/* ----------------------------------------------------------------------------

Generated by ma_php_db_export.php
2025-12-05 22:40:11
Martin Seydler
www.maetes.com
	
Use it like this:
-------------------
#include "dbstars_hygl_421_pov_mag_all.inc"
#for (mI, 0, dimension_size(HYGL_421,1) - 1)
	// do some nice stuff
	sphere { <0,0,0> HYGL_421[mI][Indexes-see-below] }
#end

---------------------------------------------------------------------------- */

#declare hy_id  =  0;  //HYGL-ID
#declare hy_hip =  1;  //Hipparcos-ID
#declare hy_hd  =  2;  //HD-ID
#declare hy_hr  =  3;  //HR-ID
#declare hy_gl  =  4;  //Gliese designation
#declare hy_bf  =  5;  //Bayer-Flamsteed
#declare hy_bay =  6;  //Bayer
#declare hy_fla =  7;  //Flamsteed
#declare hy_byg =  8;  //Bayer Greek abbreviation
#declare hy_bys =  9;  //Bayer Superscript
#declare hy_con = 10;  //Constellation
#declare hy_naa = 11;  //Name ascii
#declare hy_dil = 12;  //Distance Lightyears
#declare hy_mag = 13;  //Magnitude visible from Earth
#declare hy_maa = 14;  //Magnitude absolute
#declare hy_rad = 15;  //Right Ascension (degree 0 to 360)
#declare hy_ded = 16;  //Declination (degree -90 to +90)
#declare hy_sp  = 17;  //Spectrum
#declare hy_sps = 18;  //Spectrum - first UC-Letter
#declare hy_cpn = 19;  //Companion number
#declare hy_cpp = 20;  //Companion primary HYGL-ID
#declare hy_bgl = 21;  //Base Starsystem Gliese designation


#declare HYGL_421 = array[119626][22] {
{ "0","","","","","","","","","","","Sol","0.000","-26.700","4.850","0.000000","0.000000","G2V","G","1","","" }
{ "32263","32349","48915","2491","Gl 244A","9Alp CMa","Alp","9","Alp","","CMa","Sirius","8.601","-1.440","1.454","101.287214","-16.716116","A0m...","A","1","","Gl 244" }
{ "30365","30438","45348","2326","","Alp Car","Alp","","Alp","","Car","Canopus","309.153","-0.620","-5.504","95.987926","-52.695660","F0Ib","F","1","","" }
{ "69451","69673","124897","5340","Gl 541","16Alp Boo","Alp","16","Alp","","Boo","Arcturus","36.717","-0.050","-0.307","213.915456","19.182410","K2IIIp","K","1","","" }
{ "71456","71683","128620","5459","Gl 559A","Alp1Cen","Alp-1","","Alp","1","Cen","Rigil Kentaurus","4.321","-0.010","4.379","219.911470","-60.833976","G2V","G","1","","Gl 559" }
{ "90979","91262","172167","7001","Gl 721","3Alp Lyr","Alp","3","Alp","","Lyr","Vega","25.045","0.030","0.604","279.234597","38.783692","A0Vvar","A","1","","" }
{ "24549","24608","34029","1708","Gl 194A","13Alp Aur","Alp","13","Alp","","Aur","Capella","42.803","0.080","-0.510","79.172249","45.997991","M1: comp","M","1","","Gl 194" }
{ "24378","24436","34085","1713","","19Bet Ori","Bet","19","Bet","","Ori","Rigel","862.848","0.180","-6.933","78.634468","-8.201640","B8Ia","B","1","","" }
{ "37173","37279","61421","2943","Gl 280A","10Alp CMi","Alp","10","Alp","","CMi","Procyon","11.462","0.400","2.671","114.825500","5.224993","F5IV-V","F","1","","Gl 280" }
{ "27919","27989","39801","2061","","58Alp Ori","Alp","58","Alp","","Ori","Betelgeuse","497.949","0.450","-5.469","88.792938","7.407063","M2Ib","M","1","","" }
{ "7574","7588","10144","472","","Alp Eri","Alp","","Alp","","Eri","Achernar","139.443","0.450","-2.705","24.428346","-57.236757","B3Vp","B","1","","" }
{ "68483","68702","122451","5267","","Bet Cen","Bet","","Bet","","Cen","Hadar","392.015","0.610","-4.789","210.955936","-60.373039","B1III","B","1","","" }
{ "97338","97649","187642","7557","Gl 768","53Alp Aql","Alp","53","Alp","","Aql","Altair","16.730","0.760","2.210","297.695813","8.868322","A7IV-V","A","1","","" }
{ "60530","60718","108248","4730","","Alp1Cru","Alp-1","","Alp","1","Cru","Acrux","321.971","0.770","-4.202","186.649670","-63.099092","B0.5IV","B","1","","" }
{ "21368","21421","29139","1457","Gl 171.1A","87Alp Tau","Alp","87","Alp","","Tau","Aldebaran","66.644","0.870","-0.682","68.980154","16.509301","K5III","K","1","","Gl 171.1" }
{ "118360","","","","Gl 194B","","","","","","Aur","","42.199","0.960","0.401","79.168889","46.000842","G0 III","G","2","24549","Gl 194" }
{ "65269","65474","116658","5056","","67Alp Vir","Alp","67","Alp","","Vir","Spica","249.737","0.980","-3.440","201.298249","-11.161322","B1V","B","1","","" }
{ "80519","80763","148478","6134","","21Alp Sco","Alp","21","Alp","","Sco","Antares","553.746","1.060","-5.089","247.351923","-26.432002","M1Ib + B2.5V","M","1","","" }
{ "37718","37826","62509","2990","Gl 286","78Bet Gem","Bet","78","Bet","","Gem","Pollux","33.785","1.160","1.084","116.329162","28.026199","K0IIIvar","K","1","","" }
{ "113008","113368","216956","8728","Gl 881","24Alp PsA","Alp","24","Alp","","PsA","Fomalhaut","25.126","1.170","1.737","344.412573","-29.622236","A3V","A","1","","" }
{ "101767","102098","197345","7924","","50Alp Cyg","Alp","50","Alp","","Cyg","Deneb","1411.932","1.250","-6.932","310.357976","45.280338","A2Ia","A","1","","" }
{ "62239","62434","111123","4853","","Bet Cru","Bet","","Bet","","Cru","Mimosa","278.528","1.250","-3.407","191.930378","-59.688764","B0.5III","B","1","","" }
{ "71453","71681","128621","5460","Gl 559B","Alp2Cen","Alp-2","","Alp","2","Cen","Toliman","4.321","1.350","5.739","219.905188","-60.838300","K1V","K","2","71456","Gl 559" }
{ "49528","49669","87901","3982","","32Alp Leo","Alp","32","Alp","","Leo","Regulus","79.299","1.360","-0.569","152.092974","11.967207","B7V","B","1","","" }
{ "33492","33579","52089","2618","","21Eps CMa","Eps","21","Eps","","CMa","Adhara","405.163","1.500","-3.971","104.656451","-28.972084","B2II","B","1","","" }
{ "36744","36850","60179","2891","Gl 278A","66Alp Gem","Alp","66","Alp","","Gem","Castor","50.867","1.580","0.615","113.649517","31.888276","A2Vm","A","1","","Gl 278" }
{ "60893","61084","108903","4763","","Gam Cru","Gam","","Gam","","Cru","Gacrux","88.557","1.590","-0.579","187.791440","-57.113212","M4III","M","1","","" }
{ "85665","85927","158926","6527","","35Lam Sco","Lam","35","Lam","","Sco","Shaula","571.202","1.620","-4.597","263.402172","-37.103821","B1.5IV+...","B","1","","" }
{ "25273","25336","35468","1790","","24Gam Ori","Gam","24","Gam","","Ori","Bellatrix","252.443","1.640","-2.804","81.282763","6.349702","B2III","B","1","","" }
{ "25364","25428","35497","1791","","112Bet Tau","Bet","112","Bet","","Tau","Elnath","133.890","1.650","-1.417","81.572964","28.607450","B7III","B","1","","" }
{ "45106","45238","80007","3685","","Bet Car","Bet","","Bet","","Car","Miaplacidus","113.170","1.670","-1.032","138.300620","-69.717208","A2IV","A","1","","" }
{ "26246","26311","37128","1903","","46Eps Ori","Eps","46","Eps","","Ori","Alnilam","1976.705","1.690","-7.223","84.053389","-1.201920","B0Ia","B","1","","" }
{ "108922","109268","209952","8425","Gl 848.2","Alp Gru","Alp","","Alp","","Gru","Alnair","101.008","1.730","-0.725","332.058128","-46.960975","B7IV","B","1","","" }
{ "26662","26727","37742","1948","","50Zet Ori","Zet","50","Zet","","Ori","Alnitak","736.245","1.740","-5.028","85.189696","-1.942572","O9.5Ib SB","O","1","","" }
{ "39840","39953","68273","3207","","Gam2Vel","Gam-2","","Gam","2","Vel","","1116.974","1.750","-5.923","122.383133","-47.336588","WC8 + O9I","W","1","","" }
{ "62757","62956","112185","4905","","77Eps UMa","Eps","77","Eps","","UMa","Alioth","82.550","1.760","-0.256","193.507075","55.959821","A0p","A","1","","" }
{ "15824","15863","20902","1017","","33Alp Per","Alp","33","Alp","","Per","Mirfak","506.454","1.790","-4.166","51.080677","49.861180","F5Ib","F","1","","" }
{ "89906","90185","169022","6879","","20Eps Sgr","Eps","20","Eps","","Sgr","Kaus Australis","143.302","1.790","-1.424","276.043013","-34.384616","B9.5III","B","1","","" }
{ "53905","54061","95689","4301","","50Alp UMa","Alp","50","Alp","","UMa","Dubhe","122.892","1.810","-1.070","165.932322","61.751033","F7V comp","F","1","","" }
{ "34354","34444","54605","2693","","25Del CMa","Del","25","Del","","CMa","Wezen","1606.682","1.830","-6.633","107.097852","-26.393200","F8Ia","F","1","","" }
{ "67088","67301","120315","5191","","85Eta UMa","Eta","85","Eta","","UMa","Alkaid","103.938","1.850","-0.667","206.885314","49.313265","B3V SB","B","1","","" }
{ "40921","41037","71129","3307","","Eps Car","Eps","","Eps","","Car","Avior","605.114","1.860","-4.482","125.628541","-59.509483","K3III+B2V","K","1","","" }
{ "85965","86228","159532","6553","","The Sco","The","","The","","Sco","Sargas","300.328","1.860","-2.961","264.329705","-42.997824","F1II","F","1","","" }
{ "28288","28360","40183","2088","GJ 3375","34Bet Aur","Bet","34","Bet","","Aur","Menkalinan","81.113","1.900","-0.078","89.882235","44.947433","A2V","A","1","","" }
{ "82022","82273","150798","6217","","Alp TrA","Alp","","Alp","","TrA","Atria","390.607","1.910","-3.482","252.166150","-69.027715","K2IIb-IIIa","K","1","","" }
{ "31601","31681","47105","2421","","24Gam Gem","Gam","24","Gam","","Gem","Alhena","109.302","1.930","-0.696","99.427921","16.399252","A0IV","A","1","","" }
{ "42794","42913","74956","3485","Gl 321.3A","Del Vel","Del","","Del","","Vel","Alsephina","80.552","1.930","-0.033","131.175892","-54.708821","A1V","A","1","","Gl 321.3" }
{ "100425","100751","193924","7790","","Alp Pav","Alp","","Alp","","Pav","Peacock","178.814","1.940","-1.755","306.411892","-56.735090","B2IV","B","1","","" }
{ "11734","11767","8890","424","","1Alp UMi","Alp","1","Alp","","UMi","Polaris","432.568","1.970","-3.643","37.946254","89.264109","F7:Ib-IIv SB","F","1","","" }
{ "30251","30324","44743","2294","","2Bet CMa","Bet","2","Bet","","CMa","Mirzam","492.683","1.980","-3.916","95.674939","-17.955918","B1II/III","B","1","","" }
{ "46259","46390","81797","3748","","30Alp Hya","Alp","30","Alp","","Hya","Alphard","180.297","1.990","-1.723","141.896847","-8.658603","K3III","K","1","","" }
{ "50440","50583","89484","4057","","41Gam1Leo","Gam-1","41","Gam","1","Leo","Algieba","130.098","2.010","-0.994","154.993096","19.841489","K0III","K","1","","" }
{ "9861","9884","12929","617","Gl 84.3","13Alp Ari","Alp","13","Alp","","Ari","Hamal","65.811","2.010","0.486","31.793321","23.462423","K2III","K","1","","" }
{ "3413","3419","4128","188","Gl 31","16Bet Cet","Bet","16","Bet","","Cet","Diphda","96.325","2.040","-0.312","10.897350","-17.986605","K0III","K","1","","" }
{ "92564","92855","175191","7121","","34Sig Sgr","Sig","34","Sig","","Sgr","Nunki","227.763","2.050","-2.170","283.816353","-26.296722","B2.5V","B","1","","" }
{ "68714","68933","123139","5288","Gl 539","5The Cen","The","5","The","","Cen","Menkent","58.820","2.060","0.780","211.670924","-36.369954","K0IIIb","K","1","","" }
{ "72380","72607","131873","5563","","7Bet UMi","Bet","7","Bet","","UMi","Kochab","130.934","2.070","-0.948","222.676569","74.155505","K4IIIvar","K","1","","" }
{ "111768","112122","214952","8636","","Bet Gru","Bet","","Bet","","Gru","Tiaki","176.970","2.070","-1.602","340.666725","-46.884577","M5III","M","1","","" }
{ "676","677","358","15","","21Alp And","Alp","21","Alp","","And","Alpheratz","97.013","2.070","-0.297","2.096863","29.090432","B9p","B","1","","" }
{ "5436","5447","6860","337","Gl 53.3","43Bet And","Bet","43","Bet","","And","Mirach","197.431","2.070","-1.840","17.432917","35.620558","M0IIIvar","M","1","","" }
{ "27298","27366","38771","2004","","53Kap Ori","Kap","53","Kap","","Ori","Saiph","647.136","2.070","-4.418","86.939120","-9.669605","B0.5Iavar","B","1","","" }
{ "85769","86032","159561","6556","Gl 681","55Alp Oph","Alp","55","Alp","","Oph","Rasalhague","48.586","2.080","1.215","263.733620","12.560035","A5III","A","1","","" }
{ "14540","14576","19356","936","","26Bet Per","Bet","26","Bet","","Per","Algol","89.925","2.090","-0.112","47.042213","40.955648","B8V","B","1","","" }
{ "9618","9640","12533","603","","57Gam1And","Gam-1","57","Gam","1","And","Almach","392.959","2.100","-3.305","30.974767","42.329725","B8V","B","1","","" }
{ "57459","57632","102647","4534","Gl 448","94Bet Leo","Bet","94","Bet","","Leo","Denebola","35.877","2.140","1.933","177.264947","14.572060","A3Vvar","A","1","","" }
{ "4417","4427","5394","264","","27Gam Cas","Gam","27","Gam","","Cas","Cih","549.085","2.150","-3.981","14.177150","60.716740","B0IV:evar","B","1","","" }
{ "61739","61932","110304","4819","","Gam Cen","Gam","","Gam","","Cen","","130.150","2.200","-0.805","190.379565","-48.959888","A1IV","A","1","","" }
{ "39318","39429","66811","3165","","Zet Pup","Zet","","Zet","","Pup","Naos","1083.576","2.210","-5.397","120.896050","-40.003148","O5IAf","O","1","","" }
{ "45425","45556","80404","3699","","Iot Car","Iot","","Iot","","Car","Aspidiske","765.625","2.210","-4.643","139.272572","-59.275229","A8Ib","A","1","","" }
{ "76035","76267","139006","5793","","5Alp CrB","Alp","5","Alp","","CrB","Alphecca","75.048","2.220","0.410","233.671915","26.714693","A0V","A","1","","" }
{ "65173","65378","116656","5054","GJ 3783A","79Zet UMa","Zet","79","Zet","","UMa","Mizar","85.808","2.230","0.129","200.981210","54.925362","A2V","A","1","","GJ 3783" }
{ "100128","100453","194093","7796","","37Gam Cyg","Gam","37","Gam","","Cyg","Sadr","1832.339","2.230","-6.518","305.557089","40.256679","F8Ib","F","1","","" }
{ "44689","44816","78647","3634","","Lam Vel","Lam","","Lam","","Vel","Suhail","544.501","2.230","-3.883","136.999015","-43.432589","K4Ib-II","K","1","","" }
{ "3172","3179","3712","168","","18Alp Cas","Alp","18","Alp","","Cas","Schedar","228.241","2.240","-1.985","10.126736","56.537331","K0II-IIIvar","K","1","","" }
{ "87561","87833","164058","6705","","33Gam Dra","Gam","33","Gam","","Dra","Eltanin","154.284","2.240","-1.134","269.151553","51.488895","K5III","K","1","","" }
{ "25865","25930","36486","1852","","34Del Ori","Del","34","Del","","Ori","Mintaka","692.476","2.250","-4.385","83.001669","-0.299092","O9.5II","O","1","","" }
{ "744","746","432","21","Gl 8","11Bet Cas","Bet","11","Bet","","Cas","Caph","54.743","2.280","1.155","2.293312","59.149780","F2III-IV","F","1","","" }
{ "66447","66657","118716","5132","","Eps Cen","Eps","","Eps","","Cen","","427.466","2.290","-3.297","204.971934","-53.466394","B1III","B","1","","" }
{ "78165","78401","143275","5953","","7Del Sco","Del","7","Del","","Sco","Dschubba","491.199","2.290","-3.599","240.083361","-22.621710","B0.2IV","B","1","","" }
{ "82144","82396","151680","6241","","26Eps Sco","Eps","26","Eps","","Sco","Larawag","63.715","2.290","0.836","252.541200","-34.293232","K2IIIb","K","1","","" }
{ "71634","71860","129056","5469","","Alp Lup","Alp","","Alp","","Lup","Uridim","464.610","2.300","-3.468","220.482339","-47.388200","B1.5III","B","1","","" }
{ "71125","71352","127972","5440","","Eta Cen","Eta","","Eta","","Cen","","305.676","2.330","-2.529","218.876795","-42.157824","B1Vn + A","B","1","","" }
{ "53754","53910","95418","4295","GJ 9343","48Bet UMa","Bet","48","Bet","","UMa","Merak","79.745","2.340","0.399","165.460160","56.382427","A1V","A","1","","" }
{ "71879","72105","129988","5505","","36Eps Boo","Eps","36","Eps","","Boo","Izar","202.582","2.350","-1.616","221.246755","27.074222","A0","A","1","","" }
{ "106972","107315","206778","8308","","8Eps Peg","Eps","8","Eps","","Peg","Enif","689.548","2.380","-4.246","326.046491","9.875011","K2Ibvar","K","1","","" }
{ "86403","86670","160578","6580","","Kap Sco","Kap","","Kap","","Sco","","483.194","2.390","-3.463","265.621983","-39.029983","B1.5III","B","1","","" }
{ "2076","2081","2261","99","","Alp Phe","Alp","","Alp","","Phe","Ankaa","84.716","2.400","0.327","6.570846","-42.305981","K0III...","K","1","","" }
{ "57828","58001","103287","4554","","64Gam UMa","Gam","64","Gam","","UMa","Phecda","83.182","2.410","0.377","178.457517","53.694760","A0V SB","A","1","","" }
{ "83755","84012","155125","6378","Gl 656.1A","35Eta Oph","Eta","35","Eta","","Oph","Sabik","88.365","2.430","0.266","257.594526","-15.724910","A2.5Va","A","1","","Gl 656.1" }
{ "113521","113881","217906","8775","","53Bet Peg","Bet","53","Bet","","Peg","Scheat","196.008","2.440","-1.454","345.943512","28.082789","M2II-IIIvar","M","1","","" }
{ "104861","105199","203280","8162","Gl 826","5Alp Cep","Alp","5","Alp","","Cep","Alderamin","49.046","2.450","1.564","319.644454","62.585573","A7IV-V","A","1","","" }
{ "35806","35904","58350","2827","","31Eta CMa","Eta","31","Eta","","CMa","Aludra","1988.758","2.450","-6.476","111.023762","-29.303104","B5Ia","B","1","","" }
{ "45809","45941","81188","3734","","Kap Vel","Kap","","Kap","","Vel","Markeb","572.204","2.470","-3.751","140.528429","-55.010668","B2IV","B","1","","" }
{ "102157","102488","197989","7949","Gl 806.1A","53Eps Cyg","Eps","53","Eps","","Cyg","Aljanah","72.705","2.480","0.739","311.552666","33.970256","K0III","K","1","","Gl 806.1" }
{ "113603","113963","218045","8781","","54Alp Peg","Alp","54","Alp","","Peg","Markab","133.343","2.490","-0.568","346.190218","15.205264","B9.5III","B","1","","" }
{ "81130","81377","149757","6175","","13Zet Oph","Zet","13","Zet","","Oph","","366.056","2.540","-2.711","249.289740","-10.567090","O9.5V","O","1","","" }
{ "14100","14135","18884","911","","92Alp Cet","Alp","92","Alp","","Cet","Menkar","249.165","2.540","-1.875","45.569884","4.089734","M2III","M","1","","" }
{ "67786","68002","121263","5231","","Zet Cen","Zet","","Zet","","Cen","Leepwal","381.916","2.550","-2.793","208.885006","-47.288375","B2.5IV","B","1","","" }
{ "78580","78820","144217","5984","","8Bet1Sco","Bet-1","8","Bet","1","Sco","Acrab","404.159","2.560","-2.906","241.359295","-19.805453","B0.5V","B","1","","" }
{ "54712","54872","97603","4357","Gl 419","68Del Leo","Del","68","Del","","Leo","Zosma","58.430","2.560","1.294","168.527065","20.523717","A4V","A","1","","" }
{ "59016","59196","105435","4621","","Del Cen","Del","","Del","","Cen","","414.957","2.580","-2.943","182.089649","-50.722425","B2IVne","B","1","","" }
{ "59621","59803","106625","4662","","4Gam Crv","Gam","4","Gam","","Crv","Gienah","153.630","2.580","-0.785","183.951561","-17.541929","B8III","B","1","","" }
{ "25920","25985","36673","1865","","11Alp Lep","Alp","11","Alp","","Lep","Arneb","2218.751","2.580","-6.583","83.182566","-17.822289","F0Ib","F","1","","" }
{ "93213","93506","176687","7194","","38Zet Sgr","Zet","38","Zet","","Sgr","Ascella","88.198","2.600","0.440","285.652980","-29.880105","A3IV","A","1","","" }
{ "74556","74785","135742","5685","","27Bet Lib","Bet","27","Bet","","Lib","Zubeneschamali","185.106","2.610","-1.160","229.251731","-9.382917","B8V","B","1","","" }
{ "76835","77070","140573","5854","Gl 596.2","24Alp Ser","Alp","24","Alp","","Ser","Unukalhai","73.958","2.630","0.852","236.066976","6.425627","K2III","K","1","","" }
{ "8884","8903","11636","553","Gl 80","6Bet Ari","Bet","6","Bet","","Ari","Sheratan","58.661","2.640","1.365","28.660022","20.808035","A5V...","A","1","","" }
{ "26569","26634","37795","1956","","Alp Col","Alp","","Alp","","Col","Phact","261.343","2.650","-1.869","84.912249","-34.074108","B7IV","B","1","","" }
{ "61166","61359","109379","4786","","9Bet Crv","Bet","9","Bet","","Crv","Kraz","145.671","2.650","-0.600","188.596810","-23.396759","G5II","G","1","","" }
{ "28309","28380","40312","2095","","37The Aur","The","37","The","","Aur","Mahasim","165.562","2.650","-0.878","89.930261","37.212585","A0p Si","A","1","","" }
{ "6672","6686","8538","403","","37Del Cas","Del","37","Del","","Cas","Ruchbah","99.408","2.660","0.240","21.453235","60.235283","A5Vv SB","A","1","","" }
{ "67711","67927","121370","5235","Gl 534","8Eta Boo","Eta","8","Eta","","Boo","Muphrid","37.169","2.680","2.396","208.671169","18.397717","G0IV","G","1","","" }
{ "73046","73273","132058","5571","","Bet Lup","Bet","","Bet","","Lup","","382.813","2.680","-2.668","224.633059","-43.133960","B2III","B","1","","" }
{ "61392","61585","109668","4798","","Alp Mus","Alp","","Alp","","Mus","","315.432","2.690","-2.237","189.296085","-69.135564","B2IV-V","B","1","","" }
{ "22961","23015","31398","1577","","3Iot Aur","Iot","3","Iot","","Aur","Hassaleh","493.429","2.690","-3.209","74.248410","33.166090","K3IIvar","K","1","","" }
{ "52575","52727","93497","4216","","Mu  Vel","Mu","","Mu","","Vel","","117.154","2.690","-0.087","161.692327","-49.420255","G5III SB","G","1","","" }
{ "85436","85696","158408","6508","","34Ups Sco","Ups","34","Ups","","Sco","Lesath","576.248","2.700","-3.536","262.690984","-37.295811","B2IV","B","1","","" }
{ "35169","35264","56855","2773","","Pi  Pup","Pi","","Pi","","Pup","","807.318","2.710","-4.258","109.285658","-37.097470","K3Ib","K","1","","" }
{ "89653","89931","168454","6859","","19Del Sgr","Del","19","Del","","Sgr","Kaus Media","347.715","2.720","-2.419","275.248496","-29.828103","K3III","K","1","","" }
{ "96970","97278","186791","7525","","50Gam Aql","Gam","50","Gam","","Aql","Tarazed","394.863","2.720","-2.695","296.564913","10.613261","K3II","K","1","","" }
{ "79352","79593","146051","6056","","1Del Oph","Del","1","Del","","Oph","Yed Prior","171.121","2.730","-0.869","243.586414","-3.694323","M1III","M","1","","" }
{ "80089","80331","148387","6132","Gl 624.1A","14Eta Dra","Eta","14","Eta","","Dra","Athebyne","92.082","2.730","0.476","245.997904","61.514213","G8III","G","1","","Gl 624.1" }
{ "61748","61941","110379","4825","Gl 482A","29Gam Vir","Gam","29","Gam","","Vir","Porrima","38.111","2.740","2.402","190.415176","-1.449375","F0V+...","F","1","","Gl 482" }
{ "52268","52419","93030","4199","","The Car","The","","The","","Car","","455.526","2.740","-2.985","160.739232","-64.394450","B0Vp","B","1","","" }
{ "26176","26241","37043","1899","","44Iot Ori","Iot","44","Iot","","Ori","Hatysa","2329.688","2.750","-6.519","83.858260","-5.909901","O9III","O","1","","" }
{ "64904","65109","115892","5028","Gl 508.1","Iot Cen","Iot","","Iot","","Cen","Kulou","58.778","2.750","1.471","200.149445","-36.712295","A2V","A","1","","" }
{ "72396","72622","130841","5531","Gl 564.1","9Alp2Lib","Alp-2","9","Alp","2","Lib","Zubenelgenubi","75.797","2.750","0.919","222.719648","-16.041778","A3IV","A","1","","" }
{ "86475","86742","161096","6603","","60Bet Oph","Bet","60","Bet","","Oph","Cebalrai","81.846","2.760","0.762","265.868138","4.567303","K2III","K","1","","" }
{ "84086","84345","156014","6406","","64Alp1Her","Alp-1","64","Alp","1","Her","Rasalgethi","359.599","2.780","-2.432","258.661910","14.390333","M5IIvar","M","1","","" }
{ "80571","80816","148856","6148","","27Bet Her","Bet","27","Bet","","Her","Kornephoros","139.145","2.780","-0.370","247.555017","21.489613","G8III","G","1","","" }
{ "23820","23875","33111","1666","GJ 9175","67Bet Eri","Bet","67","Bet","","Eri","Cursa","89.358","2.780","0.591","76.962439","-5.086446","A3IIIvar","A","1","","" }
{ "85410","85670","159181","6536","","23Bet Dra","Bet","23","Bet","","Dra","Rastaban","380.136","2.790","-2.543","262.608199","52.301387","G2II","G","1","","" }
{ "59565","59747","106490","4656","","Del Cru","Del","","Del","","Cru","Imai","345.139","2.790","-2.333","183.786398","-58.748928","B2IV","B","1","","" }
{ "76065","76297","138690","5776","","Gam Lup","Gam","","Gam","","Lup","","420.847","2.800","-2.753","233.785212","-41.166757","B2IV","B","1","","" }
{ "81444","81693","150680","6212","Gl 635A","40Zet Her","Zet","40","Zet","","Her","","34.950","2.810","2.660","250.321697","31.602726","F9IV","F","1","","Gl 635" }
{ "25542","25606","36079","1829","","9Bet Lep","Bet","9","Bet","","Lep","Nihal","160.352","2.810","-0.648","82.061347","-20.759441","G5II","G","1","","" }
{ "2016","2021","2151","98","Gl 19","Bet Hyi","Bet","","Bet","","Hyi","","24.327","2.820","3.457","6.418738","-77.254247","G2IV","G","1","","" }
{ "81020","81266","149438","6165","","23Tau Sco","Tau","23","Tau","","Sco","Paikauhale","474.064","2.820","-2.992","248.970643","-28.216016","B0V","B","1","","" }
{ "90217","90496","169916","6913","Gl 713.1","22Lam Sgr","Lam","22","Lam","","Sgr","Kaus Borealis","78.177","2.820","0.922","276.992680","-25.421700","K1IIIb","K","1","","" }
{ "1065","1067","886","39","","88Gam Peg","Gam","88","Gam","","Peg","Algenib","391.544","2.830","-2.567","3.308970","15.183596","B2IV","B","1","","" }
{ "39644","39757","67523","3185","","15Rho Pup","Rho","15","Rho","","Pup","Tureis","63.541","2.830","1.382","121.886056","-24.304324","F2mF5IIp","F","1","","" }
{ "77716","77952","141891","5897","Gl 601A","Bet TrA","Bet","","Bet","","TrA","","40.371","2.830","2.367","238.786242","-63.430727","F2III","F","1","","Gl 601" }
{ "18201","18246","24398","1203","","44Zet Per","Zet","44","Zet","","Per","","751.512","2.840","-3.973","58.533004","31.883635","B1Ib","B","1","","" }
{ "84999","85258","157244","6461","","Bet Ara","Bet","","Bet","","Ara","","645.854","2.840","-3.644","261.324968","-55.529884","K3Ib-II","K","1","","" }
{ "85530","85792","158427","6510","","Alp Ara","Alp","","Alp","","Ara","","267.341","2.840","-1.728","262.960430","-49.876145","B2Vne","B","1","","" }
{ "107213","107556","207098","8322","Gl 837","49Del Cap","Del","49","Del","","Cap","Deneb Algedi","38.704","2.850","2.478","326.760161","-16.127286","A5mF2 (IV)","A","1","","" }
{ "17661","17702","23630","1165","","25Eta Tau","Eta","25","Eta","","Tau","Alcyone","403.160","2.850","-2.610","56.871148","24.105137","B7III","B","1","","" }
{ "63405","63608","113226","4932","","47Eps Vir","Eps","47","Eps","","Vir","Vindemiatrix","109.596","2.850","0.218","195.544167","10.959150","G8IIIvar","G","1","","" }
{ "118485","","60178","2890","Gl 278B","66Alp Gem","Alp","66","Alp","","Gem","Castor B","51.550","2.850","1.856","113.652408","31.890520","A m","A","2","36744","Gl 278" }
{ "96858","97165","186882","7528","","18Del Cyg","Del","18","Del","","Cyg","Fawaris","164.975","2.860","-0.660","296.243613","45.130810","B9.5III","B","1","","" }
{ "9217","9236","12311","591","Gl 83","Alp Hyi","Alp","","Alp","","Hyi","","71.793","2.860","1.147","29.691771","-61.569859","F0V","F","1","","" }
{ "74717","74946","135382","5671","","Gam TrA","Gam","","Gam","","TrA","","183.854","2.870","-0.885","229.727708","-68.679545","A1V","A","1","","" }
{ "109784","110130","211416","8502","","Alp Tuc","Alp","","Alp","","Tuc","Lang-Exster","199.728","2.870","-1.065","334.625568","-60.259587","K3III","K","1","","" }
{ "30270","30343","44478","2286","","13Mu  Gem","Mu","13","Mu","","Gem","Tejat","231.645","2.870","-1.387","95.740101","22.513586","M3IIIvar","M","1","","" }
{ "93846","94141","178524","7264","","41Pi  Sgr","Pi","41","Pi","","Sgr","Albaldah","509.619","2.880","-3.089","287.440971","-21.023615","F2II/III","F","1","","" }
{ "13813","13847","18622","897","","The1Eri","The-1","","The","1","Eri","Acamar","161.224","2.880","-0.590","44.565352","-40.304672","A4III+...","A","1","","" }
{ "62925","63125","112413","4915","","12Alp2CVn","Alp-2","12","Alp","2","CVn","Cor Caroli","114.803","2.890","0.157","194.007103","38.318380","A0spe...","A","1","","" }
{ "78029","78265","143018","5944","","6Pi  Sco","Pi","6","Pi","","Sco","Fang","585.559","2.890","-3.381","239.712973","-26.114105","B1V + B2V","B","1","","" }
{ "36087","36188","58715","2845","","3Bet CMi","Bet","3","Bet","","CMi","Gomeisa","161.704","2.890","-0.586","111.787679","8.289315","B8Vvar","B","1","","" }
{ "79870","80112","147165","6084","","20Sig Sco","Sig","20","Sig","","Sco","Alniyat","696.915","2.900","-3.749","245.297152","-25.592796","B1III","B","1","","" }
{ "105936","106278","204867","8232","","22Bet Aqr","Bet","22","Bet","","Aqr","Sadalsuud","537.325","2.900","-3.184","322.889724","-5.571172","G0Ib","G","1","","" }
{ "18485","18532","24760","1220","","45Eps Per","Eps","45","Eps","","Per","","638.271","2.900","-3.558","59.463452","40.010215","B0.5V","B","1","","" }
{ "14292","14328","18925","915","","23Gam Per","Gam","23","Gam","","Per","","243.219","2.910","-1.453","46.199127","53.506440","G8III+...","G","1","","" }
{ "47866","48002","85123","3890","","Ups Car","Ups","","Ups","","Car","","1436.812","2.920","-5.300","146.775545","-65.072007","A9","A","1","","" }
{ "111804","112158","215182","8650","","44Eta Peg","Eta","44","Eta","","Peg","Matar","214.295","2.930","-1.158","340.750567","30.221245","G2II-III..","G","1","","" }
{ "60776","60965","108767","4757","","7Del Crv","Del","7","Del","","Crv","Algorab","86.859","2.940","0.813","187.466086","-16.515432","B9.5V","B","1","","" }
{ "32682","32768","50310","2553","","Tau Pup","Tau","","Tau","","Pup","","182.007","2.940","-0.793","102.483987","-50.614560","K0III...","K","1","","" }
{ "108728","109074","209750","8414","","34Alp Aqr","Alp","34","Alp","","Aqr","Sadalmelik","523.525","2.950","-3.078","331.445982","-0.319851","G2Ib","G","1","","" }
{ "47772","47908","84441","3873","","17Eps Leo","Eps","17","Eps","","Leo","Ras Elased Australis","246.714","2.970","-1.424","146.462814","23.774255","G0II","G","1","","" }
{ "18497","18543","25025","1231","","34Gam Eri","Gam","34","Gam","","Eri","Zaurak","203.339","2.970","-1.004","59.507356","-13.508515","M1IIIb Ca-1","M","1","","" }
{ "26386","26451","37202","1910","","123Zet Tau","Zet","123","Zet","","Tau","Tianguan","444.961","2.970","-2.704","84.411190","21.142549","B4IIIp","B","1","","" }
{ "88361","88635","165135","6746","","10Gam2Sgr","Gam-2","10","Gam","2","Sgr","Alnasl","96.868","2.980","0.616","271.452050","-30.424091","K0III","K","1","","" }
{ "86804","87073","161471","6615","","Iot1Sco","Iot-1","","Iot","1","Sco","","1929.919","2.990","-5.871","266.896172","-40.126997","F3Ia","F","1","","" }
{ "93452","93747","177724","7235","GJ 4095A","17Zet Aql","Zet","17","Zet","","Aql","Okab","83.034","2.990","0.961","286.352534","13.863478","A0Vn","A","1","","GJ 4095" }
{ "64758","64962","115659","5020","","46Gam Hya","Gam","46","Gam","","Hya","","133.835","2.990","-0.076","199.730388","-23.171512","G8III","G","1","","" }
{ "74868","75097","137422","5735","","13Gam UMi","Gam","13","Gam","","UMi","Pherkad","486.800","3.000","-2.870","230.182244","71.834016","A3II-III","A","1","","" }
{ "82263","82514","151890","6247","","Mu 1Sco","Mu-1","","Mu","1","Sco","Xamidimura","501.008","3.000","-2.932","252.967640","-38.047380","B1.5IV + B","B","1","","" }
{ "10041","10064","13161","622","","4Bet Tri","Bet","4","Bet","","Tri","","126.860","3.000","0.051","32.385865","34.987297","A5III","A","1","","" }
{ "54380","54539","96833","4335","","52Psi UMa","Psi","52","Psi","","UMa","","144.509","3.000","-0.232","167.415929","44.498487","K1III","K","1","","" }
{ "107742","108085","207971","8353","","Gam Gru","Gam","","Gam","","Gru","Aldhanab","211.104","3.000","-1.055","328.482125","-37.364852","B8III","B","1","","" }
{ "17316","17358","22928","1122","","39Del Per","Del","39","Del","","Per","","516.070","3.010","-2.986","55.731233","47.787551","B5III SB","B","1","","" }
{ "59134","59316","105707","4630","","2Eps Crv","Eps","2","Eps","","Crv","","317.891","3.020","-1.924","182.531184","-22.619766","K2III","K","1","","" }
{ "30049","30122","44402","2282","","1Zet CMa","Zet","1","Zet","","CMa","Furud","362.396","3.020","-2.209","95.078299","-30.063367","B2.5V","B","1","","" }
{ "33888","33977","53138","2653","","24Omi2CMa","Omi-2","24","Omi","2","CMa","","2764.037","3.020","-6.621","105.756136","-23.833291","B3Ia","B","1","","" }
{ "23361","23416","31964","1605","","7Eps Aur","Eps","7","Eps","","Aur","Almaaz","2131.741","3.030","-6.047","75.492225","43.823308","F0Ia","F","1","","" }
{ "62127","62322","110879","4844","","Bet Mus","Bet","","Bet","","Mus","","341.525","3.040","-2.060","191.570192","-68.108119","B2V","B","1","","" }
{ "70851","71075","127762","5435","","27Gam Boo","Gam","27","Gam","","Boo","Seginus","86.790","3.040","0.915","218.019543","38.308253","A7IIIvar","A","1","","" }
{ "95648","95947","183912","7417","","6Bet1Cyg","Bet-1","6","Bet","1","Cyg","Albireo","434.296","3.050","-2.572","292.680338","27.959681","K3II+...","K","1","","" }
{ "100020","100345","193495","7776","","9Bet Cap","Bet","9","Bet","","Cap","Dabih","326.810","3.050","-1.954","305.252811","-14.781367","A5:n","A","1","","" }
{ "32161","32246","48329","2473","","27Eps Gem","Eps","27","Eps","","Gem","Mebsuta","844.965","3.060","-4.007","100.983026","25.131124","A3mA6-A9","A","1","","" }
{ "50655","50801","89758","4069","","34Mu  UMa","Mu","34","Mu","","UMa","Tania Australis","230.337","3.060","-1.185","155.582318","41.499516","M0III SB","M","1","","" }
{ "94081","94376","180711","7310","","57Del Dra","Del","57","Del","","Dra","Altais","97.418","3.070","0.694","288.138375","67.661541","G9III","G","1","","" }
{ "89364","89642","167618","6832","","Eta Sgr","Eta","","Eta","","Sgr","","145.931","3.100","-0.154","274.406890","-36.761686","M2III","M","1","","" }
{ "101445","101772","196171","7869","Gl 794.1","Alp Ind","Alp","","Alp","","Ind","","98.329","3.110","0.714","309.391743","-47.291502","K0III","K","1","","" }
{ "43689","43813","76294","3547","","16Zet Hya","Zet","16","Zet","","Hya","","167.174","3.110","-0.439","133.848444","5.945563","G8III-IV","G","1","","" }
{ "52789","52943","93813","4232","","Nu  Hya","Nu","","Nu","","Hya","","143.745","3.110","-0.111","162.406192","-16.193648","K0/K1III","K","1","","" }
{ "56392","56561","100841","4467","","Lam Cen","Lam","","Lam","","Cen","","419.764","3.110","-2.438","173.945452","-63.019841","B9II:","B","1","","" }
{ "44000","44127","76644","3569","Gl 331A","9Iot UMa","Iot","9","Iot","","UMa","Talitha","47.324","3.120","2.312","134.802422","48.041826","A7IV","A","1","","Gl 331" }
{ "82826","83081","152786","6285","GJ 9581","Zet Ara","Zet","","Zet","","Ara","","486.075","3.120","-2.746","254.655083","-55.990141","K5III","K","1","","" }
{ "84121","84379","156164","6410","GJ 3995A","65Del Her","Del","65","Del","","Her","Sarin","75.134","3.120","1.308","258.757966","24.839204","A3IVv SB","A","1","","GJ 3995" }
{ "27559","27628","39425","2040","","Bet Col","Bet","","Bet","","Col","Wazn","87.184","3.120","0.985","87.739939","-35.768309","K1.5III","K","1","","" }
{ "73107","73334","132200","5576","","Kap Cen","Kap","","Kap","","Cen","","383.262","3.130","-2.220","224.790369","-42.104194","B2IV","B","1","","" }
{ "45728","45860","80493","3705","","40Alp Lyn","Alp","40","Alp","","Lyn","","203.086","3.140","-0.831","140.263870","34.392562","M0IIIvar","M","1","","" }
{ "46568","46701","82668","3803","","","","","","","Vel","","238.942","3.160","-1.164","142.805561","-57.034377","K5III","K","1","","" }
{ "84122","84380","156283","6418","","67Pi  Her","Pi","67","Pi","","Her","","376.624","3.160","-2.152","258.761826","36.809162","K3IIvar","K","1","","" }
{ "83638","83895","155763","6396","","22Zet Dra","Zet","22","Zet","","Dra","Aldhibah","328.455","3.170","-1.845","257.196720","65.714683","B6III","B","1","","" }
{ "91754","92041","173300","7039","","27Phi Sgr","Phi","27","Phi","","Sgr","","239.293","3.170","-1.158","281.414095","-26.990778","B8.5III","B","1","","" }
{ "31605","31685","47670","2451","","Nu  Pup","Nu","","Nu","","Pup","Pipit","371.476","3.170","-2.113","99.440297","-43.195934","B8III SB","B","1","","" }
{ "46720","46853","82328","3775","Gl 354A","25The UMa","The","25","The","","UMa","","43.962","3.170","2.522","143.215720","51.677300","F6IV","F","1","","Gl 354" }
{ "71682","71908","128898","5463","Gl 560A","Alp Cir","Alp","","Alp","","Cir","Xami","54.044","3.180","2.083","220.627386","-64.975138","F1Vp","F","1","","Gl 560" }
{ "23712","23767","32630","1641","","10Eta Aur","Eta","10","Eta","","Aur","Haedus","243.400","3.180","-1.184","76.628695","41.234474","B3V","B","1","","" }
{ "22396","22449","30652","1543","Gl 178","1Pi 3Ori","Pi-3","1","Pi","3","Ori","Tabit","26.316","3.190","3.656","72.460036","6.961276","F6V","F","1","","" }
{ "23630","23685","32887","1654","","2Eps Lep","Eps","2","Eps","","Lep","","213.313","3.190","-0.888","76.365264","-22.371032","K4III","K","1","","" }
{ "82745","83000","153210","6299","","27Kap Oph","Kap","27","Kap","","Oph","","91.463","3.190","0.951","254.417081","9.375033","K2IIIvar","K","1","","" }
{ "86991","87261","161892","6630","","","","","","","Sco","Fuyue","125.832","3.190","0.258","267.464482","-37.043304","K0/K1III","K","1","","" }
{ "104394","104732","202109","8115","","64Zet Cyg","Zet","64","Zet","","Cyg","","143.114","3.210","-0.001","318.234106","30.226916","G8II SB","G","1","","" }
{ "116361","116727","222404","8974","Gl 903","35Gam Cep","Gam","35","Gam","","Cep","Errai","45.996","3.210","2.464","354.837306","77.632276","K1IV","K","1","","" }
{ "74912","75141","136298","5695","","Del Lup","Del","","Del","","Lup","","883.893","3.220","-3.945","230.343022","-40.647518","B1.5IV","B","1","","" }
{ "79640","79882","146791","6075","GJ 3949","2Eps Oph","Eps","2","Eps","","Oph","Yed Posterior","106.448","3.230","0.661","244.580370","-4.692511","G8III","G","1","","" }
{ "89684","89962","168723","6869","Gl 711","58Eta Ser","Eta","58","Eta","","Ser","","60.478","3.230","1.889","275.327504","-2.898825","K0III-IV","K","1","","" }
{ "105691","106032","205021","8238","","8Bet Cep","Bet","8","Bet","","Cep","Alfirk","685.202","3.230","-3.382","322.164926","70.560716","B2IIIv SB","B","1","","" }
{ "99156","99473","191692","7710","","65The Aql","The","65","The","","Aql","Antinous","286.353","3.240","-1.477","302.826189","-0.821461","B9.5III","B","1","","" }
{ "32521","32607","50241","2550","Gl 248","Alp Pic","Alp","","Alp","","Pic","","96.553","3.240","0.883","102.047905","-61.941391","A7IV","A","1","","" }
{ "36274","36377","59717","2878","","Sig Pup","Sig","","Sig","","Pup","","193.679","3.250","-0.618","112.307681","-43.301432","K5III SB","K","1","","" }
{ "92902","93194","176437","7178","","14Gam Lyr","Gam","14","Gam","","Lyr","Sulafat","620.069","3.250","-3.145","284.735929","32.689557","B9III","B","1","","" }
{ "68675","68895","123123","5287","Gl 538.1","49Pi  Hya","Pi","49","Pi","","Hya","","100.977","3.250","0.796","211.592892","-26.682361","K2III","K","1","","" }
{ "73486","73714","133216","5603","","20Sig Lib","Sig","20","Sig","","Lib","Brachium","288.379","3.250","-1.483","226.017583","-25.281965","M3/M4III","M","1","","" }
{ "17637","17678","24512","1208","","Gam Hyi","Gam","","Gam","","Hyi","","214.013","3.260","-0.825","56.809422","-74.238962","M2III","M","1","","" }
{ "3086","3092","3627","165","","31Del And","Del","31","Del","","And","","105.518","3.270","0.720","9.831936","30.861024","K3III...","K","1","","" }
{ "84711","84970","157056","6453","","42The Oph","The","42","The","","Oph","","436.038","3.270","-2.360","260.502412","-24.999545","B2IV","B","1","","" }
{ "112776","113136","216627","8709","","76Del Aqr","Del","76","Del","","Aqr","Skat","160.589","3.270","-0.191","343.662556","-15.820820","A3V","A","1","","" }
{ "24249","24305","33904","1702","","5Mu  Lep","Mu","5","Mu","","Lep","","185.950","3.290","-0.490","78.232915","-16.205468","B9IV: HgMn","B","1","","" }
{ "49958","50099","89080","4037","","Ome Car","Ome","","Ome","","Car","","341.883","3.290","-1.812","153.434408","-70.037903","B8III","B","1","","" }
{ "75229","75458","137759","5744","","12Iot Dra","Iot","12","Iot","","Dra","Edasich","101.197","3.290","0.831","231.232413","58.966065","K2III","K","1","","" }
{ "21228","21281","29305","1465","","Alp Dor","Alp","","Alp","","Dor","","168.643","3.300","-0.268","68.498968","-55.044975","A0V:","A","1","","" }
{ "51428","51576","91465","4140","","","","","","","Car","","483.194","3.300","-2.553","158.006142","-61.685332","B4Vne","B","1","","" }
{ "29582","29655","42995","2216","","7Eta Gem","Eta","7","Eta","","Gem","Propus","384.618","3.310","-2.048","93.719417","22.506799","M3III","M","1","","" }
{ "85008","85267","157246","6462","","Gam Ara","Gam","","Gam","","Ara","","1113.162","3.310","-4.356","261.348580","-56.377727","B1Ib","B","1","","" }
{ "83885","84143","155203","6380","Gl 657","Eta Sco","Eta","","Eta","","Sco","","73.475","3.320","1.556","258.038286","-43.239189","F3p","F","1","","" }
{ "87775","88048","163917","6698","","64Nu  Oph","Nu","64","Nu","","Oph","","150.719","3.320","-0.004","269.756631","-9.773632","K0III","K","1","","" }
{ "93569","93864","177716","7234","GJ 9643","40Tau Sgr","Tau","40","Tau","","Sgr","","121.609","3.320","0.462","286.735052","-27.670423","K1/K2III","K","1","","" }
{ "59592","59774","106591","4660","Gl 459","69Del UMa","Del","69","Del","","UMa","Megrez","80.513","3.320","1.358","183.856289","57.032617","A3Vvar","A","1","","" }
{ "5154","5165","6595","322","","Bet Phe","Bet","","Bet","","Phe","","326156.378","3.320","-16.680","16.521106","-46.718414","G8IIIvar","G","1","","" }
{ "14318","14354","19058","921","","25Rho Per","Rho","25","Rho","","Per","","307.695","3.320","-1.553","46.294050","38.840274","M3IIIvar","M","1","","" }
{ "19730","19780","27256","1336","","Alp Ret","Alp","","Alp","","Ret","Rhombus","161.624","3.330","-0.145","63.606064","-62.473858","G7III","G","1","","" }
{ "54718","54879","97633","4359","","70The Leo","The","70","The","","Leo","Chertan","165.059","3.330","-0.191","168.560027","15.429570","A2V","A","1","","" }
{ "38062","38170","63700","3045","","7Xi  Pup","Xi","7","Xi","","Pup","Azmidi","1199.104","3.340","-4.487","117.323564","-24.859786","G6Ia","G","1","","" }
{ "32276","32362","48737","2484","Gl 242","31Xi  Gem","Xi","31","Xi","","Gem","Alzirr","58.704","3.350","2.074","101.322360","12.895591","F5IV","F","1","","" }
{ "41586","41704","71369","3323","","1Omi UMa","Omi","1","Omi","","UMa","Muscida","179.108","3.350","-0.348","127.566466","60.718169","G4II-III","G","1","","" }
{ "8867","8886","11415","542","","45Eps Cas","Eps","45","Eps","","Cas","Segin","411.814","3.350","-2.156","28.598759","63.670101","B2pvar","B","1","","" }
{ "25218","25281","35411","1788","","28Eta Ori","Eta","28","Eta","","Ori","","976.516","3.350","-4.031","81.119236","-2.397146","B1V + B2","B","1","","" }
{ "95207","95501","182640","7377","Gl 760","30Del Aql","Del","30","Del","","Aql","","50.637","3.360","2.405","291.374584","3.114775","F0IV","F","1","","" }
{ "75035","75264","136504","5708","","Eps Lup","Eps","","Eps","","Lup","","512.020","3.370","-2.609","230.670315","-44.689622","B2IV-V","B","1","","" }
{ "66040","66249","118098","5107","GJ 3792","79Zet Vir","Zet","79","Zet","","Vir","Heze","74.076","3.380","1.599","203.673300","-0.595820","A3V","A","1","","" }
{ "42990","43109","74874","3482","","11Eps Hya","Eps","11","Eps","","Hya","Ashlesha","129.273","3.380","0.390","131.693798","6.418809","G0III-IV","G","1","","" }
{ "50229","50371","89388","4050","","","","","","","Car","","657.573","3.390","-3.133","154.270796","-61.332304","K3II","K","1","","" }
{ "62890","63090","112300","4910","","43Del Vir","Del","43","Del","","Vir","Minelauva","198.392","3.390","-0.530","193.900868","3.397470","M3III","M","1","","" }
{ "26142","26207","36861","1879","","39Lam Ori","Lam","39","Lam","","Ori","Meissa","1098.170","3.390","-4.246","83.784488","9.934158","O...","O","1","","" }
{ "109146","109492","210745","8465","","21Zet Cep","Zet","21","Zet","","Cep","","836.299","3.390","-3.655","332.713623","58.201261","K1Ibv SB","K","1","","" }
{ "119131","","","","Gl 656.1B","","","","","","Oph","","84.126","3.400","1.342","257.591744","-15.726921","A3 V","A","2","83755","Gl 656.1" }
{ "20842","20894","28319","1412","","78The2Tau","The-2","78","The","2","Tau","Chamukuy","150.372","3.400","0.081","67.165576","15.870883","A7III","A","1","","" }
{ "6853","6867","9053","429","","Gam Phe","Gam","","Gam","","Phe","","233.636","3.410","-0.866","22.091379","-43.318234","K5II-III","K","1","","" }
{ "18677","18724","25204","1239","","35Lam Tau","Lam","35","Lam","","Tau","","483.912","3.410","-2.447","60.170066","12.490347","B3V + A","B","1","","" }
{ "102091","102422","198149","7957","Gl 807","3Eta Cep","Eta","3","Eta","","Cep","","46.527","3.410","2.639","311.322161","61.838782","K0IV","K","1","","" }
{ "67251","67464","120307","5190","","Nu  Cen","Nu","","Nu","","Cen","Heng","436.622","3.410","-2.223","207.376176","-41.687709","B2IV","B","1","","" }
{ "74167","74395","134505","5649","GJ 9512A","Zet Lup","Zet","","Zet","","Lup","","117.322","3.410","0.630","228.071403","-52.099247","G8III","G","1","","GJ 9512" }
{ "111676","112029","214923","8634","","42Zet Peg","Zet","42","Zet","","Peg","Homam","204.358","3.410","-0.575","340.365499","10.831364","B8.5V","B","1","","" }
{ "86705","86974","161797","6623","Gl 695A","86Mu  Her","Mu","86","Mu","","Her","","27.105","3.420","3.822","266.614787","27.720676","G5IV","G","1","","Gl 695" }
{ "102064","102395","197051","7913","","Bet Pav","Bet","","Bet","","Pav","","135.110","3.420","0.334","311.239712","-66.203212","A5IV","A","1","","" }
{ "8777","8796","11443","544","Gl 78.1","2Alp Tri","Alp","2","Alp","","Tri","Mothallah","63.331","3.420","1.979","28.270445","29.578829","F6IV","F","1","","" }
{ "78148","78384","143118","5948","","Eta Lup","Eta","","Eta","","Lup","","441.946","3.420","-2.240","240.030545","-38.396706","B2.5IV","B","1","","" }
{ "93510","93805","177756","7236","","16Lam Aql","Lam","16","Lam","","Aql","","123.685","3.430","0.536","286.562243","-4.882554","B9Vn","B","1","","" }
{ "44952","45080","79351","3659","","","","","","","Car","","446.790","3.430","-2.253","137.742062","-58.966896","B2IV","B","1","","" }
{ "50193","50335","89025","4031","","36Zet Leo","Zet","36","Zet","","Leo","Adhafera","274.081","3.430","-1.192","154.172566","23.417311","F0III","F","1","","" }
{ "50230","50372","89021","4033","","33Lam UMa","Lam","33","Lam","","UMa","Tania Borealis","137.503","3.450","0.326","154.274282","42.914365","A2IV","A","1","","" }
{ "38713","38827","65575","3117","","Chi Car","Chi","","Chi","","Car","","454.890","3.460","-2.262","119.194688","-52.982360","B3IVp","B","1","","" }
{ "74438","74666","135722","5681","","49Del Boo","Del","49","Del","","Boo","","121.791","3.460","0.599","228.875638","33.314833","G8III","G","1","","" }
{ "3814","3821","4614","219","Gl 34A","24Eta Cas","Eta","24","Eta","","Cas","Achird","19.416","3.460","4.586","12.273895","57.815187","G0V SB","G","1","","Gl 34" }
{ "5353","5364","6805","334","GJ 3075","31Eta Cet","Eta","31","Eta","","Cet","","123.920","3.460","0.561","17.147456","-10.182264","K2III","K","1","","" }
{ "12673","12706","16970","804","Gl 106.1A","86Gam Cet","Gam","86","Gam","","Cet","Kaffaljidhma","79.609","3.470","1.532","40.825163","3.235818","A3V","A","1","","Gl 106.1" }
{ "67259","67472","120324","5193","","Mu  Cen","Mu","","Mu","","Cen","","505.669","3.470","-2.482","207.404141","-42.473732","B2IV-Ve","B","1","","" }
{ "81583","81833","150997","6220","","44Eta Her","Eta","44","Eta","","Her","","108.646","3.480","0.867","250.723997","38.922254","G8III-IV","G","1","","" }
{ "49441","49583","87737","3975","","30Eta Leo","Eta","30","Eta","","Leo","","1269.091","3.480","-4.470","151.833134","16.762664","A0Ib","A","1","","" }
{ "33769","33856","52877","2646","","22Sig CMa","Sig","22","Sig","","CMa","Nganurganity","1120.812","3.490","-4.191","105.429784","-27.934830","K4III","K","1","","" }
{ "55055","55219","98262","4377","","54Nu  UMa","Nu","54","Nu","","UMa","Alula Borealis","399.212","3.490","-1.949","169.619749","33.094306","K3III SB","K","1","","" }
{ "73327","73555","133208","5602","","42Bet Boo","Bet","42","Bet","","Boo","Nekkar","225.246","3.490","-0.706","225.486540","40.390566","G8III","G","1","","" }
{ "90143","90422","169467","6897","","Alp Tel","Alp","","Alp","","Tel","","277.816","3.490","-1.162","276.743419","-45.968459","B3IV","B","1","","" }
{ "112263","112623","215789","8675","GJ 9796","Eps Gru","Eps","","Eps","","Gru","","128.916","3.490","0.506","342.138585","-51.316864","A3V","A","1","","" }
{ "8087","8102","10700","509","Gl 71","52Tau Cet","Tau","52","Tau","","Cet","","11.905","3.490","5.678","26.017179","-15.937480","G8V","G","1","","" }
{ "32672","32759","50013","2538","","13Kap CMa","Kap","13","Kap","","CMa","","658.902","3.500","-3.027","102.460250","-32.508478","B1.5IVne","B","1","","" }
{ "35453","35550","56986","2777","Gl 271A","55Del Gem","Del","55","Del","","Gem","Wasat","60.466","3.500","2.160","110.030743","21.982320","F0IV...","F","1","","Gl 271" }
{ "112364","112724","216228","8694","","32Iot Cep","Iot","32","Iot","","Cep","","115.290","3.500","0.758","342.420306","66.200408","K0III","K","1","","" }
{ "112389","112748","216131","8684","GJ 4298","48Mu  Peg","Mu","48","Mu","","Peg","Sadalbari","106.102","3.510","0.949","342.500768","24.601579","M2III","M","1","","" }
{ "98026","98337","189319","7635","","12Gam Sge","Gam","12","Gam","","Sge","","258.444","3.510","-0.985","299.689271","19.492148","K5III","K","1","","" }
{ "92133","92420","174638","7106","","10Bet Lyr","Bet","10","Bet","","Lyr","Sheliak","962.113","3.520","-3.829","282.519977","33.362667","A8:V comp SB","A","1","","" }
{ "92793","93085","175775","7150","","37Xi 2Sgr","Xi-2","37","Xi","2","Sgr","","365.237","3.520","-1.726","284.432500","-21.106654","G8/K0II/III","G","1","","" }
{ "109081","109427","210418","8450","GJ 9771","26The Peg","The","26","The","","Peg","Biham","92.291","3.520","1.261","332.549934","6.197865","A2V","A","1","","" }
{ "118838","","110380","4826","Gl 482B","29Gam Vir","Gam","29","Gam","","Vir","","38.585","3.520","3.155","190.412567","-1.449235","F0 V","F","2","61748","Gl 482" }
{ "17336","17378","23249","1136","Gl 150","23Del Eri","Del","23","Del","","Eri","Rana","29.487","3.520","3.739","55.812094","-9.763395","K0IV","K","1","","" }
{ "47373","47508","83808","3852","","14Omi Leo","Omi","14","Omi","","Leo","Subra","130.306","3.520","0.512","145.287642","9.892308","A5V+...","A","1","","" }
{ "48635","48774","86440","3940","","Phi Vel","Phi","","Phi","","Vel","","1591.007","3.520","-4.921","149.215613","-54.567790","B5Ib","B","1","","" }
{ "40411","40526","69267","3249","","17Bet Cnc","Bet","17","Bet","","Cnc","Tarf","303.401","3.530","-1.313","124.128837","9.185545","K4III","K","1","","" }
{ "20837","20889","28305","1409","","74Eps Tau","Eps","74","Eps","","Tau","Ain","146.653","3.530","0.266","67.154149","19.180431","K0III","K","1","","" }
{ "85998","86263","159876","6561","","55Xi  Ser","Xi","55","Xi","","Ser","","105.280","3.540","0.995","264.396676","-15.398557","F0IIIp","F","1","","" }
{ "56174","56343","100407","4450","","Xi  Hya","Xi","","Xi","","Hya","","129.633","3.540","0.544","173.250571","-31.857625","G8III","G","1","","" }
{ "77280","77516","141513","5881","","32Mu  Ser","Mu","32","Mu","","Ser","","169.608","3.540","-0.040","237.405035","-3.430208","A0V","A","1","","" }
{ "69773","69996","125238","5354","","Iot Lup","Iot","","Iot","","Lup","","337.986","3.550","-1.527","214.850938","-46.058093","B2.5IV","B","1","","" }
{ "89660","89937","170153","6927","Gl 713A","44Chi Dra","Chi","44","Chi","","Dra","","26.280","3.550","4.019","275.261036","72.732843","F7Vvar","F","1","","Gl 713" }
{ "98924","99240","190248","7665","Gl 780","Del Pav","Del","","Del","","Pav","","19.923","3.550","4.620","302.177358","-66.182068","G5IV-Vvar","G","1","","" }
{ "19992","20042","27376","1347","","41Ups4Eri","Ups-4","41","Ups","4","Eri","","177.936","3.550","-0.134","64.473562","-33.798348","B9V","B","1","","" }
{ "27220","27288","38678","1998","Gl 217.1","14Zet Lep","Zet","14","Zet","","Lep","","70.475","3.550","1.877","86.738921","-14.821950","A2Vann","A","1","","" }
{ "1559","1562","1522","74","","8Iot Cet","Iot","8","Iot","","Cet","","274.542","3.560","-1.066","4.856978","-8.823921","K2III","K","1","","" }
{ "10578","10602","14228","674","","Phi Eri","Phi","","Phi","","Eri","","153.702","3.560","0.194","34.127305","-51.512165","B8IV-V","B","1","","" }
{ "55118","55282","98430","4382","","12Del Crt","Del","12","Del","","Crt","","185.738","3.560","-0.217","169.835208","-14.778541","K0III","K","1","","" }
{ "82294","82545","151985","6252","","Mu 2Sco","Mu-2","","Mu","2","Sco","Pipirima","474.064","3.560","-2.252","253.083941","-38.017536","B2IV","B","1","","" }
{ "70828","71053","127665","5429","","25Rho Boo","Rho","25","Rho","","Boo","","160.116","3.570","0.115","217.957496","30.371437","K3III","K","1","","" }
{ "74948","75177","136422","5705","","Phi1Lup","Phi-1","","Phi","1","Lup","","275.005","3.570","-1.060","230.451595","-36.261376","K5III","K","1","","" }
{ "37633","37740","62345","2985","","77Kap Gem","Kap","77","Kap","","Gem","","141.377","3.570","0.385","116.111898","24.397993","G8III","G","1","","" }
{ "44343","44471","77327","3594","","12Kap UMa","Kap","12","Kap","","UMa","Alkaphrah","358.414","3.570","-1.635","135.906404","47.156525","A1Vn","A","1","","" }
{ "35253","35350","56537","2763","GJ 9231A","54Lam Gem","Lam","54","Lam","","Gem","","100.883","3.580","1.128","109.523249","16.540383","A3V...","A","1","","GJ 9231" }
{ "99743","100064","192947","7754","","6Alp2Cap","Alp-2","6","Alp","2","Cap","Algedi","105.826","3.580","1.024","304.513560","-12.544852","G6/G8III","G","1","","" }
{ "7593","7607","9927","464","","51    And","","51","","","And","Nembus","177.163","3.590","-0.085","24.498074","48.628213","K3III","K","1","","" }
{ "24614","24674","34503","1735","","20Tau Ori","Tau","20","Tau","","Ori","","494.176","3.590","-2.312","79.401625","-6.844409","B5III","B","1","","" }
{ "27006","27072","38393","1983","Gl 216A","13Gam Lep","Gam","13","Gam","","Lep","","29.116","3.590","3.836","86.115852","-22.448382","F7V","F","1","","Gl 216" }
{ "57584","57757","102870","4540","Gl 449","5Bet Vir","Bet","5","Bet","","Vir","Zavijava","35.646","3.590","3.397","177.673826","1.764718","F8V","F","1","","" }
{ "60075","60260","107446","4700","","Eps Cru","Eps","","Eps","","Cru","Ginan","229.850","3.590","-0.650","185.340464","-60.401147","K3/K4III","K","1","","" }
{ "76235","76470","139063","5794","","39Ups Lib","Ups","39","Ups","","Lib","","223.701","3.600","-0.581","234.256045","-28.135079","K3III","K","1","","" }
{ "85467","85727","158094","6500","","Del Ara","Del","","Del","","Ara","","197.910","3.600","-0.315","262.774773","-60.683848","B8V","B","1","","" }
{ "32932","33018","50019","2540","","34The Gem","The","34","The","","Gem","","189.076","3.600","-0.216","103.197244","33.961254","A3III","A","1","","" }
{ "42416","42536","74195","3447","","","Omi","","Omi","","Vel","","493.429","3.600","-2.299","130.073312","-52.921887","B3IV","B","1","","" }
{ "46518","46651","82434","3786","Gl 351A","Psi Vel","Psi","","Psi","","Vel","","61.365","3.600","2.228","142.675113","-40.466769","F2IV","F","1","","Gl 351" }
{ "6523","6537","8512","402","","45The Cet","The","45","The","","Cet","","113.802","3.600","0.886","21.005856","-8.183257","K0III","K","1","","" }
{ "13176","13209","17573","838","","41    Ari","","41","","","Ari","Bharani","165.646","3.610","0.081","42.495948","27.260507","B8Vn","B","1","","" }
{ "15861","15900","21120","1030","","1Omi Tau","Omi","1","Omi","","Tau","","290.951","3.610","-1.142","51.203309","9.028870","G8III","G","1","","" }
{ "86661","86929","160635","6582","","Eta Pav","Eta","","Eta","","Pav","","352.221","3.610","-1.557","266.433316","-64.723871","K1III","K","1","","" }
{ "63411","63613","112985","4923","","Del Mus","Del","","Del","","Mus","","90.902","3.610","1.384","195.566380","-71.548855","K2III","K","1","","" }
{ "49700","49841","88284","3994","","41Lam Hya","Lam","41","Lam","","Hya","","112.545","3.610","0.920","152.647001","-12.354083","K0III","K","1","","" }
{ "37711","37819","63032","3017","","","","","","","Pup","","1132.487","3.620","-4.083","116.313740","-37.968584","K4III","K","1","","" }
{ "82477","82729","152334","6271","","Zet2Sco","Zet-2","","Zet","2","Sco","","132.315","3.620","0.579","253.645964","-42.361313","K4III","K","1","","" }
{ "113366","113726","217675","8762","","1Omi And","Omi","1","Omi","","And","Alfarasalkamil","686.645","3.620","-2.997","345.480248","42.325979","B6pv SB","B","1","","" }
{ "7083","7097","9270","437","","99Eta Psc","Eta","99","Eta","","Psc","Alpherg","349.578","3.620","-1.531","22.870870","15.345823","G8III","G","1","","" }
{ "17805","17847","23850","1178","","27    Tau","","27","","","Tau","Atlas","382.364","3.620","-1.725","57.290590","24.053415","B8III","B","1","","" }
{ "57190","57363","102249","4520","","Lam Mus","Lam","","Lam","","Mus","","127.157","3.630","0.675","176.402120","-66.728763","A7III","A","1","","" }
{ "101442","101769","196524","7882","","6Bet Del","Bet","6","Bet","","Del","Rotanev","100.883","3.640","1.188","309.387244","14.595087","F5IV","F","1","","" }
{ "88439","88714","165024","6743","","The Ara","The","","The","","Ara","","813.358","3.650","-3.334","271.657807","-50.091477","B2Ib","B","1","","" }
{ "76997","77233","141003","5867","","28Bet Ser","Bet","28","Bet","","Ser","Zhou","155.091","3.650","0.264","236.546895","15.421826","A3V","A","1","","" }
{ "46600","46733","81937","3757","GJ 3559","23    UMa","","23","","","UMa","","77.675","3.650","1.766","142.881801","63.061861","F0IV","F","1","","" }
{ "110614","110960","213051","8558","","55Zet1Aqr","Zet-1","55","Zet","1","Aqr","","91.875","3.650","1.401","337.207967","-0.019972","F3III-IV","F","1","","" }
{ "20155","20205","27371","1346","","54Gam Tau","Gam","54","Gam","","Tau","Prima Hyadum","161.544","3.650","0.176","64.948338","15.627642","G8III","G","1","","" }
{ "75466","75695","137909","5747","","3Bet CrB","Bet","3","Bet","","CrB","Nusakan","111.812","3.660","0.985","231.957275","29.105703","F0p","F","1","","" }
{ "76365","76600","139365","5812","","40Tau Lib","Tau","40","Tau","","Lib","","366.880","3.660","-1.595","234.664047","-29.777754","B2.5V","B","1","","" }
{ "68537","68756","123299","5291","","11Alp Dra","Alp","11","Alp","","Dra","Thuban","303.119","3.670","-1.171","211.097471","64.375850","A0III SB","A","1","","" }
{ "102895","103227","198700","7986","","Bet Ind","Bet","","Bet","","Ind","","611.926","3.670","-2.696","313.702466","-58.454155","K0III","K","1","","" }
{ "97056","97365","187076","7536","","7Del Sge","Del","7","Del","","Sge","","594.092","3.680","-2.622","296.846927","18.534286","M2II + B6","M","1","","" }
{ "22496","22549","30836","1552","","3Pi 4Ori","Pi-4","3","Pi","4","Ori","","1052.117","3.680","-3.863","72.801516","5.605104","B2III SB","B","1","","" }
{ "42709","42828","74575","3468","","Alp Pyx","Alp","","Alp","","Pyx","","879.128","3.680","-3.473","130.898080","-33.186385","B1.5III","B","1","","" }
{ "113980","114341","218594","8812","","88    Aqr","","88","","","Aqr","Safina","270.669","3.680","-0.915","347.361644","-21.172410","K1III","K","1","","" }
{ "2914","2920","3360","153","","17Zet Cas","Zet","17","Zet","","Cas","Fulu","593.012","3.690","-2.608","9.242822","53.896909","B2IV","B","1","","" }
{ "8989","9007","11937","566","Gl 81A","Chi Eri","Chi","","Chi","","Eri","","58.222","3.690","2.432","28.988458","-51.608896","G5IV","G","1","","Gl 81" }
{ "23398","23453","32068","1612","","8Zet Aur","Zet","8","Zet","","Aur","Saclateni","785.919","3.690","-3.220","75.619522","41.075837","K4II comp","K","1","","" }
{ "57226","57399","102224","4518","","63Chi UMa","Chi","63","Chi","","UMa","Taiyangshou","183.647","3.690","-0.063","176.512722","47.779406","K0III","K","1","","" }
{ "106642","106985","206088","8278","GJ 4209","40Gam Cap","Gam","40","Gam","","Cap","Nashira","157.033","3.690","0.277","325.022714","-16.662308","A7III:mp...","A","1","","" }
{ "47719","47854","84810","3884","","","","","","","Car","","1560.557","3.690","-4.709","146.311750","-62.507903","G5Iab/Ib","G","1","","" }
{ "114609","114971","219615","8852","","6Gam Psc","Gam","6","Gam","","Psc","","137.968","3.700","0.568","349.291404","3.282289","G7III","G","1","","" }
{ "15436","15474","20720","1003","","16Tau4Eri","Tau-4","16","Tau","4","Eri","","304.534","3.700","-1.151","49.879165","-21.757864","M3/M4III","M","1","","" }
{ "87661","87933","163993","6703","","92Xi  Her","Xi","92","Xi","","Her","","136.811","3.700","0.587","269.441161","29.247880","K0III","K","1","","" }
{ "88494","88771","165777","6771","GJ 9615A","72    Oph","","72","","","Oph","","86.859","3.710","1.583","271.837436","9.563847","A4IVs","A","1","","GJ 9615" }
{ "97725","98036","188512","7602","Gl 771A","60Bet Aql","Bet","60","Bet","","Aql","Alshain","44.679","3.710","3.027","298.828304","6.406763","G8IVvar","G","1","","Gl 771" }
{ "77386","77622","141795","5892","GJ 3921","37Eps Ser","Eps","37","Eps","","Ser","","70.444","3.710","2.038","237.704024","4.477730","A2m","A","1","","" }
{ "28032","28103","40136","2085","Gl 225","16Eta Lep","Eta","16","Eta","","Lep","","48.528","3.710","2.847","89.101223","-14.167700","F1V","F","1","","" }
{ "38304","38414","64440","3080","","","","","","","Pup","","352.601","3.710","-1.459","118.054322","-40.575786","G5III...","G","1","","" }
{ "22744","22797","31237","1567","","8Pi 5Ori","Pi-5","8","Pi","5","Ori","","1342.207","3.710","-4.362","73.562902","2.440672","B2III SB","B","1","","" }
{ "16496","16537","22049","1084","Gl 144","18Eps Eri","Eps","18","Eps","","Eri","Ran","10.490","3.720","6.183","53.232717","-9.458262","K2V","K","1","","" }
{ "17457","17499","23302","1142","","17    Tau","","17","","","Tau","Electra","404.661","3.720","-1.748","56.218900","24.113339","B6III","B","1","","" }
{ "103725","104060","200905","8079","","62Xi  Cyg","Xi","62","Xi","","Cyg","","842.781","3.720","-3.341","316.232753","43.927852","K5Ibv SB","K","1","","" }
{ "28287","28358","40035","2077","","33Del Aur","Del","33","Del","","Aur","","126.026","3.720","0.785","89.881669","54.284656","K0III","K","1","","" }
{ "16044","16083","21364","1038","","2Xi  Tau","Xi","2","Xi","","Tau","","209.075","3.730","-0.304","51.792301","9.732680","B9Vn","B","1","","" }
{ "112601","112961","216386","8698","","73Lam Aqr","Lam","73","Lam","","Aqr","","385.073","3.730","-1.631","343.153649","-7.579599","M2IIIvar","M","1","","" }
{ "71994","72220","130109","5511","","109    Vir","","109","","","Vir","","134.497","3.730","0.654","221.562184","1.892885","A0V","A","1","","" }
{ "87314","87585","163588","6688","","32Xi  Dra","Xi","32","Xi","","Dra","Grumium","112.545","3.730","1.040","268.382017","56.872643","K2III","K","1","","" }
{ "106746","107089","205478","8254","Gl 835.1","Nu  Oct","Nu","","Nu","","Oct","","69.145","3.730","2.098","325.368795","-77.390046","K0III","K","1","","" }
{ "104549","104887","202444","8130","Gl 822.1A","65Tau Cyg","Tau","65","Tau","","Cyg","","66.346","3.740","2.198","318.697753","38.045317","F1IV","F","1","","Gl 822.1" }
{ "8628","8645","11353","539","","55Zet Cet","Zet","55","Zet","","Cet","Baten Kaitos","234.983","3.740","-0.548","27.865138","-10.335038","K2III","K","1","","" }
{ "79928","80170","147547","6095","","20Gam Her","Gam","20","Gam","","Her","","192.650","3.740","-0.117","245.480066","19.153130","A9III","A","1","","" }
{ "86839","87108","161868","6629","","62Gam Oph","Gam","62","Gam","","Oph","Bake-eo","102.791","3.750","1.257","266.973169","2.707276","A0V","A","1","","" }
{ "44383","44511","78004","3614","","","","","","","Vel","","299.501","3.750","-1.065","136.038722","-47.097737","K2III","K","1","","" }
{ "30794","30867","45725","2356","","11Bet Mon","Bet","11","Bet","","Mon","","676.673","3.760","-2.825","97.204458","-7.033062","B3Ve","B","1","","" }
{ "93388","93683","177241","7217","GJ 9641","39Omi Sgr","Omi","39","Omi","","Sgr","","142.054","3.760","0.565","286.170743","-21.741496","K0III","K","1","","" }
{ "95554","95853","184006","7420","","10Iot2Cyg","Iot-2","10","Iot","2","Cyg","","121.338","3.760","0.907","292.426464","51.729779","A5Vn","A","1","","" }
{ "110822","111169","213558","8585","","7Alp Lac","Alp","7","Alp","","Lac","Stellio","102.597","3.760","1.271","337.822732","50.282491","A1V","A","1","","" }
{ "26004","26069","37350","1922","","Bet Dor","Bet","","Bet","","Dor","","1006.656","3.760","-3.687","83.406320","-62.489825","F6Ia","F","1","","" }
{ "27585","27654","39364","2035","","15Del Lep","Del","15","Del","","Lep","","113.723","3.760","1.048","87.830360","-20.879089","G8III/IV","G","1","","" }
{ "13234","13268","17506","834","","15Eta Per","Eta","15","Eta","","Per","Miram","879.128","3.770","-3.383","42.674177","55.895496","K3Ib comp SB","K","1","","" }
{ "17487","17529","23230","1135","","41Nu  Per","Nu","41","Nu","","Per","","556.581","3.770","-2.391","56.298479","42.578549","F5IIvar","F","1","","" }
{ "20405","20455","27697","1373","","61Del1Tau","Del-1","61","Del","1","Tau","Secunda Hyadum","155.609","3.770","0.377","65.733709","17.542514","G8III","G","1","","" }
{ "26484","26549","37468","1931","","48Sig Ori","Sig","48","Sig","","Ori","","1072.883","3.770","-3.816","84.686533","-2.600069","O9.5V...","O","1","","" }
{ "101629","101958","196867","7906","","9Alp Del","Alp","9","Alp","","Del","Sualocin","253.818","3.770","-0.685","309.909525","15.912072","B9V","B","1","","" }
{ "105540","105881","204075","8204","","34Zet Cap","Zet","34","Zet","","Cap","","385.528","3.770","-1.593","321.666775","-22.411332","G4Ibp...","G","1","","" }
{ "108830","109176","210027","8430","Gl 848","24Iot Peg","Iot","24","Iot","","Peg","","38.245","3.770","3.424","331.752698","25.345112","F5V","F","1","","" }
{ "82112","82363","151249","6229","","Eta Ara","Eta","","Eta","","Ara","","299.226","3.770","-1.043","252.446393","-59.041378","K5III","K","1","","" }
{ "41195","41312","71878","3347","GJ 3499","Bet Vol","Bet","","Bet","","Vol","","107.536","3.770","1.179","126.434272","-66.136890","K2IIIvar","K","1","","" }
{ "42452","42570","74180","3445","","","","","","","Vel","","326156.378","3.770","-16.230","130.156548","-46.648744","F3Ia","F","1","","" }
{ "34389","34481","55865","2736","","Gam2Vol","Gam-2","","Gam","2","Vol","","139.801","3.780","0.620","107.186826","-70.498932","G8IIIvar","G","1","","" }
{ "35946","36046","58207","2821","","60Iot Gem","Iot","60","Iot","","Gem","","120.353","3.780","0.945","111.431689","27.798080","G9III+...","G","1","","" }
{ "48182","48319","84999","3888","","29Ups UMa","Ups","29","Ups","","UMa","","116.235","3.780","1.020","147.748000","59.038735","F0IV","F","1","","" }
{ "53099","53253","94510","4257","Gl 404.1","","","","","","Car","","95.006","3.780","1.458","163.373386","-58.853171","K0III-IV...","K","1","","" }
{ "71569","71795","129246","5477","","30Zet Boo","Zet","30","Zet","","Boo","","175.731","3.780","0.123","220.287295","13.728300","A3IVn","A","1","","" }
{ "102287","102618","198001","7950","","2Eps Aqr","Eps","2","Eps","","Aqr","Albali","207.743","3.780","-0.241","311.918963","-9.495776","A1V","A","1","","" }
{ "14632","14668","19476","941","","27Kap Per","Kap","27","Kap","","Per","Misam","112.740","3.790","1.097","47.373875","44.857544","K0III","K","1","","" }
{ "53075","53229","94264","4247","","46    LMi","","46","","","LMi","Praecipua","94.868","3.790","1.472","163.327891","34.214871","K0III-IV","K","1","","" }
{ "37124","37229","61555","2948","","","","","","","Pup","","346.606","3.800","-1.332","114.707797","-26.803836","B5IV","B","1","","" }
{ "14843","14879","20010","963","Gl 127A","Alp For","Alp","","Alp","","For","Dalim","46.435","3.800","3.033","48.018736","-28.987618","F8V","F","1","","Gl 127" }
{ "76044","76276","138917","5788","","13Del Ser","Del","13","Del","","Ser","","228.081","3.800","-0.423","233.700616","10.538867","F0IV","F","1","","" }
{ "94484","94779","181276","7328","","1Kap Cyg","Kap","1","Kap","","Cyg","","124.155","3.800","0.897","289.275604","53.368459","K0III","K","1","","" }
{ "99356","99675","192577","7735","","31    Cyg","","31","","","Cyg","","883.893","3.800","-3.365","303.407938","46.741329","K2II+...","K","1","","" }
{ "76716","76952","140436","5849","","8Gam CrB","Gam","8","Gam","","CrB","","146.062","3.810","0.554","235.685719","26.295637","A1Vs","A","1","","" }
{ "51087","51232","90853","4114","","","","","","","Car","","1342.207","3.810","-4.262","156.969739","-58.739403","F2II","F","1","","" }
{ "21340","21393","29291","1464","","52Ups2Eri","Ups-2","52","Ups","2","Eri","Theemin","213.873","3.810","-0.274","68.887680","-30.562341","G8III","G","1","","" }
{ "116218","116584","222107","8961","GJ 9832","16Lam And","Lam","16","Lam","","And","Udkadua","86.125","3.810","1.701","354.390835","46.458152","G8III-IV","G","1","","" }
{ "45557","45688","80081","3690","","38    Lyn","","38","","","Lyn","","124.821","3.820","0.906","139.711034","36.802597","A1V","A","1","","" }
{ "86148","86414","160762","6588","","85Iot Her","Iot","85","Iot","","Her","","454.890","3.820","-1.902","264.866201","46.006332","B3V SB","B","1","","" }
{ "56044","56211","100029","4434","","1Lam Dra","Lam","1","Lam","","Dra","Giausar","333.152","3.820","-1.226","172.851102","69.331076","M0IIIvar","M","1","","" }
{ "80637","80883","148857","6149","","10Lam Oph","Lam","10","Lam","","Oph","Marfik","173.119","3.820","0.195","247.728429","1.983923","A2V","A","1","","" }
{ "9467","9487","12446","595","","113Alp Psc","Alp","113","Alp","","Psc","Alrescha","150.580","3.820","0.498","30.511750","2.763759","A2","A","1","","" }
{ "50924","51069","90432","4094","","42Mu  Hya","Mu","42","Mu","","Hya","","234.140","3.830","-0.450","156.522625","-16.836290","K4III","K","1","","" }
{ "68027","68245","121743","5248","","Phi Cen","Phi","","Phi","","Cen","","525.212","3.830","-2.205","209.567795","-42.100753","B2IV","B","1","","" }
{ "72144","72370","129078","5470","","Alp Aps","Alp","","Alp","","Aps","Paradys","446.790","3.830","-1.853","221.965512","-79.044751","K5III","K","1","","" }
{ "61008","61199","109026","4773","","Gam Mus","Gam","","Gam","","Mus","","324.857","3.840","-1.151","188.117006","-72.132988","B5V","B","1","","" }
{ "17398","17440","23817","1175","Gl 154.2","Bet Ret","Bet","","Bet","","Ret","","97.389","3.840","1.465","56.048895","-64.806903","K0IV SB","K","1","","" }
{ "17406","17448","23180","1131","","38Omi Per","Omi","38","Omi","","Per","Atik","1120.812","3.840","-3.841","56.079713","32.288248","B1III","B","1","","" }
{ "20833","20885","28307","1411","","77The1Tau","The-1","77","The","1","Tau","","154.357","3.840","0.464","67.143723","15.962181","G7III","G","1","","" }
{ "88517","88794","166014","6779","","103Omi Her","Omi","103","Omi","","Her","","337.986","3.840","-1.237","271.885627","28.762488","B9.5V","B","1","","" }
{ "89064","89341","166937","6812","","13Mu  Sgr","Mu","13","Mu","","Sgr","Polis","326156.378","3.840","-16.160","273.440873","-21.058834","B2III:","B","1","","" }
{ "97124","97433","188119","7582","","63Eps Dra","Eps","63","Eps","","Dra","","147.984","3.840","0.556","297.042751","70.267930","G8III","G","1","","" }
{ "43659","43783","76728","3571","","","","","","","Car","","319.761","3.840","-1.117","133.761855","-60.644609","B8III","B","1","","" }
{ "51475","51624","91316","4133","","47Rho Leo","Rho","47","Rho","","Leo","Shaomin","326156.378","3.840","-16.160","158.202799","9.306586","B1Ib SB","B","1","","" }
{ "51837","51986","92139","4167","","","","","","","Vel","","87.535","3.840","1.696","159.325750","-48.225620","A3m+...","A","1","","" }
{ "30204","30277","44762","2296","","Del Col","Del","","Del","","Col","","233.972","3.850","-0.429","95.528462","-33.436400","G7II","G","1","","" }
{ "50050","50191","88955","4023","","","","","","","Vel","","101.354","3.850","1.388","153.684107","-42.121942","A2V","A","1","","" }
{ "19697","19747","26967","1326","","Alp Hor","Alp","","Alp","","Hor","","115.006","3.850","1.114","63.500440","-42.294368","K1III","K","1","","" }
{ "27253","27321","39060","2020","Gl 219","Bet Pic","Bet","","Bet","","Pic","","63.405","3.850","2.407","86.821192","-51.066514","A3V","A","1","","" }
{ "61088","61281","109387","4787","","5Kap Dra","Kap","5","Kap","","Dra","","490.461","3.850","-2.036","188.370869","69.788238","B6IIIp","B","1","","" }
{ "61429","61622","109787","4802","","Tau Cen","Tau","","Tau","","Cen","","131.250","3.850","0.827","189.425912","-48.541304","A2V","A","1","","" }
{ "77836","78072","142860","5933","Gl 603","41Gam Ser","Gam","41","Gam","","Ser","","36.705","3.850","3.594","239.113232","15.661617","F6V","F","1","","" }
{ "89860","90139","169414","6895","","109    Her","","109","","","Her","Tusizuo","118.948","3.850","1.040","275.924503","21.769752","K2III","K","1","","" }
{ "90835","91117","171443","6973","","Alp Sct","Alp","","Alp","","Sct","","199.119","3.850","-0.078","278.801778","-8.244073","K2III","K","1","","" }
{ "87537","87808","163770","6695","","91The Her","The","91","The","","Her","","753.248","3.860","-2.958","269.063250","37.250539","K1IIvar","K","1","","" }
{ "4426","4436","5448","269","","37Mu  And","Mu","37","Mu","","And","","129.736","3.860","0.862","14.188278","38.499345","A5V","A","1","","" }
{ "21541","21594","29503","1481","GJ 9160A","53    Eri","","53","","","Eri","Sceptrum","109.854","3.860","1.223","69.545106","-14.304020","K1III","K","1","","GJ 9160" }
{ "25794","25859","36597","1862","","Eps Col","Eps","","Eps","","Col","","263.242","3.860","-0.675","82.803133","-35.470519","K1II/III","K","1","","" }
{ "110049","110395","212061","8518","GJ 9779","48Gam Aqr","Gam","48","Gam","","Aqr","Sadachbia","163.733","3.860","0.356","335.414063","-1.387331","A0V","A","1","","" }
{ "79423","79664","145544","6030","","Del TrA","Del","","Del","","TrA","","607.367","3.860","-2.490","243.859450","-63.685682","G5II","G","1","","" }
{ "80819","81065","147675","6102","Gl 626.1","Gam Aps","Gam","","Gam","","Aps","","156.280","3.860","0.458","248.364128","-78.897148","K0IV SB","K","1","","" }
{ "68064","68282","121790","5249","","Ups1Cen","Ups-1","","Ups","1","Cen","","427.466","3.870","-1.717","209.669812","-44.803584","B2IV-V","B","1","","" }
{ "71731","71957","129502","5487","GJ 9491","107Mu  Vir","Mu","107","Mu","","Vir","","59.594","3.870","2.561","220.765096","-5.658207","F2III","F","1","","" }
{ "77868","78104","142669","5928","","5Rho Sco","Rho","5","Rho","","Sco","Iklil","472.006","3.870","-1.933","239.221157","-29.214073","B2IV/V","B","1","","" }
{ "17532","17573","23408","1149","","20    Tau","","20","","","Tau","Maia","383.262","3.870","-1.480","56.456689","24.367748","B8III","B","1","","" }
{ "97493","97804","187929","7570","","55Eta Aql","Eta","55","Eta","","Aql","","1382.019","3.870","-4.265","298.118199","1.005661","F6Ibv SB","F","1","","" }
{ "42904","43023","75063","3487","","","","","","","Vel","","1853.161","3.870","-4.902","131.506865","-46.041527","A1III","A","1","","" }
{ "48318","48455","85503","3905","","24Mu  Leo","Mu","24","Mu","","Leo","Rasalas","124.108","3.880","0.978","148.190964","26.006951","K0III","K","1","","" }
{ "74148","74376","134481","5646","","Kap1Lup","Kap-1","","Kap","1","Lup","","179.998","3.880","0.171","227.983769","-48.737819","B9V","B","1","","" }
{ "763","765","496","25","Gl 9.1","Eps Phe","Eps","","Eps","","Phe","","144.189","3.880","0.652","2.352546","-45.747426","K0III","K","1","","" }
{ "8813","8832","11502","546","","5Gam2Ari","Gam-2","5","Gam","2","Ari","Mesarthim","164.063","3.880","0.372","28.382548","19.293852","A1p Si","A","1","","" }
{ "114059","114421","218670","8820","","Iot Gru","Iot","","Iot","","Gru","","183.234","3.880","0.132","347.589604","-45.246711","K0III SB","K","1","","" }
{ "59945","60129","107259","4689","","15Eta Vir","Eta","15","Eta","","Vir","Zaniah","265.384","3.890","-0.662","184.976487","-0.666803","A2IV","A","1","","" }
{ "97799","98110","188947","7615","","21Eta Cyg","Eta","21","Eta","","Cyg","","134.943","3.890","0.806","299.076568","35.083424","K0IIIvar","K","1","","" }
{ "33065","33152","50877","2580","","16Omi1CMa","Omi-1","16","Omi","1","CMa","","326156.378","3.890","-16.110","103.533137","-24.184211","K3Iab","K","1","","" }
{ "45204","45336","79469","3665","","22The Hya","The","22","The","","Hya","","113.485","3.890","1.182","138.591079","2.314280","B9.5V","B","1","","" }
{ "13667","13701","18322","874","","3Eta Eri","Eta","3","Eta","","Eri","Azha","136.524","3.890","0.781","44.106871","-8.898144","K1III-IV","K","1","","" }
{ "55260","55425","98718","4390","","Pi  Cen","Pi","","Pi","","Cen","","357.628","3.900","-1.300","170.251757","-54.491019","B5Vn","B","1","","" }
{ "65729","65936","117440","5089","","","","","","","Cen","","905.990","3.900","-3.318","202.761080","-39.407307","G8II/III","G","1","","" }
{ "47297","47431","83618","3845","","35Iot Hya","Iot","35","Iot","","Hya","Ukdah","263.242","3.900","-0.635","144.964007","-1.142810","K3IIIvar","K","1","","" }
{ "41190","41307","71155","3314","","","","","","","Hya","","122.339","3.910","1.039","126.415135","-3.906424","A0V","A","1","","" }
{ "18860","18907","25490","1251","","38Nu  Tau","Nu","38","Nu","","Tau","","116.944","3.910","1.137","60.789083","5.989305","A1V","A","1","","" }
{ "60635","60823","108483","4743","","Sig Cen","Sig","","Sig","","Cen","","411.814","3.910","-1.596","187.009969","-50.230635","B3V","B","1","","" }
{ "73579","73807","133242","5605","","Pi  Lup","Pi","","Pi","","Lup","","443.147","3.910","-1.756","226.279550","-47.051245","B5","B","1","","" }
{ "76100","76333","138905","5787","GJ 3912","38Gam Lib","Gam","38","Gam","","Lib","Zubenelhakrabi","163.160","3.910","0.414","233.881573","-14.789537","K0III","K","1","","" }
{ "79750","79992","147394","6092","","22Tau Her","Tau","22","Tau","","Her","","307.405","3.910","-0.961","244.935167","46.313366","B5IV","B","1","","" }
{ "82952","83207","153808","6324","","58Eps Her","Eps","58","Eps","","Her","","155.017","3.920","0.535","255.072410","30.926405","A0V","A","1","","" }
{ "94873","95168","181577","7340","GJ 4107","44Rho1Sgr","Rho-1","44","Rho","1","Sgr","","126.959","3.920","0.969","290.418164","-17.847197","F0III/IV","F","1","","" }
{ "104649","104987","202447","8131","","8Alp Equ","Alp","8","Alp","","Equ","Kitalpha","190.290","3.920","0.090","318.955964","5.247845","G0III+...","G","1","","" }
{ "87920","88192","164353","6714","","67    Oph","","67","","","Oph","","1230.779","3.930","-3.954","270.161315","2.931568","B5Ib","B","1","","" }
{ "78693","78933","144470","5993","","9Ome1Sco","Ome-1","9","Ome","1","Sco","","471.324","3.930","-1.869","241.701776","-20.669192","B1V","B","1","","" }
{ "37397","37504","63295","3024","","Zet Vol","Zet","","Zet","","Vol","","141.010","3.930","0.751","115.455064","-72.606098","K0III","K","1","","" }
{ "54304","54463","96918","4337","","","","","","","Car","","326156.378","3.930","-16.070","167.147469","-58.975037","G0Ia0","G","1","","" }
{ "2069","2072","2262","100","Gl 20","Kap Phe","Kap","","Kap","","Phe","","77.656","3.930","2.046","6.550742","-43.679829","A7V","A","1","","" }
{ "7068","7083","9362","440","","Del Phe","Del","","Del","","Phe","","142.116","3.930","0.734","22.812759","-49.072702","K0III-IV","K","1","","" }
{ "13497","13531","17878","854","","18Tau Per","Tau","18","Tau","","Per","","254.214","3.930","-0.529","43.564422","52.762479","G4III...","G","1","","" }
{ "21391","21444","29248","1463","","48Nu  Eri","Nu","48","Nu","","Eri","","675.272","3.930","-2.650","69.079756","-3.352459","B2III SB","B","1","","" }
{ "5337","5348","6882","338","","Zet Phe","Zet","","Zet","","Phe","Wurren","298.678","3.940","-0.869","17.096135","-55.245760","B6V + B0V","B","1","","" }
{ "103081","103413","199629","8028","","58Nu  Cyg","Nu","58","Nu","","Cyg","","374.462","3.940","-1.360","314.293402","41.167136","A1Vn","A","1","","" }
{ "37340","37447","61935","2970","","26Alp Mon","Alp","26","Alp","","Mon","","147.783","3.940","0.659","115.311804","-9.551131","K0III","K","1","","" }
{ "37570","37677","62623","2996","","3    Pup","","3","","","Pup","","326156.378","3.940","-16.060","115.951956","-28.954826","A2Iab","A","1","","" }
{ "42792","42911","74442","3461","","47Del Cnc","Del","47","Del","","Cnc","Asellus Australis","130.567","3.940","0.928","131.171250","18.154309","K0III","K","1","","" }
{ "31512","31592","47205","2429","Gl 239.1","7Nu 2CMa","Nu-2","7","Nu","2","CMa","","64.419","3.950","2.472","99.170980","-19.255879","K1III+...","K","1","","" }
{ "9577","9598","12216","580","","50    Cas","","50","","","Cas","","157.108","3.950","0.536","30.859019","72.421294","A2V","A","1","","" }
{ "118887","","116657","5055","GJ 3784B","79Zet UMa","Zet","79","Zet","","UMa","","78.782","3.950","2.035","200.984946","54.920471","A1 m","A","2","","GJ 3784" }
{ "115073","115438","220321","8892","","98    Aqr","","98","","","Aqr","","163.405","3.960","0.461","350.742630","-20.100580","K0III","K","1","","" }
{ "19296","19343","25940","1273","","48    Per","","48","","","Per","","476.837","3.960","-1.865","62.165354","47.712513","B3Ve","B","1","","" }
{ "28256","28328","40808","2120","","Eta Col","Eta","","Eta","","Col","","472.006","3.960","-1.843","89.786672","-42.815135","K0III","K","1","","" }
{ "44120","44248","76943","3579","Gl 332A","","","","","","Lyn","","52.411","3.960","2.930","135.160282","41.782911","F5V","F","1","","Gl 332" }
{ "44972","45101","79447","3663","","","","","","","Car","","542.690","3.960","-2.146","137.819773","-62.316977","B3IV","B","1","","" }
{ "94946","95241","181454","7337","","Bet1Sgr","Bet-1","","Bet","1","Sgr","Arkab Prior","313.612","3.960","-0.955","290.659545","-44.458965","B9V","B","1","","" }
{ "95052","95347","181869","7348","","Alp Sgr","Alp","","Alp","","Sgr","Rukbat","181.804","3.960","0.229","290.971543","-40.615940","B8V","B","1","","" }
{ "99529","99848","192909","7751","","32    Cyg","","32","","","Cyg","","1058.949","3.960","-3.597","303.868002","47.714208","K3Ib-II comp","K","1","","" }
{ "98184","98495","188228","7590","","Eps Pav","Eps","","Eps","","Pav","","105.076","3.970","1.430","300.147668","-72.910504","A0V","A","1","","" }
{ "20483","20535","28028","1393","","43    Eri","","43","","","Eri","Beemim","296.236","3.970","-0.821","66.009201","-34.016846","K4III","K","1","","" }
{ "27604","27673","39003","2012","","32Nu  Aur","Nu","32","Nu","","Aur","","230.337","3.970","-0.275","87.872490","39.148480","K0III","K","1","","" }
{ "110650","110997","213009","8556","","Del1Gru","Del-1","","Del","1","Gru","","309.446","3.970","-0.916","337.317370","-43.495565","G6/G8III","G","1","","" }
{ "112084","112440","215665","8667","GJ 4295","47Lam Peg","Lam","47","Lam","","Peg","","365.237","3.970","-1.276","341.632815","23.565654","G8II-III","G","1","","" }
{ "59267","59449","105937","4638","","Rho Cen","Rho","","Rho","","Cen","","378.811","3.970","-1.355","182.913028","-52.368460","B3V","B","1","","" }
{ "77398","77634","141556","5883","","5Chi Lup","Chi","5","Chi","","Lup","","195.186","3.970","0.085","237.739743","-33.627165","B9.5III-IV","B","1","","" }
{ "35132","35228","57623","2803","","Del Vol","Del","","Del","","Vol","","737.910","3.970","-2.803","109.207618","-67.957152","F6II","F","1","","" }
{ "42396","42515","74006","3438","","Bet Pyx","Bet","","Bet","","Pyx","","416.016","3.970","-1.558","130.025592","-35.308352","G5II/III","G","1","","" }
{ "106139","106481","205435","8252","","73Rho Cyg","Rho","73","Rho","","Cyg","","123.591","3.980","1.087","323.495244","45.591837","G8III","G","1","","" }
{ "18567","18614","24912","1228","","46Xi  Per","Xi","46","Xi","","Per","Menkib","1244.872","3.980","-3.928","59.741253","35.791033","O7.5Iab:","O","1","","" }
{ "9328","9347","12274","585","","59Ups Cet","Ups","59","Ups","","Cet","","292.779","3.990","-0.776","30.001260","-21.077831","K5/M0III","K","1","","" }
{ "114634","114996","219571","8848","GJ 9818","Gam Tuc","Gam","","Gam","","Tuc","","75.203","3.990","2.176","349.357465","-58.235734","F1III","F","1","","" }
{ "29578","29651","43232","2227","","5Gam Mon","Gam","5","Gam","","Mon","","497.949","3.990","-1.929","93.713887","-6.274776","K3III","K","1","","" }
{ "50809","50954","90589","4102","Gl 391","","","","","","Car","","52.913","3.990","2.939","156.098879","-74.031612","F2IV","F","1","","" }
{ "65272","65477","116842","5062","GJ 3785","80    UMa","","80","","","UMa","Alcor","81.723","3.990","1.995","201.306191","54.987958","A5V SB","A","1","","" }
{ "55476","55642","99028","4399","","78Iot Leo","Iot","78","Iot","","Leo","","77.215","4.000","2.129","170.981045","10.529509","F2IV SB","F","1","","" }
{ "79134","79374","145502","6027","","14Nu  Sco","Nu","14","Nu","","Sco","Jabbah","474.064","4.000","-1.812","242.998895","-19.460708","B2IV","B","1","","" }
{ "44254","44382","78045","3615","Gl 333.3","Alp Vol","Alp","","Alp","","Vol","","124.916","4.000","1.084","135.611657","-66.396076","Am","A","1","","" }
{ "34000","34088","52973","2650","","43Zet Gem","Zet","43","Zet","","Gem","Mekbuda","1376.187","4.010","-4.116","106.027217","20.570297","G3Ibv SB","G","1","","" }
{ "34943","35037","56139","2749","","28Ome CMa","Ome","28","Ome","","CMa","","911.051","4.010","-3.221","108.702729","-26.772667","B2IV/Ve","B","1","","" }
{ "91507","91792","171759","6982","","Zet Pav","Zet","","Zet","","Pav","","218.457","4.010","-0.120","280.758894","-71.428113","K2III","K","1","","" }
{ "100750","101076","195295","7834","","41    Cyg","","41","","","Cyg","","769.237","4.010","-2.853","307.348895","30.368555","F5II","F","1","","" }
{ "8053","8068","10516","496","","Phi Per","Phi","","Phi","","Per","","718.406","4.010","-2.705","25.915122","50.688732","B2Vpe","B","1","","" }
{ "22056","22109","30211","1520","","57Mu  Eri","Mu","57","Mu","","Eri","","521.850","4.010","-2.011","71.375629","-3.254657","B5IV","B","1","","" }
{ "71639","71865","129116","5471","","","","","","","Cen","","339.040","4.010","-1.074","220.489981","-37.793498","B2.5V","B","1","","" }
{ "78290","78527","144284","5986","Gl 609.1","13The Dra","The","13","The","","Dra","","68.607","4.010","2.395","240.472987","58.565251","F8IV-V","F","1","","" }
{ "79759","80000","146686","6072","GJ 9554","Gam2Nor","Gam-2","","Gam","2","Nor","","128.763","4.010","1.028","244.960311","-50.155508","G8III","G","1","","" }
{ "59020","59199","105452","4623","Gl 455.3","1Alp Crv","Alp","1","Alp","","Crv","Alchiba","48.716","4.020","3.149","182.103379","-24.728875","F0IV/V","F","1","","" }
{ "92951","93244","176411","7176","","13Eps Aql","Eps","13","Eps","","Aql","","154.944","4.020","0.636","284.905660","15.068298","K2III","K","1","","" }
{ "93136","93429","176678","7193","","12    Aql","","12","","","Aql","","143.935","4.020","0.796","285.420113","-5.739115","K1IIIvar","K","1","","" }
{ "43286","43409","75691","3518","","Gam Pyx","Gam","","Gam","","Pyx","","207.347","4.020","0.004","132.633056","-27.709844","K3III","K","1","","" }
{ "42984","43103","74739","3475","","48Iot Cnc","Iot","48","Iot","","Cnc","","331.123","4.030","-1.003","131.674259","28.759898","G8Iab:","G","1","","" }
{ "88327","88601","165341","6752","Gl 702A","70    Oph","","70","","","Oph","","16.580","4.030","5.499","271.363689","2.500099","K0V SB","K","1","","Gl 702" }
{ "101095","101421","195810","7852","","2Eps Del","Eps","2","Eps","","Del","Aldulfin","330.452","4.030","-0.998","308.303212","11.303263","B6III","B","1","","" }
{ "117900","118268","224617","9072","","28Ome Psc","Ome","28","Ome","","Psc","","104.337","4.030","1.505","359.827870","6.863321","F4IV","F","1","","" }
{ "62803","63003","112092","4898","","Mu 1Cru","Mu-1","","Mu","1","Cru","","414.430","4.030","-1.490","193.648499","-57.177924","B2IV-V","B","1","","" }
{ "10645","10670","14055","664","","9Gam Tri","Gam","9","Gam","","Tri","","112.313","4.030","1.345","34.328591","33.847194","A1Vnn","A","1","","" }
{ "23467","23522","31910","1603","","10Bet Cam","Bet","10","Bet","","Cam","","872.076","4.030","-3.106","75.854557","60.442245","G0Ib","G","1","","" }
{ "19538","19587","26574","1298","","38Omi1Eri","Omi-1","38","Omi","1","Eri","Beid","121.700","4.040","1.181","62.966417","-6.837581","F2II-III","F","1","","" }
{ "111147","111497","213998","8597","","62Eta Aqr","Eta","62","Eta","","Aqr","","167.862","4.040","0.482","338.839085","-0.117498","B9IV-Vn","B","1","","" }
{ "57208","57380","102212","4517","","3Nu  Vir","Nu","3","Nu","","Vir","","293.835","4.040","-0.733","176.464829","6.529376","M0III","M","1","","" }
{ "70274","70497","126660","5404","Gl 549A","23The Boo","The","23","The","","Boo","","47.393","4.040","3.229","216.299507","51.850744","F7V","F","1","","Gl 549" }
{ "55269","55434","98664","4386","","77Sig Leo","Sig","77","Sig","","Leo","","220.079","4.050","-0.096","170.284144","6.029322","B9.5Vs","B","1","","" }
{ "67246","67459","120477","5200","","5Ups Boo","Ups","5","Ups","","Boo","","263.454","4.050","-0.486","207.369346","15.797905","K5IIIvar","K","1","","" }
{ "69867","70090","125473","5367","","Psi Cen","Psi","","Psi","","Cen","","258.854","4.050","-0.448","215.139340","-37.885295","A0IV","A","1","","" }
{ "71310","71536","128345","5453","","Rho Lup","Rho","","Rho","","Lup","","316.043","4.050","-0.882","219.471812","-49.425828","B5V","B","1","","" }
{ "14596","14632","19373","937","Gl 124","Iot Per","Iot","","Iot","","Per","","34.379","4.050","3.936","47.265081","49.613278","G0V","G","1","","" }
{ "40587","40702","71243","3318","Gl 305","Alp Cha","Alp","","Alp","","Cha","","63.802","4.050","2.593","124.630545","-76.919722","F5III","F","1","","" }
{ "42765","42884","74772","3477","Gl 321.1","","","","","","Vel","","228.882","4.050","-0.181","131.099800","-42.649276","G5III","G","1","","" }
{ "112357","112716","216032","8679","","71Tau2Aqr","Tau-2","71","Tau","2","Aqr","","317.582","4.050","-0.892","342.397926","-13.592632","K5III","K","1","","" }
{ "22904","22957","31421","1580","","9Omi2Ori","Omi-2","9","Omi","2","Ori","","185.950","4.060","0.280","74.092815","13.514466","K2III","K","1","","" }
{ "55539","55705","99211","4405","","15Gam Crt","Gam","15","Gam","","Crt","","82.321","4.060","2.050","171.220527","-17.684010","A9V","A","1","","" }
{ "59746","59929","106849","4671","","Eps Mus","Eps","","Eps","","Mus","","301.438","4.060","-0.769","184.393756","-67.960736","M5III","M","1","","" }
{ "59826","60009","106983","4679","","Zet Cru","Zet","","Zet","","Cru","","357.628","4.060","-1.140","184.609472","-64.003071","B2.5V","B","1","","" }
{ "71783","72010","129456","5485","","","","","","","Cen","","209.478","4.060","0.021","220.914366","-35.173655","K3III","K","1","","" }
{ "82898","83153","152980","6295","","Eps1Ara","Eps-1","","Eps","1","Ara","","360.793","4.060","-1.159","254.896030","-53.160438","K4III","K","1","","" }
{ "36856","36962","60522","2905","","69Ups Gem","Ups","69","Ups","","Gem","","270.894","4.060","-0.537","113.980621","26.895741","K5III","K","1","","" }
{ "69479","69701","124850","5338","GJ 9473","99Iot Vir","Iot","99","Iot","","Vir","Syrma","72.527","4.070","2.335","214.003624","-6.000547","F7V","F","1","","" }
{ "73889","74117","133955","5626","","Lam Lup","Lam","","Lam","","Lup","","776.563","4.070","-2.814","227.210914","-45.279857","B3V","B","1","","" }
{ "74595","74824","135379","5670","Gl 580.1","Bet Cir","Bet","","Bet","","Cir","","99.651","4.070","1.645","229.378761","-58.801208","A3V","A","1","","" }
{ "110645","110991","213306","8571","","27Del Cep","Del","27","Del","","Cep","","865.136","4.070","-3.048","337.292739","58.415198","G2Ibvar","G","1","","" }
{ "33073","33160","50778","2574","","14The CMa","The","14","The","","CMa","","260.717","4.080","-0.434","103.547498","-12.038628","K4III","K","1","","" }
{ "46841","46974","83183","3825","","","","","","","Car","","1325.839","4.080","-3.965","143.611068","-59.229753","B5II","B","1","","" }
{ "53584","53740","95272","4287","","7Alp Crt","Alp","7","Alp","","Crt","Alkes","159.178","4.080","0.638","164.943662","-18.298783","K1III","K","1","","" }
{ "3685","3693","4502","215","","34Zet And","Zet","34","Zet","","And","Shimu","189.186","4.080","0.263","11.834713","24.267178","K1II","K","1","","" }
{ "10975","11001","15008","705","Gl 97.1","Del Hyi","Del","","Del","","Hyi","","139.682","4.080","0.921","35.437474","-68.659418","A3V","A","1","","" }
{ "12355","12387","16582","779","","82Del Cet","Del","82","Del","","Cet","","649.714","4.080","-2.416","39.870653","0.328511","B2IV","B","1","","" }
{ "14112","14146","18978","919","Gl 121","11Tau3Eri","Tau-3","11","Tau","3","Eri","","88.629","4.080","1.909","45.597950","-23.624472","A4V","A","1","","" }
{ "92571","92862","175865","7157","","13    Lyr","","13","","","Lyr","","298.132","4.080","-0.725","283.833736","43.946088","M5IIIvar","M","1","","" }
{ "103804","104139","200761","8075","","23The Cap","The","23","The","","Cap","","162.186","4.080","0.597","316.486774","-17.232861","A1V","A","1","","" }
{ "105162","105502","203504","8173","","1    Peg","","1","","","Peg","","155.832","4.080","0.684","320.521648","19.804508","K1III","K","1","","" }
{ "77214","77450","141477","5879","","35Kap Ser","Kap","35","Kap","","Ser","Gudja","381.916","4.090","-1.253","237.184910","18.141564","M1III","M","1","","" }
{ "26301","26366","37160","1907","","40Phi2Ori","Phi-2","40","Phi","2","Ori","","117.492","4.090","1.307","84.226613","9.290673","G8III-IV","G","1","","" }
{ "7499","7513","9826","458","Gl 61","50Ups And","Ups","50","Ups","","And","Titawin","44.004","4.100","3.450","24.199485","41.405459","F8V","F","1","","" }
{ "12744","12777","16895","799","Gl 107A","13The Per","The","13","The","","Per","","36.292","4.100","3.868","41.049512","49.228448","F7V","F","1","","Gl 107" }
{ "90288","90568","169767","6905","","Zet Tel","Zet","","Zet","","Tel","","126.222","4.100","1.161","277.207568","-49.070588","G8/K0III","G","1","","" }
{ "93865","94160","178345","7259","","Bet CrA","Bet","","Bet","","CrA","","474.064","4.100","-1.712","287.507316","-39.340796","K0II/IIICN.","K","1","","" }
{ "38057","38164","63922","3055","","","","","","","Pup","","1647.254","4.100","-4.417","117.309568","-46.373205","B0III","B","1","","" }
{ "33956","34045","53244","2657","","23Gam CMa","Gam","23","Gam","","CMa","Muliphein","441.946","4.110","-1.550","105.939553","-15.633286","B8II","B","1","","" }
{ "42193","42312","73634","3426","","","","","","","Vel","","1822.103","4.110","-4.626","129.410980","-42.989081","A6II","A","1","","" }
{ "48219","48356","85444","3903","","39Ups1Hya","Ups-1","39","Ups","1","Hya","Zhang","263.880","4.110","-0.430","147.869555","-14.846603","G6/G8III","G","1","","" }
{ "51690","51839","92305","4174","","Gam Cha","Gam","","Gam","","Cha","","417.614","4.110","-1.427","158.867484","-78.607786","M0III","M","1","","" }
{ "93819","94114","178253","7254","","Alp CrA","Alp","","Alp","","CrA","Meridiana","125.348","4.110","1.187","287.368034","-37.904474","A0/A1V","A","1","","" }
{ "12452","12486","16815","794","","Iot Eri","Iot","","Iot","","Eri","","150.650","4.110","0.787","40.166710","-39.855375","K0III","K","1","","" }
{ "113278","113638","217364","8747","","Zet Gru","Zet","","Zet","","Gru","","108.864","4.110","1.493","345.220151","-52.754137","G8III","G","1","","" }
{ "57266","57439","102350","4522","","","","","","","Cen","","389.673","4.110","-1.276","176.628484","-61.178398","G0II","G","1","","" }
{ "76206","76440","138538","5771","","Eps TrA","Eps","","Eps","","TrA","","201.705","4.110","0.154","234.180005","-66.317037","K0III","K","1","","" }
{ "58773","58948","104979","4608","GJ 3703","9Omi Vir","Omi","9","Omi","","Vir","","163.242","4.120","0.623","181.302254","8.732985","G8III","G","1","","" }
{ "12360","12394","16978","806","","Eps Hyi","Eps","","Eps","","Hyi","","151.842","4.120","0.780","39.896978","-68.266946","B9III","B","1","","" }
{ "19762","19812","26630","1303","","51Mu  Per","Mu","51","Mu","","Per","","900.984","4.120","-3.086","63.724419","48.409331","G0Ib...","G","1","","" }
{ "28543","28614","40932","2124","","61Mu  Ori","Mu","61","Mu","","Ori","","154.944","4.120","0.736","90.595827","9.647276","Am...","A","1","","" }
{ "97721","98032","188114","7581","","Iot Sgr","Iot","","Iot","","Sgr","","181.804","4.120","0.389","298.815386","-41.868288","K0III","K","1","","" }
{ "102647","102978","198542","7980","","18Ome Cap","Ome","18","Ome","","Cap","","842.781","4.120","-2.941","312.955381","-26.919133","K4III","K","1","","" }
{ "110696","111043","213080","8560","","Del2Gru","Del-2","","Del","2","Gru","","330.118","4.120","-0.906","337.439319","-43.749224","M4.5IIIa","M","1","","" }
{ "112050","112405","214846","8630","","Bet Oct","Bet","","Bet","","Oct","","149.271","4.130","0.827","341.515379","-81.381615","A9IV/V","A","1","","" }
{ "116405","116771","222368","8969","Gl 904","17Iot Psc","Iot","17","Iot","","Psc","","44.728","4.130","3.444","354.987666","5.626292","F7V","F","1","","" }
{ "30810","30883","45542","2343","","18Nu  Gem","Nu","18","Nu","","Gem","","544.501","4.130","-1.983","97.240779","20.212133","B6III","B","1","","" }
{ "77617","77853","142198","5908","","46The Lib","The","46","The","","Lib","","168.469","4.130","0.565","238.456397","-16.729293","K0III","K","1","","" }
{ "25184","25247","35369","1784","","29    Ori","","29","","","Ori","","157.336","4.130","0.713","80.986784","-7.808065","G8III","G","1","","" }
{ "102154","102485","197692","7936","Gl 805","16Psi Cap","Psi","16","Psi","","Cap","","47.873","4.130","3.297","311.523900","-25.270898","F5V","F","1","","" }
{ "107011","107354","206901","8315","","10Kap Peg","Kap","10","Kap","","Peg","","111.621","4.140","1.468","326.161380","25.645036","F5IV","F","1","","" }
{ "58895","59072","105211","4616","Gl 455.2","Eta Cru","Eta","","Eta","","Cru","","64.432","4.140","2.662","181.720303","-64.613730","F2III","F","1","","" }
{ "75895","76127","138749","5778","","4The CrB","The","4","The","","CrB","","375.324","4.140","-1.165","233.232435","31.359133","B6Vnn","B","1","","" }
{ "77923","78159","143107","5947","","13Eps CrB","Eps","13","Eps","","CrB","","221.423","4.140","-0.019","239.396905","26.877880","K3III","K","1","","" }
{ "109591","109937","211388","8498","","1    Lac","","1","","","Lac","","621.250","4.140","-2.259","333.992397","37.748737","K3III","K","1","","" }
{ "42195","42313","73262","3410","","4Del Hya","Del","4","Del","","Hya","","160.352","4.140","0.682","129.414026","5.703782","A1Vnn","A","1","","" }
{ "16328","16369","21754","1066","","5    Tau","","5","","","Tau","","342.242","4.140","-0.965","52.718242","12.936678","K0II-III...","K","1","","" }
{ "17566","17608","23480","1156","","23    Tau","","23","","","Tau","Merope","380.136","4.140","-1.193","56.581553","23.948358","B6IV","B","1","","" }
{ "116439","116805","222439","8976","","19Kap And","Kap","19","Kap","","And","Kaffalmusalsala","168.382","4.150","0.586","355.102038","44.333932","B9IVn","B","1","","" }
{ "84853","85112","157778","6484","","75Rho Her","Rho","75","Rho","","Her","","393.434","4.150","-1.257","260.920626","37.145946","B9.5III","B","1","","" }
{ "34677","34769","55185","2714","","22Del Mon","Del","22","Del","","Mon","","384.165","4.150","-1.205","107.966084","-0.492764","A2V","A","1","","" }
{ "28664","28734","41116","2134","","1    Gem","","1","","","Gem","","155.091","4.160","0.774","91.030062","23.263341","G7III","G","1","","" }
{ "36263","36366","58946","2852","Gl 274A","62Rho Gem","Rho","62","Rho","","Gem","","58.862","4.160","2.878","112.277927","31.784550","F0V...","F","1","","Gl 274" }
{ "85081","85340","157792","6486","Gl 673.1","44    Oph","","44","","","Oph","","83.161","4.160","2.128","261.592567","-24.175309","A3IV:m","A","1","","" }
{ "109657","110003","211391","8499","","43The Aqr","The","43","The","","Aqr","Ancha","187.446","4.170","0.373","334.208482","-7.783290","G8III-IV","G","1","","" }
{ "2592","2599","2905","130","","15Kap Cas","Kap","15","Kap","","Cas","","326156.378","4.170","-15.830","8.249954","62.931783","B1Ia","B","1","","" }
{ "17833","17874","24160","1195","","","","","","","Eri","","209.882","4.170","0.127","57.363550","-36.200250","G8III","G","1","","" }
{ "109511","109857","211336","8494","GJ 4266","23Eps Cep","Eps","23","Eps","","Cep","","85.448","4.180","2.089","333.758153","57.043587","F0IV","F","1","","" }
{ "111601","111954","214748","8628","","18Eps PsA","Eps","18","Eps","","PsA","","486.800","4.180","-1.690","340.163910","-27.043617","B8V","B","1","","" }
{ "69205","69427","124294","5315","","98Kap Vir","Kap","98","Kap","","Vir","Kang","254.810","4.180","-0.284","213.223940","-10.273702","K3III","K","1","","" }
{ "69510","69732","125162","5351","GJ 3837","19Lam Boo","Lam","19","Lam","","Boo","Xuange","99.015","4.180","1.769","214.096112","46.088305","A0sh","A","1","","" }
{ "81058","81304","149447","6166","","","","","","","Sco","","342.601","4.180","-0.927","249.093623","-35.255326","K5III","K","1","","" }
{ "67244","67457","120323","5192","","2    Cen","","2","","","Cen","","183.028","4.190","0.445","207.361360","-34.450776","M5III","M","1","","" }
{ "91756","92043","173667","7061","Gl 725.2","110    Her","","110","","","Her","","62.650","4.190","2.773","281.415524","20.546308","F6V","F","1","","" }
{ "80880","81126","149630","6168","","35Sig Her","Sig","35","Sig","","Her","","314.823","4.200","-0.723","248.525766","42.437041","B9Vvar","B","1","","" }
{ "112090","112447","215648","8665","Gl 872A","46Xi  Peg","Xi","46","Xi","","Peg","","53.155","4.200","3.139","341.673239","12.172888","F7V","F","1","","Gl 872" }
{ "112886","113246","216763","8720","","23Del PsA","Del","23","Del","","PsA","","154.138","4.200","0.828","343.987076","-32.539628","G8III","G","1","","" }
{ "25749","25813","36267","1839","","32    Ori","","32","","","Ori","","302.838","4.200","-0.639","82.696049","5.948139","B5V","B","1","","" }
{ "38721","38835","65228","3102","","11    Pup","","11","","","Pup","","521.850","4.200","-1.821","119.214754","-22.880119","F7/F8II","F","1","","" }
{ "51089","51233","90537","4100","","31Bet LMi","Bet","31","Bet","","LMi","","153.920","4.200","0.831","156.970909","36.707212","G8III-IV","G","1","","" }
{ "100767","101093","195725","7850","","2The Cep","The","2","The","","Cep","","136.467","4.210","1.102","307.395223","62.994105","A7III","A","1","","" }
{ "105519","105858","203608","8181","Gl 827","Gam Pav","Gam","","Gam","","Pav","","30.208","4.210","4.377","321.610580","-65.366198","F6V","F","1","","" }
{ "81830","82080","153751","6322","","22Eps UMi","Eps","22","Eps","","UMi","","303.967","4.210","-0.637","251.492387","82.037262","G5IIIvar","G","1","","" }
{ "16187","16228","21291","1035","","","","","","","Cam","","1941.407","4.210","-4.663","52.267225","59.940330","B9Ia","B","1","","" }
{ "20583","20635","27934","1387","","65Kap1Tau","Kap-1","65","Kap","1","Tau","","153.920","4.210","0.841","66.342334","22.293874","A7IV-V","A","1","","" }
{ "13221","13254","17584","840","","16    Per","","16","","","Per","","120.754","4.220","1.378","42.645951","38.318644","F2III","F","1","","" }
{ "17609","17651","23754","1173","Gl 155","27Tau6Eri","Tau-6","27","Tau","6","Eri","","57.493","4.220","2.989","56.712066","-23.249723","F3/F5V","F","1","","" }
{ "89630","89908","170000","6920","","43Phi Dra","Phi","43","Phi","","Dra","","302.838","4.220","-0.619","275.189323","71.337814","A0p (Si)","A","1","","" }
{ "91888","92175","173764","7063","","Bet Sct","Bet","","Bet","","Sct","","916.170","4.220","-3.023","281.793636","-4.747867","G5II...","G","1","","" }
{ "92319","92609","173948","7074","","Lam Pav","Lam","","Lam","","Pav","","1430.510","4.220","-3.990","283.054315","-62.187593","B2II-III","B","1","","" }
{ "92502","92791","175588","7139","","12Del2Lyr","Del-2","12","Del","2","Lyr","","736.245","4.220","-2.548","283.626186","36.898613","M4IIvar","M","1","","" }
{ "102122","102453","197912","7942","","52    Cyg","","52","","","Cyg","","201.083","4.220","0.270","311.415643","30.719715","K0III","K","1","","" }
{ "104764","105102","202850","8143","","67Sig Cyg","Sig","67","Sig","","Cyg","","2886.340","4.220","-5.515","319.353970","39.394681","B9Iab","B","1","","" }
{ "114362","114724","219215","8834","","90Phi Aqr","Phi","90","Phi","","Aqr","","202.080","4.220","0.260","348.580664","-6.049003","M2III","M","1","","" }
{ "38406","38518","64760","3090","","","","","","","Pup","","1655.616","4.220","-4.308","118.325666","-48.102934","B0.5Ib","B","1","","" }
{ "78678","78918","144294","5987","","The Lup","The","","The","","Lup","","414.430","4.220","-1.300","241.648112","-36.802288","B2.5Vn","B","1","","" }
{ "80327","80569","148184","6118","","7Chi Oph","Chi","7","Chi","","Oph","","525.212","4.220","-1.815","246.755979","-18.456251","B2Vne","B","1","","" }
{ "64189","64394","114710","4983","Gl 502","43Bet Com","Bet","43","Bet","","Com","","29.775","4.230","4.428","197.968562","27.878183","G0V","G","1","","" }
{ "66941","67153","119756","5168","Gl 525.1","1    Cen","","1","","","Cen","","63.282","4.230","2.791","206.422071","-33.043721","F3V","F","1","","" }
{ "68302","68520","122408","5264","","93Tau Vir","Tau","93","Tau","","Vir","","224.935","4.230","0.037","210.411638","1.544532","A3V","A","1","","" }
{ "78861","79101","145389","6023","","11Phi Her","Phi","11","Phi","","Her","","203.975","4.230","0.249","242.192434","44.934906","B9MNp...","B","1","","" }
{ "81602","81852","149324","6163","","Bet Aps","Bet","","Bet","","Aps","","156.957","4.230","0.818","250.771894","-77.517435","K0III","K","1","","" }
{ "1595","1599","1581","77","Gl 17","Zet Tuc","Zet","","Zet","","Tuc","","28.006","4.230","4.561","5.012126","-64.874791","F9V","F","1","","" }
{ "93530","93825","177474","7226","Gl 743.1A","Gam CrA","Gam","","Gam","","CrA","","56.438","4.230","3.039","286.604567","-37.063437","F7IV-V","F","1","","Gl 743.1" }
{ "106916","107259","206936","8316","","Mu  Cep","Mu","","Mu","","Cep","Garnet Star","326156.378","4.230","-15.770","325.876908","58.780046","M2Ia","M","1","","" }
{ "107190","107533","207330","8335","","81Pi 2Cyg","Pi-2","81","Pi","2","Cyg","","1105.615","4.230","-3.421","326.698366","49.309570","B3III","B","1","","" }
{ "37522","37629","62044","2973","","75Sig Gem","Sig","75","Sig","","Gem","","125.060","4.230","1.312","115.828006","28.883510","K1III SB","K","1","","" }
{ "5361","5372","5848","285","","","","","","","Cep","","280.203","4.240","-0.430","17.184193","86.257090","K2II-III","K","1","","" }
{ "11380","11407","15371","721","","Kap Eri","Kap","","Kap","","Eri","","508.032","4.240","-1.722","36.746319","-47.703840","B5IV","B","1","","" }
{ "12737","12770","17081","811","","89Pi  Cet","Pi","89","Pi","","Cet","","392.959","4.240","-1.165","41.030625","-13.858696","B7IV","B","1","","" }
{ "114493","114855","219449","8841","Gl 893.2A","91Psi1Aqr","Psi-1","91","Psi","1","Aqr","","149.819","4.240","0.929","348.972883","-9.087737","K0III","K","1","","Gl 893.2" }
{ "59816","60000","106911","4674","","Bet Cha","Bet","","Bet","","Cha","","298.405","4.240","-0.567","184.587173","-79.312240","B5Vn","B","1","","" }
{ "61124","61317","109358","4785","Gl 475","8Bet CVn","Bet","8","Bet","","CVn","Chara","27.526","4.240","4.608","188.436172","41.357480","G0V","G","1","","" }
{ "80665","80911","148703","6143","","","","","","","Sco","","554.688","4.240","-1.913","247.845561","-34.704366","B2III-IV","B","1","","" }
{ "86298","86565","160613","6581","","56Omi Ser","Omi","56","Omi","","Ser","","173.211","4.240","0.614","265.353643","-12.875307","A2Va","A","1","","" }
{ "107075","107418","207260","8334","","10Nu  Cep","Nu","10","Nu","","Cep","","326156.378","4.250","-15.750","326.362197","61.120806","A2Iavar","A","1","","" }
{ "40959","41075","70272","3275","","31    Lyn","","31","","","Lyn","Alsciaukat","382.364","4.250","-1.095","125.708813","43.188131","K5III","K","1","","" }
{ "5884","5896","7788","377","Gl 55.3A","Kap Tuc","Kap","","Kap","","Tuc","","68.348","4.250","2.643","18.940563","-68.875927","F6IV","F","1","","Gl 55.3" }
{ "19119","19167","25642","1261","","47Lam Per","Lam","47","Lam","","Per","","421.936","4.250","-1.309","61.646032","50.351262","A0IVn","A","1","","" }
{ "21349","21402","29140","1458","","88    Tau","","88","","","Tau","","156.205","4.250","0.849","68.913582","10.160790","A5m","A","1","","" }
{ "21423","21476","29094","1454","","58    Per","","58","","","Per","","797.448","4.250","-2.691","69.172627","41.264808","G8II comp","G","1","","" }
{ "23917","23972","33328","1679","","69Lam Eri","Lam","69","Lam","","Eri","","811.334","4.250","-2.729","77.286596","-8.754081","B2IVn","B","1","","" }
{ "62699","62896","111968","4889","Gl 488.1","","","","","","Cen","","148.591","4.250","0.957","193.359111","-40.178872","A4IV","A","1","","" }
{ "70470","70692","127700","5430","","5    UMi","","5","","","UMi","","358.808","4.250","-0.957","216.881365","75.695993","K4III","K","1","","" }
{ "43939","44066","76756","3572","","65Alp Cnc","Alp","65","Alp","","Cnc","Acubens","188.312","4.260","0.453","134.621755","11.857701","A5m","A","1","","" }
{ "85907","86170","159433","6546","","","","","","","Sco","","165.814","4.260","0.729","264.136816","-38.635308","G8/K0III/IV","G","1","","" }
{ "87994","88267","164668","6729","","95    Her","","95","","","Her","Bodu","417.080","4.260","-1.274","270.376697","21.595782","G5","G","1","","" }
{ "108573","108917","209790","8417","","17Xi  Cep","Xi","17","Xi","","Cep","Kurhah","96.525","4.260","1.904","330.947029","64.627971","Am","A","1","","" }
{ "5423","5434","6811","335","","42Phi And","Phi","42","Phi","","And","","716.827","4.260","-2.450","17.375518","47.241792","B7III","B","1","","" }
{ "8183","8198","10761","510","","110Omi Psc","Omi","110","Omi","","Psc","Torcular","279.483","4.260","-0.405","26.348458","9.157736","K0III","K","1","","" }
{ "15471","15510","20794","1008","Gl 139","","","","","","Eri","82 G. Eri","19.711","4.260","5.354","49.979154","-43.069784","G8V","G","1","","" }
{ "16570","16611","22203","1088","","19Tau5Eri","Tau-5","19","Tau","5","Eri","","293.306","4.260","-0.509","53.446975","-21.632883","B9V","B","1","","" }
{ "19843","19893","27290","1338","Gl 167.1","Gam Dor","Gam","","Gam","","Dor","","66.740","4.260","2.705","64.006459","-51.486648","F4III","F","1","","" }
{ "22730","22783","30614","1542","","9Alp Cam","Alp","9","Alp","","Cam","","326156.378","4.260","-15.740","73.512545","66.342678","O9.5Ia SB:","O","1","","" }
{ "4896","4906","6186","294","","71Eps Psc","Eps","71","Eps","","Psc","","181.804","4.270","0.539","15.735870","7.890135","K0III","K","1","","" }
{ "12795","12828","17094","813","GJ 9099","87Mu  Cet","Mu","87","Mu","","Cet","","84.061","4.270","2.214","41.235582","10.114146","F1III-IV","F","1","","" }
{ "19810","19860","26912","1320","","49Mu  Tau","Mu","49","Mu","","Tau","","455.526","4.270","-1.455","63.883571","8.892357","B3IV","B","1","","" }
{ "21536","21589","29388","1473","","90    Tau","","90","","","Tau","","153.558","4.270","0.906","69.539421","12.510838","A6V","A","1","","" }
{ "21828","21881","29763","1497","","94Tau Tau","Tau","94","Tau","","Tau","","398.237","4.270","-1.164","70.561257","22.956926","B3V","B","1","","" }
{ "115465","115830","220954","8916","","10The Psc","The","10","The","","Psc","","148.523","4.270","0.978","351.992064","6.378992","K1III","K","1","","" }
{ "63801","64004","113791","4942","","Xi 2Cen","Xi-2","","Xi","2","Cen","","467.273","4.270","-1.511","196.727699","-49.906246","B1.5V","B","1","","" }
{ "74682","74911","135734","5683","","Mu  Lup","Mu","","Mu","","Lup","","335.552","4.270","-0.792","229.633458","-47.875272","B8V","B","1","","" }
{ "94999","95294","181623","7343","","Bet2Sgr","Bet-2","","Bet","2","Sgr","Arkab Posterior","134.165","4.270","1.199","290.804644","-44.799778","F2III","F","1","","" }
{ "102201","102532","197964","7948","","12Gam2Del","Gam-2","12","Gam","2","Del","","126.319","4.270","1.330","311.664595","16.124296","K1IV","K","1","","" }
{ "85164","85423","157919","6492","","45    Oph","","45","","","Oph","","111.583","4.280","1.609","261.838635","-29.867033","F3III","F","1","","" }
{ "99336","99655","192696","7740","","33    Cyg","","33","","","Cyg","","159.256","4.280","0.837","303.349319","56.567722","A3IV-Vn","A","1","","" }
{ "105175","105515","203387","8167","","32Iot Cap","Iot","32","Iot","","Cap","","196.717","4.280","0.378","320.561647","-16.834542","G8III","G","1","","" }
{ "109064","109410","210459","8454","","29Pi 2Peg","Pi-2","29","Pi","2","Peg","","263.029","4.280","-0.253","332.496855","33.178224","F5III","F","1","","" }
{ "113770","114131","218227","8787","","The Gru","The","","The","","Gru","","131.887","4.280","1.246","346.719751","-43.520358","F5me...","F","1","","" }
{ "47060","47193","81817","3751","","","","","","","Dra","","994.379","4.280","-3.141","144.272259","81.326382","K3III","K","1","","" }
{ "51027","51172","90610","4104","","Alp Ant","Alp","","Alp","","Ant","","366.056","4.280","-0.971","156.787954","-31.067779","K4III","K","1","","" }
{ "20659","20711","28024","1392","","69Ups Tau","Ups","69","Ups","","Tau","","153.775","4.280","0.913","66.576909","22.813583","A8Vn","A","1","","" }
{ "16811","16852","22484","1101","Gl 147","10    Tau","","10","","","Tau","","45.540","4.290","3.565","54.218263","0.401662","F9V","F","1","","" }
{ "24785","24845","34816","1756","","6Lam Lep","Lam","6","Lam","","Lep","","851.583","4.290","-2.794","79.893852","-13.176788","B0.5IV","B","1","","" }
{ "52003","52154","92449","4180","","","","","","","Vel","","840.609","4.290","-2.766","159.826673","-55.603268","G2II","G","1","","" }
{ "108793","109139","209819","8418","","33Iot Aqr","Iot","33","Iot","","Aqr","","175.165","4.290","0.640","331.609287","-13.869679","B8V","B","1","","" }
{ "110841","111188","213398","8576","","17Bet PsA","Bet","17","Bet","","PsA","","142.800","4.290","1.083","337.876351","-32.346073","A1V","A","1","","" }
{ "116265","116631","222173","8965","","17Iot And","Iot","17","Iot","","And","Rasalnaqa","499.474","4.290","-1.635","354.534147","43.268073","B8V","B","1","","" }
{ "57763","57936","103192","4552","","Bet Hya","Bet","","Bet","","Hya","","309.740","4.290","-0.598","178.227197","-33.908124","Ap Si","A","1","","" }
{ "76819","77055","142105","5903","","16Zet UMi","Zet","16","Zet","","UMi","","368.955","4.290","-0.978","236.014482","77.794493","A3Vn","A","1","","" }
{ "80648","80894","148786","6147","","8Phi Oph","Phi","8","Phi","","Oph","","243.582","4.290","-0.076","247.784870","-16.612733","G8/K0III","G","1","","" }
{ "56478","56647","100920","4471","","91Ups Leo","Ups","91","Ups","","Leo","","181.500","4.300","0.573","174.237211","-0.823749","G9III","G","1","","" }
{ "57496","57669","102776","4537","","","","","","","Cen","","595.176","4.300","-2.006","177.421156","-63.788478","B3V","B","1","","" }
{ "60983","61174","109085","4775","Gl 471.2","8Eta Crv","Eta","8","Eta","","Crv","","59.626","4.300","2.990","188.017655","-16.196007","F2V","F","1","","" }
{ "69846","70069","125288","5358","","","","","","","Cen","","1226.152","4.300","-3.576","215.081447","-56.386497","B6Ib","B","1","","" }
{ "99706","100027","192876","7747","","5Alp1Cap","Alp-1","5","Alp","1","Cap","","569.208","4.300","-1.909","304.411954","-12.508212","G3Ib","G","1","","" }
{ "4567","4577","5737","280","","Alp Scl","Alp","","Alp","","Scl","","776.563","4.300","-2.584","14.651496","-29.357449","B7IIIp","B","1","","" }
{ "11457","11484","15318","718","","73Xi 2Cet","Xi-2","73","Xi","2","Cet","","193.106","4.300","0.438","37.039759","8.460054","B9III","B","1","","" }
{ "17489","17531","23338","1145","","19    Tau","","19","","","Tau","Taygeta","409.230","4.300","-1.193","56.302056","24.467278","B6V","B","1","","" }
{ "17757","17797","24071","1189","","","","","","","Eri","","165.478","4.300","0.773","57.149446","-37.620155","A+...","A","1","","" }
{ "20597","20648","27962","1389","","68Del3Tau","Del-3","68","Del","3","Tau","","148.523","4.300","1.008","66.372419","17.927910","A2IV","A","1","","" }
{ "28333","28404","40239","2091","","35Pi  Aur","Pi","35","Pi","","Aur","","751.512","4.300","-2.513","89.983750","45.936736","M3IIvar","M","1","","" }
{ "42680","42799","74280","3454","","7Eta Hya","Eta","7","Eta","","Hya","","586.612","4.300","-1.975","130.806146","3.398662","B3V...","B","1","","" }
{ "53262","53417","94601","4259","","54    Leo","","54","","","Leo","","286.857","4.300","-0.421","163.903343","24.749718","A1","A","1","","" }
{ "42449","42568","74375","3457","","","","","","","Car","","1443.170","4.310","-3.919","130.154296","-59.761003","B1.5III","B","1","","" }
{ "70415","70638","124882","5339","","Del Oct","Del","","Del","","Oct","","298.952","4.310","-0.501","216.732020","-83.667884","K2III","K","1","","" }
{ "75182","75411","137391","5733","GJ 3903A","51Mu 1Boo","Mu-1","51","Mu","1","Boo","Alkalurops","113.131","4.310","1.609","231.122708","37.377167","F0V","F","1","","GJ 3903" }
{ "78750","78990","144608","5997","","10Ome2Sco","Ome-2","10","Ome","2","Sco","","290.692","4.310","-0.440","241.851356","-20.868764","G6/G8III","G","1","","" }
{ "101519","101847","196574","7884","","71    Aql","","71","","","Aql","","337.287","4.310","-0.763","309.584511","-1.105121","G8III SB","G","1","","" }
{ "84622","84880","156928","6446","","53Nu  Ser","Nu","53","Nu","","Ser","","203.213","4.320","0.347","260.206918","-12.846875","A0/A1V","A","1","","" }
{ "58583","58758","104671","4599","","The1Cru","The-1","","The","1","Cru","","234.983","4.320","0.032","180.756709","-63.312930","Am","A","1","","" }
{ "64037","64241","114378","4968","Gl 501A","42Alp Com","Alp","42","Alp","","Com","Diadem","58.138","4.320","3.065","197.497038","17.529431","F5V","F","1","","Gl 501" }
{ "67455","67669","120709","5210","","3    Cen","","3","","","Cen","","343.684","4.320","-0.794","207.956685","-32.994089","B5","B","1","","" }
{ "72456","72683","130807","5528","","Omi Lup","Omi","","Omi","","Lup","","404.159","4.320","-1.146","222.909620","-43.575359","B5IV","B","1","","" }
{ "16785","16826","22192","1087","","37Psi Per","Psi","37","Psi","","Per","","583.464","4.320","-1.943","54.122386","48.192634","B5Ve","B","1","","" }
{ "21710","21763","29755","1496","","54    Eri","","54","","","Eri","","368.538","4.320","-0.945","70.110460","-19.671493","M3/M4III","M","1","","" }
{ "25880","25945","36389","1845","","119    Tau","","119","","","Tau","","1792.068","4.320","-4.380","83.053129","18.594234","M2Ib","M","1","","" }
{ "29623","29696","43039","2219","","44Kap Aur","Kap","44","Kap","","Aur","","176.970","4.320","0.648","93.844563","29.498076","G8IIIvar","G","1","","" }
{ "42948","43067","74918","3484","","12    Hya","","12","","","Hya","","245.046","4.320","-0.059","131.593907","-13.547720","G8III","G","1","","" }
{ "46617","46750","82308","3773","","4Lam Leo","Lam","4","Lam","","Leo","Alterf","329.119","4.320","-0.700","142.930121","22.967971","K5IIIvar","K","1","","" }
{ "36182","36284","58972","2854","","4Gam CMi","Gam","4","Gam","","CMi","","318.201","4.330","-0.616","112.040812","8.925530","K3III SB","K","1","","" }
{ "84147","84405","155885","6401","Gl 663A","36    Oph","","36","","","Oph","Guniibuu","19.352","4.330","5.464","258.837545","-26.602829","K2:III:","K","1","","Gl 663" }
{ "88589","88866","165040","6745","","Pi  Pav","Pi","","Pi","","Pav","","129.995","4.330","1.328","272.145004","-63.668553","Am","A","1","","" }
{ "89548","89826","168775","6872","","1Kap Lyr","Kap","1","Kap","","Lyr","","251.664","4.330","-0.107","274.965465","36.064547","K2IIIvar","K","1","","" }
{ "62670","62867","111915","4888","","","","","","","Cen","","294.365","4.330","-0.447","193.278876","-48.943315","K3/K4III","K","1","","" }
{ "70353","70576","126354","5396","","Tau2Lup","Tau-2","","Tau","2","Lup","","319.136","4.330","-0.623","216.545039","-45.379276","A7:+...","A","1","","" }
{ "118742","","98231","4375","Gl 423A","53Xi  UMa","Xi","53","Xi","","UMa","Alula Australis","33.975","4.330","4.241","169.546772","31.528783","G0 Ve","G","1","","Gl 423" }
{ "110675","111022","213310","8572","","5    Lac","","5","","","Lac","","1647.254","4.340","-4.177","337.382593","47.706887","M0II","M","1","","" }
{ "85096","85355","157999","6498","","49Sig Oph","Sig","49","Sig","","Oph","","900.984","4.340","-2.866","261.628668","4.140360","K3IIvar","K","1","","" }
{ "91684","91971","173648","7056","","6Zet1Lyr","Zet-1","6","Zet","1","Lyr","","156.130","4.340","0.940","281.193137","37.605115","Am","A","1","","" }
{ "91874","92161","173880","7069","","111    Her","","111","","","Her","","94.238","4.340","2.036","281.755296","18.181519","A5III","A","1","","" }
{ "107005","107348","206859","8313","","9    Peg","","9","","","Peg","","926.581","4.340","-2.927","326.127896","17.350017","G5Ib","G","1","","" }
{ "2906","2912","3369","154","","29Pi  And","Pi","29","Pi","","And","","598.452","4.340","-1.978","9.220199","33.719344","B5V","B","1","","" }
{ "3025","3031","3546","163","","30Eps And","Eps","30","Eps","","And","","163.815","4.340","0.835","9.639023","29.311751","G5III...","G","1","","" }
{ "5530","5542","6961","343","","33The Cas","The","33","The","","Cas","","133.561","4.340","1.279","17.775262","55.149901","A7Vvar","A","1","","" }
{ "27034","27100","39014","2015","","Del Dor","Del","","Del","","Dor","","149.613","4.340","1.032","86.193344","-65.735526","A7V","A","1","","" }
{ "31052","31125","46328","2387","","4Xi 1CMa","Xi-1","4","Xi","1","CMa","","1382.019","4.340","-3.795","97.964028","-23.418422","B1III","B","1","","" }
{ "40773","40888","71701","3340","","The Cha","The","","The","","Cha","","155.312","4.340","0.951","125.161719","-77.484477","K0III-IV","K","1","","" }
{ "45365","45496","80230","3696","","","","","","","Car","","488.258","4.340","-1.536","139.050359","-57.541473","M1III","M","1","","" }
{ "47042","47175","83446","3836","","","","","","","Vel","","105.416","4.340","1.793","144.206587","-49.355026","A5V","A","1","","" }
{ "68305","68523","122223","5260","","Ups2Cen","Ups-2","","Ups","2","Cen","","1269.091","4.340","-3.610","210.431226","-45.603421","F6II","F","1","","" }
{ "76317","76552","139127","5797","","Ome Lup","Ome","","Ome","","Lup","","218.603","4.340","0.209","234.513484","-42.567348","K4.5III","K","1","","" }
{ "60554","60742","108381","4737","","15Gam Com","Gam","15","Gam","","Com","","167.260","4.350","0.800","186.734495","28.268423","K2IIICN+...","K","1","","" }
{ "74628","74857","135758","5686","","2    Lup","","2","","","Lup","","325.831","4.350","-0.648","229.457665","-30.148673","K1II/III","K","1","","" }
{ "14802","14838","19787","951","","57Del Ari","Del","57","Del","","Ari","Botein","169.696","4.350","0.769","47.907332","19.726677","K2IIIvar","K","1","","" }
{ "22456","22509","30739","1544","","2Pi 2Ori","Pi-2","2","Pi","2","Ori","","224.471","4.350","0.161","72.653007","8.900176","A1Vn","A","1","","" }
{ "85560","85822","166205","6789","","23Del UMi","Del","23","Del","","UMi","Yildun","172.114","4.350","0.738","263.053764","86.586460","A1Vn","A","1","","" }
{ "89819","90098","168339","6855","","Xi  Pav","Xi","","Xi","","Pav","","468.616","4.350","-1.437","275.806753","-61.493901","M1III SB","M","1","","" }
{ "94418","94713","180809","7314","","21The Lyr","The","21","The","","Lyr","","832.031","4.350","-2.684","289.092063","38.133731","K0II","K","1","","" }
{ "107037","107380","206742","8305","","9Iot PsA","Iot","9","Iot","","PsA","","204.231","4.350","0.367","326.236693","-33.025781","B9.5V","B","1","","" }
{ "31330","31407","47306","2435","","","","","","","Car","","1364.671","4.350","-3.758","98.744095","-52.975607","B9III","B","1","","" }
{ "33362","33449","50522","2560","","15    Lyn","","15","","","Lyn","","178.325","4.350","0.661","104.319176","58.422759","G5III-IV","G","1","","" }
{ "39681","39794","68520","3223","","Eps Vol","Eps","","Eps","","Vol","","562.339","4.350","-1.833","121.982597","-68.617062","B6IV","B","1","","" }
{ "43113","43234","75137","3492","","13Rho Hya","Rho","13","Rho","","Hya","","354.133","4.350","-0.829","132.108211","5.837812","A0Vn","A","1","","" }
{ "28127","28199","40494","2106","","Gam Col","Gam","","Gam","","Col","","869.750","4.360","-2.770","89.384210","-35.283280","B2.5IV","B","1","","" }
{ "33260","33347","51309","2596","","20Iot CMa","Iot","20","Iot","","CMa","","2508.895","4.360","-5.070","104.034270","-17.054242","B3Ib/II","B","1","","" }
{ "39750","39863","67594","3188","","29Zet Mon","Zet","29","Zet","","Mon","","1058.949","4.360","-3.197","122.148533","-2.983786","G2Ib","G","1","","" }
{ "2478","2484","2884","126","","Bet1Tuc","Bet-1","","Bet","1","Tuc","","135.055","4.360","1.275","7.885870","-62.958218","B9V","B","1","","" }
{ "3398","3405","4150","191","","Eta Phe","Eta","","Eta","","Phe","","246.342","4.360","-0.031","10.838504","-57.463060","A0IV","A","1","","" }
{ "10300","10324","13611","649","","65Xi 1Cet","Xi-1","65","Xi","1","Cet","","383.262","4.360","-0.990","33.249982","8.846717","G8II:","G","1","","" }
{ "16294","16335","21552","1052","","35Sig Per","Sig","35","Sig","","Per","","359.599","4.360","-0.852","52.643680","47.995216","K3III","K","1","","" }
{ "18990","19038","25604","1256","","37    Tau","","37","","","Tau","","187.123","4.360","0.566","61.173797","22.081926","K0III","K","1","","" }
{ "22648","22701","31109","1560","","61Ome Eri","Ome","61","Ome","","Eri","","234.983","4.360","0.072","73.223624","-5.452695","A9IV","A","1","","" }
{ "24270","24327","33949","1705","","4Kap Lep","Kap","4","Kap","","Lep","","728.028","4.360","-2.384","78.307824","-12.941291","B7V","B","1","","" }
{ "68642","68862","122980","5285","","Chi Cen","Chi","","Chi","","Cen","","510.417","4.360","-1.612","211.511549","-41.179633","B2V","B","1","","" }
{ "96165","96468","184930","7447","","41Iot Aql","Iot","41","Iot","","Aql","","391.075","4.360","-1.034","294.180323","-1.286601","B5III","B","1","","" }
{ "88610","88886","166182","6787","","102    Her","","102","","","Her","Ramus","916.170","4.370","-2.873","272.189546","20.814557","B2IV","B","1","","" }
{ "98101","98412","189103","7623","","The1Sgr","The-1","","The","1","Sgr","","518.532","4.370","-1.637","299.934074","-35.276305","B2.5IV","B","1","","" }
{ "154","154","224935","9089","","30    Psc","","30","","","Psc","","431.995","4.370","-1.240","0.490078","-6.014072","M3III","M","1","","" }
{ "29734","29807","43785","2256","","Kap Col","Kap","","Kap","","Col","","182.516","4.370","0.631","94.138065","-35.140519","G8II","G","1","","" }
{ "35317","35415","57061","2782","","30Tau CMa","Tau","30","Tau","","CMa","","2992.260","4.370","-5.443","109.677028","-24.954375","O9Ib","O","1","","" }
{ "53618","53773","95370","4293","","","","","","","Vel","","196.243","4.370","0.473","165.038580","-42.225859","A3IV","A","1","","" }
{ "115304","115669","220704","8906","","99    Aqr","","99","","","Aqr","","283.368","4.380","-0.315","351.511617","-20.642014","K4III","K","1","","" }
{ "115865","116231","221507","8937","","Bet Scl","Bet","","Bet","","Scl","","174.043","4.380","0.744","353.242684","-37.818268","B9.5IVMNpe.","B","1","","" }
{ "98939","99255","192907","7750","","1Kap Cep","Kap","1","Kap","","Cep","","314.823","4.380","-0.543","302.222178","77.711419","B9III","B","1","","" }
{ "64034","64238","114330","4963","","51The Vir","The","51","The","","Vir","","315.737","4.380","-0.549","197.487465","-5.539010","A1V","A","1","","" }
{ "73392","73620","133165","5601","","110    Vir","","110","","","Vir","","195.420","4.390","0.502","225.725155","2.091303","K0III","K","1","","" }
{ "8818","8837","11695","555","","Psi Phe","Psi","","Psi","","Phe","","341.883","4.390","-0.712","28.411524","-46.302669","M4III SB","M","1","","" }
{ "17842","17884","23475","1155","","","","","","","Cam","","795.503","4.390","-2.546","57.380350","65.525972","M1III","M","1","","" }
{ "26111","26176","36822","1876","","37Phi1Ori","Phi-1","37","Phi","1","Ori","","1087.188","4.390","-3.224","83.705154","9.489579","B0IV...","B","1","","" }
{ "27844","27913","39587","2047","Gl 222A","54Chi1Ori","Chi-1","54","Chi","1","Ori","","28.256","4.390","4.702","88.595786","20.276174","G0V","G","1","","Gl 222" }
{ "30346","30419","44769","2298","","8Eps Mon","Eps","8","Eps","","Mon","","122.293","4.390","1.520","95.942023","4.592865","A5IV","A","1","","" }
{ "39200","39311","66141","3145","","","","","","","CMi","","254.016","4.390","-0.067","120.566404","2.334571","K2III","K","1","","" }
{ "49496","49637","87837","3980","","31    Leo","","31","","","Leo","Yunu","295.431","4.390","-0.395","151.976131","9.997508","K4III","K","1","","" }
{ "82421","82673","152614","6281","","25Iot Oph","Iot","25","Iot","","Oph","","245.230","4.390","0.009","253.501966","10.165359","B8V","B","1","","" }
{ "84636","84893","156897","6445","Gl 670A","40Xi  Oph","Xi","40","Xi","","Oph","","56.605","4.390","3.193","260.251513","-21.112933","F2/F3V","F","1","","Gl 670" }
{ "96450","96757","185758","7479","","5Alp Sge","Alp","5","Alp","","Sge","Sham","425.236","4.390","-1.186","295.024130","18.013890","G0II","G","1","","" }
{ "96530","96837","185958","7488","","6Bet Sge","Bet","6","Bet","","Sge","","439.564","4.390","-1.258","295.262245","17.476041","G8II","G","1","","" }
{ "104979","105319","202730","8140","GJ 9733A","The Ind","The","","The","","Ind","","98.775","4.390","1.984","319.966443","-53.449427","A5V","A","1","","GJ 9733" }
{ "92723","93015","174694","7107","","Kap Pav","Kap","","Kap","","Pav","","500.240","4.400","-1.529","284.237650","-67.233495","F5Ib-II:","F","1","","" }
{ "108086","108431","208450","8368","","Del Ind","Del","","Del","","Ind","","188.095","4.400","0.595","329.479400","-54.992575","F0IV","F","1","","" }
{ "4453","4463","5516","271","","38Eta And","Eta","38","Eta","","And","Kui","229.687","4.400","0.161","14.301676","23.417648","G8III-IV","G","1","","" }
{ "37962","38070","63462","3034","","Omi Pup","Omi","","Omi","","Pup","","1418.071","4.400","-3.791","117.021537","-25.937169","B1IV:nne","B","1","","" }
{ "39793","39906","67797","3192","","16    Pup","","16","","","Pup","","465.273","4.400","-1.371","122.256823","-19.245014","B5V","B","1","","" }
{ "32675","32761","50337","2554","","","","","","","Car","","544.501","4.410","-1.703","102.463811","-53.622449","G6II","G","1","","" }
{ "34601","34693","54719","2697","","46Tau Gem","Tau","46","Tau","","Gem","","321.020","4.410","-0.556","107.784889","30.245163","K2III","K","1","","" }
{ "85433","85693","158899","6526","","76Lam Her","Lam","76","Lam","","Her","Maasym","369.373","4.410","-0.860","262.684619","26.110645","K3IIIvar","K","1","","" }
{ "87726","87998","164136","6707","","94Nu  Her","Nu","94","Nu","","Her","","860.571","4.410","-2.697","269.625622","30.189277","F2II","F","1","","" }
{ "104800","105138","202904","8146","","66Ups Cyg","Ups","66","Ups","","Cyg","","642.040","4.410","-2.061","319.479478","34.896898","B2Vne","B","1","","" }
{ "113861","114222","218658","8819","","33Pi  Cep","Pi","33","Pi","","Cep","","246.714","4.410","0.016","346.974339","75.387496","G2III","G","1","","" }
{ "114670","115033","219688","8858","","93Psi2Aqr","Psi-2","93","Psi","2","Aqr","","401.670","4.410","-1.042","349.475896","-9.182513","B5Vn","B","1","","" }
{ "114740","115102","219784","8863","GJ 9821","Gam Scl","Gam","","Gam","","Scl","","182.210","4.410","0.674","349.705992","-32.532027","K1III","K","1","","" }
{ "70077","70300","125823","5378","","","","","","","Cen","","457.442","4.410","-1.325","215.759346","-39.511819","B2V","B","1","","" }
{ "72345","72571","130694","5526","","58    Hya","","58","","","Hya","Solitaire","331.123","4.420","-0.613","222.572201","-27.960371","K3III","K","1","","" }
{ "77022","77257","141004","5868","Gl 598","27Lam Ser","Lam","27","Lam","","Ser","","39.544","4.420","4.002","236.610893","7.353073","G0Vvar","G","1","","" }
{ "110192","110538","212496","8538","","3Bet Lac","Bet","3","Bet","","Lac","","169.962","4.420","0.835","335.890118","52.229046","G9III","G","1","","" }
{ "115258","115623","220657","8905","","68Ups Peg","Ups","68","Ups","","Peg","Alkarab","170.406","4.420","0.830","351.344891","23.404101","F8IV","F","1","","" }
{ "28966","29038","41753","2159","","67Nu  Ori","Nu","67","Nu","","Ori","","516.070","4.420","-1.576","91.893020","14.768472","B3IV","B","1","","" }
{ "31620","31700","47442","2443","","8Nu 3CMa","Nu-3","8","Nu","3","CMa","","421.391","4.420","-1.136","99.472591","-18.237478","K0II/III","K","1","","" }
{ "34828","34922","56096","2748","","","","","","","Pup","","208.941","4.420","0.387","108.384556","-44.639739","M5e","M","1","","" }
{ "34887","34981","56014","2745","","27    CMa","","27","","","CMa","","1734.874","4.420","-4.209","108.563385","-26.352507","B3III","B","1","","" }
{ "40211","40326","69142","3243","","","","","","","Pup","","298.405","4.420","-0.387","123.512138","-40.347890","K1II/III","K","1","","" }
{ "53798","53954","95608","4300","","60    Leo","","60","","","Leo","","126.761","4.420","1.472","165.582398","20.179842","A1m","A","1","","" }
{ "88018","88290","164577","6723","","68    Oph","","68","","","Oph","","292.517","4.420","-0.344","270.438327","1.305076","A2Vn","A","1","","" }
{ "94186","94481","180163","7298","","20Eta Lyr","Eta","20","Eta","","Lyr","Aladfar","1387.899","4.430","-3.715","288.439532","39.145968","B2.5IV","B","1","","" }
{ "98375","98688","189763","7650","","62    Sgr","","62","","","Sgr","","448.633","4.430","-1.262","300.664492","-27.709845","M4III","M","1","","" }
{ "100260","100587","194317","7806","","39    Cyg","","39","","","Cyg","","249.928","4.430","0.008","305.965070","32.190172","K3III","K","1","","" }
{ "101950","102281","197461","7928","","11Del Del","Del","11","Del","","Del","","223.242","4.430","0.253","310.864726","15.074581","A7IIIp d Del","A","1","","" }
{ "102293","102624","198026","7951","","3    Aqr","","3","","","Aqr","","585.559","4.430","-1.841","311.934316","-5.027701","M3IIIvar","M","1","","" }
{ "17551","17593","23614","1162","","26Pi  Eri","Pi","26","Pi","","Eri","","481.057","4.430","-1.414","56.535562","-12.101589","M1III","M","1","","" }
{ "19799","19849","26965","1325","Gl 166A","40Omi2Eri","Omi-2","40","Omi","2","Eri","Keid","16.257","4.430","5.942","63.818049","-7.652871","K1V","K","1","","Gl 166" }
{ "22987","23040","31278","1568","","7    Cam","","7","","","Cam","","371.900","4.430","-0.855","74.321693","53.752101","A1V","A","1","","" }
{ "1169","1170","1038","48","","7    Cet","","7","","","Cet","","447.402","4.440","-1.246","3.660070","-18.932866","M1III","M","1","","" }
{ "3778","3786","4656","224","","63Del Psc","Del","63","Del","","Psc","","311.218","4.440","-0.458","12.170599","7.585079","K5III","K","1","","" }
{ "19871","19921","27442","1355","Gl 167.3","Eps Ret","Eps","","Eps","","Ret","","59.485","4.440","3.135","64.121065","-59.302156","K2IV","K","1","","" }
{ "21717","21770","29875","1502","Gl 174.1A","Alp Cae","Alp","","Alp","","Cae","","65.771","4.440","2.917","70.140586","-41.863752","F2V","F","1","","Gl 174.1" }
{ "29987","30060","43378","2238","","2    Lyn","","2","","","Lyn","","156.580","4.440","1.033","94.905786","59.010964","A2Vs","A","1","","" }
{ "36689","36795","60532","2906","Gl 279","","","","","","Pup","","82.508","4.440","2.425","113.513260","-22.296067","F6V","F","1","","" }
{ "39978","40091","68553","3225","","","","","","","Pup","","1698.731","4.440","-4.143","122.839562","-39.618545","K4III","K","1","","" }
{ "40591","40706","70060","3270","GJ 1109","","","","","","Pup","","93.374","4.440","2.156","124.638868","-36.659288","A4m...","A","1","","" }
{ "70895","71121","127381","5425","","Sig Lup","Sig","","Sig","","Lup","","575.232","4.440","-1.792","218.154442","-50.457157","B2III","B","1","","" }
{ "95473","95771","183439","7405","","6Alp Vul","Alp","6","Alp","","Vul","Anser","297.317","4.440","-0.359","292.176405","24.664905","M0 comp","M","1","","" }
{ "94352","94648","181984","7352","","60Tau Dra","Tau","60","Tau","","Dra","","146.390","4.450","1.190","288.888440","73.355468","K3III","K","1","","" }
{ "95927","96229","184406","7429","GJ 9661","38Mu  Aql","Mu","38","Mu","","Aql","","107.607","4.450","1.858","293.522299","7.378941","K3III","K","1","","" }
{ "29353","29426","42560","2199","","70Xi  Ori","Xi","70","Xi","","Ori","","607.367","4.450","-1.900","92.984983","14.208765","B3IV","B","1","","" }
{ "42283","42402","73471","3418","","5Sig Hya","Sig","5","Sig","","Hya","Minchir","372.750","4.450","-0.840","129.689323","3.341435","K2III","K","1","","" }
{ "44064","44191","77258","3591","","","","","","","Vel","","210.423","4.450","0.402","135.022568","-41.253605","Fp","F","1","","" }
{ "51700","51849","91942","4159","","","","","","","Car","","1177.460","4.450","-3.338","158.897106","-57.557636","K3/K4II","K","1","","" }
{ "52481","52633","93845","4234","","Del2Cha","Del-2","","Del","2","Cha","","350.706","4.450","-0.708","161.446308","-80.540188","B2.5IV","B","1","","" }
{ "54921","55084","98058","4368","","74Phi Leo","Phi","74","Phi","","Leo","","184.165","4.450","0.691","169.165420","-3.651601","A7IVn","A","1","","" }
{ "7869","7884","10380","489","","106Nu  Psc","Nu","106","Nu","","Psc","","363.203","4.450","-0.784","25.357893","5.487613","K3III","K","1","","" }
{ "13114","13147","17652","841","","Bet For","Bet","","Bet","","For","","172.661","4.450","0.831","42.272542","-32.405898","G8III","G","1","","" }
{ "24187","24244","33802","1696","","3Iot Lep","Iot","3","Iot","","Lep","","231.810","4.450","0.191","78.074591","-11.869219","B8V","B","1","","" }
{ "80729","80975","148898","6153","","9Ome Oph","Ome","9","Ome","","Oph","","168.643","4.450","0.882","248.034160","-21.466390","Ap","A","1","","" }
{ "58994","59173","105382","4618","","","","","","","Cen","","438.382","4.460","-1.182","182.021818","-50.661278","B2IIIne","B","1","","" }
{ "80339","80582","147971","6115","","Eps Nor","Eps","","Eps","","Nor","","530.335","4.460","-1.596","246.795999","-47.554786","B4V","B","1","","" }
{ "44773","44901","78209","3619","GJ 3534","15    UMa","","15","","","UMa","","93.993","4.460","2.162","137.217938","51.604648","Am","A","1","","" }
{ "54522","54682","97277","4343","Gl 416.1","11Bet Crt","Bet","11","Bet","","Crt","","340.101","4.460","-0.631","167.914537","-22.825847","A1V","A","1","","" }
{ "112588","112948","216336","8695","GJ 9800A","22Gam PsA","Gam","22","Gam","","PsA","","215.427","4.460","0.361","343.131410","-32.875504","A0III","A","1","","GJ 9800" }
{ "11542","11569","15089","707","","Iot Cas","Iot","","Iot","","Cas","","132.854","4.460","1.410","37.266549","67.402474","A5p Sr","A","1","","" }
{ "18210","18255","24554","1211","","32    Eri","","32","","","Eri","","313.010","4.460","-0.451","58.572925","-2.954730","G8III","G","1","","" }
{ "24274","24331","33856","1698","","17Rho Ori","Rho","17","Rho","","Ori","","349.953","4.460","-0.693","78.322839","2.861265","K3III...","K","1","","" }
{ "12810","12843","17206","818","Gl 111","1Tau1Eri","Tau-1","1","Tau","1","Eri","","46.382","4.470","3.705","41.275727","-18.572563","F5/F6V","F","1","","" }
{ "15510","15549","20644","999","","","","","","","Ari","","542.690","4.470","-1.636","50.084839","29.048458","K2II-III","K","1","","" }
{ "23069","23123","31767","1601","","10Pi 6Ori","Pi-6","10","Pi","6","Ori","","945.381","4.470","-2.841","74.637091","1.714016","K2IIvar","K","1","","" }
{ "30715","30788","45813","2361","","Lam CMa","Lam","","Lam","","CMa","","423.580","4.470","-1.098","97.042539","-32.580070","B4V","B","1","","" }
{ "31139","31216","46300","2385","","13    Mon","","13","","","Mon","","326156.378","4.470","-15.530","98.225947","7.332965","A0Ib","A","1","","" }
{ "38847","38957","65818","3129","","","","","","","Pup","","959.283","4.470","-2.873","119.560165","-49.244912","B1Vp + B2","B","1","","" }
{ "44471","44599","78791","3643","","","","","","","Car","","400.683","4.470","-0.977","136.286772","-72.602705","F6II-III","F","1","","" }
{ "46014","46146","81146","3731","","1Kap Leo","Kap","1","Kap","","Leo","","201.331","4.470","0.518","141.163588","26.182324","K2III","K","1","","" }
{ "46873","47006","82621","3799","","26    UMa","","26","","","UMa","","262.184","4.470","-0.056","143.706070","52.051477","A2V","A","1","","" }
{ "104520","104858","202275","8123","Gl 822A","7Del Equ","Del","7","Del","","Equ","","60.299","4.470","3.136","318.620061","10.006981","F5V+...","F","1","","Gl 822" }
{ "108765","109111","209688","8411","","Lam Gru","Lam","","Lam","","Gru","","242.135","4.470","0.117","331.528706","-39.543353","M0III","M","1","","" }
{ "57630","57803","102964","4546","","","","","","","Cen","","433.143","4.470","-1.146","177.786289","-45.173470","K4III","K","1","","" }
{ "71058","71284","128167","5447","Gl 557","28Sig Boo","Sig","28","Sig","","Boo","","51.640","4.470","3.472","218.670001","29.745130","F3Vwvar","F","1","","" }
{ "72938","73165","132052","5570","GJ 9503","16    Lib","","16","","","Lib","","87.747","4.470","2.321","224.295832","-4.346462","F0V","F","1","","" }
{ "75094","75323","136415","5704","","Gam Cir","Gam","","Gam","","Cir","","448.633","4.480","-1.212","230.844382","-59.320787","B5III + F8","B","1","","" }
{ "80101","80343","147700","6104","","4Psi Oph","Psi","4","Psi","","Oph","","199.484","4.480","0.548","246.025769","-20.037327","K0III","K","1","","" }
{ "3496","3504","4180","193","","22Omi Cas","Omi","22","Omi","","Cas","","702.923","4.480","-2.187","11.181302","48.284364","B5III","B","1","","" }
{ "18697","18744","25705","1264","","Gam Ret","Gam","","Gam","","Ret","","469.290","4.480","-1.310","60.224192","-62.159284","M4III","M","1","","" }
{ "20661","20713","28052","1394","","71    Tau","","71","","","Tau","","160.116","4.480","1.025","66.586411","15.618265","F0V...","F","1","","" }
{ "32492","32578","49293","2506","","18    Mon","","18","","","Mon","","368.122","4.480","-0.783","101.965205","2.412159","K0III","K","1","","" }
{ "49500","49641","87887","3981","","15Alp Sex","Alp","15","Alp","","Sex","","283.368","4.480","-0.215","151.984501","-0.371637","A0III","A","1","","" }
{ "113529","113889","217891","8773","","4Bet Psc","Bet","4","Bet","","Psc","Fumalsamakah","408.206","4.480","-1.007","345.969225","3.820045","B6Ve","B","1","","" }
{ "113757","114119","218240","8789","","86    Aqr","","86","","","Aqr","","216.284","4.480","0.372","346.670175","-23.743115","G8III","G","1","","" }
{ "116562","116928","222603","8984","","18Lam Psc","Lam","18","Lam","","Psc","","106.622","4.490","1.918","355.511692","1.780041","A7V","A","1","","" }
{ "116605","116971","222661","8988","GJ 9836A","105Ome2Aqr","Ome-2","105","Ome","2","Aqr","","148.523","4.490","1.198","355.680592","-14.544905","B9V","B","1","","GJ 9836" }
{ "117954","118322","224686","9076","","Eps Tuc","Eps","","Eps","","Tuc","","373.177","4.490","-0.802","359.978910","-65.577132","B9IV","B","1","","" }
{ "9460","9480","12111","575","","48    Cas","","48","","","Cas","","115.006","4.490","1.754","30.489658","70.907020","A3IV","A","1","","" }
{ "21195","21248","29085","1453","","50Ups1Eri","Ups-1","50","Ups","1","Eri","","127.057","4.490","1.537","68.377345","-29.766492","K0III","K","1","","" }
{ "96138","96441","185395","7469","Gl 765A","13The Cyg","The","13","The","","Cyg","","59.801","4.490","3.174","294.110573","50.221103","F4V","F","1","","Gl 765" }
{ "103899","104234","200914","8080","","24    Cap","","24","","","Cap","","456.163","4.490","-1.238","316.781956","-25.005853","K5/M0III","K","1","","" }
{ "106967","107310","206826","8309","Gl 836.6A","78Mu 1Cyg","Mu-1","78","Mu","1","Cyg","","72.527","4.490","2.755","326.035651","28.742632","F6V","F","1","","Gl 836.6" }
{ "71536","71762","129174","5475","","29Pi 1Boo","Pi-1","29","Pi","1","Boo","","305.676","4.490","-0.369","220.181527","16.418324","B9p MnHg","B","1","","" }
{ "32164","32249","48433","2478","","30    Gem","","30","","","Gem","","288.890","4.490","-0.247","100.997053","13.228017","K1III","K","1","","" }
{ "34741","34834","55892","2740","Gl 268.1","","","","","","Pup","","69.886","4.490","2.835","108.140257","-46.759305","F0IV","F","1","","" }
{ "38343","38455","64503","3084","","","","","","","Pup","","648.422","4.490","-2.002","118.161032","-38.862812","B2V","B","1","","" }
{ "49451","49593","87696","3974","Gl 378.3","21    LMi","","21","","","LMi","","92.109","4.490","2.236","151.857312","35.244693","A7V","A","1","","" }
{ "42986","43105","75311","3498","","","","","","","Car","","605.114","4.500","-1.842","131.677307","-56.769776","B3Vne","B","1","","" }
{ "50532","50676","89890","4074","","","","","","","Vel","","1148.438","4.500","-3.233","155.228351","-56.043220","B3III","B","1","","" }
{ "99554","99874","192806","7744","","23    Vul","","23","","","Vul","","338.688","4.500","-0.582","303.942239","27.814242","K3III","K","1","","" }
{ "104122","104459","201381","8093","","13Nu  Aqr","Nu","13","Nu","","Aqr","","159.334","4.500","1.056","317.398527","-11.371693","G8III","G","1","","" }
{ "105698","106039","204381","8213","","36    Cap","","36","","","Cap","","171.121","4.500","0.901","322.180809","-21.807180","K0III","K","1","","" }
{ "108939","109285","210049","8431","","14Mu  PsA","Mu","14","Mu","","PsA","","135.842","4.500","1.402","332.095832","-32.988468","A2V","A","1","","" }
{ "109408","109754","211073","8485","","","","","","","Lac","","482.480","4.500","-1.350","333.469680","39.714927","K3III","K","1","","" }
{ "111591","111944","214868","8632","","11    Lac","","11","","","Lac","","332.813","4.500","-0.544","340.128488","44.276305","K3III","K","1","","" }
{ "26529","26594","37490","1934","","47Ome Ori","Ome","47","Ome","","Ori","","1382.019","4.500","-3.635","84.796443","4.121467","B3IIIe","B","1","","" }
{ "27461","27530","39523","2042","","Gam Pic","Gam","","Gam","","Pic","","176.778","4.500","0.830","87.456768","-56.166663","K1III","K","1","","" }
{ "57392","57565","102509","4527","","93    Leo","","93","","","Leo","","232.637","4.500","0.234","176.996423","20.218931","A comp SB","A","1","","" }
{ "67063","67275","120136","5185","Gl 527A","4Tau Boo","Tau","4","Tau","","Boo","","50.938","4.500","3.532","206.815652","17.456906","F7V","F","1","","Gl 527" }
{ "76616","76852","140159","5842","","21Iot Ser","Iot","21","Iot","","Ser","","190.068","4.510","0.683","235.387739","19.670401","A1V","A","1","","" }
{ "110492","110838","212581","8540","","Del Tuc","Del","","Del","","Tuc","","250.890","4.510","0.080","336.832971","-64.966354","B8V","B","1","","" }
{ "117495","117863","224014","9045","","7Rho Cas","Rho","7","Rho","","Cas","","326156.378","4.510","-15.490","358.595977","57.499382","F8Iavar","F","1","","" }
{ "46382","46515","82150","3765","","Eps Ant","Eps","","Eps","","Ant","","710.580","4.510","-2.181","142.311346","-35.951335","K3III","K","1","","" }
{ "47257","47391","83944","3856","","","","","","","Car","","225.714","4.510","0.309","144.837586","-61.328060","B9V","B","1","","" }
{ "98389","98702","190940","7685","","67Rho Dra","Rho","67","Rho","","Dra","","428.589","4.510","-1.083","300.704403","67.873565","K3III","K","1","","" }
{ "102002","102333","197157","7920","GJ 4158","Eta Ind","Eta","","Eta","","Ind","","78.839","4.510","2.593","311.009489","-51.920971","A6:var","A","1","","" }
{ "106381","106723","205637","8260","","39Eps Cap","Eps","39","Eps","","Cap","","1055.522","4.510","-3.040","324.270127","-19.466011","B3V:p","B","1","","" }
{ "1470","1473","1404","68","","25Sig And","Sig","25","Sig","","And","","134.775","4.510","1.429","4.581944","36.785224","A2V","A","1","","" }
{ "5574","5586","7106","352","","83Tau Psc","Tau","83","Tau","","Psc","","168.818","4.510","0.940","17.915125","30.089638","K0III-IV...","K","1","","" }
{ "27414","27483","38656","1995","","29Tau Aur","Tau","29","Tau","","Aur","","206.821","4.510","0.499","87.293512","39.181071","G8III","G","1","","" }
{ "13028","13061","17361","824","","39    Ari","","39","","","Ari","Lilii Borea","171.571","4.520","0.915","41.977200","29.247118","K1III","K","1","","" }
{ "65066","65271","116087","5035","","","","","","","Cen","","354.518","4.520","-0.661","200.658162","-60.988393","B3V","B","1","","" }
{ "65182","65387","116243","5041","","","","","","","Cen","","260.301","4.520","0.010","201.001918","-64.535668","G5III-IV","G","1","","" }
{ "69751","69974","125337","5359","","100Lam Vir","Lam","100","Lam","","Vir","Khambalia","186.482","4.520","0.734","214.777466","-13.371095","A1V","A","1","","" }
{ "73517","73745","133582","5616","","43Psi Boo","Psi","43","Psi","","Boo","","245.970","4.520","0.133","226.111476","26.947649","K2III","K","1","","" }
{ "110757","111104","213420","8579","","6    Lac","","6","","","Lac","","1716.613","4.520","-4.086","337.621918","43.123376","B2IV","B","1","","" }
{ "88835","89112","166063","6783","","Eps Tel","Eps","","Eps","","Tel","","418.149","4.520","-1.020","272.807361","-45.954418","G5III","G","1","","" }
{ "94881","95176","181615","7342","","46Ups Sgr","Ups","46","Ups","","Sgr","","1782.275","4.520","-4.168","290.431762","-15.955018","F2p","F","1","","" }
{ "102100","102431","198084","7955","GJ 9706","","","","","","Cep","","89.017","4.520","2.340","311.338166","57.579725","F8IV-V","F","1","","" }
{ "105798","106140","204724","8225","","2    Peg","","2","","","Peg","","393.909","4.520","-0.890","322.487057","23.638838","M1III","M","1","","" }
{ "85106","85365","157950","6493","","","","","","","Oph","","98.092","4.530","2.139","261.657840","-5.086596","F3V","F","1","","" }
{ "86803","87072","161592","6616","","3    Sgr","","3","","","Sgr","","985.367","4.530","-2.871","266.890104","-27.830788","F7II","F","1","","" }
{ "102258","102589","198183","7963","","54Lam Cyg","Lam","54","Lam","","Cyg","","769.237","4.530","-2.333","311.852231","36.490717","B6IV","B","1","","" }
{ "69261","69483","124675","5329","","17Kap2Boo","Kap-2","17","Kap","2","Boo","","163.405","4.530","1.031","213.370773","51.789965","A8IV","A","1","","" }
{ "28342","28413","40657","2113","","","","","","","Ori","","420.847","4.530","-1.023","90.013956","-3.074253","K2IIIvar","K","1","","" }
{ "36990","37096","61330","2937","","","","","","","Pup","","360.394","4.530","-0.687","114.342133","-34.968530","B8IV/V","B","1","","" }
{ "2479","2487","2885","127","","Bet2Tuc","Bet-2","","Bet","2","Tuc","","168.469","4.530","0.965","7.889194","-62.965561","A2V","A","1","","" }
{ "3871","3881","4727","226","","35Nu  And","Nu","35","Nu","","And","","617.720","4.530","-1.857","12.453512","41.078911","B5V SB","B","1","","" }
{ "114208","114570","219080","8830","Gl 891.1","7    And","","7","","","And","Honores","80.196","4.530","2.576","348.137397","49.406207","F0V","F","1","","" }
{ "113783","114144","218329","8795","","55    Peg","","55","","","Peg","","328.787","4.540","-0.477","346.751082","9.409492","M2III","M","1","","" }
{ "115554","115919","221115","8923","","70    Peg","","70","","","Peg","","174.883","4.540","0.893","352.288729","12.760554","G8III","G","1","","" }
{ "31339","31416","46933","2414","","5Xi 2CMa","Xi-2","5","Xi","2","CMa","","441.348","4.540","-1.117","98.764115","-22.964793","A0III","A","1","","" }
{ "46643","46776","82446","3787","","32Tau2Hya","Tau-2","32","Tau","2","Hya","","517.709","4.540","-1.463","142.995534","-1.184664","A3V","A","1","","" }
{ "46819","46952","82635","3800","","10    LMi","","10","","","LMi","","185.001","4.540","0.771","143.555754","36.397558","G8III","G","1","","" }
{ "46844","46977","82210","3771","Gl 355.1","24    UMa","","24","","","UMa","","104.137","4.540","2.019","143.620544","69.830343","G4III-IV","G","1","","" }
{ "97851","98162","188603","7604","","59    Sgr","","59","","","Sgr","","832.031","4.540","-2.494","299.236793","-27.169899","K3III","K","1","","" }
{ "72432","72659","131156","5544","Gl 566A","37Xi  Boo","Xi","37","Xi","","Boo","","21.893","4.540","5.406","222.847389","19.100460","G8V + K4V","G","1","","Gl 566" }
{ "74164","74392","134759","5652","","24Iot1Lib","Iot-1","24","Iot","1","Lib","","379.693","4.540","-0.790","228.055381","-19.791710","Asp...","A","1","","" }
{ "75075","75304","136664","5712","","Phi2Lup","Phi-2","","Phi","2","Lup","","519.357","4.540","-1.470","230.788969","-36.858489","B4V","B","1","","" }
{ "24667","24727","34334","1726","","16    Aur","","16","","","Aur","","232.305","4.540","0.277","79.544023","33.371613","K3III...","K","1","","" }
{ "300","301","225132","9098","","2    Cet","","2","","","Cet","","272.251","4.550","-0.058","0.934954","-17.335988","B9IVn","B","1","","" }
{ "16241","16281","21389","1040","","","","","","","Cam","","2508.895","4.550","-4.880","52.478103","58.878750","A0Ia SB:","A","1","","" }
{ "23540","23595","32831","1652","","Gam1Cae","Gam-1","","Gam","1","Cae","","181.299","4.550","0.825","76.101606","-35.482978","K2III","K","1","","" }
{ "88562","88839","165634","6766","","","","","","","Sgr","","339.040","4.550","-0.534","272.020739","-28.457093","K0IIICNpvar","K","1","","" }
{ "106776","107119","206952","8317","","11    Cep","","11","","","Cep","","182.414","4.550","0.812","325.479774","71.311417","K0III","K","1","","" }
{ "110005","110351","212120","8523","","2    Lac","","2","","","Lac","","554.688","4.550","-1.603","335.256420","46.536569","B6V","B","1","","" }
{ "110263","110609","212593","8541","","4    Lac","","4","","","Lac","","2249.354","4.550","-4.643","336.129136","49.476392","B9Iab","B","1","","" }
{ "33607","33694","49878","2527","","","","","","","Cam","","183.750","4.550","0.796","105.016211","76.977408","K4III","K","1","","" }
{ "36322","36425","59294","2864","","6    CMi","","6","","","CMi","","572.204","4.550","-1.671","112.449095","12.006564","K2III","K","1","","" }
{ "48265","48402","85235","3894","","30Phi UMa","Phi","30","Phi","","UMa","","508.824","4.550","-1.416","148.026490","54.064332","A3IV","A","1","","" }
{ "76137","76371","138769","5781","","","","","","","Lup","","428.027","4.550","-1.040","233.971887","-44.958389","B3IVp","B","1","","" }
{ "79837","80079","147084","6081","","19Omi Sco","Omi","19","Omi","","Sco","","879.128","4.550","-2.603","245.159087","-24.169320","A4II/III","A","1","","" }
{ "70351","70574","126341","5395","","Tau1Lup","Tau-1","","Tau","1","Lup","","1090.824","4.560","-3.062","216.534280","-45.221424","B2IV","B","1","","" }
{ "13294","13328","17709","843","","17    Per","","17","","","Per","","467.273","4.560","-1.221","42.878485","35.059741","K5III","K","1","","" }
{ "18550","18597","25422","1247","","Del Ret","Del","","Del","","Ret","","526.059","4.560","-1.478","59.686430","-61.400185","M2III","M","1","","" }
{ "85829","86092","159217","6537","","1Sig Ara","Sig","1","Sig","","Ara","","378.372","4.560","-0.762","263.914986","-46.505684","A0V","A","1","","" }
{ "102673","103004","198809","7995","GJ 4168","31    Vul","","31","","","Vul","","188.530","4.560","0.750","313.032014","27.096979","G8III","G","1","","" }
{ "103859","104194","201251","8089","","63    Cyg","","63","","","Cyg","","1032.140","4.560","-2.942","316.650383","47.648403","K4II","K","1","","" }
{ "27761","27830","39357","2034","","136    Tau","","136","","","Tau","","423.030","4.560","-1.005","88.331857","27.612262","A0V","A","1","","" }
{ "44572","44700","77912","3612","","","","","","","Lyn","","817.435","4.560","-2.435","136.632381","38.452215","G8Ib-II","G","1","","" }
{ "54789","54951","97778","4362","","72    Leo","","72","","","Leo","","959.283","4.560","-2.783","168.800959","23.095502","M3III","M","1","","" }
{ "16829","16870","22663","1106","","","","","","","Eri","","230.825","4.570","0.321","54.273665","-40.274545","K0III","K","1","","" }
{ "80221","80463","148112","6117","","24Ome Her","Ome","24","Ome","","Her","Cujam","250.120","4.570","0.146","246.353969","14.033270","B9p Cr","B","1","","" }
{ "80232","80473","147933","6112","","5Rho Oph","Rho","5","Rho","","Oph","","361.192","4.570","-0.652","246.396324","-23.447178","B2V","B","1","","" }
{ "86347","86614","162003","6636","Gl 694.1A","31Psi1Dra","Psi-1","31","Psi","1","Dra","Dziban","74.482","4.570","2.777","265.484677","72.148843","F5IV-V","F","1","","Gl 694.1" }
{ "92527","92818","175492","7133","","113    Her","","113","","","Her","","472.006","4.570","-1.233","283.687020","22.645076","G4III+...","G","1","","" }
{ "93710","94005","177873","7242","","Del CrA","Del","","Del","","CrA","","178.520","4.570","0.879","287.087337","-40.496703","K1III","K","1","","" }
{ "97575","97886","188260","7592","","13    Vul","","13","","","Vul","","334.519","4.570","-0.485","298.365392","24.079614","B9.5III","B","1","","" }
{ "86019","86284","159975","6567","","57Mu  Oph","Mu","57","Mu","","Oph","","754.992","4.580","-2.243","264.461304","-8.118771","B8II-IIIMNp","B","1","","" }
{ "26172","26237","37018","1892","","42    Ori","","42","","","Ori","","883.893","4.580","-2.585","83.846517","-4.838358","B2III...","B","1","","" }
{ "114887","115250","220061","8880","","62Tau Peg","Tau","62","Tau","","Peg","Salm","161.704","4.580","1.104","350.159337","23.740337","A5V","A","1","","" }
{ "48237","48374","85622","3912","","","","","","","Vel","","1055.522","4.580","-2.970","147.919475","-46.547620","G5Ib","G","1","","" }
{ "52317","52468","93070","4200","","","","","","","Car","","1140.407","4.580","-3.138","160.884578","-60.566619","K3Ib","K","1","","" }
{ "64220","64425","114529","4975","","","","","","","Cen","","378.811","4.580","-0.745","198.073386","-59.920579","B8V","B","1","","" }
{ "67414","67627","121130","5226","","10    Dra","","10","","","Dra","","371.476","4.580","-0.703","207.858076","64.723272","M3III","M","1","","" }
{ "79164","79404","145482","6028","","13    Sco","","13","","","Sco","","478.937","4.580","-1.254","243.075857","-27.926372","B2V","B","1","","" }
{ "77276","77512","141714","5889","","10Del CrB","Del","10","Del","","CrB","","170.050","4.590","1.004","237.398547","26.068394","G5III-IV","G","1","","" }
{ "77604","77840","142114","5904","","2    Sco","","2","","","Sco","","502.552","4.590","-1.349","238.403000","-25.327142","B2.5Vn","B","1","","" }
{ "117085","117452","223352","9016","","Del Scl","Del","","Del","","Scl","","137.445","4.590","1.466","357.231409","-28.130268","A0V","A","1","","" }
{ "91639","91926","173607","7053","","5Eps2Lyr","Eps-2","5","Eps","2","Lyr","","155.535","4.590","1.198","281.094913","39.612721","A8Vn","A","1","","" }
{ "96162","96465","184707","7440","","52    Sgr","","52","","","Sgr","","189.626","4.590","0.768","294.176788","-24.883623","B8/B9V","B","1","","" }
{ "3238","3245","3919","180","","Mu  Phe","Mu","","Mu","","Phe","","245.785","4.590","0.204","10.331496","-46.085007","G8III","G","1","","" }
{ "17309","17351","23319","1143","","","","","","","Eri","","184.269","4.590","0.830","55.708621","-37.313518","K2IIICN...","K","1","","" }
{ "17917","17959","23401","1148","","Gam Cam","Gam","","Gam","","Cam","","358.808","4.590","-0.617","57.589527","71.332266","A2IVn","A","1","","" }
{ "25409","25473","35715","1811","","30Psi2Ori","Psi-2","30","Psi","2","Ori","","1136.434","4.590","-3.121","81.709285","3.095674","B2IV","B","1","","" }
{ "42408","42527","73108","3403","","4Pi 2UMa","Pi-2","4","Pi","2","UMa","","256.010","4.590","0.116","130.053600","64.327936","K2III","K","1","","" }
{ "46376","46509","81997","3759","Gl 348A","31Tau1Hya","Tau-1","31","Tau","1","Hya","","56.536","4.590","3.396","142.287073","-2.768964","F6V","F","1","","Gl 348" }
{ "50413","50555","89682","4063","","","","","","","Vel","","1853.161","4.590","-4.182","154.903152","-55.029305","K3II","K","1","","" }
{ "54591","54751","97534","4352","","","","","","","Car","","326156.378","4.590","-15.410","168.150069","-60.317625","A6Ia","A","1","","" }
{ "49261","49402","87504","3970","","40Ups2Hya","Ups-2","40","Ups","2","Hya","","313.612","4.600","-0.315","151.281127","-13.064626","B8V","B","1","","" }
{ "53347","53502","94890","4273","","Iot Ant","Iot","","Iot","","Ant","","190.068","4.600","0.773","164.179333","-37.137765","K0III","K","1","","" }
{ "94786","95081","182564","7371","","58Pi  Dra","Pi","58","Pi","","Dra","","228.882","4.600","0.369","290.167000","65.714531","A2IIIs","A","1","","" }
{ "71899","72125","129972","5502","GJ 9493","35Omi Boo","Omi","35","Omi","","Boo","","243.037","4.600","0.239","221.310257","16.964280","K0III","K","1","","" }
{ "75272","75501","137058","5724","","","","","","","Lup","","392.486","4.600","-0.802","231.334273","-38.733620","A0V","A","1","","" }
{ "77524","77760","142373","5914","Gl 602","1Chi Her","Chi","1","Chi","","Her","","51.837","4.600","3.594","238.168543","42.451518","F9V","F","1","","" }
{ "20021","20070","26961","1324","","","","","","","Per","","313.612","4.600","-0.315","64.560844","50.295502","A2V","A","1","","" }
{ "441","443","28","3","","33    Psc","","33","","","Psc","","128.814","4.610","1.627","1.333921","-5.707618","K1III","K","1","","" }
{ "1363","1366","1280","63","","24The And","The","24","The","","And","","308.860","4.610","-0.272","4.272944","38.681636","A2V","A","1","","" }
{ "8814","8833","11559","549","","111Xi  Psc","Xi","111","Xi","","Psc","","179.108","4.610","0.912","28.388960","3.187536","K0III SB","K","1","","" }
{ "14781","14817","19656","947","","28Ome Per","Ome","28","Ome","","Per","","288.124","4.610","-0.121","47.822442","39.611582","K1III","K","1","","" }
{ "101148","101474","196093","7866","","47    Cyg","","47","","","Cyg","","2764.037","4.610","-5.031","308.475778","35.250852","K2Ib comp","K","1","","" }
{ "36044","36145","58142","2818","","21    Lyn","","21","","","Lyn","","273.621","4.610","-0.009","111.678561","49.211527","A1V","A","1","","" }
{ "38985","39095","65810","3131","","","","","","","Pup","","241.240","4.610","0.265","119.966878","-18.399228","A1V","A","1","","" }
{ "75987","76219","138716","5777","","37    Lib","","37","","","Lib","","94.347","4.610","2.303","233.544575","-10.064529","K1IV","K","1","","" }
{ "56311","56480","100673","4460","","","","","","","Cen","","426.348","4.620","-0.962","173.690331","-54.264091","B9V","B","1","","" }
{ "62132","62327","110956","4848","","","","","","","Cru","","384.618","4.620","-0.738","191.594709","-56.488815","B3V","B","1","","" }
{ "62807","63007","112078","4897","","Lam Cru","Lam","","Lam","","Cru","","383.714","4.620","-0.733","193.663335","-59.146701","B4Vn","B","1","","" }
{ "80385","80628","148367","6129","","3Ups Oph","Ups","3","Ups","","Oph","","133.561","4.620","1.559","246.950782","-8.371731","A3m","A","1","","" }
{ "87902","88175","164259","6710","Gl 699.2","57Zet Ser","Zet","57","Zet","","Ser","","76.815","4.620","2.760","270.120876","-3.690269","F3V","F","1","","" }
{ "90700","90982","170845","6951","","The CrA","The","","The","","CrA","","557.532","4.620","-1.544","278.375746","-42.312510","G5III","G","1","","" }
{ "92654","92946","175638","7141","","63The1Ser","The-1","63","The","1","Ser","Alya","154.650","4.620","1.240","284.054926","4.203595","A5V","A","1","","" }
{ "4412","4422","5395","265","","28Ups2Cas","Ups-2","28","Ups","2","Cas","Castula","199.851","4.620","0.684","14.166485","59.181056","G8III-IV","G","1","","" }
{ "18626","18673","25267","1240","","36Tau9Eri","Tau-9","36","Tau","9","Eri","","327.466","4.620","-0.389","59.981178","-24.016215","Ap Si","A","1","","" }
{ "23442","23497","32301","1620","","102Iot Tau","Iot","102","Iot","","Tau","","172.752","4.620","1.000","75.773934","21.589962","A7V","A","1","","" }
{ "25858","25923","36512","1855","","36Ups Ori","Ups","36","Ups","","Ori","","2861.021","4.620","-5.095","82.982750","-7.301537","B0V","B","1","","" }
{ "44696","44824","78541","3628","","Kap Pyx","Kap","","Kap","","Pyx","","560.406","4.620","-1.555","137.011992","-25.858536","K4/K5III","K","1","","" }
{ "54024","54182","96097","4310","","63Chi Leo","Chi","63","Chi","","Leo","","94.565","4.620","2.308","166.254287","7.336007","F2III-IVvar","F","1","","" }
{ "54143","54301","96566","4325","Gl 412.1","","","","","","Car","","398.237","4.620","-0.814","166.635220","-62.424113","G8III","G","1","","" }
{ "37541","37648","62576","2993","","1    Pup","","1","","","Pup","","772.882","4.630","-2.243","115.884948","-28.410885","K5III","K","1","","" }
{ "38388","38500","64740","3089","","","","","","","Pup","","758.503","4.630","-2.203","118.265156","-49.613044","B1.5Vp","B","1","","" }
{ "42716","42835","74395","3459","","","","","","","Hya","","769.237","4.630","-2.233","130.918223","-7.233730","G2Ib","G","1","","" }
{ "45317","45448","79940","3684","Gl 339.3","","","","","","Vel","","164.642","4.630","1.114","138.937823","-37.413144","F3/F5V","F","1","","" }
{ "90515","90797","169978","6916","","Nu  Pav","Nu","","Nu","","Pav","","438.972","4.630","-1.015","277.843441","-62.278302","B8III","B","1","","" }
{ "92225","92512","175306","7125","","47Omi Dra","Omi","47","Omi","","Dra","","341.883","4.630","-0.472","282.800216","59.388351","K0II-III SB","K","1","","" }
{ "61596","61789","110073","4817","","","","","","","Cen","","364.828","4.630","-0.613","189.968904","-39.987302","B8II/III","B","1","","" }
{ "66527","66738","119228","5154","","83    UMa","","83","","","UMa","","523.525","4.630","-1.398","205.184505","54.681634","M2IIIvar","M","1","","" }
{ "72972","73199","132813","5589","","","","","","","UMi","","459.375","4.630","-1.114","224.396139","65.932460","M5III","M","1","","" }
{ "77399","77635","141637","5885","","1    Sco","","1","","","Sco","","494.926","4.630","-1.276","237.744773","-25.751295","B1.5Vn","B","1","","" }
{ "78423","78662","143474","5961","","Iot1Nor","Iot-1","","Iot","1","Nor","","128.459","4.630","1.653","240.883966","-57.775064","A7IV","A","1","","" }
{ "117763","118131","224427","9064","","84Psi Peg","Psi","84","Psi","","Peg","","476.141","4.630","-1.192","359.439702","25.141401","M3III","M","1","","" }
{ "13880","13914","18519","887","","48Eps Ari","Eps","48","Eps","","Ari","","332.473","4.630","-0.412","44.803026","21.340429","A2Vs","A","1","","" }
{ "18171","18216","24587","1213","","33Tau8Eri","Tau-8","33","Tau","8","Eri","","377.059","4.640","-0.675","58.427921","-24.612230","B5V","B","1","","" }
{ "22792","22845","31295","1570","","7Pi 1Ori","Pi-1","7","Pi","1","Ori","","116.318","4.640","1.879","73.723864","10.150833","A0V","A","1","","" }
{ "67023","67234","119834","5172","","","","","","","Cen","","262.606","4.640","0.111","206.664060","-51.432766","G8/K0III","G","1","","" }
{ "76433","76669","139891","5833","","7Zet1CrB","Zet-1","7","Zet","1","CrB","","473.377","4.640","-1.169","234.844478","36.635812","B7V+...","B","1","","" }
{ "76593","76829","139664","5825","Gl 594","","","","","","Lup","","56.871","4.640","3.433","235.297572","-44.661205","F5IV-V","F","1","","" }
{ "82118","82369","151769","6243","","20    Oph","","20","","","Oph","","104.303","4.640","2.116","252.458449","-10.783000","F7IV","F","1","","" }
{ "28645","28716","41117","2135","","62Chi2Ori","Chi-2","62","Chi","2","Ori","","1801.969","4.640","-4.072","90.979937","20.138452","B2Iavar","B","1","","" }
{ "84348","84606","156729","6436","","69    Her","","69","","","Her","","175.447","4.640","0.986","259.417754","37.291498","A2V","A","1","","" }
{ "88488","88765","165760","6770","","71    Oph","","71","","","Oph","","272.706","4.640","0.029","271.826500","8.733867","G8III-IV","G","1","","" }
{ "95289","95585","182835","7387","","32Nu  Aql","Nu","32","Nu","","Aql","","2836.142","4.640","-5.057","291.629538","0.338570","F2Ib","F","1","","" }
{ "101263","101589","196180","7871","","4Zet Del","Zet","4","Zet","","Del","","220.079","4.640","0.494","308.827227","14.674213","A3V","A","1","","" }
{ "111323","111674","214454","8613","","9    Lac","","9","","","Lac","","171.661","4.640","1.034","339.343482","51.545123","A8IV","A","1","","" }
{ "113559","113919","218031","8780","","3    And","","3","","","And","","176.683","4.640","0.971","346.045537","50.052091","K0III","K","1","","" }
{ "118632","","","","Gl 351B","","","","","","Vel","","60.523","4.650","3.308","142.676457","-40.465622","F0 IV","F","2","46518","Gl 351" }
{ "27821","27890","40409","2102","Gl 224.1","","","","","","Dor","","85.605","4.650","2.555","88.524875","-63.089627","K1III/IV","K","1","","" }
{ "35266","35363","57150","2787","","","","","","","Pup","","803.341","4.650","-2.307","109.576643","-36.733962","B2V+...","B","1","","" }
{ "36412","36514","59890","2881","","","","","","","Pup","","1503.025","4.650","-3.668","112.677513","-30.962281","G2Ib...","G","1","","" }
{ "36811","36917","60863","2922","","","","","","","Pup","","221.574","4.650","0.490","113.845409","-28.369323","B8V","B","1","","" }
{ "51047","51192","90772","4110","","","","","","","Car","","326156.378","4.650","-15.350","156.851976","-57.638805","A6Ia","A","1","","" }
{ "12686","12719","16908","801","","35    Ari","","35","","","Ari","","342.962","4.650","-0.459","40.862969","27.707146","B3V","B","1","","" }
{ "21220","21273","28910","1444","","86Rho Tau","Rho","86","Rho","","Tau","","158.251","4.650","1.220","68.462148","14.844424","A8V","A","1","","" }
{ "23552","23607","32549","1638","","11    Ori","","11","","","Ori","","365.237","4.650","-0.596","76.142288","15.404105","A0p Si","A","1","","" }
{ "58415","58590","104321","4589","","8Pi  Vir","Pi","8","Pi","","Vir","","384.165","4.650","-0.705","180.218292","6.614322","A5V","A","1","","" }
{ "78400","78639","143546","5962","","Eta Nor","Eta","","Eta","","Nor","","219.486","4.650","0.510","240.803684","-49.229695","G8III","G","1","","" }
{ "61547","61740","110014","4813","","26Chi Vir","Chi","26","Chi","","Vir","","293.570","4.660","-0.111","189.811530","-7.995564","K2III","K","1","","" }
{ "61819","62012","110458","4831","","","","","","","Cen","","190.623","4.660","0.826","190.647872","-48.813109","K0III","K","1","","" }
{ "76469","76705","139521","5820","","3Psi1Lup","Psi-1","3","Psi","1","Lup","","219.634","4.660","0.519","234.941575","-34.411926","G8/K0III","G","1","","" }
{ "5559","5571","7087","351","","84Chi Psc","Chi","84","Chi","","Psc","","383.714","4.660","-0.693","17.863410","21.034650","K0III","K","1","","" }
{ "8481","8497","11171","531","GJ 9061A","53Chi Cet","Chi","53","Chi","","Cet","","75.622","4.660","2.834","27.396268","-10.686410","F3III","F","1","","GJ 9061" }
{ "31895","31978","47839","2456","","15    Mon","","15","","","Mon","","918.750","4.660","-2.589","100.244419","9.895754","O7","O","1","","" }
{ "33215","33302","51199","2590","","19Pi  CMa","Pi","19","Pi","","CMa","","96.496","4.660","2.305","103.905954","-20.136497","F2IV/V","F","1","","" }
{ "35110","35205","56618","2766","","","","","","","CMa","","405.163","4.660","-0.811","109.145809","-27.881179","M2III","M","1","","" }
{ "42687","42806","74198","3449","","43Gam Cnc","Gam","43","Gam","","Cnc","Asellus Borealis","181.198","4.660","0.936","130.821461","21.468501","A1IV","A","1","","" }
{ "44498","44626","78764","3642","","","","","","","Car","","967.823","4.660","-2.702","136.409914","-70.538497","B2IVe","B","1","","" }
{ "53141","53295","94334","4248","","45Ome UMa","Ome","45","Ome","","UMa","","246.342","4.660","0.269","163.494717","43.189956","A1Vs","A","1","","" }
{ "88293","88567","164975","6742","","Gam1Sgr","Gam-1","","Gam","1","Sgr","","869.750","4.660","-2.470","271.255103","-29.580087","G0Ib/II","G","1","","" }
{ "89400","89678","167818","6842","","","","","","","Sgr","","762.048","4.660","-2.183","274.513294","-27.042641","K3III","K","1","","" }
{ "89856","90135","169156","6884","","Zet Sct","Zet","","Zet","","Sct","","206.690","4.660","0.651","275.914933","-8.934383","K0III","K","1","","" }
{ "98232","98543","189849","7653","","15    Vul","","15","","","Vul","","236.345","4.660","0.359","300.275183","27.753573","A4III","A","1","","" }
{ "87856","88128","164349","6713","","93    Her","","93","","","Her","","671.104","4.670","-1.897","270.014234","16.750919","K0II-III","K","1","","" }
{ "90315","90595","170296","6930","","Gam Sct","Gam","","Gam","","Sct","","319.448","4.670","-0.285","277.299390","-14.565813","A1IV/V","A","1","","" }
{ "91633","91919","173582","7051","","4Eps1Lyr","Eps-1","4","Eps","1","Lyr","","162.348","4.670","1.185","281.084764","39.670123","F1V","F","1","","" }
{ "95799","96100","185144","7462","Gl 764","61Sig Dra","Sig","61","Sig","","Dra","Alsafi","18.769","4.670","5.870","293.087231","69.661175","K0V","K","1","","" }
{ "103406","103738","199951","8039","","Gam Mic","Gam","","Gam","","Mic","","229.042","4.670","0.438","315.322751","-32.257767","G8III","G","1","","" }
{ "5730","5742","7318","360","","85Phi Psc","Phi","85","Phi","","Psc","","446.178","4.670","-1.010","18.437275","24.583713","K0III...","K","1","","" }
{ "16203","16244","21428","1044","","34    Per","","34","","","Per","","539.102","4.670","-1.421","52.341847","49.508948","B3V","B","1","","" }
{ "19761","19811","26673","1306","","52    Per","","52","","","Per","","950.893","4.670","-2.654","63.722149","40.483671","G5II comp","G","1","","" }
{ "21630","21683","29488","1479","","92Sig2Tau","Sig-2","92","Sig","2","Tau","","155.535","4.670","1.278","69.818749","15.917977","A5Vn","A","1","","" }
{ "28837","28910","41695","2155","","18The Lep","The","18","The","","Lep","","172.752","4.670","1.050","91.538851","-14.935254","A0V","A","1","","" }
{ "40054","40167","68255","3210","","16Zet2Cnc","Zet-2","16","Zet","2","Cnc","Tegmine","81.805","4.670","2.673","123.053022","17.647771","G0V","G","1","","" }
{ "44947","45075","78362","3624","","14Tau UMa","Tau","14","Tau","","UMa","","126.319","4.670","1.730","137.729121","63.513633","Am","A","1","","" }
{ "43754","43878","76805","3574","","","","","","","Vel","","353.366","4.680","-0.494","134.080285","-52.723475","B5V","B","1","","" }
{ "47177","47310","83425","3834","","","","","","","Hya","","295.431","4.680","-0.105","144.613702","4.649293","K3III","K","1","","" }
{ "48889","49029","86663","3950","","29Pi  Leo","Pi","29","Pi","","Leo","","406.172","4.680","-0.796","150.053361","8.044223","M2III","M","1","","" }
{ "51947","52098","92125","4166","","37    LMi","","37","","","LMi","","578.292","4.680","-1.564","159.680053","31.976237","G0II","G","1","","" }
{ "96377","96683","185734","7478","","12Phi Cyg","Phi","12","Phi","","Cyg","","266.250","4.680","0.121","294.844189","30.153321","G8III-IV...","G","1","","" }
{ "106444","106786","205767","8264","","23Xi  Aqr","Xi","23","Xi","","Aqr","Bunda","178.618","4.680","0.988","324.437952","-7.854201","A7V","A","1","","" }
{ "111857","112211","215167","8649","","66    Aqr","","66","","","Aqr","","433.143","4.680","-0.936","340.896809","-18.830375","K3III","K","1","","" }
{ "65798","66006","117675","5095","","74    Vir","","74","","","Vir","","399.701","4.680","-0.762","202.991189","-6.255816","M3III","M","1","","" }
{ "66025","66234","118232","5112","","24    CVn","","24","","","CVn","","180.297","4.680","0.967","203.613744","49.015973","A5V","A","1","","" }
{ "79805","80047","145366","6020","","Del1Aps","Del-1","","Del","1","Aps","","762.048","4.680","-2.163","245.086788","-78.695745","M5III","M","1","","" }
{ "7280","7294","9408","442","","39Chi Cas","Chi","39","Chi","","Cas","","208.141","4.680","0.655","23.482920","59.232040","K0III","K","1","","" }
{ "8909","8928","11977","570","","Eta2Hyi","Eta-2","","Eta","2","Hyi","","218.750","4.680","0.547","28.733580","-67.647303","G5III","G","1","","" }
{ "9655","9677","12767","612","","Nu  For","Nu","","Nu","","For","","371.054","4.680","-0.600","31.122656","-29.296819","B9.5p (Si)","B","1","","" }
{ "13845","13879","18411","879","","22Pi  Per","Pi","22","Pi","","Per","","309.740","4.680","-0.208","44.690273","39.662728","A2Vn","A","1","","" }
{ "20680","20732","28100","1396","","73Pi  Tau","Pi","73","Pi","","Tau","","416.547","4.690","-0.841","66.651551","14.713782","G8III","G","1","","" }
{ "24753","24813","34411","1729","Gl 197","15Lam Aur","Lam","15","Lam","","Aur","","41.197","4.690","4.183","79.784922","40.099051","G0V","G","1","","" }
{ "116023","116389","221760","8949","","Iot Phe","Iot","","Iot","","Phe","","248.785","4.690","0.278","353.768979","-42.615075","A2V","A","1","","" }
{ "37067","37173","61429","2944","","","","","","","Pup","","618.892","4.690","-1.701","114.575192","-25.364804","B8IV","B","1","","" }
{ "37981","38089","63744","3046","","","","","","","Pup","","232.305","4.690","0.427","117.084119","-47.077722","K0III","K","1","","" }
{ "39100","39211","65953","3141","","28    Mon","","28","","","Mon","","449.871","4.690","-1.008","120.305562","-1.392608","K4III","K","1","","" }
{ "51951","52102","92397","4177","","","","","","","Car","","2346.449","4.690","-4.595","159.687517","-59.182997","K4/K5III:","K","1","","" }
{ "106795","107136","206672","8301","","80Pi 1Cyg","Pi-1","80","Pi","1","Cyg","Azelfafage","1725.695","4.690","-3.928","325.523594","51.189622","B3IV","B","1","","" }
{ "108526","108870","209100","8387","Gl 845","Eps Ind","Eps","","Eps","","Ind","","11.815","4.690","6.895","330.832289","-56.785977","K5V","K","1","","" }
{ "62075","62268","110829","4842","","Iot Cru","Iot","","Iot","","Cru","","120.043","4.690","1.860","191.408257","-60.981318","K1III","K","1","","" }
{ "56464","56633","100889","4468","","21The Crt","The","21","The","","Crt","","280.444","4.700","0.028","174.170474","-9.802247","B9.5Vn","B","1","","" }
{ "56753","56922","101431","4494","","Omi Hya","Omi","","Omi","","Hya","","448.633","4.700","-0.992","175.053311","-34.744660","B9V","B","1","","" }
{ "24866","24927","34968","1762","","","","","","","Lep","","416.016","4.700","-0.828","80.112158","-21.239763","A0V","A","1","","" }
{ "112756","113116","217382","8748","","","","","","","Cep","","355.678","4.700","-0.488","343.601840","84.346177","K4III","K","1","","" }
{ "115881","116247","221565","8939","","101    Aqr","","101","","","Aqr","","293.570","4.700","-0.071","353.319265","-20.914504","A0V","A","1","","" }
{ "82419","82671","152236","6262","","Zet1Sco","Zet-1","","Zet","1","Sco","","2568.161","4.700","-4.781","253.498862","-42.362025","B1Iae","B","1","","" }
{ "91441","91726","172748","7020","","Del Sct","Del","","Del","","Sct","","202.456","4.700","0.735","280.568444","-9.052549","F2IIIp d Del","F","1","","" }
{ "97755","98066","188376","7597","","58Ome Sgr","Ome","58","Ome","","Sgr","Terebellum","84.760","4.700","2.626","298.959766","-26.299506","G3/G5III","G","1","","" }
{ "104184","104521","201601","8097","","5Gam Equ","Gam","5","Gam","","Equ","","118.387","4.700","1.901","317.585415","10.131579","F0p","F","1","","" }
{ "97627","97938","188310","7595","","59Xi  Aql","Xi","59","Xi","","Aql","Libertas","183.543","4.710","0.958","298.562003","8.461453","K0III","K","1","","" }
{ "104802","105140","202627","8135","","Eps Mic","Eps","","Eps","","Mic","","182.210","4.710","0.974","319.484495","-32.172539","A0V","A","1","","" }
{ "13920","13954","18604","896","","91Lam Cet","Lam","91","Lam","","Cet","","576.248","4.710","-1.526","44.928757","8.907365","B6III","B","1","","" }
{ "16204","16245","22001","1083","Gl 143.2A","Kap Ret","Kap","","Kap","","Ret","","70.719","4.710","3.029","52.343374","-62.937527","F5IV-V","F","1","","Gl 143.2" }
{ "22614","22667","30959","1556","","4Omi1Ori","Omi-1","4","Omi","1","Ori","","651.011","4.710","-1.791","73.133176","14.250642","M3Sv","M","1","","" }
{ "23638","23693","33262","1674","Gl 189","Zet Dor","Zet","","Zet","","Dor","","37.983","4.710","4.379","76.377799","-57.472704","F7V","F","1","","" }
{ "25673","25737","36167","1834","","31    Ori","","31","","","Ori","","508.032","4.710","-1.252","82.433257","-1.092239","K5III","K","1","","" }
{ "25919","25984","36371","1843","","25Chi Aur","Chi","25","Chi","","Aur","","326156.378","4.710","-15.290","83.181971","32.192022","B5Iab","B","1","","" }
{ "45770","45902","80874","3718","","The Pyx","The","","The","","Pyx","","502.552","4.710","-1.229","140.373298","-25.965439","M0III","M","1","","" }
{ "45894","46026","81169","3733","","Lam Pyx","Lam","","Lam","","Pyx","","192.083","4.710","0.860","140.801088","-28.833873","G8III","G","1","","" }
{ "57111","57283","102070","4514","","27Zet Crt","Zet","27","Zet","","Crt","","352.983","4.710","-0.462","176.190728","-18.350674","G8III","G","1","","" }
{ "63742","63945","113703","4940","","","","","","","Cen","","390.139","4.710","-0.679","196.569637","-48.463289","B5V","B","1","","" }
{ "67973","68191","121474","5241","","","","","","","Cen","","209.612","4.710","0.670","209.412138","-63.686696","K4III","K","1","","" }
{ "114013","114375","218640","8817","GJ 9812A","89    Aqr","","89","","","Aqr","","504.106","4.710","-1.235","347.478741","-22.457611","A3IV:","A","1","","GJ 9812" }
{ "29203","29276","42933","2212","","Del Pic","Del","","Del","","Pic","","1299.428","4.720","-3.282","92.574628","-54.968645","B0.5IV","B","1","","" }
{ "39971","40084","68290","3211","","19    Pup","","19","","","Pup","","176.683","4.720","1.051","122.817942","-12.926999","K0III","K","1","","" }
{ "46239","46371","81799","3749","","","","","","","Hya","","156.580","4.720","1.313","141.826656","-22.343783","K1III","K","1","","" }
{ "50911","51056","90277","4090","","30    LMi","","30","","","LMi","","233.302","4.720","0.448","156.478430","33.796120","F0V","F","1","","" }
{ "51291","51438","91375","4138","","","","","","","Car","","260.508","4.720","0.208","157.583714","-71.992793","A2III","A","1","","" }
{ "51509","51658","91312","4132","","","","","","","UMa","","112.935","4.720","2.023","158.307976","40.425560","A7IV","A","1","","" }
{ "84256","84514","156266","6415","","41    Oph","","41","","","Oph","","205.777","4.720","0.720","259.152859","-0.445297","K2III","K","1","","" }
{ "106845","107188","206453","8288","","43Kap Cap","Kap","43","Kap","","Cap","","294.099","4.720","-0.055","325.664593","-18.866323","G8III","G","1","","" }
{ "6678","6692","8491","399","","36Psi Cas","Psi","36","Psi","","Cas","","195.070","4.720","0.836","21.483116","68.130012","K0III","K","1","","" }
{ "24983","25044","35039","1765","","22    Ori","","22","","","Ori","","929.220","4.720","-2.553","80.440616","-0.382465","B2IV-V","B","1","","" }
{ "27569","27639","38944","2011","","31Ups Aur","Ups","31","Ups","","Aur","","522.686","4.720","-1.304","87.760132","37.305573","M1III","M","1","","" }
{ "58693","58867","104841","4603","","The2Cru","The-2","","The","2","Cru","","853.812","4.720","-2.370","181.080115","-63.165711","B2IV","B","1","","" }
{ "60017","60202","107383","4697","","11    Com","","11","","","Com","","289.917","4.720","-0.024","185.179288","17.792868","G8III","G","1","","" }
{ "64639","64844","115604","5017","","20    CVn","","20","","","CVn","","264.308","4.720","0.177","199.385682","40.572608","F3III","F","1","","" }
{ "78354","78592","144206","5982","","6Ups Her","Ups","6","Ups","","Her","","371.476","4.720","-0.563","240.699515","46.036705","B9III","B","1","","" }
{ "78673","78914","144197","5980","GJ 3938","Del Nor","Del","","Del","","Nor","","122.339","4.730","1.859","241.622640","-45.173185","Am","A","1","","" }
{ "78879","79119","145328","6018","","16Tau CrB","Tau","16","Tau","","CrB","","116.693","4.730","1.962","242.242936","36.490944","K0III-IV","K","1","","" }
{ "102714","103045","198743","7990","","6Mu  Aqr","Mu","6","Mu","","Aqr","","157.260","4.730","1.314","313.163471","-8.983318","A3m","A","1","","" }
{ "33115","33202","50635","2564","GJ 9220A","38    Gem","","38","","","Gem","","83.587","4.730","2.686","103.660978","13.177827","F0Vp","F","1","","GJ 9220" }
{ "39983","40096","68601","3226","","","","","","","Pup","","326156.378","4.730","-15.270","122.857890","-42.987278","A7Ib","A","1","","" }
{ "53751","53907","95578","4299","","61    Leo","","61","","","Leo","","584.510","4.730","-1.537","165.456977","-2.484585","K5III","K","1","","" }
{ "11286","11313","14872","699","","65    And","","65","","","And","","369.373","4.730","-0.540","36.405895","50.278631","K4III","K","1","","" }
{ "2499","2505","2772","123","","14Lam Cas","Lam","14","Lam","","Cas","","377.496","4.740","-0.577","7.943090","54.522289","B8Vn","B","1","","" }
{ "6179","6193","7964","383","","90Ups Psc","Ups","90","Ups","","Psc","","307.985","4.740","-0.136","19.866638","27.264059","A3V","A","1","","" }
{ "11755","11783","15798","740","","76Sig Cet","Sig","76","Sig","","Cet","","87.068","4.740","2.608","38.021792","-15.244677","F5V","F","1","","" }
{ "12381","12413","16754","789","","","","","","","Eri","","116.401","4.740","1.977","39.949888","-42.891670","A2V","A","1","","" }
{ "15481","15520","20336","985","","","","","","","Cam","","762.048","4.740","-2.103","49.996930","65.652292","B2.5Vne","B","1","","" }
{ "16300","16341","21790","1070","","17    Eri","","17","","","Eri","","404.159","4.740","-0.726","52.654407","-5.075145","B9Vs","B","1","","" }
{ "87844","88116","163955","6700","","4    Sgr","","4","","","Sgr","","415.486","4.740","-0.786","269.948140","-23.816133","B9V","B","1","","" }
{ "93248","93542","176638","7188","","Zet CrA","Zet","","Zet","","CrA","","193.106","4.740","0.878","285.778604","-42.095105","A0Vn","A","1","","" }
{ "95752","96052","184171","7426","","8    Cyg","","8","","","Cyg","","860.571","4.740","-2.367","292.943006","34.452968","B3IV","B","1","","" }
{ "103300","103632","200120","8047","","59    Cyg","","59","","","Cyg","","1418.071","4.740","-3.451","314.956477","47.520951","B1ne","B","1","","" }
{ "108528","108874","209409","8402","","31Omi Aqr","Omi","31","Omi","","Aqr","","435.456","4.740","-0.888","330.828517","-2.155363","B7IVe","B","1","","" }
{ "116236","116602","222095","8959","","","","","","","Phe","","200.219","4.740","0.800","354.462403","-45.492351","A2V","A","1","","" }
{ "64720","64924","115617","5019","Gl 506","61    Vir","","61","","","Vir","","27.903","4.740","5.079","199.601449","-18.311196","G5V","G","1","","" }
{ "68971","69191","123569","5297","","","","","","","Cen","","182.414","4.740","1.002","212.478635","-53.438946","G8III","G","1","","" }
{ "77426","77661","141992","5899","","38Rho Ser","Rho","38","Rho","","Ser","","374.892","4.740","-0.562","237.816296","20.977919","K5III","K","1","","" }
{ "39790","39903","68456","3220","Gl 297.1","","","","","","Car","","65.166","4.740","3.237","122.253199","-61.302429","F5V","F","1","","" }
{ "42505","42624","74272","3452","","","","","","","Vel","","2548.097","4.740","-4.724","130.304724","-47.317125","A5II","A","1","","" }
{ "44262","44390","76827","3576","","8Rho UMa","Rho","8","Rho","","UMa","","314.519","4.740","-0.181","135.636304","67.629619","M3III","M","1","","" }
{ "34926","35020","56456","2762","","","","","","","Pup","","376.624","4.750","-0.562","108.658925","-48.271927","B8/B9V","B","1","","" }
{ "114727","115088","219916","8872","","34Omi Cep","Omi","34","Omi","","Cep","","203.086","4.750","0.779","349.655995","68.111445","K0III","K","1","","" }
{ "101285","101612","195627","7848","","Phi1Pav","Phi-1","","Phi","1","Pav","","90.649","4.750","2.530","308.895038","-60.581749","F1III","F","1","","" }
{ "57408","57581","102584","4530","","Mu  Mus","Mu","","Mu","","Mus","","429.719","4.750","-0.849","177.060447","-66.814910","K4III","K","1","","" }
{ "67572","67786","120955","5221","","4    Cen","","4","","","Cen","","637.024","4.750","-1.704","208.302251","-31.927612","B4IV","B","1","","" }
{ "69491","69713","125161","5350","GJ 9474A","21Iot Boo","Iot","21","Iot","","Boo","","94.813","4.750","2.433","214.041591","51.367231","A9V","A","1","","GJ 9474" }
{ "76644","76880","139997","5838","","43Kap Lib","Kap","43","Kap","","Lib","","308.568","4.750","-0.130","235.486663","-19.678828","K5III","K","1","","" }
{ "76709","76945","140008","5839","","4Psi2Lup","Psi-2","4","Psi","2","Lup","","363.608","4.750","-0.486","235.670929","-34.710407","B5V","B","1","","" }
{ "55102","55266","98353","4380","","55    UMa","","55","","","UMa","","191.857","4.760","0.912","169.782958","38.185557","A2V","A","1","","" }
{ "60299","60485","107950","4716","","5    CVn","","5","","","CVn","","386.441","4.760","-0.608","186.006208","51.562257","G7III","G","1","","" }
{ "63153","63355","112769","4920","","36    Com","","36","","","Com","","324.211","4.760","-0.227","194.731014","17.409446","M0III","M","1","","" }
{ "65433","65639","116976","5068","Gl 511.2","69    Vir","","69","","","Vir","","280.203","4.760","0.090","201.863195","-15.973578","K1IIICN...","K","1","","" }
{ "67451","67665","120933","5219","","","","","","","CVn","","600.656","4.760","-1.566","207.947823","34.444240","K5III","K","1","","" }
{ "70041","70264","125628","5371","","","","","","","Cen","","383.262","4.760","-0.590","215.654560","-58.459117","G8/K1 + F/G","G","1","","" }
{ "113794","114155","218356","8796","","56    Peg","","56","","","Peg","","591.935","4.760","-1.534","346.778080","25.468259","K0IIp","K","1","","" }
{ "2466","2472","2834","125","","Lam1Phe","Lam-1","","Lam","1","Phe","","172.752","4.760","1.140","7.853909","-48.803514","A0V","A","1","","" }
{ "13210","13244","18293","872","","Nu  Hyi","Nu","","Nu","","Hyi","","339.393","4.760","-0.326","42.618821","-75.066947","K3III","K","1","","" }
{ "13254","13288","17824","850","","2Tau2Eri","Tau-2","2","Tau","2","Eri","Angetenar","186.909","4.760","0.969","42.759680","-21.004019","K0III","K","1","","" }
{ "27681","27750","39400","2037","","56    Ori","","56","","","Ori","","1259.291","4.760","-3.174","88.110161","1.855134","K2IIvar","K","1","","" }
{ "29924","29997","42818","2209","","","","","","","Cam","","174.977","4.760","1.112","94.711578","69.319787","A0Vn","A","1","","" }
{ "38788","38901","65456","3113","","","","","","","Pup","","1212.477","4.760","-3.091","119.417112","-30.334570","A7III","A","1","","" }
{ "47387","47522","83953","3858","","","","","","","Hya","","506.454","4.760","-1.196","145.320870","-23.591514","B5V","B","1","","" }
{ "52219","52370","92938","4196","","","","","","","Car","","453.625","4.760","-0.956","160.558890","-64.466426","B3V","B","1","","" }
{ "84710","84969","156277","6417","","Zet Aps","Zet","","Zet","","Aps","","297.317","4.760","-0.039","260.497971","-67.770668","K1III","K","1","","" }
{ "86219","86486","160032","6569","Gl 686.2","Lam Ara","Lam","","Lam","","Ara","","69.961","4.760","3.103","265.099138","-49.415587","F3IV","F","1","","" }
{ "94408","94703","180554","7306","","1    Vul","","1","","","Vul","","811.334","4.760","-2.219","289.054333","21.390428","B4IV","B","1","","" }
{ "106459","106801","206165","8279","","9    Cep","","9","","","Cep","","326156.378","4.760","-15.240","324.480107","62.081940","B2Ib","B","1","","" }
{ "85939","86201","160922","6596","GJ 4017","28Ome Dra","Ome","28","Ome","","Dra","","75.552","4.770","2.946","264.237878","68.757970","F5V","F","1","","" }
{ "88131","88404","164764","6733","Gl 700.1B","69Tau Oph","Tau","69","Tau","","Oph","","167.431","4.770","1.218","270.770498","-8.180349","F5V+...","F","2","119195","Gl 700.1" }
{ "90623","90905","171635","6978","","45    Dra","","45","","","Dra","","2117.898","4.770","-4.292","278.143843","57.045599","F7Ib","F","1","","" }
{ "98448","98761","189831","7652","","","","","","","Sgr","","366.468","4.770","-0.483","300.889371","-37.940699","K4III","K","1","","" }
{ "99723","100044","193237","7763","","34    Cyg","","34","","","Cyg","","326156.378","4.770","-15.230","304.446676","38.032930","B2pe","B","1","","" }
{ "99985","100310","193432","7773","","8Nu  Cap","Nu","8","Nu","","Cap","Alshat","253.227","4.770","0.320","305.165899","-12.759080","B9IV","B","1","","" }
{ "100701","101027","194943","7822","Gl 791.1A","11Rho Cap","Rho","11","Rho","","Cap","","98.715","4.770","2.365","307.215060","-17.813687","F3V","F","1","","Gl 791.1" }
{ "3448","3455","4188","194","","17Phi1Cet","Phi-1","17","Phi","1","Cet","","233.636","4.770","0.494","11.047506","-10.609550","K0IIIvar","K","1","","" }
{ "14346","14382","18970","918","","","","","","","Per","","211.104","4.770","0.715","46.385074","56.705719","K0II-III","K","1","","" }
{ "26497","26563","37507","1937","GJ 9187","49    Ori","","49","","","Ori","","145.476","4.770","1.523","84.721179","-7.212829","A4V","A","1","","" }
{ "55959","56127","99998","4432","","87    Leo","","87","","","Leo","","603.993","4.770","-1.568","172.578722","-3.003501","K4III","K","1","","" }
{ "62785","62985","112142","4902","","40Psi Vir","Psi","40","Psi","","Vir","","544.501","4.770","-1.343","193.588181","-9.538994","M3IIIvar","M","1","","" }
{ "112160","112519","216446","8702","","","","","","","Cep","","313.311","4.770","-0.143","341.870671","83.153830","K3III","K","1","","" }
{ "32447","32533","49161","2503","","17    Mon","","17","","","Mon","","492.683","4.770","-1.126","101.832628","8.037254","K4III","K","1","","" }
{ "45620","45751","80499","3706","","26    Hya","","26","","","Hya","","336.938","4.770","-0.301","139.943260","-11.974853","G8III","G","1","","" }
{ "39734","39847","67006","3173","","27    Lyn","","27","","","Lyn","","250.120","4.780","0.356","122.114452","51.506670","A2V","A","1","","" }
{ "40159","40274","68980","3237","","","","","","","Pup","","929.220","4.780","-2.493","123.372992","-35.899518","B2ne","B","1","","" }
{ "47623","47758","84367","3871","Gl 366.1A","The Ant","The","","The","","Ant","","339.393","4.780","-0.306","146.050413","-27.769471","A7V+...","A","1","","Gl 366.1" }
{ "50422","50564","89449","4054","Gl 388.1","40    Leo","","40","","","Leo","","69.691","4.780","3.131","154.934067","19.470914","F6IV","F","1","","" }
{ "60166","60351","107700","4707","","12    Com","","12","","","Com","","294.631","4.780","0.001","185.626303","25.846160","F8:p...","F","1","","" }
{ "64647","64852","115521","5015","","60Sig Vir","Sig","60","Sig","","Vir","","675.272","4.780","-1.800","199.401178","5.469869","M2III","M","1","","" }
{ "69881","70104","125442","5364","","","","","","","Lup","","142.054","4.780","1.585","215.177386","-45.187060","F0IV","F","1","","" }
{ "70083","70306","125932","5381","","51    Hya","","51","","","Hya","","157.411","4.780","1.362","215.774125","-27.754017","K3III","K","1","","" }
{ "85494","85755","158643","6519","","51    Oph","","51","","","Oph","","405.667","4.780","-0.694","262.853973","-23.962643","A0V","A","1","","" }
{ "87024","87294","161912","6631","","Iot2Sco","Iot-2","","Iot","2","Sco","","2548.097","4.780","-4.684","267.546300","-40.090435","A6Ib","A","1","","" }
{ "91737","92024","172555","7012","","","","","","","Pav","","93.108","4.780","2.502","281.361980","-64.871259","A7V","A","1","","" }
{ "122","122","224889","9084","","The Oct","The","","The","","Oct","","217.148","4.780","0.663","0.399242","-77.065724","K2III","K","1","","" }
{ "4137","4147","5112","248","","20    Cet","","20","","","Cet","","586.612","4.780","-1.495","13.252059","-1.144260","M0III","M","1","","" }
{ "9954","9977","13041","620","","58    And","","58","","","And","","191.406","4.780","0.937","32.121816","37.859077","A5IV-V","A","1","","" }
{ "17545","17587","23089","1129","","","","","","","Cam","","991.357","4.780","-2.634","56.509717","63.345047","A3V...","A","1","","" }
{ "20977","21029","28527","1427","Gl 170.1","","","","","","Tau","","140.888","4.780","1.603","67.640126","16.194014","A6IV","A","1","","" }
{ "23177","23231","32045","1611","","64    Eri","","64","","","Eri","","290.175","4.780","0.034","74.982236","-12.537416","F0V","F","1","","" }
{ "26134","26199","36960","1887","","","","","","","Ori","","1614.636","4.780","-3.693","83.761173","-6.002027","B0.5V","B","1","","" }
{ "110025","110371","212097","8522","","32    Peg","","32","","","Peg","","695.429","4.780","-1.864","335.330573","28.330529","B9III","B","1","","" }
{ "110536","110882","212943","8551","","35    Peg","","35","","","Peg","","148.320","4.780","1.491","336.964675","4.695664","K0III","K","1","","" }
{ "109562","109908","211088","8486","","Mu 1Gru","Mu-1","","Mu","1","Gru","","274.774","4.790","0.162","333.903798","-41.346700","G8III+...","G","1","","" }
{ "86950","87220","161840","6628","","","","","","","Sco","","556.581","4.790","-1.371","267.293649","-31.703203","B8Ib/II","B","1","","" }
{ "87877","88149","164284","6712","","66    Oph","","66","","","Oph","","651.011","4.790","-1.711","270.065827","4.368615","B2Ve","B","1","","" }
{ "99505","99824","192685","7739","","","","","","","Vul","","991.357","4.790","-2.624","303.816229","25.591957","B3V","B","1","","" }
{ "109054","109400","210807","8468","","24    Cep","","24","","","Cep","","394.385","4.790","-0.622","332.451610","72.341207","G8III","G","1","","" }
{ "40922","41039","70930","3294","","","","","","","Vel","","1716.613","4.790","-3.816","125.632062","-48.490381","B1V","B","1","","" }
{ "45724","45856","81101","3728","","","","","","","Car","","233.636","4.790","0.514","140.236758","-62.404632","G6III","G","1","","" }
{ "64456","64661","114911","4993","","Eta Mus","Eta","","Eta","","Mus","","382.813","4.790","-0.558","198.812401","-67.894589","B8V","B","1","","" }
{ "77420","77655","142091","5901","","11Kap CrB","Kap","11","Kap","","CrB","","99.468","4.790","2.369","237.808052","35.657382","K0III-IV","K","1","","" }
{ "80570","80815","148605","6141","","22    Sco","","22","","","Sco","","413.379","4.790","-0.725","247.551983","-25.115224","B3V","B","1","","" }
{ "1166","1168","1013","45","","89Chi Peg","Chi","89","Chi","","Peg","","368.122","4.790","-0.473","3.650671","20.206702","M2III","M","1","","" }
{ "9135","9153","11973","569","","9Lam Ari","Lam","9","Lam","","Ari","","128.814","4.790","1.807","29.482175","23.596061","F0V","F","1","","" }
{ "22626","22678","30834","1551","","2    Aur","","2","","","Aur","","601.764","4.790","-1.540","73.158267","36.703187","K3III","K","1","","" }
{ "3293","3300","3901","179","","19Xi  Cas","Xi","19","Xi","","Cas","","1430.510","4.800","-3.410","10.516214","50.512526","B2.5V","B","1","","" }
{ "4142","4151","5015","244","Gl 41","","","","","","Cas","","61.135","4.800","3.436","13.267664","61.123970","F8V","F","1","","" }
{ "15159","15197","20320","984","","13Zet Eri","Zet","13","Zet","","Eri","Zibal","109.743","4.800","2.165","48.958436","-8.819730","A5m","A","1","","" }
{ "20304","20354","27396","1350","","53    Per","","53","","","Per","","507.242","4.800","-1.159","65.388171","46.498878","B4IV","B","1","","" }
{ "20490","20542","27819","1380","","64Del2Tau","Del-2","64","Del","2","Tau","","161.384","4.800","1.328","66.023991","17.444130","A7V","A","1","","" }
{ "23309","23364","32249","1617","","65Psi Eri","Psi","65","Psi","","Eri","","739.584","4.800","-1.978","75.359770","-7.173965","B3V","B","1","","" }
{ "31751","31832","47174","2427","","50Psi2Aur","Psi-2","50","Psi","2","Aur","","416.016","4.800","-0.728","99.832610","42.488877","K3III","K","1","","" }
{ "44910","45038","78154","3616","Gl 335A","13Sig2UMa","Sig-2","13","Sig","2","UMa","","66.468","4.800","3.254","137.598057","67.134018","F7IV-V","F","1","","Gl 335" }
{ "45363","45493","79439","3662","GJ 3541","18    UMa","","18","","","UMa","","116.902","4.800","2.028","139.047114","54.021857","A5V","A","1","","" }
{ "45679","45811","80586","3709","","27    Hya","","27","","","Hya","","222.480","4.800","0.631","140.120909","-9.555695","F5V+...","F","1","","" }
{ "52351","52502","93194","4205","","","","","","","Car","","491.940","4.800","-1.092","161.028863","-63.961072","B5Vn","B","1","","" }
{ "110326","110672","212571","8539","","52Pi  Aqr","Pi","52","Pi","","Aqr","","782.150","4.800","-2.099","336.319263","1.377401","B1Ve","B","1","","" }
{ "111698","112051","214994","8641","","43Omi Peg","Omi","43","Omi","","Peg","","298.678","4.800","-0.009","340.439202","29.307641","A1IV","A","1","","" }
{ "118743","","98230","4374","Gl 423B","53Xi  UMa","Xi","53","Xi","","UMa","Alula Australis B","33.975","4.800","4.711","169.546772","31.528783","G0 Ve","G","2","118742","Gl 423" }
{ "84315","84573","156633","6431","","68    Her","","68","","","Her","","665.625","4.800","-1.749","259.331534","33.100100","B1.5Vp","B","1","","" }
{ "99320","99639","192514","7730","","30    Cyg","","30","","","Cyg","","610.780","4.800","-1.562","303.325207","46.815675","A5IIIn","A","1","","" }
{ "102758","103089","199081","8001","","57    Cyg","","57","","","Cyg","","525.212","4.800","-1.235","313.311466","44.387260","B5V","B","1","","" }
{ "105041","105382","203006","8151","","The1Mic","The-1","","The","1","Mic","","197.193","4.800","0.893","320.190116","-40.809465","A2p","A","1","","" }
{ "61202","61394","109485","4789","","23    Com","","23","","","Com","Phyllon Kissinou","310.034","4.800","-0.090","188.712851","22.629259","A0IV","A","1","","" }
{ "63819","64022","113996","4954","","41    Com","","41","","","Com","","331.460","4.800","-0.235","196.794697","27.624741","K5III","K","1","","" }
{ "68892","69112","124547","5321","","4    UMi","","4","","","UMi","","456.802","4.800","-0.932","212.212463","77.547514","K3III","K","1","","" }
{ "69656","69879","125351","5361","","","","","","","Boo","","233.469","4.800","0.526","214.499245","35.509505","K1III","K","1","","" }
{ "71769","71995","129712","5490","","34    Boo","","34","","","Boo","","704.441","4.800","-1.872","220.855684","26.527850","M3III","M","1","","" }
{ "73340","73568","133124","5600","","41Ome Boo","Ome","41","Ome","","Boo","","371.476","4.800","-0.483","225.527119","25.008138","K4III","K","1","","" }
{ "79639","79881","146624","6070","","","","","","","Sco","","134.664","4.800","1.721","244.574588","-28.614020","A0V:","A","1","","" }
{ "55521","55687","99167","4402","","14Eps Crt","Eps","14","Eps","","Crt","","376.190","4.810","-0.500","171.152463","-10.859323","K5III","K","1","","" }
{ "70532","70755","126868","5409","Gl 550.2A","105Phi Vir","Phi","105","Phi","","Vir","Elgafar","118.258","4.810","2.013","217.050575","-2.227957","G2III","G","1","","Gl 550.2" }
{ "23955","24010","33276","1676","","15    Ori","","15","","","Ori","","538.212","4.810","-1.278","77.424813","15.597232","F2IV","F","1","","" }
{ "24314","24372","34649","1744","","The Dor","The","","The","","Dor","","491.199","4.810","-1.079","78.439323","-67.185255","K2III","K","1","","" }
{ "24599","24659","34642","1743","","Omi Col","Omi","","Omi","","Col","","105.826","4.810","2.254","79.371158","-34.895207","K0/K1III/IV","K","1","","" }
{ "28165","28237","40111","2084","","139    Tau","","139","","","Tau","","1553.126","4.810","-3.579","89.498567","25.953912","B1Ib","B","1","","" }
{ "39028","39138","66591","3159","","","","","","","Car","","499.474","4.810","-1.115","120.083200","-63.567456","B3V","B","1","","" }
{ "46896","47029","82741","3809","","","","","","","Lyn","","215.427","4.810","0.711","143.765980","39.621493","K0III","K","1","","" }
{ "90010","90289","169420","6896","","21    Sgr","","21","","","Sgr","","410.260","4.810","-0.688","276.337668","-20.541679","A1/A2V","A","1","","" }
{ "101539","101867","196724","7891","","29    Vul","","29","","","Vul","","232.803","4.810","0.542","309.630565","21.201174","A0V","A","1","","" }
{ "102393","102724","198478","7977","","55    Cyg","","55","","","Cyg","","2329.688","4.810","-4.459","312.234548","46.114134","B3Ia","B","1","","" }
{ "83007","83262","153687","6318","","30    Oph","","30","","","Oph","","405.163","4.820","-0.651","255.265008","-4.222644","K4III","K","1","","" }
{ "90065","90344","170693","6945","","42    Dra","","42","","","Dra","Fafnir","314.823","4.820","-0.103","276.496041","65.563480","K2III","K","1","","" }
{ "92492","92782","176524","7180","","52Ups Dra","Ups","52","Ups","","Dra","","344.047","4.820","-0.296","283.599144","71.297192","K0III","K","1","","" }
{ "103684","104019","200499","8060","Gl 816.2A","22Eta Cap","Eta","22","Eta","","Cap","","161.464","4.820","1.347","316.101257","-19.854991","A5V","A","1","","Gl 816.2" }
{ "9076","9095","12055","574","","","","","","","Phe","","248.216","4.820","0.413","29.291884","-47.385277","G8III","G","1","","" }
{ "24283","24340","33641","1689","","11Mu  Aur","Mu","11","Mu","","Aur","","152.981","4.820","1.464","78.357169","38.484498","A4m","A","1","","" }
{ "110040","110386","212076","8520","","31    Peg","","31","","","Peg","","1622.668","4.820","-3.664","335.379478","12.205186","B2IV-V","B","1","","" }
{ "110776","111123","213320","8573","","57Sig Aqr","Sig","57","Sig","","Aqr","","289.659","4.820","0.078","337.661733","-10.677950","A0IVs","A","1","","" }
{ "114660","115022","219734","8860","","8    And","","8","","","And","","563.310","4.820","-1.367","349.435985","49.015300","M2III","M","1","","" }
{ "116535","116901","222574","8982","","104    Aqr","","104","","","Aqr","","838.448","4.820","-2.230","355.440856","-17.816533","G2Ib/II","G","1","","" }
{ "60522","60710","108257","4732","","","","","","","Cen","","448.017","4.820","-0.869","186.632375","-51.450635","B3Vn","B","1","","" }
{ "66249","66458","118623","5127","","25    CVn","","25","","","CVn","","198.633","4.820","0.897","204.365173","36.294898","A7III","A","1","","" }
{ "69004","69226","123999","5304","GJ 9470","12    Boo","","12","","","Boo","","122.064","4.820","1.954","212.599729","25.091677","F9IVw","F","1","","" }
{ "78316","78554","143894","5972","","44Pi  Ser","Pi","44","Pi","","Ser","","179.010","4.820","1.123","240.573715","22.804454","A3V","A","1","","" }
{ "79938","80179","147449","6093","GJ 3952","50Sig Ser","Sig","50","Sig","","Ser","","88.943","4.820","2.642","245.518120","1.029039","F0V","F","1","","" }
{ "82070","82321","152107","6254","","52    Her","","52","","","Her","","180.197","4.820","1.108","252.309219","45.983323","A2p...","A","1","","" }
{ "31746","31827","47667","2450","","","","","","","CMa","","988.353","4.820","-2.587","99.819663","-14.145764","K2III","K","1","","" }
{ "33005","33092","50707","2571","","15    CMa","","15","","","CMa","","1217.001","4.820","-3.039","103.387115","-20.224254","B1Ib","B","1","","" }
{ "36667","36773","60414","2902","","","","","","","Pup","","1538.473","4.820","-3.548","113.449847","-14.523892","A4Ia","A","1","","" }
{ "50653","50799","89998","4080","","","","","","","Vel","","203.848","4.820","0.841","155.581625","-41.649960","K1IIIvar","K","1","","" }
{ "51312","51459","90839","4112","Gl 395","36    UMa","","36","","","UMa","","41.681","4.820","4.287","157.656921","55.980536","F8V","F","1","","" }
{ "34404","34495","54893","2702","","","","","","","Pup","","728.028","4.830","-1.914","107.212791","-39.655657","B3IV/V","B","1","","" }
{ "35115","35210","56577","2764","","","","","","","CMa","","1418.071","4.830","-3.361","109.153475","-23.315594","K4III","K","1","","" }
{ "40830","40945","70555","3282","","","","","","","Pup","","1006.656","4.830","-2.617","125.345949","-33.054366","K2/K3III","K","1","","" }
{ "42607","42726","74560","3467","","","","","","","Vel","","484.631","4.830","-1.030","130.605816","-53.113984","B3IV","B","1","","" }
{ "83317","83574","154090","6334","","","","","","","Sco","","326156.378","4.830","-15.170","256.205634","-34.122930","B2Iab","B","1","","" }
{ "91801","92088","173780","7064","","","","","","","Lyr","","254.810","4.830","0.366","281.518662","26.662130","K3III","K","1","","" }
{ "92733","93026","175751","7149","","Eta Sct","Eta","","Eta","","Sct","","202.330","4.830","0.867","284.265289","-5.846314","K1III","K","1","","" }
{ "92881","93174","175813","7152","","Eps CrA","Eps","","Eps","","CrA","","98.447","4.830","2.431","284.680820","-37.107357","F3IV/V","F","1","","" }
{ "4282","4292","5234","253","","26Ups1Cas","Ups-1","26","Ups","1","Cas","","328.455","4.830","-0.185","13.750726","58.972698","K2III","K","1","","" }
{ "6799","6813","8799","417","","48Ome And","Ome","48","Ome","","And","","93.348","4.830","2.547","21.913722","45.406687","F5IV","F","1","","" }
{ "12357","12390","16620","781","Gl 105.4A","83Eps Cet","Eps","83","Eps","","Cet","","70.066","4.830","3.170","39.890967","-11.872156","F5V","F","1","","Gl 105.4" }
{ "12843","12876","17566","837","","Zet Hyi","Zet","","Zet","","Hyi","","284.356","4.830","0.128","41.385714","-67.616617","A2IV/V","A","1","","" }
{ "63521","63724","113314","4933","","Xi 1Cen","Xi-1","","Xi","1","Cen","","220.525","4.830","0.680","195.888836","-49.527264","A0V","A","1","","" }
{ "73467","73695","133640","5618","Gl 575A","44    Boo","","44","","","Boo","Quadrans","40.795","4.830","4.344","225.947614","47.654060","G2V + G2V","G","1","","Gl 575" }
{ "74221","74449","134687","5651","","","","","","","Lup","","504.106","4.830","-1.115","228.206636","-44.500414","B3IV","B","1","","" }
{ "80460","80704","148783","6146","","30    Her","","30","","","Her","","354.133","4.830","-0.349","247.160591","41.881677","M6III:var","M","1","","" }
{ "57156","57328","102124","4515","","2Xi  Vir","Xi","2","Xi","","Vir","","122.019","4.840","1.975","176.320998","8.258119","A4V","A","1","","" }
{ "69804","70027","125560","5370","","20    Boo","","20","","","Boo","","187.016","4.840","1.048","214.938494","16.306948","K3III","K","1","","" }
{ "80762","81008","149161","6159","","29    Her","","29","","","Her","","351.083","4.840","-0.320","248.151226","11.488041","K4III","K","1","","" }
{ "81411","81660","151101","6223","","18    Dra","","18","","","Dra","","736.245","4.840","-1.928","250.229664","64.589046","K1p","K","1","","" }
{ "81770","82020","151613","6237","GJ 9578","","","","","","Dra","","85.158","4.840","2.756","251.324187","56.781857","F2V","F","1","","" }
{ "98042","98353","189005","7618","","60    Sgr","","60","","","Sgr","","313.311","4.840","-0.073","299.738318","-26.195767","G8II/III","G","1","","" }
{ "111849","112203","215104","8644","","Rho Gru","Rho","","Rho","","Gru","","230.337","4.840","0.595","340.874894","-41.414347","K0III","K","1","","" }
{ "112018","112374","215369","8655","","Eta Gru","Eta","","Eta","","Gru","","414.957","4.840","-0.683","341.407791","-53.500121","K2IIICNIV","K","1","","" }
{ "113743","114104","218376","8797","","1    Cas","","1","","","Cas","","1128.569","4.840","-2.856","346.653390","59.419760","B0.5IV","B","1","","" }
{ "119058","","144070","5978","GJ 9540A","Xi  Sco","Xi","","Xi","","Sco","Graffias","79.357","4.840","2.909","241.091608","-11.374611","F6 IV-V","F","1","","GJ 9540" }
{ "37191","37297","61831","2961","","","","","","","Pup","","555.633","4.840","-1.317","114.863923","-38.308021","B3V","B","1","","" }
{ "42015","42134","73389","3414","","","","","","","Car","","222.026","4.840","0.675","128.831998","-58.009228","K0III","K","1","","" }
{ "53651","53807","95345","4291","","58    Leo","","58","","","Leo","","360.394","4.840","-0.377","165.140202","3.617494","K1III","K","1","","" }
{ "6993","7007","9138","434","","98Mu  Psc","Mu","98","Mu","","Psc","","303.967","4.840","-0.007","22.546309","6.143820","K4III","K","1","","" }
{ "10316","10340","13520","643","","60    And","","60","","","And","","530.335","4.840","-1.216","33.305536","44.231652","K4III","K","1","","" }
{ "10620","10644","13974","660","Gl 92","8Del Tri","Del","8","Del","","Tri","Deltoton","35.173","4.840","4.676","34.262872","34.224231","G0V","G","1","","" }
{ "15419","15457","20630","996","Gl 137","96Kap1Cet","Kap-1","96","Kap","1","Cet","","29.810","4.840","5.035","49.840399","3.370198","G5Vvar","G","1","","" }
{ "19690","19740","26722","1311","","47    Tau","","47","","","Tau","","331.797","4.840","-0.197","63.484939","9.263824","G5III","G","1","","" }
{ "26711","26777","37711","1946","","126    Tau","","126","","","Tau","","635.782","4.840","-1.609","85.323827","16.534148","B3IV...","B","1","","" }
{ "14826","14862","19275","932","","","","","","","Cas","","165.394","4.850","1.325","47.984362","74.393659","A2Vnn","A","1","","" }
{ "15378","15416","20468","991","","","","","","","Per","","1177.460","4.850","-2.938","49.682603","34.222653","K2II","K","1","","" }
{ "64202","64408","114613","4979","Gl 501.2","","","","","","Cen","","67.416","4.850","3.273","198.013515","-37.803022","G3V","G","1","","" }
{ "74608","74837","135291","5666","","Eps Cir","Eps","","Eps","","Cir","","407.695","4.850","-0.635","229.412037","-63.610465","K2.5III","K","1","","" }
{ "87574","87846","163145","6675","","","","","","","Sco","","289.917","4.850","0.106","269.197599","-44.342246","K2III","K","1","","" }
{ "89640","89918","168656","6866","","74    Oph","","74","","","Oph","","260.508","4.850","0.338","275.216929","3.377165","G8III","G","1","","" }
{ "92855","93148","175510","7134","","Lam Tel","Lam","","Lam","","Tel","","611.926","4.850","-1.516","284.615674","-52.938629","A0V","A","1","","" }
{ "36328","36431","59612","2874","","","","","","","Pup","","3106.251","4.850","-5.044","112.464219","-23.024287","A6Ib/II","A","1","","" }
{ "49571","49712","88206","3990","","","","","","","Vel","","1331.251","4.850","-3.204","152.234355","-51.811261","B3IV","B","1","","" }
{ "32352","32438","48250","2470","","12    Lyn","","12","","","Lyn","","214.718","4.860","0.768","101.558925","59.441670","A3V","A","1","","" }
{ "42364","42483","73898","3433","","Zet Pyx","Zet","","Zet","","Pyx","","244.312","4.860","0.487","129.926983","-29.561084","G5III","G","1","","" }
{ "51659","51808","91190","4126","","","","","","","Dra","","247.275","4.860","0.461","158.773174","75.712948","K0III","K","1","","" }
{ "64615","64820","115211","5002","","","","","","","Mus","","1194.712","4.860","-2.959","199.304275","-66.783438","K2Ib/II","K","1","","" }
{ "70104","70327","126128","5385","","","","","","","Boo","","215.001","4.860","0.765","215.844567","8.446617","A0V","A","1","","" }
{ "71606","71832","129312","5480","","31    Boo","","31","","","Boo","","537.325","4.860","-1.224","220.411460","8.161764","G8IIIvar","G","1","","" }
{ "79939","80181","147677","6103","","19Xi  CrB","Xi","19","Xi","","CrB","","183.440","4.860","1.110","245.524305","30.891996","K0III","K","1","","" }
{ "80876","81122","149038","6155","","Mu  Nor","Mu","","Mu","","Nor","","326156.378","4.860","-15.140","248.520919","-44.045315","B0Ia","B","1","","" }
{ "81249","81497","150450","6200","","42    Her","","42","","","Her","","414.430","4.860","-0.660","249.686916","48.928342","M2.5III","M","1","","" }
{ "2204","2210","2429","105","","Eta Scl","Eta","","Eta","","Scl","","451.740","4.860","-0.847","6.982086","-33.007167","M2/M3III","M","1","","" }
{ "15344","15382","20610","994","","15    Eri","","15","","","Eri","","255.408","4.860","0.391","49.592095","-22.511118","K0III","K","1","","" }
{ "85567","85829","159560","6555","","25Nu 2Dra","Nu-2","25","Nu","2","Dra","","99.438","4.860","2.439","263.066511","55.172958","Am","A","1","","" }
{ "86469","86736","160915","6595","Gl 692","58    Oph","","58","","","Oph","","57.574","4.860","3.626","265.857491","-21.683194","F6/F7V","F","1","","" }
{ "91632","91918","172910","7029","","","","","","","Sgr","","466.604","4.860","-0.918","281.080667","-35.641987","B2V","B","1","","" }
{ "92471","92761","174974","7116","","32Nu 1Sgr","Nu-1","32","Nu","1","Sgr","Ainalrami","1124.677","4.860","-2.828","283.542404","-22.744834","K1II","K","1","","" }
{ "94348","94643","179950","7292","","42Psi Sgr","Psi","42","Psi","","Sgr","","298.405","4.860","0.053","288.885103","-25.256682","K0/K1III+..","K","1","","" }
{ "101446","101773","195961","7859","","Rho Pav","Rho","","Rho","","Pav","","189.626","4.860","1.038","309.396976","-61.529918","Fm delta Del","F","1","","" }
{ "108722","109068","209747","8413","","22Nu  Peg","Nu","22","Nu","","Peg","","271.571","4.860","0.258","331.419796","5.058530","K4III","K","1","","" }
{ "96981","97290","186648","7515","","56    Sgr","","56","","","Sgr","","207.611","4.870","0.851","296.590600","-19.761113","K0III","K","1","","" }
{ "106210","106551","205512","8255","","72    Cyg","","72","","","Cyg","","231.481","4.870","0.615","323.693939","38.534054","K1III","K","1","","" }
{ "34805","34899","56022","2746","","","","","","","Pup","","184.373","4.870","1.109","108.305652","-45.182739","Ap","A","1","","" }
{ "42543","42662","74137","3441","","9    Hya","","9","","","Hya","","211.790","4.870","0.808","130.430567","-15.943384","K0IIICN...","K","1","","" }
{ "43700","43825","76483","3556","","Del Pyx","Del","","Del","","Pyx","","247.275","4.870","0.471","133.881516","-27.681871","A3IV","A","1","","" }
{ "48422","48559","85859","3919","","","","","","","Hya","","341.883","4.870","-0.232","148.551380","-25.932345","K2III","K","1","","" }
{ "51830","51979","92036","4162","","","","","","","Hya","","487.528","4.870","-1.003","159.307220","-27.412634","M1III","M","1","","" }
{ "52584","52736","93607","4222","","","","","","","Car","","480.348","4.870","-0.971","161.713472","-64.383474","B3IV","B","1","","" }
{ "6397","6411","8207","390","","46Xi  And","Xi","46","Xi","","And","Adhil","214.435","4.870","0.781","20.585049","45.528778","K0III-IV","K","1","","" }
{ "12062","12093","16161","754","","78Nu  Cet","Nu","78","Nu","","Cet","","340.101","4.870","-0.221","38.968634","5.593246","G8III","G","1","","" }
{ "15072","15110","20150","972","","58Zet Ari","Zet","58","Zet","","Ari","","262.184","4.870","0.344","48.725406","21.044441","A1V","A","1","","" }
{ "19727","19777","26846","1318","","39    Eri","","39","","","Eri","","242.315","4.870","0.515","63.598703","-10.256283","K3III","K","1","","" }
{ "11318","11345","15130","708","","72Rho Cet","Rho","72","Rho","","Cet","","456.163","4.880","-0.848","36.487522","-12.290480","A0V","A","1","","" }
{ "25475","25539","35708","1810","","114    Tau","","114","","","Tau","","624.821","4.880","-1.532","81.908688","21.936965","B2.5IV","B","1","","" }
{ "27399","27468","38751","2002","","132    Tau","","132","","","Tau","","363.608","4.880","-0.356","87.254027","24.567535","G8IIIvar","G","1","","" }
{ "82607","82860","153597","6315","Gl 648","19    Dra","","19","","","Dra","","49.765","4.880","3.963","254.006243","65.134796","F6Vvar","F","1","","" }
{ "87664","87936","163376","6682","","","","","","","Sco","","451.740","4.880","-0.827","269.449189","-41.716295","M0III","M","1","","" }
{ "91559","91845","173009","7032","","Eps Sct","Eps","","Eps","","Sct","","538.212","4.880","-1.208","280.880219","-8.275215","G8II","G","1","","" }
{ "94525","94820","180540","7304","","43    Sgr","","43","","","Sgr","","481.767","4.880","-0.967","289.408665","-18.952908","K0III","K","1","","" }
{ "96039","96341","184127","7424","","Iot Tel","Iot","","Iot","","Tel","","370.632","4.880","-0.398","293.804123","-48.099202","G9III","G","1","","" }
{ "116934","117301","223165","9008","","5Tau Cas","Tau","5","Tau","","Cas","","173.950","4.880","1.245","356.764258","58.651989","K1III","K","1","","" }
{ "117841","118209","224533","9067","","27    Psc","","27","","","Psc","","234.476","4.880","0.597","359.668240","-3.555983","G9III","G","1","","" }
{ "117875","118243","224572","9071","","8Sig Cas","Sig","8","Sig","","Cas","","326156.378","4.880","-15.120","359.752229","55.754928","B1V...","B","1","","" }
{ "58309","58484","104174","4583","","Eps Cha","Eps","","Eps","","Cha","","361.592","4.880","-0.344","179.906946","-78.221839","B9Vn","B","1","","" }
{ "61767","61960","110411","4828","","30Rho Vir","Rho","30","Rho","","Vir","","118.301","4.880","2.082","190.471065","10.235625","A0V","A","1","","" }
{ "63259","63462","112989","4924","","37    Com","","37","","","Com","","660.235","4.880","-1.651","195.068637","30.785021","K1IIIp","K","1","","" }
{ "27741","27810","39764","2056","","Lam Col","Lam","","Lam","","Col","","334.519","4.880","-0.175","88.278674","-33.801361","B5V","B","1","","" }
{ "35315","35412","57060","2781","","29    CMa","","29","","","CMa","","1907.347","4.880","-3.955","109.668246","-24.558701","O7f","O","1","","" }
{ "37159","37265","61110","2930","","71Omi Gem","Omi","71","Omi","","Gem","Jishui","166.321","4.890","1.352","114.791397","34.584346","F3III","F","1","","" }
{ "37800","37908","62721","3003","","81    Gem","","81","","","Gem","","339.393","4.890","-0.196","116.531040","18.510043","K5III","K","1","","" }
{ "51375","51523","91324","4134","Gl 397.2","","","","","","Vel","","71.136","4.890","3.197","157.841627","-53.715484","F6V","F","1","","" }
{ "51860","52009","92055","4163","","","","","","","Hya","","679.492","4.890","-1.704","159.388632","-13.384543","C","C","1","","" }
{ "111489","111841","214680","8622","","10    Lac","","10","","","Lac","","1725.695","4.890","-3.728","339.815328","39.050269","O9V","O","1","","" }
{ "115626","115990","221253","8926","","","","","","","Cas","","621.250","4.890","-1.509","352.508043","58.548920","B3IV","B","1","","" }
{ "908","910","693","33","Gl 10","6    Cet","","6","","","Cet","","61.147","4.890","3.525","2.816079","-15.467977","F5V","F","1","","" }
{ "22400","22453","30504","1533","","","","","","","Per","","503.328","4.890","-1.052","72.477684","37.488275","K4II","K","1","","" }
{ "25239","25302","35439","1789","","25Psi1Ori","Psi-1","25","Psi","1","Ori","","1038.714","4.890","-2.625","81.186777","1.846445","B1V:pe","B","1","","" }
{ "27442","27511","38899","2010","","134    Tau","","134","","","Tau","","248.785","4.890","0.478","87.387212","12.651324","B9IV","B","1","","" }
{ "83358","83613","154494","6355","","60    Her","","60","","","Her","","133.288","4.890","1.833","256.344540","12.740828","A4IV","A","1","","" }
{ "85557","85819","159541","6554","","24Nu 1Dra","Nu-1","24","Nu","1","Dra","","98.656","4.890","2.487","263.043769","55.184243","Am...","A","1","","" }
{ "96811","97118","186675","7517","","15    Cyg","","15","","","Cyg","","289.146","4.890","0.152","296.069141","37.354355","G8III","G","1","","" }
{ "102500","102831","198232","7965","","Alp Mic","Alp","","Alp","","Mic","","378.372","4.890","-0.432","312.492007","-33.779722","G8III","G","1","","" }
{ "57270","57443","102365","4523","Gl 442A","","","","","","Cen","","30.074","4.890","5.066","176.630639","-40.500354","G3/G5V","G","1","","Gl 442" }
{ "57678","57851","103079","4549","","","","","","","Mus","","362.396","4.890","-0.339","177.963553","-65.205910","B4V","B","1","","" }
{ "62689","62886","112033","4894","","35    Com","","35","","","Com","","283.122","4.890","0.197","193.323942","21.244943","G8III","G","1","","" }
{ "69673","69896","123998","5303","","Eta Aps","Eta","","Eta","","Aps","","138.085","4.890","1.756","214.558162","-81.007760","A2m...","A","1","","" }
{ "62487","62683","111597","4874","","","","","","","Cen","","400.192","4.900","-0.544","192.671541","-33.999302","B9V","B","1","","" }
{ "64378","64583","114837","4989","Gl 503A","","","","","","Cen","","59.355","4.900","3.600","198.563677","-59.103235","F7IV","F","1","","Gl 503" }
{ "78416","78655","143699","5967","","","","","","","Lup","","399.701","4.900","-0.542","240.850801","-38.602541","B6III/IV","B","1","","" }
{ "78581","78821","144218","5985","","8Bet2Sco","Bet-2","8","Bet","2","Sco","Acrab B","398.237","4.900","-0.534","241.360646","-19.801860","B2V","B","1","","" }
{ "80442","80686","147584","6098","Gl 624","Zet TrA","Zet","","Zet","","TrA","","39.520","4.900","4.483","247.116324","-70.084401","F9V","F","1","","" }
{ "3793","3801","4636","223","","25Nu  Cas","Nu","25","Nu","","Cas","","411.814","4.900","-0.606","12.208379","50.968168","B9III","B","1","","" }
{ "6656","6670","8705","412","","46    Cet","","46","","","Cet","","287.616","4.900","0.173","21.405142","-14.598796","K2III","K","1","","" }
{ "26820","26885","37984","1963","","51    Ori","","51","","","Ori","","293.570","4.900","0.129","85.619300","1.474629","K1III","K","1","","" }
{ "33398","33485","50973","2585","","16    Lyn","","16","","","Lyn","","240.883","4.900","0.558","104.404635","45.094094","A2Vn","A","1","","" }
{ "97368","97679","187811","7565","","12    Vul","","12","","","Vul","","629.646","4.900","-1.528","297.767113","22.610046","B2.5V","B","1","","" }
{ "102459","102790","198048","7952","","Zet Ind","Zet","","Zet","","Ind","","412.856","4.900","-0.612","312.370630","-46.226826","K5III","K","1","","" }
{ "83351","83608","154905","6369","GJ 9584B","21Mu  Dra","Mu","21","Mu","","Dra","","89.480","4.910","2.718","256.333932","54.470042","F5","F","2","119127","GJ 9584" }
{ "97744","98055","189037","7619","","24Psi Cyg","Psi","24","Psi","","Cyg","","281.412","4.910","0.230","298.907503","52.438948","A4Vn","A","1","","" }
{ "100775","101101","195135","7831","","69    Aql","","69","","","Aql","","199.851","4.910","0.974","307.412502","-2.885531","K2III","K","1","","" }
{ "101365","101692","196321","7873","","70    Aql","","70","","","Aql","","1299.428","4.910","-3.092","309.181801","-2.549957","K5II","K","1","","" }
{ "12590","12623","16739","788","Gl 105.6","12    Per","","12","","","Per","","78.896","4.910","2.992","40.562163","40.193944","F9V","F","1","","" }
{ "21087","21139","28749","1437","","45    Eri","","45","","","Eri","","656.250","4.910","-1.608","67.969447","-0.044011","K3II-III","K","1","","" }
{ "23307","23362","32309","1621","","","","","","","Lep","","197.910","4.910","0.995","75.356580","-20.051918","B9V","B","1","","" }
{ "23780","23835","32923","1656","Gl 188A","104    Tau","","104","","","Tau","","50.341","4.910","3.968","76.862453","18.645052","G4V","G","1","","Gl 188" }
{ "61773","61966","110335","4823","","","","","","","Cru","","956.470","4.910","-2.426","190.485760","-59.685819","B6IV","B","1","","" }
{ "66048","66257","118216","5110","","","","","","","CVn","","148.930","4.910","1.612","203.699148","37.182415","F2IV SB","F","1","","" }
{ "73246","73473","132742","5586","","19Del Lib","Del","19","Del","","Lib","","293.570","4.910","0.139","225.243121","-8.518943","B9.5V","B","1","","" }
{ "74376","74604","135153","5660","","1    Lup","","1","","","Lup","","1953.032","4.910","-3.976","228.655501","-31.519121","F3III","F","1","","" }
{ "81474","81724","150416","6196","GJ 9574","","","","","","Oph","","412.334","4.910","-0.599","250.393265","-17.742167","G8II/III","G","1","","" }
{ "110961","111310","213442","8582","","Nu  Tuc","Nu","","Nu","","Tuc","","290.175","4.910","0.164","338.250151","-61.982122","M4III","M","1","","" }
{ "112826","113186","216735","8717","","50Rho Peg","Rho","50","Rho","","Peg","","312.111","4.910","0.006","343.806967","8.816166","A1V","A","1","","" }
{ "30020","30093","44131","2275","","","","","","","Ori","","464.610","4.910","-0.858","94.998334","-2.944493","M1III","M","1","","" }
{ "34530","34622","54810","2701","","20    Mon","","20","","","Mon","","202.834","4.910","0.941","107.557008","-4.237106","K0III","K","1","","" }
{ "34660","34752","54716","2696","","63    Aur","","63","","","Aur","","485.352","4.910","-0.953","107.913826","39.320549","K4II-III","K","1","","" }
{ "51934","52085","92214","4171","","Phi3Hya","Phi-3","","Phi","3","Hya","","210.559","4.910","0.860","159.645648","-16.876572","G8III","G","1","","" }
{ "28503","28574","40967","2128","","3    Mon","","3","","","Mon","","784.030","4.920","-1.985","90.460091","-10.597930","B5III","B","1","","" }
{ "28744","28816","41511","2148","","17    Lep","","17","","","Lep","","908.513","4.920","-2.305","91.246372","-16.484435","Ap shell","A","1","","" }
{ "30447","30520","44537","2289","","46Psi1Aur","Psi-1","46","Psi","1","Aur","","326156.378","4.920","-15.080","96.224593","49.287893","K5Iabvar","K","1","","" }
{ "33971","34059","53811","2672","","","","","","","Pup","","197.551","4.920","1.009","105.973436","-49.583920","A4IV","A","1","","" }
{ "36444","36547","55966","2742","","","","","","","Cam","","499.474","4.920","-1.005","112.768658","82.411466","M4IIIa","M","1","","" }
{ "45308","45439","79917","3682","","","","","","","Vel","","224.626","4.920","0.730","138.903001","-38.569942","K1III","K","1","","" }
{ "54046","54204","96202","4314","GJ 3642A","Chi1Hya","Chi-1","","Chi","1","Hya","","141.010","4.920","1.741","166.333005","-27.293612","F3IV/V","F","1","","GJ 3642" }
{ "60509","60697","108283","4733","","14    Com","","14","","","Com","","275.936","4.920","0.283","186.600271","27.268237","F0p","F","1","","" }
{ "65991","66200","118022","5105","","78    Vir","","78","","","Vir","","184.791","4.920","1.154","203.533045","3.658967","A1p SrCrEu","A","1","","" }
{ "67267","67480","120539","5201","","6    Boo","","6","","","Boo","","401.176","4.920","-0.530","207.428467","21.264105","K4III","K","1","","" }
{ "71878","72104","129685","5489","","","","","","","Cen","","214.295","4.920","0.832","221.246670","-35.191826","A0V","A","1","","" }
{ "75150","75379","137052","5723","","31Eps Lib","Eps","31","Eps","","Lib","","101.860","4.920","2.447","231.049542","-10.322266","F5IV","F","1","","" }
{ "88451","88726","165189","6749","","","","","","","CrA","","136.467","4.920","1.812","271.707875","-43.425216","A5V","A","1","","" }
{ "89583","89861","168720","6868","","106    Her","","106","","","Her","","392.015","4.920","-0.479","275.074640","21.961297","M1III","M","1","","" }
{ "90548","90830","170465","6934","","Del1Tel","Del-1","","Del","1","Tel","","707.497","4.920","-1.761","277.939307","-45.914814","B6IV","B","1","","" }
{ "92399","92689","175535","7137","","","","","","","Dra","","456.163","4.920","-0.808","283.306433","50.708221","G8III","G","1","","" }
{ "102057","102388","197752","7939","","30    Vul","","30","","","Vul","","324.857","4.920","-0.071","311.218779","25.270617","K2III","K","1","","" }
{ "9042","9061","11930","565","","56    Cet","","56","","","Cet","","352.983","4.920","-0.252","29.167479","-22.526785","K3III","K","1","","" }
{ "19465","19515","26612","1302","","Del Hor","Del","","Del","","Hor","","178.814","4.930","1.235","62.710621","-41.993573","A9V","A","1","","" }
{ "19940","19990","27045","1329","","50Ome2Tau","Ome-2","50","Ome","2","Tau","","94.401","4.930","2.622","64.315259","20.578591","A3m","A","1","","" }
{ "20203","20252","27348","1343","","54    Per","","54","","","Per","","218.311","4.930","0.802","65.102673","34.566725","G8III","G","1","","" }
{ "23125","23179","31647","1592","","4Ome Aur","Ome","4","Ome","","Aur","","170.495","4.930","1.339","74.814177","37.890245","A1V","A","1","","" }
{ "96180","96483","184915","7446","","39Kap Aql","Kap","39","Kap","","Aql","","1681.218","4.930","-3.631","294.222705","-7.027477","B0.5III","B","1","","" }
{ "98804","99120","190421","7673","","Xi  Tel","Xi","","Xi","","Tel","","1079.988","4.930","-2.670","301.846504","-52.880793","M1II","M","1","","" }
{ "98986","99303","191610","7708","","28    Cyg","","28","","","Cyg","","1035.417","4.930","-2.578","302.356744","36.839621","B2.5V","B","1","","" }
{ "99451","99770","192640","7736","","29    Cyg","","29","","","Cyg","","139.264","4.930","1.778","303.633428","36.806302","A2V","A","1","","" }
{ "102240","102571","198134","7956","","","","","","","Cyg","","444.961","4.930","-0.744","311.794780","34.374123","K3IIIvar","K","1","","" }
{ "36836","36942","61248","2934","","","","","","","Car","","392.486","4.930","-0.472","113.915474","-52.533836","K3III","K","1","","" }
{ "37502","37609","61497","2946","","24    Lyn","","24","","","Lyn","","266.904","4.930","0.365","115.751817","58.710360","A3IVn","A","1","","" }
{ "38969","39079","65695","3122","","27    Mon","","27","","","Mon","","274.774","4.930","0.302","119.933969","-3.679583","K2III","K","1","","" }
{ "43812","43937","77002","3582","","","","","","","Car","","673.877","4.930","-1.646","134.243425","-59.229338","B2IV-V","B","1","","" }
{ "47457","47592","84117","3862","Gl 364","","","","","","Hya","","48.965","4.930","4.048","145.560161","-23.915569","G0V","G","1","","" }
{ "56113","56280","100286","4443","","","","","","","Hya","","85.763","4.930","2.831","173.068357","-29.261022","F8V","F","1","","" }
{ "56816","56986","101570","4499","","","","","","","Cen","","888.710","4.930","-2.247","175.223516","-62.090101","G3Ib","G","1","","" }
{ "59665","59847","106714","4667","","7    Com","","7","","","Com","","249.355","4.930","0.513","184.085581","23.945409","K0III","K","1","","" }
{ "62566","62763","111812","4883","","31    Com","","31","","","Com","","290.692","4.930","0.180","192.924676","27.540712","G0III","G","1","","" }
{ "63300","63503","113139","4931","","78    UMa","","78","","","UMa","","82.991","4.930","2.902","195.181870","56.366338","F2V","F","1","","" }
{ "69047","69269","123934","5301","","","","","","","Vir","","460.673","4.930","-0.820","212.710357","-16.302030","M1III","M","1","","" }
{ "72404","72631","130952","5535","","11    Lib","","11","","","Lib","","218.603","4.930","0.799","222.754463","-2.299150","G8...","G","1","","" }
{ "73768","73996","134083","5634","Gl 578","45    Boo","","45","","","Boo","","63.777","4.930","3.474","226.825228","24.869195","F5V","F","1","","" }
{ "79135","79375","145570","6031","","15Psi Sco","Psi","15","Psi","","Sco","","155.609","4.930","1.537","242.999953","-10.064253","A3IV","A","1","","" }
{ "114577","114939","219576","8850","","92Chi Aqr","Chi","92","Chi","","Aqr","","613.076","4.930","-1.440","349.212248","-7.726504","M3III","M","1","","" }
{ "116706","117073","222842","8997","","78    Peg","","78","","","Peg","","224.317","4.930","0.743","355.997832","29.361454","K0III","K","1","","" }
{ "33270","33357","51799","2608","","","","","","","Pup","","860.571","4.940","-2.167","104.066625","-48.721144","M1III","M","1","","" }
{ "35628","35727","57821","2812","","","","","","","CMa","","481.057","4.940","-0.904","110.556371","-19.016600","B5II/III","B","1","","" }
{ "39313","39424","66216","3149","","Chi Gem","Chi","","Chi","","Gem","","256.211","4.940","0.464","120.879510","27.794332","K2III","K","1","","" }
{ "43224","43347","75710","3520","","","","","","","Vel","","1109.376","4.940","-2.718","132.448504","-45.307875","A2III","A","1","","" }
{ "48478","48615","85951","3923","","","","","","","Hya","Felis","614.230","4.940","-1.435","148.717542","-19.009360","K5III","K","1","","" }
{ "50788","50933","89822","4072","GJ 9327","","","","","","UMa","","339.393","4.940","-0.146","156.032723","65.566423","A0sp...","A","1","","" }
{ "51348","51495","91496","4142","","","","","","","Car","","1032.140","4.940","-2.562","157.758626","-73.221490","K4/K5III","K","1","","" }
{ "10256","10280","13480","642","","6    Tri","","6","","","Tri","","290.692","4.940","0.190","33.092859","30.303067","F5V comp SB","F","1","","" }
{ "13871","13905","18449","882","","24    Per","","24","","","Per","","368.122","4.940","-0.323","44.765344","35.183128","K2III","K","1","","" }
{ "92987","93279","176670","7192","","15Lam Lyr","Lam","15","Lam","","Lyr","","1105.615","4.940","-2.711","285.003437","32.145514","K3III","K","1","","" }
{ "99423","99742","192425","7724","","67Rho Aql","Rho","67","Rho","","Aql","","149.957","4.940","1.627","303.569242","15.197609","A2V","A","1","","" }
{ "100812","101138","195556","7844","","45Ome1Cyg","Ome-1","45","Ome","1","Cyg","","908.513","4.940","-2.285","307.514740","48.951569","B2.5IV","B","1","","" }
{ "109076","109422","210302","8447","Gl 849.1","15Tau PsA","Tau","15","Tau","","PsA","","59.616","4.940","3.630","332.536389","-32.548407","F6V","F","1","","" }
{ "63963","64166","114149","4958","","45Psi Hya","Psi","45","Psi","","Hya","","231.481","4.940","0.685","197.263630","-23.118070","K0III","K","1","","" }
{ "64335","64540","115004","4997","","","","","","","CVn","","459.375","4.940","-0.804","198.428962","40.152885","K0III","K","1","","" }
{ "80406","80650","149212","6161","","15    Dra","","15","","","Dra","","486.800","4.940","-0.930","246.995995","68.768137","A0III","A","1","","" }
{ "55779","55945","99648","4418","","84Tau Leo","Tau","84","Tau","","Leo","","562.339","4.950","-1.233","171.984333","2.856265","G8II-III","G","1","","" }
{ "61191","61384","109551","4795","","6    Dra","","6","","","Dra","","601.764","4.950","-1.380","188.683531","70.021770","K2III","K","1","","" }
{ "77971","78207","142983","5941","","48    Lib","","48","","","Lib","","467.943","4.950","-0.834","239.547371","-14.279358","B8Ia/Iab","B","1","","" }
{ "79270","79509","145397","6024","","Kap Nor","Kap","","Kap","","Nor","","428.027","4.950","-0.640","243.369713","-54.630467","G4III","G","1","","" }
{ "79580","79822","148048","6116","GJ 3950A","21Eta UMi","Eta","21","Eta","","UMi","","96.984","4.950","2.584","244.376869","75.755330","F5V","F","1","","GJ 3950" }
{ "3407","3414","4058","184","","20Pi  Cas","Pi","20","Pi","","Cas","","175.071","4.950","1.301","10.866985","47.024546","A5V","A","1","","" }
{ "6228","6242","7927","382","","34Phi Cas","Phi","34","Phi","","Cas","","326156.378","4.950","-15.050","20.020487","58.231611","F0Ia","F","1","","" }
{ "18458","18505","24479","1204","","","","","","","Cam","","360.793","4.950","-0.269","59.356000","63.072264","B9.5V","B","1","","" }
{ "26671","26736","37756","1952","","","","","","","Ori","","898.502","4.950","-2.250","85.211311","-1.128787","B2IV-V","B","1","","" }
{ "112557","112917","216397","8699","","15    Lac","","15","","","Lac","","325.181","4.950","-0.043","343.008379","43.312417","M0III","M","1","","" }
{ "115376","115738","220825","8911","","8Kap Psc","Kap","8","Kap","","Psc","","153.485","4.950","1.587","351.733146","1.255608","A0p","A","1","","" }
{ "116878","117245","223075","9004","","19    Psc","","19","","","Psc","","898.502","4.950","-2.250","356.597985","3.486811","C5II","C","1","","" }
{ "29361","29434","42545","2198","","69    Ori","","69","","","Ori","","528.617","4.950","-1.099","93.013664","16.130406","B5Vn","B","1","","" }
{ "97757","98068","188892","7613","","22    Cyg","","22","","","Cyg","","1443.170","4.950","-3.279","298.965675","38.486705","B5IV","B","1","","" }
{ "98298","98608","189124","7625","","","","","","","Pav","","475.447","4.950","-0.868","300.436390","-59.375893","M6III","M","1","","" }
{ "88382","88657","165625","6765","","98    Her","","98","","","Her","","737.910","4.960","-1.813","271.507920","22.218879","M3IIIa+...","M","1","","" }
{ "88876","89153","166464","6801","","11    Sgr","","1","","","Sgr","","256.010","4.960","0.486","272.930552","-23.701235","K0III","K","1","","" }
{ "88895","89172","167006","6815","","104    Her","","104","","","Her","","544.501","4.960","-1.153","272.975660","31.405350","M3III","M","1","","" }
{ "115225","115590","220652","8904","","4    Cas","","4","","","Cas","","785.919","4.960","-1.950","351.209392","62.282806","M1III","M","1","","" }
{ "67281","67494","120452","5196","","89    Vir","","89","","","Vir","","244.312","4.960","0.587","207.467860","-18.134168","K0III","K","1","","" }
{ "77944","78180","143466","5960","","","","","","","Dra","","109.522","4.960","2.330","239.447938","54.749762","F0IV","F","1","","" }
{ "78411","78650","143787","5969","","","","","","","Sco","","207.611","4.960","0.941","240.835947","-25.865240","K3III","K","1","","" }
{ "7803","7818","10205","477","","53Tau And","Tau","53","Tau","","And","","712.132","4.960","-1.736","25.145058","40.577049","B8III","B","1","","" }
{ "7903","7918","10307","483","Gl 67","","","","","","And","","41.549","4.960","4.434","25.445739","42.613369","G2V","G","1","","" }
{ "11888","11918","16046","749","","Ome For","Ome","","Ome","","For","","483.912","4.960","-0.897","38.461271","-28.232343","B9V","B","1","","" }
{ "15609","15648","20677","1002","","32    Per","","32","","","Per","","150.580","4.960","1.638","50.360716","43.329651","A3V","A","1","","" }
{ "20825","20877","28292","1407","","75    Tau","","75","","","Tau","","186.695","4.960","1.171","67.109874","16.359672","K2IIIvar","K","1","","" }
{ "24762","24822","34559","1739","","109    Tau","","109","","","Tau","","247.275","4.960","0.561","79.819172","22.096494","G8III","G","1","","" }
{ "27880","27949","39283","2029","","30Xi  Aur","Xi","30","Xi","","Aur","","238.244","4.960","0.642","88.711599","55.706947","A2V","A","1","","" }
{ "27940","28010","40176","2087","","Xi  Col","Xi","","Xi","","Col","","332.813","4.970","-0.074","88.874632","-37.120668","K1IIICN...","K","1","","" }
{ "38426","38538","64145","3067","","83Phi Gem","Phi","83","Phi","","Gem","","222.480","4.970","0.801","118.374236","26.765783","A3V","A","1","","" }
{ "50702","50847","90264","4089","","","","","","","Car","","401.670","4.970","-0.482","155.742358","-66.901498","B8V","B","1","","" }
{ "59988","60172","107328","4695","","16    Vir","","16","","","Vir","","307.985","4.970","0.094","185.087421","3.312574","K1III","K","1","","" }
{ "65515","65721","117176","5072","Gl 512.1","70    Vir","","70","","","Vir","","58.661","4.970","3.695","202.107556","13.778787","G5V","G","1","","" }
{ "70530","70753","126769","5407","","52    Hya","","52","","","Hya","","393.434","4.970","-0.437","217.043453","-29.491638","B7/B8V","B","1","","" }
{ "76506","76742","139663","5824","","42    Lib","","42","","","Lib","","382.364","4.970","-0.375","235.070401","-23.818078","K3III","K","1","","" }
{ "79548","79790","146143","6058","","Gam1Nor","Gam-1","","Gam","1","Nor","","1469.173","4.970","-3.298","244.253892","-50.068122","F9Ia","F","1","","" }
{ "83175","83430","154143","6337","","","","","","","Her","","394.863","4.970","-0.445","255.782796","14.091947","M3III","M","1","","" }
{ "115944","116310","221673","8943","","72    Peg","","72","","","Peg","","549.085","4.970","-1.161","353.488260","31.325277","K4III","K","1","","" }
{ "116392","116758","222345","8968","","102Ome1Aqr","Ome-1","102","Ome","1","Aqr","","142.178","4.970","1.773","354.946112","-14.222178","A7IV","A","1","","" }
{ "116854","117221","223047","9003","","20Psi And","Psi","20","Psi","","And","","1003.558","4.970","-2.471","356.508517","46.420276","G5Ib","G","1","","" }
{ "5849","5862","7570","370","Gl 55","Nu  Phe","Nu","","Nu","","Phe","","49.298","4.970","4.073","18.795647","-45.531664","F8V","F","1","","" }
{ "8990","9009","11529","548","","46Ome Cas","Ome","46","Ome","","Cas","","701.412","4.970","-1.693","29.000049","68.685242","B8III","B","1","","" }
{ "17271","17313","22951","1123","","40    Per","","40","","","Per","","1055.522","4.970","-2.580","55.594359","33.965026","B0.5V","B","1","","" }
{ "18725","18772","25728","1266","","Iot Ret","Iot","","Iot","","Ret","","319.136","4.970","0.017","60.325458","-61.078822","K4III","K","1","","" }
{ "20200","20250","27382","1348","","52Phi Tau","Phi","52","Phi","","Tau","","321.020","4.970","0.004","65.088407","27.350754","K1III","K","1","","" }
{ "7984","7999","10550","500","","","","","","","Cet","","1190.352","4.980","-2.831","25.681292","-3.690200","K3II-III","K","1","","" }
{ "10030","10053","13174","623","","14    Ari","","14","","","Ari","","288.634","4.980","0.245","32.355547","25.939892","F2III","F","1","","" }
{ "13850","13884","18866","909","","Bet Hor","Bet","","Bet","","Hor","","294.631","4.980","0.201","44.699081","-64.071284","A5III","A","1","","" }
{ "23728","23783","32537","1637","Gl 187.2A","9    Aur","","9","","","Aur","","85.740","4.980","2.881","76.669338","51.597720","F0V","F","1","","Gl 187.2" }
{ "26155","26220","37020","1893","","41The1Ori","The-1","41","The","1","Ori","","326156.378","4.980","-15.020","83.815926","-5.387315","O7","O","1","","" }
{ "26170","26235","37041","1897","","43The2Ori","The-2","43","The","2","Ori","","1545.765","4.980","-3.399","83.845420","-5.416060","O9.5Vpe","O","1","","" }
{ "89877","90156","170073","6923","","39    Dra","","39","","","Dra","","184.165","4.980","1.221","275.977612","58.800736","A3V","A","1","","" }
{ "92659","92951","175639","7142","","63The2Ser","The-2","63","The","2","Ser","Alya B","169.432","4.980","1.402","284.061014","4.202132","A5Vn","A","1","","" }
{ "94771","95066","181391","7333","","26    Aql","","26","","","Aql","","154.211","4.980","1.607","290.137101","-5.415766","G8III-IV...","G","1","","" }
{ "97762","98073","189276","7633","","","","","","","Cyg","","916.170","4.980","-2.263","298.980762","58.845969","K5II-III","K","1","","" }
{ "37273","37379","61772","2959","","","","","","","Pup","","695.429","4.980","-1.664","115.096711","-15.263920","K3III","K","1","","" }
{ "42390","42509","73840","3431","","6    Hya","","6","","","Hya","","388.281","4.980","-0.399","130.006136","-12.475372","K3III","K","1","","" }
{ "53669","53824","95382","4294","","59    Leo","","59","","","Leo","","151.208","4.980","1.649","165.186677","6.101449","A5III","A","1","","" }
{ "57523","57696","102839","4538","","","","","","","Mus","","948.129","4.980","-2.337","177.485927","-70.225790","G5Ib","G","1","","" }
{ "60558","60746","108382","4738","","16    Com","","16","","","Com","","277.816","4.980","0.328","186.747072","26.825699","A4V","A","1","","" }
{ "75811","76041","138629","5774","","53Nu 2Boo","Nu-2","53","Nu","2","Boo","","388.281","4.980","-0.399","232.945768","40.899332","A5V","A","1","","" }
{ "78256","78493","143807","5971","","14Iot CrB","Iot","14","Iot","","CrB","","311.813","4.980","0.078","240.360701","29.851061","A0p...","A","1","","" }
{ "55395","55560","98839","4392","","56    UMa","","56","","","UMa","","532.935","4.990","-1.076","170.706634","43.482703","G8II","G","1","","" }
{ "59674","59856","106760","4668","","","","","","","Com","","316.350","4.990","0.056","184.125595","33.061527","K1III","K","1","","" }
{ "66609","66821","118991","5141","","","","","","","Cen","","271.345","4.990","0.390","205.436622","-54.559425","B8Vn+...","B","1","","" }
{ "69167","69389","124224","5313","","","","","","","Vir","","258.240","4.990","0.497","213.065851","2.409433","B9p Si","B","1","","" }
{ "74977","75206","136351","5698","GJ 3901","Nu 1Lup","Nu-1","","Nu","1","Lup","","116.944","4.990","2.217","230.534631","-47.927792","F8V","F","1","","" }
{ "75083","75312","137107","5727","Gl 584A","2Eta CrB","Eta","2","Eta","","CrB","","58.263","4.990","3.730","230.801248","30.287812","G2V","G","1","","Gl 584" }
{ "78087","78323","143009","5943","","","","","","","Lup","","436.038","4.990","-0.640","239.876141","-41.744436","G8III","G","1","","" }
{ "32758","32844","49520","2516","","58Psi7Aur","Psi-7","58","Psi","7","Aur","","378.811","4.990","-0.335","102.691455","41.781230","K3III","K","1","","" }
{ "32769","32855","50235","2549","","","","","","","Pup","","815.391","4.990","-2.000","102.718133","-34.367318","K2/K3III","K","1","","" }
{ "33882","33971","52918","2648","","19    Mon","","19","","","Mon","","1217.001","4.990","-2.869","105.728236","-4.239231","B1V","B","1","","" }
{ "35941","36041","58367","2828","","2Eps CMi","Eps","2","Eps","","CMi","","1042.033","4.990","-2.532","111.412071","9.276097","G8III","G","1","","" }
{ "40145","40259","68752","3229","","20    Pup","","20","","","Pup","","869.750","4.990","-2.140","123.333201","-15.788221","G5Ib/II","G","1","","" }
{ "44531","44659","77996","3613","","18Ome Hya","Ome","18","Ome","","Hya","","896.034","4.990","-2.204","136.493195","5.092316","K2II-III","K","1","","" }
{ "44957","45085","79186","3654","","","","","","","Vel","","326156.378","4.990","-15.010","137.768333","-44.867902","B5Ia","B","1","","" }
{ "46637","46771","82395","3782","","5Xi  Leo","Xi","5","Xi","","Leo","","215.569","4.990","0.889","142.986416","11.299827","K0IIIvar","K","1","","" }
{ "355","355","225212","9103","","3    Cet","","3","","","Cet","","2090.746","4.990","-4.044","1.125494","-10.509523","K3Ibvar","K","1","","" }
{ "9485","9505","12303","590","","4    Per","","4","","","Per","","728.028","4.990","-1.754","30.575391","54.487541","B8III","B","1","","" }
{ "16108","16147","21278","1034","","","","","","","Per","","524.367","4.990","-1.041","52.012762","49.062866","B5V","B","1","","" }
{ "17262","17304","23227","1134","","Del For","Del","","Del","","For","","847.160","4.990","-2.083","55.562092","-31.938361","B5III","B","1","","" }
{ "18441","18488","24480","1205","","","","","","","Cam","","1462.585","4.990","-3.268","59.284544","61.108883","K3I-II","K","1","","" }
{ "21591","21644","29573","1483","","","","","","","Eri","","232.637","4.990","0.724","69.723149","-12.123121","A0V","A","1","","" }
{ "25079","25142","35149","1770","","23    Ori","","23","","","Ori","","1553.126","4.990","-3.399","80.708334","3.544452","B1V","B","1","","" }
{ "89071","89348","168151","6850","Gl 708.1","36    Dra","","36","","","Dra","","74.755","4.990","3.189","273.473181","64.397287","F5V","F","1","","" }
{ "95077","95372","182568","7372","","2    Cyg","","2","","","Cyg","","842.781","4.990","-2.071","291.031574","29.621338","B3IV","B","1","","" }
{ "98527","98842","190056","7659","","","","","","","Sgr","","290.692","4.990","0.240","301.081616","-32.056296","K1III/IV","K","1","","" }
{ "108943","109289","210066","8433","","Ups PsA","Ups","","Ups","","PsA","","424.130","4.990","-0.580","332.108048","-34.043841","K4III","K","1","","" }
{ "112928","113288","216946","8726","","","","","","","Lac","Tengshe","1598.806","4.990","-3.462","344.108327","49.733544","K5Ibvar","K","1","","" }
{ "114753","115115","219832","8865","","95Psi3Aqr","Psi-3","95","Psi","3","Aqr","","261.553","4.990","0.469","349.740317","-9.610750","A0V","A","1","","" }
{ "117754","118121","224392","9062","","Eta Tuc","Eta","","Eta","","Tuc","","154.723","5.000","1.619","359.395907","-64.298231","A1V","A","1","","" }
{ "118562","","","","Gl 321.3B","","","","","","Vel","","79.745","5.000","3.059","131.174096","-54.708074","","","2","42794","Gl 321.3" }
{ "119059","","144069","5977","GJ 9540B","Xi  Sco","Xi","","Xi","","Sco","","79.357","5.000","3.069","241.091608","-11.374611","F6 IV-V","F","2","119058","GJ 9540" }
{ "119259","","177475","7227","Gl 743.1B","Gam CrA","Gam","","Gam","","CrA","","58.357","5.000","3.737","286.602704","-37.064740","F8 V","F","2","93530","Gl 743.1" }
{ "18970","19018","25291","1242","","","","","","","Cam","","2038.477","5.000","-3.979","61.113178","59.155507","F0II","F","1","","" }
{ "25215","25278","35296","1780","Gl 202","111    Tau","","111","","","Tau","","46.922","5.000","4.210","81.106068","17.383534","F8V SB","F","1","","" }
{ "55423","55588","98993","4396","","","","","","","Cen","","1055.522","5.000","-2.550","170.802862","-36.164769","K4III","K","1","","" }
{ "57003","57175","101947","4511","","","","","","","Cen","","326156.378","5.000","-15.000","175.879985","-62.489396","F9Ia","F","1","","" }
{ "75777","76008","139669","5826","","15The UMi","The","15","The","","UMi","","856.054","5.000","-2.095","232.854278","77.349352","K5III","K","1","","" }
{ "78804","79043","145001","6008","","7Kap Her","Kap","7","Kap","","Her","Marsic","367.707","5.000","-0.260","242.018860","17.046980","G8III","G","1","","" }
{ "28962","29034","42167","2177","","The Col","The","","The","","Col","Elkurud","721.585","5.000","-1.724","91.881802","-37.252920","B8:IV","B","1","","" }
{ "29662","29735","43445","2244","","","","","","","CMa","","407.695","5.000","-0.485","93.937025","-13.718414","B9V","B","1","","" }
{ "33258","33345","51250","2593","","18Mu  CMa","Mu","18","Mu","","CMa","","1244.872","5.000","-2.908","104.027691","-14.043430","B9.5V","B","1","","" }
{ "35287","35384","56169","2751","","","","","","","Lyn","","348.830","5.000","-0.146","109.633242","49.464756","A4IIIn","A","1","","" }
{ "47072","47205","83240","3827","","10    Leo","","10","","","Leo","","245.600","5.000","0.616","144.302781","6.835802","K1IIIvar","K","1","","" }
{ "87788","88060","163755","6693","","","","","","","Sgr","","1012.908","5.000","-2.461","269.772005","-30.253025","K5/M0III","K","1","","" }
{ "88512","88788","166208","6791","","","","","","","Her","","409.744","5.000","-0.495","271.869748","43.461891","G8III...","G","1","","" }
{ "92554","92845","175190","7120","GJ 9637","35Nu 2Sgr","Nu-2","35","Nu","2","Sgr","","273.851","5.000","0.380","283.779735","-22.671328","K1Ib/II","K","1","","" }
{ "93115","93408","177196","7215","","16    Lyr","","16","","","Lyr","","122.110","5.000","2.133","285.359865","46.934812","A7V","A","1","","" }
{ "94195","94490","180610","7309","","54    Dra","","54","","","Dra","","165.226","5.000","1.477","288.479811","57.705102","K2III","K","1","","" }
{ "95973","96275","184606","7437","","9    Vul","","9","","","Vul","","552.807","5.000","-1.146","293.645399","19.773403","B8IIIn","B","1","","" }
{ "96986","97295","187013","7534","Gl 767.1A","17    Cyg","","17","","","Cyg","","69.248","5.000","3.365","296.606655","33.727598","F5","F","1","","Gl 767.1" }
{ "84575","84833","157049","6452","","","","","","","Her","","479.642","5.010","-0.827","260.078628","18.057081","M2III","M","1","","" }
{ "97186","97496","187362","7546","","8Zet Sge","Zet","8","Zet","","Sge","","255.009","5.010","0.544","297.244413","19.142042","A3V","A","1","","" }
{ "97947","98258","188899","7614","","61    Sgr","","61","","","Sgr","","265.600","5.010","0.456","299.487628","-15.491490","A2V","A","1","","" }
{ "56693","56862","101379","4492","","","","","","","Mus","","501.779","5.010","-0.925","174.873401","-65.397766","G2III + A","G","1","","" }
{ "59875","60059","107079","4682","","","","","","","Cen","","494.176","5.010","-0.892","184.749114","-55.143002","M1III","M","1","","" }
{ "60459","60646","108225","4728","","6    CVn","","6","","","CVn","","261.553","5.010","0.489","186.462298","39.018616","G8III-IV","G","1","","" }
{ "60809","60998","108907","4765","","4    Dra","","4","","","Dra","","621.250","5.010","-1.389","187.528018","69.201123","M3IIIa","M","1","","" }
{ "839","841","571","27","","22    And","","22","","","And","","1230.779","5.010","-2.874","2.580186","46.072272","F2II","F","1","","" }
{ "2213","2219","2411","103","","47    Psc","","47","","","Psc","","528.617","5.010","-1.039","7.012132","17.893125","M3IIIvar","M","1","","" }
{ "7703","7719","10072","469","","52Chi And","Chi","52","Chi","","And","","250.312","5.010","0.585","24.837529","44.386165","G8III...","G","1","","" }
{ "23375","23430","32436","1628","","","","","","","Lep","","233.135","5.010","0.739","75.540900","-26.275029","K1III","K","1","","" }
{ "24448","24504","33959","1706","","14    Aur","","14","","","Aur","","285.601","5.010","0.298","78.851649","32.687600","A9IV","A","1","","" }
{ "29280","29353","43455","2245","","Eta2Dor","Eta-2","","Eta","2","Dor","","640.779","5.010","-1.456","92.812507","-65.589417","M2.5III","M","1","","" }
{ "29846","29919","42973","2215","","1    Lyn","","1","","","Lyn","","638.271","5.010","-1.448","94.478443","61.515286","M3III","M","1","","" }
{ "36326","36429","59148","2861","","65    Gem","","65","","","Gem","","483.912","5.010","-0.847","112.453196","27.916146","K2III","K","1","","" }
{ "38313","38423","64379","3079","Gl 292A","","","","","","Pup","","58.525","5.010","3.740","118.065364","-34.705442","F3/F5V","F","1","","Gl 292" }
{ "41969","42088","73155","3407","","","","","","","Vel","","849.366","5.010","-2.068","128.681672","-49.944203","K1/K2II","K","1","","" }
{ "46817","46950","83058","3819","","","","","","","Vel","","903.480","5.010","-2.202","143.536651","-51.255266","B1.5IV","B","1","","" }
{ "52274","52425","92523","4181","","","","","","","UMa","","417.614","5.010","-0.527","160.766831","69.076214","K3III","K","1","","" }
{ "46747","46880","82734","3808","Gl 355.2","","","","","","Hya","","362.396","5.020","-0.209","143.301919","-21.115722","K0III","K","1","","" }
{ "51486","51635","91504","4143","","","","","","","Vel","","1309.865","5.020","-2.999","158.236944","-47.003353","K4III","K","1","","" }
{ "53271","53426","94600","4258","","46    UMa","","46","","","UMa","","236.860","5.020","0.715","163.934989","33.506929","K1III","K","1","","" }
{ "67885","68103","121710","5247","","9    Boo","","9","","","Boo","","581.384","5.020","-1.235","209.142412","27.492082","K3IIIvar","K","1","","" }
{ "72573","72800","131120","5543","","","","","","","Cen","","491.940","5.020","-0.872","223.212820","-37.803160","B7II/III","B","1","","" }
{ "74564","74793","136726","5714","","11    UMi","","11","","","UMi","","398.237","5.020","-0.414","229.274515","71.823901","K4III","K","1","","" }
{ "86942","87212","162579","6656","","30    Dra","","30","","","Dra","","217.004","5.020","0.905","267.267931","50.781075","A2V","A","1","","" }
{ "86964","87234","163989","6701","","35    Dra","","35","","","Dra","","103.575","5.020","2.511","267.362327","76.962881","F6IV-Vs","F","1","","" }
{ "89703","89981","169305","6891","","","","","","","Dra","","648.422","5.020","-1.472","275.386127","49.121593","M2III","M","1","","" }
{ "91688","91975","173370","7040","","4    Aql","","4","","","Aql","","465.273","5.020","-0.751","281.208075","2.060038","B9V","B","1","","" }
{ "92764","93057","175687","7145","","36Xi 1Sgr","Xi-1","36","Xi","1","Sgr","","2064.281","5.020","-3.987","284.335319","-20.656346","B9.5Ib","B","1","","" }
{ "95182","95477","182369","7362","","47Chi1Sgr","Chi-1","47","Chi","1","Sgr","","251.858","5.020","0.581","291.318698","-24.508575","A4IV/V","A","1","","" }
{ "107265","107608","207155","8326","","10The PsA","The","10","The","","PsA","","321.020","5.020","0.054","326.933971","-30.898304","A1V","A","1","","" }
{ "20849","20901","28355","1414","","79    Tau","","79","","","Tau","","159.334","5.020","1.576","67.209010","13.047602","A7V","A","1","","" }
{ "25229","25292","35186","1773","","21Sig Aur","Sig","21","Sig","","Aur","","467.273","5.020","-0.761","81.163091","37.385346","K4III","K","1","","" }
{ "9814","9836","12869","613","","12Kap Ari","Kap","12","Kap","","Ari","","181.602","5.030","1.302","31.641352","22.648317","A2m","A","1","","" }
{ "22426","22479","30814","1549","","60    Eri","","60","","","Eri","","235.833","5.030","0.734","72.548397","-16.217159","K0III","K","1","","" }
{ "61225","61418","109511","4792","","24    Com","","24","","","Com","","450.492","5.030","-0.671","188.782332","18.377058","K2III","K","1","","" }
{ "66591","66803","119149","5150","","82    Vir","","82","","","Vir","","509.619","5.030","-0.939","205.403238","-8.702984","M2III","M","1","","" }
{ "69396","69618","124367","5316","","","","","","","Cen","","481.767","5.030","-0.817","213.738124","-57.086126","B4Vne","B","1","","" }
{ "82253","82504","152326","6270","","51    Her","","51","","","Her","","698.408","5.030","-1.623","252.938589","24.656433","K2II-III","K","1","","" }
{ "28604","28675","41312","2140","","","","","","","Lep","","406.679","5.030","-0.449","90.814999","-26.284544","K3II/IIICNv","K","1","","" }
{ "35131","35226","56779","2770","","","","","","","Pup","","753.248","5.030","-1.788","109.205873","-36.592633","B3V","B","1","","" }
{ "37783","37891","62952","3015","","4    Pup","","4","","","Pup","","235.153","5.030","0.740","116.486959","-14.563805","F2V","F","1","","" }
{ "41521","41639","72127","3359","","","","","","","Vel","","2609.251","5.030","-4.485","127.364519","-44.724812","B+...","B","1","","" }
{ "53565","53721","95128","4277","Gl 407","47    UMa","","47","","","UMa","Chalawan","45.866","5.030","4.290","164.866798","40.430257","G0V","G","1","","" }
{ "83081","83336","153613","6316","","","","","","","Sco","","447.402","5.030","-0.656","255.469348","-32.143519","B8V","B","1","","" }
{ "84413","84671","156681","6433","","","","","","","Oph","","492.683","5.030","-0.866","259.654126","10.864475","K4II-III","K","1","","" }
{ "91471","91755","173524","7049","","46    Dra","","46","","","Dra","","340.455","5.030","-0.063","280.658144","55.539457","B9.5p...","B","1","","" }
{ "94966","95261","181296","7329","","Eta Tel","Eta","","Eta","","Tel","","157.260","5.030","1.614","290.713314","-54.423931","A0Vn","A","1","","" }
{ "95638","95937","183630","7414","","36    Aql","","36","","","Aql","","528.617","5.030","-1.019","292.665989","-2.788887","M1IIIvar","M","1","","" }
{ "97324","97635","188056","7576","","20    Cyg","","20","","","Cyg","","202.456","5.030","1.065","297.657198","52.988001","K3IIIvar","K","1","","" }
{ "102868","103200","199169","8008","","32    Vul","","32","","","Vul","","582.422","5.030","-1.229","313.640155","28.057621","K4III","K","1","","" }
{ "104848","105186","203064","8154","","68    Cyg","","68","","","Cyg","","326156.378","5.040","-14.960","319.613267","43.945945","O8","O","1","","" }
{ "106369","106711","205835","8266","","74    Cyg","","74","","","Cyg","","214.718","5.040","0.948","324.237400","40.413521","A5V","A","1","","" }
{ "108190","108535","209369","8400","","16    Cep","","16","","","Cep","","119.778","5.040","2.215","329.812766","73.179896","F5V","F","1","","" }
{ "58730","58905","104902","4605","","Kap Cha","Kap","","Kap","","Cha","","476.837","5.040","-0.785","181.194243","-76.519061","K4III","K","1","","" }
{ "64203","64407","114642","4981","","53    Vir","","53","","","Vir","","110.599","5.040","2.388","198.014753","-16.198601","F6V","F","1","","" }
{ "65263","65468","116244","5042","","Iot1Mus","Iot-1","","Iot","1","Mus","","221.123","5.040","0.884","201.280405","-74.887818","K0III","K","1","","" }
{ "65604","65810","117150","5071","","","","","","","Cen","","507.242","5.040","-0.919","202.355227","-51.165134","A0V","A","1","","" }
{ "74549","74778","135240","5664","","Del Cir","Del","","Del","","Cir","","326156.378","5.040","-14.960","229.237071","-60.957255","O8.5V","O","1","","" }
{ "74746","74975","136202","5694","","5    Ser","","5","","","Ser","","82.781","5.040","3.017","229.828323","1.765408","F8III-IV","F","1","","" }
{ "75742","75973","138481","5763","","52Nu 1Boo","Nu-1","52","Nu","1","Boo","","838.448","5.040","-2.010","232.732322","40.833047","K5III","K","1","","" }
{ "77575","77811","142096","5902","","45Lam Lib","Lam","45","Lam","","Lib","","309.446","5.040","0.154","238.333578","-20.167040","B3V","B","1","","" }
{ "111359","111710","214376","8610","","63Kap Aqr","Kap","63","Kap","","Aqr","Situla","213.873","5.040","0.956","339.439088","-4.228056","K2III","K","1","","" }
{ "183","183","224990","9091","","Zet Scl","Zet","","Zet","","Scl","","502.552","5.040","-0.899","0.582999","-29.720414","B4V","B","1","","" }
{ "5306","5317","6658","324","","41    And","","41","","","And","","192.309","5.040","1.187","17.003385","43.942092","A3m","A","1","","" }
{ "8226","8241","10939","520","","","","","","","Eri","","202.330","5.040","1.077","26.525886","-53.522037","A1V","A","1","","" }
{ "15181","15219","20123","969","","","","","","","Per","","789.725","5.040","-1.880","49.050849","50.937664","G5II","G","1","","" }
{ "21808","21861","29992","1503","Gl 176.1","Bet Cae","Bet","","Bet","","Cae","","93.508","5.040","2.753","70.514473","-37.144297","F3V","F","1","","" }
{ "28253","28325","40536","2108","","2    Mon","","2","","","Mon","","286.353","5.040","0.323","89.767969","-9.558250","A6m","A","1","","" }
{ "28919","28991","42540","2196","","","","","","","Pic","","361.592","5.040","-0.184","91.764064","-62.154581","K2/K3III","K","1","","" }
{ "29727","29800","43386","2241","GJ 9207","74    Ori","","74","","","Ori","","62.783","5.040","3.618","94.110910","12.272163","F5IV-V","F","1","","" }
{ "32088","32173","47914","2459","","55Psi4Aur","Psi-4","55","Psi","4","Aur","","323.568","5.040","0.057","100.770758","44.524450","K5III","K","1","","" }
{ "35749","35846","57727","2808","","57    Gem","","57","","","Gem","","158.945","5.040","1.601","110.868813","25.050531","G8III","G","1","","" }
{ "37194","37300","61338","2938","","74    Gem","","74","","","Gem","","525.212","5.040","-0.995","114.869135","17.674519","M0III","M","1","","" }
{ "37498","37606","62644","2998","Gl 284","","","","","","Pup","","80.473","5.040","3.079","115.737982","-45.173118","G5IV","G","1","","" }
{ "39578","39690","67582","3187","","","","","","","Vel","","1393.831","5.040","-3.114","121.668086","-45.266015","K3III","K","1","","" }
{ "31685","31765","47973","2462","","","","","","","Pup","","476.837","5.050","-0.775","99.656811","-48.220183","G8III","G","1","","" }
{ "37285","37391","51802","2609","","","","","","","Cep","","455.526","5.050","-0.675","115.129418","87.020091","M2III","M","1","","" }
{ "42311","42430","73752","3430","Gl 314A","","","","","","Pyx","","63.270","5.050","3.611","129.782972","-22.661875","G3/G5V","G","1","","Gl 314" }
{ "113986","114347","218634","8815","","57    Peg","","57","","","Peg","","782.150","5.050","-1.849","347.381070","8.677161","M4Sv","M","1","","" }
{ "114864","115227","220009","8878","","7    Psc","","7","","","Psc","","432.568","5.050","-0.563","350.085761","5.381307","K2III","K","1","","" }
{ "117004","117371","223274","9013","","","","","","","Cep","","303.119","5.050","0.209","356.978150","67.806808","A1Vn","A","1","","" }
{ "88469","88745","165908","6775","Gl 704A","99    Her","","99","","","Her","","51.018","5.050","4.079","271.756452","30.562140","F7V","F","1","","Gl 704" }
{ "109210","109556","210839","8469","","22Lam Cep","Lam","22","Lam","","Cep","","1976.705","5.050","-3.863","332.877417","59.414488","O6e","O","1","","" }
{ "15405","15444","20418","989","","31    Per","","31","","","Per","","560.406","5.050","-1.125","49.781798","50.094966","B5V","B","1","","" }
{ "17809","17851","23862","1180","","28    Tau","","28","","","Tau","Pleione","381.916","5.050","-0.293","57.296729","24.136712","B7p","B","1","","" }
{ "23594","23649","33042","1663","","Eta2Pic","Eta-2","","Eta","2","Pic","","443.750","5.050","-0.619","76.241636","-49.577837","M2IIIvar","M","1","","" }
{ "24819","24879","34578","1740","","19    Aur","","19","","","Aur","","2077.429","5.050","-3.971","80.003837","33.958054","A5IIvar","A","1","","" }
{ "17254","17296","22649","1105","","","","","","","Cam","","519.357","5.060","-0.950","55.538904","63.216806","S5.3 SB:","S","1","","" }
{ "24446","24505","34310","1723","","","","","","","Lep","","278.053","5.060","0.406","78.851549","-26.943509","B9V","B","1","","" }
{ "24984","25045","35162","1771","","","","","","","Lep","","351.841","5.060","-0.105","80.442732","-24.772981","A2/A3","A","1","","" }
{ "117350","117718","223768","9036","","81Phi Peg","Phi","81","Phi","","Peg","","462.633","5.060","-0.699","358.122034","19.120287","M2III","M","1","","" }
{ "29061","29134","43107","2221","","Nu  Dor","Nu","","Nu","","Dor","","299.776","5.060","0.243","92.184643","-68.843409","B8V","B","1","","" }
{ "29344","29417","42690","2205","","","","","","","Mon","","1194.712","5.060","-2.759","92.965892","-6.550287","B2V","B","1","","" }
{ "30699","30772","45546","2344","","10    Mon","","10","","","Mon","","1087.188","5.060","-2.554","96.989873","-4.762154","B2V","B","1","","" }
{ "36711","36817","60584","2909","","","","","","","Pup","","103.345","5.060","2.556","113.577592","-23.473661","F6V","F","1","","" }
{ "40565","40680","70514","3280","","","","","","","Vol","","297.046","5.060","0.263","124.578290","-65.613192","K1III","K","1","","" }
{ "49344","49485","87783","3976","","","","","","","Vel","","240.351","5.060","0.723","151.546728","-47.369995","K0IV","K","1","","" }
{ "53682","53838","95310","4288","","49    UMa","","49","","","UMa","","376.624","5.060","-0.252","165.210137","39.212092","Am","A","1","","" }
{ "70025","70248","124771","5336","","Eps Aps","Eps","","Eps","","Aps","","644.578","5.060","-1.419","215.596627","-80.108945","B4V","B","1","","" }
{ "83776","84033","154948","6371","","","","","","","Sco","","315.737","5.060","0.131","257.676379","-44.557719","G8/K0III+..","G","1","","" }
{ "96519","96825","186155","7495","","","","","","","Cyg","","161.864","5.060","1.581","295.209010","45.524942","F5II","F","1","","" }
{ "96643","96950","186005","7489","","55    Sgr","","55","","","Sgr","","177.163","5.060","1.385","295.629717","-16.123996","F3IV/V","F","1","","" }
{ "98260","98571","190147","7660","","26    Cyg","","26","","","Cyg","","434.296","5.060","-0.562","300.339825","50.104695","K1II-III","K","1","","" }
{ "101540","101868","196740","7894","","28    Vul","","28","","","Vul","","522.686","5.060","-0.964","309.632975","24.115958","B5IV","B","1","","" }
{ "102513","102843","198639","7984","","56    Cyg","","56","","","Cyg","","133.616","5.060","1.998","312.520429","44.059304","A4me...","A","1","","" }
{ "102619","102950","198308","7968","","Iot Ind","Iot","","Iot","","Ind","","466.604","5.060","-0.718","312.875207","-51.608179","K1II/III","K","1","","" }
{ "104417","104755","201371","8092","","Omi Pav","Omi","","Omi","","Pav","","893.579","5.060","-2.129","318.335260","-70.126267","M2III","M","1","","" }
{ "83690","83947","155410","6388","","","","","","","Her","","282.142","5.070","0.385","257.388566","40.777033","K3III","K","1","","" }
{ "85544","85805","159966","6566","","27    Dra","","27","","","Dra","","210.968","5.070","1.016","262.991175","68.135024","K0III","K","1","","" }
{ "90571","90853","170523","6938","","Del2Tel","Del-2","","Del","2","Tel","","1194.712","5.070","-2.749","278.008104","-45.757382","B3III","B","1","","" }
{ "93572","93867","178125","7248","","18    Aql","","18","","","Aql","","698.408","5.070","-1.583","286.744179","11.071228","B8III","B","1","","" }
{ "101587","101916","196755","7896","","7Kap Del","Kap","7","Kap","","Del","","98.240","5.070","2.676","309.782421","10.086203","G5IV+...","G","1","","" }
{ "107420","107763","207650","8343","","14    Peg","","14","","","Peg","","274.774","5.070","0.442","327.461220","30.174215","A1Vs","A","1","","" }
{ "108671","109017","209975","8428","","19    Cep","","19","","","Cep","","2064.281","5.070","-3.937","331.286626","62.279814","O9.5Ib","O","1","","" }
{ "33471","33558","52092","2619","","","","","","","Pup","","589.794","5.070","-1.216","104.604567","-34.111708","B4IV/V","B","1","","" }
{ "34815","34909","55383","2717","","51    Gem","","51","","","Gem","","540.890","5.070","-1.028","108.342815","16.158966","K3V","K","1","","" }
{ "36290","36393","59037","2857","","64    Gem","","64","","","Gem","","176.206","5.070","1.407","112.335183","28.118275","A4V","A","1","","" }
{ "37902","38010","63465","3035","","","","","","","Pup","","1055.522","5.070","-2.480","116.854141","-38.511145","B2IV/V","B","1","","" }
{ "46641","46774","82381","3779","","6    Leo","","6","","","Leo","","499.474","5.070","-0.855","142.989906","9.715767","K3III","K","1","","" }
{ "46795","46928","83979","3860","","Zet Cha","Zet","","Zet","","Cha","","572.204","5.070","-1.151","143.472854","-80.941258","B5V","B","1","","" }
{ "47318","47452","83754","3849","","38Kap Hya","Kap","38","Kap","","Hya","","436.038","5.070","-0.560","145.076516","-14.332292","B4IV/V","B","1","","" }
{ "48300","48437","85558","3909","","8Gam Sex","Gam","8","Gam","","Sex","","277.580","5.070","0.420","148.126811","-8.105030","A2V","A","1","","" }
{ "51626","51775","91612","4146","","48    Leo","","48","","","Leo","","266.033","5.070","0.512","158.700063","6.953749","G8II-III","G","1","","" }
{ "2572","2578","3003","136","GJ 9015A","Bet3Tuc","Bet-3","","Bet","3","Tuc","","148.591","5.070","1.777","8.182685","-63.031500","A0V","A","1","","GJ 9015" }
{ "3802","3810","4676","225","Gl 34.1","64    Psc","","64","","","Psc","","76.491","5.070","3.219","12.244618","16.940644","F8V...","F","1","","" }
{ "14917","14954","19994","962","Gl 128A","94    Cet","","94","","","Cet","","73.641","5.070","3.302","48.193485","-1.196101","F8V","F","1","","Gl 128" }
{ "21008","21060","28873","1443","","Del Cae","Del","","Del","","Cae","","704.441","5.070","-1.602","67.708746","-44.953749","B2IV-V","B","1","","" }
{ "21674","21727","29317","1467","","3    Cam","","3","","","Cam","","422.482","5.070","-0.492","69.977845","53.079535","K0III SB","K","1","","" }
{ "25219","25282","35410","1787","","27    Ori","","27","","","Ori","","186.588","5.070","1.283","81.120450","-0.891328","K0III","K","1","","" }
{ "119135","","155886","6402","Gl 663B","36    Oph","","36","","","Oph","Guniibuu B","19.521","5.070","6.185","258.836007","-26.603215","K1 Ve","K","2","84147","Gl 663" }
{ "56076","56243","100261","4441","","Omi1Cen","Omi-1","","Omi","1","Cen","","326156.378","5.070","-14.930","172.941961","-59.442061","G0Ia","G","1","","" }
{ "69193","69415","124206","5312","Gl 540.1","50    Hya","","50","","","Hya","","217.583","5.070","0.949","213.191772","-27.261186","K2III","K","1","","" }
{ "81046","81292","150117","6185","","17    Dra","","17","","","Dra","","412.334","5.070","-0.439","249.057186","52.924422","B9V","B","1","","" }
{ "55433","55598","98991","4395","","13Lam Crt","Lam","13","Lam","","Crt","","139.861","5.080","1.919","170.841225","-18.779973","F3IV","F","1","","" }
{ "62805","63005","112091","4899","","Mu 2Cru","Mu-2","","Mu","2","Cru","","407.186","5.080","-0.402","193.653760","-57.168670","B5Vne","B","1","","" }
{ "72901","73129","131492","5551","","The Cir","The","","The","","Cir","","1509.983","5.080","-3.248","224.183313","-62.781016","B4Vnp","B","1","","" }
{ "2848","2854","3240","144","","","","","","","Cas","","536.441","5.080","-1.000","9.034587","54.168450","B7III","B","1","","" }
{ "17729","17771","23793","1174","","30    Tau","","30","","","Tau","","453.625","5.080","-0.636","57.067785","11.143294","B3V","B","1","","" }
{ "21620","21673","29479","1478","","91Sig1Tau","Sig-1","91","Sig","1","Tau","","147.050","5.080","1.810","69.788401","15.799846","A4m","A","1","","" }
{ "22512","22565","30780","1547","","97    Tau","","97","","","Tau","","167.174","5.080","1.531","72.843582","18.839861","A7IV-V","A","1","","" }
{ "25047","25110","33564","1686","Gl 196","","","","","","Cam","","68.119","5.080","3.481","80.640547","79.231149","F6V","F","1","","" }
{ "25477","25541","35620","1805","","24Phi Aur","Phi","24","Phi","","Aur","","452.995","5.080","-0.633","81.912027","34.475892","K4IIIp","K","1","","" }
{ "92524","92814","175156","7119","","","","","","","Sct","","1399.813","5.080","-3.083","283.679641","-15.603036","B3II","B","1","","" }
{ "98764","99080","190993","7688","","17    Vul","","17","","","Vul","","504.106","5.080","-0.865","301.722528","23.614425","B3V","B","1","","" }
{ "100555","100881","194636","7814","","10Pi  Cap","Pi","10","Pi","","Cap","","545.412","5.080","-1.036","306.830039","-18.211721","B4V","B","1","","" }
{ "107693","108036","207958","8351","Gl 838.5","51Mu  Cap","Mu","51","Mu","","Cap","","86.813","5.080","2.954","328.324026","-13.551768","F3IV","F","1","","" }
{ "29198","29271","43834","2261","Gl 231","Alp Men","Alp","","Alp","","Men","Hoerikwaggo","33.261","5.080","5.037","92.559476","-74.753045","G5V","G","1","","" }
{ "32472","32558","49331","2508","","","","","","","Mon","","1411.932","5.080","-3.102","101.905088","-8.998503","M1II","M","1","","" }
{ "38758","38872","65551","3116","","","","","","","Pup","","1094.485","5.080","-2.549","119.326766","-44.109859","B2.5IV","B","1","","" }
{ "41365","41483","71935","3350","","","","","","","Vel","","199.119","5.080","1.152","126.902547","-53.088480","A9/F0III/IV","A","1","","" }
{ "47977","48113","84737","3881","Gl 368","","","","","","UMa","","59.911","5.080","3.760","147.147143","46.021008","G2V","G","1","","" }
{ "51290","51437","90994","4119","","30Bet Sex","Bet","30","Bet","","Sex","","404.661","5.080","-0.388","157.572832","-0.637026","B6V","B","1","","" }
{ "51569","51718","91550","4145","","44    Hya","","44","","","Hya","","797.448","5.080","-1.861","158.503687","-23.745165","K5III","K","1","","" }
{ "51763","51912","92063","4164","","","","","","","Car","","262.606","5.080","0.551","159.085587","-59.564392","K1III","K","1","","" }
{ "52306","52457","92825","4192","","41    LMi","","41","","","LMi","","229.203","5.080","0.846","160.854007","23.188404","A3Vn","A","1","","" }
{ "111182","111532","214470","8615","","31    Cep","","31","","","Cep","","179.010","5.080","1.383","338.941157","73.643188","F3III-IV","F","1","","" }
{ "109912","110256","210967","8481","","Eps Oct","Eps","","Eps","","Oct","","290.692","5.090","0.340","335.006304","-80.439747","M6III","M","1","","" }
{ "113428","113788","217782","8766","Gl 886.1A","2    And","","2","","","And","","421.391","5.090","-0.466","345.651539","42.757795","A3Vn","A","1","","Gl 886.1" }
{ "115079","115444","220363","8893","","66    Peg","","66","","","Peg","","388.281","5.090","-0.289","350.769034","12.313910","K3III","K","1","","" }
{ "116653","117020","222764","8991","","77    Peg","","77","","","Peg","","618.892","5.090","-1.301","355.843164","10.331536","M2III","M","1","","" }
{ "86924","87194","162211","6644","","87    Her","","87","","","Her","","211.928","5.090","1.026","267.204779","25.622869","K2III","K","1","","" }
{ "89759","90037","168592","6862","","","","","","","CrA","","484.631","5.090","-0.770","275.577414","-38.656894","K4/K5III","K","1","","" }
{ "98604","98920","190608","7679","","16Eta Sge","Eta","16","Eta","","Sge","","160.352","5.090","1.632","301.289552","19.991071","K2III","K","1","","" }
{ "106656","106999","206330","8284","","75    Cyg","","75","","","Cyg","","403.659","5.090","-0.373","325.046234","43.273839","M1IIIvar","M","1","","" }
{ "107679","108022","208057","8356","","16    Peg","","16","","","Peg","","632.086","5.090","-1.347","328.265699","25.925140","B3V","B","1","","" }
{ "108756","109102","209945","8424","","","","","","","Lac","","608.501","5.090","-1.264","331.508143","45.014348","K5III","K","1","","" }
{ "55432","55597","99103","4401","","","","","","","Mus","","403.659","5.090","-0.373","170.839242","-64.954714","B5","B","1","","" }
{ "59637","59819","106661","4663","","6    Com","","6","","","Com","","198.633","5.090","1.167","184.000783","14.899071","A3V","A","1","","" }
{ "77424","77660","141851","5895","","36    Ser","","36","","","Ser","","162.267","5.090","1.606","237.814972","-3.090497","A3Vn","A","1","","" }
{ "79062","79302","145250","6017","","","","","","","Sco","","317.891","5.090","0.146","242.758654","-29.416220","K0III","K","1","","" }
{ "3773","3781","4815","236","","Lam Hyi","Lam","","Lam","","Hyi","","211.790","5.090","1.028","12.146651","-74.923438","K5III","K","1","","" }
{ "9091","9110","11909","563","","8Iot Ari","Iot","8","Iot","","Ari","","520.186","5.090","-0.924","29.337722","17.817532","K1p...","K","1","","" }
{ "16251","16292","21447","1046","","","","","","","Cam","","198.633","5.090","1.167","52.500849","55.451808","A1V","A","1","","" }
{ "23211","23265","30338","1523","","","","","","","Cep","","384.165","5.090","-0.265","75.086323","81.194088","K3III","K","1","","" }
{ "31201","31278","46487","2395","","","","","","","Mon","","553.746","5.090","-1.059","98.408008","-1.220154","B5Vn","B","1","","" }
{ "35601","35699","57423","2795","","56    Gem","","56","","","Gem","","443.147","5.090","-0.576","110.486930","20.443658","M0III","M","1","","" }
{ "36013","36114","59219","2862","","","","","","","Car","","605.114","5.090","-1.252","111.591052","-51.018481","K0III","K","1","","" }
{ "38913","39023","65699","3123","","12    Pup","","12","","","Pup","","860.571","5.090","-2.017","119.773815","-23.310396","G8II","G","1","","" }
{ "40206","40321","69081","3240","","","","","","","Pup","","1016.064","5.090","-2.377","123.492971","-36.322281","B2V:","B","1","","" }
{ "43290","43413","75821","3527","","","","","","","Vel","","326156.378","5.090","-14.910","132.639426","-46.529187","B0III","B","1","","" }
{ "46150","46283","81848","3753","","","","","","","Vel","","429.153","5.090","-0.506","141.574858","-53.378909","B6V","B","1","","" }
{ "47829","47965","84335","3870","","","","","","","UMa","","552.807","5.090","-1.056","146.631934","57.128070","M3III","M","1","","" }
{ "48088","48224","85355","3898","","","","","","","Vel","","842.781","5.090","-1.971","147.488112","-45.732736","B7III","B","1","","" }
{ "57440","57613","102620","4532","","","","","","","Hya","","545.412","5.100","-1.016","177.187854","-26.749777","M4III","M","1","","" }
{ "64598","64803","115310","5006","","","","","","","Cen","","257.627","5.100","0.612","199.221380","-31.506196","K0III","K","1","","" }
{ "70177","70400","126248","5392","","","","","","","Vir","","159.023","5.100","1.660","216.047270","5.820131","A5V","A","1","","" }
{ "78244","78481","143666","5966","","5    Her","","5","","","Her","","250.890","5.100","0.670","240.309662","17.818397","G8III","G","1","","" }
{ "81878","82129","150549","6204","","","","","","","TrA","","696.915","5.100","-1.549","251.666688","-67.109691","Ap","A","1","","" }
{ "113201","113561","217476","8752","","","","","","","Cas","","326156.378","5.100","-14.900","345.021259","56.945374","G0Ia","G","1","","" }
{ "117321","117689","223647","9032","","Gam1Oct","Gam-1","","Gam","1","Oct","","265.168","5.100","0.550","358.027771","-82.018818","G7III","G","1","","" }
{ "84903","85162","157243","6460","","","","","","","Sco","","737.910","5.100","-1.673","261.054535","-44.162576","B7III","B","1","","" }
{ "88621","88899","166230","6794","","101    Her","","101","","","Her","","328.787","5.100","0.083","272.220263","20.045233","A8III","A","1","","" }
{ "94590","94885","180972","7319","","23    Aql","","23","","","Aql","","371.054","5.100","-0.180","289.635397","1.085129","K2II-IIIvar","K","1","","" }
{ "106601","106944","206067","8277","","25    Aqr","","25","","","Aqr","","226.497","5.100","0.892","324.888607","2.243558","K0III","K","1","","" }
{ "107039","107382","206834","8311","","46    Cap","","46","","","Cap","","791.642","5.100","-1.826","326.251060","-9.082428","G8II-III","G","1","","" }
{ "13741","13775","18296","873","","21    Per","","21","","","Per","","319.761","5.100","0.143","44.322009","31.934219","B9p...","B","1","","" }
{ "15698","15737","20893","1015","","63Tau2Ari","Tau-2","63","Tau","2","Ari","","317.582","5.100","0.158","50.688514","20.742069","K3III","K","1","","" }
{ "19412","19461","25007","1230","","","","","","","Cep","","379.693","5.100","-0.230","62.511579","80.698681","G8III+...","G","1","","" }
{ "20470","20522","27820","1381","","66    Tau","","66","","","Tau","","395.821","5.100","-0.320","65.965939","9.460968","A3V","A","1","","" }
{ "27465","27534","39844","2064","","Eps Dor","Eps","","Eps","","Dor","","574.219","5.100","-1.128","87.473086","-66.901187","B6V","B","1","","" }
{ "6946","6960","9132","433","","48    Cet","","48","","","Cet","","232.803","5.110","0.842","22.400553","-21.629339","A0V","A","1","","" }
{ "18168","18213","24626","1214","","","","","","","Eri","","346.238","5.110","-0.020","58.412262","-34.732297","B6/B7V","B","1","","" }
{ "23886","23941","33256","1673","Gl 189.2","68    Eri","","68","","","Eri","","83.034","5.110","3.081","77.182080","-4.456207","F2V","F","1","","" }
{ "109627","109973","211202","8488","","Mu 2Gru","Mu-2","","Mu","2","Gru","","265.384","5.110","0.558","334.110669","-41.627225","G8III","G","1","","" }
{ "111443","111795","214665","8621","","","","","","","Lac","","451.115","5.110","-0.594","339.657907","56.795632","M4III","M","1","","" }
{ "111888","112242","215373","8656","","13    Lac","","13","","","Lac","","256.614","5.110","0.631","341.022836","41.819235","K0III","K","1","","" }
{ "33017","33104","49340","2511","","43    Cam","","43","","","Cam","","979.449","5.110","-2.278","103.426015","68.888309","B7III","B","1","","" }
{ "35309","35406","57219","2790","","","","","","","Pup","","756.743","5.110","-1.718","109.659111","-36.742735","A0V","A","1","","" }
{ "48693","48833","86146","3928","GJ 3574","19    LMi","","19","","","LMi","","91.797","5.110","2.863","149.421151","41.055633","F6Vs","F","1","","" }
{ "54302","54461","96919","4338","","","","","","","Car","","326156.378","5.110","-14.890","167.141676","-61.947175","B9Ia","B","1","","" }
{ "65330","65535","116713","5058","","","","","","","Cen","","203.339","5.110","1.136","201.532238","-39.755107","Kp...","K","1","","" }
{ "77746","77982","141767","5891","","Kap TrA","Kap","","Kap","","TrA","","1207.987","5.110","-2.733","238.873367","-68.603001","G6VII","G","1","","" }
{ "89912","90191","169702","6903","","2Mu  Lyr","Mu","2","Mu","","Lyr","","438.972","5.110","-0.535","276.057455","39.507239","A3IVn","A","1","","" }
{ "91589","91875","172777","7021","","Lam CrA","Lam","","Lam","","CrA","","205.259","5.110","1.116","280.945590","-38.323441","A0/A1V","A","1","","" }
{ "93788","94083","180777","7312","Gl 748.1","59    Dra","","59","","","Dra","","89.041","5.110","2.929","287.290744","76.560502","A9V","A","1","","" }
{ "101654","101983","196378","7875","Gl 794.2","Phi2Pav","Phi-2","","Phi","2","Pav","","80.433","5.110","3.150","310.010204","-60.548892","F8V","F","1","","" }
{ "102362","102693","197937","7943","Gl 808.1","Iot Mic","Iot","","Iot","","Mic","","115.535","5.110","2.364","312.121258","-43.988544","F1IV","F","1","","" }
{ "107972","108317","208816","8383","","","","","","","Cep","","2452.304","5.110","-4.271","329.163099","63.625557","M2 comp","M","1","","" }
{ "86529","86796","160691","6585","Gl 691","Mu  Ara","Mu","","Mu","","Ara","Cervantes","50.590","5.120","4.167","266.036284","-51.834053","G5V","G","1","","" }
{ "89657","89935","168914","6877","","107    Her","","107","","","Her","","263.029","5.120","0.587","275.254249","28.869954","A7V","A","1","","" }
{ "90524","90806","170680","6944","","","","","","","Sgr","","223.089","5.120","0.945","277.859569","-18.402697","B9/B9.5V","B","1","","" }
{ "90823","91105","171391","6970","","","","","","","Sct","","329.119","5.120","0.100","278.759967","-10.977206","G8III","G","1","","" }
{ "95652","95951","183914","7418","","6Bet2Cyg","Bet-2","6","Bet","2","Cyg","Albireo B","399.701","5.120","-0.322","292.689148","27.965276","B8V","B","1","","" }
{ "96026","96327","184492","7430","","37    Aql","","37","","","Aql","","457.442","5.120","-0.615","293.780238","-10.560444","G8III","G","1","","" }
{ "97365","97675","187691","7560","Gl 768.1A","54Omi Aql","Omi","54","Omi","","Aql","","62.590","5.120","3.705","297.756834","10.415727","F8V","F","1","","Gl 768.1" }
{ "101151","101477","195569","7846","","Nu  Mic","Nu","","Nu","","Mic","","233.972","5.120","0.841","308.479456","-44.516048","K0III","K","1","","" }
{ "34578","34670","55526","2719","GJ 3434","","","","","","Pup","","316.043","5.120","0.188","107.697869","-48.932098","K2III","K","1","","" }
{ "35611","35710","57264","2793","","65    Aur","","65","","","Aur","","236.003","5.120","0.823","110.510962","36.760584","K0III","K","1","","" }
{ "37557","37664","62713","3002","","","","","","","Pup","","217.004","5.120","1.005","115.924601","-40.933746","K1III","K","1","","" }
{ "38264","38373","63975","3059","","13Zet CMi","Zet","13","Zet","","CMi","","623.626","5.120","-1.287","117.924952","1.766868","B8II","B","1","","" }
{ "45374","45505","80108","3692","","","","","","","Vel","","326156.378","5.120","-14.880","139.095983","-44.265735","K3Ib","K","1","","" }
{ "46780","46914","82984","3817","","","","","","","Vel","","829.914","5.120","-1.908","143.435609","-49.005072","B4IV","B","1","","" }
{ "52202","52353","92424","4178","","38    UMa","","38","","","UMa","","226.812","5.120","0.909","160.486198","65.716280","K2IIIvar","K","1","","" }
{ "53107","53261","94247","4246","","44    UMa","","44","","","UMa","","653.620","5.120","-1.389","163.393666","54.585128","K3III","K","1","","" }
{ "8863","8882","11753","558","","Phi Phe","Phi","","Phi","","Phe","","306.826","5.120","0.253","28.591834","-42.496950","A3V","A","1","","" }
{ "14206","14240","19319","934","","Mu  Hor","Mu","","Mu","","Hor","","141.561","5.120","1.932","45.903588","-59.737775","F0IV","F","1","","" }
{ "23739","23794","32964","1657","","66    Eri","","66","","","Eri","","308.860","5.120","0.238","76.690219","-4.655163","B9.5V","B","1","","" }
{ "110045","110391","212010","8516","","47    Aqr","","47","","","Aqr","","171.031","5.120","1.522","335.398203","-21.598230","K0III","K","1","","" }
{ "113500","113860","217792","8767","Gl 886.2","Pi  PsA","Pi","","Pi","","PsA","","95.957","5.120","2.777","345.874194","-34.749412","A9V","A","1","","" }
{ "56083","56250","100262","4442","","Omi2Cen","Omi-2","","Omi","2","Cen","","326156.378","5.120","-14.880","172.953348","-59.515648","A3Ia","A","1","","" }
{ "61275","61468","109536","4794","","","","","","","Cen","","115.864","5.120","2.367","188.939800","-41.021945","A7III","A","1","","" }
{ "62161","62356","111067","4851","","27    Com","","27","","","Com","","339.746","5.120","0.031","191.661502","16.577691","K3III","K","1","","" }
{ "56163","56332","100393","4449","","","","","","","Hya","","388.744","5.130","-0.251","173.225555","-31.087226","M1/M2III","M","1","","" }
{ "68818","69038","123657","5299","","","","","","","Boo","","512.824","5.130","-0.853","211.982305","43.854452","M4.2III","M","1","","" }
{ "73598","73826","133340","5607","","","","","","","Lup","","352.983","5.130","-0.042","226.329840","-41.067236","G8III","G","1","","" }
{ "76027","76259","138688","5775","","36    Lib","","36","","","Lib","","318.201","5.130","0.184","233.655496","-28.046983","K2/K3III","K","1","","" }
{ "79412","79653","145842","6045","","The Nor","The","","The","","Nor","","385.528","5.130","-0.233","243.813858","-47.372021","B8V","B","1","","" }
{ "145","145","224926","9087","","29    Psc","","29","","","Psc","","454.257","5.130","-0.589","0.456035","-3.027504","B7III-IV","B","1","","" }
{ "1156","1158","1014","46","","","","","","","Cet","","582.422","5.130","-1.129","3.615116","-7.780532","M3IIIvar","M","1","","" }
{ "6048","6061","7804","378","","89    Psc","","89","","","Psc","","245.600","5.130","0.746","19.449816","3.614466","A3V","A","1","","" }
{ "11449","11477","15427","724","","Phi For","Phi","","Phi","","For","","151.983","5.130","1.788","37.007087","-33.811039","A2/A3V","A","1","","" }
{ "15851","15890","20797","1009","","","","","","","Cam","","2051.298","5.130","-3.863","51.168998","64.585996","M0II","M","1","","" }
{ "26156","26221","37022","1895","","41The1Ori","The-1","41","The","1","Ori","","326156.378","5.130","-14.870","83.818606","-5.389696","O6pe","O","1","","" }
{ "84629","84887","157198","6457","","70    Her","","70","","","Her","","427.466","5.130","-0.457","260.225863","24.499435","A2V","A","1","","" }
{ "94007","94302","180006","7295","","53    Dra","","53","","","Dra","","344.047","5.130","0.014","287.918954","56.859213","G8III","G","1","","" }
{ "103708","104043","199532","8021","","Alp Oct","Alp","","Alp","","Oct","","141.992","5.130","1.936","316.179319","-77.023767","F4III","F","1","","" }
{ "40728","40843","69897","3262","Gl 303","18Chi Cnc","Chi","18","Chi","","Cnc","","59.594","5.130","3.821","125.016090","27.217707","F6V","F","1","","" }
{ "41209","41325","71115","3306","","","","","","","Cnc","","394.863","5.130","-0.285","126.478198","7.564506","G8II","G","1","","" }
{ "117866","118234","224554","9069","","Pi  Phe","Pi","","Pi","","Phe","","287.362","5.130","0.405","359.732322","-52.745807","K1III","K","1","","" }
{ "84368","84626","156349","6424","","39Omi Oph","Omi","39","Omi","","Oph","","294.897","5.140","0.359","259.502841","-24.286901","K:...","K","1","","" }
{ "92870","93163","175329","7127","","Ome Pav","Ome","","Ome","","Pav","","563.310","5.140","-1.047","284.652174","-60.200550","K1III-IV","K","1","","" }
{ "94182","94477","179761","7287","","21    Aql","","21","","","Aql","","710.580","5.140","-1.551","288.427928","2.293707","B8II-III","B","1","","" }
{ "95202","95498","182762","7385","","4    Vul","","4","","","Vul","","271.571","5.140","0.538","291.369166","19.798365","K0III","K","1","","" }
{ "97559","97870","188665","7608","","23    Cyg","","23","","","Cyg","","633.313","5.140","-1.301","298.322393","57.523482","B5V","B","1","","" }
{ "99799","100122","193370","7770","","35    Cyg","","35","","","Cyg","","3166.567","5.140","-4.796","304.662791","34.982775","F5Ib","F","1","","" }
{ "101826","102157","196519","7881","","Ups Pav","Ups","","Ups","","Pav","","785.919","5.140","-1.770","310.487784","-66.760682","B8Vvar","B","1","","" }
{ "55833","56000","99803","4423","","","","","","","Cen","","699.906","5.140","-1.518","172.146196","-42.674203","B9V","B","1","","" }
{ "56487","56656","101021","4475","","","","","","","Cen","","233.804","5.140","0.863","174.252785","-61.283442","K1III","K","1","","" }
{ "59322","59504","106112","4646","","","","","","","Cam","","108.864","5.140","2.523","183.049664","77.616241","A5m","A","1","","" }
{ "60036","60221","107418","4699","","","","","","","Crv","","201.207","5.140","1.189","185.232136","-13.565724","K0III","K","1","","" }
{ "64701","64906","115735","5023","","21    CVn","","21","","","CVn","","274.774","5.140","0.512","199.560504","49.682062","A0V","A","1","","" }
{ "69789","70012","125454","5366","","102Ups Vir","Ups","102","Ups","","Vir","","261.553","5.140","0.619","214.885332","-2.265518","G9III","G","1","","" }
{ "76075","76307","139153","5800","","6Mu  CrB","Mu","6","Mu","","CrB","","618.892","5.140","-1.251","233.812143","39.010067","M2III","M","1","","" }
{ "77869","78105","142629","5925","","Xi 1Lup","Xi-1","","Xi","1","Lup","","138.202","5.140","2.005","239.222897","-33.966134","A3V","A","1","","" }
{ "2894","2900","3346","152","","","","","","","And","","616.553","5.140","-1.243","9.193540","44.488587","K5III","K","1","","" }
{ "5786","5799","7439","366","Gl 54.2A","37    Cet","","37","","","Cet","","76.276","5.140","3.295","18.600163","-7.922826","F5V","F","1","","Gl 54.2" }
{ "16281","16322","21686","1061","","4    Tau","","4","","","Tau","","361.192","5.140","-0.082","52.601954","11.336442","A0Vn","A","1","","" }
{ "17844","17886","23848","1177","","42    Per","","42","","","Per","","268.441","5.140","0.563","57.386216","33.091382","A3V","A","1","","" }
{ "25365","25429","36189","1836","","Lam Dor","Lam","","Lam","","Dor","","458.085","5.140","-0.598","81.580300","-58.912520","G6III","G","1","","" }
{ "28620","28691","41040","2130","","64    Ori","","64","","","Ori","","718.406","5.140","-1.575","90.864025","19.690561","B8V","B","1","","" }
{ "32679","32765","50223","2548","Gl 249.1","","","","","","Pup","","82.384","5.140","3.128","102.477569","-46.614560","F5III","F","1","","" }
{ "32778","32864","48879","2490","","42    Cam","","42","","","Cam","","923.956","5.140","-2.121","102.737869","67.571934","B4IV","B","1","","" }
{ "33692","33779","53047","2652","","","","","","","Car","","645.854","5.140","-1.344","105.214552","-51.402585","M1III","M","1","","" }
{ "33944","34033","52960","2649","","","","","","","Gem","","594.092","5.140","-1.162","105.908633","10.951817","K3III","K","1","","" }
{ "34017","34105","54118","2683","","","","","","","Car","","300.882","5.140","0.315","106.076356","-56.749724","A0p:","A","1","","" }
{ "36982","37088","61064","2927","","25    Mon","","25","","","Mon","","220.227","5.140","0.993","114.319547","-4.110979","F6III","F","1","","" }
{ "37908","38016","62898","3013","","80Pi  Gem","Pi","80","Pi","","Gem","","661.575","5.140","-1.396","116.876357","33.415697","M0III","M","1","","" }
{ "38807","38917","65685","3121","","","","","","","Pup","","290.951","5.140","0.388","119.465514","-45.577669","K2III","K","1","","" }
{ "39456","39567","66664","3163","","8    Cnc","","8","","","Cnc","","214.577","5.140","1.049","121.268705","13.118215","A1V","A","1","","" }
{ "40170","40285","69144","3244","","","","","","","Vel","","1358.985","5.140","-2.959","123.400655","-46.991628","B2.5IV","B","1","","" }
{ "52590","52742","93563","4221","","","","","","","Vel","","526.059","5.140","-0.898","161.739510","-56.757192","B8/B9III","B","1","","" }
{ "29822","29895","43827","2260","","","","","","","CMa","","618.892","5.150","-1.241","94.423849","-16.815908","K1III","K","1","","" }
{ "37838","37946","62647","2999","","","","","","","Lyn","","433.143","5.150","-0.466","116.663654","37.517394","M3III","M","1","","" }
{ "42715","42834","74753","3476","","","","","","","Vel","","1853.161","5.150","-3.622","130.917808","-49.822802","B0IIIn","B","1","","" }
{ "43408","43531","75506","3508","","35    Lyn","","35","","","Lyn","","264.952","5.150","0.601","132.986808","43.726603","K0III","K","1","","" }
{ "44728","44857","77800","3609","","11Sig1UMa","Sig-1","11","Sig","1","UMa","","521.017","5.150","-0.867","137.097999","66.873235","K5III","K","1","","" }
{ "47519","47654","83506","3839","","27    UMa","","27","","","UMa","","478.235","5.150","-0.681","145.738428","72.252618","K0III","K","1","","" }
{ "49942","50083","88981","4025","","","","","","","Car","","307.695","5.150","0.277","153.377760","-66.372811","Am","A","1","","" }
{ "54201","54360","96616","4327","","","","","","","Cen","","274.312","5.150","0.526","166.819617","-42.638681","Ap SrCrEu","A","1","","" }
{ "56585","56754","101189","4487","","","","","","","Cen","","285.102","5.150","0.442","174.530565","-61.826563","B9IV","B","1","","" }
{ "58628","58803","104731","4600","GJ 3701","","","","","","Cen","","82.592","5.150","3.132","180.914598","-42.434056","F6V","F","1","","" }
{ "60135","60320","107566","4703","","Zet2Mus","Zet-2","","Zet","2","Mus","","329.784","5.150","0.126","185.530701","-67.522105","Am","A","1","","" }
{ "63875","64078","114038","4955","","49    Vir","","49","","","Vir","","307.405","5.150","0.279","196.974217","-10.740408","K2III","K","1","","" }
{ "67032","67244","119921","5174","","","","","","","Cen","","436.622","5.150","-0.483","206.734806","-36.251933","A0V","A","1","","" }
{ "71971","72197","129926","5497","Gl 561.1A","54    Hya","","54","","","Hya","","98.775","5.150","2.744","221.500372","-25.443181","F0V + G/K","F","1","","Gl 561.1" }
{ "72377","72603","130819","5530","Gl 563.4","8Alp1Lib","Alp-1","8","Alp","1","Lib","","74.944","5.150","3.343","222.671601","-15.997237","F3V","F","1","","" }
{ "74377","74605","136064","5691","Gl 580.2","","","","","","UMi","","82.655","5.150","3.131","228.658886","67.346722","F9IV","F","1","","" }
{ "74479","74707","135345","5667","","","","","","","Lup","","1763.007","5.150","-3.514","229.016773","-41.491155","F:+...","F","1","","" }
{ "75532","75761","137898","5746","","10    Ser","","10","","","Ser","","129.633","5.150","2.154","232.159321","1.842081","A8IV","A","1","","" }
{ "81823","82073","151217","6228","","43    Her","","43","","","Her","","354.133","5.150","-0.029","251.457880","8.582616","K5III","K","1","","" }
{ "114158","114520","218918","8826","","59    Peg","","59","","","Peg","","242.315","5.150","0.795","347.934123","8.720116","A5Vn","A","1","","" }
{ "98114","98425","189687","7647","","25    Cyg","","25","","","Cyg","","1320.471","5.150","-2.887","299.979980","37.042885","B3IV","B","1","","" }
{ "101607","101936","196758","7897","","1    Aqr","","1","","","Aqr","","233.135","5.150","0.879","309.853714","0.486445","K1III","K","1","","" }
{ "101655","101984","196777","7900","","15Ups Cap","Ups","15","Ups","","Cap","","580.349","5.150","-1.101","310.012271","-18.138659","M1III","M","1","","" }
{ "102200","102531","197963","7947","","12Gam1Del","Gam-1","12","Gam","1","Del","","123.779","5.150","2.254","311.661934","16.124134","A2Ia+...","A","1","","" }
{ "5532","5544","7034","349","","82    Psc","","82","","","Psc","","480.348","5.150","-0.691","17.778201","31.424736","F0V","F","1","","" }
{ "9439","9459","12524","602","","Chi Phe","Chi","","Chi","","Phe","","375.324","5.150","-0.155","30.426599","-44.713509","K5III","K","1","","" }
{ "11756","11784","15656","736","","14    Tri","","14","","","Tri","","433.143","5.150","-0.466","38.025682","36.147271","K5III","K","1","","" }
{ "1682","1686","1671","82","","27Rho And","Rho","27","Rho","","And","","158.328","5.160","1.729","5.280250","37.968603","F5III","F","1","","" }
{ "11034","11060","14489","685","","9    Per","","9","","","Per","","326156.378","5.160","-14.840","35.589310","55.845653","A2Ia","A","1","","" }
{ "13683","13717","18331","875","","","","","","","Eri","","186.482","5.160","1.374","44.155934","-3.712320","A3Vn","A","1","","" }
{ "15366","15404","20365","987","","29    Per","","29","","","Per","","637.024","5.160","-1.294","49.657225","50.222174","B3V","B","1","","" }
{ "27552","27621","39640","2049","","","","","","","Pic","","256.412","5.160","0.682","87.721750","-52.108873","G8III","G","1","","" }
{ "112575","112935","216385","8697","GJ 9801A","49Sig Peg","Sig","49","Sig","","Peg","","88.968","5.160","2.981","343.100295","9.835664","F7IV","F","1","","GJ 9801" }
{ "31010","31084","46184","2379","","","","","","","CMa","","366.468","5.160","-0.093","97.846017","-12.391953","K1III","K","1","","" }
{ "38273","38382","64096","3064","Gl 291A","9    Pup","","9","","","Pup","","53.830","5.160","4.072","117.942932","-13.898029","G2V","G","1","","Gl 291" }
{ "40314","40429","69863","3260","","","","","","","Car","","252.834","5.160","0.713","123.816409","-62.915643","A+...","A","1","","" }
{ "44819","44946","78515","3627","","77Xi  Cnc","Xi","77","Xi","","Cnc","Nahn","373.177","5.160","-0.132","137.339723","22.045446","K0III","K","1","","" }
{ "51665","51814","91480","4141","","37    UMa","","37","","","UMa","","86.514","5.160","3.042","158.790252","57.082637","F1V","F","1","","" }
{ "67713","67929","121299","5232","","90    Vir","","90","","","Vir","","246.528","5.160","0.768","208.675611","-1.503125","K2III","K","1","","" }
{ "73548","73776","132905","5593","","Eta Cir","Eta","","Eta","","Cir","","275.936","5.160","0.523","226.200455","-64.031350","G8III","G","1","","" }
{ "75301","75530","137471","5739","","9Tau1Ser","Tau-1","9","Tau","1","Ser","","689.548","5.160","-1.466","231.447487","15.428036","M1III","M","1","","" }
{ "76011","76243","138764","5780","","","","","","","Lib","","399.212","5.160","-0.279","233.610473","-9.183416","B6IV","B","1","","" }
{ "90605","90887","170642","6942","","","","","","","CrA","","229.203","5.160","0.926","278.088855","-39.704001","A3V","A","1","","" }
{ "105229","105570","203562","8178","","10Bet Equ","Bet","10","Bet","","Equ","","330.787","5.160","0.129","320.723385","6.811140","A3V","A","1","","" }
{ "106752","107095","206301","8283","","42    Cap","","42","","","Cap","","108.394","5.160","2.552","325.386923","-14.047611","G2V","G","1","","" }
{ "87292","87563","163217","6677","","90    Her","","90","","","Her","","353.749","5.170","-0.006","268.325110","40.007959","K3III","K","1","","" }
{ "93520","93815","177171","7213","","Rho Tel","Rho","","Rho","","Tel","","185.001","5.170","1.401","286.583093","-52.340910","F7V","F","1","","" }
{ "95152","95447","182572","7373","Gl 759","31    Aql","","31","","","Aql","","49.500","5.170","4.264","291.242462","11.944415","G8IVvar","G","1","","" }
{ "95260","95556","183056","7395","","4    Cyg","","4","","","Cyg","","707.497","5.170","-1.511","291.538026","36.317896","B9sp...","B","1","","" }
{ "96156","96459","185351","7468","","","","","","","Cyg","","133.179","5.170","2.115","294.158331","44.694936","K0III","K","1","","" }
{ "103750","104085","200365","8055","","Mu  Ind","Mu","","Mu","","Ind","","365.646","5.170","-0.078","316.309345","-54.727042","K2III","K","1","","" }
{ "104625","104963","202320","8127","","28Phi Cap","Phi","28","Phi","","Cap","","643.307","5.170","-1.305","318.907914","-20.651696","K0II/III","K","1","","" }
{ "38103","38211","63697","3044","","6    Pup","","6","","","Pup","","254.611","5.170","0.708","117.421665","-17.228408","K3III","K","1","","" }
{ "43966","44093","77140","3588","","","","","","","Vel","","224.780","5.170","0.978","134.718237","-47.234688","Am","A","1","","" }
{ "44016","44143","77370","3598","Gl 333.1","","","","","","Car","","86.171","5.170","3.060","134.851163","-59.083712","F3V","F","1","","" }
{ "2375","2381","2696","118","","","","","","","Cet","","173.211","5.170","1.544","7.594398","-23.787680","A3V","A","1","","" }
{ "3899","3909","4813","235","Gl 37","19Phi2Cet","Phi-2","19","Phi","2","Cet","","51.379","5.170","4.183","12.531639","-10.644326","F7IV-V","F","1","","" }
{ "5325","5336","6582","321","Gl 53A","30Mu  Cas","Mu","30","Mu","","Cas","","24.638","5.170","5.779","17.062154","54.920340","G5Vp","G","1","","Gl 53" }
{ "12241","12273","15920","743","","","","","","","Cas","","255.809","5.170","0.698","39.508630","72.818252","G8III","G","1","","" }
{ "12799","12832","17093","812","","38    Ari","","38","","","Ari","","118.516","5.170","2.368","41.239916","12.445761","A7III-IV","A","1","","" }
{ "20455","20507","27861","1383","","42Xi  Eri","Xi","42","Xi","","Eri","","209.075","5.170","1.136","65.920218","-3.745470","A2V","A","1","","" }
{ "117262","117629","223640","9031","","108    Aqr","","108","","","Aqr","","318.823","5.170","0.219","357.838905","-18.909163","Ap Si","A","1","","" }
{ "118869","","114379","4969","Gl 501B","42Alp Com","Alp","42","Alp","","Com","","46.721","5.170","4.390","197.495839","17.528977","F5 V","F","2","64037","Gl 501" }
{ "58014","58188","103632","4567","","30Eta Crt","Eta","30","Eta","","Crt","","251.470","5.170","0.735","179.003978","-17.150829","A0V","A","1","","" }
{ "58973","59151","105340","4617","","","","","","","Mus","","424.683","5.170","-0.403","181.958476","-75.367019","K2II/III","K","1","","" }
{ "60328","60514","107966","4717","","13    Com","","13","","","Com","","264.523","5.170","0.625","186.077183","26.098606","A3V","A","1","","" }
{ "61717","61910","110317","4821","","","","","","","Crv","","257.424","5.170","0.684","190.316477","-13.013901","F3IV","F","1","","" }
{ "63008","63210","112409","4913","","","","","","","Cen","","368.538","5.170","-0.095","194.268180","-51.198752","B8V","B","1","","" }
{ "55613","55779","99453","4413","GJ 3663","","","","","","Cen","","88.774","5.180","3.006","171.430753","-63.972475","F7V","F","1","","" }
{ "69151","69373","124730","5334","","","","","","","UMi","","428.027","5.180","-0.410","213.016826","69.432548","M2III","M","1","","" }
{ "72809","73036","131342","5546","","","","","","","Cir","","161.224","5.180","1.710","223.894309","-60.114164","K1III","K","1","","" }
{ "1704","1708","1737","84","","Iot Scl","Iot","","Iot","","Scl","","330.452","5.180","0.152","5.379981","-28.981469","K0III","K","1","","" }
{ "2220","2225","2421","104","","","","","","","And","","282.631","5.180","0.491","7.056809","44.394452","A2Vs","A","1","","" }
{ "8001","8016","10250","480","","42    Cas","","42","","","Cas","","277.580","5.180","0.530","25.732390","70.622526","B9V","B","1","","" }
{ "19123","19171","25823","1268","","41    Tau","","41","","","Tau","","420.305","5.180","-0.371","61.651712","27.599903","B9p Si","B","1","","" }
{ "22780","22833","31283","1569","","6    Ori","","6","","","Ori","","228.241","5.180","0.955","73.695404","11.426006","A3V","A","1","","" }
{ "24140","24197","33554","1684","","","","","","","Ori","","343.323","5.180","0.069","77.923181","16.045673","K5III","K","1","","" }
{ "25853","25918","37763","1953","","Gam Men","Gam","","Gam","","Men","","102.275","5.180","2.698","82.969772","-76.340964","K4III","K","1","","" }
{ "26575","26640","37438","1928","","125    Tau","","125","","","Tau","","427.466","5.180","-0.407","84.934159","25.897091","B3IV","B","1","","" }
{ "27138","27204","38666","1996","","Mu  Col","Mu","","Mu","","Col","","1331.251","5.180","-2.874","86.499561","-32.306435","B1IV/V","B","1","","" }
{ "92356","92646","174295","7087","","Kap Tel","Kap","","Kap","","Tel","","271.797","5.180","0.576","283.165119","-52.107370","G8/K0III","G","1","","" }
{ "96359","96665","185507","7474","","44Sig Aql","Sig","44","Sig","","Aql","","780.278","5.180","-1.714","294.798506","5.397773","B3V + B3V","B","1","","" }
{ "97319","97630","187849","7566","","19    Cyg","","19","","","Cyg","","692.476","5.180","-1.455","297.641641","38.722419","M2IIIa","M","1","","" }
{ "99534","99853","192713","7741","","22    Vul","","22","","","Vul","","1918.567","5.180","-3.668","303.875995","23.508906","G2Ib SB","G","1","","" }
{ "100934","101260","196502","7879","","73    Dra","","73","","","Dra","","395.821","5.180","-0.240","307.876677","74.954619","A0p...","A","1","","" }
{ "106887","107230","207130","8324","","","","","","","Cep","","244.495","5.180","0.806","325.767085","72.320084","K0III","K","1","","" }
{ "33595","33682","53501","2662","GJ 3422","","","","","","Vol","","292.255","5.180","0.418","104.960676","-67.916443","K3III","K","1","","" }
{ "35853","35951","58343","2825","","","","","","","CMa","","937.231","5.180","-2.112","111.167448","-16.201473","B2Vne","B","1","","" }
{ "40828","40943","70556","3283","","","","","","","Pup","","1489.299","5.180","-3.118","125.337686","-36.484177","B2IV-V+...","B","1","","" }
{ "41179","41296","71510","3330","","","","","","","Vel","","695.429","5.180","-1.464","126.380544","-51.727415","B2V","B","1","","" }
{ "42385","42504","74146","3442","","","","","","","Vel","","442.546","5.180","-0.483","129.990031","-53.054729","B4IV","B","1","","" }
{ "45201","45333","79028","3648","Gl 337.1","16    UMa","","16","","","UMa","","63.827","5.180","3.722","138.585608","61.423318","F9V","F","1","","" }
{ "52318","52469","92787","4191","","","","","","","UMa","","120.978","5.180","2.334","160.887337","46.203877","F5III","F","1","","" }
{ "54974","55137","98118","4371","","75    Leo","","75","","","Leo","","332.135","5.180","0.141","169.322501","2.010556","M0III comp","M","1","","" }
{ "116948","117315","223145","9006","","Sig Phe","Sig","","Sig","","Phe","","603.993","5.180","-1.158","356.816636","-50.226461","B3V","B","1","","" }
{ "111445","111797","214734","8627","","30    Cep","","30","","","Cep","","287.110","5.190","0.467","339.662724","63.584472","A3IV","A","1","","" }
{ "115040","115404","220278","8890","","97    Aqr","","97","","","Aqr","","213.174","5.190","1.113","350.663210","-15.039338","A3V","A","1","","" }
{ "85053","85312","157457","6468","","Kap Ara","Kap","","Kap","","Ara","","455.526","5.190","-0.535","261.500160","-50.633510","K1III","K","1","","" }
{ "99419","99738","192518","7731","","21    Vul","","21","","","Vul","","297.317","5.190","0.391","303.560534","28.694817","A7IVn","A","1","","" }
{ "102962","103294","199253","8011","","17    Del","","17","","","Del","","479.642","5.190","-0.647","313.902873","13.721536","K0III","K","1","","" }
{ "104930","105268","203467","8171","","6    Cep","","6","","","Cep","","1988.758","5.190","-3.736","319.842566","64.871855","B3IVe","B","1","","" }
{ "56414","56583","100696","4461","","2    Dra","","2","","","Dra","","237.550","5.190","0.878","174.011165","69.322952","K0III","K","1","","" }
{ "64587","64792","115383","5011","Gl 504","59    Vir","","59","","","Vir","","57.271","5.190","3.967","199.193826","9.424156","G0Vs","G","1","","" }
{ "73717","73945","133774","5622","","21Nu  Lib","Nu","21","Nu","","Lib","","695.429","5.190","-1.454","226.656654","-16.256818","K5III","K","1","","" }
{ "77041","77277","141653","5886","","","","","","","Dra","","286.102","5.190","0.475","236.666574","62.599557","A2IV","A","1","","" }
{ "80629","80874","148291","6125","","","","","","","TrA","","785.919","5.190","-1.720","247.705695","-61.633503","K0II/IIICN.","K","1","","" }
{ "11046","11072","14802","695","Gl 97","Kap For","Kap","","Kap","","For","","71.635","5.190","3.481","35.635567","-23.816326","G2V","G","1","","" }
{ "11193","11220","14770","694","","64    And","","64","","","And","","399.212","5.190","-0.249","36.103784","50.006546","G8III","G","1","","" }
{ "23785","23840","33684","1695","","","","","","","Dor","","565.262","5.190","-1.004","76.891743","-63.399679","M3III","M","1","","" }
{ "28673","28744","41335","2142","","","","","","","Mon","","1315.147","5.190","-2.838","91.056256","-6.708941","B2Vne+","B","1","","" }
{ "30644","30717","45416","2334","","","","","","","Mon","","849.366","5.190","-1.888","96.807339","0.299246","K1II","K","1","","" }
{ "38960","39070","66342","3153","","","","","","","Car","","982.399","5.190","-2.204","119.906434","-60.587061","M0II","M","1","","" }
{ "42306","42425","74405","3460","","The Vol","The","","The","","Vol","","240.174","5.190","0.854","129.771414","-70.386745","A0V","A","1","","" }
{ "43229","43352","75605","3512","","","","","","","Pyx","","223.855","5.190","1.007","132.464583","-32.780525","G8III","G","1","","" }
{ "51217","51362","90882","4116","","29Del Sex","Del","29","Del","","Sex","","321.971","5.190","0.218","157.369592","-2.739078","B9.5V","B","1","","" }
{ "27902","27971","39220","2027","","31    Cam","","31","","","Cam","","468.616","5.200","-0.587","88.740943","59.888367","A2V","A","1","","" }
{ "29577","29650","43042","2220","GJ 3390","71    Ori","","71","","","Ori","","67.893","5.200","3.608","93.712000","19.156448","F6V","F","1","","" }
{ "30859","30932","46355","2389","","","","","","","Pic","","304.250","5.200","0.351","97.368823","-56.852766","K0III","K","1","","" }
{ "32019","32104","48097","2466","","26    Gem","","26","","","Gem","","142.302","5.200","2.001","100.601361","17.645303","A2V","A","1","","" }
{ "33839","33927","52497","2630","","42Ome Gem","Ome","42","Ome","","Gem","","1489.299","5.200","-3.098","105.603253","24.215446","G5II","G","1","","" }
{ "33993","34081","53704","2666","","","","","","","Pup","","348.458","5.200","0.056","106.011655","-42.337280","Am","A","1","","" }
{ "35053","35146","55280","2715","","18    Lyn","","18","","","Lyn","","198.997","5.200","1.273","108.979004","59.637467","K2III","K","1","","" }
{ "36136","36238","58728","2846","","63    Gem","","63","","","Gem","","104.437","5.200","2.673","111.934856","21.445247","F5IV-V...","F","1","","" }
{ "39848","39961","68217","3204","","","","","","","Vel","","1249.641","5.200","-2.717","122.399650","-44.122773","B2IV-V","B","1","","" }
{ "42421","42540","74067","3439","","","","","","","Vel","","279.243","5.200","0.537","130.079935","-40.263875","Ap (SiCr)","A","1","","" }
{ "42560","42679","74371","3456","","","","","","","Vel","","326156.378","5.200","-14.800","130.487125","-45.410714","B5Iab","B","1","","" }
{ "56876","57047","101666","4503","","","","","","","Hya","","403.659","5.200","-0.263","175.433121","-32.499404","K5III","K","1","","" }
{ "60003","60189","107348","4696","","5Zet Crv","Zet","5","Zet","","Crv","","415.486","5.200","-0.326","185.140194","-22.215901","B8V","B","1","","" }
{ "63698","63901","113797","4943","","14    CVn","","14","","","CVn","","340.455","5.200","0.107","196.435170","35.798899","B9V","B","1","","" }
{ "68051","68269","121847","5250","","47    Hya","","47","","","Hya","","332.813","5.200","0.156","209.629787","-24.972249","B8V","B","1","","" }
{ "79955","80197","147749","6107","","20Nu 1CrB","Nu-1","20","Nu","1","CrB","","640.779","5.200","-1.266","245.589269","33.799052","M2III","M","1","","" }
{ "114764","115126","219834","8866","Gl 894.2A","94    Aqr","","94","","","Aqr","","68.882","5.200","3.577","349.777766","-13.458552","G6/G8IV","G","1","","Gl 894.2" }
{ "90162","90441","169985","6918","","59    Ser","","59","","","Ser","","469.290","5.200","-0.590","276.802118","0.196108","G0III+...","G","1","","" }
{ "91939","92226","173540","7050","","Mu  CrA","Mu","","Mu","","CrA","","395.821","5.200","-0.220","281.935891","-40.406167","G5/G6III","G","1","","" }
{ "92725","93017","176051","7162","Gl 738A","","","","","","Lyr","","48.506","5.200","4.338","284.256616","32.901273","G0V","G","1","","Gl 738" }
{ "93622","93917","178449","7261","","17    Lyr","","17","","","Lyr","","135.616","5.200","2.106","286.856530","32.501738","F0V","F","1","","" }
{ "103839","104174","200763","8076","","","","","","","Mic","","328.125","5.200","0.187","316.602826","-32.341618","K2III","K","1","","" }
{ "103879","104214","201091","8085","Gl 820A","61    Cyg","","61","","","Cyg","","11.371","5.200","7.488","316.721911","38.749415","K5V","K","1","","Gl 820" }
{ "2349","2355","2628","114","","28    And","","28","","","And","","204.743","5.200","1.211","7.530671","29.751557","A7III","A","1","","" }
{ "2756","2762","3196","142","Gl 23A","13    Cet","","13","","","Cet","","69.321","5.200","3.563","8.811995","-3.592846","F8V...","F","1","","Gl 23" }
{ "19899","19949","26764","1314","","","","","","","Cam","","326.810","5.200","0.196","64.179563","53.611799","A2Vn","A","1","","" }
{ "21243","21296","29064","1451","","47    Eri","","47","","","Eri","","994.379","5.200","-2.221","68.548453","-8.231352","M3III","M","1","","" }
{ "5289","5300","6767","331","","Ups Phe","Ups","","Ups","","Phe","","185.738","5.210","1.433","16.949359","-41.486916","A3V","A","1","","" }
{ "5725","5737","7344","361","","86Zet Psc","Zet","86","Zet","","Psc","Revati","173.857","5.210","1.576","18.432854","7.575354","A7IV","A","1","","" }
{ "12451","12484","16920","802","","Zet Hor","Zet","","Zet","","Hor","","160.116","5.210","1.755","40.164996","-54.549911","F4IV","F","1","","" }
{ "19157","19205","25867","1269","","42Psi Tau","Psi","42","Psi","","Tau","","90.024","5.210","3.005","61.751927","29.001299","F1V","F","1","","" }
{ "111099","111449","213845","8592","Gl 863.2","59Ups Aqr","Ups","59","Ups","","Aqr","","73.975","5.210","3.432","338.673450","-20.708216","F7V","F","1","","" }
{ "28224","28296","40446","2103","","60    Ori","","60","","","Ori","","445.569","5.210","-0.467","89.706549","0.552979","A1Vs","A","1","","" }
{ "30384","30457","44951","2305","","","","","","","CMa","","348.458","5.210","0.066","96.043003","-11.530088","K3III","K","1","","" }
{ "30606","30679","44708","2293","","5    Lyn","","5","","","Lyn","","626.020","5.210","-1.206","96.703650","58.417409","K4III","K","1","","" }
{ "31979","32064","48217","2469","","","","","","","Mon","","344.410","5.210","0.092","100.484944","-9.167537","M0III","M","1","","" }
{ "55590","55756","99322","4409","","","","","","","Cen","","274.081","5.210","0.588","171.372784","-36.063062","K0III","K","1","","" }
{ "64520","64725","115202","5001","Gl 503.3","57    Vir","","57","","","Vir","","125.493","5.210","2.284","198.994833","-19.943103","K1III","K","1","","" }
{ "65890","66098","117818","5100","","76    Vir","","76","","","Vir","","235.153","5.210","0.920","203.241971","-10.165000","K0III","K","1","","" }
{ "77342","77578","141680","5888","","34Ome Ser","Ome","34","Ome","","Ser","","273.392","5.210","0.593","237.573112","2.196509","G8III","G","1","","" }
{ "84820","85079","157042","6451","","Iot Ara","Iot","","Iot","","Ara","","934.546","5.210","-2.076","260.816987","-47.468197","B2IIIne","B","1","","" }
{ "92102","92390","174116","7078","GJ 4080","29    Sgr","","29","","","Sgr","","934.546","5.220","-2.066","282.417109","-20.324656","K2III","K","1","","" }
{ "92117","92405","174602","7102","","9Nu 2Lyr","Nu-2","9","Nu","2","Lyr","","231.481","5.220","0.965","282.470491","32.551058","A3V","A","1","","" }
{ "94965","95260","182255","7358","","3    Vul","","3","","","Vul","","392.959","5.220","-0.185","290.712016","26.262403","B6III","B","1","","" }
{ "98272","98583","190544","7676","","64    Dra","","64","","","Dra","","587.669","5.220","-1.059","300.368906","64.820974","M1III","M","1","","" }
{ "105752","106093","204771","8228","","71    Cyg","","71","","","Cyg","","216.715","5.220","1.108","322.362243","46.540585","K0III","K","1","","" }
{ "31045","31119","46089","2375","","","","","","","Mon","","207.611","5.220","1.201","97.951244","11.544412","A3V","A","1","","" }
{ "32476","32562","48781","2487","","57Psi6Aur","Psi-6","57","Psi","6","Aur","","360.394","5.220","0.003","101.914907","48.789476","K1III","K","1","","" }
{ "33790","33878","52666","2639","","","","","","","Mon","","571.202","5.220","-0.997","105.484935","-5.722065","M2III","M","1","","" }
{ "36163","36265","58923","2851","","5Eta CMi","Eta","5","Eta","","CMi","","318.201","5.220","0.274","112.008644","6.941968","F0III","F","1","","" }
{ "37912","38020","63578","3037","","","","","","","Pup","","1568.059","5.220","-3.190","116.881282","-46.608490","B1V","B","1","","" }
{ "38951","39061","65925","3140","","","","","","","Pup","","181.198","5.220","1.496","119.868248","-39.296944","F3V","F","1","","" }
{ "43844","43970","76543","3561","","62Omi1Cnc","Omi-1","62","Omi","1","Cnc","","149.134","5.220","1.919","134.312286","15.322762","A5III","A","1","","" }
{ "54607","54767","97583","4355","","","","","","","Car","","312.710","5.220","0.311","168.188513","-64.169770","B9V","B","1","","" }
{ "3497","3505","4247","197","Gl 31.3","","","","","","Cet","","87.231","5.220","3.084","11.184995","-22.006135","F0V","F","1","","" }
{ "9741","9763","12339","592","","49    Cas","","49","","","Cas","","400.192","5.220","-0.224","31.381544","76.115060","G8III","G","1","","" }
{ "13840","13874","18543","892","","","","","","","Eri","","360.793","5.220","0.001","44.675320","-2.782877","A2IV","A","1","","" }
{ "19749","19799","26793","1315","","","","","","","Tau","","391.075","5.220","-0.174","63.650976","10.011406","B9Vn","B","1","","" }
{ "21494","21547","29391","1474","","51    Eri","","51","","","Eri","","95.985","5.220","2.876","69.400549","-2.473548","F0V","F","1","","" }
{ "23679","23734","32343","1622","","11    Cam","","11","","","Cam","","685.202","5.220","-1.392","76.535234","58.972372","B2.5Ve","B","1","","" }
{ "24987","25048","34759","1749","","20Rho Aur","Rho","20","Rho","","Aur","","529.475","5.220","-0.832","80.451721","41.804572","B5V","B","1","","" }
{ "115711","116076","221345","8930","","14    And","","14","","","And","Veritate","258.240","5.220","0.727","352.822354","39.236198","K0III","K","1","","" }
{ "55664","55831","99556","4415","","","","","","","Cen","","1364.671","5.220","-2.888","171.647610","-61.115167","B3IV","B","1","","" }
{ "58509","58684","104513","4594","","67    UMa","","67","","","UMa","","111.774","5.220","2.545","180.528589","43.045600","A7m","A","1","","" }
{ "62074","62267","110951","4847","","32    Vir","","32","","","Vir","","252.638","5.220","0.775","191.404410","7.673326","A8m","A","1","","" }
{ "69813","70035","125158","5349","","","","","","","Cen","","157.716","5.220","1.798","214.965031","-61.272972","Am","A","1","","" }
{ "72064","72290","129893","5495","","","","","","","Lup","","259.886","5.220","0.713","221.755417","-52.383518","G6III","G","1","","" }
{ "81965","82216","151525","6234","","45    Her","","45","","","Her","","393.434","5.220","-0.187","251.943410","5.246746","B9p (Cr)","B","1","","" }
{ "62876","63076","112429","4916","","8    Dra","","8","","","Dra","Taiyi","95.535","5.230","2.896","193.868968","65.438474","A5n","A","1","","" }
{ "72131","72357","130259","5516","","56    Hya","","56","","","Hya","","358.020","5.230","0.028","221.936678","-26.087500","G8/K0III","G","1","","" }
{ "76702","76939","139980","5837","","","","","","","Lup","","260.717","5.230","0.716","235.659679","-37.424935","G8/K0III","G","1","","" }
{ "79366","79607","146361","6063","Gl 615.2A","17Sig CrB","Sig","17","Sig","","CrB","","68.751","5.230","3.611","243.670355","33.858613","F8V","F","1","","Gl 615.2" }
{ "82242","82493","151804","6245","","","","","","","Sco","","326156.378","5.230","-14.770","252.890510","-41.230534","O9e","O","1","","" }
{ "6301","6315","8126","389","","91    Psc","","91","","","Psc","","350.329","5.230","0.075","20.280711","28.738207","K5III","K","1","","" }
{ "10282","10306","13555","646","GJ 1043","17Eta Ari","Eta","17","Eta","","Ari","","94.156","5.230","2.928","33.200328","21.210993","F5V","F","1","","" }
{ "14420","14456","19349","935","","","","","","","Eri","","456.163","5.230","-0.498","46.639551","-6.088555","M3III","M","1","","" }
{ "82478","82730","152601","6280","","23    Oph","","23","","","Oph","","240.706","5.230","0.890","253.648724","-6.153982","K2III","K","1","","" }
{ "85773","86036","160269","6573","Gl 684A","26    Dra","","26","","","Dra","","46.283","5.230","4.470","263.747552","61.874554","G0V","G","1","","Gl 684" }
{ "93773","94068","178596","7266","","19    Aql","","19","","","Aql","","149.339","5.230","1.926","287.249634","6.073207","F0III-IV","F","1","","" }
{ "98324","98636","190004","7657","","16    Vul","","16","","","Vul","","221.724","5.230","1.068","300.505943","24.938043","F2III","F","1","","" }
{ "32207","32292","48917","2492","","10    CMa","","10","","","CMa","","326156.378","5.230","-14.770","101.118613","-31.070523","B2V","B","1","","" }
{ "35809","35907","57669","2805","","66    Aur","","66","","","Aur","","1207.987","5.230","-2.613","111.035287","40.672389","K0III","K","1","","" }
{ "39857","39970","68324","3213","","","","","","","Vel","","1105.615","5.230","-2.421","122.429816","-47.937193","B1IVe","B","1","","" }
{ "43709","43834","76219","3540","","58Rho2Cnc","Rho-2","58","Rho","2","Cnc","","486.800","5.230","-0.640","133.915333","27.927481","G8II-III","G","1","","" }
{ "44027","44154","76813","3575","","64Sig3Cnc","Sig-3","64","Sig","3","Cnc","","295.699","5.230","0.443","134.886078","32.418559","G9III","G","1","","" }
{ "44209","44337","77653","3605","","","","","","","Vel","","368.538","5.230","-0.035","135.435686","-52.188685","Ap Si","A","1","","" }
{ "44670","44798","78316","3623","","76Kap Cnc","Kap","76","Kap","","Cnc","","531.199","5.230","-0.829","136.936718","10.668191","B8IIIMNp","B","1","","" }
{ "48786","48926","86629","3947","","Eta Ant","Eta","","Eta","","Ant","","108.646","5.230","2.617","149.717865","-35.890973","A8IV","A","1","","" }
{ "52549","52701","93549","4220","","","","","","","Car","","476.141","5.230","-0.592","161.623337","-64.263242","B7IV","B","1","","" }
{ "53098","53252","94388","4251","Gl 403.1","","","","","","Hya","","100.479","5.230","2.787","163.373036","-20.138731","F6V","F","1","","" }
{ "32394","32480","48682","2483","Gl 245","56Psi5Aur","Psi-5","56","Psi","5","Aur","","54.523","5.240","4.124","101.684745","43.577427","G0V","G","1","","" }
{ "35295","35393","57240","2791","","","","","","","Pup","","462.633","5.240","-0.519","109.639642","-39.210285","A0V","A","1","","" }
{ "36537","36641","59881","2880","","7Del1CMi","Del-1","7","Del","1","CMi","","760.271","5.240","-1.598","113.024787","1.914481","F0III","F","1","","" }
{ "42215","42334","73495","3420","","Eta Pyx","Eta","","Eta","","Pyx","","231.810","5.240","0.981","129.467311","-26.255000","A0V","A","1","","" }
{ "45212","45344","79735","3674","","","","","","","Vel","","611.926","5.240","-1.126","138.602042","-43.227493","B4V+...","B","1","","" }
{ "45396","45527","79910","3681","","23    Hya","","23","","","Hya","","245.415","5.240","0.858","139.173901","-6.353144","K2III","K","1","","" }
{ "89921","90200","168905","6875","","","","","","","CrA","","487.528","5.240","-0.633","276.076006","-44.110256","B2.5Vn","B","1","","" }
{ "97863","98174","188162","7587","","","","","","","Pav","","278.528","5.240","0.583","299.276238","-58.901351","B9.5IV","B","1","","" }
{ "101594","101923","196662","7889","","14Tau Cap","Tau","14","Tau","","Cap","","1136.434","5.240","-2.471","309.817990","-14.954760","B7III","B","1","","" }
{ "103240","103571","","","","","","","","","Equ","","184.478","5.240","1.477","314.771294","4.294610","G0V","G","1","","" }
{ "106785","107128","206356","8285","","41    Cap","","41","","","Cap","","230.662","5.240","0.992","325.502883","-23.262858","K0III","K","1","","" }
{ "109226","109572","210855","8472","","","","","","","Cep","","121.836","5.240","2.378","332.952721","56.839357","F8V","F","1","","" }
{ "56610","56779","101153","4483","","1Ome Vir","Ome","1","Ome","","Vir","","497.190","5.240","-0.675","174.615032","8.134298","M4III","M","1","","" }
{ "64144","64348","114474","4973","","","","","","","Cen","","222.329","5.240","1.072","197.846836","-43.368553","K1/K2III","K","1","","" }
{ "73681","73909","134190","5635","","","","","","","Boo","","257.424","5.240","0.754","226.569569","54.556318","G8III","G","1","","" }
{ "79300","79540","145897","6048","","17Chi Sco","Chi","17","Chi","","Sco","","378.372","5.240","-0.082","243.462104","-11.837747","K3III","K","1","","" }
{ "80377","80620","148349","6128","","","","","","","Oph","","577.268","5.240","-1.000","246.931068","-7.597929","M2 comp","M","1","","" }
{ "80598","80843","148897","6152","","","","","","","Her","","628.432","5.240","-1.184","247.639800","20.479188","G8p","G","1","","" }
{ "948","950","739","35","GJ 3013","The Scl","The","","The","","Scl","","69.395","5.240","3.600","2.933278","-35.133119","F3/F5V","F","1","","" }
{ "3939","3949","4919","242","","Rho Phe","Rho","","Rho","","Phe","","242.135","5.240","0.887","12.671520","-50.986816","F2III","F","1","","" }
{ "7966","7981","10476","493","Gl 68","107    Psc","","107","","","Psc","","24.567","5.240","5.855","25.624056","20.268504","K1V","K","1","","" }
{ "14009","14043","18537","890","","","","","","","Per","","458.729","5.240","-0.501","45.217509","52.351744","B7V","B","1","","" }
{ "15333","15371","20807","1010","Gl 138","Zet2Ret","Zet-2","","Zet","2","Ret","","39.244","5.240","4.838","49.549639","-62.506363","G1V","G","1","","" }
{ "16762","16803","22470","1100","","20    Eri","","20","","","Eri","","486.800","5.240","-0.630","54.072548","-17.467064","B8/B9III","B","1","","" }
{ "17415","17457","23363","1146","","24    Eri","","24","","","Eri","","654.932","5.240","-1.274","56.127125","-1.163091","B7V","B","1","","" }
{ "17675","17717","23878","1181","","28Tau7Eri","Tau-7","28","Tau","7","Eri","","250.890","5.240","0.810","56.915201","-23.874677","A1V","A","1","","" }
{ "17912","17954","23985","1188","","","","","","","Tau","","184.165","5.240","1.481","57.578900","25.579362","A2V","A","1","","" }
{ "20334","20384","28093","1395","","Eta Ret","Eta","","Eta","","Ret","","384.618","5.240","-0.118","65.471939","-63.386391","G7III","G","1","","" }
{ "21244","21297","29065","1452","","","","","","","Eri","","760.271","5.240","-1.598","68.549044","-8.970258","K4III","K","1","","" }
{ "25134","25197","34787","1751","","16    Cam","","16","","","Cam","","336.244","5.240","0.174","80.865980","57.544395","A0Vn","A","1","","" }
{ "26203","26268","37077","1901","","45    Ori","","45","","","Ori","","359.599","5.240","0.028","83.914517","-4.856067","F0III","F","1","","" }
{ "112170","112529","215721","8670","","68    Aqr","","68","","","Aqr","","254.016","5.240","0.783","341.888032","-19.613375","G8III","G","1","","" }
{ "116722","117089","222847","8998","","106    Aqr","","106","","","Aqr","","378.811","5.240","-0.085","356.050326","-18.276938","B9V","B","1","","" }
{ "119195","","164765","6734","Gl 700.1A","69Tau Oph","Tau","69","Tau","","Oph","","169.696","5.240","1.659","270.768033","-8.181708","dF3   J","F","1","","Gl 700.1" }
{ "111678","112031","214993","8640","","12    Lac","","12","","","Lac","","1342.207","5.250","-2.822","340.369379","40.225449","B2IIIv SB","B","1","","" }
{ "113504","113864","218029","8779","","","","","","","Cep","","413.379","5.250","-0.265","345.886924","67.209210","K3III","K","1","","" }
{ "76299","76534","139641","5823","","54Phi Boo","Phi","54","Phi","","Boo","","169.696","5.250","1.669","234.456609","40.353433","G8III-IV","G","1","","" }
{ "31088","31165","46568","2399","","","","","","","Col","","273.163","5.250","0.635","98.089066","-37.696702","G8III","G","1","","" }
{ "31608","31688","47536","2447","","","","","","","CMa","","402.166","5.250","-0.205","99.448363","-32.339735","K1III","K","1","","" }
{ "37813","37921","62832","3008","","11    CMi","","11","","","CMi","","301.438","5.250","0.421","116.567504","10.768252","A1Vnn","A","1","","" }
{ "39376","39487","66888","3170","","","","","","","Pup","","2090.746","5.250","-3.784","121.067460","-32.674829","M2II","M","1","","" }
{ "50272","50414","89254","4042","","22Eps Sex","Eps","22","Eps","","Sex","","193.450","5.250","1.384","154.407513","-8.068914","F2III","F","1","","" }
{ "51354","51502","90089","4084","Gl 392.1","","","","","","Cam","","70.126","5.250","3.588","157.770726","82.558587","F2V","F","1","","" }
{ "86040","86305","159492","6549","Gl 683","Pi  Ara","Pi","","Pi","","Ara","","145.346","5.250","2.005","264.523072","-54.500434","A7V","A","1","","" }
{ "88057","88331","164852","6738","","96    Her","","96","","","Her","","939.932","5.250","-2.048","270.596035","20.833632","B3IV","B","1","","" }
{ "89788","90067","169191","6885","","","","","","","Her","","362.799","5.250","0.019","275.704325","17.826616","K3III","K","1","","" }
{ "91769","92056","174980","7117","","","","","","","Dra","","315.737","5.250","0.321","281.444831","74.085553","K0II-III","K","1","","" }
{ "93608","93903","178475","7262","","18Iot Lyr","Iot","18","Iot","","Lyr","","896.034","5.250","-1.944","286.825538","36.100157","B6IV","B","1","","" }
{ "104400","104738","201772","8104","","","","","","","Mic","","107.500","5.250","2.660","318.262653","-39.424922","F5V","F","1","","" }
{ "7940","7955","10537","497","","Pi  Scl","Pi","","Pi","","Scl","","214.859","5.250","1.156","25.535841","-32.326970","K1II/III","K","1","","" }
{ "10535","10559","13869","655","","7    Tri","","7","","","Tri","","280.685","5.250","0.576","33.984527","33.358895","A0V","A","1","","" }
{ "13108","13141","17848","852","","Nu  Hor","Nu","","Nu","","Hor","","164.559","5.250","1.736","42.255925","-62.806521","A2V","A","1","","" }
{ "25139","25202","35337","1783","","8    Lep","","8","","","Lep","","1647.254","5.250","-3.267","80.875652","-13.927352","B2IV","B","1","","" }
{ "13132","13165","17543","836","","42Pi  Ari","Pi","42","Pi","","Ari","","780.278","5.260","-1.634","42.323166","17.464309","B6V","B","1","","" }
{ "14257","14293","19107","925","","10Rho3Eri","Rho-3","10","Rho","3","Eri","","135.560","5.260","2.166","46.068814","-7.600857","A8V","A","1","","" }
{ "20211","20261","27459","1356","","58    Tau","","58","","","Tau","","153.125","5.260","1.902","65.151284","15.095453","F0V","F","1","","" }
{ "20216","20266","27022","1327","","","","","","","Cam","","319.448","5.260","0.305","65.168118","65.140441","G5III","G","1","","" }
{ "27318","27386","38710","1999","","52    Ori","","52","","","Ori","","538.212","5.260","-0.828","87.000976","6.454156","A5V","A","1","","" }
{ "31357","31434","46553","2398","","49    Aur","","49","","","Aur","","369.792","5.260","-0.013","98.800256","28.022314","A0Vnn","A","1","","" }
{ "45196","45328","79846","3679","","","","","","","Vel","","639.522","5.260","-1.202","138.575022","-55.569629","G8II/III","G","1","","" }
{ "45500","45631","80456","3703","","","","","","","Vel","","437.794","5.260","-0.379","139.524492","-51.050859","B7/B8III","B","1","","" }
{ "48743","48883","86360","3937","","27Nu  Leo","Nu","27","Nu","","Leo","","499.474","5.260","-0.665","149.555734","12.444800","B9IV","B","1","","" }
{ "49557","49698","88323","3995","","","","","","","Car","","369.373","5.260","-0.010","152.178338","-65.815438","K0III","K","1","","" }
{ "53000","53154","94367","4250","","","","","","","Car","","326156.378","5.260","-14.740","163.128536","-57.240405","B9Ia","B","1","","" }
{ "56404","56573","100825","4466","","","","","","","Cen","","201.580","5.260","1.305","173.981565","-47.641643","A7m","A","1","","" }
{ "56805","56975","101484","4495","","92    Leo","","92","","","Leo","","269.997","5.260","0.670","175.196124","21.352730","K1III","K","1","","" }
{ "57909","58082","103462","4558","","","","","","","Hya","","286.102","5.260","0.545","178.677234","-25.713887","G8III","G","1","","" }
{ "67489","67703","120642","5207","","","","","","","Cen","","259.886","5.260","0.753","208.020320","-52.811530","B9Vn","B","1","","" }
{ "68848","69068","123782","5300","","13    Boo","","13","","","Boo","","549.085","5.260","-0.871","212.072172","49.458167","M2III","M","1","","" }
{ "75599","75828","137709","5742","","","","","","","Lup","","1094.485","5.260","-2.369","232.351130","-46.732704","K4III","K","1","","" }
{ "76191","76425","139195","5802","","16    Ser","","16","","","Ser","","231.153","5.260","1.008","234.123246","10.010176","K0p","K","1","","" }
{ "79919","80161","148293","6126","","","","","","","Dra","","293.306","5.260","0.491","245.453044","69.109391","K2III","K","1","","" }
{ "92963","93256","176527","7181","","","","","","","Lyr","","323.568","5.260","0.277","284.939494","26.230404","K2III","K","1","","" }
{ "108578","108924","209772","8416","","18    Cep","","18","","","Cep","","424.130","5.260","-0.310","330.970631","63.119920","M5III","M","1","","" }
{ "83058","83313","154029","6332","","59    Her","","59","","","Her","","322.289","5.270","0.296","255.401503","33.568270","A3IV","A","1","","" }
{ "83176","83431","153580","6314","GJ 3985","Eps2Ara","Eps-2","","Eps","2","Ara","","88.798","5.270","3.095","255.786291","-53.237028","F6V","F","1","","" }
{ "92910","93203","176303","7172","","11    Aql","","11","","","Aql","","157.945","5.270","1.845","284.773917","13.622245","F8V","F","1","","" }
{ "99648","99968","193092","7759","","","","","","","Cyg","","1575.635","5.270","-3.150","304.230354","40.365075","K5II","K","1","","" }
{ "107500","107843","206240","8280","","Lam Oct","Lam","","Lam","","Oct","","409.230","5.270","-0.223","327.726201","-82.718904","G8/K0III+..","G","1","","" }
{ "108659","109005","209960","8426","","20    Cep","","20","","","Cep","","303.119","5.270","0.429","331.252033","62.785671","K4III","K","1","","" }
{ "30000","30073","44112","2273","","7    Mon","","7","","","Mon","","872.076","5.270","-1.866","94.928327","-7.822908","B2.5V","B","1","","" }
{ "32451","32537","49591","2518","","","","","","","Pup","","324.211","5.270","0.283","101.839171","-37.929698","B8/B9V","B","1","","" }
{ "36654","36760","60107","2886","","68    Gem","","68","","","Gem","","423.580","5.270","-0.298","113.402008","15.826662","A1Vn","A","1","","" }
{ "42010","42129","73390","3415","","","","","","","Car","","896.034","5.270","-1.924","128.814864","-58.224735","B3V+...","B","1","","" }
{ "48543","48682","85795","3917","","31    UMa","","31","","","UMa","","208.008","5.270","1.247","148.929182","49.819843","A3III","A","1","","" }
{ "49929","50070","88824","4017","","","","","","","Vel","","169.256","5.270","1.694","153.345243","-51.232971","A7V","A","1","","" }
{ "51168","51313","91056","4120","","","","","","","Car","","2651.678","5.270","-4.280","157.219115","-64.172278","K3Ib","K","1","","" }
{ "109347","109693","212710","8546","","","","","","","Cep","","256.614","5.270","0.791","333.292518","86.107955","B9.5Vn","B","1","","" }
{ "116591","116957","222643","8987","","","","","","","Aqr","","269.997","5.270","0.680","355.615928","-15.448033","K3III","K","1","","" }
{ "6985","6999","9057","430","","49    And","","49","","","And","","294.099","5.270","0.495","22.525427","47.007274","K0III","K","1","","" }
{ "9706","9727","12230","581","","47    Cas","","47","","","Cas","","108.142","5.270","2.667","31.279727","77.281341","F0Vn","F","1","","" }
{ "10296","10320","13709","652","Gl 89","Mu  For","Mu","","Mu","","For","","320.389","5.270","0.309","33.226954","-30.723825","A0V","A","1","","" }
{ "11710","11738","15694","737","GJ 9083","","","","","","Cet","","459.375","5.270","-0.474","37.875398","2.267182","K3III","K","1","","" }
{ "11729","11757","16522","776","","Mu  Hyi","Mu","","Mu","","Hyi","","283.861","5.270","0.572","37.917503","-79.109382","G4III","G","1","","" }
{ "15588","15627","20756","1005","","61Tau1Ari","Tau-1","61","Tau","1","Ari","","508.824","5.270","-0.696","50.306765","21.147086","B5IV","B","1","","" }
{ "20590","20641","27946","1388","","67Kap2Tau","Kap-2","67","Kap","2","Tau","","148.051","5.270","1.985","66.354209","22.199998","A7V","A","1","","" }
{ "57304","57477","102328","4521","","","","","","","UMa","","215.569","5.270","1.169","176.731735","55.628190","K3III","K","1","","" }
{ "61834","62027","110432","4830","","","","","","","Cru","","1217.001","5.270","-2.589","190.709479","-63.058624","B2pe","B","1","","" }
{ "65375","65581","116870","5064","","68    Vir","","68","","","Vir","","440.157","5.270","-0.381","201.679873","-12.707664","K5III","K","1","","" }
{ "72702","72929","131430","5548","","12    Lib","","12","","","Lib","","417.080","5.270","-0.264","223.583874","-24.642202","K2/K3III","K","1","","" }
{ "79815","80057","145388","6021","","Del2Aps","Del-2","","Del","2","Aps","","613.076","5.270","-1.100","245.111928","-78.667496","K3III","K","1","","" }
{ "57198","57371","102232","4519","","","","","","","Cen","","691.009","5.280","-1.350","176.433247","-45.690134","B6III","B","1","","" }
{ "58412","58587","104337","4590","","","","","","","Crv","","3166.567","5.280","-4.656","180.213167","-19.658982","B2IV","B","1","","" }
{ "59938","60122","107274","4690","","3    CVn","","3","","","CVn","","589.794","5.280","-1.006","184.952978","48.984148","M0III","M","1","","" }
{ "74368","74596","135502","5676","","48Chi Boo","Chi","48","Chi","","Boo","","252.443","5.280","0.836","228.621518","29.164295","A2V","A","1","","" }
{ "80402","80645","147787","6109","","Iot TrA","Iot","","Iot","","TrA","","126.564","5.280","2.336","246.988770","-64.057942","F4IV","F","1","","" }
{ "81189","81437","150449","6199","","","","","","","Dra","","270.894","5.280","0.683","249.501928","56.015540","K1III","K","1","","" }
{ "110271","110618","211998","8515","Gl 855.1A","Nu  Ind","Nu","","Nu","","Ind","","93.615","5.280","2.990","336.146460","-72.255412","A3V: + F9V","A","1","","Gl 855.1" }
{ "116851","117218","223024","9002","","107    Aqr","","107","","","Aqr","","238.767","5.280","0.957","356.503829","-18.678340","F2:V+...","F","1","","" }
{ "85130","85389","157661","6477","","","","","","","Ara","","635.782","5.280","-1.169","261.716582","-45.843030","B8V","B","1","","" }
{ "90733","91014","171034","6960","","","","","","","Sgr","","1320.471","5.280","-2.757","278.490692","-33.016560","B2III/IV","B","1","","" }
{ "94539","94834","180868","7315","","25Ome1Aql","Ome-1","25","Ome","1","Aql","","414.957","5.280","-0.243","289.454160","11.595422","F0IV","F","1","","" }
{ "96650","96957","186203","7497","","47Chi Aql","Chi","47","Chi","","Aql","","853.812","5.280","-1.810","295.641705","11.826583","F3V:+...","F","1","","" }
{ "97792","98103","188728","7610","","61Phi Aql","Phi","61","Phi","","Aql","","219.486","5.280","1.140","299.059381","11.423721","A1IV","A","1","","" }
{ "99873","100195","193150","7761","","7Sig Cap","Sig","7","Sig","","Cap","","1120.812","5.280","-2.401","304.848349","-19.118533","K2III","K","1","","" }
{ "28976","29048","42042","2168","","19    Lep","","19","","","Lep","","838.448","5.280","-1.770","91.923490","-19.165866","M1III","M","1","","" }
{ "30880","30953","46273","2384","","","","","","","Pup","","167.776","5.280","1.723","97.454531","-50.239085","F2V","F","1","","" }
{ "32406","32492","49229","2504","","11    CMa","","11","","","CMa","","795.503","5.280","-1.656","101.712883","-14.425971","B8/B9III","B","1","","" }
{ "32834","32921","49908","2529","","36    Gem","","36","","","Gem","","491.199","5.280","-0.609","102.887692","21.761148","A2V","A","1","","" }
{ "40888","41003","71576","3334","","Eta Vol","Eta","","Eta","","Vol","","381.024","5.280","-0.058","125.518766","-73.399985","A0/A1IV/V","A","1","","" }
{ "43023","43142","74988","3486","","","","","","","Hya","","401.670","5.280","-0.172","131.812440","-1.897033","A3V","A","1","","" }
{ "45324","45455","79354","3660","","17    UMa","","17","","","UMa","","719.992","5.280","-1.440","138.957475","56.741406","K5III","K","1","","" }
{ "45450","45581","80951","3720","","","","","","","Car","","350.706","5.280","0.122","139.355007","-74.894313","A1V","A","1","","" }
{ "47167","47300","83287","3829","","42    Lyn","","42","","","Lyn","","122.569","5.280","2.405","144.590743","40.239793","F0V","F","1","","" }
{ "7635","7650","9774","456","","40    Cas","","40","","","Cas","","458.085","5.280","-0.458","24.628892","73.040040","G8II-IIIvar","G","1","","" }
{ "18405","18453","24546","1210","","43    Per","","43","","","Per","","122.110","5.280","2.413","59.152044","50.695381","F5IV","F","1","","" }
{ "18741","18788","25340","1244","","35    Eri","","35","","","Eri","","413.904","5.280","-0.237","60.383542","-1.549660","B5V","B","1","","" }
{ "21987","22040","30478","1530","","Kap Dor","Kap","","Kap","","Dor","","218.603","5.280","1.149","71.088068","-59.732733","A8/A9III/IV","A","1","","" }
{ "23816","23871","32977","1658","","106    Tau","","106","","","Tau","","189.516","5.280","1.459","76.951666","20.418379","A5V","A","1","","" }
{ "26395","26460","37495","1935","Gl 209.1","Nu 2Col","Nu-2","","Nu","2","Col","","133.071","5.280","2.227","84.435920","-28.689690","F5V","F","1","","" }
{ "27296","27364","38622","1993","","133    Tau","","133","","","Tau","","633.313","5.280","-1.161","86.928779","13.899599","B2IV-V","B","1","","" }
{ "812","814","636","30","","Gam3Oct","Gam-3","","Gam","3","Oct","","254.611","5.290","0.828","2.509402","-82.224047","K1/K2III","K","1","","" }
{ "981","983","787","37","","","","","","","Cet","","622.436","5.290","-1.113","3.041601","-17.938278","K4III","K","1","","" }
{ "8194","8209","10830","514","","Eps Scl","Eps","","Eps","","Scl","","91.694","5.290","3.045","26.411448","-25.052610","F2IV","F","1","","" }
{ "9293","9312","11946","567","","","","","","","Cas","","245.600","5.290","0.906","29.908376","64.621602","A0Vn","A","1","","" }
{ "10766","10793","14252","675","","10    Tri","","10","","","Tri","","376.624","5.290","-0.022","34.737470","28.642674","A2V","A","1","","" }
{ "10995","11021","14652","689","","69    Cet","","69","","","Cet","","1076.424","5.290","-2.303","35.485947","0.395675","M2III","M","1","","" }
{ "11459","11486","15257","717","","12    Tri","","12","","","Tri","","162.509","5.290","1.803","37.041590","29.669330","F0III","F","1","","" }
{ "19669","19719","26690","1309","","46    Tau","","46","","","Tau","","118.516","5.290","2.488","63.387932","7.716045","F3V...","F","1","","" }
{ "20652","20704","27971","1390","","","","","","","Per","","253.227","5.290","0.840","66.526259","31.438911","K1III","K","1","","" }
{ "22234","22287","30121","1511","","4    Cam","","4","","","Cam","","172.114","5.290","1.678","72.001032","56.757183","A3m","A","1","","" }
{ "24813","24873","34863","1757","","7Nu  Lep","Nu","7","Nu","","Lep","","333.493","5.290","0.242","79.995932","-12.315585","B7/B8V","B","1","","" }
{ "26803","26868","38170","1973","","","","","","","Col","","428.589","5.290","-0.303","85.563308","-34.667812","B9/B9.5V","B","1","","" }
{ "89161","89439","167264","6822","","15    Sgr","","15","","","Sgr","","326156.378","5.290","-14.710","273.803779","-20.728270","B0/1Ia/ab","B","1","","" }
{ "92534","92824","164461","6721","","Chi Oct","Chi","","Chi","","Oct","","256.816","5.290","0.809","283.698445","-87.605843","K3III","K","1","","" }
{ "105557","105898","204411","8216","","","","","","","Cyg","","411.294","5.290","-0.214","321.715015","48.835168","A6pe...","A","1","","" }
{ "105985","106327","204783","8229","","Xi  Gru","Xi","","Xi","","Gru","","465.938","5.290","-0.485","323.024468","-41.179310","K0III","K","1","","" }
{ "107129","107472","207089","8321","","12    Peg","","12","","","Peg","","1393.831","5.290","-2.864","326.518182","22.948880","K0Ib","K","1","","" }
{ "108645","108991","209625","8410","","32    Aqr","","32","","","Aqr","","222.177","5.290","1.124","331.197592","-0.906343","A5m","A","1","","" }
{ "60715","60904","108662","4752","","17    Com","","17","","","Com","","237.723","5.290","0.977","187.227941","25.912852","A0p","A","1","","" }
{ "69390","69612","124679","5330","","15    Boo","","15","","","Boo","","264.952","5.290","0.741","213.711872","10.100610","K1III","K","1","","" }
{ "27878","27947","40292","2094","","","","","","","Pic","","113.170","5.290","2.588","88.708743","-52.635481","F0Ve...","F","1","","" }
{ "33229","33316","51283","2595","","","","","","","CMa","","326156.378","5.290","-14.710","103.945533","-22.941439","B2/B3III","B","1","","" }
{ "35330","35427","57146","2786","","","","","","","CMa","","1254.448","5.290","-2.635","109.713644","-26.585854","G2II","G","1","","" }
{ "48253","48390","85376","3900","","22    Leo","","22","","","Leo","","135.222","5.290","2.202","147.970987","24.395369","A5IV","A","1","","" }
{ "32325","32411","49048","2498","","","","","","","CMa","","424.130","5.300","-0.270","101.497478","-14.796127","A1IV/V","A","1","","" }
{ "34709","34802","55719","2727","","","","","","","Pup","","411.294","5.300","-0.204","108.065875","-40.498808","A3p...","A","1","","" }
{ "37597","37704","62285","2983","","76    Gem","","76","","","Gem","","634.545","5.300","-1.145","116.028815","25.784159","K5III","K","1","","" }
{ "38852","38962","65345","3110","","14    CMi","","14","","","CMi","","241.597","5.300","0.952","119.586053","2.224767","K0III","K","1","","" }
{ "39667","39780","67228","3176","","10Mu 2Cnc","Mu-2","10","Mu","2","Cnc","","75.956","5.300","3.464","121.941061","21.581816","G2IV","G","1","","" }
{ "43184","43305","75333","3500","","14    Hya","","14","","","Hya","","450.492","5.300","-0.401","132.340526","-3.443023","B9MNp...","B","1","","" }
{ "45158","45290","79158","3652","","36    Lyn","","36","","","Lyn","","581.384","5.300","-0.955","138.450889","43.217825","B8IIIMNp","B","1","","" }
{ "47345","47479","84121","3863","","","","","","","Car","","236.688","5.300","0.996","145.177404","-57.983553","A3IV","A","1","","" }
{ "49668","49809","88215","3991","","","","","","","Hya","","90.473","5.300","3.085","152.524534","-12.815923","F2/F3IV/V","F","1","","" }
{ "84825","85084","157236","6459","","43    Oph","","43","","","Oph","","819.488","5.300","-1.701","260.839963","-28.142831","K4/K5III","K","1","","" }
{ "89495","89773","168532","6860","","105    Her","","105","","","Her","","973.601","5.300","-2.075","274.794497","24.446059","K4II SB","K","1","","" }
{ "96501","96808","185644","7476","","54    Sgr","","54","","","Sgr","","240.528","5.300","0.961","295.180757","-16.293268","K1III","K","1","","" }
{ "98110","98421","189118","7624","","The2Sgr","The-2","","The","2","Sgr","","158.175","5.300","1.871","299.963930","-34.697799","A4/A5IV","A","1","","" }
{ "99631","99951","192944","7753","","24    Vul","","24","","","Vul","","437.794","5.300","-0.339","304.196187","24.671102","G8III","G","1","","" }
{ "100215","100541","194013","7794","","","","","","","Aql","","246.528","5.300","0.908","305.794557","5.342987","G8III-IV","G","1","","" }
{ "103179","103511","199697","8032","","33    Vul","","33","","","Vul","","452.367","5.300","-0.410","314.568130","22.325908","K4III","K","1","","" }
{ "103237","103569","199766","8034","","1Eps Equ","Eps","1","Eps","","Equ","","176.396","5.300","1.635","314.768653","4.293481","F5III...","F","1","","" }
{ "104028","104365","201184","8087","GJ 9720","25Chi Cap","Chi","25","Chi","","Cap","","179.800","5.300","1.593","317.140099","-21.193669","A0V","A","1","","" }
{ "105601","105942","204403","8215","","70    Cyg","","70","","","Cyg","","1304.626","5.300","-2.710","321.839023","37.116798","B3V","B","1","","" }
{ "106808","107151","206487","8289","","7    Peg","","7","","","Peg","","729.656","5.300","-1.448","325.564381","5.680137","M2III","M","1","","" }
{ "3224","3231","3817","175","","32    And","","32","","","And","","354.903","5.300","0.117","10.279946","39.458664","G8III","G","1","","" }
{ "12193","12225","16555","778","","Eta Hor","Eta","","Eta","","Hor","","148.591","5.300","2.007","39.351374","-52.543086","A6V","A","1","","" }
{ "12456","12489","16628","782","","33    Ari","","33","","","Ari","","231.481","5.300","1.045","40.171129","27.060943","A3V","A","1","","" }
{ "16458","16499","21770","1069","","36    Per","","36","","","Per","","118.473","5.300","2.499","53.109472","46.056862","F4IIIvar","F","1","","" }
{ "21861","21914","30185","1516","","Lam Pic","Lam","","Lam","","Pic","","374.462","5.300","0.000","70.693482","-50.481334","K0/K1III","K","1","","" }
{ "21875","21928","29722","1494","","59    Per","","59","","","Per","","241.240","5.300","0.955","70.726330","43.365138","A1Vn","A","1","","" }
{ "23412","23467","33285","1677","","Bet Men","Bet","","Bet","","Men","","793.568","5.300","-1.631","75.679178","-71.314300","G8III","G","1","","" }
{ "113839","114200","218452","8804","","4    And","","4","","","And","","348.830","5.300","0.154","346.913627","46.387231","K5III","K","1","","" }
{ "116454","116820","222433","8975","","Mu  Scl","Mu","","Mu","","Scl","","291.732","5.300","0.542","355.158994","-32.073125","K0III","K","1","","" }
{ "117362","117730","223781","9039","","82    Peg","","82","","","Peg","","182.721","5.300","1.558","358.154603","10.947320","A4Vn","A","1","","" }
{ "55867","56034","99787","4422","","57    UMa","","57","","","UMa","","212.757","5.300","1.228","172.267213","39.336974","A2V","A","1","","" }
{ "56828","56997","101501","4496","Gl 434","61    UMa","","61","","","UMa","","31.349","5.310","5.396","175.262571","34.201635","G8Vvar","G","1","","" }
{ "57389","57562","102510","4528","","4    Vir","","4","","","Vir","","192.992","5.310","1.449","176.978753","8.245895","A1","A","1","","" }
{ "59472","59654","106321","4652","","","","","","","Cen","","571.202","5.310","-0.907","183.511276","-45.723919","K3III","K","1","","" }
{ "64372","64577","114946","4995","","55    Vir","","55","","","Vir","","127.107","5.310","2.356","198.545414","-19.930947","G8III/IV","G","1","","" }
{ "80699","80945","148688","6142","","","","","","","Sco","","2717.970","5.310","-4.294","247.924038","-41.817145","B1Ia","B","1","","" }
{ "10342","10366","13530","645","","","","","","","And","","211.928","5.310","1.246","33.400926","51.065818","G8III:var","G","1","","" }
{ "10793","10819","14212","670","","62    And","","62","","","And","","245.785","5.310","0.924","34.820052","47.379973","A1V","A","1","","" }
{ "27177","27243","38871","2008","","","","","","","Pic","","469.290","5.310","-0.480","86.614044","-46.597180","K0/K1II","K","1","","" }
{ "37594","37701","61931","2969","","","","","","","Lyn","","739.584","5.310","-1.468","116.017426","50.433794","A0IIIn","A","1","","" }
{ "43548","43671","76360","3551","","","","","","","Vel","","252.053","5.310","0.870","133.460822","-47.520778","Am","A","1","","" }
{ "45413","45544","80170","3694","","","","","","","Vel","","345.139","5.310","0.187","139.237839","-39.401539","K2III","K","1","","" }
{ "54853","55016","97907","4365","","73    Leo","","73","","","Leo","","386.441","5.310","-0.058","168.966249","13.307578","K3III","K","1","","" }
{ "85407","85667","158614","6516","Gl 678A","","","","","","Oph","","53.302","5.310","4.243","262.599157","-1.062922","G8IV-V","G","1","","Gl 678" }
{ "93855","94150","177389","7221","","","","","","","Pav","","121.928","5.310","2.447","287.469636","-68.424448","G8/K0III/IV","G","1","","" }
{ "104637","104974","202369","8128","","29    Cap","","29","","","Cap","","611.926","5.310","-1.056","318.936842","-15.171500","M2III","M","1","","" }
{ "110303","110649","212330","8531","Gl 857","","","","","","Tuc","","67.069","5.310","3.745","336.234575","-57.797415","F9V","F","1","","" }
{ "112421","112781","215573","8663","","Xi  Oct","Xi","","Xi","","Oct","","492.683","5.320","-0.576","342.594824","-80.123845","B6IV","B","1","","" }
{ "38038","38146","63660","3043","","","","","","","Pup","","281.412","5.320","0.640","117.256985","-24.912208","G2","G","1","","" }
{ "41143","41260","71176","3315","","","","","","","Pup","","467.943","5.320","-0.464","126.265587","-24.046212","K4/K5III","K","1","","" }
{ "52757","52911","93702","4227","","53    Leo","","53","","","Leo","","380.579","5.320","-0.015","162.314292","10.545202","A2V","A","1","","" }
{ "56940","57111","101673","4504","","3    Dra","","3","","","Dra","","601.764","5.320","-1.010","175.618340","66.744906","K3III","K","1","","" }
{ "60264","60449","107832","4712","","","","","","","Cen","","444.355","5.320","-0.352","185.897606","-35.412677","B8/B9V","B","1","","" }
{ "65274","65479","116457","5048","","","","","","","Cen","","127.854","5.320","2.354","201.308524","-64.485144","F2III","F","1","","" }
{ "72263","72489","130559","5523","","7Mu  Lib","Mu","7","Mu","","Lib","","237.897","5.320","1.005","222.329385","-14.149022","Ap","A","1","","" }
{ "72822","73049","131625","5558","","","","","","","Cen","","253.818","5.320","0.865","223.936274","-33.855785","A0V","A","1","","" }
{ "74421","74649","135482","5675","","3    Ser","","3","","","Ser","","373.177","5.320","0.028","228.797304","4.939362","K0III","K","1","","" }
{ "79966","80208","147152","6083","","","","","","","Nor","","462.633","5.320","-0.439","245.616662","-49.572354","B6IV","B","1","","" }
{ "5506","5518","6829","336","","31    Cas","","31","","","Cas","","276.873","5.320","0.676","17.663692","68.778621","A0Vnn","A","1","","" }
{ "14134","14168","18953","917","","9Rho2Eri","Rho-2","9","Rho","2","Eri","","264.737","5.320","0.773","45.676144","-7.685472","K0II-III","K","1","","" }
{ "15731","15770","20809","1011","","","","","","","Per","","541.788","5.320","-0.782","50.804952","49.213269","B5V","B","1","","" }
{ "18910","18957","25558","1253","","40    Tau","","40","","","Tau","","640.779","5.320","-1.146","60.935852","5.435624","B3V","B","1","","" }
{ "21462","21515","29335","1469","","","","","","","Tau","","851.583","5.320","-1.764","69.306972","0.998314","B7V","B","1","","" }
{ "26061","26126","36777","1872","","38    Ori","","38","","","Ori","","275.936","5.320","0.683","83.569887","3.766895","A2V","A","1","","" }
{ "83919","84177","155644","6393","","37    Oph","","37","","","Oph","","1090.824","5.320","-2.302","258.115872","10.585168","M2III","M","1","","" }
{ "97438","97749","187474","7552","","","","","","","Sgr","","301.438","5.320","0.491","297.960838","-39.874367","A0p","A","1","","" }
{ "98313","98624","188887","7612","","Mu 2Pav","Mu-2","","Mu","2","Pav","","236.345","5.320","1.019","300.468443","-66.943966","K2IVCN...","K","1","","" }
{ "99143","99461","191408","7703","Gl 783A","","","","","","Sgr","","19.618","5.320","6.424","302.799478","-36.101212","K2V","K","1","","Gl 783" }
{ "103550","103882","200163","8048","","Zet Mic","Zet","","Zet","","Mic","","115.372","5.320","2.577","315.741493","-38.631447","F3V","F","1","","" }
{ "89795","90074","168733","6870","","","","","","","Sgr","","556.581","5.330","-0.831","275.721154","-36.669556","B7Ib/II","B","1","","" }
{ "92831","93124","176155","7165","","","","","","","Aql","","1545.765","5.330","-3.049","284.561447","17.360912","F8Ib","F","1","","" }
{ "97112","97421","186543","7510","","Nu  Tel","Nu","","Nu","","Tel","","161.624","5.330","1.855","297.004814","-56.362611","A9Vn","A","1","","" }
{ "98127","98438","189577","7645","","13    Sge","","13","","","Sge","","1019.239","5.330","-2.144","300.013784","17.516511","M4IIIa","M","1","","" }
{ "64618","64823","115478","5013","","","","","","","Vir","","324.534","5.330","0.341","199.315117","13.675751","K3III","K","1","","" }
{ "109440","109786","210960","8480","","41    Aqr","","41","","","Aqr","","233.469","5.330","1.056","333.575129","-21.074566","K1III","K","1","","" }
{ "115899","116264","221615","8940","","71    Peg","","71","","","Peg","","520.186","5.330","-0.684","353.367055","22.498775","M5IIIa","M","1","","" }
{ "39622","39734","67456","3183","","","","","","","Pup","","1545.765","5.330","-3.049","121.825167","-20.554342","A3Ib/II","A","1","","" }
{ "40701","40817","71046","3301","","Kap1Vol","Kap-1","","Kap","1","Vol","","434.875","5.330","-0.295","124.954106","-71.514906","B9III/IV","B","1","","" }
{ "41498","41616","72108","3358","","","","","","","Vel","","2131.741","5.330","-3.747","127.269807","-47.928923","B2IV","B","1","","" }
{ "41704","41822","72094","3357","","31The Cnc","The","31","The","","Cnc","","414.957","5.330","-0.193","127.898883","18.094420","K5III","K","1","","" }
{ "41790","41909","72292","3366","","33Eta Cnc","Eta","33","Eta","","Cnc","","298.405","5.330","0.523","128.177078","20.441162","K3III","K","1","","" }
{ "52526","52678","93540","4219","","","","","","","Car","","476.141","5.330","-0.492","161.569038","-64.514559","B7:V","B","1","","" }
{ "5121","5131","6456","310","","74Psi1Psc","Psi-1","74","Psi","1","Psc","","275.005","5.330","0.700","16.420639","21.473181","A1Vn","A","1","","" }
{ "20112","20161","27588","1364","","","","","","","Hor","","252.053","5.330","0.890","64.819508","-44.267919","K2III","K","1","","" }
{ "22677","22730","31139","1562","","5    Ori","","5","","","Ori","","590.863","5.330","-0.960","73.344886","2.508225","M1III","M","1","","" }
{ "22781","22834","31296","1571","","","","","","","Ori","","481.767","5.330","-0.517","73.699088","7.779097","K1III","K","1","","" }
{ "23824","23879","33054","1664","","14    Ori","","14","","","Ori","","210.831","5.330","1.277","76.970390","8.498429","Am","A","1","","" }
{ "9420","9440","12438","594","","Pi  For","Pi","","Pi","","For","","294.365","5.340","0.563","30.311387","-30.001830","G8III","G","1","","" }
{ "13456","13490","17904","855","","20    Per","","20","","","Per","","230.499","5.340","1.094","43.427525","38.337488","F4Vvar","F","1","","" }
{ "17521","17563","23466","1153","","29    Tau","","29","","","Tau","","533.807","5.340","-0.730","56.418510","6.049991","B3V","B","1","","" }
{ "20136","20186","27309","1341","","56    Tau","","56","","","Tau","","326.156","5.340","0.340","64.902935","21.773491","A0p Si","A","1","","" }
{ "24757","24817","34658","1746","","21    Ori","","21","","","Ori","","202.080","5.340","1.380","79.796746","2.595806","F5IIvar","F","1","","" }
{ "25915","25980","36591","1861","","","","","","","Ori","","1560.557","5.340","-3.059","83.172305","-1.591831","B1IV","B","1","","" }
{ "25936","26001","37297","1917","","","","","","","Dor","","231.645","5.340","1.083","83.248100","-64.227517","G8/K0III","G","1","","" }
{ "109308","109654","210889","8475","","","","","","","Peg","","258.035","5.340","0.849","333.199259","34.604592","K2III","K","1","","" }
{ "109654","110000","211361","8496","","42    Aqr","","42","","","Aqr","","586.612","5.340","-0.935","334.200185","-12.831436","K1III","K","1","","" }
{ "112967","113327","217050","8731","","","","","","","Lac","","821.553","5.340","-1.666","344.268747","48.684068","B4IIIpe","B","1","","" }
{ "82336","82587","152598","6279","","53    Her","","53","","","Her","","95.200","5.340","3.014","253.241946","31.701674","F0V","F","1","","" }
{ "95986","96288","184875","7444","","","","","","","Cyg","","576.248","5.340","-0.896","293.671911","42.412509","A2V","A","1","","" }
{ "102796","103127","198716","7987","","","","","","","Mic","","400.192","5.340","-0.104","313.417408","-39.809865","K2III","K","1","","" }
{ "107445","107788","207652","8344","","13    Peg","","13","","","Peg","","109.010","5.340","2.720","327.536238","17.285851","F2III-IV","F","1","","" }
{ "58709","58884","104878","4604","","","","","","","Mus","","347.344","5.340","0.203","181.162183","-68.328912","A0V","A","1","","" }
{ "59005","59184","105416","4620","","","","","","","Cen","","599.552","5.340","-0.982","182.061326","-48.692487","A1V","A","1","","" }
{ "62918","63117","112244","4908","","","","","","","Cru","","326156.378","5.340","-14.660","193.988069","-56.835806","O9Ib","O","1","","" }
{ "70246","70469","126218","5390","","","","","","","Lib","","458.729","5.340","-0.401","216.202622","-24.806310","K0III","K","1","","" }
{ "76630","76866","140160","5843","","20Chi Ser","Chi","20","Chi","","Ser","","219.782","5.340","1.197","235.447562","12.847528","A0p Sr","A","1","","" }
{ "29631","29704","43153","2223","","72    Ori","","72","","","Ori","","522.686","5.340","-0.684","93.854699","16.143175","B7V","B","1","","" }
{ "30174","30247","43905","2264","","45    Aur","","45","","","Aur","","193.106","5.340","1.478","95.442171","53.452179","F5III...","F","1","","" }
{ "31709","31789","47100","2420","","52Psi3Aur","Psi-3","52","Psi","3","Aur","","1370.405","5.340","-2.777","99.704924","39.902559","B8III","B","1","","" }
{ "32403","32489","48432","2477","","13    Lyn","","13","","","Lyn","","210.968","5.340","1.286","101.706261","57.169176","K0III","K","1","","" }
{ "32961","33048","49618","2520","","14    Lyn","","14","","","Lyn","","486.800","5.340","-0.530","103.271064","59.448543","G4III...","G","1","","" }
{ "36790","36896","60318","2896","","","","","","","Gem","","372.325","5.340","0.053","113.786676","30.960924","K0III","K","1","","" }
{ "40101","40215","67447","3182","","","","","","","UMa","","751.512","5.340","-1.473","123.203283","68.474072","G8II","G","1","","" }
{ "43291","43414","76143","3537","","","","","","","Vol","","169.344","5.340","1.763","132.644728","-66.792981","F5IV","F","1","","" }
{ "45975","46107","82554","3795","","Iot Cha","Iot","","Iot","","Cha","","189.626","5.340","1.518","141.040202","-80.786876","F3/F5IV","F","1","","" }
{ "50743","50888","90132","4086","","","","","","","Ant","","135.222","5.340","2.252","155.872171","-38.009839","A8V","A","1","","" }
{ "28874","28946","41357","2143","","40    Aur","","40","","","Aur","","340.811","5.350","0.255","91.646233","38.482644","A4m","A","1","","" }
{ "29173","29246","41597","2152","","37    Cam","","37","","","Cam","","381.024","5.350","0.012","92.495854","58.935694","G8III","G","1","","" }
{ "35859","35957","58535","2834","","","","","","","CMa","","660.235","5.350","-1.181","111.182732","-31.808905","K1III","K","1","","" }
{ "36336","36439","58855","2849","GJ 9234","22    Lyn","","22","","","Lyn","","66.010","5.350","3.819","112.483004","49.672463","F6V","F","1","","" }
{ "42485","42604","73593","3422","","34    Lyn","","34","","","Lyn","","180.297","5.350","1.637","130.254433","45.834010","G0IV","G","1","","" }
{ "46678","46811","82694","3807","","","","","","","Vel","","423.580","5.350","-0.218","143.080318","-40.649335","G8III","G","1","","" }
{ "82550","82802","152879","6293","","54    Her","","54","","","Her","","391.544","5.350","-0.047","253.842378","18.433213","K4III","K","1","","" }
{ "85919","86182","160290","6574","","82    Her","","82","","","Her","","353.366","5.350","0.176","264.156851","48.585634","K1III","K","1","","" }
{ "92661","92953","175219","7122","","","","","","","CrA","","295.431","5.350","0.565","284.070653","-42.710676","G6III-IV","G","1","","" }
{ "94090","94385","179406","7279","","20    Aql","","20","","","Aql","","979.449","5.350","-2.038","288.169629","-7.939518","B3V","B","1","","" }
{ "3941","3951","4775","233","","","","","","","Cas","","639.522","5.350","-1.112","12.681623","64.247549","A4V comp SB","A","1","","" }
{ "4361","4371","5437","267","","22Phi3Cet","Phi-3","22","Phi","3","Cet","","550.940","5.350","-0.788","14.006210","-11.266526","K4III","K","1","","" }
{ "6692","6706","8723","413","","93Rho Psc","Rho","93","Rho","","Psc","","82.238","5.350","3.342","21.563596","19.172346","F2V:var","F","1","","" }
{ "22104","22157","30210","1519","","","","","","","Ori","","235.322","5.350","1.059","71.507250","11.705591","Am...","A","1","","" }
{ "109927","110273","211838","8512","","46Rho Aqr","Rho","46","Rho","","Aqr","","881.504","5.350","-1.809","335.049651","-7.821102","B8IIIMNp...","B","1","","" }
{ "114991","115355","220222","8887","","64    Peg","","64","","","Peg","","829.914","5.350","-1.678","350.478883","31.812465","B6III","B","1","","" }
{ "116343","116709","222304","8967","","18    And","","18","","","And","","421.391","5.350","-0.206","354.784740","50.471733","B9V","B","1","","" }
{ "66724","66936","119425","5159","","84    Vir","","84","","","Vir","","238.418","5.350","1.030","205.765469","3.537903","K1III","K","1","","" }
{ "74890","75119","136514","5710","","6    Ser","","6","","","Ser","","239.293","5.350","1.022","230.258316","0.715337","K3III","K","1","","" }
{ "77671","77907","142780","5932","","2    Her","","2","","","Her","","653.620","5.350","-1.159","238.657740","43.138567","M3III","M","1","","" }
{ "78810","79050","144690","6001","","","","","","","Sco","","478.937","5.350","-0.484","242.031579","-26.326679","M2III","M","1","","" }
{ "80538","80782","148379","6131","","","","","","","Nor","","1822.103","5.350","-3.386","247.426368","-46.243229","B1.5Iap","B","1","","" }
{ "58334","58510","104181","4585","","7    Vir","","7","","","Vir","","305.390","5.360","0.503","179.987135","3.655197","A1V","A","1","","" }
{ "65096","65301","116292","5044","","63    Vir","","63","","","Vir","","305.963","5.360","0.499","200.754650","-17.735274","K0III","K","1","","" }
{ "71905","72131","129422","5482","","","","","","","Cir","","158.021","5.360","1.934","221.322032","-62.875648","A7Vn","A","1","","" }
{ "75209","75439","136933","5719","","Ups Lup","Ups","","Ups","","Lup","","406.679","5.360","-0.119","231.187556","-39.710268","Ap...","A","1","","" }
{ "76392","76628","139446","5814","","41    Lib","","41","","","Lib","","311.218","5.360","0.462","234.727318","-19.301892","G8III/IV","G","1","","" }
{ "3132","3138","3690","167","","55    Psc","","55","","","Psc","","414.430","5.360","-0.160","9.981544","21.438495","F3V...","F","1","","" }
{ "3624","3632","4408","211","","57    Psc","","57","","","Psc","","776.563","5.360","-1.524","11.637328","15.475504","M4III","M","1","","" }
{ "5257","5268","6793","332","","Iot Tuc","Iot","","Iot","","Tuc","","304.250","5.360","0.511","16.827565","-61.775289","G5III","G","1","","" }
{ "11231","11258","15233","714","","Lam Hor","Lam","","Lam","","Hor","","161.065","5.360","1.892","36.224804","-60.311947","F2III","F","1","","" }
{ "11763","11791","15779","739","","75    Cet","","75","","","Cet","","265.600","5.360","0.806","38.039254","-1.034896","G3III:","G","1","","" }
{ "18946","18993","25621","1257","","","","","","","Tau","","115.453","5.360","2.615","61.041145","2.826947","F6IV","F","1","","" }
{ "21677","21730","29316","1466","","2    Cam","","2","","","Cam","","145.023","5.360","2.120","69.991894","53.473021","A8V","A","1","","" }
{ "25998","26063","36695","1868","","","","","","","Ori","","1469.173","5.360","-2.908","83.381027","-1.156073","B1V","B","1","","" }
{ "27589","27658","39291","2031","","55    Ori","","55","","","Ori","","1048.734","5.360","-2.176","87.841599","-7.518003","B2IV-V","B","1","","" }
{ "29417","29490","41927","2165","","36    Cam","","36","","","Cam","","715.255","5.360","-1.345","93.212737","65.718422","K2II-III","K","1","","" }
{ "29922","29996","43993","2267","","","","","","","Mon","","469.966","5.360","-0.433","94.710762","-9.390018","K1III","K","1","","" }
{ "34893","34987","55751","2729","","","","","","","CMi","","741.264","5.360","-1.423","108.583594","3.111414","K0III","K","1","","" }
{ "34990","35083","56342","2756","","","","","","","CMa","","628.432","5.360","-1.064","108.837803","-30.686447","B2V","B","1","","" }
{ "37745","37853","63077","3018","Gl 288A","","","","","","Pup","","49.605","5.360","4.449","116.396038","-34.172363","G0V","G","1","","Gl 288" }
{ "38731","38846","65460","3114","","","","","","","Pup","","1568.059","5.360","-3.050","119.240846","-43.500411","B2.5V","B","1","","" }
{ "39994","40107","68312","3212","","","","","","","Hya","","290.692","5.360","0.610","122.887519","-7.772539","G8III","G","1","","" }
{ "45279","45410","79554","3669","","82Pi 2Cnc","Pi-2","82","Pi","2","Cnc","","607.367","5.360","-0.990","138.807723","14.941507","K1III","K","1","","" }
{ "47588","47723","84194","3866","","16Psi Leo","Psi","16","Psi","","Leo","","610.780","5.360","-1.002","145.932935","14.021692","M2III","M","1","","" }
{ "52254","52405","92964","4198","","","","","","","Car","","326156.378","5.360","-14.640","160.669042","-59.215759","B2.5Ia","B","1","","" }
{ "52486","52638","93152","4203","","42    LMi","","42","","","LMi","","382.364","5.360","0.015","161.466236","30.682313","A1Vn","A","1","","" }
{ "84563","84821","157087","6455","","","","","","","Her","","446.790","5.360","-0.323","260.040976","25.537603","A3III","A","1","","" }
{ "89327","89605","167128","6819","","","","","","","Tel","","760.271","5.360","-1.478","274.281393","-56.023351","B3IIIpe","B","1","","" }
{ "92697","92989","175362","7129","","","","","","","CrA","","430.285","5.360","-0.242","284.168732","-37.343241","B3V","B","1","","" }
{ "102268","102599","199437","8016","","","","","","","Dra","","398.724","5.360","-0.076","311.889750","80.552262","K1III","K","1","","" }
{ "109763","110109","211415","8501","Gl 853A","","","","","","Gru","","44.962","5.360","4.663","334.564329","-53.627073","G1V","G","1","","Gl 853" }
{ "116523","116889","222547","8980","","103    Aqr","","103","","","Aqr","","756.743","5.360","-1.468","355.393708","-18.027077","K4/K5III","K","1","","" }
{ "109952","110298","211924","8513","","30    Peg","","30","","","Peg","","1274.048","5.370","-2.589","335.114903","5.789498","B5IV","B","1","","" }
{ "113597","113957","217902","8774","","Kap Gru","Kap","","Kap","","Gru","","364.014","5.370","0.132","346.165017","-53.964905","K5III","K","1","","" }
{ "28877","28949","41692","2154","","","","","","","Mon","","1058.949","5.370","-2.187","91.661401","-4.193836","B5IV","B","1","","" }
{ "29657","29730","42633","2201","","40    Cam","","40","","","Cam","","491.940","5.370","-0.522","93.918851","59.998975","K3III","K","1","","" }
{ "30492","30565","46116","2377","","Pi 2Dor","Pi-2","","Pi","2","Dor","","269.997","5.370","0.780","96.369347","-69.690299","G8III","G","1","","" }
{ "35750","35848","58215","2822","","","","","","","CMa","","616.553","5.370","-1.013","110.870793","-27.834294","K4III","K","1","","" }
{ "35888","35987","58187","2820","","1    CMi","","1","","","CMi","","316.350","5.370","0.436","111.242415","11.669524","A5IV","A","1","","" }
{ "39007","39117","64307","3075","","","","","","","Cam","","879.128","5.370","-1.783","120.048963","73.917919","K3III","K","1","","" }
{ "48941","49081","86728","3951","Gl 376","20    LMi","","20","","","LMi","","49.075","5.370","4.483","150.252965","31.923672","G1V","G","1","","" }
{ "54586","54746","97495","4350","","","","","","","Cen","","164.393","5.370","1.858","168.137865","-49.100996","A2III","A","1","","" }
{ "60789","60978","108844","4760","","74    UMa","","74","","","UMa","","273.163","5.370","0.755","187.489000","58.405742","A5e...","A","1","","" }
{ "63230","63432","113092","4928","","9    Dra","","9","","","Dra","","624.821","5.370","-1.042","194.979976","66.597272","K2III","K","1","","" }
{ "72996","73223","131109","5540","","","","","","","Aps","","374.462","5.370","0.070","224.471322","-76.662655","K4III","K","1","","" }
{ "79562","79804","147232","6086","","","","","","","Dra","","739.584","5.370","-1.408","244.313927","59.755023","M4IIIa","M","1","","" }
{ "80095","80337","147513","6094","Gl 620.1A","","","","","","Sco","","41.676","5.370","4.838","246.005323","-39.192980","G3/G5V","G","1","","Gl 620.1" }
{ "8215","8230","10824","513","","","","","","","Cet","","550.940","5.370","-0.768","26.496918","-5.733299","K4III","K","1","","" }
{ "23428","23482","32743","1649","Gl 187","Eta1Pic","Eta-1","","Eta","1","Pic","","85.047","5.370","3.289","75.702915","-49.151407","F2V","F","1","","" }
{ "26182","26248","36819","1875","","121    Tau","","121","","","Tau","","552.807","5.370","-0.776","83.863038","24.039589","B2.5IV","B","1","","" }
{ "88107","88380","164584","6724","","7    Sgr","","7","","","Sgr","","1079.988","5.370","-2.230","270.712909","-24.282468","F2/F3II/III","F","1","","" }
{ "90481","90763","170479","6936","","","","","","","Sgr","","289.917","5.370","0.626","277.770184","-32.989114","A5V","A","1","","" }
{ "91824","92111","173460","7046","","28    Sgr","","28","","","Sgr","","683.766","5.370","-1.237","281.585863","-22.392176","K5III","K","1","","" }
{ "91825","92112","175286","7124","","50    Dra","","50","","","Dra","","279.963","5.370","0.702","281.592736","75.433964","A1Vn","A","1","","" }
{ "109058","109404","210271","8444","","","","","","","PsA","","206.690","5.370","1.361","332.482097","-34.014967","A5IV","A","1","","" }
{ "109246","109592","210939","8479","","","","","","","Cep","","365.646","5.370","0.122","333.008395","60.759095","K1III","K","1","","" }
{ "84604","84862","157214","6458","Gl 672","72    Her","","72","","","Her","","46.727","5.380","4.599","260.164802","32.467743","G0V","G","1","","" }
{ "90362","90642","170474","6935","","60    Ser","","60","","","Ser","","229.687","5.380","1.141","277.420749","-1.985308","K0III","K","1","","" }
{ "90731","91013","171779","6983","","","","","","","Dra","","638.271","5.380","-1.078","278.486236","52.353517","K0III","K","1","","" }
{ "90935","91217","171802","6985","","","","","","","Oph","","125.638","5.380","2.452","279.115968","9.122491","F5III","F","1","","" }
{ "91915","92202","173819","7066","","","","","","","Sct","","326156.378","5.380","-14.620","281.870626","-5.705147","K0Ibpvar","K","1","","" }
{ "94417","94712","179886","7289","","","","","","","Tel","","545.412","5.380","-0.736","289.090594","-45.466033","K3III","K","1","","" }
{ "97339","97650","187532","7553","","51    Aql","","51","","","Aql","","90.902","5.380","3.154","297.694933","-10.763512","F0V","F","1","","" }
{ "98715","99031","191026","7689","","27    Cyg","","27","","","Cyg","","78.103","5.380","3.484","301.590826","35.972468","K0IV","K","1","","" }
{ "100639","100965","196787","7901","","75    Dra","","75","","","Dra","","455.526","5.380","-0.345","307.060308","81.422708","G9III","G","1","","" }
{ "103400","103732","200310","8053","","60    Cyg","","60","","","Cyg","","1524.095","5.380","-2.968","315.295525","46.155773","B1V","B","1","","" }
{ "105324","105665","203638","8183","","33    Cap","","33","","","Cap","","239.293","5.380","1.052","321.039973","-20.851869","K0III","K","1","","" }
{ "109176","109521","210715","8463","","","","","","","Lac","","183.131","5.380","1.633","332.791041","50.823393","A5V","A","1","","" }
{ "60194","60379","107696","4706","","","","","","","Cru","","361.592","5.380","0.156","185.706043","-57.676132","B9V","B","1","","" }
{ "60593","60781","108396","4739","","","","","","","Cru","","443.147","5.380","-0.286","186.870281","-58.991756","M4/M5III","M","1","","" }
{ "62377","62572","112028","4893","","","","","","","Cam","","583.464","5.380","-0.883","192.307433","83.412901","A1IIIsh","A","1","","" }
{ "66637","66849","118978","5140","","","","","","","Cen","","782.150","5.380","-1.519","205.504599","-58.787078","B9IV","B","1","","" }
{ "70707","70931","126983","5413","","","","","","","Lup","","203.339","5.380","1.406","217.587346","-49.519018","A1V","A","1","","" }
{ "72868","73095","131562","5556","","","","","","","Lup","","200.588","5.380","1.436","224.071838","-52.809548","A2III","A","1","","" }
{ "74949","75178","136849","5718","","50    Boo","","50","","","Boo","","261.973","5.380","0.856","230.452419","32.933695","B9Vn","B","1","","" }
{ "77622","77858","142165","5906","","","","","","","Sco","","420.305","5.380","-0.171","238.474647","-24.533157","B5V","B","1","","" }
{ "35490","35589","57917","2815","","","","","","","Car","","480.348","5.380","-0.461","110.161709","-52.085924","B9V","B","1","","" }
{ "38609","38722","64648","3086","","85    Gem","","85","","","Gem","","374.462","5.380","0.080","118.916232","19.883970","A0Vs","A","1","","" }
{ "45440","45571","80671","3712","Gl 340.1A","","","","","","Car","","106.448","5.380","2.811","139.322236","-68.689642","F4V","F","1","","Gl 340.1" }
{ "46272","46404","81809","3750","Gl 344A","","","","","","Hya","","99.196","5.380","2.965","141.944922","-6.071187","G2V","G","1","","Gl 344" }
{ "1641","1645","1635","80","","41    Psc","","41","","","Psc","","407.695","5.380","-0.105","5.149423","8.190271","K3III","K","1","","" }
{ "1955","1960","2011","93","","12    Cas","","12","","","Cas","","701.412","5.380","-1.283","6.197902","61.831057","B9III","B","1","","" }
{ "2562","2568","2910","131","","52    Psc","","52","","","Psc","","260.925","5.380","0.865","8.147836","20.294316","K0III","K","1","","" }
{ "3323","3330","4089","187","","Rho Tuc","Rho","","Rho","","Tuc","","133.835","5.380","2.314","10.618036","-65.468030","F6V","F","1","","" }
{ "12055","12086","16058","750","","15    Tri","","15","","","Tri","","632.086","5.380","-1.057","38.945037","34.687558","M3III","M","1","","" }
{ "18813","18859","25457","1249","Gl 159","","","","","","Eri","","61.423","5.380","4.005","60.653104","-0.268923","F5V","F","1","","" }
{ "20214","20264","27616","1367","","","","","","","Eri","","475.447","5.380","-0.438","65.162552","-20.639622","A0V","A","1","","" }
{ "20380","20430","27638","1369","","59Chi Tau","Chi","59","Chi","","Tau","","291.211","5.380","0.626","65.645593","25.629314","B9V","B","1","","" }
{ "21617","21670","29499","1480","","","","","","","Tau","","160.352","5.380","1.922","69.775652","7.870976","A5m","A","1","","" }
{ "24739","24799","34452","1732","","","","","","","Aur","","413.379","5.380","-0.135","79.750113","33.748394","A0p...","A","1","","" }
{ "4880","4890","6245","299","","","","","","","Phe","","238.418","5.390","1.070","15.704960","-46.397311","G8III","G","1","","" }
{ "13169","13202","17729","845","","Gam2For","Gam-2","","Gam","2","For","","458.729","5.390","-0.351","42.475742","-27.941981","A1V","A","1","","" }
{ "18350","18396","24504","1207","","","","","","","Per","","729.656","5.390","-1.358","58.992367","47.871420","B6V","B","1","","" }
{ "19464","19513","26322","1287","","44    Tau","","44","","","Tau","","205.259","5.390","1.396","62.707762","26.480952","F2IV-V","F","1","","" }
{ "21991","22044","30034","1507","","","","","","","Ori","","149.476","5.390","2.084","71.107613","11.146137","F0V","F","1","","" }
{ "23167","23221","32008","1608","","63    Eri","","63","","","Eri","","176.015","5.390","1.729","74.960217","-10.263325","G4V","G","1","","" }
{ "55484","55650","99055","4400","","79    Leo","","79","","","Leo","","353.749","5.390","0.214","171.009696","1.407765","G8IIICN...","G","1","","" }
{ "56222","56391","100493","4453","","","","","","","Cen","","385.528","5.390","0.027","173.405062","-40.586637","A2IV/V","A","1","","" }
{ "71274","71500","128266","5450","","","","","","","Lup","","1364.671","5.390","-2.718","219.333986","-46.133439","K0III","K","1","","" }
{ "71392","71618","129002","5468","","33    Boo","","33","","","Boo","","185.950","5.390","1.610","219.709341","44.404500","A1V","A","1","","" }
{ "76991","77227","140873","5863","","25    Ser","","25","","","Ser","","449.871","5.390","-0.308","236.523488","-1.804193","B8III","B","1","","" }
{ "78223","78459","143761","5968","Gl 606.2","15Rho CrB","Rho","15","Rho","","CrB","","56.214","5.390","4.208","240.261184","33.303509","G2V","G","1","","" }
{ "78955","79195","145206","6016","","","","","","","Ser","","478.937","5.390","-0.444","242.460492","-3.466729","K4III","K","1","","" }
{ "114027","114389","218700","8821","","58    Peg","","58","","","Peg","","809.321","5.390","-1.583","347.506086","9.822082","B9III","B","1","","" }
{ "82512","82764","152815","6287","","","","","","","Her","","269.997","5.390","0.800","253.729867","20.958488","G8III","G","1","","" }
{ "84720","84979","156190","6411","","Iot Aps","Iot","","Iot","","Aps","","1320.471","5.390","-2.647","260.524491","-70.123208","B8/B9Vn...","B","1","","" }
{ "89573","89851","168415","6858","","","","","","","Ser","","521.017","5.390","-0.627","275.036632","-15.831697","K3III","K","1","","" }
{ "93006","93299","177003","7210","","","","","","","Dra","","671.104","5.390","-1.177","285.056979","50.533466","B2.5IV","B","1","","" }
{ "96000","96302","184759","7441","","9    Cyg","","9","","","Cyg","","558.487","5.390","-0.778","293.712197","29.462954","A0V+...","A","1","","" }
{ "97224","97534","186219","7498","","","","","","","Pav","","142.302","5.390","2.191","297.355403","-72.503378","A4III","A","1","","" }
{ "101156","101483","195943","7858","","3Eta Del","Eta","3","Eta","","Del","","236.174","5.390","1.091","308.487672","13.027255","A3IVs","A","1","","" }
{ "105625","105966","204414","8217","","35    Vul","","35","","","Vul","","190.290","5.390","1.560","321.916893","27.608593","A1V","A","1","","" }
{ "29777","29850","43525","2247","","75    Ori","","75","","","Ori","","225.402","5.390","1.192","94.277582","9.942390","A2V","A","1","","" }
{ "32408","32494","49689","2523","","","","","","","Car","","823.627","5.390","-1.622","101.719504","-51.265667","K1II/IIIp+G:","K","1","","" }
{ "32591","32677","49662","2522","","","","","","","CMa","","528.617","5.390","-0.659","102.240575","-15.144726","B7IV","B","1","","" }
{ "39427","39538","64486","3082","","","","","","","Cam","","322.927","5.390","0.412","121.196520","79.479612","A0p...","A","1","","" }
{ "46602","46735","82198","3769","","8    LMi","","8","","","LMi","","479.642","5.390","-0.447","142.885072","35.103273","M1III","M","1","","" }
{ "31499","31579","46687","2405","","","","","","","Aur","","326156.378","5.400","-14.600","99.136819","38.445500","C5II","C","1","","" }
{ "35697","35795","58155","2819","","","","","","","CMa","","1325.839","5.400","-2.645","110.752908","-31.923781","B3V","B","1","","" }
{ "43597","43721","75959","3532","","57    Cnc","","57","","","Cnc","","461.324","5.400","-0.353","133.561364","30.579115","G7III","G","1","","" }
{ "46322","46454","81858","3754","","2Ome Leo","Ome","2","Ome","","Leo","","108.178","5.400","2.796","142.114168","9.056778","F9V","F","1","","" }
{ "46339","46471","81688","3743","","","","","","","UMa","Intercrus","279.963","5.400","0.732","142.166629","45.601483","K0III-IV","K","1","","" }
{ "46945","47080","82885","3815","Gl 356A","11    LMi","","11","","","LMi","","37.080","5.400","5.121","143.915006","35.810133","G8IV-V","G","1","","Gl 356" }
{ "54688","54849","97585","4356","","69    Leo","","69","","","Leo","","527.761","5.400","-0.645","168.439800","-0.069502","A0V","A","1","","" }
{ "119106","","","","Gl 635B","","","","","","Her","","35.211","5.400","5.234","250.322356","31.601207","K0 V","K","2","81444","Gl 635" }
{ "119397","","","","Gl 822B","","","","","","Equ","","60.277","5.400","4.066","318.620872","10.006094","F7 V","F","2","104520","Gl 822" }
{ "4904","4914","6203","296","","25    Cet","","25","","","Cet","","333.493","5.400","0.352","15.760568","-4.836601","K0III-IV","K","1","","" }
{ "12620","12653","17051","810","Gl 108","Iot Hor","Iot","","Iot","","Hor","","55.993","5.400","4.226","40.638971","-50.800294","G3IV","G","1","","" }
{ "17812","17854","23277","1138","","","","","","","Cam","","346.975","5.400","0.266","57.307137","70.871050","A2m","A","1","","" }
{ "20326","20376","27245","1335","","","","","","","Cam","","446.178","5.400","-0.280","65.448401","60.735625","M0III","M","1","","" }
{ "20984","21036","28556","1430","","83    Tau","","83","","","Tau","","147.449","5.400","2.124","67.655673","13.724402","F0V","F","1","","" }
{ "25435","25499","35671","1808","","115    Tau","","115","","","Tau","","549.085","5.400","-0.731","81.792055","17.962216","B5V","B","1","","" }
{ "26471","26536","37269","1914","","26    Aur","","26","","","Aur","","566.244","5.400","-0.798","84.658697","30.492412","A2V + GIII","A","1","","" }
{ "65522","65728","117376","5085","","","","","","","UMa","","232.803","5.400","1.132","202.113052","59.945787","A1Vn","A","1","","" }
{ "70380","70602","126661","5405","","22    Boo","","22","","","Boo","","290.692","5.400","0.650","216.614028","19.226900","F0m","F","1","","" }
{ "75782","76013","137387","5730","","Kap1Aps","Kap-1","","Kap","1","Aps","","1240.138","5.400","-2.500","232.878420","-73.389591","B1npe","B","1","","" }
{ "79973","80214","147767","6108","","21Nu 2CrB","Nu-2","21","Nu","2","CrB","","594.092","5.400","-0.902","245.621747","33.703478","K5III","K","1","","" }
{ "80157","80399","147722","6105","","","","","","","Sco","","107.927","5.400","2.801","246.165694","-29.704663","G0","G","1","","" }
{ "91702","91989","172991","7031","","","","","","","CrA","","1304.626","5.400","-2.610","281.238145","-39.686188","K1/K2III+..","K","1","","" }
{ "93233","93526","176984","7209","","14    Aql","","14","","","Aql","","499.474","5.400","-0.525","285.727077","-3.698987","A1V","A","1","","" }
{ "93418","93713","178207","7251","","51    Dra","","51","","","Dra","","362.396","5.400","0.171","286.229863","53.396654","A0Vn","A","1","","" }
{ "93422","93717","177463","7225","","15    Aql","","15","","","Aql","","289.402","5.400","0.660","286.240298","-4.031420","K1III","K","1","","" }
{ "98646","98962","191277","7701","","66    Dra","","66","","","Dra","","171.842","5.400","1.791","301.386655","61.995420","K3III","K","1","","" }
{ "104805","105143","202671","8137","","30    Cap","","30","","","Cap","","533.807","5.400","-0.670","319.488690","-17.985138","B5II/III","B","1","","" }
{ "83581","83838","155103","6377","","","","","","","Her","","176.970","5.410","1.738","257.008611","35.935174","A5m","A","1","","" }
{ "85278","85537","158352","6507","","","","","","","Oph","","194.488","5.410","1.533","262.206895","0.330625","A8V","A","1","","" }
{ "89494","89772","168387","6857","","","","","","","Oph","","152.624","5.410","2.059","274.789736","7.259767","K2III","K","1","","" }
{ "89745","90023","169110","6882","","","","","","","Her","","651.011","5.410","-1.091","275.536249","23.285176","K5III","K","1","","" }
{ "90953","91235","172044","6997","","","","","","","Lyr","","504.106","5.410","-0.535","279.155602","33.469036","B8II-IIIp..","B","1","","" }
{ "96386","96693","185872","7483","","14    Cyg","","14","","","Cyg","","652.313","5.410","-1.095","294.860334","42.818278","B9III","B","1","","" }
{ "97335","97646","186957","7531","","","","","","","Pav","","277.108","5.410","0.764","297.686626","-59.193667","A0IV","A","1","","" }
{ "101846","102177","197511","7929","","51    Cyg","","51","","","Cyg","","1274.048","5.410","-2.549","310.552614","50.340030","B2V","B","1","","" }
{ "102442","102773","197635","7934","","Sig Pav","Sig","","Sig","","Pav","","301.997","5.410","0.577","312.325989","-68.776521","K0III","K","1","","" }
{ "104412","104750","201901","8110","","","","","","","Mic","","366.880","5.410","0.155","318.322187","-27.619333","K3III","K","1","","" }
{ "928","930","720","34","","Kap2Scl","Kap-2","","Kap","2","Scl","","793.568","5.410","-1.521","2.893415","-27.799737","K2III","K","1","","" }
{ "3536","3544","4222","196","","","","","","","Cas","","322.289","5.410","0.436","11.321612","55.221396","A2Vs","A","1","","" }
{ "7436","7450","9856","459","","50    Cet","","50","","","Cet","","546.326","5.410","-0.710","23.995701","-15.400183","K1III","K","1","","" }
{ "32826","32912","51557","2602","","Iot Vol","Iot","","Iot","","Vol","","563.310","5.410","-0.777","102.862422","-70.963411","B7IV","B","1","","" }
{ "34211","34301","53974","2678","","","","","","","CMa","","3048.190","5.410","-4.443","106.669861","-11.294014","B0.5IV","B","1","","" }
{ "35757","35855","58286","2823","","","","","","","CMa","","1109.376","5.410","-2.248","110.882901","-32.202067","B2/B3II/III","B","1","","" }
{ "36260","36363","59635","2875","","","","","","","Pup","","538.212","5.410","-0.678","112.273745","-38.812065","B3V","B","1","","" }
{ "37343","37450","62226","2981","","","","","","","Pup","","593.012","5.410","-0.888","115.315900","-38.533532","B3V","B","1","","" }
{ "61428","61621","109799","4803","","","","","","","Hya","","111.966","5.410","2.732","189.426137","-27.138888","F0V","F","1","","" }
{ "67076","67288","120052","5181","","87    Vir","","87","","","Vir","","676.673","5.410","-1.175","206.855792","-17.859839","M2III","M","1","","" }
{ "69766","69989","125451","5365","GJ 3841","18    Boo","","18","","","Boo","","85.114","5.410","3.327","214.817827","13.004299","F5IV","F","1","","" }
{ "76824","77060","140417","5848","","44Eta Lib","Eta","44","Eta","","Lib","","149.203","5.410","2.108","236.018334","-15.672834","A6IV","A","1","","" }
{ "77623","77859","142184","5907","","","","","","","Sco","","426.906","5.410","-0.175","238.482769","-23.978094","B2V","B","1","","" }
{ "80449","80693","148513","6136","","","","","","","Oph","","407.186","5.410","-0.072","247.141589","0.665002","K4IIIp","K","1","","" }
{ "57339","57512","102461","4526","","","","","","","Cen","","702.923","5.420","-1.247","176.829809","-57.696498","K5III","K","1","","" }
{ "61116","61309","109317","4783","","","","","","","CVn","","291.471","5.420","0.664","188.412154","33.247584","K0IIICN...","K","1","","" }
{ "62030","62223","110914","4846","","","","","","","CVn","La Superba","1045.373","5.420","-2.109","191.282614","45.440256","C7Iab","C","1","","" }
{ "70572","70794","126927","5410","","106    Vir","","106","","","Vir","","624.821","5.420","-0.992","217.173843","-6.900536","K5III","K","1","","" }
{ "80148","80390","147628","6100","","","","","","","Sco","","420.847","5.420","-0.133","246.132321","-37.566044","B8V","B","1","","" }
{ "759","761","493","24","","Kap1Scl","Kap-1","","Kap","1","Scl","","252.638","5.420","0.975","2.337763","-27.987928","F3V","F","1","","" }
{ "2234","2240","2490","109","","","","","","","Phe","","375.756","5.420","0.113","7.110403","-39.915002","M0III","M","1","","" }
{ "3713","3721","4382","208","","23    Cas","","23","","","Cas","","771.055","5.420","-1.448","11.941785","74.847573","B8III","B","1","","" }
{ "5939","5951","7672","373","","39    Cet","","39","","","Cet","","262.817","5.420","0.889","19.151200","-2.500368","G5III-IVe","G","1","","" }
{ "6578","6592","8651","408","","","","","","","Phe","","235.662","5.420","1.126","21.169930","-41.492549","K0III","K","1","","" }
{ "8795","8814","11428","543","","55    And","","55","","","And","","630.863","5.420","-1.013","28.322276","40.729790","K1III","K","1","","" }
{ "9568","9589","12573","607","","60    Cet","","60","","","Cet","","280.927","5.420","0.744","30.798541","0.128507","A5III","A","1","","" }
{ "11020","11046","14690","691","","70    Cet","","70","","","Cet","","261.343","5.420","0.901","35.551652","-0.884852","F0Vn","F","1","","" }
{ "20725","20776","26836","1317","","","","","","","Cep","","967.823","5.420","-1.942","66.762092","80.824159","G6III:","G","1","","" }
{ "91211","91494","171967","6991","","","","","","","CrA","","639.522","5.420","-1.042","279.896526","-43.185878","M2III","M","1","","" }
{ "101472","101800","196544","7883","","5Iot Del","Iot","5","Iot","","Del","","188.967","5.420","1.605","309.454664","11.377676","A2V","A","1","","" }
{ "105631","105972","204770","8227","","7    Cep","","7","","","Cep","","805.324","5.420","-1.543","321.942297","66.809096","B7V","B","1","","" }
{ "113912","114273","218527","8807","","5    Psc","","5","","","Psc","","265.816","5.420","0.864","347.170505","2.127883","G8IV","G","1","","" }
{ "31222","31299","46815","2411","","","","","","","Col","","391.544","5.420","0.023","98.456176","-36.232029","K3III","K","1","","" }
{ "32226","32311","48450","2480","","28    Gem","","28","","","Gem","","476.141","5.420","-0.402","101.189415","28.970932","K4III","K","1","","" }
{ "36672","36778","60606","2911","","","","","","","Pup","","1186.023","5.420","-2.383","113.462685","-36.338392","B2Vne","B","1","","" }
{ "41699","41817","72310","3367","","","","","","","Pyx","","345.139","5.420","0.297","127.878852","-19.577462","B9.5IV/V","B","1","","" }
{ "44690","44818","78235","3621","","72Tau Cnc","Tau","72","Tau","","Cnc","","273.621","5.420","0.801","137.000222","29.654235","G8III","G","1","","" }
{ "50191","50333","89056","4035","","37    Leo","","37","","","Leo","","585.559","5.420","-0.851","154.169741","13.728334","M1III","M","1","","" }
{ "31048","31121","46229","2381","","","","","","","Mon","","698.408","5.430","-1.223","97.958592","-8.158235","K2III","K","1","","" }
{ "42963","43082","75149","3494","","","","","","","Vel","","326156.378","5.430","-14.570","131.627284","-45.912504","B3Ia","B","1","","" }
{ "43783","43908","79837","3678","","Zet Oct","Zet","","Zet","","Oct","","162.267","5.430","1.946","134.174231","-85.663152","F0III","F","1","","" }
{ "47820","47956","85396","3902","","Nu  Cha","Nu","","Nu","","Cha","","184.373","5.430","1.669","146.585281","-76.776120","G8III","G","1","","" }
{ "51437","51585","91232","4127","","46    Leo","","46","","","Leo","","693.950","5.430","-1.210","158.049060","14.137270","M2III","M","1","","" }
{ "54016","54173","96146","4313","","","","","","","Ant","","517.709","5.430","-0.573","166.225820","-35.804678","A0V","A","1","","" }
{ "54318","54477","96819","4334","","","","","","","Hya","","181.500","5.430","1.703","167.183354","-28.080670","A1V","A","1","","" }
{ "83705","83962","155078","6375","","","","","","","Oph","","134.775","5.430","2.349","257.449790","-10.523301","F5IV","F","1","","" }
{ "87457","87728","164613","6725","","34Psi2Dra","Psi-2","34","Psi","2","Dra","","1055.522","5.430","-2.120","268.796427","72.005127","F2.5II-III","F","1","","" }
{ "90955","91237","171834","6987","","","","","","","Oph","","107.892","5.430","2.832","279.162811","6.671805","F3V","F","1","","" }
{ "92324","92614","174933","7113","","112    Her","","112","","","Her","","405.667","5.430","-0.044","283.068451","21.425142","B9p...","B","1","","" }
{ "108316","108661","209014","8386","","12Eta PsA","Eta","12","Eta","","PsA","","817.435","5.430","-1.565","330.209265","-28.453736","B8/B9V+...","B","1","","" }
{ "109126","109472","210424","8452","","38    Aqr","","38","","","Aqr","","449.871","5.430","-0.268","332.656174","-11.564939","B5III","B","1","","" }
{ "62228","62423","111335","4863","","7    Dra","","7","","","Dra","Tianyi","741.264","5.430","-1.353","191.893093","66.790304","K5III","K","1","","" }
{ "74712","74941","135591","5680","","","","","","","Cir","","326156.378","5.430","-14.570","229.704770","-60.496334","O7Iab:","O","1","","" }
{ "76383","76618","139129","5798","","","","","","","Nor","","408.717","5.430","-0.060","234.706186","-52.372695","B9V","B","1","","" }
{ "77776","78012","142908","5936","GJ 9531","12Lam CrB","Lam","12","Lam","","CrB","","135.560","5.430","2.336","238.948259","37.946958","F0IV","F","1","","" }
{ "78010","78246","142990","5942","","","","","","","Sco","","555.633","5.430","-0.727","239.645281","-24.831488","B5V","B","1","","" }
{ "79147","79387","145607","6033","","16    Sco","","16","","","Sco","","252.443","5.430","0.986","243.030480","-8.547576","A4V","A","1","","" }
{ "9307","9326","12255","583","","57    Cet","","57","","","Cet","","588.730","5.430","-0.852","29.942495","-20.824539","M0/M1III","M","1","","" }
{ "9353","9372","12292","587","","","","","","","Cet","","476.141","5.430","-0.392","30.111760","-8.523873","M3III","M","1","","" }
{ "11003","11029","14691","692","","","","","","","Cet","","96.725","5.430","3.069","35.506375","-10.777534","F0V","F","1","","" }
{ "12735","12768","16901","800","","14    Per","","14","","","Per","","982.399","5.430","-1.964","41.021497","44.297040","G0Ib","G","1","","" }
{ "23928","23983","33254","1672","","16    Ori","","16","","","Ori","","178.423","5.430","1.740","77.331839","9.829579","A2m","A","1","","" }
{ "25705","25769","35583","1802","","17    Cam","","17","","","Cam","","939.932","5.430","-1.868","82.542526","63.067220","M1III","M","1","","" }
{ "112372","112731","216174","8688","","","","","","","Lac","","397.267","5.430","0.002","342.442821","55.902777","K1III","K","1","","" }
{ "112474","112832","216149","8685","","","","","","","Gru","","772.882","5.430","-1.443","342.758984","-39.156834","K3III","K","1","","" }
{ "113161","113521","217264","8742","","2    Psc","","2","","","Psc","","298.952","5.430","0.619","344.864396","0.962927","K1III:","K","1","","" }
{ "117080","117447","223385","9018","","6    Cas","","6","","","Cas","","326156.378","5.430","-14.570","357.209055","62.214516","A3Ia comp","A","1","","" }
{ "113636","113996","218060","8782","","83    Aqr","","83","","","Aqr","","209.478","5.440","1.401","346.290778","-7.693801","F2V","F","1","","" }
{ "114789","115152","219945","8874","","11    And","","11","","","And","","286.102","5.440","0.725","349.874172","48.625322","K0III","K","1","","" }
{ "58204","58379","103961","4576","","","","","","","Cru","","762.048","5.440","-1.403","179.563477","-56.317310","B8III","B","1","","" }
{ "63891","64094","113904","4952","","The Mus","The","","The","","Mus","","326156.378","5.440","-14.560","197.029816","-65.306023","WC6 + O9.5I","W","1","","" }
{ "76163","76397","138816","5784","","","","","","","Lup","","544.501","5.440","-0.673","234.050459","-44.396823","M0III","M","1","","" }
{ "78653","78893","145454","6025","","","","","","","Dra","","253.818","5.440","0.985","241.582129","67.810134","A0Vn","A","1","","" }
{ "79721","79963","146667","6071","","Lam Nor","Lam","","Lam","","Nor","","348.830","5.440","0.294","244.823518","-42.673965","A3Vn","A","1","","" }
{ "29663","29736","43247","2229","","73    Ori","","73","","","Ori","","1164.844","5.440","-2.324","93.937351","12.551067","B9II-III","B","1","","" }
{ "32353","32439","46588","2401","Gl 240.1","","","","","","Cam","","58.294","5.440","4.179","101.560049","79.564811","F8V","F","1","","" }
{ "33097","33184","50747","2572","","","","","","","Mon","","551.872","5.440","-0.702","103.602771","-1.126996","A4IV","A","1","","" }
{ "34631","34724","55057","2707","","21    Mon","","21","","","Mon","","284.356","5.440","0.738","107.848398","-0.301928","F2V","F","1","","" }
{ "38386","38497","64572","3085","","","","","","","Pup","","742.953","5.440","-1.348","118.264616","-36.363769","K1IIICN...","K","1","","" }
{ "43726","43851","76351","3550","","60    Cnc","","60","","","Cnc","","695.429","5.440","-1.204","133.981451","11.626023","K5III","K","1","","" }
{ "43807","43932","76398","3555","","59Sig2Cnc","Sig-2","59","Sig","2","Cnc","","194.256","5.440","1.565","134.235846","32.910430","A7IV","A","1","","" }
{ "47071","47204","83520","3840","","","","","","","Vel","","233.302","5.440","1.168","144.302759","-53.668508","A2/A3V","A","1","","" }
{ "52585","52737","93397","4214","","","","","","","Hya","","205.907","5.440","1.439","161.716898","-17.296874","A3V","A","1","","" }
{ "87575","87847","163532","6686","","","","","","","Oph","","400.192","5.440","-0.004","269.198937","-4.081823","G9III","G","1","","" }
{ "90135","90414","169405","6894","","","","","","","Tel","","497.949","5.440","-0.479","276.725046","-48.117243","K0/K1III+..","K","1","","" }
{ "99312","99631","192107","7720","","66    Aql","","66","","","Aql","","707.497","5.440","-1.241","303.307841","-1.009339","K5III","K","1","","" }
{ "100917","101243","195774","7851","","46Ome2Cyg","Ome-2","46","Ome","2","Cyg","","399.212","5.440","0.001","307.828389","49.220297","M2III","M","1","","" }
{ "4500","4510","5575","274","","68    Psc","","68","","","Psc","","648.422","5.440","-1.052","14.458964","28.992217","G6III","G","1","","" }
{ "13748","13782","18454","883","","4    Eri","","4","","","Eri","","155.535","5.440","2.048","44.349002","-23.862164","A5IV/V","A","1","","" }
{ "15508","15547","19978","961","","","","","","","Cep","","264.737","5.440","0.893","50.081743","77.734740","A6V","A","1","","" }
{ "17734","17776","23753","1172","","","","","","","Tau","","385.984","5.440","0.074","57.086731","23.421250","B8V","B","1","","" }
{ "19434","19483","26409","1290","","37    Eri","","37","","","Eri","","351.462","5.440","0.278","62.593841","-6.923852","G8III","G","1","","" }
{ "24197","24254","32650","1643","","","","","","","Cam","","377.933","5.440","0.120","78.093550","73.946674","B9p Si","B","1","","" }
{ "24769","24829","35072","1767","","Zet Pic","Zet","","Zet","","Pic","","116.484","5.440","2.676","79.842196","-50.605967","F7III-IV","F","1","","" }
{ "26584","26649","37811","1958","","","","","","","Col","","421.936","5.440","-0.119","84.957676","-32.629216","G6/G8III","G","1","","" }
{ "2936","2942","3421","157","","","","","","","And","","847.160","5.450","-1.623","9.338419","35.399501","G5III","G","1","","" }
{ "3077","3083","3574","164","","","","","","","Cas","","2090.746","5.450","-3.584","9.791215","49.354589","K5III","K","1","","" }
{ "4283","4293","5457","270","","Lam2Tuc","Lam-2","","Lam","2","Tuc","","221.875","5.450","1.287","13.751267","-69.527084","G7III","G","1","","" }
{ "12300","12332","16432","773","","32Nu  Ari","Nu","32","Nu","","Ari","","336.938","5.450","0.379","39.704145","21.961408","A7V","A","1","","" }
{ "14340","14376","19134","927","","52    Ari","","52","","","Ari","","539.102","5.450","-0.641","46.361207","25.255174","B7Vn","B","1","","" }
{ "17447","17489","23288","1140","","16    Tau","","16","","","Tau","Celaeno","377.059","5.450","0.135","56.200892","24.289470","B7IV","B","1","","" }
{ "18928","18975","25570","1254","","","","","","","Tau","","113.683","5.450","2.739","60.985847","8.197269","F2V","F","1","","" }
{ "19350","19398","26326","1288","","","","","","","Eri","","652.313","5.450","-1.055","62.324315","-16.385875","B5IV","B","1","","" }
{ "19755","19805","27304","1340","","","","","","","Ret","","262.817","5.450","0.919","63.702281","-62.191811","K0III","K","1","","" }
{ "21682","21735","29589","1484","","93    Tau","","93","","","Tau","","416.547","5.450","-0.081","70.014239","12.197609","B8IV","B","1","","" }
{ "25928","25993","36848","1877","","","","","","","Col","","172.296","5.450","1.836","83.214193","-38.513371","K2/K3III","K","1","","" }
{ "33297","33384","54239","2689","","The Men","The","","The","","Men","","352.221","5.450","0.283","104.143664","-79.420193","B9.5V","B","1","","" }
{ "33391","33478","51733","2607","","","","","","","CMa","","123.732","5.450","2.555","104.391303","-24.630841","F3V","F","1","","" }
{ "36512","36616","59686","2877","","","","","","","Gem","","316.043","5.450","0.518","112.951649","17.086046","K2III","K","1","","" }
{ "41207","41323","71459","3326","","","","","","","Pup","","718.406","5.450","-1.265","126.466306","-42.153072","B3V","B","1","","" }
{ "42168","42286","73887","3432","","","","","","","Car","","337.986","5.450","0.373","129.328500","-62.853465","K0III","K","1","","" }
{ "42341","42459","74071","3440","","","","","","","Vel","","444.961","5.450","-0.224","129.849387","-53.439767","B5V","B","1","","" }
{ "44277","44405","77350","3595","","69Nu  Cnc","Nu","69","Nu","","Cnc","","392.486","5.450","0.048","135.684440","24.452915","A0III","A","1","","" }
{ "46461","46594","82419","3784","","","","","","","Vel","","432.568","5.450","-0.163","142.521320","-51.517164","B8V","B","1","","" }
{ "53119","53273","94402","4253","","","","","","","Leo","","312.710","5.450","0.541","163.432134","-2.129205","G8III","G","1","","" }
{ "109443","109789","210934","8478","","16Lam PsA","Lam","16","Lam","","PsA","","501.008","5.450","-0.482","333.578123","-27.766908","B7V","B","1","","" }
{ "110709","111056","213798","8591","","29Rho2Cep","Rho-2","29","Rho","2","Cep","","245.046","5.450","1.071","337.470709","78.824285","A3V","A","1","","" }
{ "112997","113357","217014","8729","Gl 882","51    Peg","","51","","","Peg","Helvetios","50.906","5.450","4.483","344.366550","20.768832","G5V","G","1","","" }
{ "59212","59394","105850","4635","","3    Crv","","3","","","Crv","","191.857","5.450","1.602","182.766012","-23.602423","A1V","A","1","","" }
{ "60667","60855","108541","4748","","","","","","","Cen","","436.622","5.450","-0.183","187.093621","-39.041172","B8/B9V","B","1","","" }
{ "62831","63031","111482","4870","","Iot Oct","Iot","","Iot","","Oct","","351.841","5.450","0.285","193.743279","-85.123369","K0III","K","1","","" }
{ "73396","73624","132955","5595","","","","","","","Lup","","387.820","5.450","0.074","225.746992","-32.643294","B3V","B","1","","" }
{ "74078","74305","134270","5637","","","","","","","Lup","","2159.976","5.450","-3.655","227.816592","-55.346032","G2Ib/II","G","1","","" }
{ "77666","77902","142574","5924","","","","","","","Ser","","510.417","5.450","-0.522","238.644229","20.310968","M0III","M","1","","" }
{ "79512","79754","146003","6055","","","","","","","Nor","","774.718","5.450","-1.429","244.180311","-53.811109","M2IV","M","1","","" }
{ "89228","89507","167096","6818","","","","","","","CrA","","300.328","5.450","0.629","273.972641","-44.206461","G8/K0III","G","1","","" }
{ "95206","95503","182416","7363","","49Chi3Sgr","Chi-3","49","Chi","3","Sgr","","499.474","5.450","-0.475","291.373586","-23.962457","K3III","K","1","","" }
{ "96252","96556","185124","7460","","42    Aql","","42","","","Aql","","104.873","5.450","2.914","294.447156","-4.647640","F3IV","F","1","","" }
{ "104046","104382","177482","7228","","Sig Oct","Sig","","Sig","","Oct","Polaris Australis","280.927","5.450","0.774","317.191788","-88.956499","F0III","F","1","","" }
{ "107949","108294","208321","8366","","","","","","","Gru","","335.897","5.450","0.386","329.094890","-37.253655","A3V","A","1","","" }
{ "82424","82676","152234","6260","","","","","","","Sco","","2588.543","5.460","-4.038","253.507654","-41.806389","B0.5Ia","B","1","","" }
{ "92021","92308","173715","7062","","Eta1CrA","Eta-1","","Eta","1","CrA","","336.244","5.460","0.394","282.210353","-43.680047","A2Vn","A","1","","" }
{ "92541","92831","175740","7146","","","","","","","Lyr","","267.341","5.460","0.892","283.717405","41.602723","G8III","G","1","","" }
{ "94532","94827","180968","7318","","2    Vul","","2","","","Vul","","1217.001","5.460","-2.399","289.431817","23.025540","B0.5IV","B","1","","" }
{ "94778","95073","181440","7336","","27    Aql","","27","","","Aql","","437.794","5.460","-0.179","290.148693","-0.892161","B9III","B","1","","" }
{ "95566","95865","183275","7398","GJ 9657A","","","","","","Sgr","","233.972","5.460","1.181","292.467438","-26.985615","K1/K2III","K","1","","GJ 9657" }
{ "96232","96536","184985","7454","Gl 764.2","","","","","","Sgr","","99.681","5.460","3.034","294.393399","-14.301801","F7V","F","1","","" }
{ "97883","98194","189178","7628","","","","","","","Cyg","","1109.376","5.460","-2.198","299.307777","40.367824","B5V","B","1","","" }
{ "106445","106787","205852","8267","","5    Peg","","5","","","Peg","","321.020","5.460","0.494","324.439276","19.318607","F1IV","F","1","","" }
{ "4278","4288","5286","258","","36    And","","36","","","And","","123.873","5.460","2.562","13.742083","23.628335","K1IV","K","1","","" }
{ "18961","19009","25555","1252","","36    Tau","","36","","","Tau","","1132.487","5.460","-2.243","61.090306","24.105993","G0III...","G","1","","" }
{ "20106","20156","27084","1330","","","","","","","Per","","242.857","5.460","1.100","64.805079","50.048695","A7V","A","1","","" }
{ "21632","21685","29613","1487","","","","","","","Eri","","196.125","5.460","1.564","69.832119","-14.359192","K0III","K","1","","" }
{ "24842","24902","34557","1738","","","","","","","Aur","","277.108","5.460","0.814","80.061138","41.086212","A3V","A","1","","" }
{ "25704","25768","36553","1856","","","","","","","Pic","","143.935","5.460","2.236","82.539475","-47.077655","G3IV","G","1","","" }
{ "25796","25861","36351","1842","","33    Ori","","33","","","Ori","","1136.434","5.460","-2.251","82.810552","3.292133","B1.5V","B","1","","" }
{ "27130","27196","38104","1971","","27Omi Aur","Omi","27","Omi","","Aur","","413.379","5.460","-0.055","86.475176","49.826255","A0p...","A","1","","" }
{ "27497","27566","40953","2125","","Kap Men","Kap","","Kap","","Men","","285.102","5.460","0.752","87.569986","-79.361362","B9.5V","B","1","","" }
{ "28871","28943","41841","2163","","","","","","","Lep","","460.023","5.460","-0.287","91.633738","-23.110846","A2V","A","1","","" }
{ "34532","34624","55070","2708","","","","","","","CMa","","705.966","5.460","-1.217","107.580505","-27.491520","G8III","G","1","","" }
{ "34818","34912","54895","2703","","","","","","","Lyn","","723.185","5.460","-1.269","108.347492","51.428745","M3III","M","1","","" }
{ "35086","35180","56405","2758","GJ 9228","","","","","","CMa","","269.106","5.460","0.878","109.060644","-15.585689","A1V","A","1","","" }
{ "42518","42637","75416","3502","","Eta Cha","Eta","","Eta","","Cha","","309.740","5.460","0.572","130.331602","-78.963359","B9IV","B","1","","" }
{ "46226","46358","82350","3777","","","","","","","Car","","201.829","5.460","1.502","141.776826","-71.601895","K2III","K","1","","" }
{ "46608","46741","83095","3821","","","","","","","Car","","789.725","5.460","-1.460","142.901285","-73.080913","K4III","K","1","","" }
{ "52443","52595","93779","4231","","Del1Cha","Del-1","","Del","1","Cha","","348.458","5.460","0.316","161.318187","-80.469597","K0III","K","1","","" }
{ "56121","56290","100203","4439","Gl 431.1A","","","","","","UMa","","91.284","5.460","3.225","173.086453","61.082520","F6V","F","1","","Gl 431.1" }
{ "56532","56700","101067","4476","","","","","","","Cen","","353.366","5.460","0.286","174.391709","-47.747309","K2III","K","1","","" }
{ "61938","62131","110666","4839","","","","","","","Hya","","412.334","5.460","-0.049","191.002221","-28.323957","K3III","K","1","","" }
{ "62866","63066","112213","4906","","","","","","","Cen","","661.575","5.460","-1.076","193.830998","-42.915732","M0III","M","1","","" }
{ "66424","66634","119024","5142","","82    UMa","","82","","","UMa","","174.789","5.460","1.815","204.877084","52.921208","A3Vn","A","1","","" }
{ "67091","67304","119971","5176","","","","","","","Cen","","497.949","5.460","-0.459","206.910781","-50.320682","K2III","K","1","","" }
{ "68720","68940","123255","5290","","95    Vir","","95","","","Vir","","189.296","5.460","1.641","211.678435","-9.313515","F2IV","F","1","","" }
{ "75343","75572","137704","5741","","","","","","","Boo","","515.255","5.460","-0.533","231.572492","34.335996","K4III","K","1","","" }
{ "75418","75647","137432","5736","","","","","","","Lup","","428.027","5.460","-0.130","231.825551","-36.767560","B5V","B","1","","" }
{ "79248","79488","145892","6047","","9    Her","","9","","","Her","","397.267","5.460","0.032","243.314289","5.021086","K5III","K","1","","" }
{ "81059","81305","149404","6164","","","","","","","Sco","","1358.985","5.460","-2.639","249.094014","-42.858861","O9Ia","O","1","","" }
{ "59860","60044","107193","4687","","","","","","","Dra","","319.136","5.470","0.517","184.708517","75.160561","A1V","A","1","","" }
{ "60752","60941","108722","4753","","18    Com","","18","","","Com","","200.959","5.470","1.522","187.362680","24.108925","F5III","F","1","","" }
{ "60879","61071","108945","4766","","21    Com","","21","","","Com","","269.774","5.470","0.882","187.752338","24.567168","A2pvar","A","1","","" }
{ "64907","65112","115823","5026","","","","","","","Cen","","408.717","5.470","-0.020","200.157652","-52.747825","B6V","B","1","","" }
{ "68363","68581","122430","5265","","","","","","","Hya","","439.564","5.470","-0.178","210.594932","-27.429773","K2/K3III","K","1","","" }
{ "72356","72582","131111","5541","","","","","","","Boo","","209.882","5.470","1.427","222.623660","37.272047","K0III-IV","K","1","","" }
{ "78164","78400","143333","5954","GJ 3931","49    Lib","","49","","","Lib","","114.844","5.470","2.737","240.081698","-16.533350","F7V","F","1","","" }
{ "4095","4104","5098","247","","","","","","","Cet","","558.487","5.470","-0.698","13.169261","-24.005844","K1III","K","1","","" }
{ "13931","13965","18474","885","","","","","","","Per","","510.417","5.470","-0.502","44.957456","47.220693","G4p","G","1","","" }
{ "16429","16470","21699","1063","","","","","","","Per","","605.114","5.470","-0.872","53.035809","48.023476","B8IIIp Mn","B","1","","" }
{ "20930","20982","26659","1304","","","","","","","Cep","","307.405","5.470","0.599","67.502381","83.340379","G8III","G","1","","" }
{ "20987","21039","28546","1428","","81    Tau","","81","","","Tau","","146.521","5.470","2.208","67.662031","15.691879","Am","A","1","","" }
{ "22573","22626","30442","1527","","","","","","","Cam","","498.710","5.470","-0.452","73.021632","63.505421","M2III","M","1","","" }
{ "22818","22871","32440","1629","","Eta Men","Eta","","Eta","","Men","","668.353","5.470","-1.088","73.796482","-74.936852","K6III","K","1","","" }
{ "25631","25695","35943","1821","","118    Tau","","118","","","Tau","","425.236","5.470","-0.106","82.318747","25.150215","B9Vn","B","1","","" }
{ "27270","27338","38558","1990","","130    Tau","","130","","","Tau","","1782.275","5.470","-3.218","86.859151","17.729141","F0III","F","1","","" }
{ "110379","110725","213022","8557","","","","","","","Cep","","501.008","5.470","-0.462","336.503310","70.770898","K2III","K","1","","" }
{ "110591","110936","212953","8552","","Nu  Gru","Nu","","Nu","","Gru","","285.102","5.470","0.762","337.163348","-39.131792","G8III","G","1","","" }
{ "84462","84720","156274","6416","Gl 666A","","","","","","Ara","","28.708","5.470","5.747","259.764825","-46.636235","M0V","M","1","","Gl 666" }
{ "87477","87747","163506","6685","","89    Her","","89","","","Her","","326156.378","5.470","-14.530","268.854952","26.049991","F2Iavar","F","1","","" }
{ "88765","89042","165499","6761","Gl 705.1","Iot Pav","Iot","","Iot","","Pav","","57.442","5.470","4.241","272.609225","-62.002197","G0V","G","1","","" }
{ "89013","89290","166596","6804","","","","","","","CrA","","1164.844","5.470","-2.294","273.302907","-41.336111","B2.5III","B","1","","" }
{ "89854","90133","167468","6829","","Phi Oct","Phi","","Phi","","Oct","","194.025","5.470","1.598","275.901837","-75.044277","A0V","A","1","","" }
{ "90631","90913","170975","6959","","","","","","","Sct","","2886.340","5.470","-4.265","278.180509","-14.865662","K3Iab","K","1","","" }
{ "90640","90923","171301","6968","","","","","","","Lyr","","357.628","5.470","0.270","278.208152","30.554209","B8IV","B","1","","" }
{ "101684","102014","196737","7893","","","","","","","Mic","","236.860","5.470","1.165","310.082607","-33.431843","K1III","K","1","","" }
{ "102814","103145","199101","8005","","","","","","","Cyg","","600.656","5.470","-0.856","313.474560","33.437891","K5III","K","1","","" }
{ "105703","106044","203881","8196","","","","","","","Pav","","411.814","5.470","-0.036","322.186813","-69.505386","M5III","M","1","","" }
{ "34350","34440","54131","2684","","45    Gem","","45","","","Gem","","322.608","5.470","0.494","107.091831","15.930675","G8III","G","1","","" }
{ "38526","38639","64144","3066","","26    Lyn","","26","","","Lyn","","840.609","5.470","-1.586","118.677960","47.564596","K4III","K","1","","" }
{ "41961","42080","72037","3354","","2    UMa","","2","","","UMa","","152.481","5.470","2.121","128.650666","65.145170","A2m","A","1","","" }
{ "43204","43325","75630","3514","","","","","","","Vel","","1264.172","5.470","-2.472","132.413171","-40.320158","A2/A3IV","A","1","","" }
{ "44833","44961","78732","3641","","20    Hya","","20","","","Hya","","481.767","5.470","-0.377","137.398206","-8.787648","G8II","G","1","","" }
{ "51854","52004","92207","4169","","","","","","","Car","","326156.378","5.470","-14.530","159.362799","-58.733339","A0Ia","A","1","","" }
{ "53625","53781","95212","4280","","","","","","","UMa","","825.712","5.470","-1.547","165.061257","45.526276","K5III","K","1","","" }
{ "30141","30214","44458","2284","","","","","","","CMa","","1101.880","5.480","-2.164","95.352980","-11.773238","B1Vpe SB","B","1","","" }
{ "37941","38048","63336","3029","","5    Pup","","5","","","Pup","","93.267","5.480","3.198","116.986338","-12.192705","F5+...","F","1","","" }
{ "38480","38593","64802","3091","","","","","","","Pup","","678.080","5.480","-1.109","118.545871","-35.877287","B2V","B","1","","" }
{ "42593","42712","74455","3462","","","","","","","Vel","","326156.378","5.480","-14.520","130.567477","-48.099090","B1.5Vn","B","1","","" }
{ "44485","44613","77601","3603","","","","","","","UMa","","316.657","5.480","0.544","136.350414","48.530314","F6II-III","F","1","","" }
{ "56633","56802","101198","4488","GJ 3677A","24Iot Crt","Iot","24","Iot","","Crt","","87.184","5.480","3.345","174.666730","-13.201943","F7V","F","1","","GJ 3677" }
{ "61125","61318","109309","4781","","21    Vir","","21","","","Vir","","258.444","5.480","0.985","188.444788","-9.452077","A0V","A","1","","" }
{ "72437","72664","131507","5552","","","","","","","Dra","","452.995","5.480","-0.233","222.860434","59.293985","K4III","K","1","","" }
{ "72906","73133","131918","5564","","15Xi 2Lib","Xi-2","15","Xi","2","Lib","","549.085","5.480","-0.651","224.192132","-11.409701","K4III","K","1","","" }
{ "76721","76957","140728","5857","","","","","","","Boo","","298.678","5.480","0.671","235.711602","52.360903","B9p...","B","1","","" }
{ "79040","79280","146926","6079","","19    UMi","","19","","","UMi","","617.720","5.480","-0.907","242.706365","75.877563","B8V","B","1","","" }
{ "79766","80008","147365","6091","GJ 9557A","","","","","","Her","","86.035","5.480","3.374","244.979855","39.708584","F3IV-V","F","1","","GJ 9557" }
{ "81884","82135","151078","6221","","","","","","","Sco","","287.870","5.480","0.751","251.699838","-39.376962","K0III","K","1","","" }
{ "82151","82402","151956","6250","","47    Her","","47","","","Her","","177.452","5.480","1.802","252.580753","7.247683","A3m","A","1","","" }
{ "11222","11249","14951","702","","24Xi  Ari","Xi","24","Xi","","Ari","","872.076","5.480","-1.656","36.204400","10.610565","B7IV","B","1","","" }
{ "13231","13265","17829","851","","Eta3For","Eta-3","","Eta","3","For","","459.375","5.480","-0.264","42.668359","-35.675849","K2III","K","1","","" }
{ "18098","18141","24388","1202","","30    Eri","","30","","","Eri","","585.559","5.480","-0.791","58.173566","-5.361259","B8+...","B","1","","" }
{ "24619","24679","34538","1737","","","","","","","Lep","","159.881","5.480","2.028","79.417674","-13.519826","G8IV","G","1","","" }
{ "82704","82960","152820","6288","","27    Sco","","27","","","Sco","","948.129","5.480","-1.837","254.296564","-33.259492","K5III","K","1","","" }
{ "102166","102497","197630","7933","","","","","","","Mic","","324.534","5.480","0.491","311.583568","-39.199262","B8/B9V","B","1","","" }
{ "102763","103094","199098","8003","","","","","","","Cyg","","1006.656","5.480","-1.967","313.327348","45.181673","K0II","K","1","","" }
{ "105327","105668","203705","8187","","18    Aqr","","18","","","Aqr","","153.630","5.480","2.115","321.047883","-12.878108","F0V","F","1","","" }
{ "105426","105767","203926","8199","","21    Aqr","","21","","","Aqr","","388.281","5.480","0.101","321.320657","-3.556747","K4III","K","1","","" }
{ "88559","88836","166229","6793","","","","","","","Her","","207.479","5.490","1.472","272.009382","36.401264","K2III","K","1","","" }
{ "89092","89369","167036","6816","","14    Sgr","","14","","","Sgr","","452.995","5.490","-0.223","273.566255","-21.713164","K2III","K","1","","" }
{ "90722","91004","171115","6961","","24    Sgr","","24","","","Sgr","","2064.281","5.490","-3.517","278.472858","-24.032283","K3III","K","1","","" }
{ "93372","93667","177074","7211","","","","","","","Sgr","","479.642","5.490","-0.347","286.104403","-31.047079","A0V","A","1","","" }
{ "96756","97063","186185","7496","GJ 9666","","","","","","Sgr","","159.568","5.490","2.042","295.889697","-15.470105","F5V","F","1","","" }
{ "103069","103401","199345","8015","","7    Aqr","","7","","","Aqr","","546.326","5.490","-0.630","314.225115","-9.697545","K5III","K","1","","" }
{ "60945","61136","108968","4768","","","","","","","Cru","","1399.813","5.490","-2.673","187.918071","-59.423922","F5III","F","1","","" }
{ "61531","61724","110024","4815","","26    Com","","26","","","Com","","273.392","5.490","0.873","189.780468","21.062559","G9III","G","1","","" }
{ "79431","79672","146233","6060","Gl 616","18    Sco","","18","","","Sco","","45.337","5.490","4.775","243.905286","-8.369442","G1V","G","1","","" }
{ "109733","110078","210853","8471","","Psi Oct","Psi","","Psi","","Oct","","125.541","5.490","2.563","334.461141","-77.511553","F3III","F","1","","" }
{ "116245","116611","222133","8963","","75    Peg","","75","","","Peg","","232.803","5.490","1.222","354.486671","18.400667","A1Vn","A","1","","" }
{ "117008","117375","223252","9012","","20    Psc","","20","","","Psc","","316.657","5.490","0.554","356.985595","-2.761598","G8III","G","1","","" }
{ "29078","29150","42301","2180","","","","","","","Lep","","246.342","5.490","1.099","92.241104","-22.427412","A0V","A","1","","" }
{ "37793","37901","62902","3014","","","","","","","Mon","","267.780","5.490","0.918","116.509125","-6.772511","K5III","K","1","","" }
{ "42596","42715","74535","3466","","","","","","","Vel","","499.474","5.490","-0.435","130.579173","-53.100056","B8...","B","1","","" }
{ "45395","45526","79931","3683","","24    Hya","","24","","","Hya","","676.673","5.490","-1.095","139.172364","-8.744759","B9III","B","1","","" }
{ "46445","46578","82205","3770","","","","","","","Ant","","789.725","5.490","-1.430","142.477107","-26.589616","K2IIICNII","K","1","","" }
{ "50161","50303","88960","4024","","23    LMi","","23","","","LMi","","260.717","5.490","0.976","154.060157","29.310501","A0Vn","A","1","","" }
{ "52537","52689","93291","4209","","52    Leo","","52","","","Leo","","287.362","5.490","0.765","161.605332","14.194645","G4III:","G","1","","" }
{ "3599","3607","4398","210","","","","","","","Cet","","304.250","5.490","0.641","11.548934","-22.522097","G8/K0III","G","1","","" }
{ "7199","7213","9525","445","","","","","","","Scl","","275.237","5.490","0.859","23.233551","-36.865231","K1/K2III","K","1","","" }
{ "8225","8240","10934","519","","","","","","","Phe","","634.545","5.490","-0.955","26.524798","-50.816256","M3III","M","1","","" }
{ "14381","14417","18438","881","","","","","","","Cep","","691.009","5.490","-1.140","46.533050","79.418535","F7IV comp SB","F","1","","" }
{ "15300","15338","20315","982","","30    Per","","30","","","Per","","731.292","5.490","-1.263","49.447280","44.025024","B8V...","B","1","","" }
{ "18387","18434","24640","1215","","","","","","","Per","","867.437","5.490","-1.634","59.119540","35.080899","B1.5V","B","1","","" }
{ "22210","22263","30495","1532","Gl 177","58    Eri","","58","","","Eri","","43.303","5.490","4.875","71.901201","-16.934456","G3V","G","1","","" }
{ "27448","27517","39070","2021","","","","","","","Lep","","267.561","5.490","0.920","87.402261","-14.483665","G8III","G","1","","" }
{ "1643","1647","1685","83","","Pi  Tuc","Pi","","Pi","","Tuc","","318.201","5.500","0.554","5.162669","-69.624913","B9V","B","1","","" }
{ "4842","4852","6178","293","","Sig Scl","Sig","","Sig","","Scl","","232.305","5.500","1.237","15.610104","-31.552005","A1/A2IV","A","1","","" }
{ "4879","4889","6118","291","","69Sig Psc","Sig","69","Sig","","Psc","","433.719","5.500","-0.119","15.704565","31.804263","B9.5V","B","1","","" }
{ "6718","6732","8763","414","","94    Psc","","94","","","Psc","","279.005","5.500","0.839","21.673653","19.240422","K1III","K","1","","" }
{ "9550","9570","12471","599","","3Eps Tri","Eps","3","Eps","","Tri","","391.544","5.500","0.103","30.741489","33.284135","A2V","A","1","","" }
{ "15604","15643","20894","1016","","","","","","","Eri","","366.880","5.500","0.245","50.350047","-23.635135","G8III","G","1","","" }
{ "15822","15861","21017","1022","","64    Ari","","64","","","Ari","","208.008","5.500","1.477","51.076975","24.724063","K4III","K","1","","" }
{ "20121","20171","27295","1339","","53    Tau","","53","","","Tau","","269.997","5.500","0.910","64.858734","21.142307","B9IV","B","1","","" }
{ "22905","22958","31512","1582","","62    Eri","","62","","","Eri","","741.264","5.500","-1.283","74.100775","-5.171356","B6V","B","1","","" }
{ "23845","23900","32990","1659","","103    Tau","","103","","","Tau","","1496.130","5.500","-2.808","77.027597","24.265175","B2V...","B","1","","" }
{ "24392","24450","34043","1709","","","","","","","Ori","","486.075","5.500","-0.366","78.683534","5.156151","K4III","K","1","","" }
{ "25883","25950","36408","1847","","","","","","","Tau","","2992.260","5.500","-4.313","83.058925","17.058128","B7III","B","1","","" }
{ "115471","115836","219765","8862","","Tau Oct","Tau","","Tau","","Oct","","486.075","5.500","-0.366","352.014900","-87.482214","K2III","K","1","","" }
{ "88788","89065","166460","6800","","","","","","","Oph","","403.160","5.500","0.040","272.667915","3.324256","K2III","K","1","","" }
{ "96770","97077","186486","7506","","10    Vul","","10","","","Vul","","331.797","5.500","0.463","295.928851","25.771929","G8III","G","1","","" }
{ "100109","100435","193911","7789","","25    Vul","","25","","","Vul","","997.420","5.500","-1.927","305.514294","24.446099","B8IIIn","B","1","","" }
{ "105572","105913","204018","8202","","","","","","","Mic","","184.061","5.500","1.742","321.756804","-42.547930","Am","A","1","","" }
{ "108198","108543","208737","8379","","","","","","","Gru","","432.568","5.500","-0.113","329.824604","-38.395096","K1II/III","K","1","","" }
{ "56328","56497","100708","4462","","","","","","","Cen","","191.857","5.500","1.652","173.737099","-49.136490","K1III/IV","K","1","","" }
{ "66226","66435","118904","5139","","","","","","","UMi","","411.294","5.500","-0.004","204.295971","71.242252","K2III","K","1","","" }
{ "66960","67172","119853","5173","","86    Vir","","86","","","Vir","","406.679","5.500","0.021","206.484664","-12.426528","G8III","G","1","","" }
{ "75874","76106","138413","5762","","","","","","","Lib","","228.561","5.500","1.272","233.152925","-19.670460","A2IV","A","1","","" }
{ "75901","76133","138562","5772","","11    Ser","","11","","","Ser","","280.203","5.500","0.830","233.241407","-1.186399","K0III","K","1","","" }
{ "78959","79199","144987","6007","","","","","","","Sco","","407.695","5.500","0.015","242.469134","-33.545805","B8V","B","1","","" }
{ "80895","81141","148488","6135","","","","","","","Aps","","809.321","5.500","-1.473","248.580666","-70.988097","K1IIICN...","K","1","","" }
{ "81006","81252","148890","6151","","The TrA","The","","The","","TrA","","342.242","5.500","0.395","248.936628","-65.495399","G8/K0III","G","1","","" }
{ "28992","29064","42303","2181","","Pi 2Col","Pi-2","","Pi","2","Col","","242.857","5.500","1.140","91.970255","-42.154043","A0V","A","1","","" }
{ "33910","34000","53921","2674","","","","","","","Car","","493.429","5.500","-0.399","105.812931","-59.178109","B9IV","B","1","","" }
{ "35467","35564","57852","2813","","","","","","","Car","","103.443","5.500","2.994","110.089321","-52.311524","F2","F","1","","" }
{ "48865","49005","86378","3939","","","","","","","UMa","","500.240","5.500","-0.429","149.965423","56.811807","K5III","K","1","","" }
{ "51672","51821","91793","4153","","","","","","","Ant","","874.414","5.500","-1.641","158.803568","-39.562589","C","C","1","","" }
{ "52534","52686","93257","4208","","51    Leo","","51","","","Leo","","186.588","5.500","1.713","161.602258","18.891523","K3III","K","1","","" }
{ "29868","29941","43955","2266","","","","","","","CMa","","795.503","5.510","-1.426","94.557201","-19.966974","B2/B3V","B","1","","" }
{ "41333","41451","72337","3370","","","","","","","Vol","","279.483","5.510","0.845","126.819903","-70.093482","A0V","A","1","","" }
{ "47134","47267","83548","3842","","","","","","","Vel","","474.755","5.510","-0.305","144.506034","-43.190944","G8II","G","1","","" }
{ "52070","52221","92664","4185","","","","","","","Car","","523.525","5.510","-0.518","160.047722","-65.100209","B9p Si","B","1","","" }
{ "52271","52422","92769","4189","","40    LMi","","40","","","LMi","","157.792","5.510","2.087","160.757869","26.325577","A4Vn","A","1","","" }
{ "53873","54029","95808","4305","","","","","","","Crt","","338.688","5.510","0.428","165.812002","-11.303470","G7III...","G","1","","" }
{ "84577","84835","157325","6464","","74    Her","","74","","","Her","","557.532","5.510","-0.654","260.088039","46.240780","M0III","M","1","","" }
{ "87038","87308","162555","6654","","","","","","","Her","","253.621","5.510","1.056","267.595374","29.322143","K1III","K","1","","" }
{ "92260","92549","175225","7123","Gl 732.1","","","","","","Dra","","83.716","5.510","3.463","282.895681","52.975117","G9IVa","G","1","","" }
{ "92340","92630","174387","7092","","","","","","","Tel","","1035.417","5.510","-1.998","283.113428","-46.595119","M0III","M","1","","" }
{ "92931","93225","176162","7166","","","","","","","Sgr","","476.837","5.510","-0.315","284.849174","-12.840517","B4V","B","1","","" }
{ "93047","93340","177249","7218","","49    Dra","","49","","","Dra","","491.940","5.510","-0.382","285.181084","55.658301","G5IIbCN...","G","1","","" }
{ "94143","94437","179497","7282","","","","","","","Sgr","","541.788","5.510","-0.592","288.314679","-12.282584","K3III","K","1","","" }
{ "96951","97260","186500","7507","","","","","","","Sgr","","710.580","5.510","-1.181","296.505070","-31.908571","B8III","B","1","","" }
{ "98014","98325","189395","7640","","","","","","","Cyg","","465.273","5.510","-0.261","299.658242","30.983665","B9Vn","B","1","","" }
{ "98508","98823","190327","7669","","63Tau Aql","Tau","63","Tau","","Aql","Tianfu","461.978","5.510","-0.246","301.034646","7.277966","K0III","K","1","","" }
{ "99087","99404","191747","7711","","18    Vul","","18","","","Vul","","423.580","5.510","-0.058","302.639731","26.904169","A3III","A","1","","" }
{ "99200","99518","192004","7718","","19    Vul","","19","","","Vul","","1411.932","5.510","-2.672","302.949893","26.808990","K3II-III","K","1","","" }
{ "103195","103527","199665","8030","","18    Del","","18","","","Del","Musica","245.600","5.510","1.126","314.608062","10.839286","G6III:","G","1","","" }
{ "104920","105259","203338","8164","","","","","","","Cep","","1929.919","5.510","-3.351","319.815374","58.623502","B3Vv comp","B","1","","" }
{ "106892","107235","206749","8306","","","","","","","Cyg","","642.040","5.510","-0.961","325.776973","41.154970","M2III","M","1","","" }
{ "2796","2802","3302","147","GJ 3041","Lam2Phe","Lam-2","","Lam","2","Phe","","113.564","5.510","2.801","8.921510","-48.000907","F6V","F","1","","" }
{ "3667","3675","4482","213","","58    Psc","","58","","","Psc","","283.122","5.510","0.817","11.756074","11.973849","G8II","G","1","","" }
{ "5335","5346","6763","330","","80    Psc","","80","","","Psc","","114.844","5.510","2.777","17.092496","5.649819","F0III-IV","F","1","","" }
{ "6734","6748","8829","421","","47    Cet","","47","","","Cet","","122.202","5.510","2.642","21.714854","-13.056512","F0V","F","1","","" }
{ "10618","10642","14129","666","","67    Cet","","67","","","Cet","","332.813","5.510","0.466","34.246016","-6.422116","G8III","G","1","","" }
{ "14097","14131","19400","939","","The Hyi","The","","The","","Hyi","","514.442","5.510","-0.480","45.564221","-71.902457","B8III/IV","B","1","","" }
{ "15163","15201","21024","1025","","Iot Hyi","Iot","","Iot","","Hyi","","96.897","5.510","3.146","48.989267","-77.388454","F4III","F","1","","" }
{ "19340","19388","26162","1283","","43Ome1Tau","Ome-1","43","Ome","1","Tau","","283.861","5.510","0.812","62.291513","19.609217","K2III","K","1","","" }
{ "20808","20860","26356","1289","","","","","","","Cep","","756.743","5.510","-1.318","67.055387","83.807790","B5V","B","1","","" }
{ "22989","23043","31539","1585","","","","","","","Tau","","476.837","5.510","-0.315","74.343087","17.153677","K1III","K","1","","" }
{ "110715","111062","213235","8566","","37    Peg","","37","","","Peg","","169.168","5.510","1.936","337.491406","4.431690","F5IVs","F","1","","" }
{ "113172","113532","217236","8740","","","","","","","PsA","","312.410","5.510","0.604","344.898994","-29.462311","F0V","F","1","","" }
{ "59052","59232","105521","4625","","","","","","","Cen","","1591.007","5.510","-2.931","182.227462","-41.231605","B3IV","B","1","","" }
{ "67038","67250","120164","5186","","","","","","","CVn","","316.964","5.510","0.572","206.749152","38.542697","K0III+...","K","1","","" }
{ "70691","70915","126981","5412","","","","","","","Lup","","476.837","5.510","-0.315","217.535992","-45.321355","B8Vn","B","1","","" }
{ "72966","73193","132132","5573","GJ 3881A","","","","","","Vir","","291.471","5.510","0.754","224.388546","-0.167612","K1III","K","1","","GJ 3881" }
{ "74820","75049","136512","5709","","1Omi CrB","Omi","1","Omi","","CrB","","269.997","5.510","0.920","230.035703","29.616209","K0III","K","1","","" }
{ "82229","82480","152127","6255","","21    Oph","","21","","","Oph","","378.811","5.510","0.185","252.853869","1.215947","A2Vs","A","1","","" }
{ "59986","60170","107325","4693","","","","","","","Com","","160.985","5.520","2.053","185.082005","26.619482","K2III-IV","K","1","","" }
{ "65883","66091","117789","5099","","75    Vir","","75","","","Vir","","514.442","5.520","-0.470","203.215181","-15.363012","K1III","K","1","","" }
{ "73270","73497","132833","5590","","","","","","","Lib","","742.953","5.520","-1.268","225.332611","-2.754927","M0III","M","1","","" }
{ "73406","73634","133392","5609","","","","","","","Boo","","279.963","5.520","0.852","225.775251","35.205795","G8III:","G","1","","" }
{ "74503","74732","135534","5678","","","","","","","Lib","","472.006","5.520","-0.283","229.095887","-22.399416","K2III","K","1","","" }
{ "7963","7978","10647","506","GJ 3109","","","","","","Eri","","56.861","5.520","4.313","25.621868","-53.740834","F8V","F","1","","" }
{ "13293","13327","17769","847","","43Sig Ari","Sig","43","Sig","","Ari","","494.176","5.520","-0.382","42.873276","15.082071","B7V","B","1","","" }
{ "17696","17738","23940","1184","","Rho For","Rho","","Rho","","For","","268.884","5.520","0.939","56.983493","-30.167882","G6III","G","1","","" }
{ "19287","19335","25998","1278","Gl 161.1","50    Per","","50","","","Per","","68.477","5.520","3.909","62.152461","38.039733","F7V","F","1","","" }
{ "22801","22854","30958","1555","","5    Cam","","5","","","Cam","","620.069","5.520","-0.875","73.763051","55.259109","B9.5V","B","1","","" }
{ "24496","24555","34203","1718","","18    Ori","","18","","","Ori","","443.147","5.520","-0.146","79.017226","11.341354","A0V","A","1","","" }
{ "25491","25555","35770","1814","","116    Tau","","116","","","Tau","","424.130","5.520","-0.050","81.940035","15.874052","B9.5Vn","B","1","","" }
{ "28027","28098","40248","2092","","Sig Col","Sig","","Sig","","Col","","1664.063","5.520","-3.019","89.087265","-31.382440","F2III","F","1","","" }
{ "31503","31583","47054","2418","","","","","","","Mon","","753.248","5.520","-1.298","99.147216","-5.211143","B8V","B","1","","" }
{ "39249","39360","66624","3162","","","","","","","Pup","","479.642","5.520","-0.317","120.686605","-41.309828","Ap Si","A","1","","" }
{ "39455","39566","67364","3180","","","","","","","Car","","383.714","5.520","0.167","121.265450","-53.107921","K3/K4III","K","1","","" }
{ "40167","40282","69194","3247","","","","","","","Vel","","721.585","5.520","-1.204","123.392663","-50.196072","M1III","M","1","","" }
{ "41035","41152","70313","3277","","","","","","","Lyn","","164.476","5.520","2.007","125.952138","53.219712","A3V","A","1","","" }
{ "41279","41395","71377","3324","","","","","","","Pup","","275.005","5.520","0.890","126.674805","-12.534602","K1/K2III","K","1","","" }
{ "50314","50456","89353","4049","","","","","","","Ant","","2651.678","5.520","-4.030","154.531631","-28.992000","B9.5Ib/II","B","1","","" }
{ "50790","50935","90040","4081","","28    LMi","","28","","","LMi","","424.130","5.520","-0.050","156.035855","33.718531","K1III","K","1","","" }
{ "51240","51384","89571","4062","","","","","","","Cam","","132.530","5.520","2.476","157.425555","84.252009","F0IV","F","1","","" }
{ "54178","54336","96436","4319","","65    Leo","","65","","","Leo","","206.167","5.520","1.516","166.725864","1.955525","G9IIICN...","G","1","","" }
{ "85126","85385","158148","6502","","","","","","","Her","","583.464","5.520","-0.743","261.704697","20.080977","B5V","B","1","","" }
{ "88539","88816","165687","6769","","","","","","","Sgr","","251.470","5.520","1.085","271.951431","-17.154159","K0III","K","1","","" }
{ "89845","90124","168838","6874","","","","","","","Sgr","","286.605","5.520","0.801","275.870106","-36.237987","K0III","K","1","","" }
{ "94494","94789","179366","7278","","","","","","","Pav","","298.678","5.520","0.711","289.300938","-66.661048","A4IV/V","A","1","","" }
{ "102585","102916","198357","7971","","","","","","","Mic","","587.669","5.520","-0.759","312.753163","-37.913332","K3III","K","1","","" }
{ "107492","107835","207241","8333","","Omi Ind","Omi","","Omi","","Ind","","543.594","5.520","-0.589","327.696713","-69.629416","M0III","M","1","","" }
{ "107632","107975","207978","8354","GJ 4234","15    Peg","","15","","","Peg","","89.530","5.520","3.327","328.124674","28.793538","F6IVwvar","F","1","","" }
{ "109128","109474","210884","8474","","","","","","","Cep","","109.559","5.520","2.889","332.661935","70.132573","F2V","F","1","","" }
{ "110471","110817","213087","8561","","26    Cep","","26","","","Cep","","326156.378","5.520","-14.480","336.772128","65.132270","B0.5Ib","B","1","","" }
{ "112025","112381","215405","8657","","","","","","","Gru","","787.817","5.520","-1.395","341.419959","-46.547328","K3III","K","1","","" }
{ "109399","109745","211096","8487","","","","","","","Lac","","251.664","5.530","1.093","333.455091","45.440613","A0III","A","1","","" }
{ "110183","110529","212271","8529","","49    Aqr","","49","","","Aqr","","261.973","5.530","1.006","335.878511","-24.762661","K0IIICN...","K","1","","" }
{ "112788","113148","216640","8711","","77    Aqr","","77","","","Aqr","","134.331","5.530","2.456","343.689476","-16.271957","K1III","K","1","","" }
{ "113609","113969","217831","8769","","","","","","","Ind","","174.322","5.530","1.890","346.217394","-68.820226","F4III","F","1","","" }
{ "115348","115713","220729","8907","","Omi Gru","Omi","","Omi","","Gru","","100.356","5.530","3.089","351.652348","-52.721603","F4V","F","1","","" }
{ "30578","30651","44691","2291","","","","","","","Lyn","","244.495","5.530","1.156","96.607704","56.285096","A3m","A","1","","" }
{ "39922","40035","68146","3202","Gl 297.2A","18    Pup","","18","","","Pup","","72.998","5.530","3.781","122.665960","-13.799207","F7V","F","1","","Gl 297.2" }
{ "48925","49065","87971","3983","","Mu 1Cha","Mu-1","","Mu","1","Cha","","375.324","5.530","0.225","150.182870","-82.214670","A0IV","A","1","","" }
{ "57986","58159","103578","4564","","95    Leo","","95","","","Leo","","494.926","5.530","-0.376","178.918889","15.646818","A3V","A","1","","" }
{ "63747","63950","113866","4949","Gl 499.1","40    Com","","40","","","Com","","736.245","5.530","-1.238","196.594173","22.616187","M5III","M","1","","" }
{ "67605","67819","120987","5222","","","","","","","Cen","","170.495","5.530","1.939","208.386550","-35.664248","F3V","F","1","","" }
{ "69240","69462","124147","5308","","","","","","","Cen","","2131.741","5.530","-3.547","213.318388","-53.665674","K5III+...","K","1","","" }
{ "69313","69536","124570","5323","","14    Boo","","14","","","Boo","","110.636","5.530","2.878","213.521598","12.959444","F6IV","F","1","","" }
{ "69436","69658","124683","5332","","","","","","","Vir","","246.714","5.530","1.136","213.850360","-18.200690","A0V","A","1","","" }
{ "75894","76126","138485","5764","","35Zet4Lib","Zet-4","35","Zet","4","Lib","","656.250","5.530","-0.988","233.230089","-16.852844","B3V","B","1","","" }
{ "77228","77464","141378","5875","","","","","","","Lib","","176.206","5.530","1.867","237.236657","-3.818513","A5IV","A","1","","" }
{ "78199","78436","143459","5959","","50    Lib","","50","","","Lib","","489.724","5.530","-0.353","240.198469","-8.411353","A0Vs","A","1","","" }
{ "79738","79980","146836","6077","","","","","","","Sco","","157.411","5.530","2.112","244.886377","-30.906716","F5IV","F","1","","" }
{ "80217","80460","148283","6123","","25    Her","","25","","","Her","","242.857","5.530","1.170","246.350697","37.394079","A5V","A","1","","" }
{ "81044","81290","150100","6184","","16    Dra","","16","","","Dra","","426.906","5.530","-0.055","249.047605","52.900048","B9.5Vn","B","1","","" }
{ "107","107","224865","9082","","","","","","","Phe","","542.690","5.530","-0.576","0.333820","-50.337373","M2III","M","1","","" }
{ "8687","8704","11241","533","","1    Per","","1","","","Per","","1294.271","5.530","-2.463","27.997144","55.147385","B1.5V","B","1","","" }
{ "12075","12107","16212","759","","80    Cet","","80","","","Cet","","465.273","5.530","-0.241","39.000202","-7.831597","M0III","M","1","","" }
{ "15293","15330","20766","1006","Gl 136","Zet1Ret","Zet-1","","Zet","1","Ret","","39.164","5.530","5.133","49.438539","-62.575322","G2V","G","1","","" }
{ "17126","17167","22920","1121","","22    Eri","","22","","","Eri","","496.433","5.530","-0.382","55.159722","-5.210706","B9IIIp Si","B","1","","" }
{ "20737","20789","28149","1399","","72    Tau","","72","","","Tau","","377.933","5.530","0.210","66.822698","22.996337","B7V","B","1","","" }
{ "20832","20884","28375","1415","","","","","","","Tau","","382.813","5.530","0.182","67.133831","1.380821","B3V","B","1","","" }
{ "21896","21949","30612","1541","","Mu  Men","Mu","","Mu","","Men","","491.199","5.530","-0.359","70.766467","-70.931027","B9IV","B","1","","" }
{ "21975","22028","30127","1513","","","","","","","Eri","","305.963","5.530","0.669","71.033251","-18.666586","A1V","A","1","","" }
{ "25788","25853","36473","1849","","10    Lep","","10","","","Lep","","271.571","5.530","0.928","82.781777","-20.863659","A0V","A","1","","" }
{ "26317","26382","37147","1905","","122    Tau","","122","","","Tau","","158.482","5.530","2.097","84.265561","17.040324","F0V","F","1","","" }
{ "82802","83057","152824","6289","","","","","","","Ara","","519.357","5.530","-0.480","254.574762","-50.641185","B9IV","B","1","","" }
{ "84293","84551","156098","6409","","","","","","","Sco","","157.792","5.530","2.107","259.265235","-32.662840","F6V","F","1","","" }
{ "86431","86698","160668","6583","","","","","","","Sco","","689.548","5.530","-1.096","265.712904","-36.945564","K5III","K","1","","" }
{ "88745","89020","166023","6780","","","","","","","Sgr","","449.251","5.530","-0.165","272.524219","-30.728666","K1III + (F)","K","1","","" }
{ "93548","93843","178233","7253","","","","","","","Lyr","","130.358","5.530","2.521","286.657201","28.628595","F0III","F","1","","" }
{ "94689","94982","181333","7331","","28    Aql","","28","","","Aql","","337.287","5.530","0.457","289.913950","12.374680","F0III","F","1","","" }
{ "101736","102066","197177","7921","","49    Cyg","","49","","","Cyg","","797.448","5.530","-1.411","310.260590","32.307287","G8IIb","G","1","","" }
{ "103649","103981","200496","8058","","12    Aqr","","12","","","Aqr","","501.779","5.530","-0.405","316.019685","-5.823066","G4","G","1","","" }
{ "105885","106227","205139","8243","","","","","","","Cep","","1509.983","5.530","-2.798","322.747052","60.459432","B1II","B","1","","" }
{ "107243","107586","207528","8339","","12    Cep","","12","","","Cep","","458.085","5.530","-0.208","326.855424","60.692689","M1III","M","1","","" }
{ "83925","84183","156295","6421","","","","","","","Dra","","140.403","5.540","2.370","258.135702","62.874337","F0IV","F","1","","" }
{ "85757","86019","159358","6544","","","","","","","Ser","","402.166","5.540","0.085","263.693129","-11.241999","B8Vn","B","1","","" }
{ "86356","86623","160910","6594","","","","","","","Her","","113.683","5.540","2.829","265.494309","15.952430","F4Vw","F","1","","" }
{ "97454","97765","187982","7573","","","","","","","Vul","","1689.929","5.540","-3.032","298.006641","24.992162","A1Iab","A","1","","" }
{ "97923","98234","189090","7622","","11    Sge","","11","","","Sge","","455.526","5.540","-0.185","299.439355","16.789163","B9III","B","1","","" }
{ "102966","103298","199254","8012","","16    Del","","16","","","Del","","197.312","5.540","1.631","313.910714","12.568558","A4V","A","1","","" }
{ "103266","103598","200205","8049","","","","","","","Cep","","615.389","5.540","-0.839","314.855660","59.438594","K4III","K","1","","" }
{ "107994","108339","208565","8373","","17    Peg","","17","","","Peg","","400.683","5.540","0.093","329.234884","12.076492","A2Vnn","A","1","","" }
{ "55979","56146","100006","4433","","86    Leo","","86","","","Leo","","314.823","5.540","0.617","172.620972","18.409801","K0III","K","1","","" }
{ "56843","57013","101615","4502","","","","","","","Cen","","213.593","5.540","1.459","175.332533","-43.095667","A0V","A","1","","" }
{ "58401","58576","104304","4587","Gl 454","","","","","","Vir","","41.628","5.540","5.010","180.185208","-10.446014","K0IV","K","1","","" }
{ "60027","60212","107465","4701","","70    UMa","","70","","","UMa","","635.782","5.540","-0.909","185.211908","57.864118","K5III","K","1","","" }
{ "74898","75127","136479","5707","","","","","","","Lib","","302.277","5.540","0.705","230.281710","-5.824853","K1III","K","1","","" }
{ "77154","77390","140483","5851","","","","","","","TrA","","365.237","5.540","0.294","236.971163","-65.442291","A5","A","1","","" }
{ "77896","78132","142980","5940","","Phi Ser","Phi","","Phi","","Ser","","241.240","5.540","1.195","239.310725","14.414480","K1IV","K","1","","" }
{ "114692","115054","219693","8859","GJ 4330","Phi Gru","Phi","","Phi","","Gru","","115.495","5.540","2.794","349.541085","-40.824361","F5V","F","1","","" }
{ "28453","28524","41047","2131","","","","","","","Col","","614.230","5.540","-0.835","90.317905","-33.911835","K5III","K","1","","" }
{ "29190","29263","42682","2203","","","","","","","Col","","851.583","5.540","-1.544","92.543365","-40.353792","M2II/III","M","1","","" }
{ "29769","29842","43899","2263","","","","","","","Col","","298.678","5.540","0.731","94.255128","-37.737445","K2III","K","1","","" }
{ "32523","32609","48766","2486","","","","","","","Lyn","","144.381","5.540","2.310","102.051108","55.704195","F5V:+...","F","1","","" }
{ "35043","35136","55575","2721","GJ 1095","","","","","","Lyn","","55.094","5.540","4.402","108.958876","47.239964","G0V","G","1","","" }
{ "35939","36039","60816","2919","","Eps Men","Eps","","Eps","","Men","","466.604","5.540","-0.238","111.409046","-79.094188","K2/K3III","K","1","","" }
{ "45087","45219","79698","3673","","","","","","","Car","","473.377","5.540","-0.269","138.231783","-59.413928","G6II","G","1","","" }
{ "811","813","560","26","","34    Psc","","34","","","Psc","","305.390","5.540","0.683","2.509175","11.145813","B9V","B","1","","" }
{ "7521","7535","9919","463","","102Pi  Psc","Pi","102","Pi","","Psc","","114.441","5.540","2.814","24.274657","12.141535","F0V","F","1","","" }
{ "25080","25143","34904","1760","","","","","","","Aur","","292.517","5.540","0.776","80.709655","41.029260","A3V","A","1","","" }
{ "27514","27581","39019","2016","","135    Tau","","135","","","Tau","","316.657","5.540","0.604","87.620442","14.305608","G9III:","G","1","","" }
{ "475","476","87","4","","86    Peg","","86","","","Peg","","372.750","5.550","0.260","1.424836","13.396266","G5III","G","1","","" }
{ "2655","2661","3059","138","","","","","","","Scl","","538.212","5.550","-0.538","8.421020","-29.558278","K1III","K","1","","" }
{ "3875","3885","4757","230","","65    Psc","","65","","","Psc","","288.890","5.550","0.813","12.471497","27.710286","F5III+...","F","1","","" }
{ "5122","5132","6457","311","","74Psi1Psc","Psi-1","74","Psi","1","Psc","","280.203","5.550","0.880","16.423789","21.465442","A0Vn","A","1","","" }
{ "7603","7617","9900","461","","","","","","","Cas","","1744.152","5.550","-3.091","24.531523","57.977631","G5II","G","1","","" }
{ "11405","11432","15176","712","","11    Tri","","11","","","Tri","","278.053","5.550","0.896","36.865726","31.801280","K1III:","K","1","","" }
{ "14879","14915","19926","958","","","","","","","Cet","","753.248","5.550","-1.268","48.109855","6.660883","K1IIIpe+...","K","1","","" }
{ "15657","15696","20825","1012","","62    Ari","","62","","","Ari","","883.893","5.550","-1.615","50.549554","27.607553","G5III","G","1","","" }
{ "17062","17103","22796","1115","","12    Tau","","12","","","Tau","","371.900","5.550","0.265","54.963009","3.056863","G6III:","G","1","","" }
{ "17161","17203","22780","1113","","","","","","","Per","","821.553","5.550","-1.456","55.282727","37.580198","B7Vn","B","1","","" }
{ "20184","20234","27192","1333","","","","","","","Per","","1083.576","5.550","-2.057","65.047969","50.920933","B1.5IV","B","1","","" }
{ "24678","24738","34269","1722","","","","","","","Aur","","563.310","5.550","-0.637","79.565388","42.792111","M4III","M","1","","" }
{ "110432","110778","212697","8544","Gl 859B","53    Aqr","","53","","","Aqr","","65.890","5.550","4.023","336.642791","-16.742138","G3V","G","2","119501","Gl 859" }
{ "113309","113669","217484","8754","","","","","","","PsA","","534.683","5.550","-0.523","345.330756","-28.853960","K3III","K","1","","" }
{ "114469","114831","219586","8851","","","","","","","Cep","","379.252","5.550","0.222","348.907156","70.888080","F0IV","F","1","","" }
{ "115988","116354","221756","8947","","15    And","","15","","","And","","261.973","5.550","1.026","353.656418","40.236441","A1III","A","1","","" }
{ "116932","117299","223173","9010","","","","","","","Cas","","1606.682","5.550","-2.913","356.757987","57.451359","K3II","K","1","","" }
{ "84690","84949","157482","6469","","","","","","","Her","","241.240","5.550","1.205","260.431734","39.974649","F9Vn...","F","1","","" }
{ "95714","96014","184293","7427","","","","","","","Cyg","","461.978","5.550","-0.206","292.830590","50.306706","K1III","K","1","","" }
{ "102674","103005","198667","7985","","5    Aqr","","5","","","Aqr","","649.714","5.550","-0.946","313.036224","-5.507059","B9III","B","1","","" }
{ "103187","103519","199870","8035","","","","","","","Cyg","","258.649","5.550","1.054","314.581003","44.471711","G8III","G","1","","" }
{ "103842","104177","200702","8069","","Eta Mic","Eta","","Eta","","Mic","","712.132","5.550","-1.146","316.606310","-41.385965","K3III","K","1","","" }
{ "108427","108772","209481","8406","","14    Cep","","14","","","Cep","","3048.190","5.550","-4.303","330.519057","58.000366","O9V","O","1","","" }
{ "108522","108868","209396","8401","","30    Aqr","","30","","","Aqr","","303.684","5.550","0.705","330.818579","-6.522406","K0III","K","1","","" }
{ "55491","55657","99264","4406","","","","","","","Mus","","994.379","5.550","-1.871","171.046507","-72.256608","B2IV-V","B","1","","" }
{ "62413","62608","111315","4862","","","","","","","Mus","","467.273","5.550","-0.231","192.437315","-71.986260","G8Ib/II","G","1","","" }
{ "66845","67057","119605","5165","","83    Vir","","83","","","Vir","","823.627","5.550","-1.462","206.124277","-16.179072","G1IV/V","G","1","","" }
{ "69831","70054","125383","5362","","","","","","","Lup","","368.955","5.550","0.282","215.040434","-43.058843","G8III","G","1","","" }
{ "71193","71419","128068","5444","","","","","","","Lup","","699.906","5.550","-1.108","219.079327","-46.245451","K3III","K","1","","" }
{ "71611","71837","129336","5481","","32    Boo","","32","","","Boo","","403.160","5.550","0.090","220.431343","11.660662","G8III","G","1","","" }
{ "80238","80480","149681","6173","","","","","","","UMi","","139.861","5.550","2.389","246.431093","78.963854","F0V","F","1","","" }
{ "81504","81754","150453","6202","","","","","","","Oph","","137.156","5.550","2.431","250.473710","-19.924377","F3V","F","1","","" }
{ "81920","82171","150898","6219","","","","","","","Ara","","2695.507","5.550","-4.036","251.831919","-58.341441","B0Iab","B","1","","" }
{ "27886","27955","40091","2082","","","","","","","Col","","506.454","5.550","-0.406","88.718694","-39.957857","M0III","M","1","","" }
{ "30070","30143","44506","2288","","","","","","","Col","","1941.407","5.550","-3.323","95.150998","-34.144144","B3V","B","1","","" }
{ "30647","30720","45433","2335","","","","","","","Mon","","692.476","5.550","-1.085","96.814964","-0.275999","K5III","K","1","","" }
{ "30655","30728","45415","2333","","","","","","","Mon","","307.985","5.550","0.674","96.835212","2.908288","G9III","G","1","","" }
{ "34177","34267","53329","2660","","","","","","","Gem","","302.277","5.550","0.715","106.548326","34.473967","G8IV","G","1","","" }
{ "36156","36258","59256","2863","","","","","","","Pup","","921.346","5.550","-1.705","111.996506","-29.155896","B9Vsp...","B","1","","" }
{ "37414","37521","61913","2967","","","","","","","Gem","","1294.271","5.550","-2.443","115.513410","14.208503","M3Sv","M","1","","" }
{ "40679","40793","68375","3216","","","","","","","Cam","","280.444","5.550","0.878","124.884296","75.756907","G8III","G","1","","" }
{ "43373","43496","75737","3523","","15    Hya","","15","","","Hya","","446.178","5.550","-0.130","132.893380","-7.177226","A4m","A","1","","" }
{ "51985","52136","92095","4165","","","","","","","UMa","","453.625","5.550","-0.166","159.773715","53.668300","K3III","K","1","","" }
{ "29132","29205","42341","2183","","","","","","","Lep","","208.141","5.560","1.535","92.393852","-14.584619","K2III","K","1","","" }
{ "30248","30321","45669","2352","","Pi 1Dor","Pi-1","","Pi","1","Dor","","618.892","5.560","-0.831","95.659355","-69.984043","K5III","K","1","","" }
{ "33977","34065","53705","2667","Gl 264.1A","","","","","","Pup","","53.866","5.560","4.471","105.988918","-43.608039","G3V...","G","1","","Gl 264.1" }
{ "41283","41400","71250","3319","","27    Cnc","","27","","","Cnc","","900.984","5.560","-1.646","126.683082","12.654612","M3III","M","1","","" }
{ "42415","42535","74196","3448","","","","","","","Vel","","480.348","5.560","-0.281","130.072808","-53.015398","B7Vn","B","1","","" }
{ "44171","44299","77475","3600","","","","","","","Vel","","429.153","5.560","-0.036","135.336935","-41.864254","B5V","B","1","","" }
{ "45058","45189","79416","3661","","","","","","","Vel","","692.476","5.560","-1.075","138.127200","-43.613262","B8V","B","1","","" }
{ "45792","45924","81034","3726","","","","","","","Vel","","574.219","5.560","-0.668","140.462396","-42.194860","M3Ib","M","1","","" }
{ "46849","46982","82870","3814","","33    Hya","","33","","","Hya","","566.244","5.560","-0.638","143.636035","-5.914948","K1III","K","1","","" }
{ "47582","47717","84461","3875","","","","","","","Vel","","342.962","5.560","0.451","145.926091","-53.891282","A0V","A","1","","" }
{ "48173","48310","85656","3914","","","","","","","Car","","1090.824","5.560","-2.062","147.731629","-62.745116","K1IIICN...","K","1","","" }
{ "83435","83692","154733","6364","","","","","","","Her","","341.883","5.560","0.458","256.575214","22.084153","K4III","K","1","","" }
{ "86400","86667","161074","6602","","83    Her","","83","","","Her","","405.667","5.560","0.086","265.618188","24.564058","K4III","K","1","","" }
{ "89204","89482","167965","6845","","","","","","","Lyr","","591.935","5.560","-0.734","273.911573","42.159345","B7IV","B","1","","" }
{ "92591","92882","175317","7126","","","","","","","Sgr","","103.443","5.560","3.054","283.879194","-16.376635","F5/F6IV/V","F","1","","" }
{ "92758","93051","175869","7158","","64    Ser","","64","","","Ser","","1136.434","5.560","-2.151","284.319127","2.535346","B9IIIp...","B","1","","" }
{ "93701","93996","178175","7249","","","","","","","Sgr","","1294.271","5.560","-2.433","287.069593","-19.290289","B2V","B","1","","" }
{ "97650","97961","188485","7601","","","","","","","Vul","","470.644","5.560","-0.236","298.629479","24.319388","A0III","A","1","","" }
{ "4430","4440","5408","266","","","","","","","Cas","","538.212","5.560","-0.528","14.195654","60.362836","B8V","B","1","","" }
{ "5299","5310","6695","328","","79Psi2Psc","Psi-2","79","Psi","2","Psc","","154.284","5.560","2.186","16.988166","20.739113","A3V","A","1","","" }
{ "5554","5566","6960","342","","","","","","","Cas","","404.661","5.560","0.092","17.856418","64.202677","B9.5V","B","1","","" }
{ "13917","13951","18633","899","","5    Eri","","5","","","Eri","","362.396","5.560","0.331","44.921499","-2.464952","B9.5V","B","1","","" }
{ "16739","16780","22409","1098","","","","","","","Eri","","377.933","5.560","0.240","53.990274","-11.193782","G7III:","G","1","","" }
{ "17464","17506","23413","1150","","25    Eri","","25","","","Eri","","394.385","5.560","0.148","56.235408","-0.296720","K4III","K","1","","" }
{ "21690","21743","29737","1495","","","","","","","Eri","","350.329","5.560","0.405","70.028356","-24.482368","G6/G8III","G","1","","" }
{ "25544","25608","36187","1835","","","","","","","Col","","286.353","5.560","0.843","82.063891","-37.230767","A0V","A","1","","" }
{ "110589","110935","212728","8547","","","","","","","Ind","","140.645","5.560","2.387","337.156372","-67.489059","A3V","A","1","","" }
{ "114460","114822","219402","8840","","","","","","","Aqr","","232.305","5.560","1.297","348.892740","-3.496380","A3V","A","1","","" }
{ "114779","115142","219877","8868","","96    Aqr","","96","","","Aqr","","111.430","5.560","2.892","349.849903","-5.124352","F3IV","F","1","","" }
{ "115031","115395","220369","8894","","","","","","","Cas","","1716.613","5.560","-3.046","350.635536","60.133485","K3II","K","1","","" }
{ "115226","115591","220599","8903","","67    Peg","","67","","","Peg","","473.377","5.560","-0.249","351.211793","32.384882","B9III","B","1","","" }
{ "115381","115746","221525","8938","","","","","","","Cep","","333.152","5.560","0.514","351.749849","87.307504","A7IV","A","1","","" }
{ "56601","56770","101107","4477","","59    UMa","","59","","","UMa","","151.630","5.560","2.223","174.585843","43.625429","F2II-III","F","1","","" }
{ "57698","57870","103101","4551","","","","","","","Cen","","335.552","5.560","0.498","178.043048","-56.987741","B4III","B","1","","" }
{ "60547","60735","108323","4735","","","","","","","Hya","","507.242","5.560","-0.399","186.715378","-32.830121","B9V","B","1","","" }
{ "66541","66753","117374","5084","","Kap Oct","Kap","","Kap","","Oct","","273.163","5.560","0.945","205.233850","-85.786043","A2m...","A","1","","" }
{ "70269","70492","125835","5379","","","","","","","Cir","","2025.816","5.560","-3.406","216.276393","-68.195333","A3Ib","A","1","","" }
{ "75028","75257","137071","5726","","","","","","","Boo","","1941.407","5.560","-3.313","230.655714","39.581463","K4III","K","1","","" }
{ "61775","61968","110423","4829","","31    Vir","","31","","","Vir","","233.302","5.570","1.298","190.487991","6.806617","A2V","A","1","","" }
{ "63919","64122","114113","4957","","","","","","","Vir","","316.657","5.570","0.634","197.135278","-8.984385","K3III","K","1","","" }
{ "66430","66640","118889","5138","","","","","","","Boo","","195.655","5.570","1.680","204.894242","10.746269","F0V","F","1","","" }
{ "70020","70243","125745","5376","","","","","","","Cen","","1370.405","5.570","-2.547","215.582175","-34.786792","B8V","B","1","","" }
{ "76760","76996","137333","5729","","Rho Oct","Rho","","Rho","","Oct","","215.712","5.570","1.468","235.817419","-84.465273","A2V","A","1","","" }
{ "76812","77048","140716","5855","","9Pi  CrB","Pi","9","Pi","","CrB","","243.400","5.570","1.206","235.997098","32.515807","G9III:","G","1","","" }
{ "76927","77163","140775","5859","","","","","","","Ser","","369.792","5.570","0.297","236.347849","5.447315","A1V","A","1","","" }
{ "78913","79153","144480","5994","","Iot2Nor","Iot-2","","Iot","2","Nor","","279.963","5.570","0.902","242.327315","-57.934318","B9V","B","1","","" }
{ "81452","81702","150136","6187","","","","","","","Ara","","326156.378","5.570","-14.430","250.335063","-48.762957","O5","O","1","","" }
{ "530","531","144","7","","10    Cas","","10","","","Cas","","867.437","5.570","-1.554","1.610552","64.196168","B9III","B","1","","" }
{ "727","729","448","22","","87    Peg","","87","","","Peg","","285.102","5.570","0.862","2.260085","18.211963","G9III","G","1","","" }
{ "2705","2711","3158","140","Gl 22.2","","","","","","Phe","","83.118","5.570","3.539","8.615616","-52.373090","F3IV-V","F","1","","" }
{ "2935","2941","3443","159","Gl 25A","","","","","","Cet","","50.232","5.570","4.632","9.335902","-24.767267","K1V+...","K","1","","Gl 25" }
{ "3733","3741","4622","220","","","","","","","Cet","","342.962","5.570","0.461","12.004439","-21.722492","B9V","B","1","","" }
{ "5443","5454","6903","339","","81Psi3Psc","Psi-3","81","Psi","3","Psc","","376.624","5.570","0.258","17.455009","19.658408","G0III","G","1","","" }
{ "5577","5589","6972","345","","32    Cas","","32","","","Cas","","388.281","5.570","0.191","17.922428","65.018854","B9IV","B","1","","" }
{ "7950","7965","10221","478","","43    Cas","","43","","","Cas","","388.744","5.570","0.189","25.585314","68.043021","A0p SiSr","A","1","","" }
{ "9294","9313","12296","588","","","","","","","Phe","","293.306","5.570","0.801","29.911770","-42.030532","K1III","K","1","","" }
{ "10394","10418","14141","667","","Pi 1Hyi","Pi-1","","Pi","1","Hyi","","776.563","5.570","-1.314","33.560489","-67.841441","M1III","M","1","","" }
{ "10510","10535","13872","657","","21    Ari","","21","","","Ari","","166.576","5.570","2.029","33.928261","25.043043","F6V","F","1","","" }
{ "10918","10944","14392","682","","63    And","","63","","","And","","392.486","5.570","0.168","35.242481","50.151466","B9p Si","B","1","","" }
{ "16222","16263","21688","1062","","","","","","","Eri","","418.149","5.570","0.030","52.400113","-12.674737","A5III/IV","A","1","","" }
{ "22340","22393","30454","1529","","","","","","","Aur","","214.718","5.570","1.478","72.303520","31.437375","K2III","K","1","","" }
{ "31200","31277","46374","2391","","","","","","","Gem","","251.276","5.570","1.136","98.400686","14.155163","K2III:","K","1","","" }
{ "38044","38152","64067","3062","","","","","","","Car","","1090.824","5.570","-2.052","117.277993","-56.410360","G5II","G","1","","" }
{ "43778","43903","75958","3531","","6    UMa","","6","","","UMa","","306.826","5.570","0.703","134.156115","64.603831","G6III","G","1","","" }
{ "47035","47168","83069","3820","","","","","","","Leo","","572.204","5.570","-0.651","144.178549","31.161734","M2III","M","1","","" }
{ "51231","51376","90972","4118","","Del Ant","Del","","Del","","Ant","","434.296","5.570","-0.052","157.397422","-30.607065","B9/B9.5V","B","1","","" }
{ "51536","51685","91365","4137","","34    LMi","","34","","","LMi","","683.766","5.570","-1.037","158.378812","34.988695","A2Vn","A","1","","" }
{ "52910","53064","93875","4236","","42    UMa","","42","","","UMa","","272.478","5.570","0.960","162.848917","59.320119","K2III","K","1","","" }
{ "82669","82925","152849","6291","","24    Oph","","24","","","Oph","","303.684","5.570","0.725","254.200153","-23.150346","A0V","A","1","","" }
{ "85489","85749","158837","6524","","","","","","","Oph","","364.014","5.570","0.332","262.838891","2.724507","G8III","G","1","","" }
{ "88731","89008","166640","6807","","","","","","","Her","","393.909","5.570","0.160","272.495808","36.466284","G8III","G","1","","" }
{ "95268","95564","182629","7375","","50    Sgr","","50","","","Sgr","","431.424","5.570","-0.037","291.579811","-21.776693","K1/K2III","K","1","","" }
{ "95523","95822","183492","7407","","","","","","","Aql","","299.226","5.570","0.757","292.342307","14.596019","K0III","K","1","","" }
{ "102302","102633","198069","7953","","13    Del","","13","","","Del","","428.589","5.570","-0.023","311.951388","6.008209","A0V","A","1","","" }
{ "106087","106429","204960","8236","","","","","","","Gru","","653.620","5.570","-0.939","323.348008","-44.848700","K0III","K","1","","" }
{ "107174","107517","207052","8319","","48Lam Cap","Lam","48","Lam","","Cap","","281.655","5.570","0.889","326.633741","-11.365954","A1V","A","1","","" }
{ "107306","107649","207129","8323","Gl 838","","","","","","Gru","","52.168","5.570","4.550","327.065439","-47.303615","G2V","G","1","","" }
{ "108499","108845","209515","8407","","","","","","","Cyg","","492.683","5.570","-0.326","330.736105","44.649863","A0IV","A","1","","" }
{ "114260","114622","219134","8832","Gl 892","","","","","","Cas","","21.351","5.570","6.490","348.316473","57.168355","K3Vvar","K","1","","" }
{ "117709","118077","224355","9059","","","","","","","Cas","","231.481","5.570","1.315","359.285341","55.705705","G8Ib","G","1","","" }
{ "109391","109737","210848","8470","","","","","","","PsA","","252.443","5.580","1.136","333.435120","-25.180905","F7II","F","1","","" }
{ "114562","114924","219623","8853","GJ 4324","","","","","","Cas","","66.876","5.580","4.021","349.176081","53.213476","F7V","F","1","","" }
{ "114907","115271","220088","8882","","63    Peg","","63","","","Peg","","419.764","5.580","0.032","350.206456","30.414921","M0III","M","1","","" }
{ "31005","31079","46569","2400","","","","","","","Car","","120.397","5.580","2.744","97.826163","-51.825953","F8V","F","1","","" }
{ "34950","35044","56160","2750","","","","","","","CMa","","271.797","5.580","0.976","108.713185","-27.037996","K3III","K","1","","" }
{ "37098","37204","60986","2924","","70    Gem","","70","","","Gem","","371.900","5.580","0.295","114.636907","35.048550","K0III","K","1","","" }
{ "37334","37441","61363","2939","","","","","","","Lyn","","314.216","5.580","0.661","115.301728","48.131533","K0III","K","1","","" }
{ "40829","40944","70442","3279","","","","","","","Pup","","567.228","5.580","-0.622","125.338428","-20.079058","A3V","A","1","","" }
{ "41261","41377","71093","3304","","22Phi1Cnc","Phi-1","22","Phi","1","Cnc","","373.177","5.580","0.288","126.615449","27.893583","K5III","K","1","","" }
{ "47827","47963","84816","3886","","","","","","","Vel","","997.420","5.580","-1.847","146.626556","-44.755060","B2.5IV","B","1","","" }
{ "50995","51140","90677","4107","","","","","","","Vel","","2025.816","5.580","-3.386","156.703862","-54.877302","K3II/III","K","1","","" }
{ "51219","51364","90957","4117","","","","","","","Hya","","359.203","5.580","0.370","157.370744","-29.663832","K3III","K","1","","" }
{ "54169","54327","96706","4329","","","","","","","Car","","823.627","5.580","-1.432","166.707983","-70.877930","B2V","B","1","","" }
{ "55599","55765","99285","4408","","81    Leo","","81","","","Leo","","143.239","5.580","2.367","171.401571","16.456539","F2V","F","1","","" }
{ "57937","58110","103484","4559","","6    Vir","","6","","","Vir","","171.481","5.580","1.976","178.763057","8.443943","K0III:","K","1","","" }
{ "61103","61296","109272","4779","","","","","","","Crv","","160.985","5.580","2.113","188.392746","-12.830203","G8III/IV","G","1","","" }
{ "63535","63738","113415","4935","Gl 496A","","","","","","Vir","","92.004","5.580","3.328","195.942123","-20.583497","F7V","F","1","","Gl 496" }
{ "70568","70791","127243","5420","","24    Boo","","24","","","Boo","","326.156","5.580","0.580","217.157960","49.844851","G3IV","G","1","","" }
{ "124","124","224893","9085","","","","","","","Cas","","3076.947","5.580","-4.293","0.404239","61.222801","F0III","F","1","","" }
{ "1916","1921","1976","91","","","","","","","Cas","","1000.480","5.580","-1.854","6.065218","52.019914","B5IV","B","1","","" }
{ "5155","5164","6530","317","","28    Cet","","28","","","Cet","","589.794","5.580","-0.706","16.521450","-9.839354","A1V","A","1","","" }
{ "7664","7679","10148","473","","","","","","","Cet","","252.053","5.580","1.140","24.715764","-21.275384","F0V","F","1","","" }
{ "10706","10732","14191","669","","22The Ari","The","22","The","","Ari","","447.402","5.580","-0.106","34.531404","19.901164","A1Vn","A","1","","" }
{ "13668","13702","18256","869","","46Rho3Ari","Rho-3","46","Rho","3","Ari","","115.290","5.580","2.838","44.108943","18.023119","F6V","F","1","","" }
{ "16170","16210","21362","1037","","","","","","","Per","","524.367","5.580","-0.451","52.218000","49.848384","B6Vn","B","1","","" }
{ "20169","20219","27397","1351","","57    Tau","","57","","","Tau","","149.066","5.580","2.280","64.990425","14.035201","F3V...","F","1","","" }
{ "20943","20995","28485","1422","","80    Tau","","80","","","Tau","","149.476","5.580","2.274","67.535815","15.637840","F0V...","F","1","","" }
{ "22478","22531","31203","1563","","Iot Pic","Iot","","Iot","","Pic","","135.560","5.580","2.486","72.730584","-53.461508","F0IV...","F","1","","" }
{ "87298","87569","162587","6658","","","","","","","Sco","","823.627","5.580","-1.432","268.347800","-34.895125","K3III","K","1","","" }
{ "89209","89487","166599","6805","","","","","","","Pav","","294.631","5.580","0.801","273.919342","-63.055366","K0III/IV","K","1","","" }
{ "89981","90260","169233","6888","","18    Sgr","","18","","","Sgr","","639.522","5.580","-0.882","276.255992","-30.756570","K0III","K","1","","" }
{ "92438","92728","175426","7131","","11Del1Lyr","Del-1","11","Del","1","Lyr","","991.357","5.580","-1.834","283.431497","36.971721","B2.5V","B","1","","" }
{ "92581","92872","175515","7135","","","","","","","Aql","","287.870","5.580","0.851","283.864357","6.615290","G9III","G","1","","" }
{ "94329","94624","180262","7300","","","","","","","Aql","","692.476","5.580","-1.055","288.833709","15.083651","G8II-III","G","1","","" }
{ "99786","100108","193369","7769","","36    Cyg","","36","","","Cyg","","203.848","5.580","1.601","304.619372","36.999803","A2V","A","1","","" }
{ "100111","100437","194152","7798","","","","","","","Cyg","","405.163","5.580","0.109","305.522338","45.794994","K0IIIvar","K","1","","" }
{ "105071","105411","203344","8165","","","","","","","Peg","","270.445","5.580","0.987","320.268254","23.855966","K1III","K","1","","" }
{ "109006","109352","210354","8449","","27Pi 1Peg","Pi-1","27","Pi","1","Peg","","288.634","5.580","0.845","332.306835","33.172337","G6III:","G","1","","" }
{ "94432","94727","180482","7303","","22    Aql","","22","","","Aql","","536.441","5.590","-0.490","289.129298","4.834795","A3IV","A","1","","" }
{ "94691","94986","180885","7316","","","","","","","Sgr","","900.984","5.590","-1.616","289.916638","-35.421452","B4III","B","1","","" }
{ "94782","95077","181240","7327","","","","","","","Sgr","","180.596","5.590","1.874","290.158957","-22.402535","A6:m...","A","1","","" }
{ "95876","96178","183806","7416","","","","","","","Tel","","396.784","5.590","0.164","293.340103","-45.271748","A0p","A","1","","" }
{ "99937","100261","194258","7804","","","","","","","Dra","","669.726","5.590","-0.972","305.024975","68.880317","M5III","M","1","","" }
{ "101389","101716","196504","7880","","27    Vul","","27","","","Vul","","317.582","5.590","0.648","309.269467","26.461947","B9V","B","1","","" }
{ "101922","102253","197950","7945","","4    Cep","","4","","","Cep","","139.562","5.590","2.433","310.795826","66.657447","A8V","A","1","","" }
{ "103198","103530","199955","8040","","","","","","","Cyg","","1079.988","5.590","-2.010","314.625130","50.461791","B5Vn","B","1","","" }
{ "105428","105769","204153","8208","","","","","","","Cyg","","109.155","5.590","2.967","321.331243","46.714341","F0V","F","1","","" }
{ "58151","58326","103884","4573","","","","","","","Cru","","610.780","5.590","-0.772","179.416767","-62.448748","B3V","B","1","","" }
{ "58252","58427","104035","4578","","","","","","","Cru","","326156.378","5.590","-14.410","179.698605","-64.339560","A3Ib","A","1","","" }
{ "58479","58654","104438","4593","","","","","","","UMa","","335.207","5.590","0.531","180.414518","36.042086","K0III","K","1","","" }
{ "63769","63972","113778","4941","","","","","","","Cen","","344.410","5.590","0.472","196.646138","-41.588443","K0II/III","K","1","","" }
{ "72606","72833","130458","5520","","","","","","","Aps","","329.451","5.590","0.568","223.306448","-73.190071","G5III","G","1","","" }
{ "73613","73841","133962","5627","","47    Boo","","47","","","Boo","","274.312","5.590","0.966","226.357723","48.150972","A1V","A","1","","" }
{ "74721","74950","135876","5687","","","","","","","Lup","","547.242","5.590","-0.534","229.734909","-40.788222","B9V","B","1","","" }
{ "77870","78106","142630","5926","","Xi 2Lup","Xi-2","","Xi","2","Lup","","150.233","5.590","2.273","239.225487","-33.964281","B9V","B","1","","" }
{ "117315","117683","223719","9033","","22    Psc","","22","","","Psc","","748.065","5.590","-1.213","357.990995","2.930384","K4II","K","1","","" }
{ "117909","118277","224630","9073","","","","","","","Scl","","737.910","5.590","-1.183","359.866237","-29.485168","K5III","K","1","","" }
{ "31378","31457","47144","2424","","","","","","","Col","","509.619","5.590","-0.379","98.850914","-36.779879","A0V","A","1","","" }
{ "33488","33575","52018","2616","","","","","","","CMa","","862.848","5.590","-1.523","104.649581","-25.414157","B2V","B","1","","" }
{ "35517","35615","57478","2796","","","","","","","CMa","","602.877","5.590","-0.744","110.242857","-14.360489","G8/K0III","G","1","","" }
{ "36617","36723","60111","2887","","8Del2CMi","Del-2","8","Del","2","CMi","","136.182","5.590","2.487","113.298608","3.290379","F2V","F","1","","" }
{ "38795","38908","65907","3138","Gl 294A","","","","","","Car","","52.853","5.590","4.542","119.444195","-60.303072","G2V...","G","1","","Gl 294" }
{ "40563","40678","70002","3266","","","","","","","Pup","","411.814","5.590","0.084","124.572475","-35.451703","K2III","K","1","","" }
{ "43376","43499","76113","3536","","","","","","","Car","","737.910","5.590","-1.183","132.902180","-57.633577","B8III","B","1","","" }
{ "44872","45001","78922","3644","","Eps Pyx","Eps","","Eps","","Pyx","","211.928","5.590","1.526","137.485043","-30.365401","A4IV","A","1","","" }
{ "49427","49569","87808","3977","","","","","","","Hya","","382.364","5.590","0.245","151.789578","-17.141733","K4III","K","1","","" }
{ "50099","50241","89062","4036","","","","","","","Vel","","507.242","5.590","-0.369","153.881506","-43.112369","K4III","K","1","","" }
{ "51344","51491","91120","4123","","","","","","","Hya","","522.686","5.590","-0.434","157.749326","-13.588470","B8/B9IV/V","B","1","","" }
{ "377","377","225253","9108","","","","","","","Tuc","","572.204","5.590","-0.631","1.171961","-71.436891","B8III","B","1","","" }
{ "2491","2497","2774","124","","","","","","","Cas","","381.024","5.590","0.252","7.921578","52.839526","K2III","K","1","","" }
{ "3841","3849","4730","227","","","","","","","Cet","","277.580","5.590","0.940","12.356725","-13.561274","K3III","K","1","","" }
{ "4273","4283","4853","240","","","","","","","Cep","","286.102","5.590","0.875","13.719999","83.707435","A4V","A","1","","" }
{ "4760","4770","6055","288","","Xi  Scl","Xi","","Xi","","Scl","","513.632","5.590","-0.396","15.326102","-38.916527","K1III","K","1","","" }
{ "9553","9573","12301","589","","53    Cas","","53","","","Cas","","1753.529","5.590","-3.062","30.750783","64.390018","B8Ib","B","1","","" }
{ "13631","13665","17948","860","GJ 3188","","","","","","Cas","","87.114","5.590","3.457","43.986782","61.521138","F4V","F","1","","" }
{ "17353","17395","23281","1139","","","","","","","Eri","","138.378","5.590","2.452","55.890974","-10.485661","A5m","A","1","","" }
{ "19047","19095","25945","1275","GJ 9143","","","","","","Eri","","146.917","5.590","2.322","61.405920","-27.651807","F0IV/V","F","1","","" }
{ "21426","21479","29712","1492","","","","","","","Dor","","178.130","5.590","1.903","69.190157","-62.077154","M8e","M","1","","" }
{ "5614","5626","6798","333","","","","","","","Cep","","270.221","5.600","1.009","18.069022","79.673963","A3V","A","1","","" }
{ "6500","6514","8374","395","","47    And","","47","","","And","","208.274","5.600","1.574","20.919181","37.714943","A1m","A","1","","" }
{ "10697","10723","14214","672","","","","","","","Cet","","79.434","5.600","3.667","34.505999","1.757802","G0.5IV","G","1","","" }
{ "17418","17460","23193","1133","","","","","","","Per","","295.431","5.600","0.815","56.130937","36.460103","A2m","A","1","","" }
{ "24112","24169","33664","1693","","","","","","","Lep","","486.075","5.600","-0.266","77.845295","-11.849089","M6.2III","M","1","","" }
{ "25266","25329","35536","1799","","","","","","","Ori","","436.622","5.600","-0.033","81.257267","-10.328887","K5III","K","1","","" }
{ "26028","26093","36653","1864","","35    Ori","","35","","","Ori","","446.178","5.600","-0.080","83.476183","14.305578","B3V","B","1","","" }
{ "26150","26215","36881","1883","","","","","","","Ori","","1120.812","5.600","-2.081","83.805165","10.240093","B9IIIMNp...","B","1","","" }
{ "27560","27629","39004","2013","","","","","","","Tau","","349.204","5.600","0.452","87.742125","27.967861","G7III:","G","1","","" }
{ "27673","27743","39317","2033","","137    Tau","","137","","","Tau","","424.130","5.600","0.030","88.092883","14.171787","B9p...","B","1","","" }
{ "110639","110986","213119","8562","","36    Peg","","36","","","Peg","","596.264","5.600","-0.710","337.283260","9.129034","K5III","K","1","","" }
{ "112921","113281","216916","8725","","16    Lac","","16","","","Lac","","1274.048","5.600","-2.359","344.098460","41.603876","B2IV","B","1","","" }
{ "113893","114254","218434","8802","","","","","","","Scl","","268.884","5.600","1.019","347.087796","-28.823697","G8III","G","1","","" }
{ "115255","115620","220572","8901","","","","","","","Tuc","","290.433","5.600","0.852","351.330935","-56.848985","K0III","K","1","","" }
{ "115405","115770","220974","8918","","","","","","","Cep","","213.174","5.600","1.523","351.818703","70.359782","A6IV","A","1","","" }
{ "118164","","","","Gl 105.4B","","","","","","Cet","","88.174","5.600","3.440","39.891943","-11.871068","F5 V","F","2","12357","Gl 105.4" }
{ "118645","","","","Gl 366.1B","","","","","","Ant","","384.165","5.600","0.245","146.049044","-27.769033","F8 V","F","2","47623","Gl 366.1" }
{ "84143","84401","155806","6397","","","","","","","Sco","","326156.378","5.600","-14.400","258.830197","-33.548420","O9","O","1","","" }
{ "92094","92382","173861","7068","","Eta2CrA","Eta-2","","Eta","2","CrA","","481.767","5.600","-0.247","282.395818","-43.434102","B9IV","B","1","","" }
{ "95264","95560","182919","7390","","5    Vul","","5","","","Vul","","237.723","5.600","1.287","291.555191","20.097733","A0V","A","1","","" }
{ "97446","97757","188209","7589","","","","","","","Cyg","","326156.378","5.600","-14.400","297.996125","47.027339","O9.5Ia","O","1","","" }
{ "97669","97980","188350","7596","","58    Aql","","58","","","Aql","","371.476","5.600","0.317","298.686654","0.273627","A0III","A","1","","" }
{ "100143","100469","193571","7779","","Kap1Sgr","Kap-1","","Kap","1","Sgr","","215.712","5.600","1.498","305.614577","-42.049548","A0V","A","1","","" }
{ "102304","102635","198345","7969","","","","","","","Cyg","","586.612","5.600","-0.675","311.955371","47.831869","K5III","K","1","","" }
{ "104034","104371","201433","8094","","","","","","","Cyg","","377.496","5.600","0.283","317.162031","30.205637","B9V","B","1","","" }
{ "108346","108691","209128","8390","","28    Aqr","","28","","","Aqr","","715.255","5.600","-1.105","330.270896","0.604715","K4III:","K","1","","" }
{ "59319","59501","106057","4643","","5    Com","","5","","","Com","","425.236","5.600","0.024","183.038712","20.542064","K0II-III","K","1","","" }
{ "64867","65072","116010","5032","","23    CVn","","23","","","CVn","","508.824","5.600","-0.366","200.079007","40.150548","K1III","K","1","","" }
{ "65989","66198","118214","5109","","81    UMa","","81","","","UMa","","298.678","5.600","0.791","203.530475","55.348434","A0V","A","1","","" }
{ "81777","82028","151203","6227","","","","","","","Her","","453.625","5.600","-0.116","251.343830","15.745289","M3III","M","1","","" }
{ "30269","30342","45229","2320","","Nu  Pic","Nu","","Nu","","Pic","","157.411","5.600","2.182","95.732688","-56.369969","Am","A","1","","" }
{ "31090","31167","46304","2386","","","","","","","Mon","","136.467","5.600","2.492","98.096371","-5.868820","F0Vnn+...","F","1","","" }
{ "32445","32531","49877","2526","","","","","","","Car","","601.764","5.600","-0.730","101.827956","-55.539988","K5III","K","1","","" }
{ "36085","36186","58954","2853","","","","","","","CMa","","301.160","5.600","0.773","111.783290","-17.864861","F2V","F","1","","" }
{ "36285","36388","59311","2865","","","","","","","Mon","","2233.948","5.600","-3.578","112.327786","-1.905329","K5III","K","1","","" }
{ "37516","37623","62578","2994","","","","","","","Pup","","626.020","5.600","-0.816","115.799941","-36.050089","B5V","B","1","","" }
{ "38145","38253","63752","3047","","","","","","","Mon","","1199.104","5.600","-2.227","117.544069","-9.183441","K3III","K","1","","" }
{ "39066","39177","65759","3128","","3    Cnc","","3","","","Cnc","","793.568","5.600","-1.331","120.197115","17.308703","K3III","K","1","","" }
{ "41259","41375","71297","3321","","2    Hya","","2","","","Hya","","163.160","5.600","2.104","126.613369","-3.987479","A5III-IV","A","1","","" }
{ "44755","44883","78556","3630","","19    Hya","","19","","","Hya","","614.230","5.600","-0.775","137.175748","-8.589524","B9.5III","B","1","","" }
{ "46088","46221","81420","3738","","28    Hya","","28","","","Hya","","898.502","5.600","-1.600","141.350148","-5.117394","K5III","K","1","","" }
{ "50901","51046","90362","4092","","","","","","","Sex","","396.784","5.600","0.174","156.434466","-7.059829","M0.5III","M","1","","" }
{ "30363","30436","45018","2311","","","","","","","CMa","","1012.908","5.610","-1.851","95.982983","-25.577629","K5III","K","1","","" }
{ "31814","31897","50506","2559","","Zet Men","Zet","","Zet","","Men","","413.904","5.610","0.093","100.012107","-80.813593","A5III","A","1","","" }
{ "38092","38200","63852","3052","","","","","","","Pup","","758.503","5.610","-1.223","117.397528","-33.288950","M0III","M","1","","" }
{ "41094","41211","70958","3297","Gl 306","1    Hya","","1","","","Hya","","86.813","5.610","3.484","126.145895","-3.751240","F3V","F","1","","" }
{ "41605","41723","72227","3362","","","","","","","Pyx","","1055.522","5.610","-1.940","127.619218","-32.159285","K3III","K","1","","" }
{ "45788","45920","81157","3732","","","","","","","Vel","","264.737","5.610","1.063","140.458630","-55.514686","A3IVs...","A","1","","" }
{ "47435","47570","83805","3851","","43    Lyn","","43","","","Lyn","","347.344","5.610","0.473","145.501465","39.757851","G8III","G","1","","" }
{ "50863","51008","90254","4088","","44    Leo","","44","","","Leo","","1025.649","5.610","-1.878","156.313312","8.784845","M2IIIs","M","1","","" }
{ "52811","52965","93905","4238","","","","","","","Ant","","431.995","5.610","0.000","162.487594","-34.058183","A1V","A","1","","" }
{ "85660","85922","159170","6534","","","","","","","Oph","","156.881","5.610","2.199","263.374354","-5.744803","A5V","A","1","","" }
{ "86775","87044","161833","6627","","","","","","","Her","","466.604","5.610","-0.168","266.783524","17.697014","A1V","A","1","","" }
{ "89648","89925","168913","6876","","108    Her","","108","","","Her","","183.234","5.610","1.862","275.237374","29.858925","A5m","A","1","","" }
{ "108348","108693","209166","8392","","20    Peg","","20","","","Peg","","251.858","5.610","1.171","330.272285","13.119823","F4III","F","1","","" }
{ "1724","1728","1760","85","","","","","","","Cet","","881.504","5.610","-1.549","5.442797","-20.058024","M5/M6Ib/II","M","1","","" }
{ "9601","9622","12642","611","","","","","","","Cet","","541.788","5.610","-0.492","30.918701","-4.103516","K5Iab:","K","1","","" }
{ "15116","15154","20149","971","","","","","","","Ari","","521.017","5.610","-0.407","48.835158","30.556689","A1Vs","A","1","","" }
{ "18600","18647","25165","1235","","","","","","","Eri","","734.586","5.610","-1.153","59.875549","-12.574425","K4III","K","1","","" }
{ "20870","20922","28497","1423","","","","","","","Eri","","1517.006","5.610","-2.728","67.278856","-13.048370","B2V:ne","B","1","","" }
{ "23499","23554","32667","1645","","","","","","","Lep","","189.736","5.610","1.786","75.971960","-24.388151","A2IV","A","1","","" }
{ "112504","112864","216380","8696","","","","","","","Cep","","237.205","5.610","1.302","342.844020","61.696740","G2IV+...","G","1","","" }
{ "62921","63121","112412","4914","","12Alp1CVn","Alp-1","12","Alp","1","CVn","Cor Caroli B","120.353","5.610","2.775","194.002020","38.314912","F0V","F","1","","" }
{ "66446","66656","118799","5136","","","","","","","Cen","","496.433","5.610","-0.302","204.952325","-40.051708","K2/K3III","K","1","","" }
{ "67171","67384","120420","5195","","","","","","","CVn","","284.356","5.610","0.908","207.161401","31.190206","K0III","K","1","","" }
{ "69376","69598","124433","5318","","","","","","","Cen","","445.569","5.610","-0.067","213.677862","-41.837495","G8III","G","1","","" }
{ "72097","72323","130158","5514","","55    Hya","","55","","","Hya","","742.953","5.610","-1.178","221.843980","-25.624267","B9IV/V","B","1","","" }
{ "77050","77286","140784","5860","","","","","","","Lup","","384.618","5.610","0.252","236.684245","-34.682454","B8V","B","1","","" }
{ "78040","78276","143435","5957","","","","","","","CrB","","763.832","5.610","-1.238","239.740458","36.643773","K5III","K","1","","" }
{ "79448","79689","145782","6040","","","","","","","Nor","","423.030","5.610","0.045","243.957517","-57.912350","A5III","A","1","","" }
{ "80707","80953","149303","6162","","","","","","","Her","","226.027","5.610","1.406","247.946791","45.598281","A4Vn","A","1","","" }
{ "57618","57791","102928","4544","","","","","","","Vir","","298.132","5.620","0.815","177.759297","-5.333332","K0IV","K","1","","" }
{ "72884","73111","131657","5559","","","","","","","Lup","","551.872","5.620","-0.522","224.133592","-47.879198","B+...","B","1","","" }
{ "74461","74689","135559","5679","","4    Ser","","4","","","Ser","","150.510","5.620","2.299","228.954488","0.372139","A4V","A","1","","" }
{ "79118","79358","145849","6046","","","","","","","CrB","","675.272","5.620","-0.960","242.950232","36.425094","K3III SB","K","1","","" }
{ "81483","81733","150168","6188","","","","","","","Ara","","2188.969","5.620","-3.514","250.417608","-49.651552","B1II","B","1","","" }
{ "4577","4587","5722","279","","23Phi4Cet","Phi-4","23","Phi","4","Cet","","319.761","5.620","0.663","14.682784","-11.379975","G7III","G","1","","" }
{ "7331","7345","9672","451","","49    Cet","","49","","","Cet","","193.679","5.620","1.752","23.657403","-15.676359","A1V","A","1","","" }
{ "14109","14143","18883","910","","93    Cet","","93","","","Cet","","550.011","5.620","-0.515","45.593824","4.352884","B7V","B","1","","" }
{ "15345","15383","20559","992","","95    Cet","","95","","","Cet","","219.044","5.620","1.484","49.593440","-0.930288","K1IV","K","1","","" }
{ "16449","16489","20084","965","","","","","","","Cep","","336.244","5.620","0.554","53.082297","84.911040","G3IIp...","G","1","","" }
{ "18424","18471","24740","1218","","32    Tau","","32","","","Tau","","138.085","5.620","2.486","59.216972","22.477971","F2IV","F","1","","" }
{ "18963","19011","25723","1265","","","","","","","Eri","","384.618","5.620","0.262","61.094648","-12.792295","K1III","K","1","","" }
{ "26817","26882","37289","1916","","","","","","","Cam","","272.706","5.620","1.009","85.610200","65.697649","K5III","K","1","","" }
{ "27697","27766","39720","2053","","","","","","","Col","","321.971","5.620","0.648","88.138252","-37.631063","K1III","K","1","","" }
{ "27869","27938","39853","2065","","","","","","","Lep","","662.919","5.620","-0.920","88.681790","-11.774192","K3 comp","K","1","","" }
{ "29643","29716","43318","2233","","","","","","","Ori","","121.293","5.620","2.768","93.892771","-0.512189","F6V","F","1","","" }
{ "30371","30444","45145","2316","","","","","","","Col","","331.123","5.620","0.587","96.004214","-36.707764","K1II/III","K","1","","" }
{ "31285","31362","46936","2415","","","","","","","CMa","","526.059","5.620","-0.418","98.647212","-32.716255","B9V","B","1","","" }
{ "32299","32385","49131","2501","","","","","","","CMa","","1896.258","5.620","-3.202","101.379954","-30.948980","B+...","B","1","","" }
{ "37644","37751","62747","3004","","","","","","","Pup","","2588.543","5.620","-3.878","116.142376","-24.674079","B2II","B","1","","" }
{ "38266","38375","64152","3068","","","","","","","Pup","","305.676","5.620","0.761","117.929280","-21.173662","K0III","K","1","","" }
{ "38542","38656","65273","3105","","","","","","","Car","","337.287","5.620","0.547","118.722301","-57.302806","K3/K4III","K","1","","" }
{ "40126","40240","68351","3215","","15    Cnc","","15","","","Cnc","","683.766","5.620","-0.987","123.286952","29.656536","B9p SiCr","B","1","","" }
{ "42676","42795","74228","3450","","45    Cnc","","45","","","Cnc","","926.581","5.620","-1.647","130.801372","12.680876","A3V+...","A","1","","" }
{ "47066","47199","83380","3833","","","","","","","Ant","","279.722","5.620","0.953","144.291200","-32.178646","K1III","K","1","","" }
{ "48211","48348","85563","3910","","","","","","","Vel","","323.247","5.620","0.639","147.832221","-46.193871","K2III","K","1","","" }
{ "87506","87777","163547","6687","","","","","","","Her","","434.875","5.620","-0.005","268.961710","22.464221","K3III","K","1","","" }
{ "90857","91139","171745","6980","","","","","","","Her","","470.644","5.620","-0.176","278.876653","23.605530","G8III","G","1","","" }
{ "92677","92969","176598","7187","","","","","","","Dra","","313.612","5.620","0.705","284.107214","65.258084","G8III","G","1","","" }
{ "98548","98863","190603","7678","","","","","","","Cyg","","326156.378","5.620","-14.380","301.150729","32.218598","B1.5Ia comp","B","1","","" }
{ "107430","107773","207229","8331","","","","","","","Ind","","337.986","5.620","0.543","327.500534","-64.712537","K1III","K","1","","" }
{ "108735","109081","209529","8409","","Kap2Ind","Kap-2","","Kap","2","Ind","","491.199","5.620","-0.269","331.462434","-59.636072","K4III","K","1","","" }
{ "110160","110506","212132","8524","","Pi 2Gru","Pi-2","","Pi","2","Gru","","130.463","5.620","2.610","335.783030","-45.928488","F3III-IV","F","1","","" }
{ "113771","114132","218242","8790","","Ups Gru","Ups","","Ups","","Gru","","284.853","5.620","0.914","346.723414","-38.892293","A0V","A","1","","" }
{ "115404","115769","220790","8909","","","","","","","Tuc","","314.216","5.630","0.711","351.812352","-58.476110","G8III","G","1","","" }
{ "115989","116355","221758","8948","","73    Peg","","73","","","Peg","","290.175","5.630","0.884","353.659183","33.497328","K0III:","K","1","","" }
{ "119127","","154906","6370","GJ 9584A","21Mu  Dra","Mu","21","Mu","","Dra","Alrakis","75.850","5.630","3.797","256.330705","54.469093","F7 V","F","1","","GJ 9584" }
{ "28742","28814","41380","2145","","66    Ori","","66","","","Ori","","326156.378","5.630","-14.370","91.243167","4.158671","G4III","G","1","","" }
{ "33998","34086","53208","2655","","","","","","","Mon","","1240.138","5.630","-2.270","106.021867","-5.323979","K3III","K","1","","" }
{ "36425","36528","58425","2830","","","","","","","Cam","","448.633","5.630","-0.062","112.719575","68.465621","K2III","K","1","","" }
{ "40531","40646","68930","3235","","29    Lyn","","29","","","Lyn","","299.501","5.630","0.815","124.460070","59.571133","A7IV","A","1","","" }
{ "40718","40834","71066","3302","","Kap2Vol","Kap-2","","Kap","2","Vol","","418.686","5.630","0.088","125.002286","-71.505377","A0p","A","1","","" }
{ "42319","42438","72905","3391","Gl 311","3Pi 1UMa","Pi-1","3","Pi","1","UMa","","46.821","5.630","4.845","129.798859","65.020907","G1.5Vb","G","1","","" }
{ "42798","42917","74521","3465","","49    Cnc","","49","","","Cnc","","423.030","5.630","0.065","131.187653","10.081670","A1p...","A","1","","" }
{ "52256","52407","92845","4194","","","","","","","Ant","","610.780","5.630","-0.732","160.679961","-32.715673","A0V","A","1","","" }
{ "56341","56510","100615","4457","","","","","","","UMa","","438.972","5.630","-0.015","173.770430","54.785419","K0III","K","1","","" }
{ "60826","61015","108821","4759","","","","","","","Crv","","982.399","5.630","-1.764","187.572696","-23.696419","M0III","M","1","","" }
{ "63800","64003","113852","4947","","","","","","","Cen","","250.504","5.630","1.203","196.726039","-35.862033","A0V","A","1","","" }
{ "66229","66438","118261","5113","","","","","","","Cen","","116.526","5.630","2.865","204.301201","-61.691856","F6V","F","1","","" }
{ "66551","66763","119126","5149","","2    Boo","","2","","","Boo","","335.897","5.630","0.566","205.259785","22.495768","G9III","G","1","","" }
{ "72347","72573","133002","5596","GJ 3876","","","","","","UMi","","141.193","5.630","2.448","222.582212","82.511944","F9V","F","1","","" }
{ "72873","73100","132254","5581","GJ 3880","","","","","","Boo","","81.887","5.630","3.631","224.095854","49.628449","F7V","F","1","","" }
{ "77748","77984","142445","5917","","4    Sco","","4","","","Sco","","408.206","5.630","0.143","238.875342","-26.265993","A3V","A","1","","" }
{ "78767","79007","144874","6004","","45    Ser","","45","","","Ser","","322.927","5.630","0.652","241.906411","9.891743","A7V","A","1","","" }
{ "80761","81007","149121","6158","","28    Her","","28","","","Her","","385.984","5.630","0.264","248.148688","5.521220","B9.5III","B","1","","" }
{ "7810","7825","10204","476","","","","","","","And","","226.970","5.630","1.417","25.165105","43.297687","A9IV:","A","1","","" }
{ "7928","7943","10390","490","","","","","","","Tri","","274.774","5.630","1.002","25.514516","35.245707","B9IV-V","B","1","","" }
{ "8347","8362","10780","511","Gl 75","","","","","","Cas","","32.836","5.630","5.615","26.935016","63.852501","K0V","K","1","","" }
{ "15441","15479","20729","1004","","","","","","","For","","976.516","5.630","-1.751","49.895444","-24.122902","M1III","M","1","","" }
{ "83378","83635","154445","6353","","","","","","","Oph","","1116.974","5.630","-2.043","256.384414","-0.892070","B1V","B","1","","" }
{ "85455","85715","158974","6528","","","","","","","Her","","394.385","5.630","0.218","262.730722","31.158139","G8III","G","1","","" }
{ "90261","90541","169853","6910","","","","","","","CrA","","411.294","5.630","0.126","277.112974","-38.995671","A2m...","A","1","","" }
{ "90406","90687","170433","6933","","","","","","","Sgr","","294.099","5.630","0.855","277.549428","-18.728794","K0III","K","1","","" }
{ "93205","93498","176704","7195","","","","","","","Sgr","","257.627","5.630","1.142","285.615323","-24.846826","K2III","K","1","","" }
{ "93423","93718","177808","7237","","","","","","","Lyr","","618.892","5.630","-0.761","286.241114","31.744072","M0III","M","1","","" }
{ "97560","97871","188041","7575","","","","","","","Aql","","261.343","5.630","1.111","298.328065","-3.114464","A5pvar","A","1","","" }
{ "100581","100907","195050","7826","","40    Cyg","","40","","","Cyg","","265.600","5.630","1.076","306.892756","38.440332","A3V","A","1","","" }
{ "103696","104031","200644","8066","","3    Equ","","3","","","Equ","","769.237","5.630","-1.233","316.144383","5.502862","K5III","K","1","","" }
{ "105235","105576","203475","8172","","","","","","","Cap","","774.718","5.630","-1.249","320.752054","-22.669048","M0III","M","1","","" }
{ "107232","107575","207203","8328","","11    Peg","","11","","","Peg","","569.208","5.630","-0.579","326.808175","2.686124","A1V","A","1","","" }
{ "82932","83187","153053","6297","","","","","","","Ara","","168.993","5.640","2.068","255.026177","-54.597179","A3V","A","1","","" }
{ "90034","90313","169689","6902","","","","","","","Oph","","787.817","5.640","-1.275","276.411662","8.032006","G8III-IV+..","G","1","","" }
{ "92478","92768","175443","7132","","","","","","","Lyr","","363.203","5.640","0.406","283.555199","27.909528","K4III","K","1","","" }
{ "96104","96406","184552","7431","","51    Sgr","","51","","","Sgr","","294.365","5.640","0.863","294.006887","-24.719081","A1m...","A","1","","" }
{ "96500","96807","185762","7480","","45    Aql","","45","","","Aql","","352.221","5.640","0.473","295.180501","-0.621233","A3IV","A","1","","" }
{ "100264","100591","193807","7787","","Kap2Sgr","Kap-2","","Kap","2","Sgr","","311.515","5.640","0.740","305.971585","-42.422868","A3V","A","1","","" }
{ "104305","104642","202214","8119","","","","","","","Cep","","326156.378","5.640","-14.360","317.950994","59.986610","B0V","B","1","","" }
{ "105513","105854","203949","8200","","","","","","","Mic","","263.667","5.640","1.102","321.595198","-37.829429","K2III","K","1","","" }
{ "56150","56319","100378","4447","","","","","","","Cen","","558.487","5.640","-0.528","173.200397","-40.436194","M1III","M","1","","" }
{ "56349","56518","100733","4463","","","","","","","Cen","","721.585","5.640","-1.084","173.805445","-47.372580","M3III","M","1","","" }
{ "56506","56675","101132","4479","","Pi  Cha","Pi","","Pi","","Cha","","135.391","5.640","2.549","174.316115","-75.896544","F1III","F","1","","" }
{ "63713","63916","113847","4945","","","","","","","CVn","","432.568","5.640","0.027","196.467795","45.268550","K1III","K","1","","" }
{ "64402","64607","115046","4998","","","","","","","Vir","","478.235","5.640","-0.191","198.630345","11.331656","M0III","M","1","","" }
{ "73142","73369","132772","5588","","40    Boo","","40","","","Boo","","167.949","5.640","2.081","224.903969","39.265333","F1III-IV","F","1","","" }
{ "75501","75730","137744","5743","","32Zet1Lib","Zet-1","32","Zet","1","Lib","","784.030","5.640","-1.265","232.064199","-16.716484","K4III","K","1","","" }
{ "76514","76750","138800","5782","","Kap2Aps","Kap-2","","Kap","2","Aps","","780.278","5.640","-1.254","235.088964","-73.446685","B8IV","B","1","","" }
{ "81722","81972","150742","6214","","","","","","","Sco","","533.807","5.640","-0.430","251.177480","-40.839675","B3V","B","1","","" }
{ "110721","111068","213323","8574","","38    Peg","","38","","","Peg","","360.394","5.640","0.423","337.507544","32.572638","B9.5V","B","1","","" }
{ "114586","114948","219482","8843","GJ 1282","","","","","","Tuc","","66.986","5.640","4.077","349.239879","-62.001198","F7V","F","1","","" }
{ "33717","33804","52670","2640","","","","","","","CMa","","1019.239","5.640","-1.834","105.274777","-25.215634","B2/B3III/IV","B","1","","" }
{ "35087","35181","56813","2771","","","","","","","Pup","","751.512","5.640","-1.173","109.064470","-46.774533","K4III","K","1","","" }
{ "36626","36732","60341","2899","","","","","","","Pup","","272.706","5.640","1.029","113.331516","-19.412525","K0III","K","1","","" }
{ "37483","37590","62412","2988","","","","","","","Pup","","315.737","5.640","0.711","115.700637","-26.351326","K1III","K","1","","" }
{ "44228","44356","77353","3596","","","","","","","Hya","","490.461","5.640","-0.246","135.491617","-0.482673","K0III","K","1","","" }
{ "47566","47701","84107","3861","","15    Leo","","15","","","Leo","","159.881","5.640","2.188","145.888589","29.974473","A2IV","A","1","","" }
{ "49723","49865","88333","3996","","18    Sex","","18","","","Sex","","473.377","5.640","-0.169","152.732755","-8.418462","K2III","K","1","","" }
{ "3564","3572","4161","192","","21    Cas","","21","","","Cas","","303.401","5.640","0.797","11.412927","74.988073","A2IV","A","1","","" }
{ "5071","5081","6397","308","","72    Psc","","72","","","Psc","","178.033","5.640","1.955","16.272315","14.946133","F4II-III","F","1","","" }
{ "9600","9621","12558","605","","10    Ari","","10","","","Ari","","158.868","5.640","2.202","30.913899","25.935471","F8IV","F","1","","" }
{ "10189","10212","13421","635","","64    Cet","","64","","","Cet","","132.800","5.640","2.591","32.837834","8.569805","G0IV","G","1","","" }
{ "12121","12153","16234","763","","31    Ari","","31","","","Ari","","113.288","5.640","2.936","39.157965","12.447639","F7V","F","1","","" }
{ "14403","14439","19270","931","","","","","","","Ari","","313.311","5.640","0.727","46.598690","13.187250","K3III","K","1","","" }
{ "20037","20087","27176","1331","","51    Tau","","51","","","Tau","","176.301","5.640","1.976","64.596658","21.579297","F0V","F","1","","" }
{ "20433","20484","27749","1376","","63    Tau","","63","","","Tau","","162.753","5.640","2.149","65.854415","16.777260","A1m","A","1","","" }
{ "22492","22545","30557","1535","","","","","","","Aur","","316.964","5.640","0.702","72.788911","48.740685","G9III","G","1","","" }
{ "24853","24914","34255","1720","","","","","","","Cam","","2051.298","5.640","-3.353","80.094220","62.653711","K4Iab:","K","1","","" }
{ "25217","25280","35505","1792","","","","","","","Lep","","222.632","5.640","1.469","81.118703","-16.975781","A0V","A","1","","" }
{ "10281","10305","13612","650","Gl 87.1A","66    Cet","","66","","","Cet","","129.479","5.650","2.656","33.198090","-2.393637","F8V","F","1","","Gl 87.1" }
{ "12215","12247","16400","771","","81    Cet","","81","","","Cet","","301.717","5.650","0.819","39.424168","-3.396175","G5III:","G","1","","" }
{ "17890","17932","23838","1176","","","","","","","Per","","374.033","5.650","0.353","57.518456","44.967856","G2III...","G","1","","" }
{ "23112","23166","31925","1604","","","","","","","Lep","","131.994","5.650","2.614","74.755695","-16.376027","F5V","F","1","","" }
{ "26330","26394","39091","2022","GJ 9189","Pi  Men","Pi","","Pi","","Men","","59.736","5.650","4.336","84.287394","-80.469122","G3IV","G","1","","" }
{ "114948","115312","220096","8883","","","","","","","Scl","","330.452","5.650","0.622","350.314581","-26.986769","G5IV","G","1","","" }
{ "85031","85290","158460","6511","","","","","","","Dra","","316.043","5.650","0.718","261.422328","60.048398","A1Vn","A","1","","" }
{ "85650","85912","159332","6541","","","","","","","Her","","122.800","5.650","2.771","263.345103","19.256677","F6V","F","1","","" }
{ "90367","90647","172340","7006","","","","","","","Dra","","408.717","5.650","0.160","277.437352","77.547068","K4III","K","1","","" }
{ "94325","94620","180317","7301","","1    Sge","","1","","","Sge","","299.501","5.650","0.835","288.822334","21.232118","A4V","A","1","","" }
{ "94425","94720","180555","7307","","","","","","","Aql","","409.744","5.650","0.155","289.111616","14.544616","B9.5V","B","1","","" }
{ "98159","98470","189245","7631","Gl 773.4","","","","","","Sgr","","69.307","5.650","4.013","300.084313","-33.703452","F7V","F","1","","" }
{ "99428","99747","191829","7714","","","","","","","Tel","","685.202","5.650","-0.962","303.579249","-52.445770","K4III","K","1","","" }
{ "108354","108699","209167","8393","","19    Peg","","19","","","Peg","","540.890","5.650","-0.448","330.288479","8.257164","K5III","K","1","","" }
{ "62130","62325","111028","4849","","33    Vir","","33","","","Vir","","147.249","5.650","2.377","191.593926","9.539684","K1III-IV","K","1","","" }
{ "62305","62500","111295","4860","","","","","","","Hya","","320.389","5.650","0.689","192.109456","-27.597384","G8III","G","1","","" }
{ "65317","65522","116458","5049","","","","","","","Mus","","443.750","5.650","-0.019","201.459860","-70.627248","Ap","A","1","","" }
{ "65584","65790","117304","5081","","71    Vir","","71","","","Vir","","320.389","5.650","0.689","202.304171","10.818310","K0III","K","1","","" }
{ "73056","73284","132219","5577","","59    Hya","","59","","","Hya","","368.955","5.650","0.382","224.663576","-27.657314","A6IV","A","1","","" }
{ "73312","73540","130650","5525","","Pi 1Oct","Pi-1","","Pi","1","Oct","","393.909","5.650","0.240","225.461313","-83.227646","G8/K0III","G","1","","" }
{ "73544","73771","131246","5545","","Pi 2Oct","Pi-2","","Pi","2","Oct","","1953.032","5.650","-3.236","226.195658","-83.038311","G8Ib","G","1","","" }
{ "74814","75043","136729","5715","","","","","","","Boo","","220.674","5.650","1.498","230.021448","51.958515","A4V","A","1","","" }
{ "74952","75181","136352","5699","Gl 582","Nu 2Lup","Nu-2","","Nu","2","Lup","","48.312","5.650","4.797","230.452611","-48.317628","G2V","G","1","","" }
{ "75079","75308","136359","5700","","","","","","","Cir","","131.568","5.650","2.621","230.793973","-60.657176","F7V","F","1","","" }
{ "76284","76519","140227","5844","","","","","","","UMi","","767.427","5.650","-1.208","234.413253","69.283344","M0III","M","1","","" }
{ "28413","28484","41214","2138","","","","","","","Pic","","212.618","5.650","1.579","90.204919","-51.216319","A1m...","A","1","","" }
{ "28685","28756","41534","2149","","","","","","","Col","","1006.656","5.650","-1.797","91.084447","-32.172430","B2V","B","1","","" }
{ "32990","33077","50644","2565","","","","","","","CMa","","311.515","5.650","0.750","103.328393","-19.032763","A9/F0III","A","1","","" }
{ "36067","36168","58978","2855","","","","","","","CMa","","1249.641","5.650","-2.267","111.747847","-23.086023","B1II","B","1","","" }
{ "39102","39213","65900","3136","","","","","","","CMi","","307.985","5.650","0.774","120.307877","4.879824","A1V","A","1","","" }
{ "47824","47960","84607","3879","","","","","","","Sex","","262.817","5.650","1.119","146.598379","1.785586","F4IV","F","1","","" }
{ "53161","53316","94481","4255","","","","","","","Crt","","492.683","5.650","-0.246","163.574071","-13.758036","K0III + (G)","K","1","","" }
{ "32388","32474","49147","2502","","","","","","","Mon","","539.994","5.660","-0.435","101.662570","-10.107360","B9.5V","B","1","","" }
{ "36875","36981","60855","2921","","","","","","","Pup","","1269.091","5.660","-2.290","114.016224","-14.492771","B2/3V(n)","B","1","","" }
{ "36916","37023","60437","2903","","","","","","","Lyn","","550.011","5.660","-0.475","114.131840","46.180288","M0III","M","1","","" }
{ "39806","39919","68161","3203","","","","","","","Vel","","916.170","5.660","-1.583","122.289618","-48.684413","B8Ib/II","B","1","","" }
{ "39829","39943","67880","3194","","","","","","","Pup","","1689.929","5.660","-2.912","122.368895","-16.248922","B4V","B","1","","" }
{ "39844","39957","68434","3218","","","","","","","Car","","393.909","5.660","0.250","122.390136","-56.085384","A3m...","A","1","","" }
{ "42253","42372","73017","3400","","","","","","","UMa","","266.467","5.660","1.099","129.592562","53.401539","G8IV","G","1","","" }
{ "46378","46511","82077","3763","","","","","","","Hya","","1190.352","5.660","-2.151","142.302679","-20.749127","K4/K5III","K","1","","" }
{ "50378","50520","89715","4065","","","","","","","Car","","261.973","5.660","1.136","154.771245","-64.676258","A1V","A","1","","" }
{ "50466","50609","89736","4066","","","","","","","Vel","","1681.218","5.660","-2.901","155.069657","-47.699090","K5/M0III","K","1","","" }
{ "52889","53043","93859","4235","","43    UMa","","43","","","UMa","","357.236","5.660","0.462","162.796011","56.582250","K2III","K","1","","" }
{ "83892","84150","155259","6381","","","","","","","Sco","","205.259","5.660","1.666","258.067530","-39.506949","A0/A1V","A","1","","" }
{ "85528","85790","159139","6533","","78    Her","","78","","","Her","","267.561","5.660","1.090","262.956578","28.407499","A1V","A","1","","" }
{ "95323","95619","182681","7380","","","","","","","Sgr","","228.081","5.660","1.437","291.735335","-29.743225","B8/B9V","B","1","","" }
{ "96193","96496","184835","7443","","","","","","","Sgr","","397.267","5.660","0.232","294.263919","-18.231052","K0III","K","1","","" }
{ "101019","101345","195564","7845","","","","","","","Cap","","79.589","5.660","3.723","308.098720","-9.853384","G3V","G","1","","" }
{ "102618","102949","198726","7988","","","","","","","Vul","","1203.529","5.660","-2.175","312.867656","28.250505","F5Ib","F","1","","" }
{ "106513","106856","205924","8270","","4    Peg","","4","","","Peg","","178.423","5.660","1.970","324.633081","5.771742","A9IV-Vn","A","1","","" }
{ "106801","107144","206445","8287","","26    Aqr","","26","","","Aqr","","1116.974","5.660","-2.013","325.542132","1.285253","K2III","K","1","","" }
{ "1286","1288","1187","57","","","","","","","Scl","","496.433","5.660","-0.252","4.036893","-31.446394","K2III","K","1","","" }
{ "3471","3478","4142","189","","","","","","","Cas","","623.626","5.660","-0.747","11.109179","47.863984","B5V...","B","1","","" }
{ "7554","7568","11025","525","","","","","","","Oct","","380.579","5.660","0.325","24.365834","-84.769593","K0III","K","1","","" }
{ "9967","9990","12953","618","","","","","","","Per","","326156.378","5.660","-14.340","32.169084","58.423601","A1Ia","A","1","","" }
{ "17485","17527","23324","1144","","18    Tau","","18","","","Tau","","409.230","5.660","0.167","56.290575","24.839260","B8V","B","1","","" }
{ "17542","17584","23300","1141","","","","","","","Per","","748.065","5.660","-1.143","56.496897","45.681899","B6V","B","1","","" }
{ "18046","18089","24263","1199","","31    Tau","","31","","","Tau","","778.416","5.660","-1.229","58.000954","6.534907","B5V","B","1","","" }
{ "21770","21823","29526","1482","","","","","","","Per","","296.506","5.660","0.867","70.350481","48.300881","A0V","A","1","","" }
{ "21905","21958","30080","1509","","","","","","","Cae","","642.040","5.660","-0.811","70.788734","-30.765557","K3III","K","1","","" }
{ "24940","25001","34790","1752","","","","","","","Aur","","288.890","5.660","0.923","80.302864","29.569884","A1Vs","A","1","","" }
{ "111457","111809","214484","8616","","","","","","","PsA","","423.580","5.660","0.092","339.714441","-33.081347","A0V","A","1","","" }
{ "113202","113562","217303","8743","","","","","","","PsA","","686.645","5.660","-0.957","345.024110","-25.164180","K0IICNIII","K","1","","" }
{ "115543","115908","221006","8919","","","","","","","Tuc","","386.441","5.660","0.292","352.253970","-63.110656","Ap Si","A","1","","" }
{ "116225","116591","222093","8958","","","","","","","Aqr","","267.122","5.660","1.094","354.414830","-13.060243","K0III","K","1","","" }
{ "59286","59468","105981","4640","","4    Com","","4","","","Com","","886.294","5.660","-1.511","182.963245","25.870280","K4III","K","1","","" }
{ "60240","60425","107815","4711","","6    Crv","","6","","","Crv","","331.123","5.660","0.627","185.839947","-24.840669","K1III","K","1","","" }
{ "67757","67973","121190","5230","","","","","","","Cen","","352.983","5.660","0.488","208.800635","-52.160822","B8V","B","1","","" }
{ "80549","80793","148604","6140","","","","","","","Oph","","297.860","5.660","0.857","247.445510","-14.550879","G5III/IV","G","1","","" }
{ "71557","71783","128974","5466","","","","","","","Cen","","618.892","5.670","-0.721","220.255813","-36.134858","Ap Si","A","1","","" }
{ "73859","74087","134320","5638","","46    Boo","","46","","","Boo","","517.709","5.670","-0.333","227.099087","26.301152","K2III","K","1","","" }
{ "79159","79399","145483","6029","","12    Sco","","12","","","Sco","","303.401","5.670","0.827","243.066839","-28.417305","B9V","B","1","","" }
{ "80069","80309","148374","6130","","","","","","","Dra","","506.454","5.670","-0.286","245.946552","61.696461","G8III","G","1","","" }
{ "80431","80675","147977","6114","","","","","","","Nor","","1342.207","5.670","-2.402","247.063211","-58.599795","B9III","B","1","","" }
{ "654","655","344","13","","","","","","","Scl","","309.740","5.670","0.782","2.014551","-33.529326","K1III","K","1","","" }
{ "2377","2383","2726","120","","","","","","","Phe","","140.524","5.670","2.498","7.608625","-48.214910","F2V","F","1","","" }
{ "5482","5493","6920","340","","44    And","","44","","","And","","170.495","5.670","2.079","17.578200","42.081475","F8V","F","1","","" }
{ "10489","10513","14287","678","","Pi 2Hyi","Pi-2","","Pi","2","Hyi","","488.258","5.670","-0.206","33.869098","-67.746366","K2III","K","1","","" }
{ "14485","14521","20313","981","","","","","","","Hyi","","270.221","5.670","1.079","46.883112","-78.989244","F2II-III","F","1","","" }
{ "16468","16509","22231","1090","","","","","","","Hor","","312.410","5.670","0.764","53.144881","-50.378646","K3III","K","1","","" }
{ "18758","18805","25330","1243","","","","","","","Tau","","571.202","5.670","-0.547","60.442234","9.998017","B5V","B","1","","" }
{ "20001","20049","28525","1426","","Del Men","Del","","Del","","Men","","423.580","5.670","0.102","64.496638","-80.214033","K2/K3III+..","K","1","","" }
{ "21242","21295","28978","1448","","","","","","","Tau","","484.631","5.670","-0.190","68.534445","5.568616","A2Vs","A","1","","" }
{ "24052","24109","33167","1668","","","","","","","Aur","","158.791","5.670","2.233","77.678768","46.962070","F5V","F","1","","" }
{ "25999","26064","36576","1858","","120    Tau","","120","","","Tau","","1553.126","5.670","-2.719","83.381791","18.540231","B2IV-Ve","B","1","","" }
{ "26132","26197","36959","1886","","","","","","","Ori","","2695.507","5.670","-3.916","83.754195","-6.009270","B1Vvar","B","1","","" }
{ "28741","28812","41361","2144","","63    Ori","","63","","","Ori","","1309.865","5.670","-2.349","91.242428","5.419970","G7III:","G","1","","" }
{ "30026","30099","44033","2269","","","","","","","Ori","","593.012","5.670","-0.628","95.017600","14.651127","K3Ib","K","1","","" }
{ "41074","41191","72922","3393","","","","","","","Cha","","247.463","5.670","1.270","126.084556","-80.914202","G8III","G","1","","" }
{ "41125","41242","71141","3308","","","","","","","Pup","","564.284","5.670","-0.520","126.229921","-23.153745","A1III/IV","A","1","","" }
{ "42445","42564","74167","3444","","","","","","","Vel","","964.960","5.670","-1.685","130.146910","-45.191103","M0III","M","1","","" }
{ "43461","43584","75698","3519","","51Sig1Cnc","Sig-1","51","Sig","1","Cnc","","210.288","5.670","1.623","133.144258","32.474157","A8Vms","A","1","","" }
{ "47823","47959","84561","3877","","18    Leo","","18","","","Leo","","512.020","5.670","-0.309","146.597200","11.810043","K4III","K","1","","" }
{ "51653","51802","91636","4148","","49    Leo","","49","","","Leo","","428.589","5.670","0.077","158.758997","8.650425","A2V","A","1","","" }
{ "53981","54137","96113","4311","","","","","","","Vel","","285.851","5.670","0.956","166.130141","-47.679103","A8III/IV","A","1","","" }
{ "88723","89000","166285","6797","","","","","","","Oph","","153.053","5.670","2.313","272.475056","3.119827","F5V","F","1","","" }
{ "90688","90968","170868","6952","","Kap1CrA","Kap-1","","Kap","1","CrA","","973.601","5.670","-1.705","278.346387","-38.725985","B9.5","B","1","","" }
{ "92705","92997","176408","7175","","48    Dra","","48","","","Dra","","276.170","5.670","1.031","284.187766","57.814851","K1III","K","1","","" }
{ "96212","96516","185194","7463","","4Eps Sge","Eps","4","Eps","","Sge","","480.348","5.670","-0.171","294.322472","16.462802","G8IIIvar","G","1","","" }
{ "98529","98844","190299","7667","","62    Aql","","62","","","Aql","","417.080","5.670","0.136","301.096465","-0.709309","K4III","K","1","","" }
{ "102631","102962","198160","7959","","","","","","","Pav","","248.974","5.670","1.256","312.910215","-62.429335","A2","A","1","","" }
{ "104102","104440","200525","8061","Gl 818.1A","","","","","","Pav","","64.471","5.670","4.190","317.340775","-73.172968","G3IV","G","1","","Gl 818.1" }
{ "105362","105703","203925","8198","","","","","","","Vul","","223.855","5.670","1.487","321.141675","26.174560","A8III","A","1","","" }
{ "84433","84691","156874","6443","","","","","","","Her","","316.657","5.680","0.744","259.702180","28.822968","K0III","K","1","","" }
{ "85668","85930","159353","6542","","","","","","","Her","","303.119","5.680","0.839","263.414119","16.317553","K0III:","K","1","","" }
{ "87044","87314","161783","6622","","","","","","","Ara","","988.353","5.680","-1.727","267.618299","-53.612406","B2V + B3V","B","1","","" }
{ "91597","91883","173417","7044","","","","","","","Lyr","","164.063","5.680","2.172","280.964979","31.926613","F1III-IV","F","1","","" }
{ "92457","92747","174947","7114","","33    Sgr","","33","","","Sgr","","1638.977","5.680","-2.826","283.500381","-21.359845","G8/K0II","G","1","","" }
{ "97323","97634","187879","7567","","","","","","","Cyg","","2117.898","5.680","-3.382","297.655532","40.599759","B1III","B","1","","" }
{ "98064","98375","189410","7641","","14    Vul","","14","","","Vul","","160.195","5.680","2.224","299.793922","23.101281","F0","F","1","","" }
{ "100428","100754","194577","7811","","","","","","","Vul","","475.447","5.680","-0.138","306.418871","21.409642","G6III","G","1","","" }
{ "101570","101899","196852","7904","","","","","","","Cyg","","354.133","5.680","0.501","309.747998","30.334265","K2III","K","1","","" }
{ "101824","102155","197392","7926","","","","","","","Cyg","","1094.485","5.680","-1.949","310.485417","41.716875","B8II-III","B","1","","" }
{ "102980","103312","199478","8020","","","","","","","Cyg","","326156.378","5.680","-14.320","313.957518","47.417656","B8Ia","B","1","","" }
{ "105156","105497","203644","8185","","","","","","","Cyg","","329.119","5.680","0.660","320.501694","49.388848","K0III","K","1","","" }
{ "32728","32814","49738","2525","","35    Gem","","35","","","Gem","","1763.007","5.680","-2.984","102.606244","13.413177","K3III","K","1","","" }
{ "32881","32968","49968","2533","","","","","","","Gem","","462.633","5.680","-0.079","102.999953","23.601718","K5III","K","1","","" }
{ "34382","34473","55864","2735","","Gam1Vol","Gam-1","","Gam","1","Vol","","161.944","5.680","2.200","107.176464","-70.497087","F2","F","1","","" }
{ "37068","37174","61715","2957","","","","","","","Pup","","3136.119","5.680","-4.235","114.575872","-48.601436","F4Iab","F","1","","" }
{ "41743","41861","72737","3386","","","","","","","Vel","","749.785","5.680","-1.128","128.020681","-53.211920","G8III+...","G","1","","" }
{ "43876","44001","76582","3565","","63Omi2Cnc","Omi-2","63","Omi","2","Cnc","","150.441","5.680","2.360","134.396661","15.581281","F0IV","F","1","","" }
{ "47054","47187","83332","3830","","","","","","","Ant","","311.515","5.680","0.780","144.250879","-25.296759","K0III","K","1","","" }
{ "49080","49220","87015","3952","","","","","","","Leo","","942.648","5.680","-1.625","150.703962","21.949258","B2.5IV","B","1","","" }
{ "57568","57741","102878","4541","","","","","","","Cen","","326156.378","5.680","-14.320","177.613672","-62.649381","A3Iab","A","1","","" }
{ "60607","60795","108502","4745","","73    UMa","","73","","","UMa","","417.080","5.680","0.146","186.896306","55.712724","M2III","M","1","","" }
{ "60768","60957","108765","4756","","20    Com","","20","","","Com","","274.081","5.680","1.058","187.430158","20.896109","A3V","A","1","","" }
{ "61465","61658","109896","4807","","","","","","","Vir","","492.683","5.680","-0.216","189.593357","1.854662","M3III","M","1","","" }
{ "67019","67231","120198","5187","","84    UMa","","84","","","UMa","","290.433","5.680","0.932","206.648600","54.432679","B9p EuCr","B","1","","" }
{ "71928","72154","129956","5501","","108    Vir","","108","","","Vir","","493.429","5.680","-0.219","221.375855","0.717271","B9.5V","B","1","","" }
{ "72262","72488","130529","5521","","","","","","","Lib","","1012.908","5.680","-1.781","222.328109","-24.251470","K3III+...","K","1","","" }
{ "72298","72524","131041","5538","","39    Boo","","39","","","Boo","","223.701","5.680","1.499","222.422152","48.720804","F6V+...","F","1","","" }
{ "74667","74896","136138","5692","","","","","","","Ser","","356.455","5.680","0.487","229.602105","20.572778","G5IV","G","1","","" }
{ "379","379","225216","9104","","","","","","","Cep","","302.277","5.680","0.845","1.174555","67.166445","K1III","K","1","","" }
{ "10133","10155","13325","631","","15    Ari","","15","","","Ari","","558.487","5.680","-0.488","32.656641","19.500338","M3III","M","1","","" }
{ "16249","16290","22676","1109","","","","","","","Men","","320.704","5.680","0.717","52.495497","-78.351850","G8III","G","1","","" }
{ "17267","17309","23016","1126","","13    Tau","","13","","","Tau","","539.102","5.680","-0.411","55.578951","19.700254","B9Vn","B","1","","" }
{ "22646","22699","30823","1550","","","","","","","Aur","","452.995","5.680","-0.033","73.198996","42.586626","A3III","A","1","","" }
{ "24967","25028","35007","1764","","","","","","","Ori","","1003.558","5.680","-1.761","80.382681","-0.416491","B3V","B","1","","" }
{ "112183","112542","215766","8673","","69Tau1Aqr","Tau-1","69","Tau","1","Aqr","","317.582","5.680","0.738","341.928199","-14.056428","B9V","B","1","","" }
{ "113297","113657","217403","8749","","","","","","","Gru","","488.258","5.680","-0.196","345.281450","-50.950028","K3III","K","1","","" }
{ "113849","114210","218470","8805","","5    And","","5","","","And","","112.004","5.680","3.001","346.938903","49.295776","F5V","F","1","","" }
{ "114003","114365","218753","8822","","2    Cas","","2","","","Cas","","1744.152","5.680","-2.961","347.433910","59.332692","A5III","A","1","","" }
{ "114087","114449","218792","8824","","","","","","","Peg","","507.242","5.680","-0.279","347.677650","17.594372","K4III","K","1","","" }
{ "116129","116495","221950","8954","","16    Psc","","16","","","Psc","","101.040","5.680","3.225","354.097024","2.102222","F6Vbwvar","F","1","","" }
{ "59649","59831","106690","4666","","2    CVn","","2","","","CVn","","771.055","5.690","-1.178","184.031443","40.660180","M1III","M","1","","" }
{ "64993","65198","116160","5037","","","","","","","Vir","","220.824","5.690","1.537","200.423512","2.087243","A2V","A","1","","" }
{ "65387","65593","116835","5060","","","","","","","Cen","","1953.032","5.690","-3.196","201.733826","-41.497562","K3III","K","1","","" }
{ "65857","66065","117716","5097","","","","","","","Hya","","233.469","5.690","1.416","203.149609","-28.692768","A0/A1V","A","1","","" }
{ "68596","68815","122250","5261","","The Aps","The","","The","","Aps","","368.955","5.690","0.422","211.333543","-76.796752","M6.5III","M","1","","" }
{ "78832","79072","145002","6010","","47    Ser","","47","","","Ser","","807.318","5.690","-1.278","242.116979","8.534310","M3.5IIIa","M","1","","" }
{ "82999","83254","153834","6325","","","","","","","Her","","3106.251","5.690","-4.204","255.242233","22.632095","K3III","K","1","","" }
{ "84691","84950","157681","6479","","","","","","","Dra","","623.626","5.690","-0.717","260.439004","53.420428","K5III","K","1","","" }
{ "84888","85147","156838","6440","","","","","","","Ara","","1449.584","5.690","-2.549","261.004486","-62.864153","B2IV","B","1","","" }
{ "85749","86011","159176","6535","","","","","","","Sco","","326156.378","5.690","-14.310","263.677054","-32.581662","O5/6(e)","O","1","","" }
{ "86889","87158","162076","6638","","","","","","","Her","","259.266","5.690","1.188","267.103196","20.565441","G5IV","G","1","","" }
{ "87850","88122","164646","6728","","","","","","","Her","","572.204","5.690","-0.531","269.984189","45.501378","M0III","M","1","","" }
{ "90382","90662","170069","6922","","","","","","","Tel","","645.854","5.690","-0.794","277.483061","-47.220546","K2III","K","1","","" }
{ "91849","92136","173638","7055","","","","","","","Sct","","326156.378","5.690","-14.310","281.680518","-10.125048","F2Ib-II","F","1","","" }
{ "92645","92937","175743","7148","","","","","","","Her","","300.882","5.690","0.865","284.025511","18.105410","K1III","K","1","","" }
{ "93100","93393","176871","7202","","","","","","","Lyr","","649.714","5.690","-0.806","285.322319","26.291411","B5V","B","1","","" }
{ "98321","98633","189741","7649","","63    Sgr","","63","","","Sgr","","296.776","5.690","0.895","300.494166","-13.637217","A1IV","A","1","","" }
{ "100032","100357","194298","7805","","","","","","","Dra","","701.412","5.690","-0.973","305.298001","63.980122","K5III","K","1","","" }
{ "101553","101882","196725","7892","","8The Del","The","8","The","","Del","","2013.311","5.690","-3.262","309.683276","13.315125","K3Ib","K","1","","" }
{ "103344","103675","200044","8044","","","","","","","Del","","523.525","5.690","-0.338","315.115366","19.329581","M3III","M","1","","" }
{ "103813","104148","200718","8070","","Del Mic","Del","","Del","","Mic","","301.438","5.690","0.861","316.504760","-30.125120","K0/K1III","K","1","","" }
{ "106910","107253","206774","8307","","79    Cyg","","79","","","Cyg","","274.542","5.690","1.064","325.856863","38.283589","A0V","A","1","","" }
{ "107717","108060","208108","8358","","","","","","","Peg","","235.833","5.690","1.394","328.405749","19.668437","A0Vs","A","1","","" }
{ "108710","109056","209833","8419","","23    Peg","","23","","","Peg","","346.975","5.690","0.556","331.394467","28.963981","B9Vn","B","1","","" }
{ "31062","31137","46860","2412","","Mu  Pic","Mu","","Mu","","Pic","","756.743","5.690","-1.138","97.992963","-58.753835","B9V","B","1","","" }
{ "33740","33827","50885","2581","","","","","","","Cam","","508.824","5.690","-0.276","105.339180","70.808296","K4III","K","1","","" }
{ "34488","34579","54912","2704","","","","","","","CMa","","1842.692","5.690","-3.070","107.429269","-25.231034","B2V","B","1","","" }
{ "36930","37036","61068","2928","","","","","","","Pup","","1689.929","5.690","-2.882","114.170975","-19.702338","B2II","B","1","","" }
{ "36937","37043","61391","2940","","","","","","","Pup","","463.290","5.690","-0.072","114.183005","-48.830167","B9V","B","1","","" }
{ "38317","38427","64238","3073","","10    Pup","","10","","","Pup","","1090.824","5.690","-1.932","118.078661","-14.846175","F2IV/V","F","1","","" }
{ "54097","54255","96314","4317","","Chi2Hya","Chi-2","","Chi","2","Hya","","692.476","5.690","-0.945","166.489864","-27.287853","B8V","B","1","","" }
{ "2543","2548","2913","132","","51    Psc","","51","","","Psc","","264.094","5.690","1.148","8.099090","6.955463","B9.5V","B","1","","" }
{ "4665","4675","5788","282","","","","","","","And","","388.281","5.690","0.311","15.014816","44.713243","B9.5Vn","B","1","","" }
{ "7237","7251","9352","439","","","","","","","Cas","","2203.759","5.690","-3.459","23.357125","58.327334","K0Ib+...","K","1","","" }
{ "7449","7463","9906","462","","Tau Scl","Tau","","Tau","","Scl","","226.183","5.690","1.485","24.035412","-29.907317","F2V","F","1","","" }
{ "9002","9021","11749","557","","56    And","","56","","","And","","316.350","5.690","0.756","29.038902","37.251830","G8III...","G","1","","" }
{ "13908","13942","18692","901","","Zet For","Zet","","Zet","","For","","106.379","5.690","3.123","44.900714","-25.274133","F3V","F","1","","" }
{ "19918","19968","26670","1305","","","","","","","Cam","","446.178","5.690","0.010","64.223131","61.849989","B5Vn","B","1","","" }
{ "25160","25223","35299","1781","","","","","","","Ori","","876.764","5.690","-1.457","80.926289","-0.159818","B1.5V","B","1","","" }
{ "25428","25492","35600","1804","","","","","","","Aur","","1436.812","5.690","-2.530","81.784470","30.208603","B9Ib","B","1","","" }
{ "194","194","225003","9093","","32    Psc","","32","","","Psc","","120.353","5.700","2.865","0.623762","8.485463","F0V","F","1","","" }
{ "521","522","142","6","Gl 4.2A","","","","","","Phe","","83.867","5.700","3.649","1.579161","-49.075191","G1IV...","G","1","","Gl 4.2" }
{ "3709","3717","4585","218","","","","","","","Cet","","355.290","5.700","0.514","11.930081","-18.061339","K3III","K","1","","" }
{ "5820","5833","7476","368","","38    Cet","","38","","","Cet","","139.981","5.700","2.537","18.704883","-0.973795","F5V","F","1","","" }
{ "7906","7921","10615","505","","","","","","","Hyi","","363.608","5.700","0.464","25.449832","-60.789339","K2/K3III","K","1","","" }
{ "7926","7941","10538","498","","","","","","","Scl","","303.684","5.700","0.855","25.512492","-36.832305","A0V","A","1","","" }
{ "8696","8714","11291","536","","2    Per","","2","","","Per","","482.480","5.700","-0.150","28.039020","50.792794","B9p...","B","1","","" }
{ "9203","9222","11949","568","","3    Per","","3","","","Per","","244.679","5.700","1.324","29.639597","49.204352","K0IV","K","1","","" }
{ "15580","15619","20791","1007","","97Kap2Cet","Kap-2","97","Kap","2","Cet","","322.608","5.700","0.724","50.278347","3.675620","G8.5III","G","1","","" }
{ "18217","18262","24744","1219","","","","","","","Eri","","499.474","5.700","-0.225","58.596523","-40.357009","K0III...","K","1","","" }
{ "19462","19511","26464","1293","","","","","","","Eri","","286.102","5.700","0.985","62.699019","-8.819814","G9III:","G","1","","" }
{ "84898","85157","157728","6480","","73    Her","","73","","","Her","","139.264","5.700","2.548","261.027455","22.960285","F0IV","F","1","","" }
{ "95393","95690","182509","7370","","","","","","","Tel","","537.325","5.700","-0.384","291.950497","-54.325272","K4III","K","1","","" }
{ "95524","95823","183007","7392","","","","","","","Sgr","","203.466","5.700","1.725","292.349271","-43.445195","Am","A","1","","" }
{ "97655","97966","188293","7593","","57    Aql","","57","","","Aql","","482.480","5.700","-0.150","298.656884","-8.227289","B7Vn","B","1","","" }
{ "99182","99500","192455","7727","","68    Dra","","68","","","Dra","","157.716","5.700","2.278","302.895101","62.078542","F5V","F","1","","" }
{ "99523","99841","192787","7743","","","","","","","Cyg","","317.891","5.700","0.756","303.849053","33.729084","K0III","K","1","","" }
{ "103057","103389","199260","8013","Gl 811","","","","","","Cap","","71.651","5.700","3.991","314.197190","-26.296378","F7V","F","1","","" }
{ "105311","105652","203803","8190","","","","","","","Vul","","168.993","5.700","2.128","320.995082","24.274135","F1IV","F","1","","" }
{ "106217","106559","205289","8245","","37    Cap","","37","","","Cap","","88.389","5.700","3.535","323.712717","-20.084274","F5V","F","1","","" }
{ "107587","107930","208095","8357","","","","","","","Cep","","1503.025","5.700","-2.618","328.004306","55.796743","B6IV-V","B","1","","" }
{ "110895","111242","214035","8599","","","","","","","Cep","","785.919","5.700","-1.210","338.067763","76.226441","A2V","A","1","","" }
{ "117200","117567","223559","9029","","","","","","","Aqr","","454.890","5.700","-0.022","357.638688","-14.401490","K4III","K","1","","" }
{ "118351","","","","Gl 188B","","","","","","Tau","","51.754","5.700","4.697","76.863404","18.647141","G4 V","G","2","23780","Gl 188" }
{ "61378","61571","109742","4801","","25    Com","","25","","","Com","","634.545","5.700","-0.745","189.243055","17.089536","K5III","K","1","","" }
{ "62507","62703","111588","4872","","","","","","","Cen","","332.135","5.700","0.661","192.741199","-52.787424","A5V","A","1","","" }
{ "63851","64053","113902","4951","","","","","","","Cen","","326.483","5.700","0.698","196.909579","-53.459764","B8V","B","1","","" }
{ "66111","66320","118219","5111","","80    Vir","","80","","","Vir","","316.964","5.700","0.762","203.880400","-5.396191","G6III","G","1","","" }
{ "67634","67848","121409","5238","","86    UMa","","86","","","UMa","","478.937","5.700","-0.134","208.462606","53.728677","A0V","A","1","","" }
{ "71748","71974","129433","5484","","4    Lib","","4","","","Lib","","497.190","5.700","-0.215","220.806470","-24.997753","B9.5V","B","1","","" }
{ "74153","74380","134482","5647","","Kap2Lup","Kap-2","","Kap","2","Lup","","253.621","5.700","1.246","227.990448","-48.743687","A3IV","A","1","","" }
{ "78628","78868","143346","5955","","","","","","","Aps","","290.951","5.700","0.948","241.482760","-72.400898","K1IIICNII","K","1","","" }
{ "28230","28302","40369","2099","","","","","","","Ori","","793.568","5.700","-1.231","89.721819","12.808264","K2III...","K","1","","" }
{ "29079","29151","42111","2174","","","","","","","Ori","","654.932","5.700","-0.814","92.241264","2.499692","A3Vn","A","1","","" }
{ "29787","29860","43587","2251","Gl 231.1A","","","","","","Ori","","62.783","5.700","4.278","94.317242","5.100112","G0.5Vb","G","1","","Gl 231.1" }
{ "31691","31771","47070","2419","","51    Aur","","51","","","Aur","","488.258","5.700","-0.176","99.664755","39.390854","K5III","K","1","","" }
{ "31787","31870","47946","2460","","","","","","","CMa","","239.293","5.700","1.372","99.927756","-30.470491","K1III","K","1","","" }
{ "35390","35487","57167","2788","","","","","","","CMa","","139.502","5.700","2.544","109.867408","-16.395244","F2III/IV","F","1","","" }
{ "36247","36348","58661","2844","","","","","","","Lyn","","499.474","5.700","-0.225","112.214513","48.183930","B9MNp...","B","1","","" }
{ "38328","38438","64722","3088","","","","","","","Car","","1336.707","5.700","-2.363","118.123930","-54.367165","B1.5IV","B","1","","" }
{ "42907","43026","74794","3478","","","","","","","Hya","","301.997","5.700","0.867","131.510314","-2.048655","K0III:","K","1","","" }
{ "43673","43797","76653","3570","GJ 3519","","","","","","Vel","","78.782","5.700","3.785","133.799047","-54.965768","F6V","F","1","","" }
{ "49199","49339","87427","3965","","","","","","","Hya","","228.882","5.700","1.469","151.087284","-24.285534","F0V","F","1","","" }
{ "49794","49934","88661","4009","","","","","","","Car","","1274.048","5.700","-2.259","152.943607","-58.060544","B2IVnpe","B","1","","" }
{ "53543","53699","95221","4282","","","","","","","Hya","","158.251","5.700","2.270","164.807255","-33.737595","F2V","F","1","","" }
{ "54328","54487","96738","4332","","67    Leo","","67","","","Leo","","460.673","5.700","-0.050","167.204541","24.658464","A3IV","A","1","","" }
{ "28428","28499","40394","2101","","36    Aur","","36","","","Aur","","1156.583","5.710","-2.039","90.244002","47.901923","B9.5p SiFe","B","1","","" }
{ "29161","29234","42443","2186","","","","","","","Lep","","159.959","5.710","2.257","92.449823","-22.774343","F5V","F","1","","" }
{ "31484","31564","47138","2423","","6Nu 1CMa","Nu-1","6","Nu","1","CMa","","350.706","5.710","0.552","99.095211","-18.659904","G8/K0III+..","G","1","","" }
{ "34911","35005","55730","2728","","","","","","","CMi","","294.365","5.710","0.933","108.635921","12.115824","G6III","G","1","","" }
{ "40875","40990","70523","3281","","","","","","","Pup","","310.625","5.710","0.816","125.477535","-17.586334","K0III","K","1","","" }
{ "41697","41816","72041","3355","","30Ups1Cnc","Ups-1","30","Ups","1","Cnc","","249.928","5.710","1.288","127.877180","24.081105","F0IIIn","F","1","","" }
{ "43029","43148","75276","3496","","","","","","","Vel","","326156.378","5.710","-14.290","131.828526","-46.155415","F0Ib","F","1","","" }
{ "48476","48613","86087","3927","","","","","","","Vel","","302.838","5.710","0.871","148.713512","-50.243959","A0V","A","1","","" }
{ "49222","49363","87141","3954","","","","","","","UMa","","165.478","5.710","2.183","151.151383","53.891716","F5V","F","1","","" }
{ "51784","51933","91889","4158","Gl 398.1","","","","","","Hya","","81.784","5.710","3.714","159.134913","-12.230121","F7V","F","1","","" }
{ "54364","54522","96813","4333","","","","","","","UMa","","381.916","5.710","0.367","167.329526","36.309379","M3.5III","M","1","","" }
{ "88","88","224834","9081","","Tau Phe","Tau","","Tau","","Phe","","593.012","5.710","-0.588","0.269116","-48.809876","G8III","G","1","","" }
{ "1084","1086","905","41","","23    And","","23","","","And","","113.842","5.710","2.996","3.378599","41.035370","F0IV","F","1","","" }
{ "5285","5296","6706","329","","30    Cet","","30","","","Cet","","153.775","5.710","2.343","16.942530","-9.785550","F7IV","F","1","","" }
{ "14894","14930","20234","977","","","","","","","Hor","","1048.734","5.710","-1.826","48.138128","-57.321549","C5II","C","1","","" }
{ "16073","16112","21574","1054","","Chi2For","Chi-2","","Chi","2","For","","454.890","5.710","-0.012","51.889210","-35.681323","K2III","K","1","","" }
{ "19505","19554","26462","1292","","45    Tau","","45","","","Tau","","120.620","5.710","2.870","62.834506","5.523047","F4V","F","1","","" }
{ "21225","21278","29009","1449","","46    Eri","","46","","","Eri","","827.808","5.710","-1.313","68.478034","-6.738908","B9p Si","B","1","","" }
{ "22808","22860","31414","1579","","","","","","","Eri","","473.377","5.710","-0.099","73.778431","-16.740670","G8/K0III","G","1","","" }
{ "22828","22881","31444","1581","","","","","","","Eri","","278.290","5.710","1.055","73.827704","-16.417767","G6/G8III","G","1","","" }
{ "23613","23668","32890","1655","","","","","","","Lep","","248.595","5.710","1.300","76.317480","-26.152391","K2III","K","1","","" }
{ "26280","26345","37209","1911","","","","","","","Ori","","1538.473","5.710","-2.658","84.148723","-6.064752","B1V...","B","1","","" }
{ "88687","88964","166233","6795","","73    Oph","","73","","","Oph","","178.716","5.710","2.016","272.391222","3.993276","F2V","F","1","","" }
{ "89817","90096","169033","6881","","","","","","","Sct","","615.389","5.710","-0.669","275.800678","-12.014755","B5V","B","1","","" }
{ "90218","90497","170200","6928","","","","","","","Ser","","707.497","5.710","-0.971","276.994887","6.194104","B8III-IV","B","1","","" }
{ "90559","90842","170521","6937","","","","","","","CrA","","1101.880","5.710","-1.934","277.984263","-43.507383","K2III","K","1","","" }
{ "92007","92294","173168","7036","","The Pav","The","","The","","Pav","","220.824","5.710","1.557","282.158065","-65.077679","A9V","A","1","","" }
{ "95261","95557","182645","7378","","","","","","","Sgr","","698.408","5.710","-0.943","291.546007","-15.053251","B7IV","B","1","","" }
{ "95956","96258","184960","7451","GJ 4116","","","","","","Cyg","","81.908","5.710","3.711","293.582413","51.236620","F7V","F","1","","" }
{ "97774","98085","188727","7609","","10    Sge","","10","","","Sge","","326156.378","5.710","-14.290","299.005266","16.634799","G5Ibv SB","G","1","","" }
{ "99898","100221","193964","7792","","71    Dra","","71","","","Dra","","377.933","5.710","0.390","304.902947","62.257472","B9V","B","1","","" }
{ "105420","105761","203875","8195","","19    Aqr","","19","","","Aqr","","299.501","5.710","0.895","321.304279","-9.748552","F0IV","F","1","","" }
{ "107759","108102","208111","8360","","","","","","","Aqr","","292.517","5.710","0.946","328.543218","-4.276180","K2III","K","1","","" }
{ "56451","56620","100893","4469","","","","","","","Hya","","364.014","5.710","0.472","174.145589","-33.570057","K0III","K","1","","" }
{ "59740","59923","106887","4673","","","","","","","Com","","179.207","5.710","2.010","184.377408","28.937189","A4m","A","1","","" }
{ "60423","60610","108114","4724","","","","","","","Cen","","438.972","5.710","0.065","186.340584","-35.186417","B9IV/V","B","1","","" }
{ "62346","62541","111397","4865","","29    Com","","29","","","Com","","399.212","5.710","0.271","192.225887","14.122584","A1V","A","1","","" }
{ "62535","62732","111613","4876","","","","","","","Cru","","326156.378","5.710","-14.290","192.824911","-60.329789","A2Iab","A","1","","" }
{ "67573","67787","121107","5225","","7    Boo","","7","","","Boo","","689.548","5.710","-0.916","208.303882","17.932868","G5III","G","1","","" }
{ "73308","73536","132933","5594","","","","","","","Vir","","2296.876","5.710","-3.529","225.453829","-0.140295","M2III","M","1","","" }
{ "75436","75665","137066","5725","","","","","","","TrA","","682.335","5.710","-0.893","231.887889","-64.531504","K5/M0III","K","1","","" }
{ "77100","77336","141187","5870","","31Ups Ser","Ups","31","Ups","","Ser","","250.120","5.710","1.286","236.822167","14.115348","A3V","A","1","","" }
{ "59127","59309","105702","4629","","11    Vir","","11","","","Vir","","143.681","5.720","2.500","182.514243","5.807008","Am","A","1","","" }
{ "59564","59746","106574","4659","","","","","","","Dra","","465.938","5.720","-0.055","183.785497","70.200008","K2III","K","1","","" }
{ "66208","66417","118508","5123","","","","","","","Boo","","458.729","5.720","-0.021","204.246185","24.613297","M2III","M","1","","" }
{ "69541","69763","124471","5320","","","","","","","Cir","","1304.626","5.720","-2.290","214.161341","-66.587894","B1.5III","B","1","","" }
{ "71786","72012","129846","5493","","","","","","","Boo","","683.766","5.720","-0.887","220.935153","40.459254","K4III","K","1","","" }
{ "72939","73166","132146","5575","","","","","","","Boo","","532.066","5.720","-0.343","224.298657","16.388128","G5III:","G","1","","" }
{ "72957","73184","131977","5568","Gl 570A","","","","","","Lib","","19.049","5.720","6.888","224.366478","-21.415475","K4V","K","1","","Gl 570" }
{ "75031","75260","137443","5737","","","","","","","Dra","","368.122","5.720","0.457","230.660108","63.341439","K4III","K","1","","" }
{ "75123","75352","136956","5720","","","","","","","Lib","","562.339","5.720","-0.463","230.967665","-12.369501","G8III","G","1","","" }
{ "78730","78970","144415","5991","","","","","","","Lup","","178.716","5.720","2.026","241.817522","-36.755676","F0/F2V","F","1","","" }
{ "79425","79666","146388","6065","","16    Her","","16","","","Her","","347.715","5.720","0.581","243.869322","18.808087","K3III","K","1","","" }
{ "1977","1982","2054","96","","","","","","","Cas","","516.070","5.720","-0.276","6.276670","53.046786","B9IV","B","1","","" }
{ "2347","2353","2637","117","","12    Cet","","12","","","Cet","","567.228","5.720","-0.482","7.509824","-3.957332","M0III","M","1","","" }
{ "3271","3277","3980","183","","Xi  Phe","Xi","","Xi","","Phe","","218.603","5.720","1.589","10.443144","-56.501315","Ap","A","1","","" }
{ "10304","10328","13596","648","","19    Ari","","19","","","Ari","","478.937","5.720","-0.114","33.263763","15.279860","M0III","M","1","","" }
{ "12041","12072","16028","748","","","","","","","And","","623.626","5.720","-0.687","38.911424","37.312263","K4III","K","1","","" }
{ "12497","12530","16765","790","","84    Cet","","84","","","Cet","","73.674","5.720","3.951","40.308327","-0.695653","F7IV","F","1","","" }
{ "15373","15411","20631","997","","","","","","","Eri","","120.575","5.720","2.881","49.671439","-18.559794","F3V","F","1","","" }
{ "16129","16168","21402","1041","","","","","","","Per","","382.364","5.720","0.375","52.086235","33.807557","A2V","A","1","","" }
{ "17492","17534","23719","1169","","","","","","","Hor","","337.636","5.720","0.645","56.316156","-47.359476","K1III","K","1","","" }
{ "19933","19983","26755","1313","","","","","","","Cam","","260.301","5.720","1.210","64.283693","57.860355","K1III","K","1","","" }
{ "20350","20400","27628","1368","","60    Tau","","60","","","Tau","","144.765","5.720","2.484","65.514651","14.077198","A3m","A","1","","" }
{ "20790","20842","28226","1403","","","","","","","Tau","","153.702","5.720","2.354","67.003247","21.619907","Am","A","1","","" }
{ "22033","22086","30238","1521","","","","","","","Eri","","712.132","5.720","-0.976","71.267335","-21.283383","K4III","K","1","","" }
{ "27248","27316","38545","1989","","131    Tau","","131","","","Tau","","339.746","5.720","0.631","86.804799","14.488322","A3Vn","A","1","","" }
{ "109485","109831","211211","8489","","","","","","","Lac","","268.663","5.720","1.141","333.684833","42.953910","A2Vnn","A","1","","" }
{ "111013","111362","213930","8594","","","","","","","Lac","","344.410","5.720","0.602","338.419218","56.624737","G8III-IV","G","1","","" }
{ "111621","111974","214850","8631","","","","","","","Peg","","110.225","5.720","3.076","340.219487","14.549161","G3V+...","G","1","","" }
{ "112824","113184","216718","8716","","","","","","","Aqr","","272.024","5.720","1.114","343.795671","-4.987899","K0III-IV","K","1","","" }
{ "112947","113307","216823","8722","","Tau3Gru","Tau-3","","Tau","3","Gru","","243.400","5.720","1.356","344.199195","-47.969221","Am...","A","1","","" }
{ "117746","118114","224362","9061","","Gam2Oct","Gam-2","","Gam","2","Oct","","305.104","5.720","0.865","359.387389","-82.169804","K0III","K","1","","" }
{ "28838","28909","42525","2194","","Eta1Dor","Eta-1","","Eta","1","Dor","","321.653","5.720","0.750","91.539042","-66.039621","A0V","A","1","","" }
{ "29221","29294","42621","2200","","","","","","","Lep","","329.784","5.720","0.696","92.644504","-27.154343","K1III","K","1","","" }
{ "31557","31637","47500","2446","","","","","","","Col","","1144.408","5.720","-2.006","99.307650","-36.990651","B6IV","B","1","","" }
{ "32653","32740","49380","2512","","","","","","","Gem","","416.016","5.720","0.192","102.422147","32.606756","K3II","K","1","","" }
{ "34935","35029","56455","2761","","","","","","","Pup","","464.610","5.720","-0.048","108.691749","-46.849672","A0p","A","1","","" }
{ "42027","42146","72968","3398","","3    Hya","","3","","","Hya","","302.838","5.720","0.881","128.867493","-7.982292","A1spe...","A","1","","" }
{ "43521","43644","75486","3505","","5    UMa","","5","","","UMa","","289.659","5.720","0.978","133.344017","61.962268","F2III","F","1","","" }
{ "43798","43923","76291","3545","","","","","","","Lyn","","230.662","5.720","1.472","134.208268","45.631646","K1IV","K","1","","" }
{ "45028","45158","79181","3653","","","","","","","Hya","","303.967","5.720","0.873","137.994743","-19.747628","G8III","G","1","","" }
{ "46325","46457","81873","3755","","3    Leo","","3","","","Leo","","405.163","5.720","0.249","142.121571","8.188298","K0III","K","1","","" }
{ "47458","47594","83489","3838","","","","","","","UMa","","493.429","5.720","-0.179","145.562059","69.237537","G9III:","G","1","","" }
{ "48151","48287","85483","3904","","","","","","","Vel","","577.268","5.720","-0.520","147.674780","-46.933923","K0IIICN...","K","1","","" }
{ "48427","48561","85980","3925","","","","","","","Vel","","997.420","5.720","-1.707","148.573577","-45.283516","B+...","B","1","","" }
{ "85211","85470","157753","6483","","","","","","","Ara","","357.628","5.720","0.520","261.990027","-52.297168","K2III","K","1","","" }
{ "85626","85888","159501","6550","","","","","","","Her","","324.534","5.720","0.731","263.280295","41.243449","K1III:","K","1","","" }
{ "88025","88298","164402","6716","","","","","","","Sgr","","326156.378","5.720","-14.280","270.476586","-22.780298","B0Iab...","B","1","","" }
{ "88362","88636","165683","6768","","","","","","","Her","","692.476","5.720","-0.915","271.456704","32.230674","K0III","K","1","","" }
{ "95190","95485","182477","7367","","","","","","","Sgr","","504.886","5.720","-0.229","291.339970","-13.897130","K2III","K","1","","" }
{ "83278","83535","153716","6320","","","","","","","Ara","","569.208","5.730","-0.479","256.103012","-57.712166","B5IV","B","1","","" }
{ "86464","86731","161239","6608","","84    Her","","84","","","Her","","127.405","5.730","2.771","265.839878","24.327821","G2IIIb","G","1","","" }
{ "91686","91973","173649","7057","","7Zet2Lyr","Zet-2","7","Zet","2","Lyr","","155.535","5.730","2.338","281.200837","37.594615","F0IVvar","F","1","","" }
{ "93258","93552","176723","7197","","","","","","","CrA","","223.395","5.730","1.552","285.823725","-38.253147","F2III/IV","F","1","","" }
{ "95360","95656","183534","7408","","7Iot1Cyg","Iot-1","7","Iot","1","Cyg","","350.706","5.730","0.572","291.858178","52.320436","A1V","A","1","","" }
{ "98441","98754","190229","7664","","","","","","","Aql","","638.271","5.730","-0.728","300.875065","16.031255","B9MNp...","B","1","","" }
{ "98454","98767","190360","7670","Gl 777A","","","","","","Cyg","","51.722","5.730","4.729","300.905601","29.896805","G6IV+...","G","1","","Gl 777" }
{ "99507","99825","192310","7722","Gl 785","","","","","","Cap","","29.064","5.730","5.980","303.822091","-27.032977","K3V","K","1","","" }
{ "100533","100859","195068","7828","","43    Cyg","","43","","","Cyg","","122.523","5.730","2.856","306.759358","49.383367","F0V:","F","1","","" }
{ "104641","104978","202103","8114","","","","","","","Ind","","428.027","5.730","0.140","318.941069","-53.263084","A6IV","A","1","","" }
{ "106313","106654","205471","8253","","8    PsA","","8","","","PsA","","190.623","5.730","1.896","324.045695","-26.171516","A7/A8IV","A","1","","" }
{ "106819","107162","206644","8300","","77    Cyg","","77","","","Cyg","","412.334","5.730","0.221","325.595642","41.077019","A0V","A","1","","" }
{ "111196","111546","214167","","","","","","","","Lac","","2159.976","5.730","-3.375","338.967854","39.634331","B1Ve","B","1","","" }
{ "112862","113222","216831","8723","","","","","","","Lac","","623.626","5.730","-0.677","343.935436","36.351390","B7III","B","1","","" }
{ "116721","117088","222820","8996","","","","","","","Tuc","","728.028","5.730","-1.014","356.050143","-64.404451","K3II","K","1","","" }
{ "55631","55797","99283","4407","","","","","","","UMa","","306.826","5.730","0.863","171.488093","55.850459","K0III","K","1","","" }
{ "56859","57029","101606","4501","","62    UMa","","62","","","UMa","","134.221","5.730","2.658","175.392897","31.746058","F4V","F","1","","" }
{ "57497","57670","102713","4536","","","","","","","UMa","","226.497","5.730","1.522","177.423875","34.931758","F5IV","F","1","","" }
{ "60144","60329","107567","4704","","Zet1Mus","Zet-1","","Zet","1","Mus","","326.810","5.730","0.726","185.550137","-68.307316","K0III","K","1","","" }
{ "66191","66400","118349","5120","","","","","","","Hya","","266.033","5.730","1.172","204.201896","-26.495198","A7V+...","A","1","","" }
{ "66516","66727","119055","5144","","1    Boo","","1","","","Boo","","328.125","5.730","0.717","205.168629","19.955719","A1V","A","1","","" }
{ "67450","67664","120404","5194","","","","","","","Cir","","728.028","5.730","-1.014","207.947608","-69.401258","K5/M0III","K","1","","" }
{ "77750","77986","142926","5938","","4    Her","","4","","","Her","","536.441","5.730","-0.350","238.877487","42.566193","B9p","B","1","","" }
{ "78422","78661","145622","6034","","","","","","","UMi","","513.632","5.730","-0.256","240.880774","76.793939","A3V","A","1","","" }
{ "82171","82422","152173","6258","","50    Her","","50","","","Her","","1069.365","5.730","-1.849","252.662329","29.806538","M1III","M","1","","" }
{ "4190","4200","5276","257","","","","","","","Tuc","","712.132","5.730","-0.966","13.407592","-62.871352","M4III","M","1","","" }
{ "12838","12871","17504","833","","Gam Hor","Gam","","Gam","","Hor","","182.618","5.730","1.989","41.364433","-63.704553","G8III/IV","G","1","","" }
{ "20527","20579","27777","1377","","55    Per","","55","","","Per","","448.017","5.730","0.041","66.121469","34.130758","B8V","B","1","","" }
{ "21766","21819","29646","1490","","","","","","","Tau","","381.470","5.730","0.390","70.332323","28.614994","A2V","A","1","","" }
{ "25131","25194","35515","1793","","","","","","","Col","","649.714","5.730","-0.766","80.850084","-39.678423","M2III","M","1","","" }
{ "26900","26966","38206","1975","","","","","","","Lep","","244.862","5.730","1.353","85.840290","-18.557475","A0V","A","1","","" }
{ "31113","31190","46547","2397","","","","","","","CMa","","1753.529","5.730","-2.922","98.162403","-32.030447","B2V","B","1","","" }
{ "33628","33715","52005","2615","","41    Gem","","41","","","Gem","","326156.378","5.730","-14.270","105.065934","16.078998","K3Ib","K","1","","" }
{ "37216","37322","61878","2963","","","","","","","Pup","","572.204","5.730","-0.491","114.932568","-38.139287","B5V","B","1","","" }
{ "39910","40023","67767","3191","","14Psi Cnc","Psi","14","Psi","","Cnc","","134.887","5.730","2.647","122.613275","25.507334","G8IV","G","1","","" }
{ "40657","40772","69148","3245","","","","","","","UMa","","461.978","5.730","-0.026","124.821549","62.507159","G8III","G","1","","" }
{ "44795","44923","78702","3638","","","","","","","Hya","","272.934","5.730","1.117","137.267549","-18.328548","A0/A1V","A","1","","" }
{ "47056","47189","83189","3826","","8    Leo","","8","","","Leo","","1160.699","5.730","-2.026","144.260753","16.437952","K1III","K","1","","" }
{ "50641","50786","89744","4067","GJ 9326","","","","","","UMa","","128.611","5.730","2.751","155.544105","41.229530","F7V","F","1","","" }
{ "53222","53377","94497","4256","","","","","","","UMa","","289.917","5.730","0.986","163.742443","34.034798","G7III:","G","1","","" }
{ "28912","28984","41933","2166","","","","","","","Lep","","1254.448","5.740","-2.185","91.739639","-21.812299","M3II/III","M","1","","" }
{ "30767","30840","45871","2364","","","","","","","CMa","","862.848","5.740","-1.373","97.163513","-32.371279","B5IV","B","1","","" }
{ "32724","32810","50123","2545","","","","","","","CMa","","649.714","5.740","-0.756","102.597287","-31.706057","B3V","B","1","","" }
{ "33190","33277","50692","2569","Gl 252","37    Gem","","37","","","Gem","","56.234","5.740","4.557","103.827791","25.375697","G0V","G","1","","" }
{ "34297","34387","54079","2682","","","","","","","CMi","","595.176","5.740","-0.566","106.956203","7.471214","K0III:","K","1","","" }
{ "35545","35643","56963","2776","","","","","","","Lyn","","115.741","5.740","2.990","110.322960","45.228200","A7s","A","1","","" }
{ "38670","38783","65662","3120","","","","","","","Car","","1309.865","5.740","-2.279","119.077715","-60.526436","K4II","K","1","","" }
{ "41182","41299","71095","3305","","","","","","","Hya","","893.579","5.740","-1.449","126.398074","2.102209","K5III","K","1","","" }
{ "42804","42923","74824","3479","","","","","","","Pyx","","1583.283","5.740","-2.691","131.216367","-37.147249","B2III","B","1","","" }
{ "44376","44504","77309","3592","","","","","","","UMa","","390.139","5.740","0.351","136.001675","54.283887","A2V","A","1","","" }
{ "45830","45962","81136","3730","","","","","","","Vel","","531.199","5.740","-0.319","140.599972","-46.047445","G6/G8III","G","1","","" }
{ "46680","46813","82573","3796","","","","","","","Hya","","377.059","5.740","0.425","143.085041","-19.400303","A4III","A","1","","" }
{ "50306","50448","88983","4026","","32    UMa","","32","","","UMa","","259.472","5.740","1.237","154.508743","65.108351","A8III","A","1","","" }
{ "52187","52338","92354","4176","","","","","","","UMa","","513.632","5.740","-0.246","160.451200","68.443499","K3III","K","1","","" }
{ "52336","52487","93163","4204","","","","","","","Car","","1173.224","5.740","-2.040","160.963354","-64.249042","B3:V","B","1","","" }
{ "54668","54829","97670","4361","","","","","","","Car","","2203.759","5.740","-3.409","168.378278","-59.619318","B1.5V","B","1","","" }
{ "55913","56080","99902","4426","","85    Leo","","85","","","Leo","","437.794","5.740","0.101","172.424359","15.413269","K4III","K","1","","" }
{ "61020","61212","109141","4776","","","","","","","Crv","","124.487","5.740","2.832","188.150004","-13.859105","F3IV/V","F","1","","" }
{ "65389","65595","117566","5091","","","","","","","Cam","","285.851","5.740","1.026","201.738074","78.643869","G2.5IIIb","G","1","","" }
{ "66456","66666","118767","5134","","","","","","","Cen","","513.632","5.740","-0.246","204.999331","-49.949956","M8III","M","1","","" }
{ "67726","67942","120913","5218","","","","","","","Cir","","942.648","5.740","-1.565","208.704696","-67.652100","K2III","K","1","","" }
{ "70885","71111","128000","5442","","","","","","","Dra","","620.069","5.740","-0.655","218.128887","55.398010","K5III","K","1","","" }
{ "71054","71280","128333","5452","","","","","","","Boo","","856.054","5.740","-1.355","218.665145","49.368354","M1III","M","1","","" }
{ "71227","71453","128207","5449","","","","","","","Cen","","481.057","5.740","-0.104","219.183905","-40.211580","B8V","B","1","","" }
{ "71342","71568","128902","5464","","","","","","","Boo","","900.984","5.740","-1.466","219.552549","43.642130","K2III","K","1","","" }
{ "72024","72250","129858","5494","","","","","","","Lup","","305.676","5.740","0.881","221.620853","-47.441116","A1V","A","1","","" }
{ "74521","74750","135160","5661","","","","","","","Cir","","1681.218","5.740","-2.821","229.152890","-60.903996","B0.5V","B","1","","" }
{ "75743","75974","138852","5785","","","","","","","Dra","","308.568","5.740","0.860","232.732705","64.208693","K0III-IV","K","1","","" }
{ "77409","77645","141318","5873","","","","","","","Nor","","2159.976","5.740","-3.365","237.778358","-55.055533","B2II","B","1","","" }
{ "78043","78279","142514","5920","","","","","","","TrA","","888.710","5.740","-1.437","239.742309","-65.037585","B7III","B","1","","" }
{ "79109","79349","145713","6039","","10    Her","","10","","","Her","","682.335","5.740","-0.863","242.908486","23.494801","M4IIIa","M","1","","" }
{ "81484","81734","150557","6205","","14    Oph","","14","","","Oph","","181.299","5.740","2.015","250.427005","1.181231","F2.7III-IV","F","1","","" }
{ "81859","82110","150745","6215","","","","","","","Ara","","985.367","5.740","-1.661","251.588442","-58.503595","B2IV-V","B","1","","" }
{ "82941","83196","153363","6310","","26    Oph","","26","","","Oph","","109.928","5.740","3.102","255.039613","-24.989070","F3V","F","1","","" }
{ "84512","84769","158996","6529","","","","","","","UMi","","959.283","5.740","-1.603","259.904408","80.136399","K5III","K","1","","" }
{ "86048","86313","160018","6568","","","","","","","Ser","","384.165","5.740","0.385","264.539602","-10.926268","K0III","K","1","","" }
{ "87766","88038","163652","6691","","","","","","","Sgr","","397.267","5.740","0.312","269.732026","-36.858376","G8III","G","1","","" }
{ "87864","88136","166866","6810","","41    Dra","","41","","","Dra","","207.215","5.740","1.725","270.037891","80.004095","K2Vvar","K","1","","" }
{ "88409","88684","165438","6756","","","","","","","Ser","","119.910","5.740","2.913","271.563320","-4.751252","K1IV","K","1","","" }
{ "90384","90664","169836","6908","","","","","","","Pav","","318.201","5.740","0.794","277.486291","-57.523143","K0III","K","1","","" }
{ "90709","90991","171130","6962","","","","","","","Sct","","226.970","5.740","1.527","278.412583","-14.853614","A0/A1V","A","1","","" }
{ "91033","91315","172728","7018","","","","","","","Dra","","388.281","5.740","0.361","279.389609","62.526591","A0V","A","1","","" }
{ "98021","98332","188097","7579","","","","","","","Pav","","228.721","5.740","1.511","299.671742","-69.163957","Am","A","1","","" }
{ "106543","106886","206267","8281","","","","","","","Cep","","1976.705","5.740","-3.173","324.740080","57.489037","O6 (f)","O","1","","" }
{ "107822","108165","208501","8371","","13    Cep","","13","","","Cep","","326156.378","5.740","-14.260","328.721483","56.611227","B8Ibvar","B","1","","" }
{ "108863","109209","210074","8435","","","","","","","Peg","","202.080","5.740","1.780","331.869118","19.475526","F2V:","F","1","","" }
{ "116758","117125","222806","8995","","","","","","","Oct","","484.631","5.740","-0.120","356.169642","-78.791442","K1III","K","1","","" }
{ "116947","117314","223170","9009","","","","","","","Aqr","","305.104","5.740","0.885","356.816304","-11.911126","K0III","K","1","","" }
{ "1351","1354","1239","60","","","","","","","Cas","","620.069","5.740","-0.655","4.237697","61.533185","G8III","G","1","","" }
{ "3759","3765","4628","222","Gl 33","","","","","","Psc","96 G. Psc","24.315","5.740","6.378","12.095730","5.280615","K2V","K","1","","" }
{ "11971","12002","16074","752","","77    Cet","","77","","","Cet","","458.729","5.740","-0.001","38.677603","-7.859445","K4III","K","1","","" }
{ "12090","12122","16307","767","","Iot1For","Iot-1","","Iot","1","For","","582.422","5.740","-0.519","39.038613","-30.044978","G8/K0III","G","1","","" }
{ "12607","12640","16811","793","","34Mu  Ari","Mu","34","Mu","","Ari","","381.024","5.740","0.402","40.591411","20.011465","A0V","A","1","","" }
{ "14641","14677","19548","944","","55    Ari","","55","","","Ari","","1055.522","5.740","-1.810","47.403086","29.077080","B8III","B","1","","" }
{ "16103","16142","21530","1050","","","","","","","Eri","","318.512","5.740","0.792","52.003947","-11.286600","K2III","K","1","","" }
{ "17300","17342","22764","1112","","","","","","","Cam","","2064.281","5.740","-3.267","55.678060","59.969391","K4Ib","K","1","","" }
{ "20774","20825","28732","1435","","","","","","","Ret","","358.020","5.740","0.538","66.941817","-62.521206","K0III","K","1","","" }
{ "23419","23474","32503","1634","","1    Lep","","1","","","Lep","","467.943","5.740","-0.044","75.687418","-22.795052","K1IV","K","1","","" }
{ "26279","26344","36678","1866","","","","","","","Aur","","746.353","5.740","-1.058","84.146753","54.428658","M0III","M","1","","" }
{ "7262","7276","9562","448","","","","","","","Cet","","96.268","5.750","3.400","23.428484","-7.025341","G2IV","G","1","","" }
{ "7901","7916","10453","492","","","","","","","Cet","","128.661","5.750","2.770","25.436805","-11.324669","F5V+...","F","1","","" }
{ "10692","10718","13982","661","","8    Per","","8","","","Per","","410.776","5.750","0.249","34.499402","57.899820","K3III","K","1","","" }
{ "14026","14060","18784","907","","8Rho1Eri","Rho-1","8","Rho","1","Eri","","323.889","5.750","0.765","45.291765","-7.663012","K0II","K","1","","" }
{ "19476","19525","26311","1286","","","","","","","Per","","982.399","5.750","-1.644","62.745921","33.586792","K1II-III","K","1","","" }
{ "22883","22936","31134","1561","","","","","","","Cam","","423.030","5.750","0.185","74.029480","52.869761","A2Vs","A","1","","" }
{ "24368","24426","34266","1721","","","","","","","Col","","497.190","5.750","-0.165","78.620185","-35.976996","G8III","G","1","","" }
{ "25954","26019","36874","1881","","","","","","","Col","","257.424","5.750","1.264","83.280728","-35.139376","K0III","K","1","","" }
{ "84926","85185","157740","6481","","","","","","","Her","","407.695","5.750","0.265","261.131403","16.301006","A3V","A","1","","" }
{ "86515","86782","161693","6618","","","","","","","Dra","Alruba","532.935","5.750","-0.316","265.996545","53.801715","A2V","A","1","","" }
{ "97163","97473","187259","7544","","52Pi  Aql","Pi","52","Pi","","Aql","","514.442","5.750","-0.240","297.175239","11.815896","F2V:+...","F","1","","" }
{ "98167","98478","188584","7603","","Mu 1Pav","Mu-1","","Mu","1","Pav","","238.942","5.750","1.426","300.096268","-66.949360","K0IV","K","1","","" }
{ "101761","102092","196917","7909","","","","","","","Mic","","452.995","5.750","0.037","310.348529","-31.598289","M1III","M","1","","" }
{ "101877","102208","199095","8002","","76    Dra","","76","","","Dra","","352.601","5.750","0.581","310.646324","82.531158","A0V","A","1","","" }
{ "104027","104364","200751","8073","","","","","","","Pav","","512.020","5.750","-0.229","317.136255","-63.928260","K0III","K","1","","" }
{ "104180","104516","201834","8106","","","","","","","Cyg","","443.147","5.750","0.084","317.564857","53.563100","B9III","B","1","","" }
{ "104943","105282","203245","8161","","","","","","","Cyg","","545.412","5.750","-0.366","319.869774","49.510294","B6V","B","1","","" }
{ "105662","106003","204485","8220","","","","","","","Cyg","","145.866","5.750","2.497","322.034320","32.225330","F0V","F","1","","" }
{ "108677","109023","209761","8415","","","","","","","Peg","","389.208","5.750","0.366","331.297216","26.673689","K2III","K","1","","" }
{ "29152","29225","42087","2173","","3    Gem","","3","","","Gem","","326156.378","5.750","-14.250","92.433270","23.113466","B2.5Ib","B","1","","" }
{ "30754","30827","45412","2332","","48    Aur","","48","","","Aur","","326156.378","5.750","-14.250","97.142037","30.493034","F5.5Ibv","F","1","","" }
{ "31857","31940","45866","2363","","","","","","","Cam","","698.408","5.750","-0.903","100.120190","77.995782","K5III","K","1","","" }
{ "32531","32617","49434","2514","","","","","","","Mon","","130.410","5.750","2.741","102.079441","-1.318922","F1V","F","1","","" }
{ "32612","32698","49643","2521","","","","","","","Mon","","574.219","5.750","-0.478","102.318371","-2.272038","B8IIIn","B","1","","" }
{ "32937","33024","50277","2551","","","","","","","Mon","","203.213","5.750","1.777","103.206117","8.380373","F0Vn","F","1","","" }
{ "34269","34360","54309","2690","","","","","","","CMa","","326156.378","5.750","-14.250","106.844115","-23.840722","B2V:nn","B","1","","" }
{ "34629","34722","54801","2700","","47    Gem","","47","","","Gem","","388.744","5.750","0.369","107.846117","26.856587","A4IV","A","1","","" }
{ "35060","35152","55870","2738","","53    Gem","","53","","","Gem","","769.237","5.750","-1.113","108.988196","27.897419","M1III","M","1","","" }
{ "36293","36396","59381","2867","","","","","","","Mon","","1294.271","5.750","-2.243","112.342111","-10.326664","K5III","K","1","","" }
{ "41397","41515","71801","3343","","","","","","","Pyx","","929.220","5.750","-1.523","126.997590","-35.113761","B2V","B","1","","" }
{ "43674","43798","76376","3554","","","","","","","Hya","","446.178","5.750","0.070","133.801789","-18.241189","K2/K3III","K","1","","" }
{ "46524","46657","82383","3780","","Zet1Ant","Zet-1","","Zet","1","Ant","","405.667","5.750","0.276","142.692066","-31.889222","A0","A","1","","" }
{ "48842","48982","86513","3942","","","","","","","Leo","","342.962","5.750","0.641","149.900927","29.645233","G9III:","G","1","","" }
{ "54679","54840","97651","4360","","","","","","","Cen","","424.130","5.750","0.180","168.414167","-53.231813","K2III","K","1","","" }
{ "59049","59229","105509","4624","","","","","","","Cen","","339.746","5.750","0.661","182.224213","-44.325989","A3III","A","1","","" }
{ "62697","62894","111904","4887","","","","","","","Cru","","326156.378","5.750","-14.250","193.341239","-60.328489","B9Ia","B","1","","" }
{ "62824","63024","112264","4909","","","","","","","CVn","","695.429","5.750","-0.894","193.735525","47.196722","M5III","M","1","","" }
{ "65261","65466","116706","5057","","","","","","","Com","","285.351","5.750","1.040","201.277829","23.854419","A3IV","A","1","","" }
{ "73838","74066","133880","5624","","","","","","","Lup","","361.192","5.750","0.528","227.050541","-40.583930","B8IV Si","B","1","","" }
{ "74011","74239","134373","5641","","","","","","","Lib","","425.236","5.750","0.174","227.577638","-26.332621","K0III","K","1","","" }
{ "74354","74582","134453","5644","","","","","","","TrA","","1173.224","5.750","-2.030","228.579876","-70.079476","N0v","N","1","","" }
{ "78766","79005","144708","6002","","11    Sco","","11","","","Sco","","366.468","5.750","0.497","241.901734","-12.745410","B9V","B","1","","" }
{ "80133","80375","148330","6127","","","","","","","Dra","","391.075","5.750","0.356","246.105557","55.205096","A2svar...","A","1","","" }
{ "109677","110023","211434","8504","","44    Aqr","","44","","","Aqr","","309.153","5.750","0.866","334.277082","-5.387164","G6III","G","1","","" }
{ "109757","110103","211833","8511","","25    Cep","","25","","","Cep","","921.346","5.750","-1.505","334.552582","62.804388","K3III","K","1","","" }
{ "115171","115537","220440","8898","","","","","","","Gru","","588.730","5.750","-0.532","351.055217","-51.891174","M0III","M","1","","" }
{ "115390","115755","220885","8913","","13    And","","13","","","And","","300.052","5.750","0.931","351.780757","42.912010","B9III","B","1","","" }
{ "109274","109620","211029","8483","","","","","","","Cep","","948.129","5.760","-1.557","333.093531","63.291035","M3III","M","1","","" }
{ "110256","110602","212430","8534","","50    Aqr","","50","","","Aqr","","458.085","5.760","0.022","336.112748","-13.529369","K0III","K","1","","" }
{ "110439","110785","212754","8548","GJ 9782A","34    Peg","","34","","","Peg","","124.440","5.760","2.852","336.655770","4.393766","F7V","F","1","","GJ 9782" }
{ "110849","111196","211539","8505","","Ups Oct","Ups","","Ups","","Oct","","324.211","5.760","0.773","337.907524","-85.967253","K0III","K","1","","" }
{ "113143","113503","217232","8739","","52    Peg","","52","","","Peg","","307.695","5.760","0.887","344.799222","11.728844","A7V","A","1","","" }
{ "117388","117756","223807","9040","","","","","","","Aqr","","616.553","5.760","-0.623","358.210534","-8.996756","K0III","K","1","","" }
{ "29360","29433","42509","2193","","68    Ori","","68","","","Ori","","832.031","5.760","-1.274","93.005584","19.790543","B9.5V","B","1","","" }
{ "29996","30069","44323","2279","","","","","","","Col","","407.695","5.760","0.275","94.920649","-34.396591","B9V","B","1","","" }
{ "30518","30591","45572","2348","","","","","","","Pup","","587.669","5.760","-0.519","96.431888","-48.176898","B9V","B","1","","" }
{ "30763","30836","45765","2359","","","","","","","CMa","","456.163","5.760","0.032","97.155913","-17.466009","K0III","K","1","","" }
{ "31657","31737","47152","2425","","53    Aur","","53","","","Aur","","346.606","5.760","0.628","99.595868","28.984354","B9npe...","B","1","","" }
{ "37223","37329","61899","2964","","","","","","","Pup","","1148.438","5.760","-1.973","114.949485","-38.260652","B3III","B","1","","" }
{ "38362","38474","64235","3072","","","","","","","Mon","","129.530","5.760","2.765","118.199411","-5.428257","F5IVs","F","1","","" }
{ "41970","42090","72524","3377","","33    Lyn","","33","","","Lyn","","354.903","5.760","0.577","128.682866","36.419619","A2Vnn","A","1","","" }
{ "44808","44936","78668","3636","","","","","","","Hya","","452.995","5.760","0.047","137.297976","-12.357706","G6III","G","1","","" }
{ "51413","51561","91355","4135","","","","","","","Vel","","544.501","5.760","-0.353","157.989332","-45.066710","B9","B","1","","" }
{ "7736","7751","10360","486","Gl 66B","","","","","","Eri","p Eridani","25.513","5.760","6.293","24.947541","-56.196400","K0V","K","2","118084","Gl 66" }
{ "8974","8993","11763","559","","7    Ari","","7","","","Ari","","557.532","5.760","-0.404","28.962663","23.577322","K1III","K","1","","" }
{ "12659","12692","16727","785","","11    Per","","11","","","Per","","431.424","5.760","0.153","40.761762","55.106019","B7IIIp...","B","1","","" }
{ "13620","13654","18191","867","","45Rho2Ari","Rho-2","45","Rho","2","Ari","","351.462","5.760","0.598","43.952075","18.331640","M6IIIvar","M","1","","" }
{ "16244","16285","21882","1075","","","","","","","Eri","","213.453","5.760","1.681","52.479834","-42.634256","A5V","A","1","","" }
{ "16470","16511","21933","1079","","6    Tau","","6","","","Tau","","350.329","5.760","0.605","53.149787","9.373438","B9IV","B","1","","" }
{ "17537","17579","23432","1151","","21    Tau","","21","","","Tau","Asterope","371.900","5.760","0.475","56.476980","24.554511","B8V","B","1","","" }
{ "18167","18212","24240","1198","","","","","","","Per","","393.909","5.760","0.350","58.411217","48.650495","K0III","K","1","","" }
{ "20218","20268","27497","1360","","","","","","","Tau","","360.793","5.760","0.541","65.171857","6.130798","G8III-IV","G","1","","" }
{ "21139","21192","28843","1441","","","","","","","Eri","","475.447","5.760","-0.058","68.156472","-3.209541","B9III","B","1","","" }
{ "22272","22325","30606","1538","","59    Eri","","59","","","Eri","","136.069","5.760","2.658","72.135553","-16.329484","F8V","F","1","","" }
{ "26154","26219","37192","1909","","","","","","","Col","","301.438","5.760","0.931","83.814464","-33.079724","K0III","K","1","","" }
{ "83112","83367","154084","6333","","","","","","","Her","","313.010","5.760","0.849","255.577886","25.505620","G7III:","G","1","","" }
{ "84432","84690","156293","6420","","","","","","","Sco","","363.608","5.760","0.524","259.699299","-44.129746","B9V","B","1","","" }
{ "84809","85068","156854","6442","","","","","","","Ara","","395.341","5.760","0.342","260.779653","-56.525547","G8/K0III","G","1","","" }
{ "84910","85169","156942","6447","","","","","","","Ara","","888.710","5.760","-1.417","261.078318","-60.673799","B8Ib/II","B","1","","" }
{ "85991","86254","160181","6571","","79    Her","","79","","","Her","","250.120","5.760","1.336","264.379562","24.309991","A2Vn","A","1","","" }
{ "87564","87836","163318","6680","","","","","","","Sgr","","167.346","5.760","2.209","269.174323","-28.065394","A7III/IV","A","1","","" }
{ "89690","89968","168608","6863","","","","","","","Sgr","","1235.441","5.760","-2.132","275.345778","-18.859999","F8II","F","1","","" }
{ "90480","90762","170878","6955","","","","","","","Her","","435.456","5.760","0.132","277.768538","16.928556","A2V","A","1","","" }
{ "91039","91322","171978","6993","","","","","","","Ser","","523.525","5.760","-0.268","279.399838","-0.309472","A2V","A","1","","" }
{ "91568","91854","172211","7004","","","","","","","Pav","","355.290","5.760","0.574","280.905530","-64.551425","K0III","K","1","","" }
{ "95276","95572","182900","7389","","","","","","","Aql","","182.618","5.760","2.019","291.600561","13.023801","F6III","F","1","","" }
{ "95839","96141","183552","7411","","","","","","","Tel","","377.496","5.760","0.443","293.224205","-53.185618","Am","A","1","","" }
{ "97505","97816","187420","7548","","","","","","","Tel","","562.339","5.760","-0.423","298.157142","-54.971026","G8/K0III","G","1","","" }
{ "97617","97928","188154","7584","","56    Aql","","56","","","Aql","","632.086","5.760","-0.677","298.534488","-8.574211","K5III","K","1","","" }
{ "99775","100097","193592","7781","","","","","","","Cyg","","295.164","5.760","0.977","304.603140","55.397095","A2Vs","A","1","","" }
{ "101101","101427","193721","7785","","","","","","","Oct","","521.850","5.760","-0.261","308.323406","-80.964862","G6/G8II","G","1","","" }
{ "103341","103673","199623","8027","","","","","","","Ind","","91.360","5.760","3.523","315.089635","-51.265312","F5IV-V","F","1","","" }
{ "105355","105696","203585","8180","","The2Mic","The-2","","The","2","Mic","","390.607","5.760","0.368","321.103392","-41.006695","A0III","A","1","","" }
{ "56276","56445","100563","4455","GJ 9367","89    Leo","","89","","","Leo","","88.798","5.760","3.585","173.591458","3.060165","F5V","F","1","","" }
{ "61186","61379","109409","4788","","","","","","","Cen","","92.369","5.760","3.499","188.676718","-44.673018","G4IV","G","1","","" }
{ "62381","62576","111469","4869","","30    Com","","30","","","Com","","303.119","5.760","0.919","192.322742","27.552379","A2V","A","1","","" }
{ "64240","64445","114780","4986","","","","","","","Vir","","838.448","5.760","-1.290","198.137174","11.556096","M0III","M","1","","" }
{ "64939","65144","115912","5029","","","","","","","Cen","","413.379","5.760","0.245","200.240499","-46.880008","K1III","K","1","","" }
{ "65215","65420","116568","5050","","66    Vir","","66","","","Vir","","97.739","5.760","3.377","201.138452","-5.164010","F3V","F","1","","" }
{ "68058","68276","121996","5255","","10    Boo","","10","","","Boo","","472.006","5.760","-0.043","209.662180","21.696219","A0Vs","A","1","","" }
{ "72152","72378","130274","5517","","57    Hya","","57","","","Hya","","447.402","5.760","0.074","221.989826","-26.646155","B9.5V","B","1","","" }
{ "72261","72487","130945","5533","","38    Boo","","38","","","Boo","Merga","159.802","5.760","2.309","222.327796","46.116205","F7IVw","F","1","","" }
{ "73956","74184","133683","5621","","","","","","","TrA","","326156.378","5.760","-14.240","227.374654","-67.084133","F8Iab-Ib","F","1","","" }
{ "76333","76568","139798","5830","","","","","","","Boo","","116.443","5.760","2.997","234.567501","46.797751","F2V","F","1","","" }
{ "77808","78045","142139","5905","","","","","","","TrA","","215.285","5.760","1.662","239.024733","-60.482477","A3V","A","1","","" }
{ "79812","80054","146690","6073","","","","","","","Nor","","333.834","5.760","0.709","245.105175","-55.139706","G6III","G","1","","" }
{ "80652","80898","149009","6154","","","","","","","Her","","840.609","5.760","-1.296","247.805965","22.195458","K5III","K","1","","" }
{ "55911","56078","99922","4428","","","","","","","Crt","","445.569","5.770","0.093","172.410912","-24.464011","A0V","A","1","","" }
{ "59425","59607","106231","4648","","","","","","","Cen","","1424.264","5.770","-2.431","183.354339","-38.929188","B4III","B","1","","" }
{ "64486","64692","115271","5004","","19    CVn","","19","","","CVn","","241.597","5.770","1.422","198.883229","40.855199","A7V","A","1","","" }
{ "67449","67663","120640","5206","","","","","","","Cen","","1591.007","5.770","-2.671","207.946755","-46.898666","B2Vp","B","1","","" }
{ "68172","68390","122066","5257","","48    Hya","","48","","","Hya","","182.618","5.770","2.029","210.000553","-25.010403","F6V","F","1","","" }
{ "73778","74006","133631","5617","","","","","","","Lup","","337.636","5.770","0.695","226.858109","-49.088612","G8III","G","1","","" }
{ "76142","76376","139493","5818","","","","","","","Dra","","255.408","5.770","1.301","233.987731","54.630567","A2V","A","1","","" }
{ "81054","81300","149661","6171","Gl 631","12    Oph","","12","","","Oph","","31.804","5.770","5.825","249.089371","-2.324584","K2V","K","1","","" }
{ "81392","81641","150378","6195","","37    Her","","37","","","Her","","293.570","5.770","0.999","250.161195","4.219789","A1V","A","1","","" }
{ "1189","1191","1064","51","","","","","","","Cet","","338.688","5.770","0.688","3.727144","-9.569571","B9V","B","1","","" }
{ "2000","2006","2114","97","","44    Psc","","44","","","Psc","","469.966","5.770","-0.023","6.350868","1.939692","G5III","G","1","","" }
{ "5350","5361","6676","326","","","","","","","Cas","","602.877","5.770","-0.564","17.139407","58.263449","B8V","B","1","","" }
{ "20539","20591","27786","1379","","56    Per","","56","","","Per","","132.476","5.770","2.726","66.156067","33.959686","F4V","F","1","","" }
{ "22283","22336","30562","1536","","","","","","","Eri","","86.171","5.770","3.660","72.151603","-5.674045","F8V","F","1","","" }
{ "25519","25583","35802","1816","","117    Tau","","117","","","Tau","","613.076","5.770","-0.600","82.006709","17.239130","M1III","M","1","","" }
{ "25687","25751","36166","1833","","","","","","","Ori","","1430.510","5.770","-2.440","82.478225","1.789260","B2V","B","1","","" }
{ "114413","114775","219263","8835","","","","","","","Gru","","249.737","5.770","1.350","348.744162","-41.105397","K2III","K","1","","" }
{ "114916","115280","220117","8885","","12    And","","12","","","And","","136.868","5.770","2.656","350.221851","38.182326","F5V","F","1","","" }
{ "117124","117491","223438","9022","","21    Psc","","21","","","Psc","","303.684","5.770","0.925","357.364481","1.076131","A5m","A","1","","" }
{ "117261","117628","223637","9030","","80    Peg","","80","","","Peg","","844.965","5.770","-1.297","357.838536","9.313351","M3III","M","1","","" }
{ "32723","32809","49980","2535","","","","","","","CMa","","1186.023","5.770","-2.033","102.590705","-17.084555","K3III","K","1","","" }
{ "34794","34888","55589","2723","","","","","","","CMa","","660.235","5.770","-0.761","108.279974","-11.251341","K0","K","1","","" }
{ "35843","35941","57927","2816","","59    Gem","","59","","","Gem","","187.231","5.770","1.975","111.139385","27.637857","F0:III:","F","1","","" }
{ "37263","37369","61294","2935","","","","","","","Lyn","","1173.224","5.770","-2.010","115.061245","38.344539","M0III","M","1","","" }
{ "38884","38994","66194","3147","","","","","","","Car","","1052.117","5.770","-1.773","119.710643","-60.824462","B2IVnpe","B","1","","" }
{ "40042","40155","68808","3232","","","","","","","Vel","","2452.304","5.770","-3.611","122.999871","-46.644351","F7p","F","1","","" }
{ "40229","40344","69123","3242","","","","","","","Pup","","224.626","5.770","1.580","123.555260","-35.490019","K1III","K","1","","" }
{ "46093","46225","81830","3752","","","","","","","Car","","252.443","5.770","1.326","141.363793","-61.950476","A4V+...","A","1","","" }
{ "46880","47013","82189","3768","","22    UMa","","22","","","UMa","","160.116","5.770","2.315","143.722627","72.205679","F7V","F","1","","" }
{ "49886","50027","88547","4004","","19    Sex","","19","","","Sex","","416.016","5.770","0.242","153.201520","4.614680","K0III:","K","1","","" }
{ "52301","52452","92841","4193","","35    Sex","","35","","","Sex","","552.807","5.770","-0.376","160.837165","4.747669","K3III+...","K","1","","" }
{ "54651","54811","97576","4354","","","","","","","Cen","","628.432","5.770","-0.654","168.311194","-44.372216","K5/M0III","K","1","","" }
{ "84879","85139","157617","6476","","","","","","","Oph","","723.185","5.770","-0.959","260.990067","8.852571","K1III","K","1","","" }
{ "87287","87558","162917","6670","","","","","","","Oph","","101.512","5.770","3.305","268.309105","6.101424","F4IV-V","F","1","","" }
{ "90522","90804","170740","6946","","","","","","","Sct","","1076.424","5.770","-1.823","277.857057","-10.795836","B2V","B","1","","" }
{ "103850","104185","201078","8084","","","","","","","Cyg","","1689.929","5.770","-2.802","316.626016","31.184657","F7.5Ib-IIv","F","1","","" }
{ "106051","106393","205314","8246","","","","","","","Cyg","","492.683","5.770","-0.126","323.235778","49.977629","A0V","A","1","","" }
{ "106554","106897","206043","8276","","","","","","","Peg","","129.633","5.770","2.774","324.754933","20.265451","F2V","F","1","","" }
{ "82523","82775","152408","6272","","","","","","","Sco","","2264.975","5.780","-3.428","253.743771","-41.150858","O8Iab+...","O","1","","" }
{ "85439","85699","166926","6811","","24    UMi","","24","","","UMi","","152.910","5.780","2.425","262.695843","86.968047","A2m","A","1","","" }
{ "86285","86552","160263","6572","","","","","","","Ara","","801.367","5.780","-1.172","265.317658","-46.921830","A0V","A","1","","" }
{ "87122","87393","161814","6624","","","","","","","Pav","","401.670","5.780","0.328","267.897798","-60.164056","K0III","K","1","","" }
{ "91122","91405","171961","6990","","","","","","","Sgr","","492.683","5.780","-0.116","279.627979","-23.504893","B8III","B","1","","" }
{ "93550","93845","178187","7250","","","","","","","Vul","","349.578","5.780","0.629","286.659978","24.250793","A4III","A","1","","" }
{ "101149","101475","196178","7870","","","","","","","Cyg","","431.424","5.780","0.173","308.478505","46.693866","B9sp...","B","1","","" }
{ "102894","103226","199012","8000","","19    Cap","","19","","","Cap","","364.828","5.780","0.537","313.699241","-17.922894","K0III","K","1","","" }
{ "105587","105928","204139","8207","","35    Cap","","35","","","Cap","","560.406","5.780","-0.395","321.811751","-21.196210","K3III","K","1","","" }
{ "107544","107887","207840","8348","","","","","","","Peg","","526.909","5.780","-0.262","327.892698","19.826682","B8III","B","1","","" }
{ "109125","109471","210502","8458","","","","","","","Peg","","680.911","5.780","-0.818","332.655970","11.624539","M1III","M","1","","" }
{ "110322","110668","212211","8527","","","","","","","Ind","","161.304","5.780","2.309","336.293595","-70.431622","F3III","F","1","","" }
{ "117519","117887","224062","9047","","","","","","","Psc","","637.024","5.780","-0.674","358.694263","0.109309","M5IIb","M","1","","" }
{ "58777","58952","104985","4609","","","","","","","Cam","Tonatiuh","316.657","5.780","0.844","181.311769","76.905734","G9III","G","1","","" }
{ "60780","60969","108732","4754","","","","","","","Cru","","508.824","5.780","-0.186","187.475823","-56.524940","M1III","M","1","","" }
{ "61305","61498","109573","4796","","","","","","","Cen","","237.377","5.780","1.470","189.004339","-39.869505","A0V","A","1","","" }
{ "64128","64332","114435","4970","","","","","","","Cen","","276.873","5.780","1.136","197.787068","-42.232891","F7IV","F","1","","" }
{ "71982","72208","130144","5512","","","","","","","Boo","","807.318","5.780","-1.188","221.524782","15.131788","M5III","M","1","","" }
{ "72707","72934","131530","5554","","13Xi 1Lib","Xi-1","13","Xi","1","Lib","","336.938","5.780","0.709","223.595306","-11.898348","G7III","G","1","","" }
{ "77326","77562","141168","5869","","","","","","","Nor","","308.276","5.780","0.902","237.529561","-53.209770","B8V","B","1","","" }
{ "77754","77990","142049","5900","","","","","","","Nor","","167.174","5.780","2.231","238.884973","-60.177647","Amvar","A","1","","" }
{ "77906","78142","142691","5929","","","","","","","Lup","","791.642","5.780","-1.146","239.338861","-36.185344","K0/K1III+..","K","1","","" }
{ "79257","79497","145361","6019","","Zet Nor","Zet","","Zet","","Nor","","217.728","5.780","1.658","243.344755","-55.540947","F2III","F","1","","" }
{ "343","343","225197","9101","","","","","","","Cet","","295.699","5.780","0.993","1.082469","-16.529036","K0III","K","1","","" }
{ "1072","1074","1032","47","","","","","","","Oct","","973.601","5.780","-1.595","3.331479","-84.993978","M0/M1III","M","1","","" }
{ "2870","2876","3283","146","","","","","","","Cas","","326156.378","5.780","-14.220","9.113932","60.326215","A4III","A","1","","" }
{ "8031","8046","10425","491","","44    Cas","","44","","","Cas","","1045.373","5.780","-1.749","25.832272","60.551332","B8IIIn","B","1","","" }
{ "8417","8433","11007","523","GJ 3115","","","","","","Tri","","90.852","5.780","3.555","27.173256","32.690210","F8V","F","1","","" }
{ "8760","8778","11522","547","","","","","","","Cet","","307.115","5.780","0.911","28.217132","-16.929250","F0V","F","1","","" }
{ "12154","12186","16417","772","Gl 105.1","Lam2For","Lam-2","","Lam","2","For","","84.082","5.780","3.724","39.244209","-34.577977","G1V","G","1","","" }
{ "12770","12803","17036","809","","37Omi Ari","Omi","37","Omi","","Ari","","594.092","5.780","-0.522","41.137390","15.311862","B9Vn","B","1","","" }
{ "14857","14893","19832","954","","56    Ari","","56","","","Ari","","502.552","5.780","-0.159","48.059356","27.256968","B9p Si","B","1","","" }
{ "15837","15876","20995","1019","","","","","","","Per","","435.456","5.780","0.152","51.123740","33.535962","A0V","A","1","","" }
{ "18038","18081","24131","1191","","","","","","","Per","","842.781","5.780","-1.281","57.973828","34.359119","B1V","B","1","","" }
{ "20248","20297","29116","1456","","Nu  Men","Nu","","Nu","","Men","","169.785","5.780","2.198","65.241820","-81.579920","F0/F2III","F","1","","" }
{ "21096","21148","28446","1417","","1    Cam","","1","","","Cam","","326156.378","5.780","-14.220","68.007671","53.910830","B0III SB","B","1","","" }
{ "21535","21588","29375","1472","","89    Tau","","89","","","Tau","","162.509","5.780","2.293","69.539343","16.033291","F0V","F","1","","" }
{ "21971","22024","30076","1508","","56    Eri","","56","","","Eri","","326156.378","5.780","-14.220","71.022169","-8.503571","B2Ve","B","1","","" }
{ "24980","25041","34989","1763","","","","","","","Ori","","1424.264","5.780","-2.421","80.431501","8.428556","B1V...","B","1","","" }
{ "25334","25397","35736","1812","","","","","","","Lep","","146.851","5.780","2.513","81.499271","-19.695399","F5V","F","1","","" }
{ "27212","27280","38527","1987","","","","","","","Ori","","297.860","5.780","0.977","86.717229","9.522343","G8III","G","1","","" }
{ "29315","29388","42126","2175","","41    Aur","","41","","","Aur","","334.177","5.780","0.727","92.902445","48.710989","A3V+...","A","1","","" }
{ "29378","29451","42471","2189","","","","","","","Aur","","931.875","5.780","-1.500","93.083854","32.693380","M1III","M","1","","" }
{ "30390","30463","45557","2345","","","","","","","Pic","","303.401","5.780","0.937","96.057756","-60.281325","A0V","A","1","","" }
{ "31367","31446","46769","2409","","","","","","","Mon","","1524.095","5.780","-2.568","98.815948","0.890216","B8Ib","B","1","","" }
{ "32765","32851","49933","2530","","","","","","","Mon","","96.811","5.780","3.418","102.707633","-0.540882","F2V","F","1","","" }
{ "33826","33914","52556","2632","","","","","","","Gem","","597.356","5.780","-0.534","105.572888","15.336008","K1III:","K","1","","" }
{ "34127","34215","53510","2663","","","","","","","Mon","","991.357","5.780","-1.634","106.412606","9.185800","M0III","M","1","","" }
{ "35027","35120","56031","2747","","","","","","","CMi","","542.690","5.780","-0.326","108.914291","7.977742","M4III","M","1","","" }
{ "36259","36362","59550","2873","","","","","","","Pup","","1069.365","5.780","-1.799","112.270480","-31.456216","B2IV","B","1","","" }
{ "36742","36848","60666","2916","","","","","","","Pup","","323.568","5.780","0.797","113.644992","-27.012275","K1III","K","1","","" }
{ "37117","37223","61641","2954","","","","","","","Pup","","997.420","5.780","-1.647","114.682918","-36.496830","B3III","B","1","","" }
{ "38052","38160","64185","3070","","","","","","","Car","","112.818","5.780","3.085","117.303851","-60.283688","F1V","F","1","","" }
{ "38102","38210","64484","3081","","","","","","","Vol","","491.940","5.780","-0.112","117.420812","-66.195974","B9V","B","1","","" }
{ "39110","39221","65301","3106","","","","","","","Lyn","","150.441","5.780","2.460","120.336509","59.047398","F2:V:","F","1","","" }
{ "43546","43669","76538","3560","","","","","","","Car","","1436.812","5.780","-2.440","133.452763","-60.353909","B5III","B","1","","" }
{ "44992","45122","79275","3658","","","","","","","Vel","","994.379","5.780","-1.641","137.889103","-46.583911","B2IV-V","B","1","","" }
{ "49936","50078","88842","4020","","","","","","","Vel","","341.525","5.780","0.680","153.366721","-51.755788","A3IV/V","A","1","","" }
{ "28827","28899","41843","2164","","","","","","","Col","","278.053","5.790","1.136","91.523075","-29.758624","A1V","A","1","","" }
{ "29938","30011","44081","2271","","","","","","","CMa","","1753.529","5.790","-2.862","94.745731","-20.925611","B3II/III","B","1","","" }
{ "31909","31992","47964","2461","","","","","","","Mon","","1254.448","5.790","-2.135","100.272669","0.495323","B8III","B","1","","" }
{ "35899","35998","58461","2832","","","","","","","CMa","","116.235","5.790","3.030","111.284662","-13.751978","F3V","F","1","","" }
{ "35924","36024","58612","2841","","","","","","","CMa","","1411.932","5.790","-2.392","111.355285","-25.217767","B5III","B","1","","" }
{ "36149","36251","59067","2859","","","","","","","CMa","","1583.283","5.790","-2.641","111.965255","-11.556867","B8Vv comp VB","B","1","","" }
{ "37401","37508","61885","2965","","","","","","","Gem","","778.416","5.790","-1.099","115.466031","13.480453","M2III","M","1","","" }
{ "42058","42177","73340","3413","","","","","","","Vel","","446.178","5.790","0.110","128.966799","-50.969651","B8 Si","B","1","","" }
{ "42893","43012","76236","3543","","","","","","","Cha","","498.710","5.790","-0.132","131.480081","-79.504373","K5III","K","1","","" }
{ "43480","43603","76110","3535","","","","","","","Vel","","698.408","5.790","-0.863","133.200078","-38.724086","K5/M0III","K","1","","" }
{ "45612","45743","80479","3704","","","","","","","Hya","","451.740","5.790","0.083","139.888054","-15.834663","K1/K2III","K","1","","" }
{ "45783","45915","80390","3698","","","","","","","UMa","","751.512","5.790","-1.023","140.430392","56.699219","M4IIIa","M","1","","" }
{ "48202","48339","85655","3913","","","","","","","Car","","771.055","5.790","-1.078","147.800208","-59.425774","K2IIICNp...","K","1","","" }
{ "51275","51420","90840","4113","","32    LMi","","32","","","LMi","","754.992","5.790","-1.033","157.526878","38.925132","A4V","A","1","","" }
{ "52327","52478","92728","4187","","39    UMa","","39","","","UMa","","369.792","5.790","0.517","160.930529","57.199203","A0Vs","A","1","","" }
{ "54401","54561","97023","4339","","","","","","","Hya","","394.385","5.790","0.378","167.472465","-32.367529","A1V","A","1","","" }
{ "54702","54863","97605","4358","","","","","","","Leo","","197.551","5.790","1.879","168.507640","8.060695","K3III","K","1","","" }
{ "60277","60463","107860","4714","","","","","","","Cen","","335.207","5.790","0.731","185.936471","-38.911381","B8/B9V","B","1","","" }
{ "63212","63414","112846","4921","","44    Vir","","44","","","Vir","","254.214","5.790","1.331","194.914655","-3.811926","A3V","A","1","","" }
{ "63976","64179","114256","4960","","","","","","","Vir","","308.276","5.790","0.912","197.301815","10.022468","K0III","K","1","","" }
{ "66470","66681","118666","5130","","","","","","","Cen","","226.497","5.790","1.582","205.044839","-64.576553","F3III-IV","F","1","","" }
{ "76297","76532","139254","5806","","","","","","","Lib","","274.774","5.790","1.162","234.450167","-23.141698","K0III","K","1","","" }
{ "78410","78649","144208","5983","","","","","","","CrB","","654.932","5.790","-0.724","240.830681","36.631787","A2V+...","A","1","","" }
{ "80428","80672","148247","6122","","","","","","","Sco","","359.996","5.790","0.576","247.060277","-37.179881","K1IIICN...","K","1","","" }
{ "82895","83150","152564","6276","","","","","","","TrA","","787.817","5.790","-1.125","254.891558","-69.268164","Ap Si","A","1","","" }
{ "88540","88817","166046","6782","","100    Her","","100","","","Her","","125.832","5.790","2.858","271.956262","26.097340","A3V","A","1","","" }
{ "90836","91118","171623","6977","","","","","","","Her","","647.136","5.790","-0.698","278.802508","18.203410","A0Vn","A","1","","" }
{ "94139","94434","179323","7277","","","","","","","Sgr","","1698.731","5.790","-2.793","288.306952","-25.906786","K2III","K","1","","" }
{ "95495","95793","183324","7400","","35    Aql","","35","","","Aql","","199.606","5.790","1.856","292.254117","1.950448","A0V","A","1","","" }
{ "97674","97985","188650","7606","","","","","","","Cyg","","1203.529","5.790","-2.045","298.701038","36.995676","Fp","F","1","","" }
{ "101696","102026","196857","7905","","","","","","","Cap","","327.466","5.790","0.781","310.135498","-16.124180","K0III","K","1","","" }
{ "106250","106592","205423","8251","","","","","","","Aqr","","418.149","5.790","0.250","323.823419","-3.983305","G9III:","G","1","","" }
{ "108413","108758","209419","8403","","","","","","","Cyg","","1000.480","5.790","-1.644","330.460766","52.882253","B5III","B","1","","" }
{ "108894","109240","210129","8438","","25    Peg","","25","","","Peg","","608.501","5.790","-0.564","331.959609","21.702926","B7Vn","B","1","","" }
{ "110232","110578","212404","8533","","51    Aqr","","51","","","Aqr","","405.667","5.790","0.316","336.028683","-4.837020","A0V","A","1","","" }
{ "110644","110992","213179","8564","","","","","","","Peg","","1254.448","5.790","-2.135","337.292607","26.763198","K2II","K","1","","" }
{ "112688","113048","216608","8708","","","","","","","Lac","","185.633","5.790","2.014","343.417320","44.749163","A3m","A","1","","" }
{ "113541","113902","217842","8771","","","","","","","Gru","","310.921","5.790","0.894","345.998486","-41.478896","K0III","K","1","","" }
{ "1653","1657","1632","79","","","","","","","And","","626.020","5.790","-0.626","5.189673","32.911186","K5III","K","1","","" }
{ "7104","7118","9377","441","","","","","","","Scl","","333.834","5.790","0.739","22.930204","-30.283081","K0III","K","1","","" }
{ "10517","10540","13871","656","","20    Ari","","20","","","Ari","","137.329","5.790","2.668","33.941828","25.782937","F6IV-V","F","1","","" }
{ "12082","12114","16160","753","Gl 105A","","","","","","Cet","268 G. Cet","23.419","5.790","6.509","39.020359","6.886870","K3V","K","1","","Gl 105" }
{ "12411","12444","16673","784","GJ 3175","","","","","","Cet","","70.965","5.790","4.102","40.051762","-9.452875","F6V","F","1","","" }
{ "15154","15192","20041","964","","","","","","","Per","","2861.021","5.790","-3.925","48.949881","57.140620","A0Ia","A","1","","" }
{ "16550","16591","21912","1078","","","","","","","Per","","182.823","5.790","2.047","53.395968","39.899478","A5m","A","1","","" }
{ "17543","17585","23005","1124","","","","","","","Cam","","180.796","5.790","2.071","56.503598","67.201605","F0IV","F","1","","" }
{ "21200","21253","29399","1475","","","","","","","Ret","","147.249","5.790","2.517","68.391797","-62.823677","K1III","K","1","","" }
{ "22860","22913","31373","1576","","","","","","","Ori","","363.608","5.790","0.554","73.958972","15.040278","B9V","B","1","","" }
{ "23014","23068","31553","1586","","99    Tau","","99","","","Tau","","455.526","5.790","0.065","74.452696","23.948562","G8III:","G","1","","" }
{ "23034","23088","31592","1590","","98    Tau","","98","","","Tau","","284.356","5.790","1.088","74.539132","25.050405","A0V","A","1","","" }
{ "26104","26169","37993","1964","","","","","","","Men","","1087.188","5.790","-1.824","83.686593","-73.741277","M2/M3III","M","1","","" }
{ "27481","27549","39007","2014","","","","","","","Ori","","358.414","5.790","0.585","87.511189","9.871218","G8III","G","1","","" }
{ "171","171","224930","9088","Gl 914A","85    Peg","","85","","","Peg","","39.693","5.800","5.374","0.542080","27.082256","G3V","G","1","","Gl 914" }
{ "418","418","225289","9110","","","","","","","Cas","","723.185","5.800","-0.929","1.275587","61.313970","B8MNp...","B","1","","" }
{ "3575","3583","4391","209","GJ 1021","","","","","","Phe","","49.440","5.800","4.897","11.439755","-47.551985","G5IV","G","1","","" }
{ "4257","4267","5267","254","","66    Psc","","66","","","Psc","","352.601","5.800","0.631","13.646777","19.188417","A1Vn","A","1","","" }
{ "5537","5550","7019","348","","45    And","","45","","","And","","789.725","5.800","-1.120","17.792833","37.724121","B7III-IV","B","1","","" }
{ "12207","12239","16024","747","","","","","","","Cas","","923.956","5.800","-1.461","39.400133","65.745336","K5III","K","1","","" }
{ "13022","13055","16458","774","","","","","","","Cep","","434.296","5.800","0.178","41.948523","81.448475","G8p...","G","1","","" }
{ "13800","13834","18404","878","","47    Ari","","47","","","Ari","","108.178","5.800","3.196","44.521717","20.668733","F5IV","F","1","","" }
{ "18172","18217","24141","1192","","","","","","","Cam","","164.726","5.800","2.283","58.430175","57.975141","A5m","A","1","","" }
{ "19522","19571","26591","1300","","","","","","","Eri","","264.094","5.800","1.258","62.900842","-20.356157","A1V + (F/G)","A","1","","" }
{ "23861","23916","33224","1671","","","","","","","Eri","","680.911","5.800","-0.798","77.084125","-8.665324","B8V","B","1","","" }
{ "25644","25708","36134","1830","","","","","","","Ori","","492.683","5.800","-0.096","82.348689","-3.446394","K1III...","K","1","","" }
{ "85736","85998","159480","6548","","53    Oph","","53","","","Oph","","337.636","5.800","0.725","263.652894","9.586700","A2V","A","1","","" }
{ "92079","92367","173791","7065","","","","","","","Tel","","358.414","5.800","0.595","282.363855","-45.810100","G6IV","G","1","","" }
{ "98201","98512","189198","7630","","","","","","","Sgr","","265.384","5.800","1.248","300.201356","-45.112918","A8III","A","1","","" }
{ "98504","98819","190406","7672","Gl 779","15    Sge","","15","","","Sge","","57.952","5.800","4.552","301.025980","17.070173","G1V","G","1","","" }
{ "108986","109332","210191","8439","","35    Aqr","","35","","","Aqr","","2329.688","5.800","-3.469","332.245794","-18.519592","B2III","B","1","","" }
{ "28783","28855","41759","2160","","","","","","","Col","","271.119","5.800","1.201","91.363237","-35.513647","A0V","A","1","","" }
{ "33161","33248","51055","2588","","17    CMa","","17","","","CMa","","504.106","5.800","-0.145","103.761410","-20.404876","A2V","A","1","","" }
{ "34249","34339","54475","2691","","","","","","","Pup","","776.563","5.800","-1.084","106.779499","-40.893268","B3V","B","1","","" }
{ "34881","34975","55775","2731","","","","","","","Mon","","1294.271","5.800","-2.193","108.545212","-3.901779","K5III","K","1","","" }
{ "35686","35785","57103","2784","","19    Lyn","","19","","","Lyn","","326156.378","5.800","-14.200","110.716899","55.281392","B8V","B","1","","" }
{ "35884","35984","57646","2804","","","","","","","Lyn","","1035.417","5.800","-1.708","111.237851","51.887258","K5III","K","1","","" }
{ "37603","37710","62781","3007","","","","","","","Pup","","140.101","5.800","2.635","116.040404","-36.062505","F0IV","F","1","","" }
{ "38734","38848","64960","3095","","1    Cnc","","1","","","Cnc","","465.938","5.800","0.025","119.247718","15.790281","K3III","K","1","","" }
{ "40751","40866","69994","3264","","","","","","","Cnc","","563.310","5.800","-0.387","125.087376","20.747721","K1III","K","1","","" }
{ "41909","42028","72660","3383","","","","","","","Hya","","294.631","5.800","1.021","128.506740","-2.151555","A1V","A","1","","" }
{ "43948","44075","76932","3578","GJ 3523","","","","","","Hya","","68.607","5.800","4.185","134.683030","-16.132727","F7/F8IV/V","F","1","","" }
{ "44128","44256","77615","3604","","","","","","","Car","","1309.865","5.800","-2.219","135.190602","-60.963828","G8II","G","1","","" }
{ "47363","47498","84152","3864","","","","","","","Car","","368.122","5.800","0.537","145.258947","-57.259542","K0/K1III","K","1","","" }
{ "47807","47943","84542","3876","","","","","","","Leo","","1964.797","5.800","-3.099","146.541850","6.708556","M1III","M","1","","" }
{ "49622","49764","88473","4002","","","","","","","Car","","682.335","5.800","-0.803","152.375783","-68.682779","A0IV","A","1","","" }
{ "50351","50493","89569","4061","","","","","","","Vel","","117.619","5.800","3.015","154.658412","-56.110393","F6V","F","1","","" }
{ "52826","52980","93903","4237","","41    Sex","","41","","","Sex","","310.625","5.800","0.906","162.575234","-8.897763","A3m","A","1","","" }
{ "55550","55716","99196","4404","","","","","","","Leo","","490.461","5.800","-0.086","171.245530","11.430292","K4III","K","1","","" }
{ "55682","55849","99574","4417","","","","","","","Cen","","611.926","5.800","-0.566","171.697004","-53.159915","K0III+...","K","1","","" }
{ "56432","56601","100808","4465","","","","","","","Leo","","233.469","5.800","1.526","174.074801","27.781351","F0V","F","1","","" }
{ "59737","59920","106884","4672","","","","","","","UMa","","344.774","5.800","0.679","184.373269","53.191331","K6III","K","1","","" }
{ "71984","72210","129944","5499","","","","","","","Lib","","338.336","5.800","0.720","221.528198","-23.153018","K0III","K","1","","" }
{ "72326","72552","130917","5532","","","","","","","Boo","","321.020","5.800","0.834","222.493322","28.615832","A4V","A","1","","" }
{ "76642","76878","140232","5845","","22Tau7Ser","Tau-7","22","Tau","7","Ser","","173.119","5.800","2.175","235.477981","18.464037","A2m","A","1","","" }
{ "79516","79757","146738","6074","","18Ups CrB","Ups","18","Ups","","CrB","","666.987","5.800","-0.753","244.186605","29.150261","A3V","A","1","","" }
{ "109663","110009","211392","8500","","","","","","","Aqr","","369.373","5.800","0.530","334.219026","-9.040067","K3III:","K","1","","" }
{ "111310","111660","214710","8625","","","","","","","Cep","","698.408","5.800","-0.853","339.303704","75.371811","M1III","M","1","","" }
{ "112670","113031","216494","8704","","74    Aqr","","74","","","Aqr","","825.712","5.800","-1.217","343.369602","-11.616514","B8IV/V","B","1","","" }
{ "118084","","10361","487","Gl 66A","","","","","","Eri","p Eridani","26.571","5.800","6.245","24.945038","-56.194620","K2 V","K","1","","Gl 66" }
{ "113806","114167","218269","8793","","","","","","","Gru","","149.066","5.810","2.510","346.811603","-50.686681","F6.5IV-V+..","F","1","","" }
{ "114828","115191","219981","8876","","10    And","","10","","","And","","481.057","5.810","-0.034","349.968371","42.078044","M0III","M","1","","" }
{ "116216","116582","222109","8962","","","","","","","And","","807.318","5.810","-1.158","354.383500","44.428994","B8V","B","1","","" }
{ "117913","118281","224635","9074","GJ 4384A","","","","","","And","","94.347","5.810","3.503","359.872080","33.723878","F8","F","1","","GJ 4384" }
{ "28215","28287","40733","2117","","","","","","","Pic","","1181.726","5.810","-1.985","89.656457","-44.034562","G8II","G","1","","" }
{ "32316","32402","49517","2515","","","","","","","Car","","1289.156","5.810","-2.174","101.473830","-52.409691","K3III","K","1","","" }
{ "35107","35202","56733","2769","","","","","","","Pup","","610.780","5.810","-0.552","109.132718","-38.318928","B4V","B","1","","" }
{ "50242","50384","89125","4039","Gl 387A","39    Leo","","39","","","Leo","","74.380","5.810","4.020","154.310664","23.106220","F8Vw","F","1","","Gl 387" }
{ "53606","53762","95347","4292","","","","","","","Vel","","305.104","5.810","0.955","164.997468","-43.807110","B8/B9V","B","1","","" }
{ "5483","5494","6953","341","","","","","","","Psc","","393.909","5.810","0.400","17.581046","25.457763","K5III","K","1","","" }
{ "10845","10871","14641","688","","","","","","","Hor","","616.553","5.810","-0.573","34.976084","-55.944796","K5III","K","1","","" }
{ "11064","11090","14622","687","","","","","","","And","","153.341","5.810","2.449","35.709661","41.396297","F0III-IV","F","1","","" }
{ "12115","12148","16247","766","","","","","","","Cet","","295.968","5.810","1.021","39.146129","7.730026","K0III:","K","1","","" }
{ "14153","14187","19141","929","","","","","","","Eri","","847.160","5.810","-1.263","45.732734","-46.975036","K2/K3III","K","1","","" }
{ "16327","16368","22252","1092","","","","","","","Ret","","867.437","5.810","-1.314","52.715385","-66.489714","B8V","B","1","","" }
{ "17755","17798","23978","1187","","","","","","","Eri","","593.012","5.810","-0.488","57.148773","-20.902977","K5III","K","1","","" }
{ "20414","20465","27881","1384","","","","","","","Eri","","501.008","5.810","-0.122","65.773635","-24.892157","K5III","K","1","","" }
{ "24672","24732","33541","1683","","","","","","","Cam","","362.799","5.810","0.579","79.555200","73.268071","A0V","A","1","","" }
{ "26480","26545","37717","1947","","","","","","","Col","","439.564","5.810","0.162","84.681355","-40.707306","B8V","B","1","","" }
{ "86353","86620","162004","6637","Gl 694.1B","31Psi1Dra","Psi-1","31","Psi","1","Dra","Dziban B","75.220","5.810","3.995","265.491911","72.156911","G0V","G","2","86347","Gl 694.1" }
{ "89331","89609","167720","6838","","","","","","","Sgr","","976.516","5.810","-1.571","274.298450","-17.373886","K2III","K","1","","" }
{ "90063","90342","169981","6917","","","","","","","Her","","405.163","5.810","0.339","276.494938","29.828930","A2IV","A","1","","" }
{ "94927","95222","181907","7349","","","","","","","Aql","","338.336","5.810","0.730","290.589771","-0.252345","G8III:","G","1","","" }
{ "98710","99026","191195","7697","","","","","","","Cyg","","119.253","5.810","2.995","301.557345","53.165688","F5V","F","1","","" }
{ "99344","99663","192781","7742","","","","","","","Cep","","580.349","5.810","-0.441","303.364966","60.640569","K5III","K","1","","" }
{ "105073","105413","203291","8163","","9    Equ","","9","","","Equ","","654.932","5.810","-0.704","320.270102","7.354503","M2III","M","1","","" }
{ "64722","64927","115723","5022","","","","","","","CVn","","501.008","5.810","-0.122","199.615518","34.098304","K4.5III","K","1","","" }
{ "65042","65247","116084","5036","","","","","","","Cen","","326156.378","5.810","-14.190","200.567863","-52.182956","B2.5Ib","B","1","","" }
{ "66353","66563","118646","5128","","","","","","","Hya","","150.929","5.810","2.483","204.675314","-29.560867","F3V","F","1","","" }
{ "66931","67143","119752","5167","","","","","","","Hya","","283.861","5.810","1.112","206.403733","-26.116009","A0V","A","1","","" }
{ "77502","77738","142531","5922","","","","","","","Dra","","335.552","5.810","0.748","238.069032","55.826713","G8III:","G","1","","" }
{ "55416","55581","99022","4398","","","","","","","Cen","","760.271","5.820","-1.018","170.783945","-56.779355","A4:p","A","1","","" }
{ "59546","59728","106485","4655","","","","","","","Crv","","270.221","5.820","1.229","183.748263","-20.844220","K0IIICN...","K","1","","" }
{ "60398","60584","108135","4726","","71    UMa","","71","","","UMa","","858.306","5.820","-1.281","186.263397","56.777828","M3III","M","1","","" }
{ "64617","64822","115331","5008","","","","","","","Cen","","211.652","5.820","1.759","199.308002","-43.979479","Am","A","1","","" }
{ "65332","65536","117187","5073","","","","","","","UMi","","1173.224","5.820","-1.960","201.533485","72.391476","M1III","M","1","","" }
{ "67862","68079","121416","5239","","","","","","","Cen","","318.201","5.820","0.874","209.082552","-46.592948","K0IV","K","1","","" }
{ "73868","74096","134335","5640","","","","","","","Boo","","466.604","5.820","0.042","227.148182","25.108635","K1III","K","1","","" }
{ "75713","75944","138137","5750","","34Zet3Lib","Zet-3","34","Zet","3","Lib","","508.032","5.820","-0.142","232.668339","-16.609464","K0III","K","1","","" }
{ "75975","76207","138505","5767","","","","","","","Lup","","1148.438","5.820","-1.913","233.507144","-40.066432","M2III","M","1","","" }
{ "76334","76569","139329","5810","","","","","","","Lib","","284.853","5.820","1.114","234.567830","-21.016327","K0III","K","1","","" }
{ "78205","78442","143553","5963","","","","","","","Ser","","244.862","5.820","1.443","240.213057","4.427363","K0III:","K","1","","" }
{ "7064","7078","9021","427","","38    Cas","","38","","","Cas","","94.511","5.820","3.510","22.806661","70.264604","F6V","F","1","","" }
{ "13801","13835","18535","889","","6    Eri","","6","","","Eri","","662.919","5.820","-0.720","44.523875","-23.606012","K2III","K","1","","" }
{ "16299","16340","21551","1051","","","","","","","Per","","893.579","5.820","-1.369","52.653935","48.103596","B8V","B","1","","" }
{ "16805","16846","22468","1099","","","","","","","Tau","","100.079","5.820","3.385","54.197040","0.587758","G5IV/V +K1IV","G","1","","" }
{ "17849","17891","23523","1158","","","","","","","Cam","","233.636","5.820","1.544","57.402545","63.296967","A5Vn","A","1","","" }
{ "22520","22573","31093","1559","","","","","","","Cae","","268.000","5.820","1.246","72.867554","-34.906286","A2/A3V","A","1","","" }
{ "111250","111600","214122","8601","","","","","","","PsA","","357.628","5.820","0.620","339.147689","-31.663789","K2III","K","1","","" }
{ "112231","112590","215943","8678","","","","","","","Lac","","336.938","5.820","0.749","342.046008","37.416688","G8III:","G","1","","" }
{ "112724","113084","216646","8712","","","","","","","Lac","","303.967","5.820","0.973","343.529030","40.376907","K0III","K","1","","" }
{ "115884","116250","221420","8935","GJ 4340","","","","","","Oct","","102.533","5.820","3.333","353.331477","-77.385327","G2V","G","1","","" }
{ "28920","28992","42054","2170","","","","","","","Col","","1019.239","5.820","-1.654","91.765292","-34.312021","B4Vnn","B","1","","" }
{ "30630","30703","45984","2369","","","","","","","Pic","","563.310","5.820","-0.367","96.767211","-58.002116","K3III","K","1","","" }
{ "30999","31072","46349","2388","","","","","","","Col","","615.389","5.820","-0.559","97.804566","-35.258840","G8III+...","G","1","","" }
{ "31096","31173","46052","2372","","","","","","","Aur","","262.817","5.820","1.289","98.113280","32.454898","A3m + A3m","A","1","","" }
{ "38051","38159","63949","3058","","","","","","","Pup","","1929.919","5.820","-3.041","117.303602","-46.857717","B1.5IV","B","1","","" }
{ "41503","41621","72067","3356","","","","","","","Vel","","1430.510","5.820","-2.390","127.281535","-44.160413","B2V","B","1","","" }
{ "84948","85207","157527","6472","","","","","","","Oph","","301.717","5.820","0.989","261.175131","-21.441479","K0III","K","1","","" }
{ "87541","87812","163472","6684","","","","","","","Oph","","1358.985","5.820","-2.279","269.076670","0.670355","B2IV-V","B","1","","" }
{ "91249","91532","172348","7007","","","","","","","Sct","","582.422","5.820","-0.439","280.001616","-7.790799","K4III","K","1","","" }
{ "91687","91974","173117","7035","","","","","","","Sgr","","578.292","5.820","-0.424","281.206676","-25.010914","B8III","B","1","","" }
{ "91740","92027","173495","7048","","","","","","","Ser","","615.389","5.820","-0.559","281.368187","5.500128","A1V","A","1","","" }
{ "92199","92488","174464","7094","","","","","","","Sct","","2787.661","5.820","-3.839","282.743786","-9.774096","F2Ib","F","1","","" }
{ "93285","93580","177178","7214","","","","","","","Aql","","179.010","5.820","2.123","285.884386","1.818768","A4V","A","1","","" }
{ "95487","95785","183491","7406","","8    Vul","","8","","","Vul","","514.442","5.820","-0.170","292.237844","24.768723","K0III","K","1","","" }
{ "99952","100276","193579","7780","","","","","","","Sge","","545.412","5.820","-0.296","305.089192","17.792928","K5III","K","1","","" }
{ "85120","85379","158414","6509","","77    Her","","77","","","Her","","375.756","5.830","0.523","261.684343","48.260065","A4V","A","1","","" }
{ "85499","85760","156513","6429","","","","","","","Aps","","883.893","5.830","-1.335","262.864466","-80.859134","M3III","M","1","","" }
{ "88541","88818","166045","6781","","100    Her","","100","","","Her","","161.784","5.830","2.352","271.956505","26.101280","A3V","A","1","","" }
{ "97067","97376","187235","7543","","","","","","","Cyg","","472.690","5.830","0.024","296.865745","38.407614","B8Vn","B","1","","" }
{ "99748","100069","193322","7767","","","","","","","Cyg","","1941.407","5.830","-3.043","304.529119","40.732082","O9V","O","1","","" }
{ "103027","103359","199611","8025","","","","","","","Cyg","","167.260","5.830","2.280","314.106098","50.728598","F0III","F","1","","" }
{ "103478","103810","200614","8065","","","","","","","Cep","","921.346","5.830","-1.425","315.537508","56.669614","B8III","B","1","","" }
{ "104342","104680","201647","8100","GJ 9726","","","","","","Mic","","103.279","5.830","3.327","318.057090","-40.269362","F5IV","F","1","","" }
{ "104826","105164","202753","8141","","15    Aqr","","15","","","Aqr","","1016.064","5.830","-1.637","319.546137","-4.519478","B5V","B","1","","" }
{ "108529","108875","209459","8404","","21    Peg","","21","","","Peg","","629.646","5.830","-0.598","330.829299","11.386552","B9.5V","B","1","","" }
{ "110441","110787","213403","8578","","28Rho1Cep","Rho-1","28","Rho","1","Cep","","206.037","5.830","1.827","336.676825","78.785853","A2m","A","1","","" }
{ "114019","114382","218630","8814","","","","","","","Gru","","108.973","5.830","3.211","347.489322","-42.861292","F4IV","F","1","","" }
{ "55868","56035","99747","4421","","","","","","","UMa","","108.610","5.830","3.218","172.269321","61.778368","F5Vawvar","F","1","","" }
{ "58007","58181","103605","4566","","66    UMa","","66","","","UMa","","309.446","5.830","0.944","178.993384","56.598560","K1III","K","1","","" }
{ "62317","62512","111456","4867","GJ 9417","","","","","","UMa","","78.422","5.830","3.925","192.164164","60.319822","F5V","F","1","","" }
{ "67647","67861","120991","5223","","","","","","","Cen","","326156.378","5.830","-14.170","208.488509","-47.128164","B2IIIe","B","1","","" }
{ "70440","70663","126504","5401","","","","","","","Lup","","221.273","5.830","1.672","216.800877","-46.134254","Am","A","1","","" }
{ "71347","71573","128998","5467","","","","","","","Boo","","359.599","5.830","0.618","219.563397","54.023339","A1V","A","1","","" }
{ "73338","73566","132851","5591","","60    Hya","","60","","","Hya","","331.797","5.830","0.793","225.526784","-28.060611","A4IV","A","1","","" }
{ "80109","80351","147869","6111","","21    Her","","21","","","Her","","366.468","5.830","0.577","246.045124","6.948207","A2sp...","A","1","","" }
{ "81043","81289","150030","6183","","","","","","","Her","","1000.480","5.830","-1.604","249.046689","46.613333","G8II","G","1","","" }
{ "81224","81472","149711","6174","","","","","","","Sco","","627.224","5.830","-0.590","249.609560","-43.398426","B2.5IV","B","1","","" }
{ "3292","3299","3856","177","","","","","","","Cas","","516.888","5.830","-0.170","10.514292","66.147592","G9III-IV","G","1","","" }
{ "5011","5021","6210","297","","","","","","","Cas","","263.454","5.830","1.294","16.081259","61.580184","F6V","F","1","","" }
{ "8527","8544","11154","530","","1    Ari","","1","","","Ari","","585.559","5.830","-0.441","27.535716","22.275338","K1III+...","K","1","","" }
{ "13075","13108","17459","828","","40    Ari","","40","","","Ari","","461.978","5.830","0.074","42.133700","18.283790","K1III","K","1","","" }
{ "26331","26396","37098","1902","","","","","","","Tau","","504.886","5.830","-0.119","84.286852","26.924473","B9IV-V","B","1","","" }
{ "29306","29379","42398","2185","","5    Gem","","5","","","Gem","","568.217","5.830","-0.375","92.884607","24.420253","K0III","K","1","","" }
{ "29501","29575","43023","2218","","","","","","","Ori","","307.405","5.830","0.959","93.475974","-3.741374","G8III","G","1","","" }
{ "29556","29629","43157","2224","","","","","","","Mon","","639.522","5.830","-0.632","93.652928","-4.568457","B5V","B","1","","" }
{ "35651","35749","57749","2811","","","","","","","Mon","","748.065","5.830","-0.973","110.605790","-5.982829","F3IV","F","1","","" }
{ "36706","36812","60357","2901","","9Del3CMi","Del-3","9","Del","3","CMi","","575.232","5.830","-0.402","113.566217","3.371725","A0Vnn","A","1","","" }
{ "39269","39380","66598","3160","","","","","","","Pup","","472.006","5.830","0.027","120.767342","-32.463548","K2/K3III","K","1","","" }
{ "39964","40077","68657","3227","","","","","","","Vel","","842.781","5.830","-1.231","122.794977","-48.461994","B3V","B","1","","" }
{ "45428","45559","80050","3687","","","","","","","Hya","","360.793","5.830","0.611","139.282175","-14.574069","K0III","K","1","","" }
{ "45544","45675","80558","3708","","","","","","","Vel","","326156.378","5.830","-14.170","139.676493","-51.560651","B7Iab","B","1","","" }
{ "48609","48748","86267","3932","","","","","","","Ant","","513.632","5.830","-0.156","149.147875","-33.418496","K1III","K","1","","" }
{ "34665","34758","55344","2716","","","","","","","CMa","","467.273","5.840","0.059","107.923356","-20.883063","A0IV/V","A","1","","" }
{ "34931","35025","55621","2725","","52    Gem","","52","","","Gem","","300.328","5.840","1.019","108.674902","24.884984","M1IIIvar","M","1","","" }
{ "36615","36721","60345","2900","","","","","","","Pup","","275.703","5.840","1.205","113.290735","-24.710731","A3III","A","1","","" }
{ "50194","50336","89024","4032","","","","","","","Leo","","355.290","5.840","0.654","154.174019","25.370705","K2III:","K","1","","" }
{ "51988","52139","92168","4168","","38    LMi","","38","","","LMi","","170.673","5.840","2.246","159.781945","37.910000","F9V","F","1","","" }
{ "56437","56606","100929","4472","","","","","","","Cen","","1622.668","5.840","-2.644","174.093222","-61.052433","B2.5IV","B","1","","" }
{ "61723","61916","110287","4818","","","","","","","Cen","","905.990","5.840","-1.378","190.345848","-46.145581","K3II","K","1","","" }
{ "62943","63143","112486","4917","","","","","","","UMa","","282.631","5.840","1.151","194.073319","54.099489","A5m","A","1","","" }
{ "64383","64587","114533","4976","","","","","","","Cha","","1221.559","5.840","-2.027","198.572298","-78.447454","F8Ib","F","1","","" }
{ "64418","64623","114971","4996","","","","","","","Cen","","235.322","5.840","1.549","198.680415","-48.957022","K0IV","K","1","","" }
{ "69606","69829","125180","5352","","","","","","","Boo","","762.048","5.840","-1.003","214.368548","15.263380","M3III","M","1","","" }
{ "70777","71002","126862","5408","","","","","","","Cir","","248.028","5.840","1.435","217.818363","-67.717197","K1III","K","1","","" }
{ "74311","74539","135051","5658","","","","","","","Lib","","997.420","5.840","-1.587","228.472140","-26.193569","G8/K0II","G","1","","" }
{ "76359","76594","139906","5835","","","","","","","Boo","","376.624","5.840","0.528","234.642490","50.423283","G8III","G","1","","" }
{ "77932","78168","142883","5934","","","","","","","Sco","","460.673","5.840","0.090","239.418598","-20.983080","B3V","B","1","","" }
{ "81491","81741","150331","6192","","","","","","","Sco","","283.368","5.840","1.145","250.439420","-33.145759","G1II","G","1","","" }
{ "82464","82716","152293","6266","","","","","","","Sco","","1436.812","5.840","-2.380","253.612257","-42.478891","F5Ib-II","F","1","","" }
{ "85627","85889","158799","6523","","","","","","","Sco","","1517.006","5.840","-2.498","263.280785","-41.173066","B9Ib/II","B","1","","" }
{ "87201","87472","162391","6648","","","","","","","Sco","","791.642","5.840","-1.086","268.082340","-34.416842","G8/K0III","G","1","","" }
{ "88395","88670","165402","6755","","","","","","","Ser","","517.709","5.840","-0.163","271.530831","-8.323956","B8III-IV","B","1","","" }
{ "91178","91461","171819","6986","","","","","","","Tel","","356.845","5.840","0.645","279.809526","-47.909767","A3V","A","1","","" }
{ "92532","92822","175824","7154","","","","","","","Dra","","180.297","5.840","2.127","283.696418","48.859401","F3III","F","1","","" }
{ "94892","95188","181645","7344","","45Rho2Sgr","Rho-2","45","Rho","2","Sgr","","332.135","5.840","0.801","290.462051","-18.308388","K0III","K","1","","" }
{ "95286","95582","182955","7391","","","","","","","Vul","","613.076","5.840","-0.530","291.619529","19.891493","M0III","M","1","","" }
{ "95434","95732","183227","7397","","","","","","","Aql","","962.113","5.840","-1.509","292.086659","2.930030","B6III","B","1","","" }
{ "99254","99572","191862","7715","GJ 4139","2Xi 2Cap","Xi-2","2","Xi","2","Cap","","90.348","5.840","3.628","303.107783","-12.617497","F5V","F","1","","" }
{ "105721","106062","204585","8223","","","","","","","Peg","","665.625","5.840","-0.709","322.249068","22.179436","M4III","M","1","","" }
{ "107883","108226","208682","8375","","","","","","","Cep","","1025.649","5.840","-1.648","328.879143","65.320809","B2.5Ve","B","1","","" }
{ "111458","111810","214567","8618","","40    Peg","","40","","","Peg","","373.177","5.840","0.548","339.719132","19.522263","G8II","G","1","","" }
{ "112061","112417","215664","8666","","","","","","","Lac","","185.633","5.840","2.064","341.542452","44.546054","F0III-IV","F","1","","" }
{ "838","840","587","29","","","","","","","Psc","","190.179","5.840","2.011","2.578624","-5.248588","K1III","K","1","","" }
{ "871","873","645","31","","","","","","","Cet","","244.679","5.840","1.464","2.678469","-12.579897","K0III","K","1","","" }
{ "6488","6502","8498","400","","","","","","","Scl","","976.516","5.840","-1.541","20.878996","-30.945617","M0III","M","1","","" }
{ "9113","9132","11928","564","","","","","","","Tri","","457.442","5.840","0.105","29.432263","27.804381","M2III","M","1","","" }
{ "10011","10035","13336","632","","","","","","","Phe","","521.017","5.840","-0.177","32.288763","-43.516596","K1III","K","1","","" }
{ "11811","11840","15755","738","","","","","","","Tri","","271.571","5.840","1.238","38.219275","34.542410","K0III","K","1","","" }
{ "12256","12288","16538","777","","Iot2For","Iot-2","","Iot","2","For","","110.711","5.840","3.186","39.577722","-30.194062","F5V","F","1","","" }
{ "14076","14110","18885","912","","","","","","","Eri","","329.784","5.840","0.816","45.483827","-9.961407","G6III:","G","1","","" }
{ "15267","15305","20640","998","","","","","","","Hor","","512.020","5.840","-0.139","49.360825","-47.751664","K2III","K","1","","" }
{ "19405","19454","22701","1107","","","","","","","Cep","","137.735","5.840","2.712","62.501279","86.626139","F5IV","F","1","","" }
{ "22354","22407","30453","1528","","","","","","","Aur","","273.163","5.840","1.225","72.329477","32.588191","A8m","A","1","","" }
{ "23094","23148","34172","1716","","Xi  Men","Xi","","Xi","","Men","","368.955","5.840","0.572","74.712434","-82.470512","G8III","G","1","","" }
{ "23828","23883","32991","1660","","105    Tau","","105","","","Tau","","1079.988","5.840","-1.760","76.980983","21.704821","B2Ve","B","1","","" }
{ "12653","12686","16735","787","","","","","","","Per","","460.673","5.850","0.100","40.747920","53.526105","K0II-III","K","1","","" }
{ "18559","18606","25069","1232","","","","","","","Eri","","151.489","5.850","2.515","59.718308","-5.469947","G9V","G","1","","" }
{ "20221","20271","27563","1363","","","","","","","Eri","","789.725","5.850","-1.070","65.178477","-7.592493","B5III","B","1","","" }
{ "21551","21604","29365","1471","","","","","","","Tau","","329.784","5.850","0.826","69.565960","20.684722","B8V","B","1","","" }
{ "91156","91438","172051","6998","Gl 722","","","","","","Sgr","","42.674","5.850","5.266","279.722515","-21.051871","G5V","G","1","","" }
{ "94042","94336","179957","7293","GJ 9648B","","","","","","Cyg","","79.745","5.850","3.909","288.021233","49.855755","G4V+...","G","2","119271","GJ 9648" }
{ "95057","95352","182694","7382","","","","","","","Lyr","","440.752","5.850","0.196","290.985409","43.388171","G6.5IIIa","G","1","","" }
{ "33290","33377","50658","2568","","Psi9Aur","Psi-9","","Psi","9","Aur","","1259.291","5.850","-2.084","104.133576","46.273998","B8III","B","1","","" }
{ "34726","34819","55052","2706","","48    Gem","","48","","","Gem","","358.020","5.850","0.648","108.109911","24.128594","F5IV","F","1","","" }
{ "44278","44406","77445","3599","","","","","","","Cnc","","633.313","5.850","-0.591","135.686739","7.298267","K3III:","K","1","","" }
{ "45182","45314","79694","3672","","","","","","","Vel","","526.059","5.850","-0.188","138.534232","-44.145822","B6IV","B","1","","" }
{ "45255","45386","79807","3677","","","","","","","Vel","","642.040","5.850","-0.621","138.738201","-37.602396","K0/K1III+..","K","1","","" }
{ "48595","48734","86080","3926","","","","","","","Leo","","579.319","5.850","-0.397","149.108237","8.933157","K2III:","K","1","","" }
{ "52768","52922","93943","4239","","","","","","","Car","","736.245","5.850","-0.918","162.351861","-59.323793","B9.5IV/V","B","1","","" }
{ "52794","52948","93833","4233","","","","","","","Sex","","340.811","5.850","0.755","162.431202","-9.852695","G8III:","G","1","","" }
{ "57668","57841","103026","4548","","","","","","","Hya","","101.670","5.850","3.381","177.923378","-30.834809","F8V","F","1","","" }
{ "59426","59608","106251","4650","GJ 3716","12    Vir","","12","","","Vir","","163.651","5.850","2.348","183.358080","10.262341","A2m","A","1","","" }
{ "66586","66798","119476","5162","","","","","","","Dra","","222.480","5.850","1.681","205.374371","64.822411","A2V","A","1","","" }
{ "72732","72959","131432","5549","","","","","","","Cen","","1045.373","5.850","-1.679","223.657982","-33.300575","K2III","K","1","","" }
{ "73872","74100","133937","5625","","","","","","","Lup","","387.359","5.850","0.477","227.163340","-42.867921","B7V","B","1","","" }
{ "76274","76509","139778","5828","","","","","","","Dra","","356.066","5.850","0.659","234.383425","54.508733","K1III:","K","1","","" }
{ "77135","77370","141675","5887","","","","","","","Dra","","240.706","5.850","1.510","236.908004","55.376627","A3m","A","1","","" }
{ "111292","111643","214150","8602","","Sig2Gru","Sig-2","","Sig","2","Gru","","214.718","5.850","1.758","339.245192","-40.591034","A1V","A","1","","" }
{ "113262","113622","217459","8751","","","","","","","Psc","","445.569","5.850","0.173","345.178751","3.011805","K4III","K","1","","" }
{ "114279","114641","219139","8833","","","","","","","Peg","","345.505","5.850","0.725","348.360429","11.065001","G5III:","G","1","","" }
{ "117354","117722","223774","9037","","","","","","","Aqr","","281.655","5.850","1.169","358.124967","-14.251217","K2III","K","1","","" }
{ "112637","112997","216489","8703","","","","","","","Peg","","291.993","5.860","1.100","343.259443","16.841194","K1III SB","K","1","","" }
{ "116014","116380","221861","8952","","","","","","","Cep","","2104.235","5.860","-3.188","353.745973","71.642043","K0Ib","K","1","","" }
{ "117135","117503","223460","9024","","","","","","","And","","423.030","5.860","0.295","357.420667","36.425281","G1IIIe","G","1","","" }
{ "29543","29616","42954","2214","","","","","","","Ori","","528.617","5.860","-0.189","93.619097","17.906353","A6m","A","1","","" }
{ "30966","31039","45410","2331","","6    Lyn","","6","","","Lyn","","182.007","5.860","2.127","97.696349","58.162633","K0IV","K","1","","" }
{ "33849","33937","52609","2635","","","","","","","Gem","","2508.895","5.860","-3.570","105.638698","16.674447","M2III","M","1","","" }
{ "35250","35347","57197","2789","","","","","","","Pup","","591.935","5.860","-0.434","109.517714","-43.986786","B8II/III","B","1","","" }
{ "36296","36399","59380","2866","GJ 3443","","","","","","Mon","","88.847","5.860","3.684","112.356832","-7.551168","F8V","F","1","","" }
{ "38599","38712","64685","3087","","","","","","","CMi","","127.256","5.860","2.904","118.880973","8.862840","F2IV","F","1","","" }
{ "40242","40357","69302","3250","","","","","","","Vel","","1181.726","5.860","-1.935","123.599471","-45.834522","B2IV-V","B","1","","" }
{ "43247","43370","75629","3513","","","","","","","Pyx","","751.512","5.860","-0.953","132.509302","-29.462997","G8III","G","1","","" }
{ "45454","45585","80950","3721","","","","","","","Car","","267.341","5.860","1.292","139.365071","-74.734591","A0V","A","1","","" }
{ "46485","46618","82232","3772","","","","","","","Hya","","238.418","5.860","1.540","142.593689","-15.577352","K2III","K","1","","" }
{ "46603","46736","82514","3790","","","","","","","Ant","","279.005","5.860","1.199","142.887604","-35.714750","K3III","K","1","","" }
{ "48753","48893","85841","3918","","","","","","","UMa","","360.394","5.860","0.643","149.595288","72.879509","K3III:","K","1","","" }
{ "49752","49893","88231","3993","","","","","","","LMi","","638.271","5.860","-0.598","152.803255","37.401900","K3III","K","1","","" }
{ "53622","53778","95314","4289","","","","","","","Crt","","465.273","5.860","0.089","165.048724","-14.083368","K5III","K","1","","" }
{ "1369","1372","1279","62","","","","","","","Cas","","1120.812","5.860","-1.821","4.287677","47.947405","B7III","B","1","","" }
{ "3742","3750","4440","212","","","","","","","Cas","","199.728","5.860","1.925","12.037306","72.674482","K0IV","K","1","","" }
{ "8372","8387","10982","522","","4    Ari","","4","","","Ari","","275.237","5.860","1.229","27.045564","16.955551","B9.5V","B","1","","" }
{ "10302","10326","13692","651","","","","","","","Cet","","346.975","5.860","0.726","33.254104","-21.000137","K0III","K","1","","" }
{ "13305","13339","17656","842","","","","","","","Per","","391.075","5.860","0.466","42.923904","46.841939","G8III","G","1","","" }
{ "16948","16989","22675","1108","","","","","","","Eri","","366.468","5.860","0.607","54.621890","-7.391863","G5III:","G","1","","" }
{ "20291","20341","27611","1366","","","","","","","Eri","","466.604","5.860","0.082","65.362661","-0.098170","K2","K","1","","" }
{ "21919","21972","29721","1493","","","","","","","Per","","683.766","5.860","-0.747","70.839981","49.973789","B9III","B","1","","" }
{ "23420","23475","32393","1625","","","","","","","Eri","","299.776","5.860","1.043","75.689144","-4.210121","K3","K","1","","" }
{ "25424","25488","36060","1827","","","","","","","Col","","299.776","5.860","1.043","81.772166","-40.943510","A7m","A","1","","" }
{ "25822","25887","36734","1870","","","","","","","Pic","","548.162","5.860","-0.267","82.899997","-45.925317","K3III","K","1","","" }
{ "82369","82621","152311","6269","","","","","","","Oph","","87.866","5.860","3.708","253.355096","-20.415555","G5IV","G","1","","" }
{ "84790","85049","156768","6438","","","","","","","Ara","","1094.485","5.860","-1.769","260.730103","-58.010327","G8Ib/II","G","1","","" }
{ "87829","88101","164064","6706","","","","","","","Oph","","560.406","5.860","-0.315","269.903180","-4.821126","K5III","K","1","","" }
{ "88822","89099","166114","6786","","","","","","","CrA","","269.774","5.860","1.272","272.773146","-41.359113","F0Vn","F","1","","" }
{ "88838","89115","164712","6731","","","","","","","Aps","","245.600","5.860","1.476","272.815715","-75.891510","K3III","K","1","","" }
{ "88957","89234","165259","6751","","","","","","","Aps","","137.445","5.860","2.736","273.142224","-73.672417","F5V","F","1","","" }
{ "93862","94157","178322","7257","","","","","","","CrA","","1449.584","5.860","-2.379","287.490224","-41.892256","B5V","B","1","","" }
{ "96774","97081","186619","7514","","","","","","","Cyg","","570.204","5.860","-0.353","295.937887","41.773108","M0III","M","1","","" }
{ "99741","100062","192879","7748","","4    Cap","","4","","","Cap","","316.350","5.860","0.926","304.505816","-21.809960","G8III","G","1","","" }
{ "100412","100738","194215","7801","","","","","","","Sgr","","501.779","5.860","-0.075","306.361780","-28.663269","G8II/III","G","1","","" }
{ "102441","102772","198174","7961","","","","","","","Cap","","964.960","5.860","-1.495","312.323387","-25.781240","B8II","B","1","","" }
{ "61227","61420","109519","4793","","","","","","","Com","","638.271","5.860","-0.598","188.784027","21.881384","K1III","K","1","","" }
{ "61527","61720","109960","4810","","","","","","","Hya","","624.821","5.860","-0.552","189.764425","-30.422387","K2/K3III","K","1","","" }
{ "69706","69929","125248","5355","","","","","","","Vir","","332.813","5.860","0.816","214.659408","-18.715968","Ap Si(Cr)","A","1","","" }
{ "70958","71182","127501","5427","","","","","","","Lup","","327.138","5.860","0.853","218.374869","-52.679522","K0III","K","1","","" }
{ "70959","71184","127486","5426","","","","","","","Lup","","249.355","5.860","1.443","218.385067","-54.998628","F6IV-V","F","1","","" }
{ "72341","72567","130948","5534","Gl 564","","","","","","Boo","","59.269","5.860","4.563","222.565847","23.911844","G2V","G","1","","" }
{ "76816","77052","140538","5853","Gl 596.1A","23Psi Ser","Psi","23","Psi","","Ser","","47.810","5.860","5.030","236.007582","2.515173","G5V","G","1","","Gl 596.1" }
{ "77305","77541","141194","5871","","","","","","","Nor","","194.372","5.860","1.984","237.489603","-48.912408","A2IV","A","1","","" }
{ "78858","79098","144844","6003","","","","","","","Sco","","443.750","5.860","0.191","242.182171","-23.685416","B9V","B","1","","" }
{ "79080","79320","145191","6015","","","","","","","Sco","","211.104","5.860","1.805","242.823838","-41.119803","F0IV","F","1","","" }
{ "81921","82172","151732","6242","","","","","","","Her","","754.992","5.860","-0.963","251.832275","42.238918","M4IIIa","M","1","","" }
{ "55597","55763","99333","4411","","","","","","","Cen","","446.178","5.870","0.190","171.387932","-37.747575","M3III","M","1","","" }
{ "62165","62360","111032","4850","","","","","","","Cen","","355.290","5.870","0.684","191.692614","-33.315483","K3III","K","1","","" }
{ "62445","62641","111604","4875","","","","","","","CVn","","358.020","5.870","0.668","192.544808","37.516937","A3V","A","1","","" }
{ "67622","67836","120908","5217","","","","","","","Cen","","900.984","5.870","-1.336","208.429588","-53.373323","B5III","B","1","","" }
{ "69742","69965","125276","5356","Gl 542.1A","","","","","","Hya","","58.820","5.870","4.590","214.753825","-25.815426","F7Vw","F","1","","Gl 542.1" }
{ "70434","70657","126241","5391","","","","","","","Cir","","903.480","5.870","-1.342","216.779593","-65.821646","K3III","K","1","","" }
{ "77673","77909","142301","5912","","3    Sco","","3","","","Sco","","515.255","5.870","-0.123","238.664712","-25.243741","B8III/IV","B","1","","" }
{ "208","207","225009","9094","","","","","","","Cas","","326156.378","5.870","-14.130","0.650350","66.098966","G8III","G","1","","" }
{ "5913","5926","7389","365","","","","","","","Cas","","2764.037","5.870","-3.771","19.049587","71.743842","K1V","K","1","","" }
{ "6212","6226","8036","385","","42    Cet","","42","","","Cet","","328.455","5.870","0.855","19.951230","-0.509029","A7V...","A","1","","" }
{ "9552","9572","12583","608","","","","","","","Cet","","358.414","5.870","0.665","30.744035","-15.305932","K0II/III","K","1","","" }
{ "20752","20804","28217","1402","","","","","","","Tau","","587.669","5.870","-0.409","66.869869","11.212300","B8IV","B","1","","" }
{ "26422","26487","37320","1920","","","","","","","Ori","","780.278","5.870","-1.024","84.504662","7.541420","B8III","B","1","","" }
{ "27464","27533","39190","2026","","","","","","","Lep","","555.633","5.870","-0.287","87.472919","-22.971872","A1V","A","1","","" }
{ "109384","109730","211006","8482","","","","","","","Peg","","244.129","5.870","1.499","333.411222","28.608017","K2III","K","1","","" }
{ "27941","28011","39910","2070","","","","","","","Ori","","316.350","5.870","0.936","88.875713","-4.616546","K2III:","K","1","","" }
{ "30593","30666","45320","2324","","","","","","","Mon","","236.345","5.870","1.569","96.664938","-1.507336","A3Vn","A","1","","" }
{ "31585","31665","46590","2402","","11    Lyn","","11","","","Lyn","","331.797","5.870","0.833","99.409973","56.857531","A2V","A","1","","" }
{ "32667","32753","49606","2519","","33    Gem","","33","","","Gem","","858.306","5.870","-1.231","102.457653","16.202888","B7III","B","1","","" }
{ "35244","35341","56221","2753","","64    Aur","","64","","","Aur","","278.053","5.870","1.216","109.509234","40.883392","A5Vn","A","1","","" }
{ "35528","35626","57615","2802","","","","","","","CMa","","639.522","5.870","-0.592","110.268056","-25.891643","M3III","M","1","","" }
{ "36341","36444","60060","2884","","","","","","","Car","","359.996","5.870","0.656","112.498882","-52.651157","K0III","K","1","","" }
{ "37807","37915","63215","3022","","","","","","","Pup","","590.863","5.870","-0.420","116.543947","-37.933670","B5V","B","1","","" }
{ "39073","39184","66441","3156","","","","","","","Car","","767.427","5.870","-0.988","120.208119","-54.151275","B5Vn","B","1","","" }
{ "39080","39191","65714","3124","","2Ome1Cnc","Ome-1","2","Ome","1","Cnc","","662.919","5.870","-0.670","120.232802","25.392836","G8III:","G","1","","" }
{ "46519","46652","82087","3764","","7    LMi","","7","","","LMi","","501.779","5.870","-0.065","142.680088","33.655711","G8III:","G","1","","" }
{ "52687","52841","93657","4225","","","","","","","Hya","","466.604","5.870","0.092","162.058811","-31.687850","A1V","A","1","","" }
{ "83991","84248","154903","6368","","","","","","","Ara","","326.156","5.870","0.870","258.325089","-67.196591","K0III-IV","K","1","","" }
{ "85956","86219","161178","6606","","","","","","","Dra","","362.799","5.870","0.639","264.286880","72.455794","G9III","G","1","","" }
{ "86580","86847","160928","6597","","","","","","","Sco","","235.153","5.870","1.580","266.175036","-42.729302","A2/A3IV/V","A","1","","" }
{ "90357","90637","170650","6943","","","","","","","Her","","1226.152","5.870","-2.006","277.398793","23.866202","B6IV","B","1","","" }
{ "98105","98416","189340","7637","Gl 773.3","","","","","","Aql","","72.415","5.870","4.138","299.947272","-9.958238","F8V","F","1","","" }
{ "99569","99889","192985","7756","","","","","","","Cyg","","111.736","5.870","3.196","304.002552","45.579525","F5V:","F","1","","" }
{ "100248","100574","194335","7807","","","","","","","Cyg","","1353.346","5.870","-2.220","305.934867","37.476449","B2Vne","B","1","","" }
{ "102560","102891","198431","7976","","","","","","","Aqr","","264.094","5.870","1.328","312.674065","-12.544906","K1III","K","1","","" }
{ "105072","105412","203222","8160","","16    Aqr","","16","","","Aqr","","296.506","5.870","1.077","320.267992","-4.560125","G7III:","G","1","","" }
{ "82921","83176","153336","6308","","","","","","","Oph","","540.890","5.880","-0.218","254.990439","-25.092198","M1/M2III","M","1","","" }
{ "87189","87460","162374","6647","","","","","","","Sco","","842.781","5.880","-1.181","268.056921","-34.799196","B6Ib","B","1","","" }
{ "90633","90915","171245","6966","","","","","","","Her","","753.248","5.880","-0.938","278.192311","23.616801","K5III","K","1","","" }
{ "90648","90930","169570","6899","","","","","","","Pav","","354.903","5.880","0.697","278.230556","-73.965596","K0III","K","1","","" }
{ "93718","94013","179094","7275","","","","","","","Cyg","","231.645","5.880","1.623","287.107608","52.425731","K1IV","K","1","","" }
{ "94335","94630","180450","7302","","","","","","","Lyr","","1269.091","5.880","-2.070","288.853568","30.526381","M0III","M","1","","" }
{ "97472","97783","187739","7561","","57    Sgr","","57","","","Sgr","","377.933","5.880","0.560","298.050015","-19.044991","K0III","K","1","","" }
{ "98297","98609","189944","7656","","","","","","","Vul","","1079.988","5.880","-1.720","300.436294","24.800423","B4V","B","1","","" }
{ "103836","104171","201636","8099","","","","","","","Cep","","158.945","5.880","2.441","316.597352","71.431797","F3IV","F","1","","" }
{ "106889","107232","206561","8295","","44    Cap","","44","","","Cap","","435.456","5.880","0.252","325.768325","-14.399709","A9/F0V","A","1","","" }
{ "109626","109972","211554","8506","","","","","","","Cep","","616.553","5.880","-0.503","334.110584","57.220238","G8III","G","1","","" }
{ "110911","111259","213660","8588","","","","","","","Lac","","683.766","5.880","-0.727","338.109905","39.779733","A6V","A","1","","" }
{ "111045","111394","213789","8590","","60    Aqr","","60","","","Aqr","","347.715","5.880","0.741","338.512133","-1.574270","G6III","G","1","","" }
{ "111580","111934","214690","8623","","","","","","","PsA","","693.950","5.880","-0.760","340.092986","-30.658871","K2/K3III","K","1","","" }
{ "114004","114366","218619","8813","","","","","","","Scl","","649.714","5.880","-0.616","347.435954","-28.088572","K2III","K","1","","" }
{ "60989","61181","108970","4769","","","","","","","Mus","","347.715","5.880","0.741","188.041328","-73.001056","K1III","K","1","","" }
{ "61365","61558","109704","4799","","25    Vir","","25","","","Vir","","225.091","5.880","1.685","189.197311","-5.831898","A3V","A","1","","" }
{ "62207","62402","111270","4859","","","","","","","UMa","","196.598","5.880","1.979","191.828904","62.781155","A9V","A","1","","" }
{ "65118","65323","116365","5047","","65    Vir","","65","","","Vir","","1244.872","5.880","-2.028","200.828724","-4.924427","K3III","K","1","","" }
{ "65345","65550","116957","5067","","","","","","","CVn","","411.814","5.880","0.374","201.569144","46.028055","K0III:","K","1","","" }
{ "66982","67194","120047","5179","","","","","","","CVn","","171.391","5.880","2.277","206.556529","41.088746","A5V","A","1","","" }
{ "71127","71353","127971","5439","","","","","","","Cen","","366.880","5.880","0.625","218.881188","-41.517436","B6V","B","1","","" }
{ "73083","73310","132345","5582","","18    Lib","","18","","","Lib","","310.034","5.880","0.990","224.723257","-11.144014","K3III-IV","K","1","","" }
{ "73265","73493","132604","5585","","","","","","","Cen","","390.607","5.880","0.488","225.304548","-38.058398","K2/K3III","K","1","","" }
{ "74068","74296","131596","5557","","Ome Oct","Ome","","Ome","","Oct","","316.964","5.880","0.942","227.786648","-84.787812","B9.5V","B","1","","" }
{ "74672","74901","136028","5690","","","","","","","Ser","","726.406","5.880","-0.859","229.608859","-0.461234","K5III","K","1","","" }
{ "1490","1493","1439","71","","","","","","","And","","543.594","5.880","-0.229","4.659382","31.517227","A0IV","A","1","","" }
{ "2469","2475","2767","122","","","","","","","And","","378.811","5.880","0.555","7.856808","33.581642","K1III...","K","1","","" }
{ "3087","3093","3651","166","Gl 27","54    Psc","","54","","","Psc","","36.071","5.880","5.661","9.840940","21.250472","K0V","K","1","","" }
{ "4336","4346","5384","263","","","","","","","Cet","","601.764","5.880","-0.450","13.926667","-7.347149","K5III","K","1","","" }
{ "7587","7601","10800","512","Gl 67.1","","","","","","Oct","","89.309","5.880","3.693","24.479381","-82.974995","G2V","G","1","","" }
{ "11321","11348","15144","710","","","","","","","Cet","","251.276","5.880","1.446","36.501459","-15.341247","Ap SrCrEu","A","1","","" }
{ "11643","11670","15524","728","","","","","","","Ari","","168.818","5.880","2.310","37.634792","25.235036","F6IV","F","1","","" }
{ "14052","14086","18907","914","GJ 9107","Eps For","Eps","","Eps","","For","","105.009","5.880","3.341","45.406731","-28.091554","G8/K0V","G","1","","" }
{ "19081","19129","25274","1241","","","","","","","Cam","","624.821","5.880","-0.532","61.513227","68.679972","K2III","K","1","","" }
{ "19970","20020","27657","1372","","The Ret","The","","The","","Ret","","460.673","5.880","0.130","64.417785","-63.255405","B+...","B","1","","" }
{ "21270","21323","28929","1445","","","","","","","Tau","","485.352","5.880","0.017","68.658299","28.961150","B9p...","B","1","","" }
{ "24146","24203","33646","1691","","","","","","","Ori","","637.024","5.880","-0.574","77.938962","1.037028","F5","F","1","","" }
{ "26800","26865","38090","1968","","12    Lep","","12","","","Lep","","994.379","5.880","-1.541","85.558159","-22.373715","A2/A3V","A","1","","" }
{ "28782","28854","41547","2150","","","","","","","Mon","","179.108","5.880","2.182","91.362634","-10.242596","F4V:","F","1","","" }
{ "29605","29679","43396","2242","","","","","","","CMa","","737.910","5.880","-0.893","93.785010","-20.272186","K2III","K","1","","" }
{ "29779","29852","43940","2265","","","","","","","Col","","201.954","5.880","1.921","94.289872","-37.253498","A2V","A","1","","" }
{ "30472","30545","45067","2313","","","","","","","Mon","","109.485","5.880","3.250","96.318941","-0.945883","F8V","F","1","","" }
{ "30899","30972","45466","2338","","47    Aur","","47","","","Aur","","610.780","5.880","-0.482","97.512401","46.685554","K4III","K","1","","" }
{ "31082","31159","46241","2382","","12    Mon","","12","","","Mon","","562.339","5.880","-0.303","98.080022","4.855999","K0V","K","1","","" }
{ "31863","31946","46509","2396","","","","","","","Cam","","774.718","5.880","-0.999","100.134360","71.748786","K0III","K","1","","" }
{ "32141","32226","48434","2479","","","","","","","Mon","","2861.021","5.880","-3.835","100.911023","3.932528","B0III","B","1","","" }
{ "33328","33415","50763","2573","","","","","","","Aur","","349.578","5.880","0.729","104.233646","46.705352","K0III:","K","1","","" }
{ "40190","40305","68077","3200","","","","","","","Lyn","","574.219","5.880","-0.348","123.459108","56.452246","G9III","G","1","","" }
{ "40958","41074","70761","3291","","","","","","","Pup","","326156.378","5.880","-14.120","125.708069","-26.348220","F2Iab","F","1","","" }
{ "41816","41935","72184","3360","","","","","","","Lyn","","243.946","5.880","1.511","128.229145","38.016368","K2III","K","1","","" }
{ "43898","44024","77020","3583","","","","","","","Vel","","1035.417","5.880","-1.628","134.481514","-48.572910","G8/K0II","G","1","","" }
{ "46487","46620","82536","3793","","","","","","","Car","","967.823","5.880","-1.482","142.597652","-58.361839","M2III","M","1","","" }
{ "50541","50685","89343","4047","","","","","","","UMa","","402.166","5.880","0.425","155.264151","68.747651","A7Vn","A","1","","" }
{ "53567","53723","95234","4284","","","","","","","Crt","","661.575","5.880","-0.656","164.878870","-16.353701","M1III","M","1","","" }
{ "54923","55086","97989","4367","","","","","","","UMa","","448.633","5.880","0.188","169.174485","49.476250","K0III:","K","1","","" }
{ "28067","28139","40020","2076","","","","","","","Ori","","308.568","5.890","1.010","89.206038","11.521058","K2III","K","1","","" }
{ "28199","28271","40372","2100","","59    Ori","","59","","","Ori","","364.420","5.890","0.649","89.601844","1.837108","A5me del Del","A","1","","" }
{ "36925","37031","60803","2918","","","","","","","CMi","","128.206","5.890","2.918","114.144611","5.862171","G0V","G","1","","" }
{ "37645","37752","62893","3011","","","","","","","Pup","","672.487","5.890","-0.681","116.142443","-37.942917","B8V","B","1","","" }
{ "38158","38267","64225","3071","","","","","","","Pup","","246.156","5.890","1.501","117.599357","-50.509468","K2III","K","1","","" }
{ "40760","40875","69548","3254","","30    Lyn","","30","","","Lyn","","105.518","5.890","3.340","125.108460","57.743278","F4V","F","1","","" }
{ "40965","41081","71043","3300","","","","","","","Vel","","228.401","5.890","1.664","125.729860","-52.123730","A0V","A","1","","" }
{ "41558","41676","71088","3303","","","","","","","UMa","","319.761","5.890","0.933","127.442733","67.297441","G8III","G","1","","" }
{ "41889","42008","72561","3378","","","","","","","Hya","","1647.254","5.890","-2.627","128.431160","4.757000","G5III","G","1","","" }
{ "43002","43121","74873","3481","","50    Cnc","","50","","","Cnc","","176.015","5.890","2.229","131.733412","12.109952","A1V","A","1","","" }
{ "44155","44283","77887","3610","","","","","","","Vol","","707.497","5.890","-0.791","135.285404","-68.683916","M1III","M","1","","" }
{ "44179","44307","77104","3587","","66    Cnc","","66","","","Cnc","","466.604","5.890","0.112","135.350539","32.252296","A2V","A","1","","" }
{ "50715","50860","89904","4075","","27    LMi","","27","","","LMi","","242.315","5.890","1.535","155.776372","33.908145","A6V","A","1","","" }
{ "51893","52043","92287","4173","","","","","","","Car","","1006.656","5.890","-1.557","159.511053","-57.256309","B3IV","B","1","","" }
{ "54378","54537","96834","4336","","","","","","","UMa","","548.162","5.890","-0.237","167.410480","43.207736","M2III","M","1","","" }
{ "56119","56287","100382","4448","","","","","","","Mus","","306.538","5.890","1.025","173.083318","-66.961823","K1IIICN...","K","1","","" }
{ "57930","58103","103516","4563","","","","","","","Cen","","326156.378","5.890","-14.110","178.750073","-63.279180","A3Ib","A","1","","" }
{ "58545","58720","104600","4597","","","","","","","Mus","","344.774","5.890","0.769","180.657224","-69.192288","B9V","B","1","","" }
{ "58683","58858","104827","4602","","2    Com","","2","","","Com","","329.451","5.890","0.868","181.069152","21.459153","F0IV-V","F","1","","" }
{ "62734","62931","111973","4890","","Kap Cru","Kap","","Kap","","Cru","","326156.378","5.890","-14.110","193.453840","-60.376244","B5Ia","B","1","","" }
{ "62833","63033","112164","4903","GJ 9423","","","","","","Cen","","130.776","5.890","2.874","193.744032","-44.151968","G2IV","G","1","","" }
{ "65036","65241","116235","5040","","64    Vir","","64","","","Vir","","215.001","5.890","1.795","200.540372","5.154764","A2m","A","1","","" }
{ "67392","67605","120819","5215","","","","","","","CVn","","678.080","5.890","-0.699","207.788393","34.664399","M2III","M","1","","" }
{ "69271","69493","124425","5317","","","","","","","Vir","","193.679","5.890","2.022","213.419958","-0.845463","F7Vw","F","1","","" }
{ "72206","72432","130328","5519","","","","","","","Cen","","514.442","5.890","-0.100","222.158540","-36.634697","M5III","M","1","","" }
{ "75336","75565","136672","5713","","","","","","","TrA","","342.601","5.890","0.783","231.560833","-68.309167","K0III","K","1","","" }
{ "77206","77442","141527","5880","","","","","","","CrB","","326156.378","5.890","-14.110","237.143396","28.156749","C00 (F8pe)","C","1","","" }
{ "79117","79357","145931","6050","","","","","","","Her","","632.086","5.890","-0.547","242.948336","42.374569","K4II+...","K","1","","" }
{ "79970","80212","147225","6085","","","","","","","Nor","","942.648","5.890","-1.415","245.621120","-43.912051","G2Ib","G","1","","" }
{ "81460","81710","149671","6172","","Eta1TrA","Eta-1","","Eta","1","TrA","","661.575","5.890","-0.646","250.346342","-68.296123","B7IV","B","1","","" }
{ "84242","84500","156247","6414","","","","","","","Oph","","653.620","5.890","-0.619","259.132149","1.210545","B5Vnn","B","1","","" }
{ "85984","86248","159463","6547","","","","","","","Ara","","332.135","5.890","0.851","264.363801","-50.059702","K0III-IV","K","1","","" }
{ "88195","88469","164794","6736","","9    Sgr","","9","","","Sgr","","326156.378","5.890","-14.110","270.968520","-24.360730","O6","O","1","","" }
{ "91830","92117","173654","7059","","5    Aql","","5","","","Aql","","364.828","5.890","0.647","281.619143","-0.961692","A2m","A","1","","" }
{ "92025","92312","174262","7086","","","","","","","Her","","285.851","5.890","1.176","282.222440","19.328720","A1V","A","1","","" }
{ "92811","93104","176318","7174","","","","","","","Lyr","","578.292","5.890","-0.354","284.507911","38.266188","B7IV","B","1","","" }
{ "93279","93574","175986","7161","","","","","","","Pav","","183.647","5.890","2.137","285.873628","-68.755544","F8V","F","1","","" }
{ "95716","96016","184010","7421","","","","","","","Vul","","197.431","5.890","1.980","292.840086","26.617171","K0III-IV","K","1","","" }
{ "95932","96234","184035","7422","","","","","","","Sgr","","423.030","5.890","0.325","293.535353","-40.034638","A5IV-III","A","1","","" }
{ "96314","96620","185912","7484","","","","","","","Cyg","","133.343","5.890","2.832","294.671534","54.973793","F6Vasv","F","1","","" }
{ "96921","97229","186689","7519","","49Ups Aql","Ups","49","Ups","","Aql","","174.883","5.890","2.243","296.416446","7.613158","A3IV","A","1","","" }
{ "100757","101084","195554","7843","","","","","","","Cyg","","867.437","5.890","-1.234","307.362952","56.068190","B9Vn","B","1","","" }
{ "101515","101843","194612","7812","","","","","","","Oct","","638.271","5.890","-0.568","309.577522","-81.289063","K5III","K","1","","" }
{ "103128","103460","199443","8018","","","","","","","Cap","","178.912","5.890","2.194","314.419348","-16.031539","A2/A3III","A","1","","" }
{ "104929","105269","203156","8157","","","","","","","Cyg","","2159.976","5.890","-3.215","319.842417","38.237473","F2Ib","F","1","","" }
{ "112475","112833","217157","8736","","","","","","","Cep","","434.875","5.890","0.265","342.762271","85.373739","K5","K","1","","" }
{ "114383","114745","219485","8844","","","","","","","Cep","","452.995","5.890","0.177","348.654336","74.231268","A0V","A","1","","" }
{ "116487","116853","222493","8979","","","","","","","Aqr","","349.204","5.890","0.742","355.287129","-11.680655","K0III","K","1","","" }
{ "116552","116918","222602","8983","","","","","","","Psc","","324.211","5.890","0.903","355.486208","7.250546","A3Vn","A","1","","" }
{ "1626","1630","1606","78","","","","","","","And","","521.017","5.890","-0.127","5.101670","30.935614","B7V","B","1","","" }
{ "2897","2903","3379","155","","53    Psc","","53","","","Psc","","1038.714","5.890","-1.625","9.197134","15.231725","B2.5IV","B","1","","" }
{ "3163","3170","3823","176","Gl 29","","","","","","Tuc","","81.397","5.890","3.904","10.104880","-59.454604","G1V","G","1","","" }
{ "8982","9001","11727","556","","","","","","","And","","921.346","5.890","-1.365","28.976996","37.277786","K5III","K","1","","" }
{ "9288","9307","12139","577","","","","","","","Ari","","391.075","5.890","0.496","29.898655","21.058570","K0III-IV","K","1","","" }
{ "9334","9353","12235","582","","112    Psc","","112","","","Psc","","109.265","5.890","3.265","30.038165","3.097015","G2IV","G","1","","" }
{ "11007","11033","14728","693","","","","","","","Cet","","442.546","5.890","0.227","35.520760","-17.662169","K2III","K","1","","" }
{ "11354","11381","15220","713","","","","","","","Cet","","274.312","5.890","1.266","36.646727","-20.042617","K2III","K","1","","" }
{ "11521","11548","15335","720","Gl 99.1","13    Tri","","13","","","Tri","","102.436","5.890","3.405","37.202085","29.931760","G0V","G","1","","" }
{ "13088","13121","17471","830","","","","","","","Ari","","397.267","5.890","0.462","42.191254","25.188064","A0V","A","1","","" }
{ "13914","13949","18482","886","","","","","","","Per","","648.422","5.890","-0.602","44.916152","41.032941","K2","K","1","","" }
{ "14466","14502","19065","922","","","","","","","Cas","","618.892","5.890","-0.501","46.829204","64.057594","B9V","B","1","","" }
{ "18688","18735","25202","1238","","","","","","","Tau","","139.921","5.890","2.728","60.203172","18.194000","F4V...","F","1","","" }
{ "19236","19284","26038","1280","","","","","","","Tau","","401.670","5.890","0.438","61.997566","17.339897","K5III","K","1","","" }
{ "24105","24162","33608","1687","","","","","","","Ori","","122.708","5.890","3.013","77.829903","-2.490782","F5V","F","1","","" }
{ "330","330","225180","9100","","9    Cas","","9","","","Cas","","326156.378","5.900","-14.100","1.056930","62.287664","A1III","A","1","","" }
{ "3186","3193","3807","174","","","","","","","Cet","","471.324","5.900","0.101","10.176551","-4.351841","K0III","K","1","","" }
{ "3449","3456","4211","195","","Lam2Scl","Lam-2","","Lam","2","Scl","","338.688","5.900","0.818","11.050248","-38.421686","K1III","K","1","","" }
{ "3825","3834","4732","228","","","","","","","Cet","","188.857","5.900","2.086","12.308098","-24.136672","K0III","K","1","","" }
{ "7307","7321","9531","446","","","","","","","And","","467.943","5.900","0.116","23.569186","37.237146","B9IV","B","1","","" }
{ "7345","7359","9640","450","","","","","","","Psc","","532.066","5.900","-0.163","23.704437","18.460512","M2III","M","1","","" }
{ "11075","11102","14943","701","","","","","","","Eri","","198.513","5.900","1.978","35.727780","-51.092129","A5V","A","1","","" }
{ "19028","19076","25680","1262","Gl 160","39    Tau","","39","","","Tau","","55.243","5.900","4.756","61.334376","22.008905","G5V","G","1","","" }
{ "20821","20873","28294","1408","","76    Tau","","76","","","Tau","","187.770","5.900","2.099","67.097503","14.740974","F0IV","F","1","","" }
{ "24237","24294","33833","1697","","","","","","","Ori","","469.290","5.900","0.110","78.200537","-6.057190","G7III","G","1","","" }
{ "85150","85409","157662","6478","","","","","","","Ara","","2965.058","5.900","-3.893","261.801927","-50.630370","B9II","B","1","","" }
{ "90206","90485","169830","6907","","","","","","","Sgr","","119.384","5.900","3.082","276.956182","-29.816865","F8V","F","1","","" }
{ "96814","97122","187340","7545","","","","","","","Dra","","430.854","5.900","0.295","296.076694","69.337065","A2III","A","1","","" }
{ "98215","98526","189695","7648","","","","","","","Aql","","692.476","5.900","-0.735","300.245739","8.557735","K5III","K","1","","" }
{ "100741","101067","195324","7835","","42    Cyg","","42","","","Cyg","","2588.543","5.900","-3.598","307.334958","36.454729","A1Ib","A","1","","" }
{ "27904","27973","39586","2046","","","","","","","Aur","","277.108","5.900","1.254","88.745809","31.701496","A5IV","A","1","","" }
{ "28271","28343","40084","2081","","","","","","","Aur","","1072.883","5.900","-1.686","89.840754","49.924540","G5III","G","1","","" }
{ "28751","28823","41074","2132","","39    Aur","","39","","","Aur","","162.186","5.900","2.417","91.264142","42.981635","F3V","F","1","","" }
{ "33285","33372","51104","2589","","","","","","","Mon","","454.257","5.900","0.181","104.107639","9.956578","B8Vn","B","1","","" }
{ "34888","34982","55832","2732","","","","","","","Mon","","1874.462","5.900","-2.897","108.564666","-9.947533","K3III","K","1","","" }
{ "35379","35476","56989","2778","","","","","","","CMi","","637.024","5.900","-0.554","109.843212","2.740694","G9III","G","1","","" }
{ "36042","36143","59026","2856","","","","","","","Pup","","1032.140","5.900","-1.602","111.676945","-34.140692","B4V","B","1","","" }
{ "36536","36640","59984","2883","GJ 3449A","","","","","","Mon","","91.054","5.900","3.671","113.024014","-8.881326","F5V","F","1","","GJ 3449" }
{ "37887","37995","63271","3023","","","","","","","Pup","","1638.977","5.900","-2.606","116.802308","-22.519510","B1/B2V","B","1","","" }
{ "39140","39251","66358","3154","","","","","","","Pup","","573.210","5.900","-0.324","120.406360","-37.283720","A3IV","A","1","","" }
{ "42495","42614","74273","3453","","","","","","","Vel","","1976.705","5.900","-3.013","130.272173","-48.922680","B1.5V","B","1","","" }
{ "43769","43894","76292","3546","","","","","","","Lyn","","235.492","5.900","1.607","134.127210","40.201474","F3III","F","1","","" }
{ "46328","46460","82406","3783","","","","","","","Car","","253.227","5.900","1.450","142.127407","-66.701877","A0V","A","1","","" }
{ "47409","47544","83787","3850","","","","","","","Leo","","772.882","5.900","-0.973","145.396310","31.277817","K6III","K","1","","" }
{ "48382","48519","85709","3915","","","","","","","Sex","","929.220","5.900","-1.373","148.428855","5.958573","M2III","M","1","","" }
{ "51408","51556","91130","4124","","33    LMi","","33","","","LMi","","254.412","5.900","1.439","157.964058","32.379554","A0IV","A","1","","" }
{ "53375","53530","94985","4274","","","","","","","Vel","","335.897","5.900","0.836","164.282750","-50.765018","A7Vni","A","1","","" }
{ "55085","55249","98366","4381","","76    Leo","","76","","","Leo","","294.365","5.900","1.123","169.728996","1.650395","K0III:","K","1","","" }
{ "57433","57606","102590","4531","","","","","","","Leo","","194.837","5.900","2.019","177.161293","14.284210","F0V","F","1","","" }
{ "59846","60030","107070","4681","","13    Vir","","13","","","Vir","","373.604","5.900","0.605","184.667990","-0.787184","A5Vn","A","1","","" }
{ "64310","64515","114772","4985","","","","","","","Cen","","366.056","5.900","0.649","198.347346","-50.699829","B9V","B","1","","" }
{ "67875","68092","121607","5244","","92    Vir","","92","","","Vir","","294.365","5.900","1.123","209.116154","1.050581","A8V","A","1","","" }
{ "71345","71571","128750","5462","GJ 3862","","","","","","Boo","","322.927","5.900","0.922","219.558284","18.298379","K2III:","K","1","","" }
{ "72070","72296","130055","5508","","","","","","","Cen","","501.008","5.900","-0.032","221.771205","-38.290639","K3III","K","1","","" }
{ "72860","73087","131951","5567","","","","","","","Boo","","597.356","5.900","-0.414","224.055127","14.446266","A0V","A","1","","" }
{ "74158","74386","134943","5654","","","","","","","Ser","","723.185","5.900","-0.829","228.017762","18.976031","M4III","M","1","","" }
{ "75467","75696","138265","5755","","","","","","","Dra","","638.271","5.900","-0.558","231.964305","60.670217","K5III","K","1","","" }
{ "78637","78877","144334","5988","","","","","","","Sco","","526.059","5.900","-0.138","241.526574","-23.606315","B8V","B","1","","" }
{ "114045","114407","218655","8818","","","","","","","Gru","","918.750","5.900","-1.349","347.540549","-40.591547","M4III","M","1","","" }
{ "119548","","218641","","GJ 9812B","","","","","","Aqr","","155.312","5.900","2.511","347.479581","-22.457364","A3 (IV)","A","2","114013","GJ 9812" }
{ "112419","112778","216200","8690","","14    Lac","","14","","","Lac","","1136.434","5.910","-1.801","342.590721","41.953394","B3IV:var","B","1","","" }
{ "112814","113174","216756","8718","","","","","","","Lac","","127.256","5.910","2.954","343.760981","37.076827","F5II","F","1","","" }
{ "114068","114430","218804","8825","","6    And","","6","","","And","","90.173","5.910","3.702","347.613523","43.544232","F5IV","F","1","","" }
{ "115957","116323","221675","8944","","14    Psc","","14","","","Psc","","211.790","5.910","1.848","353.537571","-1.247567","A2m","A","1","","" }
{ "29606","29678","43112","2222","","","","","","","Ori","","1194.712","5.910","-1.909","93.785298","13.851098","B1V","B","1","","" }
{ "33334","33421","51000","2586","","","","","","","Gem","","422.482","5.910","0.348","104.252176","33.681039","G5III","G","1","","" }
{ "34705","34798","55522","2718","","26    CMa","","26","","","CMa","","838.448","5.910","-1.140","108.050896","-25.942588","B2IV/V","B","1","","" }
{ "35412","35509","57006","2779","","","","","","","CMi","","173.857","5.910","2.276","109.948522","7.142947","F8V","F","1","","" }
{ "39882","39995","67224","3175","","","","","","","Lyn","","858.306","5.910","-1.191","122.515785","58.248242","K4III:","K","1","","" }
{ "42053","42172","72945","3395","Gl 310.1A","","","","","","Cnc","","81.949","5.910","3.909","128.962396","6.620220","F8V","F","1","","Gl 310.1" }
{ "42333","42452","73171","3408","","","","","","","UMa","","521.850","5.910","-0.111","129.823475","52.711623","K1III:","K","1","","" }
{ "46350","46482","82347","3776","","","","","","","Car","","502.552","5.910","-0.029","142.196451","-62.273134","K1III","K","1","","" }
{ "46601","46734","82513","3789","","Zet2Ant","Zet-2","","Zet","2","Ant","","383.714","5.910","0.557","142.884016","-31.871831","A9IV","A","1","","" }
{ "49671","49812","88195","3989","","17    Sex","","17","","","Sex","","596.264","5.910","-0.400","152.531421","-8.408170","A1V","A","1","","" }
{ "49962","50103","88809","4015","","","","","","","Ant","","480.348","5.910","0.069","153.441404","-40.346056","K1III","K","1","","" }
{ "51461","51610","91437","4139","","","","","","","Vel","","397.267","5.910","0.482","158.140055","-44.618508","G6/G8III","G","1","","" }
{ "53103","53257","94132","4243","","","","","","","UMa","","144.445","5.910","2.679","163.379783","69.853881","G9IV","G","1","","" }
{ "53268","53423","94672","4265","","55    Leo","","55","","","Leo","","146.324","5.910","2.651","163.926654","0.736922","F2III","F","1","","" }
{ "53294","53449","94705","4267","","56    Leo","","56","","","Leo","","388.744","5.910","0.529","164.006124","6.185371","M5IIIvar","M","1","","" }
{ "8388","8404","11037","527","","","","","","","Psc","","321.020","5.910","0.944","27.108410","3.685447","G9III","G","1","","" }
{ "10416","10440","13940","659","","","","","","","Phe","","344.774","5.910","0.789","33.633123","-41.166765","G9III","G","1","","" }
{ "11838","11867","15975","744","","Lam1For","Lam-1","","Lam","1","For","","364.828","5.910","0.667","38.279286","-34.649967","K0/K1III","K","1","","" }
{ "12149","12181","16176","756","","","","","","","And","","176.683","5.910","2.241","39.238182","38.733581","F5V","F","1","","" }
{ "14075","14109","18769","905","","49    Ari","","49","","","Ari","","209.882","5.910","1.867","45.475593","26.462354","A3m","A","1","","" }
{ "15475","15514","20618","995","","59    Ari","","59","","","Ari","","219.339","5.910","1.772","49.982493","27.071134","G8IV","G","1","","" }
{ "16477","16518","21856","1074","","","","","","","Per","","2203.759","5.910","-3.239","53.166741","35.461729","B1V","B","1","","" }
{ "17553","17595","23526","1159","","","","","","","Tau","","335.207","5.910","0.851","56.539012","6.803520","G9III","G","1","","" }
{ "17576","17618","23738","1171","","Sig For","Sig","","Sig","","For","","329.451","5.910","0.888","56.614283","-29.338157","A2V","A","1","","" }
{ "17763","17805","23887","1182","","","","","","","Eri","","486.800","5.910","0.040","57.162310","0.227857","K3III","K","1","","" }
{ "20330","20380","27322","1342","","","","","","","Cam","","316.350","5.910","0.976","65.465887","56.506317","A3V","A","1","","" }
{ "20367","20417","27639","1370","","","","","","","Tau","","2329.688","5.910","-3.359","65.594708","20.821416","M0III","M","1","","" }
{ "21399","21452","28780","1440","","","","","","","Cam","","440.752","5.910","0.256","69.100905","64.261602","A1V","A","1","","" }
{ "23353","23408","32263","1618","","","","","","","Ori","","473.377","5.910","0.101","75.459804","0.722112","K0","K","1","","" }
{ "82420","82672","151967","6251","","","","","","","Ara","","709.036","5.910","-0.776","253.501585","-57.909507","M0III","M","1","","" }
{ "83221","83478","154228","6341","","","","","","","Her","","250.312","5.910","1.485","255.913759","13.605346","A1V","A","1","","" }
{ "83234","83491","153890","6327","","","","","","","Sco","","210.968","5.910","1.856","255.962195","-38.152572","F3V","F","1","","" }
{ "84451","84709","156384","6426","Gl 667A","","","","","","Sco","","22.295","5.910","6.736","259.737627","-34.989792","K4V","K","1","","Gl 667" }
{ "84789","85048","157097","6456","","","","","","","Sco","","368.955","5.910","0.642","260.728108","-37.220786","K1III","K","1","","" }
{ "87220","87491","162774","6667","","","","","","","Oph","","367.707","5.910","0.650","268.147684","1.305014","K5III","K","1","","" }
{ "91846","92133","174237","7084","","","","","","","Dra","","1294.271","5.910","-2.083","281.679517","52.987960","B2.5V","B","1","","" }
{ "92639","92931","175360","7128","","","","","","","Sgr","","635.782","5.910","-0.539","284.002799","-23.173751","B6III","B","1","","" }
{ "92886","93179","176232","7167","","10    Aql","","10","","","Aql","","255.608","5.910","1.439","284.695517","13.906648","F0spe...","F","1","","" }
{ "94261","94556","179433","7281","","","","","","","CrA","","297.860","5.910","1.107","288.664790","-45.193527","G8III","G","1","","" }
{ "94743","95038","182190","7356","","","","","","","Dra","","789.725","5.910","-1.010","290.066752","57.645129","M1III","M","1","","" }
{ "95161","95456","182286","7360","","","","","","","Sgr","","297.860","5.910","1.107","291.266847","-29.309359","K3III","K","1","","" }
{ "97287","97598","187086","7537","","","","","","","Tel","","1331.251","5.910","-2.144","297.558571","-47.557392","M1III","M","1","","" }
{ "97464","97774","188252","7591","","","","","","","Cyg","","1664.063","5.910","-2.629","298.029866","47.931795","B2III","B","1","","" }
{ "99213","99531","192044","7719","","20    Vul","","20","","","Vul","","805.324","5.910","-1.053","303.002921","26.478806","B7Ve...","B","1","","" }
{ "99696","100017","193664","7783","Gl 788","","","","","","Dra","","57.301","5.910","4.686","304.378774","66.853687","G3V","G","1","","" }
{ "101542","101870","196753","7895","","","","","","","Vul","","2038.477","5.910","-3.069","309.645795","23.680494","K0II-III+..","K","1","","" }
{ "102027","102358","197939","7944","","","","","","","Cep","","1098.170","5.910","-1.726","311.091860","56.488405","M3III","M","1","","" }
{ "102156","102487","197725","7937","","17    Cap","","17","","","Cap","","263.667","5.910","1.372","311.541614","-21.514032","A1V","A","1","","" }
{ "103770","104105","201908","8112","","","","","","","Cep","","402.662","5.910","0.452","316.371757","78.126392","B8Vn","B","1","","" }
{ "59335","59517","106068","4644","","","","","","","Cru","","326156.378","5.910","-14.090","183.091597","-62.950773","B9Ia","B","1","","" }
{ "60123","60308","107543","4702","","","","","","","Cru","","2264.975","5.910","-3.298","185.489301","-56.374385","K4III + (F)","K","1","","" }
{ "61910","62103","110646","4837","","","","","","","Vir","","218.457","5.910","1.780","190.908542","-1.576996","G8IIIp","G","1","","" }
{ "62664","62861","111884","4885","","","","","","","Cen","","413.379","5.910","0.395","193.267532","-54.952473","K3III","K","1","","" }
{ "64023","64226","114326","4962","","","","","","","Com","","672.487","5.910","-0.661","197.449372","16.848611","K5III","K","1","","" }
{ "64042","64246","114447","4971","","17    CVn","","17","","","CVn","","206.428","5.910","1.903","197.513446","38.498981","A9III-IV","A","1","","" }
{ "64261","64466","114570","4977","","","","","","","Mus","","295.968","5.910","1.121","198.203254","-66.226747","A0V(n)","A","1","","" }
{ "64375","64580","114835","4988","","","","","","","Cen","","356.066","5.910","0.719","198.550489","-58.683937","K0/K1III","K","1","","" }
{ "66245","66454","118354","5121","","","","","","","Cen","","412.334","5.910","0.401","204.347837","-46.427879","B8V","B","1","","" }
{ "66691","66903","120084","5184","","","","","","","UMi","","328.455","5.910","0.895","205.663943","78.064437","G7III:","G","1","","" }
{ "67568","67782","121164","5229","","","","","","","CVn","","214.435","5.910","1.821","208.292883","28.648131","A7V","A","1","","" }
{ "70889","71115","127739","5434","","26    Boo","","26","","","Boo","","176.206","5.910","2.247","218.135617","22.260059","F2IV","F","1","","" }
{ "72212","72438","129954","5500","","","","","","","Cir","","1405.847","5.910","-2.263","222.185653","-66.593563","B2.5V","B","1","","" }
{ "72546","72773","130701","5527","","","","","","","Cir","","1647.254","5.910","-2.607","223.146935","-63.809827","F8II + A/F","F","1","","" }
{ "73123","73350","132525","5584","","","","","","","Vir","","701.412","5.910","-0.753","224.846314","4.567761","M1III","M","1","","" }
{ "73280","73507","133388","5608","","","","","","","Dra","","344.774","5.910","0.789","225.362923","60.204453","A4V","A","1","","" }
{ "78507","78747","143928","5975","","","","","","","Lup","","123.544","5.910","3.018","241.153484","-37.862951","F3V","F","1","","" }
{ "79355","79596","145838","6044","","","","","","","Sco","","569.208","5.910","-0.299","243.593192","-33.011088","K0III","K","1","","" }
{ "82099","82350","151862","6246","","","","","","","Her","","326.483","5.910","0.908","252.394405","13.261141","A1V","A","1","","" }
{ "62366","62561","112014","4892","","","","","","","Cam","","401.176","5.920","0.470","192.278243","83.417832","A0V","A","1","","" }
{ "64185","64390","114371","4966","","","","","","","Mus","","137.329","5.920","2.798","197.964174","-69.942017","F3IV/V","F","1","","" }
{ "66038","66247","118054","5106","","","","","","","Vir","","483.194","5.920","0.067","203.668543","-13.214324","A0V","A","1","","" }
{ "66666","66878","120565","5203","","","","","","","Cam","","399.701","5.920","0.478","205.595678","82.752408","G9III","G","1","","" }
{ "66998","67210","120048","5180","","","","","","","CVn","","426.348","5.920","0.338","206.579458","38.503626","G9III","G","1","","" }
{ "67079","67292","119938","5175","","","","","","","Cen","","211.515","5.920","1.860","206.865080","-50.249291","A3m...","A","1","","" }
{ "68115","68333","121853","5251","","","","","","","Cen","","346.238","5.920","0.790","209.822805","-50.369647","G8/K0III","G","1","","" }
{ "73188","73415","131425","5547","","","","","","","Aps","","762.048","5.920","-0.923","225.047209","-77.160550","G8II","G","1","","" }
{ "80744","80991","149650","6170","","","","","","","Dra","","371.054","5.920","0.640","248.106948","60.823323","A2V","A","1","","" }
{ "81479","81729","150682","6213","","39    Her","","39","","","Her","","142.675","5.920","2.715","250.402912","26.916880","F2III","F","1","","" }
{ "3752","3760","4627","221","","62    Psc","","62","","","Psc","","579.319","5.920","-0.327","12.072540","7.299928","G8III","G","1","","" }
{ "4951","4962","6130","292","","","","","","","Cas","","2000.959","5.920","-3.019","15.904194","61.074823","F0II","F","1","","" }
{ "6550","6564","8556","404","","","","","","","Cet","","152.125","5.920","2.576","21.085429","-6.914656","F4V","F","1","","" }
{ "6617","6631","8810","420","","","","","","","Hyi","","903.480","5.920","-1.292","21.272037","-64.369478","M0III","M","1","","" }
{ "7002","7016","9228","436","","","","","","","Scl","","449.871","5.920","0.222","22.595426","-26.207851","K2III","K","1","","" }
{ "8571","8588","11257","534","","","","","","","Ari","","137.040","5.920","2.803","27.716556","11.043378","F2Vw","F","1","","" }
{ "13192","13225","17793","848","","Eta2For","Eta-2","","Eta","2","For","","449.871","5.920","0.222","42.561570","-35.843636","K0III","K","1","","" }
{ "14808","14844","18778","906","","","","","","","Cep","","202.834","5.920","1.951","47.928441","81.470710","A7III-IV","A","1","","" }
{ "14877","14913","20121","968","","","","","","","Eri","","138.613","5.920","2.778","48.107197","-44.419660","F3V+...","F","1","","" }
{ "23391","23446","32515","1635","","","","","","","Cae","","311.515","5.920","1.020","75.595022","-31.771333","K2III","K","1","","" }
{ "25407","25471","35520","1795","","","","","","","Aur","","2104.235","5.920","-3.128","81.703346","34.391810","A1p","A","1","","" }
{ "26044","26108","36780","1874","","","","","","","Ori","","683.766","5.920","-0.687","83.516864","-1.470253","K5III","K","1","","" }
{ "110186","110532","212320","8530","","","","","","","Aqr","","466.604","5.920","0.142","335.883963","-7.194421","G6V","G","1","","" }
{ "111713","112067","214995","8642","","","","","","","Peg","","277.108","5.920","1.274","340.489390","14.516393","K0III:","K","1","","" }
{ "114559","114921","219507","8846","","","","","","","Gru","","290.951","5.920","1.168","349.165792","-44.489166","K1III","K","1","","" }
{ "27896","27965","39698","2052","","57    Ori","","57","","","Ori","","1822.103","5.920","-2.816","88.736195","19.749614","B2V","B","1","","" }
{ "30913","30986","45976","2367","","","","","","","Mon","","1042.033","5.920","-1.602","97.546984","-10.081511","K0","K","1","","" }
{ "30964","31037","46189","2380","","","","","","","CMa","","1230.779","5.920","-1.964","97.692870","-27.769575","B3IV/V","B","1","","" }
{ "32280","32366","49095","2500","Gl 245.1","","","","","","CMa","","79.512","5.920","3.985","101.345670","-31.793661","F7V","F","1","","" }
{ "32377","32463","48977","2494","","16    Mon","","16","","","Mon","","858.306","5.920","-1.181","101.635066","8.587153","B2.5V","B","1","","" }
{ "37258","37364","61774","2960","","","","","","","Pup","","622.436","5.920","-0.483","115.056371","-19.660861","K0III","K","1","","" }
{ "40766","40881","70011","3268","","19Lam Cnc","Lam","19","Lam","","Cnc","Piautos","457.442","5.920","0.185","125.133905","24.022314","B9.5V","B","1","","" }
{ "40964","41080","70652","3288","","","","","","","Hya","","1289.156","5.920","-2.064","125.725398","-7.543120","M1III","M","1","","" }
{ "41882","42001","72832","3389","","","","","","","Vel","","834.160","5.920","-1.119","128.410144","-38.848815","B5III","B","1","","" }
{ "42146","42265","73143","3406","","36    Cnc","","36","","","Cnc","","488.258","5.920","0.044","129.274043","9.655580","A3V","A","1","","" }
{ "43466","43589","76161","3539","","","","","","","Vel","","1038.714","5.920","-1.595","133.160872","-48.359097","B3Vn","B","1","","" }
{ "45138","45270","79621","3670","","","","","","","Vel","","509.619","5.920","-0.049","138.393586","-47.338407","B9V","B","1","","" }
{ "46764","46897","82747","3810","","","","","","","Hya","","261.763","5.920","1.398","143.358562","-22.863883","B9.5V","B","1","","" }
{ "52709","52863","93655","4224","","","","","","","Sex","","546.326","5.920","-0.200","162.168983","-1.958896","M2III","M","1","","" }
{ "98072","98383","189684","7646","","","","","","","Cyg","","452.995","5.920","0.207","299.835090","45.772541","A5III","A","1","","" }
{ "103028","103360","199612","8026","","","","","","","Cyg","","765.625","5.920","-0.933","314.107892","49.195847","G8II-III","G","1","","" }
{ "104630","104968","203399","8168","","","","","","","Cep","","950.893","5.920","-1.404","318.926687","77.012296","K5III","K","1","","" }
{ "107852","108195","207964","8352","","","","","","","Ind","","151.560","5.920","2.584","328.797352","-61.886608","F1III","F","1","","" }
{ "83639","83896","154783","6366","","","","","","","Sco","","255.209","5.930","1.463","257.198078","-30.403730","Fm","F","1","","" }
{ "84473","84731","156091","6408","","","","","","","Ara","","2489.743","5.930","-3.484","259.802124","-59.694612","K2IIICN...","K","1","","" }
{ "85262","85520","157819","6487","","","","","","","Ara","","985.367","5.930","-1.471","262.162139","-55.169686","G8II/III","G","1","","" }
{ "86805","87074","161701","6620","","","","","","","Ser","","599.552","5.930","-0.392","266.903248","-14.725824","B9V","B","1","","" }
{ "87542","87813","163336","6681","","","","","","","Ser","","241.240","5.930","1.585","269.079315","-15.812521","A0V","A","1","","" }
{ "90562","90844","170920","6957","","61    Ser","","61","","","Ser","","614.230","5.930","-0.445","277.987476","-1.002977","A4III","A","1","","" }
{ "91064","91347","171856","6988","","","","","","","Sgr","","340.455","5.930","0.837","279.476775","-21.397725","A5IV","A","1","","" }
{ "92110","92398","174585","7100","","8Nu 1Lyr","Nu-1","8","Nu","1","Lyr","","1309.865","5.930","-2.089","282.441307","32.812820","B3IV","B","1","","" }
{ "93329","93624","176664","7190","","","","","","","Tel","","325.505","5.930","0.934","285.989771","-51.018604","K0/K1III","K","1","","" }
{ "93468","93763","177517","7230","","","","","","","Sgr","","715.255","5.930","-0.775","286.421582","-15.660419","B8IIIsp...","B","1","","" }
{ "94016","94311","179527","7283","","19    Lyr","","19","","","Lyr","","891.138","5.930","-1.253","287.941705","31.283456","B9p Si","B","1","","" }
{ "96670","96977","186377","7502","","","","","","","Cyg","","1964.797","5.930","-2.969","295.685857","32.426741","A5III","A","1","","" }
{ "103504","103836","200073","8046","","","","","","","Mic","","219.634","5.930","1.789","315.613094","-38.530970","K2III","K","1","","" }
{ "103624","103956","200817","8078","","","","","","","Cyg","","372.750","5.930","0.640","315.948372","53.285900","K0III","K","1","","" }
{ "105471","105811","204172","8209","","69    Cyg","","69","","","Cyg","","326156.378","5.930","-14.070","321.445934","36.667386","B0Ib","B","1","","" }
{ "109231","109577","210702","8461","","","","","","","Peg","","179.207","5.930","2.230","332.963879","16.040551","K1III","K","1","","" }
{ "111688","112041","215030","8643","","","","","","","Lac","","299.226","5.930","1.117","340.400100","41.549123","G9III","G","1","","" }
{ "111887","112241","215359","8654","","","","","","","Lac","","692.476","5.930","-0.705","341.021736","39.465348","K5III+...","K","1","","" }
{ "117174","117541","223524","9027","","","","","","","Aqr","","297.317","5.930","1.131","357.561374","-9.974136","K0IV","K","1","","" }
{ "117393","117761","223825","9041","","24    Psc","","24","","","Psc","","448.017","5.930","0.241","358.231522","-3.155482","G9III","G","1","","" }
{ "55707","55874","99564","4416","","16Kap Crt","Kap","16","Kap","","Crt","","228.561","5.930","1.702","171.789658","-12.356749","F4III-IV","F","1","","" }
{ "57984","58158","103596","4565","","","","","","","Hya","","547.242","5.930","-0.194","178.917214","-28.477103","K4III","K","1","","" }
{ "62963","63165","112219","4907","","","","","","","Mus","","575.232","5.930","-0.302","194.132128","-72.185212","G8III","G","1","","" }
{ "63485","63688","113120","4930","","","","","","","Mus","","1000.480","5.930","-1.504","195.772308","-71.475729","B1.5IIIne","B","1","","" }
{ "68450","68670","122438","5266","","","","","","","Cen","","545.412","5.930","-0.186","210.860568","-56.213434","K2III","K","1","","" }
{ "69772","69995","125283","5357","","","","","","","Cen","","239.645","5.930","1.599","214.849527","-37.002907","A1V","A","1","","" }
{ "71533","71759","129153","5473","","","","","","","Boo","","165.730","5.930","2.400","220.176632","13.534325","F0V","F","1","","" }
{ "76190","76424","139225","5804","","18Tau5Ser","Tau-5","18","Tau","5","Ser","","169.785","5.930","2.348","234.121822","16.119085","F3V","F","1","","" }
{ "76850","77086","140285","5846","","","","","","","Lup","","469.290","5.930","0.140","236.094491","-41.819089","A0V + B","A","1","","" }
{ "78304","78542","144204","5981","","","","","","","Dra","","811.334","5.930","-1.049","240.523157","52.915917","K5III","K","1","","" }
{ "78880","79120","145085","6011","","","","","","","Ser","","396.302","5.930","0.507","242.245331","3.454475","K5III","K","1","","" }
{ "78897","79137","145148","6014","","","","","","","Ser","","92.343","5.930","3.670","242.296724","6.378695","K1+...","K","1","","" }
{ "79711","79953","147352","6090","","","","","","","Her","","639.522","5.930","-0.532","244.796750","49.038159","K6III","K","1","","" }
{ "81275","81523","149886","6178","","","","","","","Sco","","365.646","5.930","0.682","249.771784","-37.217370","B9.5V+...","B","1","","" }
{ "635","636","319","12","","","","","","","Cet","","255.608","5.930","1.459","1.945402","-22.508560","A1V","A","1","","" }
{ "2605","2611","2952","135","","","","","","","Cas","","372.325","5.930","0.643","8.293185","54.894985","K0III","K","1","","" }
{ "5582","5594","7147","353","","34    Cet","","34","","","Cet","","560.406","5.930","-0.245","17.931287","-2.251079","K4III","K","1","","" }
{ "13439","13473","18149","863","","Psi For","Psi","","Psi","","For","","190.846","5.930","2.094","43.393281","-38.437004","F5V","F","1","","" }
{ "13445","13479","18071","862","","","","","","","Eri","","364.014","5.930","0.692","43.397162","-22.376308","G8/K0III","G","1","","" }
{ "14002","14036","18700","902","","","","","","","Ari","","526.059","5.930","-0.108","45.183919","10.870388","K6","K","1","","" }
{ "14967","15004","19845","956","","","","","","","Per","","380.136","5.930","0.597","48.349451","48.176953","G9III","G","1","","" }
{ "15319","15357","20606","993","","","","","","","For","","203.213","5.930","1.957","49.510761","-28.797075","F3V+...","F","1","","" }
{ "15990","16029","21430","1045","","","","","","","For","","451.740","5.930","0.223","51.593851","-27.317479","K0III","K","1","","" }
{ "16317","16358","21755","1067","","","","","","","Tau","","502.552","5.930","-0.009","52.689249","6.188703","G8III","G","1","","" }
{ "18155","18199","24706","1216","","","","","","","Hor","","351.083","5.930","0.770","58.388809","-46.893674","K3III","K","1","","" }
{ "18676","18723","25371","1246","","","","","","","Eri","","351.462","5.930","0.768","60.169380","-30.490697","A1V","A","1","","" }
{ "23964","24019","33204","1670","","","","","","","Tau","","171.571","5.930","2.325","77.437866","28.030461","A5m","A","1","","" }
{ "25726","25790","36162","1832","","","","","","","Ori","","253.030","5.930","1.481","82.609023","15.360449","A3Vn","A","1","","" }
{ "26697","26762","37788","1955","","","","","","","Ori","","156.355","5.930","2.527","85.273315","0.337753","F0IV","F","1","","" }
{ "27183","27249","38091","1969","","26    Cam","","26","","","Cam","","198.271","5.930","2.011","86.626588","56.115575","A4Vn","A","1","","" }
{ "27668","27737","39937","2072","","","","","","","Pic","","432.568","5.930","0.317","88.084135","-57.156191","F7IV","F","1","","" }
{ "28719","28790","41742","2158","","","","","","","Pup","","87.724","5.930","3.782","91.167168","-45.078932","F4V","F","1","","" }
{ "29123","29196","42049","2169","","","","","","","Gem","","2064.281","5.930","-3.077","92.385156","22.190262","K4III","K","1","","" }
{ "31369","31448","46709","2406","","","","","","","Mon","","1531.251","5.930","-2.428","98.823319","9.988335","K4III","K","1","","" }
{ "33928","34017","52711","2643","Gl 262","","","","","","Gem","","62.398","5.930","4.521","105.876855","29.337081","G4V","G","1","","" }
{ "35208","35304","55866","2737","","","","","","","Lyn","","598.452","5.930","-0.388","109.390499","52.131071","K1III:","K","1","","" }
{ "36940","37046","60294","2894","","","","","","","Lyn","","266.467","5.930","1.369","114.196002","55.755060","K2III","K","1","","" }
{ "37034","37140","60652","2914","","","","","","","Lyn","","254.016","5.930","1.473","114.474415","48.773842","A5m","A","1","","" }
{ "37321","37428","61603","2951","","","","","","","Gem","","1524.095","5.930","-2.418","115.243827","23.018527","K5","K","1","","" }
{ "37841","37949","62066","2975","","51    Cam","","51","","","Cam","","328.455","5.930","0.915","116.666898","65.455676","K2III:","K","1","","" }
{ "45330","45461","78935","3645","","","","","","","UMa","","287.362","5.930","1.205","138.969584","72.946326","F0III","F","1","","" }
{ "49024","49164","87283","3960","","","","","","","Car","","326156.378","5.930","-14.070","150.500419","-60.420890","A9IV","A","1","","" }
{ "50740","50885","90044","4082","","25    Sex","","25","","","Sex","","339.746","5.930","0.841","155.860327","-4.074035","B9p Si(CrSr)","B","1","","" }
{ "50847","50993","90454","4095","","","","","","","Car","","313.010","5.930","1.019","156.247740","-58.576303","F2III","F","1","","" }
{ "53239","53394","94776","4271","","","","","","","Car","","304.819","5.930","1.077","163.821841","-60.517003","K0III","K","1","","" }
{ "31596","31676","46480","2394","","8    Lyn","","8","","","Lyn","","169.785","5.940","2.358","99.422995","61.481233","G8IV-V","G","1","","" }
{ "32851","32938","50445","2558","","","","","","","Pup","","180.097","5.940","2.230","102.926776","-36.230270","A3V","A","1","","" }
{ "34268","34358","53686","2665","","","","","","","Gem","","656.250","5.940","-0.578","106.843336","34.009288","K4III","K","1","","" }
{ "34724","34817","55718","2726","","","","","","","Pup","","908.513","5.940","-1.285","108.107601","-36.544381","B4V","B","1","","" }
{ "36055","36156","58579","2837","","61    Gem","","61","","","Gem","","446.790","5.940","0.257","111.734710","20.257557","F2Vn","F","1","","" }
{ "38059","38167","63786","3049","","","","","","","Pup","","516.070","5.940","-0.056","117.311040","-35.243286","B9V","B","1","","" }
{ "41000","41117","70569","3284","","20    Cnc","","20","","","Cnc","","384.165","5.940","0.585","125.841001","18.332200","A9V","A","1","","" }
{ "41460","41578","71555","3333","","29    Cnc","","29","","","Cnc","","343.323","5.940","0.829","127.155582","14.210822","A5V","A","1","","" }
{ "45529","45661","80024","3686","","","","","","","Lyn","","283.614","5.940","1.243","139.607982","35.364080","A8V","A","1","","" }
{ "55981","56148","99984","4431","","58    UMa","","58","","","UMa","","174.229","5.940","2.302","172.629758","43.173242","F4V","F","1","","" }
{ "56149","56318","100343","4446","","","","","","","Crt","","481.057","5.940","0.096","173.198069","-7.827523","K4III","K","1","","" }
{ "56558","56727","101162","4485","","","","","","","Mus","","353.749","5.940","0.764","174.451909","-67.620379","K0III","K","1","","" }
{ "59973","60157","107295","4691","","","","","","","Crv","","385.984","5.940","0.574","185.044887","-22.175700","K0III+...","K","1","","" }
{ "70161","70384","126200","5388","","","","","","","Boo","","441.946","5.940","0.280","216.003652","8.243969","A3V","A","1","","" }
{ "77036","77272","141472","5878","","","","","","","Dra","","879.128","5.940","-1.213","236.645051","55.474791","K3III","K","1","","" }
{ "82648","82902","152527","6275","","","","","","","Ara","","378.811","5.940","0.615","254.119921","-52.283746","A0III","A","1","","" }
{ "83847","84105","155035","6374","","","","","","","Ara","","1113.162","5.940","-1.726","257.911159","-48.873399","M1/M2III","M","1","","" }
{ "85123","85382","158261","6506","","","","","","","Her","","288.379","5.940","1.207","261.692288","34.695802","A0V","A","1","","" }
{ "86001","86266","159877","6562","","","","","","","Ser","","1545.765","5.940","-2.439","264.400853","-15.571038","F0IV","F","1","","" }
{ "87119","87390","162189","6643","","","","","","","Sco","","565.262","5.940","-0.254","267.885596","-40.772461","M2III","M","1","","" }
{ "88419","88694","165185","6748","Gl 702.1","","","","","","Sgr","","57.251","5.940","4.718","271.598769","-36.019788","G3V","G","1","","" }
{ "100797","101123","195094","7830","","12Omi Cap","Omi","12","Omi","","Cap","","216.428","5.940","1.831","307.474611","-18.583178","A1V","A","1","","" }
{ "103766","104101","200790","8077","","4    Equ","","4","","","Equ","","159.568","5.940","2.492","316.361335","5.958199","F8V","F","1","","" }
{ "107031","107374","207198","8327","","","","","","","Cep","","2992.260","5.940","-3.873","326.222006","62.460567","O9II","O","1","","" }
{ "108503","108849","208741","8380","","","","","","","Oct","","204.103","5.940","1.958","330.765660","-76.118427","F3III","F","1","","" }
{ "111572","111925","214878","8633","","","","","","","Lac","","366.468","5.940","0.687","340.076685","53.845927","B8V","B","1","","" }
{ "113326","113686","217563","8759","","","","","","","Aqr","","1475.821","5.940","-2.338","345.382125","-4.711461","K0","K","1","","" }
{ "1094","1096","942","42","","","","","","","Scl","","1294.271","5.940","-2.053","3.426010","-26.022345","K5III","K","1","","" }
{ "2371","2377","2626","113","","","","","","","Cas","","769.237","5.940","-0.923","7.583013","59.977554","B9IIIn","B","1","","" }
{ "2781","2787","3229","143","","14    Cet","","14","","","Cet","","177.742","5.940","2.258","8.886806","-0.505610","F5IV","F","1","","" }
{ "3513","3521","4293","198","","","","","","","Phe","","210.017","5.940","1.896","11.237799","-42.676558","A7V","A","1","","" }
{ "7628","7643","10142","471","","","","","","","Scl","","332.135","5.940","0.901","24.614527","-36.528251","K0III","K","1","","" }
{ "8408","8423","10975","521","","","","","","","And","","341.168","5.940","0.842","27.162113","37.952870","K0III","K","1","","" }
{ "8576","8593","11413","541","","","","","","","Phe","","251.664","5.940","1.503","27.726878","-50.206138","A1V","A","1","","" }
{ "10211","10234","13468","639","","63    Cet","","63","","","Cet","","388.281","5.940","0.561","32.899312","-1.825429","G9III:","G","1","","" }
{ "13333","13367","17463","829","","","","","","","Cas","","1289.156","5.940","-2.044","42.994790","68.888497","F5:Ib-II","F","1","","" }
{ "15630","15669","20675","1001","","","","","","","Per","","142.551","5.940","2.737","50.468655","49.070905","F6V","F","1","","" }
{ "19328","19376","26171","1284","","","","","","","Tau","","406.172","5.940","0.464","62.256538","13.398281","B9.5V","B","1","","" }
{ "20567","20619","28413","1416","","","","","","","Ret","","701.412","5.940","-0.723","66.272288","-61.238193","K4/K5III","K","1","","" }
{ "21194","21247","28204","1401","","","","","","","Cam","","331.797","5.940","0.903","68.377661","72.528605","A8m","A","1","","" }
{ "25228","25291","35239","1776","","","","","","","Aur","","689.548","5.940","-0.686","81.160501","31.143148","B9III","B","1","","" }
{ "4893","4903","6116","290","","39    And","","39","","","And","","349.953","5.950","0.797","15.726108","41.345157","A5m","A","1","","" }
{ "5649","5661","7312","359","","","","","","","Scl","","226.340","5.950","1.743","18.189246","-37.856479","A9IV: (+F/G)","A","1","","" }
{ "7433","7447","9780","457","","","","","","","Psc","","189.406","5.950","2.130","23.978134","17.433841","F0IV","F","1","","" }
{ "12788","12821","16769","791","","","","","","","Cas","","413.379","5.950","0.435","41.207001","67.824630","A5III","A","1","","" }
{ "16623","16664","22091","1086","","7    Tau","","7","","","Tau","","429.153","5.950","0.354","53.610936","24.464393","A3V","A","1","","" }
{ "17804","17846","23728","1170","","","","","","","Per","","241.956","5.950","1.598","57.283828","43.963095","A9IV","A","1","","" }
{ "19946","19996","27179","1332","","","","","","","Eri","","756.743","5.950","-0.878","64.330092","-6.472177","G8III:","G","1","","" }
{ "20191","20241","27278","1337","","","","","","","Per","","401.670","5.950","0.498","65.060111","41.808070","K0III","K","1","","" }
{ "20840","20892","28479","1421","","","","","","","Eri","","308.276","5.950","1.072","67.162652","-19.458874","K2III","K","1","","" }
{ "20990","21042","28776","1439","","","","","","","Eri","","392.959","5.950","0.545","67.668043","-35.653504","K0II","K","1","","" }
{ "23207","23261","31761","1599","","5    Aur","","5","","","Aur","","194.837","5.950","2.069","75.076420","39.394701","F5V","F","1","","" }
{ "27187","27253","38529","1988","","","","","","","Ori","","128.105","5.950","2.979","86.645466","1.168193","G4V","G","1","","" }
{ "27644","27713","39421","2039","","","","","","","Ori","","322.608","5.950","0.974","88.032204","-9.041900","A2Vn","A","1","","" }
{ "82398","82650","152161","6257","","","","","","","Sco","","756.743","5.950","-0.878","253.426784","-43.050968","M3II/III","M","1","","" }
{ "82980","83235","153368","6311","","","","","","","Sco","","321.336","5.950","0.982","255.154119","-35.934133","K2IIICN...","K","1","","" }
{ "83968","84226","155450","6389","","","","","","","Sco","","1772.589","5.950","-2.726","258.243992","-32.438332","B1Ib","B","1","","" }
{ "84167","84425","155826","6398","","","","","","","Sco","","99.773","5.950","3.522","258.899911","-38.593896","G0V","G","1","","" }
{ "87603","87875","163624","6689","","","","","","","Oph","","386.441","5.950","0.582","269.267978","0.066665","A3V","A","1","","" }
{ "90326","90606","167714","6837","","","","","","","Oct","","388.281","5.950","0.571","277.333363","-80.232708","K2III","K","1","","" }
{ "93567","93862","177406","7223","","","","","","","Tel","","384.618","5.950","0.592","286.731678","-48.299144","A0V","A","1","","" }
{ "98150","98461","189195","7629","","","","","","","Sgr","","351.462","5.950","0.788","300.066374","-37.701719","G8/K0III","G","1","","" }
{ "100175","100501","194193","7800","","","","","","","Cyg","","844.965","5.950","-1.117","305.688732","41.026012","M0III","M","1","","" }
{ "103213","103545","199603","8024","","","","","","","Aqr","","284.356","5.950","1.248","314.674337","-14.483128","A9V","A","1","","" }
{ "28014","28085","40151","2086","","","","","","","Lep","","289.146","5.950","1.212","89.059437","-22.839975","K0/K1III","K","1","","" }
{ "31518","31599","47182","2428","","","","","","","CMa","","688.094","5.950","-0.671","99.194163","-13.321036","K4/K5III","K","1","","" }
{ "33642","33729","52312","2624","","","","","","","Mon","","1076.424","5.950","-1.643","105.098985","-8.406821","B9III","B","1","","" }
{ "34960","35054","56410","2759","","","","","","","Pup","","547.242","5.950","-0.174","108.738135","-41.426394","B4III/IV","B","1","","" }
{ "35034","35127","56207","2752","","","","","","","Mon","","395.341","5.950","0.532","108.930170","-10.583605","K0","K","1","","" }
{ "36243","36345","59499","2870","","","","","","","Pup","","744.649","5.950","-0.843","112.213137","-31.848401","B3V+...","B","1","","" }
{ "36393","36496","60228","2892","","","","","","","Car","","474.755","5.950","0.135","112.628808","-54.399365","M1III","M","1","","" }
{ "37371","37478","61887","2966","","","","","","","CMi","","454.890","5.950","0.228","115.396481","3.624779","A0V","A","1","","" }
{ "40578","40693","69830","3259","Gl 302","","","","","","Pup","","40.749","5.950","5.467","124.599763","-12.632173","K0V","K","1","","" }
{ "41205","41321","71863","3346","","","","","","","Vol","","366.468","5.950","0.697","126.465034","-64.600618","G8/K0III","G","1","","" }
{ "42028","42147","73072","3402","","","","","","","Pyx","","585.559","5.950","-0.321","128.869598","-26.843487","A1V+...","A","1","","" }
{ "43774","43899","76579","3564","","","","","","","Hya","","723.185","5.950","-0.779","134.142195","-16.708748","K3III","K","1","","" }
{ "44764","44892","78418","3626","GJ 9286","75    Cnc","","75","","","Cnc","","101.134","5.950","3.493","137.197249","26.629112","G5IV","G","1","","" }
{ "44769","44897","78366","3625","Gl 334.2","","","","","","Lyn","","62.590","5.950","4.535","137.212888","33.882217","F9V","F","1","","" }
{ "46726","46859","82660","3802","","","","","","","Hya","","739.584","5.950","-0.828","143.232393","-13.516804","K4III","K","1","","" }
{ "48055","48191","85206","3892","","","","","","","Ant","","404.661","5.950","0.482","147.367069","-37.186765","K2III","K","1","","" }
{ "48390","48527","85953","3924","","","","","","","Vel","","2296.876","5.950","-3.289","148.458763","-51.146713","B2V","B","1","","" }
{ "50177","50319","89010","4030","","35    Leo","","35","","","Leo","","101.670","5.950","3.481","154.134584","23.503095","G2IV","G","1","","" }
{ "52426","52577","92839","4195","","","","","","","UMa","","1240.138","5.950","-1.950","161.266771","67.411384","C5II","C","1","","" }
{ "52881","53035","94014","4240","","","","","","","Sex","","505.669","5.950","-0.002","162.772535","-3.092667","K2","K","1","","" }
{ "53179","53334","94683","4266","","","","","","","Car","","1443.170","5.950","-2.279","163.623334","-61.826622","K4III","K","1","","" }
{ "53893","54049","95849","4306","","62    Leo","","62","","","Leo","","606.239","5.950","-0.396","165.902467","-0.000833","K3III","K","1","","" }
{ "56304","56473","100600","4456","","90    Leo","","90","","","Leo","","1896.258","5.950","-2.872","173.677049","16.796915","B4V","B","1","","" }
{ "56800","56970","101541","4497","","","","","","","Cen","","1140.407","5.950","-1.768","175.177024","-53.968607","M1III","M","1","","" }
{ "58285","58460","104075","4581","","","","","","","UMa","","741.264","5.950","-0.833","179.823073","33.167004","K1III","K","1","","" }
{ "58746","58921","104933","4607","","","","","","","Cru","","683.766","5.950","-0.657","181.238464","-60.968252","M2III","M","1","","" }
{ "58873","59050","105151","4615","","","","","","","Mus","","410.776","5.950","0.449","181.596057","-65.709453","G8/K0III","G","1","","" }
{ "59104","59285","105639","4626","","10    Vir","","10","","","Vir","","238.244","5.950","1.632","182.422124","1.897889","K3III","K","1","","" }
{ "60409","60595","108107","4722","","","","","","","Vir","","230.012","5.950","1.708","186.299027","-11.610590","A1V","A","1","","" }
{ "62014","62207","110897","4845","Gl 484","10    CVn","","10","","","CVn","","56.674","5.950","4.750","191.247776","39.278916","G0V","G","1","","" }
{ "64021","64224","114287","4961","","50    Vir","","50","","","Vir","","693.950","5.950","-0.690","197.438665","-10.329327","K5III","K","1","","" }
{ "67794","68009","120213","5188","","","","","","","Cha","","801.367","5.950","-1.002","208.912393","-82.666190","K2/K3III:p","K","1","","" }
{ "76480","76716","139211","5803","","","","","","","Nor","","100.883","5.950","3.498","234.985895","-59.908338","F6V","F","1","","" }
{ "76641","76877","138867","5786","","","","","","","Aps","","421.391","5.950","0.394","235.477911","-76.081959","B9V","B","1","","" }
{ "77703","77939","142378","5915","","47    Lib","","47","","","Lib","","771.055","5.950","-0.918","238.751517","-19.382926","B2/B3V","B","1","","" }
{ "79555","79797","145689","6037","","","","","","","TrA","","170.317","5.950","2.361","244.272733","-67.941285","A4V","A","1","","" }
{ "110698","111045","213135","8563","","","","","","","PsA","","130.046","5.950","2.947","337.441710","-27.107284","F0V","F","1","","" }
{ "116002","116368","221745","8946","","","","","","","Aqr","","371.476","5.950","0.667","353.705665","-15.246005","K4III","K","1","","" }
{ "116348","116714","222386","8971","","","","","","","Cep","","258.035","5.950","1.459","354.792349","75.292882","A3V","A","1","","" }
{ "116898","117265","223128","9005","","","","","","","Cep","","1489.299","5.950","-2.348","356.653039","66.782244","B2IV","B","1","","" }
{ "117133","117500","223461","9025","","79    Peg","","79","","","Peg","","288.124","5.950","1.219","357.414121","28.842389","A2m","A","1","","" }
{ "117724","118092","224361","9060","","","","","","","Tuc","","215.427","5.950","1.851","359.332626","-62.956584","A2p","A","1","","" }
{ "109833","110179","211676","8508","","45    Aqr","","45","","","Aqr","","369.792","5.960","0.687","334.753078","-13.304995","K0III","K","1","","" }
{ "114781","115144","219879","8869","","","","","","","Aqr","","1393.831","5.960","-2.194","349.850449","-18.075376","K2/K3III","K","1","","" }
{ "119003","","","","Gl 575B","","","","","","Boo","","41.607","5.960","5.431","225.948668","47.653692","dG2","G","2","73467","Gl 575" }
{ "119020","","137108","5728","Gl 584B","2Eta CrB","Eta","2","Eta","","CrB","","60.737","5.960","4.610","230.799450","30.286200","G2 V","G","2","75083","Gl 584" }
{ "27678","27747","39286","2030","","","","","","","Ori","","1120.812","5.960","-1.721","88.097524","19.867849","B9V + G","B","1","","" }
{ "33516","33603","51814","2610","","","","","","","Mon","","838.448","5.960","-1.090","104.737603","3.602355","G8III","G","1","","" }
{ "33841","33929","52554","2631","","","","","","","Gem","","805.324","5.960","-1.003","105.606391","17.755521","M1.5","M","1","","" }
{ "33913","34002","52913","2647","","","","","","","Mon","","332.473","5.960","0.918","105.824648","9.138355","A3Vs","A","1","","" }
{ "34259","34349","54732","2698","","","","","","","Car","","544.501","5.960","-0.153","106.805392","-51.968283","K0III","K","1","","" }
{ "34991","35084","56705","2767","","","","","","","Car","","417.614","5.960","0.423","108.838512","-52.499226","K0V","K","1","","" }
{ "39416","39527","67249","3178","","","","","","","Vel","","1186.023","5.960","-1.843","121.176677","-50.590396","G5II","G","1","","" }
{ "39547","39659","66875","3169","","9Mu 1Cnc","Mu-1","9","Mu","1","Cnc","","744.649","5.960","-0.833","121.576646","22.635490","M3III","M","1","","" }
{ "40817","40932","70839","3293","","","","","","","Car","","1772.589","5.960","-2.716","125.300417","-57.973220","B1.5III","B","1","","" }
{ "41212","41328","71267","3320","","","","","","","Pup","","361.994","5.960","0.734","126.481626","-14.929661","A3m...","A","1","","" }
{ "42246","42365","73192","3409","","","","","","","Cnc","","406.679","5.960","0.481","129.579099","32.802021","K2III:","K","1","","" }
{ "43430","43553","75523","3509","","","","","","","Lyn","","537.325","5.960","-0.124","133.049046","45.312819","K0III","K","1","","" }
{ "43464","43587","75732","3522","Gl 324A","55Rho1Cnc","Rho-1","55","Rho","1","Cnc","Copernicus","40.251","5.960","5.503","133.149374","28.330819","G8V","G","1","","Gl 324" }
{ "45460","45590","79763","3676","","","","","","","UMa","","425.236","5.960","0.384","139.379891","46.817228","A1V","A","1","","" }
{ "47091","47224","83441","3835","","","","","","","Ant","","359.203","5.960","0.750","144.368351","-36.095994","K2III","K","1","","" }
{ "47267","47401","83126","3824","","","","","","","UMa","","502.552","5.960","0.021","144.866252","67.272230","K5","K","1","","" }
{ "51977","52127","92436","4179","","","","","","","Car","","682.335","5.960","-0.643","159.748584","-58.816854","M1III","M","1","","" }
{ "1702","1706","1801","87","","","","","","","Hyi","","570.204","5.960","-0.253","5.369796","-77.426873","K3III","K","1","","" }
{ "8581","8598","11151","529","","","","","","","Per","","135.955","5.960","2.860","27.737969","51.933417","F5V","F","1","","" }
{ "9609","9631","12641","610","","61    Cet","","61","","","Cet","","361.994","5.960","0.734","30.950714","-0.340251","G5V...","G","1","","" }
{ "10272","10296","13522","644","","","","","","","Ari","","746.353","5.960","-0.838","33.156402","24.167778","K0","K","1","","" }
{ "15929","15968","21722","1064","","","","","","","Hyi","","128.509","5.960","2.982","51.401055","-69.336436","F3V","F","1","","" }
{ "22308","22361","29678","1491","","","","","","","Cam","","153.485","5.960","2.597","72.209521","75.941219","A9IV","A","1","","" }
{ "24726","24786","34721","1747","Gl 198","","","","","","Lep","","81.621","5.960","3.968","79.710252","-18.130050","G0V","G","1","","" }
{ "26470","26535","37481","1933","","","","","","","Ori","","1342.207","5.960","-2.112","84.658220","-6.573959","B1.5IV","B","1","","" }
{ "27491","27560","39051","2019","","","","","","","Ori","","581.384","5.960","-0.295","87.554437","4.423406","K2III","K","1","","" }
{ "89162","89440","167263","6823","","16    Sgr","","16","","","Sgr","","326156.378","5.960","-14.040","273.804045","-20.387974","B0.5Ib/II","B","1","","" }
{ "89170","89448","168653","6865","","37    Dra","","37","","","Dra","","276.170","5.960","1.321","273.821079","68.755810","K1III:","K","1","","" }
{ "93244","93537","176884","7203","","","","","","","Sgr","","1976.705","5.960","-2.953","285.765854","-19.245686","K0II/III","K","1","","" }
{ "99932","100256","193472","7774","","","","","","","Del","","261.973","5.960","1.436","305.000790","13.548091","A5m","A","1","","" }
{ "100758","101082","196925","7908","","74    Dra","","74","","","Dra","","207.875","5.960","1.938","307.363970","81.091277","K0III+...","K","1","","" }
{ "103039","103371","199579","8023","","","","","","","Cyg","","326156.378","5.960","-14.040","314.144908","44.924722","O6...","O","1","","" }
{ "106300","106642","205730","8262","","","","","","","Cyg","","570.204","5.960","-0.253","324.010332","45.374591","M4IIIe-M6e","M","1","","" }
{ "106959","107302","206677","8302","","45    Cap","","45","","","Cap","","172.844","5.960","2.339","326.004023","-14.749370","A7IV/V","A","1","","" }
{ "107007","107350","206860","8314","Gl 836.7","","","","","","Peg","","58.336","5.960","4.697","326.130521","14.771939","G0V","G","1","","" }
{ "108160","108505","209112","8388","","","","","","","Cep","","926.581","5.960","-1.307","329.722979","62.697986","M3III","M","1","","" }
{ "56283","56452","100623","4458","Gl 432A","","","","","","Hya","","31.178","5.960","6.058","173.623172","-32.831340","K0V","K","1","","Gl 432" }
{ "60967","61158","109000","4771","","","","","","","Cru","","245.046","5.960","1.581","187.983900","-63.505838","A8III","A","1","","" }
{ "66218","66427","118338","5118","","","","","","","Cen","","414.957","5.960","0.437","204.275092","-44.143203","G8/K0III","G","1","","" }
{ "66712","66924","119250","5155","","","","","","","Cen","","359.996","5.960","0.746","205.729302","-41.401043","K0III","K","1","","" }
{ "66772","66984","119361","5157","","","","","","","Cen","","2000.959","5.960","-2.979","205.917033","-42.067521","B8III","B","1","","" }
{ "68238","68455","121932","5253","","","","","","","Cir","","248.216","5.960","1.553","210.218945","-66.268910","F0V","F","1","","" }
{ "68954","69174","123515","5296","","","","","","","Cen","","819.488","5.960","-1.041","212.396014","-51.504672","B9IV","B","1","","" }
{ "70670","70894","127167","5418","","","","","","","Vir","","258.649","5.960","1.464","217.460494","0.828929","A5IV","A","1","","" }
{ "74468","74696","135235","5663","","","","","","","Lup","","162.671","5.960","2.471","228.973601","-48.073661","A3m","A","1","","" }
{ "81716","81966","150576","6207","","","","","","","Ara","","728.028","5.960","-0.784","251.165614","-53.152313","G8III","G","1","","" }
{ "63330","63533","113095","4929","","38    Com","","38","","","Com","","406.679","5.970","0.491","195.290062","17.123147","K0III","K","1","","" }
{ "65340","65545","116831","5059","","","","","","","Vir","","255.408","5.970","1.501","201.547558","-1.192471","A7III","A","1","","" }
{ "67027","67239","120064","5182","","3    Boo","","3","","","Boo","","292.517","5.970","1.206","206.680517","25.702236","F6IV-V","F","1","","" }
{ "67272","67485","120787","5213","","","","","","","UMa","","410.260","5.970","0.472","207.439437","61.489313","G3V","G","1","","" }
{ "73709","73937","133652","5619","","","","","","","Lup","","395.821","5.970","0.550","226.638331","-30.918483","Ap Si","A","1","","" }
{ "76079","76311","139357","5811","","","","","","","Dra","","385.073","5.970","0.609","233.817527","53.922144","K4III:","K","1","","" }
{ "79696","79938","146850","6078","","","","","","","Sco","","1062.399","5.970","-1.594","244.751752","-14.872825","K3IIICNpvar","K","1","","" }
{ "4562","4572","5550","273","","","","","","","Cas","","350.329","5.970","0.815","14.629268","66.351793","A0III","A","1","","" }
{ "5498","5510","7014","347","","33    Cet","","33","","","Cet","","767.427","5.970","-0.888","17.639801","2.445670","K4III","K","1","","" }
{ "5766","5778","7374","364","","87    Psc","","87","","","Psc","","454.890","5.970","0.248","18.531793","16.133479","B8III","B","1","","" }
{ "6478","6492","8388","397","","","","","","","Psc","","1000.480","5.970","-1.464","20.853955","20.468967","K5","K","1","","" }
{ "7891","7906","10348","485","","","","","","","Tri","","514.442","5.970","-0.020","25.413489","30.047120","K0III","K","1","","" }
{ "9513","9533","12479","601","","","","","","","Ari","","672.487","5.970","-0.601","30.646157","13.476716","M2III","M","1","","" }
{ "13645","13679","18262","870","","","","","","","Cet","","140.162","5.970","2.804","44.057372","8.381563","F7IV","F","1","","" }
{ "14728","14764","19698","948","","","","","","","Ari","","444.961","5.970","0.296","47.661638","11.872627","B8V","B","1","","" }
{ "15296","15334","20346","986","","","","","","","Per","","500.240","5.970","0.041","49.440626","39.283373","A2IV","A","1","","" }
{ "16986","17027","22713","1111","","21    Eri","","21","","","Eri","","109.928","5.970","3.332","54.754657","-5.626210","K1V","K","1","","" }
{ "18127","18170","24357","1201","","","","","","","Tau","","134.775","5.970","2.889","58.291843","17.327083","F4V","F","1","","" }
{ "20562","20614","27901","1385","","","","","","","Tau","","164.809","5.970","2.452","66.238018","19.042013","F4V","F","1","","" }
{ "21794","21847","29645","1489","","","","","","","Per","","103.938","5.970","3.453","70.459241","38.280182","G0V","G","1","","" }
{ "22644","22697","30912","1554","","","","","","","Tau","","346.975","5.970","0.836","73.196306","27.897485","F2IV","F","1","","" }
{ "23776","23831","33093","1665","","","","","","","Lep","","119.690","5.970","3.147","76.854006","-12.491269","G2V","G","1","","" }
{ "26321","26386","37171","1908","","","","","","","Ori","","821.553","5.970","-1.036","84.268258","11.035005","K4II SB","K","1","","" }
{ "26860","26926","38089","1967","","","","","","","Ori","","162.915","5.970","2.477","85.724645","-6.796168","F3V","F","1","","" }
{ "27367","27435","38858","2007","GJ 1085","","","","","","Ori","","49.500","5.970","5.064","87.145586","-4.094648","G4V","G","1","","" }
{ "27519","27588","39118","2024","","","","","","","Ori","","1032.140","5.970","-1.532","87.625107","2.024700","G8III+...","G","1","","" }
{ "111165","111515","213986","8596","","","","","","","Aqr","","303.119","5.970","1.129","338.901559","-23.991094","K1III","K","1","","" }
{ "113441","113801","217703","8764","","","","","","","Aqr","","239.645","5.970","1.639","345.684391","-20.870712","K0III","K","1","","" }
{ "113828","114189","218396","8799","","","","","","","Peg","","128.509","5.970","2.992","346.869626","21.134251","A5V","A","1","","" }
{ "28040","28110","39985","2075","","","","","","","Ori","","391.544","5.970","0.573","89.116816","9.509396","A0IV","A","1","","" }
{ "29698","29771","43544","2249","","","","","","","CMa","","778.416","5.970","-0.919","94.032046","-16.618006","B2/B3V","B","1","","" }
{ "41133","41250","71302","3322","","","","","","","Pup","","1792.068","5.970","-2.730","126.238369","-42.769834","B3V","B","1","","" }
{ "48663","48802","85945","3922","","","","","","","UMa","","474.755","5.970","0.155","149.306636","57.418196","G8III","G","1","","" }
{ "50338","50480","89461","4056","","","","","","","Vel","","532.066","5.970","-0.093","154.617706","-41.668490","B9V","B","1","","" }
{ "52189","52340","93237","4206","","","","","","","Cha","","926.581","5.970","-1.297","160.464858","-79.783288","B5IV","B","1","","" }
{ "84398","84656","156891","6444","","","","","","","Her","","316.657","5.970","1.034","259.596970","38.811395","G7III:","G","1","","" }
{ "86309","86575","160781","6590","","","","","","","Oph","","1128.569","5.970","-1.726","265.384679","6.313156","G7III","G","1","","" }
{ "86604","86871","160720","6586","","","","","","","Pav","","410.776","5.970","0.469","266.232727","-57.545540","G8III","G","1","","" }
{ "88770","89047","167042","6817","","","","","","","Dra","","163.815","5.970","2.465","272.631647","54.286552","K1III","K","1","","" }
{ "96453","96760","185467","7473","","","","","","","Sgr","","358.414","5.970","0.765","295.029851","-23.429086","K0III","K","1","","" }
{ "98855","99171","191067","7690","","64    Aql","","64","","","Aql","","153.125","5.970","2.612","302.007595","-0.678185","K1IV","K","1","","" }
{ "101657","101986","197139","7919","","","","","","","Cyg","","448.633","5.970","0.278","310.013230","43.458878","K2III","K","1","","" }
{ "104414","104752","201852","8108","","","","","","","Mic","","365.646","5.970","0.722","318.328988","-36.423527","K0III","K","1","","" }
{ "104886","105224","202951","8149","","","","","","","Equ","","942.648","5.970","-1.335","319.716773","11.203373","K5III","K","1","","" }
{ "105386","105727","205072","8239","","","","","","","Cep","","362.396","5.970","0.741","321.205940","80.524826","G6III:","G","1","","" }
{ "105998","106340","204854","8230","","6    PsA","","6","","","PsA","","503.328","5.970","0.028","323.060715","-33.944623","A2V","A","1","","" }
{ "108629","108975","209522","8408","","","","","","","PsA","","1230.779","5.970","-1.914","331.153192","-26.822359","B3V (+B)","B","1","","" }
{ "109256","109602","210762","8466","","","","","","","Peg","","326156.378","5.970","-14.030","333.033722","24.950641","K0","K","1","","" }
{ "82961","83216","153221","6300","","","","","","","Ara","","348.458","5.980","0.836","255.112355","-48.647759","G5IV","G","1","","" }
{ "83436","83693","154310","6344","","","","","","","Sco","","463.949","5.980","0.215","256.584127","-37.227590","A2IV","A","1","","" }
{ "83597","83854","154779","6365","","","","","","","Oph","","374.892","5.980","0.678","257.061895","-17.609052","K0III","K","1","","" }
{ "84144","84402","155970","6404","","","","","","","Oph","","291.471","5.980","1.224","258.834518","-14.584140","K1III","K","1","","" }
{ "85183","85442","157955","6494","","","","","","","Oph","","737.910","5.980","-0.793","261.906468","-29.724567","B9.5IV","B","1","","" }
{ "85284","85543","158105","6501","","","","","","","Sco","","799.403","5.980","-0.967","262.233698","-36.778280","K0III","K","1","","" }
{ "88276","88550","164870","6739","","","","","","","Sgr","","344.410","5.980","0.862","271.209923","-35.901442","K2III","K","1","","" }
{ "88879","89156","166988","6814","","","","","","","Her","","774.718","5.980","-0.899","272.937997","33.447057","A3V","A","1","","" }
{ "92994","93287","175401","7130","","","","","","","Pav","","443.750","5.980","0.311","285.014806","-66.653618","K0III","K","1","","" }
{ "95700","95999","182709","7383","","","","","","","Pav","","1264.172","5.980","-1.962","292.795637","-68.433920","K4/K5III","K","1","","" }
{ "96179","96481","185018","7456","","","","","","","Aql","","1212.477","5.980","-1.871","294.218551","11.273206","G0Ib","G","1","","" }
{ "96533","96840","185936","7486","","","","","","","Aql","","326156.378","5.980","-14.020","295.273034","13.815682","B5V","B","1","","" }
{ "103320","103652","199942","8038","","","","","","","Equ","","247.275","5.980","1.581","315.016591","7.516197","A7V","A","1","","" }
{ "106786","107129","206570","8297","","","","","","","Cyg","","2038.477","5.980","-2.999","325.504513","35.510200","C6.3","C","1","","" }
{ "109120","109466","210434","8453","","","","","","","Aqr","","332.473","5.980","0.938","332.640609","-4.266855","K0III-IV","K","1","","" }
{ "111614","111967","214632","8620","","","","","","","Tuc","","851.583","5.980","-1.104","340.203707","-57.422322","K4III","K","1","","" }
{ "114703","115065","219815","8864","","9    And","","9","","","And","","422.482","5.980","0.418","349.597192","41.773676","A7m","A","1","","" }
{ "116362","116728","222387","8972","","","","","","","Cep","","327.466","5.980","0.971","354.838176","74.002628","G8III","G","1","","" }
{ "119620","","45291","2322","","","","","","","Car","","326156.378","5.980","-14.020","95.907083","-52.181111","G8III","G","1","","" }
{ "119626","","124953","5343","","","","","","","Boo","","326156.378","5.980","-14.020","214.017500","18.911945","A8III","A","1","","" }
{ "56993","57165","101883","4508","","","","","","","Cen","","849.366","5.980","-1.098","175.863292","-37.190155","K3III","K","1","","" }
{ "63830","64033","113823","4944","","","","","","","Cen","","554.688","5.980","-0.173","196.851263","-59.860510","B9IV+...","B","1","","" }
{ "66695","66907","119458","5161","","","","","","","CVn","","478.937","5.980","0.146","205.680952","34.989021","G5III","G","1","","" }
{ "68280","68498","122365","5262","","","","","","","Boo","","270.221","5.980","1.389","210.335120","8.894906","A2V","A","1","","" }
{ "73996","74224","134255","5636","","","","","","","Lup","","428.589","5.980","0.387","227.530537","-38.792511","G6III","G","1","","" }
{ "74333","74561","135438","5674","","","","","","","Boo","","662.919","5.980","-0.560","228.525163","31.787845","K5","K","1","","" }
{ "77176","77412","141353","5874","","","","","","","Ser","","472.006","5.980","0.177","237.055444","13.789078","K2III","K","1","","" }
{ "517","518","123","5","Gl 4.1A","","","","","","Cas","","70.051","5.980","4.320","1.565345","58.436733","G5V","G","1","","Gl 4.1" }
{ "3689","3697","4526","216","","60    Psc","","60","","","Psc","","460.673","5.980","0.230","11.848466","6.740956","G8III","G","1","","" }
{ "6697","6711","8671","409","","","","","","","And","","136.069","5.980","2.878","21.577759","43.457739","F7V","F","1","","" }
{ "7725","7740","10164","475","","105    Psc","","105","","","Psc","","392.015","5.980","0.581","24.920067","16.405858","K2III","K","1","","" }
{ "12529","12562","16825","796","","","","","","","Cet","","153.993","5.980","2.610","40.392205","-14.549276","F5V","F","1","","" }
{ "15203","15241","20277","978","","","","","","","Per","","438.972","5.980","0.335","49.146624","32.184018","G8IV","G","1","","" }
{ "16298","16339","21981","1081","","","","","","","Hor","","392.486","5.980","0.578","52.653900","-47.375125","A2V","A","1","","" }
{ "16558","16599","21819","1073","","","","","","","Cam","","242.676","5.980","1.622","53.412824","54.974857","A3V","A","1","","" }
{ "21933","21986","30020","1505","","55    Eri","","55","","","Eri","","2131.741","5.980","-3.097","70.894769","-8.794317","F4IIIp (Sr)","F","1","","" }
{ "22787","22840","31331","1574","","","","","","","Ori","","724.792","5.980","-0.754","73.711284","0.467167","B5V","B","1","","" }
{ "24771","24831","34868","1758","","","","","","","Col","","437.207","5.980","0.344","79.848688","-27.368884","A0V","A","1","","" }
{ "26541","26606","37367","1924","","","","","","","Aur","","1058.949","5.980","-1.577","84.826300","29.215213","B2IV-V","B","1","","" }
{ "28491","28562","40486","2105","","","","","","","Aur","","789.725","5.980","-0.940","90.429403","48.959445","K0","K","1","","" }
{ "35955","36055","58526","2833","","","","","","","Mon","","1212.477","5.980","-1.871","111.463334","-5.774961","CIb...","C","1","","" }
{ "36134","36236","59136","2860","","","","","","","Pup","","964.960","5.980","-1.375","111.928907","-22.859199","B5III","B","1","","" }
{ "38904","39014","65904","3137","","","","","","","Pup","","982.399","5.980","-1.414","119.757520","-45.215844","B4V","B","1","","" }
{ "41556","41674","72232","3363","","","","","","","Vel","","576.248","5.980","-0.256","127.440164","-46.331693","B7IV","B","1","","" }
{ "43427","43550","75556","3511","","","","","","","Lyn","","526.909","5.980","-0.062","133.041798","42.002735","K0III","K","1","","" }
{ "45281","45412","79452","3664","","","","","","","Lyn","","424.130","5.980","0.410","138.809443","34.633516","G6III","G","1","","" }
{ "49703","49844","88399","4001","","","","","","","Vel","","226.497","5.980","1.772","152.657134","-41.715247","K3III","K","1","","" }
{ "51474","51623","91533","4144","","","","","","","Car","","326156.378","5.980","-14.020","158.199219","-58.666745","A2Iab","A","1","","" }
{ "52673","52827","93737","4228","","","","","","","Car","","326156.378","5.980","-14.020","162.022548","-59.919163","A0Ia","A","1","","" }
{ "27870","27939","39775","2057","","","","","","","Ori","","874.414","5.990","-1.151","88.683486","0.968615","K0III","K","1","","" }
{ "29619","29692","43429","2243","","","","","","","CMa","","203.975","5.990","2.009","93.823842","-18.477163","K1III","K","1","","" }
{ "29638","29711","43319","2234","","","","","","","Mon","","212.203","5.990","1.923","93.873638","-4.914719","A5IVs","A","1","","" }
{ "31793","31876","47575","2449","","","","","","","Gem","","257.221","5.990","1.506","99.948819","12.982768","A2V","A","1","","" }
{ "34820","34914","55762","2730","","","","","","","CMa","","799.403","5.990","-0.957","108.350100","-22.674241","K4III","K","1","","" }
{ "35614","35712","57608","2801","","","","","","","CMi","","1630.782","5.990","-2.505","110.514494","0.177121","B8III","B","1","","" }
{ "37239","37345","61925","2968","","","","","","","Pup","","1399.813","5.990","-2.173","114.991629","-37.579422","B4III","B","1","","" }
{ "39124","39236","65873","3134","","5    Cnc","","5","","","Cnc","","539.994","5.990","-0.105","120.376201","16.455309","B9.5Vn","B","1","","" }
{ "45969","46101","81613","3742","","","","","","","Car","","361.994","5.990","0.764","141.022897","-61.648902","K0III","K","1","","" }
{ "47424","47559","84228","3868","","","","","","","Vel","","1874.462","5.990","-2.807","145.449720","-55.213762","B4V","B","1","","" }
{ "53118","53272","94650","4262","","","","","","","Car","","760.271","5.990","-0.848","163.425467","-70.720337","B6V","B","1","","" }
{ "53570","53726","95129","4278","","","","","","","UMa","","827.808","5.990","-1.033","164.886575","36.093100","M2III","M","1","","" }
{ "55116","55280","98560","4384","","","","","","","Car","","119.647","5.990","3.168","169.819449","-64.582491","F6IV","F","1","","" }
{ "61865","62058","110506","4834","","","","","","","Cru","","381.916","5.990","0.647","190.788308","-56.176224","B9Vn","B","1","","" }
{ "62589","62786","111774","4879","","","","","","","Cen","","465.938","5.990","0.215","192.987226","-39.680431","B7/B8V","B","1","","" }
{ "63291","63494","112992","4925","","46    Vir","","46","","","Vir","","327.138","5.990","0.983","195.149780","-3.368488","K2III","K","1","","" }
{ "70140","70363","125869","5380","","","","","","","Lup","","368.538","5.990","0.725","215.952517","-53.176233","K1III","K","1","","" }
{ "70762","70987","127193","5419","","","","","","","Cen","","315.127","5.990","1.065","217.795163","-38.869708","K1III","K","1","","" }
{ "75027","75256","137389","5731","","","","","","","Dra","","446.790","5.990","0.307","230.655214","62.047076","A0sp...","A","1","","" }
{ "81604","81854","152303","6267","","","","","","","UMi","","117.746","5.990","3.202","250.775707","77.513973","F4V","F","1","","" }
{ "81742","81992","150894","6218","","","","","","","Sco","","707.497","5.990","-0.691","251.250799","-28.509657","A3IV","A","1","","" }
{ "82360","82611","152812","6286","","","","","","","Her","","656.250","5.990","-0.528","253.323201","47.416725","K2III","K","1","","" }
{ "82554","82806","152082","6253","","","","","","","Ara","","469.966","5.990","0.197","253.852845","-63.269659","A0III","A","1","","" }
{ "84173","84431","156284","6419","","","","","","","Her","","565.262","5.990","-0.204","258.922800","23.742761","K2III","K","1","","" }
{ "85491","85751","158220","6505","","","","","","","Ara","","1832.339","5.990","-2.758","262.847015","-56.920964","B7II/III","B","1","","" }
{ "87740","88012","163685","6692","","","","","","","Sgr","","1811.980","5.990","-2.734","269.662707","-28.759089","B3II/III","B","1","","" }
{ "89309","89587","167768","6840","","","","","","","Ser","","337.287","5.990","0.917","274.221255","-3.007401","G3III","G","1","","" }
{ "89774","90052","169111","6883","","","","","","","Oph","","439.564","5.990","0.342","275.647160","12.029680","A2V","A","1","","" }
{ "92103","92391","174208","7083","","","","","","","Sct","","1744.152","5.990","-2.651","282.420646","-5.912863","K2Ib","K","1","","" }
{ "92543","92833","175635","7140","","","","","","","Lyr","","1169.019","5.990","-1.782","283.718823","33.968576","G8III+...","G","1","","" }
{ "96588","96895","186408","7503","Gl 765.1A","16    Cyg","","16","","","Cyg","","68.751","5.990","4.371","295.454178","50.525060","G2V","G","1","","Gl 765.1" }
{ "98425","98738","190211","7662","","","","","","","Sge","","809.321","5.990","-0.983","300.818330","18.500993","K3Iab:","K","1","","" }
{ "101580","101909","196775","7899","","","","","","","Del","","1347.753","5.990","-2.091","309.770696","15.838199","B3V","B","1","","" }
{ "101831","102162","196051","7863","","Mu 1Oct","Mu-1","","Mu","1","Oct","","329.784","5.990","0.966","310.510968","-76.180592","F4III-IV","F","1","","" }
{ "102614","102945","198571","7982","","4    Aqr","","4","","","Aqr","","198.031","5.990","2.073","312.857283","-5.626633","F5IV-V","F","1","","" }
{ "102887","103219","200039","8043","","","","","","","Cep","","405.667","5.990","0.516","313.684556","75.925570","G5III","G","1","","" }
{ "105233","105574","203525","8175","","17    Aqr","","17","","","Aqr","","731.292","5.990","-0.763","320.734397","-9.319330","M0III","M","1","","" }
{ "111763","112117","214953","8635","Gl 871A","","","","","","Gru","","77.087","5.990","4.122","340.653670","-47.210813","G0","G","1","","Gl 871" }
{ "112502","112862","216210","8693","","21    PsA","","21","","","PsA","","322.608","5.990","1.014","342.837249","-29.536309","G8/K0III","G","1","","" }
{ "115441","115806","220933","8915","","69    Peg","","69","","","Peg","","360.793","5.990","0.771","351.918270","25.167281","A0MNp...","A","1","","" }
{ "116287","116653","222060","8957","","","","","","","Oct","","527.761","5.990","-0.055","354.598895","-76.869552","K0II/III","K","1","","" }
{ "116402","116768","222377","8970","","","","","","","Peg","","177.452","5.990","2.312","354.979331","9.677294","A2m","A","1","","" }
{ "670","671","360","16","","","","","","","Cet","","321.020","5.990","1.024","2.073053","-8.824112","G8III:","G","1","","" }
{ "2153","2159","2363","102","","","","","","","Scl","","574.219","5.990","-0.238","6.811277","-25.547170","K0III","K","1","","" }
{ "3345","3352","4088","186","","","","","","","Tuc","","230.989","5.990","1.739","10.674140","-60.262807","K5III","K","1","","" }
{ "4542","4552","5608","275","","","","","","","And","","183.854","5.990","2.235","14.559229","33.950885","K0","K","1","","" }
{ "4988","4998","6211","298","","","","","","","Cas","","1065.871","5.990","-1.581","16.009954","52.502161","K2","K","1","","" }
{ "10703","10729","13994","662","","7    Per","","7","","","Per","","819.488","5.990","-1.011","34.519132","57.516321","G7III","G","1","","" }
{ "11069","11095","15248","715","","Kap Hyi","Kap","","Kap","","Hyi","","317.273","5.990","1.050","35.718444","-73.645792","K0III","K","1","","" }
{ "12575","12608","16975","805","","","","","","","For","","412.334","5.990","0.481","40.527515","-38.383686","G8III","G","1","","" }
{ "18294","18339","24712","1217","","","","","","","Eri","","160.510","5.990","2.530","58.817204","-12.099105","Ap SrEu(Cr)","A","1","","" }
{ "22123","22176","30197","1517","","","","","","","Tau","","261.553","5.990","1.469","71.570110","18.734693","K4III","K","1","","" }
{ "22167","22220","30138","1514","","","","","","","Per","","433.143","5.990","0.374","71.685321","40.312590","G9III","G","1","","" }
{ "24516","24575","34078","1712","","","","","","","Aur","","1874.462","5.990","-2.807","79.075625","34.312317","O9.5Vvar","O","1","","" }
{ "25124","25187","35281","1778","","","","","","","Ori","","400.192","5.990","0.546","80.827126","-8.415595","B8+...","B","1","","" }
{ "25752","25816","36040","1824","","","","","","","Aur","","420.305","5.990","0.439","82.702711","41.461994","K0IIIp","K","1","","" }
{ "26559","26624","37594","1940","","","","","","","Ori","","138.849","5.990","2.844","84.879795","-3.564704","A8Vs","A","1","","" }
{ "3130","3137","3750","171","","","","","","","Phe","","307.115","6.000","1.131","9.966415","-44.796293","K1IIICN...","K","1","","" }
{ "9544","9564","12279","586","","52    Cas","","52","","","Cas","","273.621","6.000","1.381","30.718693","64.901466","A1Vn","A","1","","" }
{ "10192","10215","13456","638","","","","","","","Cet","","155.239","6.000","2.612","32.842611","-10.052162","F5V","F","1","","" }
{ "11660","11687","15633","732","","","","","","","Cet","","281.412","6.000","1.320","37.688346","0.255749","A7III-IVs","A","1","","" }
{ "11814","11843","15814","741","GJ 3161","29    Ari","","29","","","Ari","","97.652","6.000","3.619","38.225587","15.034554","F8V","F","1","","" }
{ "20025","20075","27362","1345","","","","","","","Eri","","1509.983","6.000","-2.328","64.566987","-20.715260","M4III","M","1","","" }
{ "20441","20493","27742","1375","","","","","","","Tau","","554.688","6.000","-0.153","65.884859","20.982044","B8IV-V","B","1","","" }
{ "23709","23766","32356","1624","","","","","","","Cam","","469.290","6.000","0.210","76.623669","61.169756","K5II","K","1","","" }
{ "27198","27265","38478","1985","","129    Tau","","129","","","Tau","","734.586","6.000","-0.763","86.689569","15.822497","B8IIIMNp...","B","1","","" }
{ "83344","83601","154417","6349","Gl 654.1","","","","","","Oph","","67.402","6.000","4.424","256.320080","0.702559","F9V","F","1","","" }
{ "84373","84631","156653","6432","","","","","","","Her","","455.526","6.000","0.275","259.520580","17.317886","A1V","A","1","","" }
{ "86294","86561","161193","6607","","","","","","","Dra","","303.119","6.000","1.159","265.340785","51.818182","K0III:","K","1","","" }
{ "87345","87616","162724","6662","","","","","","","Sco","","1028.884","6.000","-1.495","268.478221","-34.752721","B9IV/V","B","1","","" }
{ "91242","91525","172883","7028","","","","","","","Dra","","539.994","6.000","-0.095","279.970051","52.196075","A0p...","A","1","","" }
{ "93560","93855","177817","7239","","","","","","","Sgr","","844.965","6.000","-1.067","286.717154","-16.229276","B7V","B","1","","" }
{ "95896","96198","184786","7442","","","","","","","Cyg","","1325.839","6.000","-2.045","293.423357","49.262319","M4.5III","M","1","","" }
{ "97093","97402","187193","7540","","","","","","","Vul","","413.904","6.000","0.483","296.952236","25.384058","K0II-III","K","1","","" }
{ "97189","97499","187195","7541","","","","","","","Aql","","314.519","6.000","1.079","297.259181","-10.870763","K5III","K","1","","" }
{ "104742","105080","202987","8150","","","","","","","Cep","","1203.529","6.000","-1.835","319.309330","55.798001","K3III","K","1","","" }
{ "107144","107487","207005","8318","","47    Cap","","47","","","Cap","","1186.023","6.000","-1.803","326.567786","-9.275935","M3III","M","1","","" }
{ "108267","108612","209008","8385","","18    Peg","","18","","","Peg","","1072.883","6.000","-1.586","330.033031","6.717437","B3III","B","1","","" }
{ "29735","29808","43847","2262","","","","","","","Col","","402.166","6.000","0.545","94.148293","-39.264394","A2Vm...","A","1","","" }
{ "30245","30318","44497","2287","","","","","","","Ori","","227.763","6.000","1.780","95.651637","12.570237","F0III","F","1","","" }
{ "34094","34182","53257","2659","","44    Gem","","44","","","Gem","","401.176","6.000","0.550","106.326541","22.637458","B8Vn","B","1","","" }
{ "34471","34561","54764","2699","","","","","","","CMa","","2233.948","6.000","-3.178","107.389020","-16.234509","B1Ib/II","B","1","","" }
{ "35513","35611","57593","2800","","","","","","","CMa","","2489.743","6.000","-3.414","110.228817","-26.963838","B3V","B","1","","" }
{ "40070","40183","68895","3234","","","","","","","Vel","","1045.373","6.000","-1.529","123.128306","-46.264285","B5V","B","1","","" }
{ "40774","40889","68951","3236","","","","","","","UMa","","811.334","6.000","-0.979","125.167988","72.407232","M0III","M","1","","" }
{ "43269","43392","75759","3525","","","","","","","Vel","","2508.895","6.000","-3.430","132.587573","-42.089791","O9V","O","1","","" }
{ "50404","50546","89319","4046","","","","","","","UMa","","144.830","6.000","2.763","154.861748","48.396762","K0","K","1","","" }
{ "51049","51194","90874","4115","","","","","","","Car","","223.242","6.000","1.823","156.855632","-65.704664","A2V","A","1","","" }
{ "51055","51200","90470","4096","","","","","","","UMa","","215.569","6.000","1.899","156.866877","41.601035","A2V","A","1","","" }
{ "59202","59384","105943","4639","","","","","","","Cam","","1098.170","6.000","-1.636","182.750311","81.709832","K5III:","K","1","","" }
{ "60790","60979","108759","4755","","","","","","","Cen","","737.910","6.000","-0.773","187.491192","-41.735901","M2II/III","M","1","","" }
{ "61495","61688","109931","4809","","","","","","","Crv","","219.486","6.000","1.860","189.685896","-18.250100","F0V","F","1","","" }
{ "62783","62983","112131","4901","","","","","","","Vir","","223.395","6.000","1.822","193.577755","-11.648570","A2V","A","1","","" }
{ "63138","63340","113049","4927","","","","","","","Dra","","541.788","6.000","-0.102","194.697128","75.472508","K0III","K","1","","" }
{ "63745","63948","113848","4946","","39    Com","","39","","","Com","","162.025","6.000","2.519","196.588511","21.153397","F4V","F","1","","" }
{ "64924","65129","115842","5027","","","","","","","Cen","","326156.378","6.000","-14.000","200.201420","-55.800688","B0.5Ia","B","1","","" }
{ "66365","66575","118520","5124","","","","","","","Cen","","326156.378","6.000","-14.000","204.703988","-57.622717","G5Ib","G","1","","" }
{ "66713","66925","119159","5151","","","","","","","Cen","","2886.340","6.000","-3.735","205.733806","-56.767971","B0.5III","B","1","","" }
{ "67332","67545","120602","5205","","","","","","","Vir","","504.886","6.000","0.051","207.602828","5.497224","K0","K","1","","" }
{ "67883","68101","121384","5236","Gl 534.1A","","","","","","Cen","","126.222","6.000","3.061","209.137340","-54.704665","G8V","G","1","","Gl 534.1" }
{ "70869","71094","127726","5433","","","","","","","Boo","","240.174","6.000","1.664","218.084295","26.677284","A7Vn","A","1","","" }
{ "72622","72848","131511","5553","Gl 567","","","","","","Boo","","37.541","6.000","5.695","223.349089","19.152798","K2V","K","1","","" }
{ "76574","76810","140027","5840","","19Tau6Ser","Tau-6","19","Tau","6","Ser","","606.239","6.000","-0.346","235.246251","16.024588","G8III","G","1","","" }
{ "77442","77678","141544","5882","","","","","","","Nor","","449.251","6.000","0.305","237.881041","-47.060800","K1IV","K","1","","" }
{ "78426","78665","143790","5970","","","","","","","Lup","","180.097","6.000","2.290","240.893178","-32.000538","F5IV/V","F","1","","" }
{ "110527","110873","212988","8555","","","","","","","Peg","","867.437","6.000","-1.124","336.942708","31.840045","K2","K","1","","" }
{ "117996","","","","GJ 9015B","","","","","","Tuc","","68.234","6.000","4.397","8.184653","-63.031210","A","A","2","2572","GJ 9015" }
{ "119198","","","","Gl 702B","","","","","","Oph","","16.588","6.000","7.468","271.364843","2.498264","K5 Ve","K","2","88327","Gl 702" }
{ "110965","111314","213973","8595","","","","","","","Cep","","253.424","6.010","1.558","338.261546","69.913545","A9III","A","1","","" }
{ "112638","112998","216595","8707","","","","","","","Cep","","1269.091","6.010","-1.940","343.265738","60.101029","K2V:","K","1","","" }
{ "117588","117956","224165","9053","","","","","","","And","","1418.071","6.010","-2.181","358.889493","47.355804","G8Ib","G","1","","" }
{ "117703","118071","224342","9057","","","","","","","And","","1052.117","6.010","-1.533","359.265128","42.658232","F8III","F","1","","" }
{ "28858","28930","41429","2146","","","","","","","Aur","","734.586","6.010","-0.753","91.593522","29.512414","M3II comp","M","1","","" }
{ "31678","31758","47561","2448","","","","","","","CMa","","487.528","6.010","0.137","99.647610","-16.873547","A0IV","A","1","","" }
{ "33713","33800","53349","2661","","","","","","","Car","","176.587","6.010","2.342","105.271436","-58.939937","F0V","F","1","","" }
{ "33966","34055","52976","2651","","","","","","","Gem","","1896.258","6.010","-2.812","105.964996","12.594242","K5","K","1","","" }
{ "37288","37394","61749","2958","","","","","","","Mon","","310.921","6.010","1.114","115.148017","-8.185430","A3IV","A","1","","" }
{ "39012","39122","66210","3148","","","","","","","Pup","","330.452","6.010","0.982","120.061244","-48.981509","A2V","A","1","","" }
{ "41165","41282","71196","3316","","","","","","","Pup","","114.682","6.010","3.280","126.329178","-21.045956","F2/F3V","F","1","","" }
{ "41479","41597","71766","3342","","","","","","","Hya","","1462.585","6.010","-2.248","127.212513","-9.748582","F2III","F","1","","" }
{ "43602","43726","76151","3538","Gl 327","","","","","","Hya","","56.703","6.010","4.809","133.574786","-5.434459","G3V","G","1","","" }
{ "46156","46288","81567","3741","","","","","","","Hya","","691.009","6.010","-0.620","141.592953","-1.464078","K3III","K","1","","" }
{ "48204","48341","85364","3899","","6    Sex","","6","","","Sex","","207.347","6.010","1.994","147.808467","-4.243350","A8III","A","1","","" }
{ "50394","50536","89455","4055","","","","","","","Hya","","214.154","6.010","1.923","154.820288","-12.528132","A8III","A","1","","" }
{ "50492","50635","89414","4052","","","","","","","UMa","","530.335","6.010","-0.046","155.129849","54.216839","K3III:","K","1","","" }
{ "51068","51213","90569","4101","","45    Leo","","45","","","Leo","","421.391","6.010","0.454","156.912460","9.762396","A0sp...","A","1","","" }
{ "51756","51905","91880","4156","","Phi2Hya","Phi-2","","Phi","2","Hya","","756.743","6.010","-0.818","159.069415","-16.344326","M1III","M","1","","" }
{ "53980","54136","95934","4309","","51    UMa","","51","","","UMa","","257.221","6.010","1.526","166.130156","38.241365","A3III-IV","A","1","","" }
{ "758","760","431","20","","","","","","","Cep","","344.047","6.010","0.894","2.332878","79.714545","A7IV","A","1","","" }
{ "3429","3436","4145","190","","","","","","","Cet","","183.957","6.010","2.254","10.958700","-12.011813","K1III","K","1","","" }
{ "6967","6981","9100","432","","97    Psc","","97","","","Psc","","476.837","6.010","0.185","22.470256","18.355669","A4IV","A","1","","" }
{ "8459","8475","11031","526","","","","","","","Per","","416.016","6.010","0.482","27.314790","47.896924","A3V","A","1","","" }
{ "8980","8998","11803","560","","","","","","","Cet","","130.098","6.010","3.006","28.974299","1.849982","F7V+...","F","1","","" }
{ "9837","9859","12885","615","","11    Ari","","11","","","Ari","","876.764","6.010","-1.137","31.705141","25.704553","B9IV-Vn","B","1","","" }
{ "10180","10203","13363","633","","16    Ari","","16","","","Ari","","767.427","6.010","-0.848","32.800229","25.936938","K4III","K","1","","" }
{ "16226","16266","21665","1060","","","","","","","Eri","","387.359","6.010","0.637","52.413076","-6.804458","G5","G","1","","" }
{ "16966","17007","22789","1114","","Tau For","Tau","","Tau","","For","","384.165","6.010","0.655","54.698625","-27.943054","A0V","A","1","","" }
{ "21085","21137","28677","1432","","85    Tau","","85","","","Tau","","147.315","6.010","2.736","67.965649","15.851560","F4V...","F","1","","" }
{ "21216","21269","28930","1446","","","","","","","Tau","","557.532","6.010","-0.154","68.450730","9.413567","G8III","G","1","","" }
{ "21406","21459","29169","1459","","","","","","","Tau","","155.017","6.010","2.625","69.121382","23.340855","F5IV","F","1","","" }
{ "85074","85333","157978","6497","","","","","","","Oph","","666.987","6.010","-0.543","261.579207","7.595650","A0...","A","1","","" }
{ "86260","86527","160371","","","","","","","","Sco","","787.817","6.010","-0.905","265.243943","-32.214464","K3III + (G)","K","1","","" }
{ "87175","87445","162989","6673","","","","","","","Her","","664.270","6.010","-0.535","268.019677","39.982089","K4III","K","1","","" }
{ "87917","88190","164614","6726","","","","","","","Her","","836.299","6.010","-1.035","270.151562","33.213682","K6III","K","1","","" }
{ "89549","89827","168694","6867","","","","","","","Her","","597.356","6.010","-0.304","274.966958","29.666392","K4III","K","1","","" }
{ "98263","98575","189561","7643","","","","","","","Sgr","","351.083","6.010","0.850","300.349362","-22.737307","K0III","K","1","","" }
{ "99261","99579","192439","7726","","","","","","","Cyg","","346.238","6.010","0.880","303.132177","51.463565","K1III:","K","1","","" }
{ "101749","102080","197121","7918","","10    Del","","10","","","Del","","507.242","6.010","0.051","310.317536","14.582880","K4III:","K","1","","" }
{ "102474","102805","198390","7973","","15    Del","","15","","","Del","","99.864","6.010","3.580","312.407364","12.545128","F5V","F","1","","" }
{ "103402","103734","200253","8051","","","","","","","Cyg","","626.020","6.010","-0.406","315.303603","36.026010","G5III","G","1","","" }
{ "105550","105891","204428","8218","","","","","","","Cyg","","448.017","6.010","0.321","321.687349","52.898537","B6V","B","1","","" }
{ "59182","59364","105805","4633","","","","","","","Com","","290.433","6.010","1.262","182.692069","27.281505","A4Vn","A","1","","" }
{ "63287","63490","112935","4922","","","","","","","Cen","","135.447","6.010","2.918","195.136107","-33.505267","F3V","F","1","","" }
{ "63381","63584","113337","4934","","","","","","","Dra","","120.309","6.010","3.176","195.446050","63.610225","F6V","F","1","","" }
{ "64009","64212","114357","4964","","","","","","","CVn","","347.344","6.010","0.873","197.411090","37.423146","K3III","K","1","","" }
{ "64773","64979","115810","5025","","","","","","","CVn","","205.518","6.010","2.013","199.767730","35.127978","F0IV","F","1","","" }
{ "65807","66015","117661","5094","","73    Vir","","73","","","Vir","","249.737","6.010","1.590","203.011708","-18.728880","A7IV/V","A","1","","" }
{ "68061","68279","121980","5254","","","","","","","Boo","","557.532","6.010","-0.154","209.666285","14.649275","K5III","K","1","","" }
{ "70726","70949","127337","5424","","","","","","","Vir","","693.950","6.010","-0.630","217.689121","4.772286","K4III","K","1","","" }
{ "75445","75674","137853","5745","","","","","","","Ser","","797.448","6.010","-0.931","231.911970","25.101626","M1III","M","1","","" }
{ "77121","77358","140901","5864","Gl 599A","","","","","","Lup","","50.078","6.010","5.079","236.871523","-37.916312","G6IV","G","1","","Gl 599" }
{ "55399","55564","98772","4391","","","","","","","UMa","","283.122","6.020","1.327","170.713533","64.330513","A3V","A","1","","" }
{ "57068","57240","101980","4512","","","","","","","Leo","","2568.161","6.020","-3.461","176.054849","25.218327","K5III","K","1","","" }
{ "60583","60771","108355","4736","","","","","","","Cru","","662.919","6.020","-0.520","186.853489","-63.788986","B8IV","B","1","","" }
{ "61743","61936","110462","4833","","76    UMa","","76","","","UMa","","521.850","6.020","-0.001","190.391382","62.713039","A2III","A","1","","" }
{ "61758","61951","110385","4827","","","","","","","Crv","","202.330","6.020","2.057","190.455833","-19.759092","F2V","F","1","","" }
{ "62560","62757","111765","4878","","37    Vir","","37","","","Vir","","598.452","6.020","-0.298","192.903705","3.056788","K4III:","K","1","","" }
{ "66793","67005","119765","5169","","","","","","","UMa","","313.311","6.020","1.107","205.978267","52.064413","A1V","A","1","","" }
{ "68870","69090","122862","5279","Gl 539.1","","","","","","Aps","","92.948","6.020","3.746","212.114857","-74.850285","G1V","G","1","","" }
{ "71051","71277","128198","5448","","","","","","","Boo","","507.242","6.020","0.061","218.660431","36.626064","K5III","K","1","","" }
{ "74193","74421","133981","5628","","","","","","","Aps","","979.449","6.020","-1.368","228.141661","-72.770599","B8/B9III","B","1","","" }
{ "76699","76935","139871","5832","","","","","","","Nor","","615.389","6.020","-0.359","235.655120","-49.489553","K2III","K","1","","" }
{ "79360","79601","147321","6088","","","","","","","UMi","","662.919","6.020","-0.520","243.639415","73.394891","A3V","A","1","","" }
{ "81623","81873","150026","6182","","","","","","","TrA","","328.125","6.020","1.007","250.842177","-67.432386","A0Vn","A","1","","" }
{ "81661","81911","151087","6222","","","","","","","Her","","173.950","6.020","2.385","250.965401","34.038803","F2.5III-IV","F","1","","" }
{ "81786","82037","151133","6224","","16    Oph","","16","","","Oph","","499.474","6.020","0.095","251.373643","1.020161","B9.5III","B","1","","" }
{ "1194","1196","1061","50","","35    Psc","","35","","","Psc","","253.621","6.020","1.566","3.745161","8.820962","F0IV","F","1","","" }
{ "9201","9220","11857","561","","","","","","","Cas","","729.656","6.020","-0.728","29.638439","61.697788","B5III","B","1","","" }
{ "14712","14748","19637","946","","","","","","","Ari","","462.633","6.020","0.261","47.612689","26.896233","K3III","K","1","","" }
{ "19213","19261","26015","1279","","","","","","","Tau","","142.302","6.020","2.821","61.924918","15.162788","F3V","F","1","","" }
{ "23322","23377","32453","1631","","","","","","","Cae","","364.828","6.020","0.777","75.393848","-39.718046","G8III","G","1","","" }
{ "24015","24072","33203","1669","","","","","","","Aur","","1583.283","6.020","-2.411","77.578361","37.301854","B2II: comp","B","1","","" }
{ "25418","25482","36584","1859","","","","","","","Dor","","254.016","6.020","1.563","81.749226","-68.622544","F0IV/V","F","1","","" }
{ "115731","116097","221323","8929","","","","","","","Phe","","342.242","6.020","0.915","352.862283","-44.843579","K0III","K","1","","" }
{ "119623","","61563","2950","","","","","","","CMi","","232.969","6.020","1.751","115.029166","16.938611","A0III","A","1","","" }
{ "31771","31852","47395","2438","","54    Aur","","54","","","Aur","","842.781","6.020","-1.041","99.888002","28.263134","B7III","B","1","","" }
{ "33527","33614","51440","2600","","62    Aur","","62","","","Aur","","836.299","6.020","-1.025","104.761888","38.052317","K2III","K","1","","" }
{ "34905","34999","55879","2739","","","","","","","Mon","","2836.142","6.020","-3.677","108.617721","-10.316245","B0III","B","1","","" }
{ "35118","35213","56578","","","","","","","","CMa","","303.119","6.020","1.179","109.159824","-23.310940","A5m...","A","1","","" }
{ "37715","37823","63118","3020","","","","","","","Pup","","821.553","6.020","-0.986","116.325188","-43.752566","B6IV","B","1","","" }
{ "38619","38732","65211","3101","","","","","","","Pup","","2025.816","6.020","-2.946","118.944117","-43.845054","B6V","B","1","","" }
{ "39150","39261","65339","3109","","53    Cam","","53","","","Cam","","321.971","6.020","1.048","120.426975","60.324353","A2p...","A","1","","" }
{ "41107","41224","70647","3287","","","","","","","Lyn","","962.113","6.020","-1.329","126.178216","42.005242","K5III","K","1","","" }
{ "43497","43620","76346","3549","","","","","","","Car","","301.438","6.020","1.191","133.265788","-56.649485","A0V","A","1","","" }
{ "45287","45418","80094","3691","","","","","","","Car","","593.012","6.020","-0.278","138.823534","-58.388377","B7IV","B","1","","" }
{ "45350","45481","80057","3688","","","","","","","Vel","","326156.378","6.020","-13.980","139.016794","-44.898723","A1Ib+...","A","1","","" }
{ "48277","48414","85504","3906","","7    Sex","","7","","","Sex","","661.575","6.020","-0.516","148.050680","2.454131","A0Vs","A","1","","" }
{ "50033","50174","88737","4012","GJ 3589","","","","","","Leo","","185.316","6.020","2.248","153.623976","21.168058","F9V","F","1","","" }
{ "52215","52366","92620","4184","","","","","","","LMi","","811.334","6.020","-0.959","160.546949","31.696998","M2III","M","1","","" }
{ "90371","90651","170397","6932","","","","","","","Sct","","341.883","6.020","0.918","277.444831","-14.581987","Ap","A","1","","" }
{ "90477","90759","170384","6931","","","","","","","CrA","","221.273","6.020","1.862","277.762289","-41.913834","A3V","A","1","","" }
{ "91089","91373","172380","7009","","","","","","","Lyr","","1716.613","6.020","-2.586","279.526982","39.668326","M4.5II","M","1","","" }
{ "91629","91915","173949","7075","","","","","","","Dra","","357.236","6.020","0.822","281.076105","61.048143","G7IV","G","1","","" }
{ "94087","94382","179648","7286","","","","","","","Vul","","769.237","6.020","-0.843","288.153053","21.554572","A2Vn","A","1","","" }
{ "94460","94755","181096","7322","","","","","","","Cyg","","137.098","6.020","2.902","289.214120","46.999102","F6IV:","F","1","","" }
{ "101681","102011","197373","7925","","","","","","","Cep","","107.324","6.020","3.434","310.074523","60.505264","F6IV","F","1","","" }
{ "101703","102033","197120","7917","","","","","","","Cyg","","242.135","6.020","1.667","310.151151","29.805552","A2V","A","1","","" }
{ "105829","106171","204965","8237","","","","","","","Cyg","","516.888","6.020","0.020","322.584671","52.957998","A3V","A","1","","" }
{ "107080","107423","206399","8286","","","","","","","Ind","","742.953","6.020","-0.768","326.370053","-71.008849","B8IV","B","1","","" }
{ "108282","108626","208796","8381","","","","","","","Ind","","543.594","6.020","-0.089","330.100987","-55.883486","B9IV/V","B","1","","" }
{ "84534","84792","156717","6435","","","","","","","Oph","","375.756","6.030","0.723","259.972293","-17.756543","A0V","A","1","","" }
{ "87261","87532","162517","6653","","","","","","","Sco","","206.559","6.030","2.022","268.240015","-35.624314","F2V","F","1","","" }
{ "87748","88020","164280","6711","","","","","","","Her","","369.373","6.030","0.760","269.676337","36.287797","G5III:","G","1","","" }
{ "89359","89637","167647","6833","","","","","","","Sgr","","1113.162","6.030","-1.636","274.401025","-34.107258","B3/B4IV/V","B","1","","" }
{ "94303","94598","180242","7299","","","","","","","Sge","","680.911","6.030","-0.568","288.761212","20.203123","G8III","G","1","","" }
{ "94707","95002","181383","7332","","29Ome2Aql","Ome-2","29","Ome","2","Aql","","265.816","6.030","1.474","289.971105","11.534965","A2V","A","1","","" }
{ "95113","95408","182180","7355","","","","","","","Sgr","","891.138","6.030","-1.153","291.125746","-27.865945","B2Vnn","B","1","","" }
{ "96085","96387","185037","7457","","11    Cyg","","11","","","Cyg","","602.877","6.030","-0.304","293.951265","36.944539","B8Vn","B","1","","" }
{ "97832","98143","189066","7620","","","","","","","Cyg","","1038.714","6.030","-1.485","299.183931","36.250599","B5IV","B","1","","" }
{ "100834","101160","195325","7836","","1    Del","","1","","","Del","","742.953","6.030","-0.758","307.574843","10.895924","A1sh","A","1","","" }
{ "111516","111869","214714","8626","","","","","","","Lac","","997.420","6.030","-1.397","339.893045","37.592817","G3Ib-IICNe.","G","1","","" }
{ "112684","113044","216435","8700","GJ 9802","Tau1Gru","Tau-1","","Tau","1","Gru","","106.379","6.030","3.463","343.407777","-48.598286","G3IV","G","1","","" }
{ "117512","117880","224022","9046","","","","","","","Phe","","90.348","6.030","3.818","358.660644","-40.300062","F8IV","F","1","","" }
{ "117589","117957","224151","9052","","","","","","","Cas","","326156.378","6.030","-13.970","358.891005","57.412168","B0.5IIv SB","B","1","","" }
{ "60281","60467","107904","4715","","4    CVn","","4","","","CVn","","310.330","6.030","1.138","185.945953","42.542743","F3IV","F","1","","" }
{ "60413","60599","108123","4725","","","","","","","Com","","476.141","6.030","0.208","186.312941","23.926202","K0III","K","1","","" }
{ "70102","70325","125810","5377","","","","","","","Lup","","1016.064","6.030","-1.437","215.834405","-50.772252","K2III","K","1","","" }
{ "71304","71530","128020","5443","Gl 558.1","","","","","","Cir","","90.978","6.030","3.802","219.444139","-67.932012","F7V","F","1","","" }
{ "73772","74000","134064","5633","","","","","","","Boo","","235.492","6.030","1.737","226.834865","18.441825","A3V","A","1","","" }
{ "79250","79490","145384","6022","","","","","","","Nor","","1598.806","6.030","-2.422","243.320714","-53.671171","M0III","M","1","","" }
{ "82008","82259","151527","6235","","","","","","","Oph","","493.429","6.030","0.131","252.112396","-14.909421","A0IV/V","A","1","","" }
{ "3596","3604","4335","205","","","","","","","And","","427.466","6.030","0.443","11.545038","44.861497","B9.5IIIMNp.","B","1","","" }
{ "5064","5074","6386","307","","73    Psc","","73","","","Psc","","651.011","6.030","-0.471","16.219322","5.656262","K5III","K","1","","" }
{ "7373","7387","9896","460","","","","","","","Hyi","","131.092","6.030","3.009","23.811980","-58.139475","F2V","F","1","","" }
{ "13353","13387","18185","866","","","","","","","Hor","","533.807","6.030","-0.040","43.079093","-62.909583","K1III","K","1","","" }
{ "15315","15353","20888","1014","","","","","","","Ret","","179.207","6.030","2.330","49.495927","-66.926853","A3V","A","1","","" }
{ "15811","15850","21051","1028","","","","","","","Tau","","458.085","6.030","0.292","51.042206","12.629590","K0III-IV","K","1","","" }
{ "16142","16181","21467","1048","","66    Ari","","66","","","Ari","","210.152","6.030","1.984","52.110696","22.804006","K0IV","K","1","","" }
{ "23325","23380","31662","1593","","","","","","","Cam","","116.111","6.030","3.273","75.400138","61.077996","F4V","F","1","","" }
{ "24326","24384","34347","1727","","","","","","","Pic","","616.553","6.030","-0.353","78.472225","-52.030755","K3III","K","1","","" }
{ "26362","26427","37303","1918","","","","","","","Ori","","1331.251","6.030","-2.024","84.363990","-5.938391","B1Vvar","B","1","","" }
{ "27353","27421","38670","1997","","","","","","","Tau","","546.326","6.030","-0.090","87.093197","20.869481","B9Vn","B","1","","" }
{ "28082","28154","39970","2074","","","","","","","Tau","","326156.378","6.030","-13.970","89.233826","24.249689","A0Ia","A","1","","" }
{ "30721","30794","44472","2285","","","","","","","Cam","","580.349","6.030","-0.221","97.060356","70.535320","A4V","A","1","","" }
{ "31537","31617","47463","2444","","","","","","","Col","","359.996","6.030","0.816","99.257870","-38.146506","K0III","K","1","","" }
{ "32957","33044","50056","2542","","","","","","","Aur","","956.470","6.030","-1.306","103.264747","35.787995","K3III:","K","1","","" }
{ "33156","33243","50890","2582","","","","","","","Mon","","1090.824","6.030","-1.592","103.745488","-2.803588","G6III:","G","1","","" }
{ "33357","33444","50551","2561","","","","","","","Lyn","","807.318","6.030","-0.938","104.304716","57.563287","K3III","K","1","","" }
{ "34687","34780","56239","2754","","","","","","","Car","","481.767","6.030","0.183","108.008250","-63.190059","A0IV/V","A","1","","" }
{ "38217","38325","63332","3028","","","","","","","Lyn","","96.553","6.030","3.673","117.773863","54.129240","F6V","F","1","","" }
{ "38285","38394","63889","3053","","","","","","","Gem","","452.995","6.030","0.317","117.986560","19.325085","K1III:","K","1","","" }
{ "38754","38868","65066","3097","","","","","","","CMi","","336.591","6.030","0.962","119.316165","8.641220","K0III","K","1","","" }
{ "40117","40231","68461","3222","","","","","","","Cnc","","481.057","6.030","0.186","123.248876","16.514320","G8III","G","1","","" }
{ "41097","41214","70937","3295","","","","","","","Hya","","206.690","6.030","2.021","126.151815","-4.717000","F2V","F","1","","" }
{ "42776","42895","75171","3495","","","","","","","Vol","","191.182","6.030","2.190","131.125045","-65.825429","A9V","A","1","","" }
{ "53310","53465","94669","4264","","","","","","","UMa","","311.515","6.030","1.130","164.060482","42.008155","K2III","K","1","","" }
{ "53635","53791","95241","4285","","","","","","","UMa","","144.637","6.030","2.796","165.086247","42.911724","F9V","F","1","","" }
{ "27709","27778","39225","2028","","","","","","","Aur","","771.055","6.040","-0.828","88.167045","33.917462","M2II:","M","1","","" }
{ "28429","28500","40589","2111","","","","","","","Gem","","2296.876","6.040","-3.199","90.251892","27.572362","B9Iab","B","1","","" }
{ "28449","28520","40972","2129","","","","","","","Lep","","358.414","6.040","0.835","90.304575","-25.417763","A0V","A","1","","" }
{ "28566","28637","40626","2112","","","","","","","Aur","","424.683","6.040","0.467","90.702491","49.905678","B9.5IV","B","1","","" }
{ "29298","29371","42477","2191","","","","","","","Ori","","430.854","6.040","0.435","92.866292","13.638561","A0Vnn","A","1","","" }
{ "29920","29993","44021","2268","","","","","","","CMa","","571.202","6.040","-0.177","94.703295","-15.024954","M1III:","M","1","","" }
{ "32282","32368","49001","2495","","","","","","","CMa","","476.141","6.040","0.218","101.347357","-23.462432","K2III","K","1","","" }
{ "35917","36017","58585","2839","","","","","","","CMa","","326156.378","6.040","-13.960","111.333231","-21.982591","A6II","A","1","","" }
{ "40703","40818","70013","3269","","","","","","","Hya","","550.011","6.040","-0.095","124.957765","3.948032","G8III","G","1","","" }
{ "41930","42049","72617","3380","","","","","","","Cnc","","188.312","6.040","2.233","128.555629","8.452339","F3IV","F","1","","" }
{ "44086","44213","77320","3593","","","","","","","Vel","","1045.373","6.040","-1.489","135.092739","-43.173991","B3Vne","B","1","","" }
{ "44905","45033","78715","3640","","79    Cnc","","79","","","Cnc","","368.122","6.040","0.777","137.586910","21.996415","G8III","G","1","","" }
{ "44930","45058","78712","3639","","","","","","","Cnc","","467.943","6.040","0.256","137.661666","30.963139","M6S","M","1","","" }
{ "45682","45814","80774","3716","","","","","","","Vel","","511.217","6.040","0.064","140.123637","-37.581688","K3/K4III","K","1","","" }
{ "51403","51551","91280","4130","","","","","","","Hya","","139.264","6.040","2.888","157.952853","-28.237103","F6/F7V","F","1","","" }
{ "51412","51560","91356","4136","","","","","","","Vel","","634.545","6.040","-0.405","157.986010","-45.069660","B4","B","1","","" }
{ "51962","52113","92245","4172","","","","","","","Hya","","363.203","6.040","0.806","159.710055","-12.443618","A0Vn","A","1","","" }
{ "58278","58453","104081","4582","","","","","","","Cen","","1025.649","6.040","-1.448","179.795285","-51.696761","K1/K2II","K","1","","" }
{ "64789","64994","115439","5012","","","","","","","Mus","","554.688","6.040","-0.113","199.829126","-72.035603","K3III","K","1","","" }
{ "67059","67271","120033","5178","","","","","","","Vir","","608.501","6.040","-0.314","206.805849","-9.709455","K5III","K","1","","" }
{ "71355","71581","128488","5456","","","","","","","Cen","","721.585","6.040","-0.684","219.580670","-38.794184","K3III","K","1","","" }
{ "76138","76372","139087","5796","","","","","","","Ser","","721.585","6.040","-0.684","233.972367","11.265656","K0III:","K","1","","" }
{ "77810","78046","142448","5918","","","","","","","Lup","","565.262","6.040","-0.154","239.028492","-39.864364","B9V","B","1","","" }
{ "78050","78286","143584","5964","","","","","","","Her","","159.802","6.040","2.589","239.768286","49.881043","F0IV","F","1","","" }
{ "79779","80021","147266","6087","","","","","","","Her","","320.075","6.040","1.081","245.017820","21.132610","G8II","G","1","","" }
{ "82883","83138","153956","6330","","","","","","","Dra","","303.684","6.040","1.195","254.839744","56.688594","K1III:","K","1","","" }
{ "85526","85788","158476","6513","","","","","","","Ara","","1456.055","6.040","-2.209","262.954575","-46.036783","F8/G0Ib","F","1","","" }
{ "85915","86178","160054","6570","","","","","","","Her","","227.128","6.040","1.826","264.153096","30.785179","A5V","A","1","","" }
{ "89002","89279","167370","6826","","","","","","","Her","","662.919","6.040","-0.500","273.270082","38.773493","B9IIIn","B","1","","" }
{ "91566","91852","173416","7043","","","","","","","Lyr","Xihe","454.890","6.040","0.318","280.900444","36.556605","G8","G","1","","" }
{ "91721","92008","172630","7015","","","","","","","Pav","","1156.583","6.040","-1.709","281.297969","-61.095196","K3III","K","1","","" }
{ "92107","92394","172881","7027","","","","","","","Pav","","704.441","6.040","-0.632","282.431989","-72.995722","B9.5IV/V","B","1","","" }
{ "93061","93354","176896","7204","","","","","","","Lyr","","385.528","6.040","0.677","285.230003","33.802158","K0III:","K","1","","" }
{ "96780","97087","186568","7512","","","","","","","Cyg","","1079.988","6.040","-1.560","295.964378","34.162724","B8III","B","1","","" }
{ "97204","97515","187098","7538","","","","","","","Sgr","","151.419","6.040","2.706","297.298331","-28.788972","F3V","F","1","","" }
{ "97363","97674","186786","7524","","","","","","","Pav","","188.857","6.040","2.226","297.754802","-65.605087","F2III-IV","F","1","","" }
{ "102969","103301","199223","8010","","","","","","","Del","","461.978","6.040","0.284","313.919491","4.532723","G6III-IV","G","1","","" }
{ "103445","103777","200052","8045","","","","","","","Cap","","303.119","6.040","1.199","315.438660","-26.880993","A3V","A","1","","" }
{ "109278","109624","210705","8462","","39    Aqr","","39","","","Aqr","","137.156","6.040","2.921","333.107320","-14.193957","F0V","F","1","","" }
{ "110153","110498","212495","8537","","","","","","","Cep","","742.953","6.040","-0.748","335.752120","62.419357","A1V","A","1","","" }
{ "112777","113137","216437","8701","","Rho Ind","Rho","","Rho","","Ind","","87.231","6.040","3.904","343.664716","-70.073709","G4IV-V","G","1","","" }
{ "114908","115272","220003","8877","","","","","","","Gru","","281.169","6.040","1.362","350.209011","-50.306559","Fm...","F","1","","" }
{ "2783","2789","3303","148","","","","","","","Phe","","230.825","6.040","1.791","8.888870","-54.821873","K0IV","K","1","","" }
{ "3978","3988","4817","237","","","","","","","Cas","","326156.378","6.040","-13.960","12.818268","61.805494","K5Ib","K","1","","" }
{ "5811","5824","7446","367","","88    Psc","","88","","","Psc","","519.357","6.040","0.030","18.676633","6.995136","G6III:","G","1","","" }
{ "5923","5936","7578","371","","","","","","","Psc","","348.086","6.040","0.899","19.078828","33.114720","K1III","K","1","","" }
{ "9548","9568","12005","572","","","","","","","Cep","","964.960","6.040","-1.315","30.737662","77.916263","K0","K","1","","" }
{ "12829","12862","17163","816","","","","","","","Cet","","160.116","6.040","2.585","41.337108","4.711629","F0III:","F","1","","" }
{ "22091","22144","30432","1526","","","","","","","Cae","","317.273","6.040","1.100","71.481088","-39.356619","K1III","K","1","","" }
{ "22301","22354","30545","1534","","","","","","","Ori","","686.645","6.040","-0.577","72.185937","3.588526","K1III","K","1","","" }
{ "23588","23643","32686","1646","","","","","","","Ori","","1164.844","6.040","-1.724","76.227194","-3.039675","B5IV","B","1","","" }
{ "23722","23777","32996","1661","","","","","","","Lep","","370.632","6.040","0.762","76.653097","-13.122622","B9.5/A0IV","B","1","","" }
{ "26199","26264","38602","1991","","Iot Men","Iot","","Iot","","Men","","853.812","6.040","-1.050","83.900575","-78.820839","B8III","B","1","","" }
{ "26647","26712","37519","1938","","","","","","","Aur","","621.250","6.040","-0.359","85.149615","31.358197","B9.5III-IVp","B","1","","" }
{ "27273","27341","38735","2001","","","","","","","Ori","","668.353","6.040","-0.518","86.862046","-10.532958","A4V","A","1","","" }
{ "2218","2224","2436","106","","48    Psc","","48","","","Psc","","762.048","6.050","-0.793","7.052931","16.445065","K5III","K","1","","" }
{ "2229","2235","2454","107","","","","","","","Psc","","119.209","6.050","3.236","7.083547","10.189848","F6Vawvar","F","1","","" }
{ "3347","3356","4065","185","","Lam1Scl","Lam-1","","Lam","1","Scl","","473.377","6.050","0.241","10.678714","-38.463483","B9.5V","B","1","","" }
{ "8351","8366","11604","550","","Tau2Hyi","Tau-2","","Tau","2","Hyi","","201.705","6.050","2.094","26.944365","-80.176311","F0III","F","1","","" }
{ "10031","10054","12467","597","","","","","","","Cep","","230.174","6.050","1.807","32.355934","81.295945","A1V","A","1","","" }
{ "10379","10403","13594","647","","","","","","","And","","129.120","6.050","3.062","33.510336","47.484241","F5V","F","1","","" }
{ "10414","10438","13474","640","","55    Cas","","55","","","Cas","","713.690","6.050","-0.650","33.621248","66.524428","B9V+...","B","1","","" }
{ "13368","13402","17925","857","Gl 117","","","","","","Eri","","33.764","6.050","5.975","43.133845","-12.769714","K1V","K","1","","" }
{ "13679","13713","18155","865","","","","","","","Per","","1042.033","6.050","-1.472","44.138762","47.164006","K3III:","K","1","","" }
{ "14279","14315","19121","926","","","","","","","Cet","","430.285","6.050","0.448","46.158612","1.863604","K0III","K","1","","" }
{ "17880","17921","23950","1185","","","","","","","Tau","","368.122","6.050","0.787","57.479466","22.244151","B8III","B","1","","" }
{ "18438","18485","24769","1221","","33    Tau","","33","","","Tau","","680.911","6.050","-0.548","59.265863","23.175550","B9.5IV","B","1","","" }
{ "18545","18592","25346","1245","","","","","","","Ret","","200.219","6.050","2.110","59.678704","-57.102360","F2IV","F","1","","" }
{ "19680","19730","26076","1281","","","","","","","Cam","","472.690","6.050","0.244","63.436717","72.126147","K1III","K","1","","" }
{ "21558","21611","30479","1531","","","","","","","Men","","514.442","6.050","0.060","69.590584","-77.656003","K2III","K","1","","" }
{ "23387","23442","31312","1572","","","","","","","Cam","","680.911","6.050","-0.548","75.582479","74.269368","K5III","K","1","","" }
{ "24946","25007","35165","1772","","","","","","","Col","","1436.812","6.050","-2.170","80.320253","-34.345051","B5II/III","B","1","","" }
{ "26876","26942","37601","1941","","24    Cam","","24","","","Cam","","192.992","6.050","2.189","85.756945","56.581522","K0III","K","1","","" }
{ "82845","83100","153072","6298","","","","","","","Sco","","315.432","6.050","1.123","254.717749","-37.620508","A3III","A","1","","" }
{ "83000","83255","148542","6139","","","","","","","Oct","","627.224","6.050","-0.370","255.243528","-86.364297","A2V","A","1","","" }
{ "85521","85783","158704","6520","","","","","","","Oph","","390.139","6.050","0.661","262.934889","-26.269709","B9II/III","B","1","","" }
{ "86195","86462","160677","6584","","","","","","","Her","","630.863","6.050","-0.383","264.989663","31.202470","M2III","M","1","","" }
{ "87245","87516","162496","6651","","","","","","","Sco","","620.069","6.050","-0.345","268.205096","-34.114833","K1III","K","1","","" }
{ "87451","87722","162926","6671","","","","","","","Sco","","979.449","6.050","-1.338","268.783461","-36.475645","B9.5III","B","1","","" }
{ "89193","89470","167356","6825","","","","","","","Sgr","","1424.264","6.050","-2.151","273.878183","-18.661577","Ap Si","A","1","","" }
{ "93630","93925","177846","7240","","","","","","","Sgr","","1269.091","6.050","-1.900","286.878505","-28.636800","K3III","K","1","","" }
{ "99909","100232","193329","7768","","","","","","","Aql","","392.959","6.050","0.645","304.930269","-1.078514","K0","K","1","","" }
{ "103883","104217","201092","8086","Gl 820B","61    Cyg","","61","","","Cyg","","11.409","6.050","8.331","316.727451","38.742055","K7V","K","2","103879","Gl 820" }
{ "104576","104914","202261","8122","","","","","","","Cap","","362.396","6.050","0.821","318.777580","-17.345138","K0III","K","1","","" }
{ "105092","105432","203439","8169","","","","","","","Cyg","","608.501","6.050","-0.304","320.341403","32.612733","A1V","A","1","","" }
{ "29770","29843","43745","2254","","","","","","","CMa","","131.303","6.050","3.026","94.264970","-22.715229","F8/G0V","F","1","","" }
{ "30199","30272","43812","2257","","4    Lyn","","4","","","Lyn","","496.433","6.050","0.138","95.514812","59.372099","A3V","A","1","","" }
{ "30497","30570","44927","2304","","","","","","","Gem","","491.199","6.050","0.161","96.387245","23.327169","A2Vn","A","1","","" }
{ "30639","30711","45588","2349","GJ 9212A","","","","","","CMa","","97.418","6.050","3.674","96.797404","-25.856496","F8/G0V","F","1","","GJ 9212" }
{ "31566","31646","47129","2422","","","","","","","Mon","","326156.378","6.050","-13.950","99.350174","6.135382","O8e","O","1","","" }
{ "31778","31859","47827","2455","","","","","","","CMa","","679.492","6.050","-0.544","99.900935","-23.695662","A0V","A","1","","" }
{ "33007","33094","50806","2576","GJ 9219","","","","","","CMa","","84.453","6.050","3.984","103.391334","-28.539794","G3/G5V","G","1","","" }
{ "36292","36395","59438","2868","","","","","","","Pup","","114.441","6.050","3.324","112.341112","-14.998657","F5V","F","1","","" }
{ "37473","37580","61859","2962","","","","","","","Gem","","195.070","6.050","2.166","115.681493","34.000218","F7V","F","1","","" }
{ "38261","38370","64365","3078","","","","","","","Pup","","2090.746","6.050","-2.984","117.918163","-42.888202","B2IV","B","1","","" }
{ "38865","38975","65257","3104","","","","","","","Cnc","","1199.104","6.050","-1.777","119.631130","16.518680","K0","K","1","","" }
{ "38957","39067","65522","3115","","","","","","","Cnc","","325.505","6.050","1.054","119.896063","13.242166","K2","K","1","","" }
{ "41257","41373","71722","3341","","","","","","","Vel","","226.497","6.050","1.842","126.605082","-52.807500","A0V","A","1","","" }
{ "41456","41574","71496","3329","","28    Cnc","","28","","","Cnc","","445.569","6.050","0.373","127.153256","24.144934","F0Vn","F","1","","" }
{ "42675","42794","75747","3524","","","","","","","Cha","","302.838","6.050","1.211","130.801212","-79.070082","A7V","A","1","","" }
{ "44997","45127","79241","3656","","","","","","","Vel","","1090.824","6.050","-1.572","137.920562","-39.258845","B5III","B","1","","" }
{ "45961","46093","81471","3739","","","","","","","Vel","","326156.378","6.050","-13.950","140.997233","-51.737080","A7Iab","A","1","","" }
{ "45982","46114","81411","3737","","","","","","","Vel","","486.075","6.050","0.184","141.067848","-39.425502","A6/A7III","A","1","","" }
{ "46196","46328","82068","3761","","","","","","","Car","","227.604","6.050","1.831","141.683934","-64.929701","A3Vn","A","1","","" }
{ "47983","48119","85250","3895","","","","","","","Vel","","331.460","6.050","1.015","147.166771","-56.411890","K0III","K","1","","" }
{ "48735","48876","86369","3938","","","","","","","Leo","","449.871","6.050","0.352","149.531795","8.313979","K3III","K","1","","" }
{ "49968","50109","88639","4006","","","","","","","Leo","","512.824","6.050","0.067","153.457113","27.135819","G5III-IV","G","1","","" }
{ "51157","51302","90763","4109","","","","","","","Sex","","258.444","6.050","1.555","157.183168","-3.742385","A1sp...","A","1","","" }
{ "52805","52959","93765","4230","","44    LMi","","44","","","LMi","","282.631","6.050","1.361","162.473864","27.973948","F5V","F","1","","" }
{ "55430","55595","98960","4394","","","","","","","Leo","","630.863","6.050","-0.383","170.824795","0.132050","K3","K","1","","" }
{ "56195","56364","100418","4451","","","","","","","Crt","","406.172","6.050","0.574","173.311761","-16.280381","F8/G0Ib/II","F","1","","" }
{ "57042","57214","101933","4510","","","","","","","Vir","","403.160","6.050","0.590","175.979668","-6.677162","G8III:","G","1","","" }
{ "57473","57646","102660","4535","","","","","","","Leo","","205.388","6.050","2.054","177.311614","16.242882","A3m","A","1","","" }
{ "57868","58041","103400","4556","","","","","","","Cen","","1545.765","6.050","-2.329","178.547941","-57.410198","A0/A1III","A","1","","" }
{ "58522","58697","104555","4595","","","","","","","Oct","","371.054","6.050","0.770","180.586013","-85.631757","K3III","K","1","","" }
{ "59369","59551","106111","4645","","","","","","","Mus","","1638.977","6.050","-2.456","183.195947","-70.151787","F6Ib","F","1","","" }
{ "59712","59895","106819","4670","","","","","","","Crv","","440.157","6.050","0.399","184.263891","-16.693736","A2V","A","1","","" }
{ "60663","60851","108501","4744","","","","","","","Cru","","319.448","6.050","1.095","187.080374","-64.340989","A0Vn","A","1","","" }
{ "60912","61103","108985","4770","","","","","","","Vir","","803.341","6.050","-0.907","187.839233","7.604309","K5","K","1","","" }
{ "64116","64320","114365","4965","","","","","","","Cen","","377.496","6.050","0.733","197.743522","-52.566897","Ap","A","1","","" }
{ "67676","67890","121156","5228","","","","","","","Hya","","211.515","6.050","1.990","208.569388","-28.569590","K2III","K","1","","" }
{ "72084","72310","130157","5513","","","","","","","Lib","","1647.254","6.050","-2.467","221.806875","-21.324871","K4/K5III","K","1","","" }
{ "74488","74716","135348","5668","","","","","","","Lup","","2064.281","6.050","-2.957","229.043596","-43.484997","B3IV","B","1","","" }
{ "76373","76608","139271","5807","","","","","","","Lup","","478.937","6.050","0.216","234.675738","-39.127734","A4:m...","A","1","","" }
{ "77218","77454","140979","5865","","","","","","","Nor","","653.620","6.050","-0.459","237.210068","-52.438256","K2/K3III","K","1","","" }
{ "81192","81440","149911","6179","","","","","","","Oph","","369.373","6.050","0.780","249.506475","-6.538014","A0pe...","A","1","","" }
{ "81655","81904","150608","6210","","","","","","","Sco","","528.617","6.050","0.001","250.948325","-38.156346","B9II/III","B","1","","" }
{ "59715","59898","106797","4669","","","","","","","Mus","","313.010","6.060","1.149","184.276426","-65.692958","A0V","A","1","","" }
{ "61833","62026","110461","4832","","","","","","","Cru","","353.749","6.060","0.884","190.707398","-55.947001","B9V","B","1","","" }
{ "64585","64790","115149","5000","","","","","","","Mus","","126.319","6.060","3.120","199.187451","-65.138259","F5V","F","1","","" }
{ "65084","65289","115967","5030","","","","","","","Mus","","916.170","6.060","-1.183","200.719210","-72.146712","B6V","B","1","","" }
{ "70651","70874","126209","5389","","","","","","","Aps","","491.940","6.060","0.168","217.404408","-76.729083","K0/K1III","K","1","","" }
{ "70668","70892","127304","5422","","","","","","","Boo","","359.203","6.060","0.850","217.456970","31.791188","A0Vs","A","1","","" }
{ "71412","71639","128582","5457","","","","","","","Lup","","114.161","6.060","3.340","219.795412","-46.584480","F7V","F","1","","" }
{ "71896","72122","129902","5496","","","","","","","Vir","","942.648","6.060","-1.245","221.298779","-1.417529","M1III","M","1","","" }
{ "72881","73107","131774","5562","","","","","","","Cen","","637.024","6.060","-0.394","224.128612","-32.636784","K3III","K","1","","" }
{ "79381","79622","146001","6054","","","","","","","Sco","","485.352","6.060","0.197","243.722627","-25.476976","B8V","B","1","","" }
{ "80316","80558","148287","6124","","","","","","","Oph","","465.938","6.060","0.285","246.708645","2.347944","G8III","G","1","","" }
{ "35345","35442","57118","2785","","","","","","","CMa","","326156.378","6.060","-13.940","109.757999","-19.280304","F2Ia","F","1","","" }
{ "37141","37248","61966","2971","","","","","","","Car","","626.020","6.060","-0.356","114.751355","-53.273357","B9IV-Vp...","B","1","","" }
{ "37735","37843","62864","3010","","2    Pup","","2","","","Pup","","253.818","6.060","1.605","116.371387","-14.690537","A6/A7","A","1","","" }
{ "38210","38319","63589","3040","","","","","","","Gem","","229.850","6.060","1.820","117.759829","33.233653","A2m","A","1","","" }
{ "48695","48835","86523","3943","","","","","","","Vel","","1792.068","6.060","-2.640","149.427501","-48.414075","B3V","B","1","","" }
{ "50706","50851","89962","4077","","43    Leo","","43","","","Leo","","231.975","6.060","1.800","155.751864","6.542643","K3III","K","1","","" }
{ "53662","53818","95456","4298","","","","","","","Hya","","102.372","6.060","3.576","165.169963","-31.839368","F8V","F","1","","" }
{ "54977","55140","98292","4379","","","","","","","Car","","2434.003","6.060","-3.304","169.329291","-67.823515","M2III","M","1","","" }
{ "2846","2852","3326","151","","","","","","","Cet","","159.412","6.060","2.615","9.028587","-22.842333","A5m...","A","1","","" }
{ "3262","3269","3883","178","","","","","","","And","","413.379","6.060","0.545","10.400151","24.629008","A7m","A","1","","" }
{ "3481","3489","4294","199","","","","","","","Tuc","","285.851","6.060","1.346","11.131598","-62.497591","F5III/IV","F","1","","" }
{ "4970","4979","6288","301","","26    Cet","","26","","","Cet","","196.125","6.060","2.164","15.954284","1.366846","F1V","F","1","","" }
{ "13797","13832","18339","876","","","","","","","Per","","587.669","6.060","-0.219","44.509703","38.614926","K3III","K","1","","" }
{ "14329","14365","19066","923","","","","","","","Per","","406.172","6.060","0.584","46.337562","40.582181","K0III","K","1","","" }
{ "17395","17437","23049","1127","","","","","","","Per","","1019.239","6.060","-1.414","56.026781","48.523656","K4III","K","1","","" }
{ "19773","19823","26553","1296","","","","","","","Cam","","1399.813","6.060","-2.103","63.757486","57.460361","A4III","A","1","","" }
{ "20663","20715","28114","1397","","","","","","","Tau","","645.854","6.060","-0.424","66.587929","8.590269","B6IV","B","1","","" }
{ "21186","21239","28970","1447","","","","","","","Eri","","742.953","6.060","-0.728","68.342025","-10.785333","K0","K","1","","" }
{ "22435","22488","30985","1557","","","","","","","Cae","","171.391","6.060","2.457","72.567423","-41.320848","F1III-IV","F","1","","" }
{ "22789","22842","31069","1558","","","","","","","Aur","","311.813","6.060","1.158","73.713488","44.060861","A0V","A","1","","" }
{ "82529","82780","152863","6292","","56    Her","","56","","","Her","","446.178","6.060","0.380","253.759003","25.730681","G5III","G","1","","" }
{ "83247","83504","154278","6342","","","","","","","Her","","319.448","6.060","1.105","255.991842","13.567420","K1III","K","1","","" }
{ "83596","83853","154895","6367","","","","","","","Oph","","291.993","6.060","1.300","257.056875","-1.079476","A3V","A","1","","" }
{ "89319","89597","167257","6821","","","","","","","Tel","","397.267","6.060","0.632","274.253829","-51.068271","B9V","B","1","","" }
{ "91811","92098","173936","7073","","","","","","","Lyr","","911.051","6.060","-1.171","281.554205","41.441810","B6V","B","1","","" }
{ "91956","92243","174179","7081","","","","","","","Lyr","","1105.615","6.060","-1.591","281.989054","31.756835","B3IVp","B","1","","" }
{ "94872","95167","184102","7423","","","","","","","Dra","","351.462","6.060","0.898","290.417726","79.602830","A3V","A","1","","" }
{ "95679","95978","184958","7450","","","","","","","Dra","","609.638","6.060","-0.298","292.751184","70.989339","K2","K","1","","" }
{ "97581","97892","188793","7611","","","","","","","Cyg","","339.746","6.060","0.971","298.397514","59.708660","A3V","A","1","","" }
{ "102659","102989","198529","7979","","Bet Mic","Bet","","Bet","","Mic","","482.480","6.060","0.210","312.994835","-33.177974","A1IV","A","1","","" }
{ "103083","103414","199442","8017","","","","","","","Aqr","","306.538","6.060","1.195","314.294071","0.463779","K2III","K","1","","" }
{ "106830","107173","206540","8292","","","","","","","Peg","","699.906","6.060","-0.598","325.637323","10.824314","B5IV","B","1","","" }
{ "108149","108494","208735","8378","","","","","","","Cap","","1052.117","6.060","-1.483","329.682469","-21.182945","M2III","M","1","","" }
{ "111773","112127","214987","8639","","","","","","","Gru","","354.133","6.060","0.881","340.679473","-44.248036","K1IV","K","1","","" }
{ "116738","117105","222805","8994","","","","","","","Tuc","","151.771","6.060","2.721","356.104775","-70.490226","G8IV","G","1","","" }
{ "112276","112635","216102","8683","","","","","","","Cep","","587.669","6.070","-0.209","342.184365","62.938410","K0","K","1","","" }
{ "115665","116030","221293","8927","","","","","","","And","","680.911","6.070","-0.528","352.664817","38.662253","G9III","G","1","","" }
{ "116371","116737","222287","8966","","The Phe","The","","The","","Phe","","257.221","6.070","1.586","354.866408","-46.637799","A+...","A","1","","" }
{ "543","544","166","8","Gl 5","","","","","","And","","44.587","6.070","5.391","1.653134","29.021502","K0V","K","1","","" }
{ "1462","1465","1419","69","","","","","","","Psc","","501.779","6.070","0.135","4.571859","11.206214","K0III","K","1","","" }
{ "4175","4185","5118","249","","","","","","","And","","351.841","6.070","0.905","13.367590","37.418209","K3III:","K","1","","" }
{ "5472","5483","6966","344","","","","","","","Psc","","538.212","6.070","-0.018","17.547670","15.673912","M0III","M","1","","" }
{ "6507","6522","8065","386","","","","","","","Cep","","326156.378","6.070","-13.930","20.945055","78.726056","A0Iab","A","1","","" }
{ "8964","8983","11995","571","","","","","","","Hyi","","154.723","6.070","2.689","28.943643","-60.860975","F0IV/V","F","1","","" }
{ "9976","9999","13215","625","","","","","","","Cet","","923.956","6.070","-1.191","32.190255","-17.779155","M1III","M","1","","" }
{ "12128","12160","16187","757","","","","","","","Tri","","371.054","6.070","0.790","39.179315","31.607667","K0","K","1","","" }
{ "12551","12584","16824","795","","","","","","","Cet","","656.250","6.070","-0.448","40.451360","-3.213807","G9III:","G","1","","" }
{ "15080","15118","20063","966","","","","","","","Per","","237.723","6.070","1.757","48.735736","42.503637","K2III","K","1","","" }
{ "15831","15870","21050","1027","","65    Ari","","65","","","Ari","","312.111","6.070","1.166","51.108818","20.803489","A1V","A","1","","" }
{ "19254","19302","25975","1277","","49    Per","","49","","","Per","","143.808","6.070","2.848","62.064180","37.727493","K1III","K","1","","" }
{ "59171","59353","105776","4631","","","","","","","Cen","","236.003","6.070","1.773","182.640871","-37.870349","A5V","A","1","","" }
{ "60804","60992","108861","4762","","75    UMa","","75","","","UMa","","390.607","6.070","0.678","187.517676","58.767773","G8III-IV","G","1","","" }
{ "65743","65951","117710","5096","","","","","","","CVn","","262.184","6.070","1.544","202.815776","42.106153","K2III","K","1","","" }
{ "69019","69241","123377","5293","","","","","","","Cir","","326156.378","6.070","-13.930","212.628782","-70.305464","K4II","K","1","","" }
{ "69076","69298","123492","5295","","","","","","","Cir","","226.655","6.070","1.860","212.757975","-69.719318","A6IV","A","1","","" }
{ "70929","71154","127624","5428","","","","","","","Cen","","330.118","6.070","1.044","218.290196","-30.715068","K0III","K","1","","" }
{ "72082","72308","129932","5498","","","","","","","Lup","","2811.693","6.070","-3.608","221.802452","-52.205256","A1III/IV","A","1","","" }
{ "74265","74493","134967","5656","","25Iot2Lib","Iot-2","25","Iot","2","Lib","","227.922","6.070","1.848","228.329959","-19.647572","A2V","A","1","","" }
{ "75140","75369","137390","5732","","","","","","","Boo","","490.461","6.070","0.184","231.021332","45.271031","K2III","K","1","","" }
{ "77565","77801","142267","5911","GJ 3924","39    Ser","","39","","","Ser","","56.585","6.070","4.874","238.300415","13.196623","G0IV","G","1","","" }
{ "78337","78575","143619","5965","","","","","","","Sco","","438.382","6.070","0.428","240.664247","-29.135800","K2/K3III","K","1","","" }
{ "78446","78685","144046","5976","","43    Ser","","43","","","Ser","","360.793","6.070","0.851","240.940379","4.986834","G9III","G","1","","" }
{ "80664","80910","148760","6145","","","","","","","Sco","","223.701","6.070","1.889","247.845219","-26.537643","K1III","K","1","","" }
{ "81421","81670","150580","6208","","","","","","","Her","","430.854","6.070","0.465","250.252433","24.858705","K2","K","1","","" }
{ "81478","81728","150366","6193","","","","","","","Oph","","285.601","6.070","1.358","250.400757","-24.467962","A7III","A","1","","" }
{ "81762","82012","151388","6230","","","","","","","Her","","723.185","6.070","-0.659","251.299154","43.217169","K4III","K","1","","" }
{ "81911","82162","151431","6232","","19    Oph","","19","","","Oph","","541.788","6.070","-0.032","251.790639","2.064526","A3V","A","1","","" }
{ "29496","29569","42466","2188","","","","","","","Aur","","417.080","6.070","0.536","93.438926","51.172469","K1III","K","1","","" }
{ "29655","29728","43285","2231","","","","","","","Ori","","653.620","6.070","-0.439","93.917404","6.066166","B6V","B","1","","" }
{ "32418","32504","49333","2509","","12    CMa","","12","","","CMa","","787.817","6.070","-0.845","101.756182","-21.015402","B7II/III","B","1","","" }
{ "34675","34768","55111","2710","","","","","","","CMi","","549.085","6.070","-0.061","107.964097","5.654703","A1V","A","1","","" }
{ "38039","38147","63352","3030","","","","","","","Gem","","762.048","6.070","-0.773","117.257651","13.371869","K0","K","1","","" }
{ "40226","40341","69080","3239","","","","","","","Pup","","2264.975","6.070","-3.138","123.545979","-32.140711","B2V","B","1","","" }
{ "41245","41361","71487","3327","","","","","","","Pup","","560.406","6.070","-0.105","126.573882","-39.058956","B9IV/V","B","1","","" }
{ "42883","43002","74879","3483","","","","","","","Pyx","","338.688","6.070","0.988","131.455350","-25.388088","A3IV/V","A","1","","" }
{ "43697","43822","76369","3552","","17    Hya","","17","","","Hya","","288.634","6.070","1.335","133.873371","-7.971153","A3","A","1","","" }
{ "44214","44342","77190","3589","","67    Cnc","","67","","","Cnc","","189.186","6.070","2.253","135.453517","27.902593","A8Vn","A","1","","" }
{ "49785","49926","88647","4007","","","","","","","Car","","801.367","6.070","-0.882","152.897806","-58.827762","M5III","M","1","","" }
{ "49903","50044","88825","4018","","","","","","","Car","","2434.003","6.070","-3.294","153.254815","-59.918088","B4Ve","B","1","","" }
{ "51301","51448","90745","4108","","","","","","","UMa","","307.405","6.070","1.199","157.610933","64.257689","A7III","A","1","","" }
{ "54135","54294","96544","4323","","","","","","","Car","","1299.428","6.070","-1.932","166.622056","-58.675021","K2II/III","K","1","","" }
{ "54381","54540","96707","4330","","","","","","","UMa","","362.799","6.070","0.839","167.416112","67.210208","F0sp...","F","1","","" }
{ "82439","82691","152248","","","","","","","","Sco","","1358.985","6.070","-2.029","253.541926","-41.825040","O7e","O","1","","" }
{ "83224","83481","153791","6323","","","","","","","Ara","","493.429","6.070","0.171","255.923680","-47.160571","A2/A3V","A","1","","" }
{ "88819","89096","166006","6778","","","","","","","Tel","","567.228","6.070","-0.132","272.768357","-47.513121","K1III-IV","K","1","","" }
{ "90208","90487","170137","6925","","","","","","","Oph","","1181.726","6.070","-1.725","276.959669","3.748570","K3III","K","1","","" }
{ "90914","91196","172569","7013","","","","","","","Dra","","216.715","6.070","1.958","279.055239","65.488717","F0V","F","1","","" }
{ "93425","93720","177809","7238","","","","","","","Lyr","","645.854","6.070","-0.414","286.242853","30.733396","M2III","M","1","","" }
{ "98643","98959","189567","7644","Gl 776","","","","","","Pav","","57.819","6.070","4.827","301.383247","-67.320897","G2V","G","1","","" }
{ "101620","101949","197018","7911","","","","","","","Cyg","","923.956","6.070","-1.191","309.888813","40.579658","B6IIIp Mn","B","1","","" }
{ "103371","103703","199947","","","","","21","","","Cap","","523.525","6.070","0.042","315.215692","-17.530898","K3III","K","1","","" }
{ "104201","104538","201616","8098","","6    Equ","","6","","","Equ","","443.147","6.070","0.404","317.630476","10.048922","A2Vs","A","1","","" }
{ "104427","104765","202240","8120","","","","","","","Cyg","","1538.473","6.070","-2.298","318.360105","36.633263","F0III","F","1","","" }
{ "105217","105558","203630","8182","","","","","","","Cyg","","366.056","6.070","0.819","320.675227","30.309882","K1III","K","1","","" }
{ "106595","106938","206005","8273","","","","","","","Cap","","307.115","6.070","1.201","324.867122","-10.576896","K0","K","1","","" }
{ "106754","107097","206538","8291","","76    Cyg","","76","","","Cyg","","496.433","6.070","0.158","325.392743","40.805222","A2V","A","1","","" }
{ "83237","83494","154431","6351","","","","","","","Her","","179.305","6.080","2.379","255.973272","34.790222","A5V","A","1","","" }
{ "84053","84311","155341","6384","","","","","","","Ara","","1538.473","6.080","-2.288","258.555864","-56.888526","M1/2II/III+A","M","1","","" }
{ "84266","84524","156227","6413","","","","","","","Oph","","364.014","6.080","0.842","259.178115","-6.244975","K0","K","1","","" }
{ "86209","86476","160471","6578","","","","","","","Oph","","512.824","6.080","0.097","265.049761","-2.152301","K2.5Ib","K","1","","" }
{ "87654","87926","161988","6635","","","","","","","Aps","","606.239","6.080","-0.266","269.423678","-76.177949","K2III","K","1","","" }
{ "92236","92524","174589","7101","","8    Aql","","8","","","Aql","","256.412","6.080","1.602","282.842323","-3.317857","F2III","F","1","","" }
{ "93671","93966","178428","7260","Gl 746","","","","","","Sge","","69.901","6.080","4.425","286.988834","16.853385","G5V","G","1","","" }
{ "95599","95898","183589","7412","","","","","","","Aql","","2025.816","6.080","-2.886","292.543895","2.904073","K5Ib","K","1","","" }
{ "96575","96882","184996","7455","","","","","","","Pav","","605.114","6.080","-0.262","295.405217","-65.854414","M0III","M","1","","" }
{ "96721","97028","186440","7505","","","","","","","Cyg","","362.799","6.080","0.849","295.789987","30.677891","A1V","A","1","","" }
{ "100438","100764","194184","7799","","","","","","","Sgr","","341.883","6.080","0.978","306.449779","-40.796184","K3III","K","1","","" }
{ "101590","101919","196821","7903","","","","","","","Vul","","718.406","6.080","-0.635","309.794363","21.817444","A0III","A","1","","" }
{ "105520","105860","204188","8210","","","","","","","Peg","","151.208","6.080","2.749","321.611081","19.375640","A8m","A","1","","" }
{ "108930","109276","210210","8441","","","","","","","Peg","","287.616","6.080","1.353","332.071836","25.543522","F1IV","F","1","","" }
{ "59213","59396","105841","4634","","","","","","","Cru","","310.921","6.080","1.184","182.771581","-61.277425","F0III","F","1","","" }
{ "68454","68673","122532","5269","","","","","","","Cen","","716.827","6.080","-0.630","210.864477","-41.423345","B8 Si","B","1","","" }
{ "73082","73309","132375","5583","","","","","","","Lib","","110.151","6.080","3.437","224.719931","-4.989256","F8V","F","1","","" }
{ "81410","81659","150483","6203","","","","","","","Her","","312.710","6.080","1.171","250.213921","12.395043","A3Vn","A","1","","" }
{ "115068","115433","220263","8889","","","","","","","Tuc","","849.366","6.080","-0.998","350.736362","-60.055843","M3III","M","1","","" }
{ "116708","117075","222803","8993","","","","","","","Phe","","225.714","6.080","1.879","356.005174","-45.083123","G8IV","G","1","","" }
{ "116973","117340","223229","9011","","","","","","","And","","1042.033","6.080","-1.442","356.887705","46.832564","B3IV","B","1","","" }
{ "1934","1939","2023","94","","","","","","","Psc","","494.926","6.080","0.174","6.123538","-2.219064","K1III","K","1","","" }
{ "4356","4366","5382","262","","67    Psc","","67","","","Psc","","253.621","6.080","1.626","13.993794","27.209381","A5IV","A","1","","" }
{ "14783","14819","19836","955","","","","","","","Eri","","862.848","6.080","-1.033","47.828235","-3.811595","M1III","M","1","","" }
{ "20059","20109","27604","1365","","","","","","","Dor","","234.983","6.080","1.792","64.666698","-52.860097","A8V+...","A","1","","" }
{ "20297","20347","27710","1374","","","","","","","Eri","","191.631","6.080","2.235","65.380470","-25.728580","F2V","F","1","","" }
{ "23688","23743","32357","1623","","12    Cam","","12","","","Cam","","713.690","6.080","-0.620","76.550576","59.021340","K0III","K","1","","" }
{ "24292","24349","33883","1701","","","","","","","Ori","","692.476","6.080","-0.555","78.381487","1.967684","A5V","A","1","","" }
{ "25468","25532","35991","1823","","","","","","","Lep","","391.075","6.080","0.686","81.902082","-21.375713","K0III","K","1","","" }
{ "26298","26363","36891","1884","","","","","","","Aur","","326156.378","6.080","-13.920","84.218403","40.182375","G3Ib","G","1","","" }
{ "28606","28677","40801","2119","","38    Aur","","38","","","Aur","","212.757","6.080","2.008","90.824727","42.911564","K0III","K","1","","" }
{ "29275","29347","42729","2206","","","","","","","Lep","","675.272","6.080","-0.500","92.806902","-26.482100","B9.5IV/V","B","1","","" }
{ "31091","31168","46178","2378","","","","","","","Mon","","686.645","6.080","-0.537","98.096977","11.673520","K0III","K","1","","" }
{ "39972","40085","68099","3201","","","","","","","Cnc","","876.764","6.080","-1.067","122.819163","9.821230","B6III","B","1","","" }
{ "41145","41262","70771","3292","","","","","","","Lyn","","872.076","6.080","-1.056","126.270367","35.011409","K0","K","1","","" }
{ "44188","44315","77250","3590","","","","","","","Hya","","1038.714","6.080","-1.435","135.380778","5.640986","F3IV+...","F","1","","" }
{ "48259","48396","85519","3908","","","","","","","Hya","","390.607","6.080","0.688","147.998059","-16.534775","K0III","K","1","","" }
{ "50150","50292","89033","4034","","","","","","","Sex","","643.307","6.080","-0.395","154.037493","-11.203419","K0","K","1","","" }
{ "51999","52150","92682","4186","","","","","","","Car","","1424.264","6.080","-2.121","159.816362","-74.493384","K3II","K","1","","" }
{ "53224","53379","94660","4263","","","","","","","Vel","","488.990","6.080","0.201","163.754223","-42.251098","A0p...","A","1","","" }
{ "28615","28686","41076","2133","","","","","","","Ori","","518.532","6.090","0.083","90.853199","11.681065","A0Vs","A","1","","" }
{ "29632","29705","43362","2237","","","","","","","Mon","","698.408","6.090","-0.563","93.858952","-9.035757","B9III","B","1","","" }
{ "29716","29789","43261","2230","","8    Gem","","8","","","Gem","","446.790","6.090","0.407","94.079361","23.970027","G8III","G","1","","" }
{ "31733","31813","47358","2436","","","","","","","Gem","","421.391","6.090","0.534","99.772081","22.030881","G9III","G","1","","" }
{ "34054","34142","53629","2664","","","","","","","CMa","","345.505","6.090","0.965","106.196045","-22.031688","K2IIICN...","K","1","","" }
{ "34163","34253","54153","2685","","","","","","","Pup","","669.726","6.090","-0.472","106.509434","-38.382854","G0III","G","1","","" }
{ "34228","34318","54173","2686","","","","","","","CMa","","916.170","6.090","-1.153","106.718652","-24.960572","K2III","K","1","","" }
{ "37300","37406","61106","2929","","23    Lyn","","23","","","Lyn","","698.408","6.090","-0.563","115.206432","57.082865","K5III","K","1","","" }
{ "38732","38845","65442","3111","","","","","","","Pup","","767.427","6.090","-0.768","119.240936","-42.406475","K3III","K","1","","" }
{ "39229","39340","65448","3112","","","","","","","Cam","","378.811","6.090","0.765","120.628400","63.090306","G1III","G","1","","" }
{ "43084","43204","75140","3493","","","","","","","Hya","","704.441","6.090","-0.582","132.020322","-6.558839","K0","K","1","","" }
{ "47881","48017","83727","3847","","","","","","","Dra","","428.027","6.090","0.500","146.825496","79.136680","F0V:","F","1","","" }
{ "49153","49293","87262","3959","","","","","","","Sex","","1156.583","6.090","-1.659","150.920777","-9.573792","K0","K","1","","" }
{ "51527","51676","91619","4147","","","","","","","Car","","326156.378","6.090","-13.910","158.355803","-58.190149","B7Ia","B","1","","" }
{ "51667","51816","91805","4154","","","","","","","Vel","","1136.434","6.090","-1.621","158.793429","-43.664587","G8/K0II/III","G","1","","" }
{ "54056","54214","96220","4315","","","","","","","Crt","","194.720","6.090","2.210","166.391644","-11.088901","F0Vn","F","1","","" }
{ "112874","113234","216761","8719","","","","","","","PsA","","1320.471","6.090","-1.947","343.964726","-31.633231","K3III","K","1","","" }
{ "117053","117420","223311","9014","","","","","","","Aqr","","795.503","6.090","-0.846","357.135334","-6.380426","K4III","K","1","","" }
{ "117563","117931","224113","9049","","","","","","","Scl","","883.893","6.090","-1.075","358.819103","-31.921467","B6/B7","B","1","","" }
{ "119433","","206827","8310","Gl 836.6B","78Mu 2Cyg","Mu-2","78","Mu","2","Cyg","","73.064","6.090","4.339","326.032633","28.743078","G2 V","G","2","106967","Gl 836.6" }
{ "84231","84489","155974","6405","","","","","","","Sco","","102.533","6.090","3.603","259.090070","-35.750297","F6V","F","1","","" }
{ "85043","85302","157967","6495","","","","","","","Her","","620.069","6.090","-0.305","261.476521","16.917578","M4III","M","1","","" }
{ "85801","86064","159018","6530","","","","","","","Ara","","956.470","6.090","-1.246","263.832948","-53.352928","B9III","B","1","","" }
{ "86046","86311","159707","6558","","","","","","","Sco","","988.353","6.090","-1.317","264.535177","-42.880274","B8V","B","1","","" }
{ "86904","87174","161420","6614","","","","","","","Ara","","172.661","6.090","2.471","267.158631","-55.401742","A9IV","A","1","","" }
{ "87108","87379","161917","6632","","","","","","","Ara","","508.824","6.090","0.124","267.796000","-53.130269","B9.5III/IV","B","1","","" }
{ "87133","87404","162123","6640","","","","","","","Ara","","842.781","6.090","-0.971","267.935656","-45.600706","G6III","G","1","","" }
{ "87473","87744","163929","6699","","","","","","","Dra","","183.854","6.090","2.335","268.848493","55.971394","F0IV","F","1","","" }
{ "88746","89023","166479","6803","","","","","","","Her","","860.571","6.090","-1.017","272.536365","16.476590","B9V+...","B","1","","" }
{ "92841","93134","175794","7151","","","","","","","Sgr","","449.871","6.090","0.392","284.588685","-31.035975","K3III","K","1","","" }
{ "94634","94929","180928","7317","","","","","","","Sgr","","481.767","6.090","0.243","289.750410","-15.536570","K4III","K","1","","" }
{ "94940","95235","182272","7359","","","","","","","Lyr","","358.414","6.090","0.885","290.638969","33.518163","K0III","K","1","","" }
{ "95630","95929","183656","7415","","","","","","","Aql","","809.321","6.090","-0.883","292.638010","3.444403","A0sh","A","1","","" }
{ "99443","99762","191603","7707","","","","","","","Pav","","231.317","6.090","1.836","303.612227","-63.415789","F0IV","F","1","","" }
{ "100000","100325","193452","7775","","","","","","","Cap","","339.393","6.090","1.004","305.193948","-14.784892","B9.5III/IV","B","1","","" }
{ "100160","100486","194097","7797","","","","","","","Cyg","","577.268","6.090","-0.150","305.655450","31.264966","K2","K","1","","" }
{ "100691","101017","194783","7817","","","","","","","Mic","","712.132","6.090","-0.606","307.194738","-35.595863","B8II/III","B","1","","" }
{ "101299","101626","195402","7838","","","","","","","Pav","","626.020","6.090","-0.326","308.965361","-69.610586","K2III","K","1","","" }
{ "105427","105768","203212","8159","","","","","","","Pav","","560.406","6.090","-0.085","321.325095","-71.799061","K2III","K","1","","" }
{ "55812","55979","99872","4425","","","","","","","Mus","","784.030","6.090","-0.815","172.076866","-72.473977","B3V","B","1","","" }
{ "56620","56789","101133","4480","","60    UMa","","60","","","UMa","","323.568","6.090","1.107","174.639677","46.834209","F5IIIs","F","1","","" }
{ "60417","60603","108110","4723","","","","","","","Hya","","561.371","6.090","-0.089","186.326711","-27.749002","K3III","K","1","","" }
{ "65577","65783","117025","5069","","","","","","","Mus","","282.631","6.090","1.401","202.283119","-64.675794","A2m","A","1","","" }
{ "68213","68431","121439","5240","","","","","","","Aps","","782.150","6.090","-0.809","210.136856","-78.589981","B9III","B","1","","" }
{ "69269","69491","124195","5311","","","","","","","Cen","","1028.884","6.090","-1.405","213.415969","-54.625627","B5V","B","1","","" }
{ "72738","72965","131058","5539","","Zet Cir","Zet","","Zet","","Cir","","1274.048","6.090","-1.869","223.677445","-65.991095","B3Vn","B","1","","" }
{ "74251","74479","134837","5653","","","","","","","Lup","","393.909","6.090","0.680","228.281937","-36.091425","B8V","B","1","","" }
{ "79092","79332","145647","6035","","","","","","","Her","","405.163","6.090","0.619","242.869740","16.665692","A0V","A","1","","" }
{ "79451","79692","146254","6061","","","","","","","Sco","","582.422","6.090","-0.169","243.964562","-14.849115","A0III","A","1","","" }
{ "80544","80788","148218","6120","","","","","","","Nor","","326156.378","6.090","-13.910","247.438421","-57.756323","G8Ib","G","1","","" }
{ "394","394","225239","9107","GJ 3002","","","","","","And","","127.804","6.090","3.124","1.223597","34.659797","G2V","G","1","","" }
{ "5111","5121","6482","315","","27    Cet","","27","","","Cet","","303.119","6.090","1.249","16.403679","-9.979323","K0III","K","1","","" }
{ "8801","8820","11643","554","","","","","","","For","","362.396","6.090","0.861","28.346466","-38.594632","K1/K2III","K","1","","" }
{ "9276","9295","12140","578","","","","","","","Ari","","321.653","6.090","1.120","29.857854","12.294876","A6V","A","1","","" }
{ "9299","9318","12477","600","","","","","","","Hyi","","445.569","6.090","0.413","29.921248","-66.066558","K2III","K","1","","" }
{ "10153","10176","13294","628","","59    And","","59","","","And","","455.526","6.090","0.365","32.720124","39.039526","B9V","B","1","","" }
{ "11576","11603","15453","725","","","","","","","Cet","","334.863","6.090","1.033","37.397321","9.565629","K2III","K","1","","" }
{ "12578","12611","17006","807","","","","","","","Eri","","135.503","6.090","2.997","40.535171","-46.524441","G8IV","G","1","","" }
{ "15949","15988","21071","1029","","","","","","","Per","","520.186","6.090","0.076","51.489058","49.120757","B7V","B","1","","" }
{ "17411","17453","23258","1137","","","","","","","Tau","","253.424","6.090","1.638","56.117510","20.928737","A0V","A","1","","" }
{ "17665","17707","23383","1147","","","","","","","Cam","","359.599","6.090","0.878","56.883897","55.921960","B9Vnn","B","1","","" }
{ "18434","18481","24817","1224","","","","","","","Tau","","229.042","6.090","1.858","59.257158","6.039967","A2Vn","A","1","","" }
{ "19592","19641","26546","1295","","","","","","","Tau","","342.601","6.090","0.983","63.130639","17.277460","K0III","K","1","","" }
{ "20056","20106","27411","1353","","","","","","","Eri","","293.043","6.090","1.322","64.656206","-22.969722","A3m...","A","1","","" }
{ "21189","21242","28704","1434","","57    Per","","57","","","Per","","192.992","6.090","2.229","68.353760","43.063893","F0V","F","1","","" }
{ "21245","21298","29063","1450","","","","","","","Eri","","716.827","6.090","-0.620","68.559139","-6.837809","K2III","K","1","","" }
{ "21981","22034","29866","1500","","","","","","","Per","","611.926","6.090","-0.276","71.054240","40.786454","B8IVn","B","1","","" }
{ "22388","22441","30605","1537","","96    Tau","","96","","","Tau","","1087.188","6.090","-1.524","72.433674","15.904221","K3III","K","1","","" }
{ "23162","23216","31579","1588","","8    Cam","","8","","","Cam","","575.232","6.090","-0.142","74.943056","53.155451","K4III","K","1","","" }
{ "25153","25216","35189","1774","","110    Tau","","110","","","Tau","","407.186","6.090","0.608","80.907109","16.699298","A2IV","A","1","","" }
{ "25254","25317","35765","1813","","","","","","","Pic","","472.690","6.090","0.284","81.231574","-44.225684","K1III","K","1","","" }
{ "27052","27118","38309","1978","","","","","","","Ori","","191.970","6.090","2.241","86.257466","4.008111","F0III:n","F","1","","" }
{ "1498","1501","1438","70","","26    And","","26","","","And","","661.575","6.100","-0.436","4.675682","43.791141","B8V","B","1","","" }
{ "4490","4501","5526","272","","","","","","","And","","437.207","6.100","0.464","14.415177","45.839379","K2III","K","1","","" }
{ "9066","9085","12042","573","Gl 81.3","","","","","","Eri","","87.629","6.100","3.954","29.249415","-51.766244","F8V","F","1","","" }
{ "14356","14392","18991","920","","","","","","","Per","","252.053","6.100","1.660","46.417331","56.068965","G9III","G","1","","" }
{ "17433","17475","23139","1130","","","","","","","Per","","463.290","6.100","0.338","56.170457","46.099813","A7IV","A","1","","" }
{ "20729","20781","28454","1418","","","","","","","Cae","","108.070","6.100","3.499","66.774816","-46.947505","F8V","F","1","","" }
{ "22902","22955","31327","1573","","","","","","","Aur","","326156.378","6.100","-13.900","74.083695","36.168537","B2Ib","B","1","","" }
{ "23562","23617","31590","1589","","","","","","","Cam","","558.487","6.100","-0.068","76.165238","74.066955","A1V","A","1","","" }
{ "23625","23680","32736","1648","","","","","","","Ori","","1230.779","6.100","-1.784","76.348819","1.177627","N5","N","1","","" }
{ "25036","25098","35580","1801","","Kap Pic","Kap","","Kap","","Pic","","634.545","6.100","-0.345","80.592287","-56.134401","B8/B9V","B","1","","" }
{ "26235","26300","37434","1927","","","","","","","Pic","","505.669","6.100","0.148","84.011867","-47.313746","K2III","K","1","","" }
{ "26250","26315","36719","1869","","","","","","","Aur","","340.101","6.100","1.009","84.066481","47.715290","F0V:","F","1","","" }
{ "26329","26395","37306","1919","","","","","","","Lep","","205.130","6.100","2.107","84.286551","-11.775515","A2V","A","1","","" }
{ "87400","87671","162817","6668","","","","","","","Sco","","707.497","6.100","-0.581","268.613008","-34.466722","B9.5/A0III","B","1","","" }
{ "89248","89527","167654","6834","","","","","","","Oph","","772.882","6.100","-0.773","274.023215","2.377517","M4III","M","1","","" }
{ "90837","91119","171780","6984","","","","","","","Lyr","","832.031","6.100","-0.934","278.806268","34.458021","B5Vn","B","1","","" }
{ "91323","91606","173398","7042","","","","","","","Dra","","362.396","6.100","0.871","280.235013","62.749466","K0III","K","1","","" }
{ "92262","92551","174959","7115","","","","","","","Lyr","","1022.434","6.100","-1.381","282.902158","36.539092","B6IV","B","1","","" }
{ "96417","96724","185837","7481","","","","","","","Cyg","","488.990","6.100","0.221","294.937175","33.978938","A3IV","A","1","","" }
{ "97733","98044","189127","7626","","","","","","","Cyg","","438.382","6.100","0.458","298.841897","58.250193","G9III","G","1","","" }
{ "100432","100758","194454","7809","","","","","","","Aql","","525.212","6.100","0.065","306.427187","-2.800378","K1III:","K","1","","" }
{ "100895","101221","195330","7837","","","","","","","Cap","","381.024","6.100","0.762","307.767950","-15.056168","K1/K2III+..","K","1","","" }
{ "103314","103646","199684","8031","","","","","","","Mic","","131.303","6.100","3.076","314.998662","-36.129641","F2V","F","1","","" }
{ "103562","103894","200577","8063","","","","","","","Cyg","","718.406","6.100","-0.615","315.770152","38.657415","G8III","G","1","","" }
{ "105499","105841","203760","8188","","Gam Ind","Gam","","Gam","","Ind","","218.019","6.100","1.975","321.564328","-54.660459","F1III","F","1","","" }
{ "105902","106243","204862","8231","","","","","","","Peg","","493.429","6.100","0.201","322.790117","12.137475","B9.5V","B","1","","" }
{ "106361","106703","205529","8256","","7    PsA","","7","","","PsA","","241.062","6.100","1.756","324.203301","-33.047896","A5V","A","1","","" }
{ "106843","107186","206731","8304","","","","","","","Cyg","","1016.064","6.100","-1.367","325.661707","49.600257","G8II","G","1","","" }
{ "106854","107197","206842","8312","","","","","","","Cep","","1094.485","6.100","-1.529","325.689039","59.270844","K1III","K","1","","" }
{ "107321","107664","207516","8338","","","","","","","Cyg","","474.755","6.100","0.285","327.122314","38.648575","B8V","B","1","","" }
{ "109163","109509","210464","8457","","","","","","","Aqr","","183.750","6.100","2.346","332.759901","-21.232790","F6/F7V","F","1","","" }
{ "32247","32332","50002","2536","","","","","","","Vol","","637.024","6.100","-0.354","101.231936","-70.433758","K3III","K","1","","" }
{ "32954","33041","50018","2539","","59    Aur","","59","","","Aur","","491.199","6.100","0.211","103.255878","38.869157","F2V","F","1","","" }
{ "34248","34338","53929","2676","","","","","","","Mon","","664.270","6.100","-0.445","106.776963","4.910582","B9.5III","B","1","","" }
{ "34689","34782","55568","2720","","","","","","","CMa","","155.091","6.100","2.714","108.017057","-30.821365","A8III/IV","A","1","","" }
{ "37746","37854","63382","3031","","","","","","","Car","","891.138","6.100","-1.083","116.397995","-56.722570","F0II","F","1","","" }
{ "42809","42928","74706","3473","","","","","","","Pyx","","275.237","6.100","1.469","131.229788","-21.167826","A5V","A","1","","" }
{ "43228","43351","76270","3544","","","","","","","Vol","","2038.477","6.100","-2.879","132.458892","-72.551240","A3m...","A","1","","" }
{ "44580","44708","78548","3629","","","","","","","Vel","","1090.824","6.100","-1.522","136.641812","-55.802411","B2IV-V","B","1","","" }
{ "45053","45184","79193","3655","","21    Hya","","21","","","Hya","","282.876","6.100","1.409","138.108513","-7.109827","A3m","A","1","","" }
{ "48082","48218","85040","3889","","20    Leo","","20","","","Leo","","624.821","6.100","-0.312","147.458734","21.179422","A8IV","A","1","","" }
{ "51100","51245","90798","4111","","","","","","","Vel","","731.292","6.100","-0.653","157.008707","-49.405801","K4III","K","1","","" }
{ "51646","51795","91706","4149","","","","","","","Hya","","215.001","6.100","2.005","158.740436","-23.176248","F6V","F","1","","" }
{ "51961","52112","92328","4175","","","","","","","Vel","","645.854","6.100","-0.384","159.709657","-42.753443","Am+...","A","1","","" }
{ "109555","109902","211053","8484","","","","","","","Gru","","623.626","6.100","-0.307","333.895985","-44.451499","G8/K0III","G","1","","" }
{ "115941","116307","221662","8942","","","","","","","Peg","","905.990","6.100","-1.118","353.481215","20.840934","M3III","M","1","","" }
{ "119491","","","","Gl 855.1B","","","","","","Ind","","94.265","6.100","3.795","336.121814","-72.256978","","","2","110271","Gl 855.1" }
{ "55363","55528","98892","4393","","","","","","","Cen","","351.083","6.100","0.940","170.596337","-44.645924","G8III","G","1","","" }
{ "57039","57211","101995","4513","","","","","","","Cen","","460.023","6.100","0.353","175.970133","-62.878280","A2III/IV","A","1","","" }
{ "60405","60591","108063","4721","","","","","","","Cen","","176.015","6.100","2.439","186.285609","-42.514312","G4IV","G","1","","" }
{ "64291","64496","114889","4992","","","","","","","Com","","346.606","6.100","0.968","198.301713","18.727008","G8III","G","1","","" }
{ "65171","65376","116581","5052","","","","","","","CVn","","1160.699","6.100","-1.656","200.974698","37.033920","M3III","M","1","","" }
{ "65685","65892","117436","5088","","72    Vir","","72","","","Vir","","173.580","6.100","2.470","202.607183","-6.470265","F2V","F","1","","" }
{ "67500","67714","120934","5220","","","","","","","Boo","","339.040","6.100","1.016","208.076690","12.165135","A1V","A","1","","" }
{ "69401","69623","124576","5324","","","","","","","Hya","","551.872","6.100","-0.042","213.755233","-29.281904","A1V","A","1","","" }
{ "70048","70270","125721","5375","","","","","","","Lup","","2188.969","6.100","-3.034","215.661317","-48.319857","B1III","B","1","","" }
{ "70728","70952","127821","5436","","","","","","","Dra","","103.673","6.100","3.589","217.692483","63.185788","F4IV","F","1","","" }
{ "71870","72097","129462","5486","","","","","","","Cir","","335.897","6.100","1.036","221.231332","-58.477492","K0III","K","1","","" }
{ "71895","72121","129557","5488","","","","","","","Cir","","1148.438","6.100","-1.633","221.295676","-55.601640","B2III","B","1","","" }
{ "73127","73354","132242","5580","","","","","","","Lup","","834.160","6.100","-0.939","224.863318","-43.159833","F5III","F","1","","" }
{ "75514","75742","137465","5738","","","","","","","Lup","","1560.557","6.100","-2.299","232.113381","-51.597934","G2Ib","G","1","","" }
{ "76104","76337","139074","5795","","15Tau3Ser","Tau-3","15","Tau","3","Ser","","379.252","6.100","0.772","233.888468","17.655555","G8III:","G","1","","" }
{ "78119","78355","142919","5937","","","","","","","Nor","","1006.656","6.100","-1.347","239.975603","-54.020911","B5IV","B","1","","" }
{ "78487","78726","143902","5974","","","","","","","Lup","","357.628","6.100","0.900","241.074257","-33.213718","F3III","F","1","","" }
{ "82202","82453","151771","6244","","","","","","","Sco","","1113.162","6.100","-1.566","252.750143","-37.514512","B8II/III","B","1","","" }
{ "59568","59750","106516","4657","","","","","","","Vir","","72.901","6.110","4.363","183.793989","-10.312400","F5V","F","1","","" }
{ "61212","61404","109372","","","","","","","","Mus","","1098.170","6.110","-1.526","188.726903","-67.756894","M6II/III","M","1","","" }
{ "62199","62394","111164","4855","","34    Vir","","34","","","Vir","","271.571","6.110","1.508","191.806839","11.958088","A3V","A","1","","" }
{ "62678","62875","111998","4891","GJ 9421","38    Vir","","38","","","Vir","","106.761","6.110","3.535","193.296488","-3.553098","F5V","F","1","","" }
{ "63009","63211","112570","4919","","","","","","","CVn","","340.455","6.110","1.017","194.282490","46.176789","K0III-IV","K","1","","" }
{ "65878","66086","117876","5102","","","","","","","Com","","438.972","6.110","0.465","203.200879","24.346743","G8III","G","1","","" }
{ "66364","66574","118344","5119","","","","","","","Mus","","424.130","6.110","0.540","204.690803","-70.444829","K3III","K","1","","" }
{ "67482","67696","120759","5212","","","","","","","Cen","","171.842","6.110","2.501","208.004078","-31.619207","F5/F6V","F","1","","" }
{ "75113","75342","137006","5721","","8    Ser","","8","","","Ser","","166.746","6.110","2.567","230.932129","-1.022384","F0V","F","1","","" }
{ "77338","77574","141296","5872","","","","","","","Nor","","147.649","6.110","2.831","237.567933","-45.401714","F0V","F","1","","" }
{ "77842","78078","142703","5930","","","","","","","Lib","","166.661","6.110","2.568","239.139053","-14.829438","A2Ib/II","A","1","","" }
{ "79824","80066","146954","6080","","","","","","","Sco","","459.375","6.110","0.366","245.135913","-39.430344","B9V","B","1","","" }
{ "80272","80514","148228","6121","","","","","","","Her","","356.845","6.110","0.915","246.547444","11.407493","G8III","G","1","","" }
{ "27868","27937","40200","2089","","","","","","","Pic","","1120.812","6.110","-1.571","88.671336","-49.627010","B3V","B","1","","" }
{ "30334","30407","44816","2301","","","","","","","Mon","","1456.055","6.110","-2.139","95.899658","-9.874727","K5","K","1","","" }
{ "31594","31674","47366","2437","","","","","","","CMa","","260.925","6.110","1.595","99.419970","-12.985116","K1III:","K","1","","" }
{ "32689","32775","50571","2562","","","","","","","Pic","","109.669","6.110","3.477","102.504217","-60.249146","F7III-IV","F","1","","" }
{ "36701","36807","60646","2913","","","","","","","Pup","","268.441","6.110","1.533","113.553467","-33.463430","A9IV","A","1","","" }
{ "38138","38246","63822","3051","","","","","","","Pup","","1090.824","6.110","-1.512","117.523623","-19.523548","K1III","K","1","","" }
{ "40209","40324","69082","3241","","","","","","","Pup","","1148.438","6.110","-1.623","123.494587","-36.340777","B2IV/V","B","1","","" }
{ "40811","40926","70982","3298","","","","","","","Car","","467.273","6.110","0.329","125.281850","-64.106002","G6/G8III","G","1","","" }
{ "41046","41163","70734","3290","","21    Cnc","","21","","","Cnc","","888.710","6.110","-1.067","125.980045","10.632063","M2III","M","1","","" }
{ "41203","41319","71030","3299","","25    Cnc","","25","","","Cnc","","146.587","6.110","2.847","126.457838","17.046267","F6V","F","1","","" }
{ "41788","41907","73468","3417","","","","","","","Vol","","395.341","6.110","0.692","128.174350","-73.356790","G8III","G","1","","" }
{ "46707","46840","82543","3794","","","","","","","Hya","","380.579","6.110","0.775","143.172476","1.864151","F7IV-V","F","1","","" }
{ "48803","48943","86612","3946","","","","","","","Hya","","797.448","6.110","-0.831","149.776273","-23.950770","B5V","B","1","","" }
{ "49119","49259","87363","3964","","","","","","","Vel","","293.570","6.110","1.339","150.835784","-46.636191","A0V","A","1","","" }
{ "54027","54185","96224","4316","","","","","","","Vel","","488.258","6.110","0.234","166.267176","-49.392299","B9V","B","1","","" }
{ "54583","54742","97411","4347","","Psi Crt","Psi","","Psi","","Crt","","501.779","6.110","0.175","168.126553","-18.499862","A0V","A","1","","" }
{ "54943","55106","98088","4369","","","","","","","Crt","","422.482","6.110","0.548","169.242406","-7.134689","A2p...","A","1","","" }
{ "366","365","225218","9105","","","","","","","And","","1259.291","6.110","-1.824","1.152455","42.092530","B9III","B","1","","" }
{ "694","696","402","18","","","","","","","Cet","","1885.297","6.110","-2.700","2.139568","-17.578155","M0/M1IIICNp","M","1","","" }
{ "1412","1415","1337","65","","","","","","","Cas","","2398.209","6.110","-3.222","4.429430","51.433090","O9IIInn","O","1","","" }
{ "2623","2629","3112","139","","The Tuc","The","","The","","Tuc","","424.130","6.110","0.540","8.346951","-71.266246","A7IV","A","1","","" }
{ "3677","3685","4490","214","","59    Psc","","59","","","Psc","","328.125","6.110","1.097","11.806763","19.578702","F0Vn","F","1","","" }
{ "4353","4363","5445","268","","","","","","","Scl","","953.674","6.110","-1.220","13.981399","-27.775839","M1/M2III","M","1","","" }
{ "5981","5993","7647","372","","","","","","","And","","698.408","6.110","-0.543","19.271087","44.901992","K5","K","1","","" }
{ "7257","7271","10042","467","","","","","","","Hyi","","406.679","6.110","0.631","23.413516","-78.504820","G3IV","G","1","","" }
{ "7347","7361","9742","453","","","","","","","Scl","","373.177","6.110","0.818","23.711632","-31.892317","K0/K1III","K","1","","" }
{ "11497","11524","15471","727","","","","","","","For","","358.808","6.110","0.903","37.147643","-31.102445","K2IIICN...","K","1","","" }
{ "13963","13997","18552","894","","","","","","","Per","","657.573","6.110","-0.413","45.049545","38.131740","B8Vn","B","1","","" }
{ "14006","14040","18760","904","","7    Eri","","7","","","Eri","","832.031","6.110","-0.924","45.211999","-2.878618","M2III","M","1","","" }
{ "14713","14749","19948","960","","","","","","","Hor","","438.382","6.110","0.468","47.613523","-48.734156","K1III","K","1","","" }
{ "14785","14821","19789","952","","","","","","","Ari","","428.027","6.110","0.520","47.841329","13.047845","K0IIIp","K","1","","" }
{ "17140","17181","22805","1118","","11    Tau","","11","","","Tau","","477.535","6.110","0.282","55.192954","25.329492","A2IV","A","1","","" }
{ "20205","20255","27429","1354","","","","","","","Tau","","157.564","6.110","2.690","65.104606","18.742608","F3:V...","F","1","","" }
{ "20713","20765","28312","1410","","","","","","","Eri","","318.512","6.110","1.162","66.737209","-24.081323","A3V","A","1","","" }
{ "21665","21718","29610","1488","","","","","","","Eri","","716.827","6.110","-0.600","69.946758","-1.052459","K0","K","1","","" }
{ "22544","22597","30870","1553","","","","","","","Ori","","609.638","6.110","-0.248","72.930765","9.975078","B5V","B","1","","" }
{ "22791","22844","31746","1597","","","","","","","Dor","","99.166","6.110","3.695","73.720761","-58.547652","F3V","F","1","","" }
{ "22794","22847","31529","1584","","","","","","","Cae","","1230.779","6.110","-1.774","73.728394","-39.628607","K3III","K","1","","" }
{ "23456","23511","32188","1615","","","","","","","Aur","","1988.758","6.110","-2.816","75.827654","41.441646","A2sh","A","1","","" }
{ "23986","24041","33419","1681","","","","","","","Ori","","325.181","6.110","1.117","77.513590","-0.565323","K0III","K","1","","" }
{ "26349","26414","37232","1913","","","","","","","Ori","","1124.677","6.110","-1.578","84.330459","8.951875","B2IV-V","B","1","","" }
{ "83104","83359","154633","6360","","","","","","","Dra","","377.496","6.110","0.793","255.565683","64.600739","G5V","G","1","","" }
{ "83318","83575","154732","6363","","","","","","","Her","","366.056","6.110","0.859","256.207342","48.803958","K1III","K","1","","" }
{ "85855","86118","159834","6559","","","","","","","Her","","368.122","6.110","0.847","263.998201","20.996242","A7IV","A","1","","" }
{ "87855","88127","166865","6809","","40    Dra","","40","","","Dra","","236.860","6.110","1.805","270.014155","80.000841","K2Vvar","K","1","","" }
{ "93230","93523","177199","7216","","","","","","","Sge","","805.324","6.110","-0.853","285.719253","19.661011","K1III","K","1","","" }
{ "93849","94144","178555","7265","","","","","","","Sgr","","386.441","6.110","0.742","287.450609","-19.803657","K1III","K","1","","" }
{ "95667","95965","183545","7410","","","","","","","Sgr","","774.718","6.110","-0.769","292.725194","-21.312237","A2V","A","1","","" }
{ "97115","97423","186984","7532","","","","","","","Sgr","","213.593","6.110","2.029","297.012599","-13.703616","A6:IIIm...","A","1","","" }
{ "98174","98485","189140","7627","","","","","","","Sgr","","1105.615","6.110","-1.541","300.110336","-43.043302","M0III","M","1","","" }
{ "99593","99913","192836","7746","","18    Sge","","18","","","Sge","","331.460","6.110","1.075","304.082447","21.598700","K1III","K","1","","" }
{ "101181","101507","195838","7855","GJ 4147","","","","","","Cap","","107.007","6.110","3.530","308.548734","-13.721091","G0V","G","1","","" }
{ "105030","105370","203574","8179","","","","","","","Cep","","405.667","6.110","0.636","320.139474","60.756405","G5III","G","1","","" }
{ "105608","105949","204599","8224","","","","","","","Cep","","1016.064","6.110","-1.357","321.855373","59.750075","M3II-III...","M","1","","" }
{ "106797","107140","206632","8298","","","","","","","Cyg","","683.766","6.110","-0.497","325.534809","45.765697","M4.5","M","1","","" }
{ "108957","109303","210334","8448","","","","","","","Lac","","139.502","6.110","2.954","332.170130","45.742254","K2III comp","K","1","","" }
{ "109313","109659","211300","8493","","","","","","","Cep","","688.094","6.110","-0.511","333.219731","73.307193","A3V+...","A","1","","" }
{ "111217","111567","214200","8604","","","","","","","Peg","","466.604","6.110","0.332","339.032921","35.577504","K0","K","1","","" }
{ "112805","113167","216701","8715","","1    Psc","","1","","","Psc","","352.983","6.110","0.938","343.747858","1.064904","A7III","A","1","","" }
{ "113897","114258","218108","8786","","","","","","","Oct","","239.645","6.110","1.779","347.098323","-79.480689","A7Vn","A","1","","" }
{ "110366","110712","212168","8526","","","","","","","Oct","","75.169","6.120","4.307","336.462749","-75.015689","G3IV","G","1","","" }
{ "111748","112102","214966","8637","","19    PsA","","19","","","PsA","","689.548","6.120","-0.506","340.592023","-29.361046","M3III","M","1","","" }
{ "113171","113531","217251","8741","","","","","","","Aqr","","888.710","6.120","-1.057","344.898639","-13.070895","K3/K4III","K","1","","" }
{ "113800","114162","218416","8801","","","","","","","And","","355.290","6.120","0.934","346.791891","52.816601","K0III","K","1","","" }
{ "114337","114699","219077","8829","","","","","","","Tuc","","95.731","6.120","3.782","348.526074","-62.700004","G5IV","G","1","","" }
{ "115131","115496","220401","8896","","","","","","","Gru","","982.399","6.120","-1.274","350.939247","-43.124429","K3III","K","1","","" }
{ "1300","1302","1185","56","","","","","","","And","","347.344","6.120","0.983","4.089672","43.595049","A2V","A","1","","" }
{ "1317","1319","1227","59","","36    Psc","","36","","","Psc","","407.695","6.120","0.635","4.141837","8.240154","G8II-III","G","1","","" }
{ "4819","4829","6192","295","","Ome Phe","Ome","","Ome","","Phe","","393.434","6.120","0.713","15.507574","-57.002389","G8III","G","1","","" }
{ "5160","5170","6559","320","","","","","","","Cet","","382.813","6.120","0.772","16.532108","-23.992451","K1III","K","1","","" }
{ "9565","9586","12173","579","","","","","","","Cas","","386.900","6.120","0.749","30.793714","73.850570","A5III","A","1","","" }
{ "10116","10138","13445","637","Gl 86","","","","","","Eri","","35.169","6.120","5.956","32.605094","-50.823725","K0V","K","1","","" }
{ "14511","14547","19940","959","","","","","","","Hyi","","333.834","6.120","1.069","46.954071","-69.264920","K1III","K","1","","" }
{ "16269","16310","21899","1076","","","","","","","Eri","","113.170","6.120","3.418","52.556590","-41.369937","F7V","F","1","","" }
{ "17079","17120","22819","1119","","","","","","","Tau","","389.208","6.120","0.736","54.998204","-1.121226","G5","G","1","","" }
{ "18989","19037","25803","1267","","","","","","","Eri","","408.206","6.120","0.633","61.170424","-20.381864","K1II","K","1","","" }
{ "21310","21363","29184","1461","","","","","","","Eri","","354.518","6.120","0.939","68.752947","-19.921384","K2IIICN...","K","1","","" }
{ "24760","24820","34579","1741","","","","","","","Tau","","392.486","6.120","0.718","79.811220","20.134596","G8III+...","G","1","","" }
{ "56086","56253","99945","4429","","","","","","","Cam","","193.106","6.120","2.258","172.962478","81.127257","A2m","A","1","","" }
{ "66780","66992","119584","5164","","","","","","","Boo","","555.633","6.120","-0.037","205.938174","22.700423","K4III","K","1","","" }
{ "68275","68493","122210","5259","","","","","","","Cen","","664.270","6.120","-0.425","210.329433","-40.221943","K1III","K","1","","" }
{ "72841","73068","132029","5569","","","","","","","Boo","","312.410","6.120","1.214","223.994161","32.300063","A2V","A","1","","" }
{ "74343","74571","135530","5677","","","","","","","Boo","","1203.529","6.120","-1.715","228.542940","42.171409","M2III","M","1","","" }
{ "76382","76617","139761","5827","","","","","","","CrB","","475.447","6.120","0.302","234.703553","34.675039","K0","K","1","","" }
{ "78232","78469","143101","5946","","","","","","","Nor","","429.719","6.120","0.521","240.277015","-54.577899","A7III","A","1","","" }
{ "82265","82517","151441","6233","","","","","","","TrA","","1012.908","6.120","-1.341","252.974516","-65.375457","B8II/III","B","1","","" }
{ "28836","28908","41330","2141","Gl 226.3","","","","","","Aur","","83.566","6.120","4.077","91.535631","35.387740","G0V","G","1","","" }
{ "29858","29931","43683","2253","","","","","","","Ori","","718.406","6.120","-0.595","94.523368","14.382859","A3V","A","1","","" }
{ "30395","30468","44996","2309","","","","","","","CMa","","942.648","6.120","-1.185","96.085744","-12.961939","B4V","B","1","","" }
{ "34830","34924","55857","2734","","","","","","","CMa","","326156.378","6.120","-13.880","108.401873","-27.356360","B2II","B","1","","" }
{ "39114","39225","66546","3157","","","","","","","Car","","1347.753","6.120","-1.961","120.346020","-54.515530","B2IV-V","B","1","","" }
{ "39413","39524","66834","3168","","14    Pup","","14","","","Pup","","1325.839","6.120","-1.925","121.172575","-19.728148","B3III","B","1","","" }
{ "40744","40859","70148","3272","","","","","","","Hya","","689.548","6.120","-0.506","125.070921","-5.329930","K2III","K","1","","" }
{ "40761","40876","70302","3276","","","","","","","Pup","","718.406","6.120","-0.595","125.113954","-22.924680","G8/K0III","G","1","","" }
{ "42336","42455","73900","3434","","","","","","","Pyx","","123.451","6.120","3.230","129.842153","-36.606685","F3/F5V","F","1","","" }
{ "42835","42954","74485","3464","","46    Cnc","","46","","","Cnc","","590.863","6.120","-0.170","131.339261","30.697752","G5III","G","1","","" }
{ "43457","43580","75916","3529","","","","","","","Hya","","339.040","6.120","1.036","133.128173","-13.232942","K1III","K","1","","" }
{ "45726","45858","80441","3701","","","","","","","Lyn","","139.145","6.120","2.970","140.247413","38.188262","F3V+...","F","1","","" }
{ "46197","46329","81753","3745","","","","","","","Pyx","","2051.298","6.120","-2.873","141.687093","-28.787696","B5V","B","1","","" }
{ "46635","46768","82477","3788","","","","","","","Hya","","357.236","6.120","0.922","142.982124","-10.370341","K0","K","1","","" }
{ "46736","46869","82638","3801","","","","","","","Hya","","408.206","6.120","0.633","143.258222","-8.505374","K0","K","1","","" }
{ "47496","47631","83951","3857","","13    LMi","","13","","","LMi","","173.765","6.120","2.487","145.678091","35.093371","F3V","F","1","","" }
{ "50645","50790","89911","4076","","","","","","","Hya","","600.656","6.120","-0.206","155.553913","-19.866571","A0V","A","1","","" }
{ "53086","53240","94363","4249","","","","","","","Leo","","258.649","6.120","1.624","163.354010","-2.255209","K0III+...","K","1","","" }
{ "53871","54027","95771","4303","","","","","","","Leo","","182.414","6.120","2.382","165.810586","-0.752344","F0V","F","1","","" }
{ "54623","54783","97550","4353","","","","","","","Cen","","849.366","6.120","-0.958","168.236352","-49.736090","G8II/III","G","1","","" }
{ "83849","84108","155860","6399","","","","","","","Her","","309.446","6.120","1.234","257.917778","49.746357","A5III","A","1","","" }
{ "83916","84175","155401","6387","","","","","","","Oph","","501.779","6.120","0.185","258.104427","-27.762124","B9Vn...","B","1","","" }
{ "86107","86373","160365","6577","","","","","","","Oph","","325.831","6.120","1.122","264.741065","13.329262","F6III","F","1","","" }
{ "89325","89604","168322","6853","","","","","","","Lyr","","400.192","6.120","0.676","274.278527","40.936727","G9III","G","1","","" }
{ "91982","92269","174481","7096","","","","","","","Dra","","196.125","6.120","2.224","282.067001","48.767556","A7III","A","1","","" }
{ "92353","92643","174631","7104","","","","","","","Sgr","","521.017","6.120","0.103","283.154355","-29.379676","K1III","K","1","","" }
{ "94103","94398","178845","7271","","","","","","","Tel","","401.670","6.120","0.668","288.192181","-50.486420","G8III","G","1","","" }
{ "97228","97538","187638","7555","","","","","","","Cyg","","699.906","6.120","-0.538","297.364596","38.710149","G6III","G","1","","" }
{ "97376","97687","187660","7559","","","","","","","Aql","","599.552","6.120","-0.202","297.796240","-2.460990","K5III","K","1","","" }
{ "98829","99145","191243","7699","","","","","","","Cyg","","1734.874","6.120","-2.509","301.922672","34.422905","B5Ib","B","1","","" }
{ "100651","100977","194939","7821","","68    Aql","","68","","","Aql","","602.877","6.120","-0.214","307.103771","-3.357794","B9V","B","1","","" }
{ "104418","104756","203501","8174","","","","","","","Cep","","526.059","6.120","0.082","318.339971","81.230972","A3IV","A","1","","" }
{ "104727","105064","202923","8147","","","","","","","Cyg","","443.750","6.120","0.451","319.258488","53.997693","A1V","A","1","","" }
{ "105523","105864","204121","8205","","","","","","","Aqr","","161.464","6.120","2.647","321.616887","1.103359","F5V","F","1","","" }
{ "85833","86096","159925","6563","","","","","","","Her","","461.978","6.130","0.374","263.926537","37.301594","G9III","G","1","","" }
{ "86922","87192","162161","6642","","","","","","","Her","","539.994","6.130","0.035","267.199473","19.255017","A1V","A","1","","" }
{ "88582","88859","165493","6759","","","","","","","Ara","","886.294","6.130","-1.041","272.125453","-45.767015","B7/B8II","B","1","","" }
{ "88809","89086","166197","6788","","","","","","","Sgr","","326156.378","6.130","-13.870","272.730612","-33.800070","B2II/III","B","1","","" }
{ "90025","90304","168740","6871","","","","","","","Pav","","232.140","6.130","1.868","276.381790","-63.021534","A3V","A","1","","" }
{ "91467","91751","172831","7024","","","","","","","Sct","","255.009","6.130","1.664","280.650489","-7.073654","K0.5III","K","1","","" }
{ "95101","95396","181925","7350","","","","","","","Sgr","","672.487","6.130","-0.441","291.089459","-43.722063","M1/M2III","M","1","","" }
{ "96137","96440","184705","7439","","","","","","","Sgr","","253.227","6.130","1.680","294.108642","-18.852921","F0V","F","1","","" }
{ "97340","97651","187880","7568","","","","","","","Cyg","","2651.678","6.130","-3.420","297.695301","37.826324","M3III","M","1","","" }
{ "97478","97789","188149","7583","","","","","","","Cyg","","707.497","6.130","-0.551","298.068384","36.432295","K4III","K","1","","" }
{ "99366","99685","192535","7733","","","","","","","Cyg","","680.911","6.130","-0.468","303.428392","43.379013","K4III","K","1","","" }
{ "99861","100184","192886","7749","","","","","","","Tel","","100.356","6.130","3.689","304.824151","-47.580289","F5V","F","1","","" }
{ "100764","101090","195006","7825","","","","","","","Cap","","539.102","6.130","0.039","307.380585","-22.391567","K5III","K","1","","" }
{ "103837","104172","201051","8082","","","","","","","Vul","","411.294","6.130","0.626","316.597818","26.924362","K0II-III","K","1","","" }
{ "104642","104980","202287","8124","","","","","","","Mic","","704.441","6.130","-0.542","318.944921","-36.210709","K3III","K","1","","" }
{ "108133","108478","208496","8369","","Kap1Ind","Kap-1","","Kap","1","Ind","","218.897","6.130","1.996","329.625319","-59.012140","F3V","F","1","","" }
{ "109238","109584","210056","8432","","","","","","","Oct","","287.616","6.130","1.403","332.979559","-76.116023","K0III","K","1","","" }
{ "55501","55667","99171","4403","","","","","","","Cen","","2764.037","6.130","-3.511","171.091899","-42.669102","B2IV-V","B","1","","" }
{ "57559","57732","102845","4539","","","","","","","Crt","","576.248","6.130","-0.106","177.581682","-15.863667","G8II/III","G","1","","" }
{ "58003","58177","103637","4568","","","","","","","Cen","","411.294","6.130","0.626","178.978168","-39.689517","K0III","K","1","","" }
{ "71202","71429","128152","5446","","","","","","","Cen","","454.890","6.130","0.408","219.100464","-39.597407","K1III","K","1","","" }
{ "71503","71729","129132","5472","","","","","","","Boo","","379.252","6.130","0.802","220.091146","21.975868","G0V","G","1","","" }
{ "73699","73927","133670","5620","","","","","","","Lib","","189.406","6.130","2.310","226.613080","-22.031830","K0III","K","1","","" }
{ "78862","79102","145122","6013","","8    Her","","8","","","Her","","318.823","6.130","1.179","242.194296","17.205638","A0Vnn","A","1","","" }
{ "109400","109746","211242","8490","","","","","","","Cep","","1304.626","6.130","-1.880","333.457123","63.162337","B8Vn","B","1","","" }
{ "113827","114187","218395","8798","","","","","","","Peg","","532.935","6.130","0.064","346.865527","32.825345","A3","A","1","","" }
{ "114388","114750","219279","8836","","","","","","","Aqr","","630.863","6.130","-0.303","348.667387","-10.688715","K5III","K","1","","" }
{ "115146","115510","220392","8895","","","","","","","Gru","","386.900","6.130","0.759","350.977046","-53.808740","A4III","A","1","","" }
{ "117342","117710","223755","9035","","","","","","","Peg","","643.307","6.130","-0.345","358.097469","21.671099","M2III","M","1","","" }
{ "118392","","38392","1982","Gl 216B","","","","","","Lep","","29.254","6.130","6.366","86.108846","-22.420198","K2 V","K","2","27006","Gl 216" }
{ "118619","","","","Gl 340.1B","","","","","","Car","","109.338","6.130","3.503","139.327205","-68.689446","","","2","45440","Gl 340.1" }
{ "3909","3919","4778","234","","","","","","","And","","327.138","6.130","1.123","12.576038","45.002258","A0p...","A","1","","" }
{ "5638","5650","7158","355","","","","","","","And","","632.086","6.130","-0.307","18.141981","45.337531","M1III","M","1","","" }
{ "6808","6822","8921","425","","","","","","","Cet","","385.528","6.130","0.767","21.943921","-10.901582","K0","K","1","","" }
{ "14478","14514","19374","938","","53    Ari","","53","","","Ari","","832.031","6.130","-0.904","46.856972","17.879995","B1.5V","B","1","","" }
{ "17366","17408","23183","1132","","14    Tau","","14","","","Tau","","409.744","6.130","0.635","55.946704","19.665032","G8III","G","1","","" }
{ "20882","20934","28700","1433","","","","","","","Cae","","399.701","6.130","0.688","67.333636","-46.515270","K1III","K","1","","" }
{ "24776","24836","34233","1719","","15    Cam","","15","","","Cam","","785.919","6.130","-0.780","79.866058","58.117365","B5V","B","1","","" }
{ "25177","25240","35317","1782","","","","","","","Ori","","181.703","6.130","2.400","80.963874","-0.866622","F7V","F","1","","" }
{ "27831","27900","39632","2048","","","","","","","Ori","","1405.847","6.130","-2.043","88.555626","10.586403","G9II","G","1","","" }
{ "32992","33079","50643","2566","","","","","","","CMa","","414.430","6.130","0.610","103.341005","-18.932844","A3III","A","1","","" }
{ "39041","39153","66255","3151","","","","","","","Pup","","967.823","6.130","-1.232","120.120674","-48.871768","A0p","A","1","","" }
{ "40951","41067","70673","3289","","22    Pup","","22","","","Pup","","411.294","6.130","0.626","125.695198","-13.054793","K0III","K","1","","" }
{ "42812","42931","74591","3469","","10    Hya","","10","","","Hya","","210.559","6.130","2.080","131.255335","5.680588","A6V","A","1","","" }
{ "43777","43902","76494","3557","","","","","","","Hya","","1418.071","6.130","-2.061","134.154326","4.236581","G8II-III","G","1","","" }
{ "45036","45166","80194","3695","","","","","","","Cha","","388.744","6.130","0.749","138.051203","-76.663028","K1III","K","1","","" }
{ "46611","46744","82428","3785","","","","","","","Hya","","167.690","6.130","2.575","142.912448","-10.552013","F0Vn","F","1","","" }
{ "48660","48799","86466","3941","","","","","","","Vel","","2673.413","6.130","-3.438","149.295601","-52.638783","B3IV","B","1","","" }
{ "50932","51077","90518","4099","","","","","","","Vel","","319.761","6.130","1.173","156.541047","-42.738494","K1III","K","1","","" }
{ "28319","28390","40083","2080","","","","","","","Aur","","307.115","6.140","1.271","89.949785","54.547009","K2III","K","1","","" }
{ "31617","31697","47240","2432","","","","","","","Mon","","326156.378","6.140","-13.860","99.469600","4.956670","B1Ib","B","1","","" }
{ "31653","31733","47420","2440","","","","","","","Mon","","758.503","6.140","-0.693","99.585234","-2.543897","K2","K","1","","" }
{ "35863","35960","58634","2842","","","","","","","Pup","","672.487","6.140","-0.431","111.197319","-37.291193","A8V","A","1","","" }
{ "37966","38074","63640","3041","","","","","","","Pup","","644.578","6.140","-0.339","117.035617","-40.652378","M2III","M","1","","" }
{ "38522","38635","64876","3092","","","","","","","Pup","","648.422","6.140","-0.352","118.666326","-34.846713","K4III","K","1","","" }
{ "38749","38863","65908","3139","","","","","","","Car","","465.273","6.140","0.369","119.303167","-63.296835","B8V","B","1","","" }
{ "40920","41036","70574","3285","","","","","","","Hya","","237.723","6.140","1.827","125.625685","-6.179158","A8IV","A","1","","" }
{ "43562","43685","75896","3528","","","","","","","Lyn","","787.817","6.140","-0.775","133.482019","35.538294","A4III","A","1","","" }
{ "45037","45167","79108","3651","","","","","","","Hya","","323.889","6.140","1.155","138.053671","3.866978","A0V","A","1","","" }
{ "45484","45615","80710","3713","","","","","","","Car","","1284.080","6.140","-1.836","139.465259","-67.050868","K2III","K","1","","" }
{ "45704","45836","80290","3697","","","","","","","UMa","","89.530","6.140","3.947","140.182391","51.266066","F3V","F","1","","" }
{ "46396","46529","82043","3760","","","","","","","Hya","","420.305","6.140","0.589","142.351841","-2.205172","F0III","F","1","","" }
{ "49141","49281","87543","3971","","","","","","","Car","","1638.977","6.140","-2.366","150.892205","-61.884040","B4:Vne","B","1","","" }
{ "49627","49769","88218","3992","Gl 379.1A","","","","","","Ant","","103.182","6.140","3.639","152.382619","-35.856771","G1V","G","1","","Gl 379.1" }
{ "109644","109990","211291","8492","","","","","","","PsA","","574.219","6.140","-0.088","334.156088","-25.898162","K1II/III","K","1","","" }
{ "111744","112098","215159","8648","","","","","","","Lac","","1254.448","6.140","-1.785","340.586708","53.908748","K2","K","1","","" }
{ "112282","112641","216057","8682","","","","","","","Lac","","746.353","6.140","-0.658","342.199548","54.414892","B5Vn","B","1","","" }
{ "112564","112924","216187","8689","","","","","","","Tuc","","409.230","6.140","0.647","343.041646","-63.188667","K0III","K","1","","" }
{ "84978","85237","157486","6470","","","","","","","Sco","","561.371","6.140","-0.039","261.261113","-34.696055","Ap...","A","1","","" }
{ "87071","87341","162570","6655","","","","","","","Her","","305.676","6.140","1.281","267.701592","22.316330","A9V","A","1","","" }
{ "87296","87567","162586","6657","","","","","","","Sco","","886.294","6.140","-1.031","268.331581","-34.730812","B4III","B","1","","" }
{ "88248","88522","165174","6747","","","","","","","Oph","","326156.378","6.140","-13.860","271.155654","1.918992","B0IIIn","B","1","","" }
{ "89021","89298","167193","6820","","","","","","","Her","","1230.779","6.140","-1.744","273.319015","21.880332","K4III","K","1","","" }
{ "89699","89977","168797","6873","","","","","","","Ser","","1058.949","6.140","-1.417","275.368337","5.435726","B3Ve","B","1","","" }
{ "90011","90290","169236","6889","","","","","","","Sgr","","385.528","6.140","0.777","276.340324","-35.992025","K0III","K","1","","" }
{ "92676","92968","175679","7144","","","","","","","Ser","","510.417","6.140","0.168","284.106685","2.471190","G8III","G","1","","" }
{ "92847","93140","175892","7159","","","","","","","Sgr","","258.854","6.140","1.642","284.603459","-22.529493","A1V","A","1","","" }
{ "95567","95866","182893","7388","","","","","","","Tel","","313.010","6.140","1.229","292.469166","-55.441754","K0/K1III","K","1","","" }
{ "96760","97067","186042","7491","","","","","","","Sgr","","635.782","6.140","-0.309","295.906740","-37.538765","B8IV/V","B","1","","" }
{ "96933","97242","186927","7530","","","","","","","Cyg","","417.614","6.140","0.603","296.463977","35.012751","A2V+...","A","1","","" }
{ "97063","97372","187372","7547","","","","","","","Cyg","","976.516","6.140","-1.241","296.861806","47.907564","M2III","M","1","","" }
{ "97659","97970","188385","7598","","","","","","","Aql","","266.685","6.140","1.577","298.667501","7.140353","A2V","A","1","","" }
{ "98068","98379","189775","7651","","","","","","","Cyg","","778.416","6.140","-0.749","299.813930","52.055691","B5III","B","1","","" }
{ "98599","98915","190964","7687","","","","","","","Cyg","","715.255","6.140","-0.565","301.278104","51.839398","M1IIIa","M","1","","" }
{ "100338","100664","194244","7803","","","","","","","Aql","","807.318","6.140","-0.828","306.156242","1.068406","B9V","B","1","","" }
{ "100959","101285","195964","7860","","","","","","","Cyg","","765.625","6.140","-0.713","307.943795","56.779858","K5III","K","1","","" }
{ "104020","104357","201298","8090","","","","","","","Equ","","1164.844","6.140","-1.624","317.117247","6.989358","K5III","K","1","","" }
{ "105711","106052","204754","8226","","","","","","","Cep","","1274.048","6.140","-1.819","322.219712","55.418702","B8III","B","1","","" }
{ "107747","108090","208110","8359","","","","","","","Peg","","458.085","6.140","0.402","328.490693","6.864804","G0IIIs","G","1","","" }
{ "56562","56731","101013","4474","","","","","","","UMa","","420.847","6.140","0.587","174.470918","50.618211","K0p...","K","1","","" }
{ "58814","58989","105043","4610","","","","","","","UMa","","384.618","6.140","0.782","181.415560","62.933120","K2III","K","1","","" }
{ "62591","62788","111786","4881","","","","","","","Hya","","218.457","6.140","2.010","192.991263","-26.738275","A0III","A","1","","" }
{ "65811","66019","117597","5092","","","","","","","Cen","","319.448","6.140","1.185","203.022534","-38.398844","K1III","K","1","","" }
{ "67863","68080","121336","5234","","","","","","","Cen","","456.163","6.140","0.412","209.083236","-54.132420","A1V","A","1","","" }
{ "67959","68177","121699","5246","","","","","","","Hya","","573.210","6.140","-0.084","209.365530","-23.022630","K2/K3III","K","1","","" }
{ "69094","69316","124186","5310","","","","","","","Boo","","361.192","6.140","0.918","212.813015","32.295892","K4III","K","1","","" }
{ "74864","75093","136751","5716","","","","","","","Boo","","176.301","6.140","2.476","230.173628","44.434376","F4IVs","F","1","","" }
{ "74889","75118","136407","5703","","29Omi Lib","Omi","29","Omi","","Lib","","184.791","6.140","2.374","230.255734","-15.548342","F2V","F","1","","" }
{ "77691","77927","141913","5898","","","","","","","TrA","","1376.187","6.140","-1.986","238.719319","-60.743651","B9II","B","1","","" }
{ "79420","79661","145921","6049","","","","","","","Nor","","232.969","6.140","1.871","243.849847","-42.899422","K2III","K","1","","" }
{ "79445","79686","146537","6068","","","","","","","CrB","","392.959","6.140","0.735","243.947188","27.422081","K2","K","1","","" }
{ "80213","80455","147349","6089","","","","","","","TrA","","407.186","6.140","0.658","246.342249","-63.125217","A1V","A","1","","" }
{ "81664","81914","150591","6209","","","","","","","Sco","","545.412","6.140","0.024","250.975332","-41.113344","B6/B7V","B","1","","" }
{ "1097","1099","943","43","","","","","","","Scl","","865.136","6.140","-0.978","3.434907","-26.284959","K4III","K","1","","" }
{ "3178","3185","3795","173","Gl 27.2","","","","","","Cet","","94.210","6.140","3.837","10.136560","-23.804876","G3/G5V","G","1","","" }
{ "4645","4655","5820","284","","","","","","","Psc","","1083.576","6.140","-1.467","14.957027","6.483225","M2III","M","1","","" }
{ "5192","5204","6557","319","","75    Psc","","75","","","Psc","","434.875","6.140","0.515","16.640111","12.956039","G8III","G","1","","" }
{ "8535","8552","11332","537","","","","","","","Phe","","495.678","6.140","0.231","27.583952","-47.816392","K1IV","K","1","","" }
{ "11388","11415","15152","711","","","","","","","Ari","","531.199","6.140","0.081","36.780163","27.012395","K5III","K","1","","" }
{ "11651","11678","15550","729","","26    Ari","","26","","","Ari","","215.427","6.140","2.041","37.660063","19.855301","A9V","A","1","","" }
{ "13164","13197","17713","844","","Gam1For","Gam-1","","Gam","1","For","","436.038","6.140","0.510","42.462354","-24.560311","K0III","K","1","","" }
{ "13849","13883","18557","895","","","","","","","Eri","","293.835","6.140","1.367","44.697092","-9.776506","A2m","A","1","","" }
{ "13873","13907","18650","900","","","","","","","For","","463.949","6.140","0.375","44.777059","-28.907213","K1III","K","1","","" }
{ "15206","15244","20395","988","","14    Eri","","14","","","Eri","","111.468","6.140","3.471","49.149025","-9.154676","F1V","F","1","","" }
{ "15518","15557","20663","1000","","60    Ari","","60","","","Ari","","298.132","6.140","1.335","50.106554","25.662739","K3III:","K","1","","" }
{ "15801","15840","21563","1053","","","","","","","Hyi","","639.522","6.140","-0.322","51.009537","-69.624606","A4:V+...","A","1","","" }
{ "16262","16303","21427","1043","","","","","","","Cam","","310.330","6.140","1.248","52.545582","59.365947","A2V","A","1","","" }
{ "16600","16641","22072","1085","","","","","","","Tau","","131.727","6.140","3.109","53.534900","17.832828","K1IVe...","K","1","","" }
{ "18355","18401","25170","1236","","","","","","","Ret","","337.636","6.140","1.065","59.016413","-63.463718","K1/K2III","K","1","","" }
{ "19129","19177","25425","1248","","","","","","","Cam","","437.794","6.140","0.501","61.661768","65.520798","A3m","A","1","","" }
{ "19623","19672","26571","1297","","","","","","","Tau","","872.076","6.140","-0.996","63.213521","22.413458","B9IIIsp...","B","1","","" }
{ "20796","20848","28322","1413","","","","","","","Tau","","307.405","6.140","1.269","67.015158","1.858605","G9III","G","1","","" }
{ "23107","23161","31764","1600","","","","","","","Ori","","1140.407","6.140","-1.578","74.747544","14.543240","B7V","B","1","","" }
{ "23528","23583","32406","1626","","","","","","","Aur","","589.794","6.140","-0.146","76.060684","30.494588","K0II-III","K","1","","" }
{ "27661","27731","38831","2006","","30    Cam","","30","","","Cam","","483.912","6.140","0.283","88.071895","58.964088","A0Vs","A","1","","" }
{ "2331","2337","2630","115","","","","","","","Cet","","139.443","6.150","2.995","7.466226","-14.864109","F2/F3V","F","1","","" }
{ "3519","3527","4304","202","","","","","","","Phe","","151.983","6.150","2.808","11.249379","-53.714895","F7III","F","1","","" }
{ "3544","3552","4301","201","","","","","","","Cet","","827.808","6.150","-0.873","11.350523","-4.629160","M0III","M","1","","" }
{ "3551","3559","4307","203","GJ 1020","18    Cet","","18","","","Cet","","101.102","6.150","3.693","11.369535","-12.880810","G2V","G","1","","" }
{ "4247","4257","5268","255","","21    Cet","","21","","","Cet","","428.589","6.150","0.557","13.573303","-8.740662","G5IV","G","1","","" }
{ "7036","7050","9030","428","","","","","","","Cas","","305.963","6.150","1.289","22.716899","66.098087","A2Vs","A","1","","" }
{ "8972","8991","12363","593","","Sig Hyi","Sig","","Sig","","Hyi","","132.476","6.150","3.106","28.959628","-78.348548","F5/F6IV/V","F","1","","" }
{ "12742","12775","17254","821","","","","","","","Hor","","330.452","6.150","1.122","41.044091","-52.570597","A2V","A","1","","" }
{ "13722","13756","18345","877","","","","","","","Cet","","737.910","6.150","-0.623","44.269063","4.501030","M4III","M","1","","" }
{ "14850","14887","19736","950","","","","","","","Per","","653.620","6.150","-0.359","48.039803","42.375905","B4V","B","1","","" }
{ "15171","15209","20162","973","","","","","","","Per","","1065.871","6.150","-1.421","49.018545","45.346133","M2III","M","1","","" }
{ "20213","20263","27536","1362","","","","","","","Eri","","199.851","6.150","2.214","65.161007","-6.245995","G8IV:","G","1","","" }
{ "20234","20284","27483","1358","","","","","","","Tau","","154.650","6.150","2.770","65.219662","13.864427","F6V...","F","1","","" }
{ "23006","23060","31726","1595","","","","","","","Eri","","1358.985","6.150","-1.949","74.436187","-14.231920","B2V","B","1","","" }
{ "23797","23852","33021","1662","GJ 3334","13    Ori","","13","","","Ori","","90.248","6.150","3.940","76.909638","9.471780","G1IV","G","1","","" }
{ "24421","24479","33618","1688","","","","","","","Cam","","355.678","6.150","0.962","78.797462","59.405687","K2III-IV","K","1","","" }
{ "24435","24493","34180","1717","","","","","","","Ori","","152.981","6.150","2.794","78.827091","-1.409040","F0IV","F","1","","" }
{ "24680","24740","34364","1728","","17    Aur","","17","","","Aur","","398.237","6.150","0.716","79.578740","33.767348","B9.5V","B","1","","" }
{ "25911","25976","36558","","","","","","","","Ori","","1101.880","6.150","-1.494","83.158248","0.011933","K5","K","1","","" }
{ "26343","26408","36570","1857","","19    Cam","","19","","","Cam","","362.799","6.150","0.919","84.312786","64.154690","A0V","A","1","","" }
{ "26347","26412","37430","1926","","Nu 1Col","Nu-1","","Nu","1","Col","","128.408","6.150","3.174","84.318772","-27.871362","F0IV","F","1","","" }
{ "26801","26866","38054","1965","","","","","","","Lep","","801.367","6.150","-0.802","85.560319","-17.530376","K3III","K","1","","" }
{ "82723","82979","153021","6296","","","","","","","Oph","","264.737","6.150","1.603","254.358336","-10.963373","G8III-IV","G","1","","" }
{ "83449","83706","154368","6347","","","","","","","Sco","","2038.477","6.150","-2.829","256.618205","-35.451046","O9.5Iab","O","1","","" }
{ "85661","85923","159870","6560","","","","","","","Dra","","815.391","6.150","-0.840","263.381689","57.558721","A5V+...","A","1","","" }
{ "89734","90012","168646","6864","","","","","","","Sgr","","538.212","6.150","0.062","275.500570","-28.429962","A3III","A","1","","" }
{ "89974","90253","169493","6898","","","","","","","Ser","","435.456","6.150","0.522","276.238369","-1.579413","F1V","F","1","","" }
{ "93563","93858","177565","7232","Gl 744","","","","","","CrA","","55.299","6.150","5.004","286.718724","-37.810658","G8V","G","1","","" }
{ "97997","98308","189900","7654","","","","","","","Dra","","446.790","6.150","0.467","299.619742","63.534135","A3V","A","1","","" }
{ "100372","100697","191220","7698","","","","","","","Oct","","246.901","6.150","1.755","306.228397","-83.310616","A2/A3m...","A","1","","" }
{ "104891","105229","203096","8155","","","","","","","Cyg","","2013.311","6.150","-2.802","319.730542","41.040518","A5IV","A","1","","" }
{ "104994","105334","202874","8145","","","","","","","Ind","","1896.258","6.150","-2.672","320.039514","-45.021893","C5II","C","1","","" }
{ "28249","28321","40535","2107","","1    Mon","","1","","","Mon","","294.631","6.150","1.371","89.754497","-9.382223","F2IV","F","1","","" }
{ "28885","28957","42078","2171","","Pi 1Col","Pi-1","","Pi","1","Col","","272.024","6.150","1.544","91.671032","-42.298804","Am","A","1","","" }
{ "28953","29025","41467","2147","","","","","","","Aur","","710.580","6.150","-0.541","91.861492","41.854282","K0III","K","1","","" }
{ "29250","29323","42536","2195","","","","","","","Mon","","555.633","6.150","-0.007","92.755058","-6.754221","A0sp...","A","1","","" }
{ "30995","31068","46792","2410","","","","","","","Pic","","1240.138","6.150","-1.750","97.794353","-61.879545","B3V","B","1","","" }
{ "31631","31711","48189","2468","GJ 3400A","","","","","","Pic","","69.454","6.150","4.509","99.501647","-61.533387","G1/G2V","G","1","","GJ 3400" }
{ "34112","34200","53952","2677","","","","","","","Pup","","174.322","6.150","2.510","106.383436","-34.777700","F2V","F","1","","" }
{ "34696","34789","55184","2713","","","","","","","CMi","","639.522","6.150","-0.312","108.031218","5.474347","K0III","K","1","","" }
{ "39505","39617","67243","3177","","","","","","","Pup","","2811.693","6.150","-3.528","121.437022","-33.569435","G1Ib","G","1","","" }
{ "40369","40485","69511","3253","","","","","","","Pup","","1655.616","6.150","-2.378","123.995099","-35.903191","K2III","K","1","","" }
{ "40832","40947","70612","3286","","","","","","","Pup","","215.001","6.150","2.055","125.350768","-39.620714","A4V","A","1","","" }
{ "44759","44887","78676","3637","","","","","","","Pyx","","398.237","6.150","0.716","137.181397","-26.767598","A4IV","A","1","","" }
{ "46384","46517","82165","3766","","","","","","","Ant","","197.671","6.150","2.237","142.317460","-38.403542","A6V","A","1","","" }
{ "47559","47694","84400","3872","","","","","","","Vel","","1342.207","6.150","-1.922","145.864972","-51.228136","B6V","B","1","","" }
{ "51016","51161","90472","4097","","","","","","","Leo","","341.883","6.150","1.048","156.752030","19.364538","K0","K","1","","" }
{ "52727","52882","93636","4223","","43    LMi","","43","","","LMi","","590.863","6.150","-0.140","162.238479","29.416057","K0","K","1","","" }
{ "53616","53771","95429","4296","","","","","","","Vel","","199.240","6.150","2.220","165.034589","-51.817800","A3III/IV","A","1","","" }
{ "110823","111170","213429","8581","Gl 862.1","","","","","","Aqr","","82.886","6.150","4.125","337.826298","-6.555151","F7V","F","1","","" }
{ "110824","111171","213428","8580","","","","","","","Aqr","","391.075","6.150","0.756","337.826747","-2.911276","K0","K","1","","" }
{ "111154","111504","213402","8577","","","","","","","Oct","","948.129","6.150","-1.167","338.859975","-78.771585","K1III","K","1","","" }
{ "113086","113447","217096","8732","","","","","","","PsA","","242.495","6.150","1.794","344.645864","-35.523231","F7V","F","1","","" }
{ "113638","113998","218061","8783","","","","","","","Aqr","","645.854","6.150","-0.334","346.303558","-17.079250","K4III","K","1","","" }
{ "114700","115062","219644","8855","","","","","","","Ind","","640.779","6.150","-0.316","349.583351","-67.471177","K2/K3III","K","1","","" }
{ "56124","56293","100307","4445","","","","","","","Hya","","718.406","6.150","-0.565","173.097037","-26.746805","M2III","M","1","","" }
{ "57456","57629","102634","4533","","","","","","","Vir","","114.441","6.150","3.424","177.255341","-0.318670","F7V","F","1","","" }
{ "59767","59950","106922","4675","","","","","","","Cen","","489.724","6.150","0.267","184.446962","-36.093979","A0V","A","1","","" }
{ "60682","60870","108570","4749","","","","","","","Cru","","138.202","6.150","3.015","187.140432","-56.407816","K0/K1III","K","1","","" }
{ "63749","63952","113994","4953","","","","","","","UMa","","379.252","6.150","0.822","196.595300","62.041868","G7III","G","1","","" }
{ "69525","69747","124931","5342","","","","","","","Vir","","457.442","6.150","0.415","214.125689","-3.196305","A1V","A","1","","" }
{ "71913","72139","130025","5507","","","","","","","Boo","","581.384","6.150","-0.105","221.335753","18.884956","K0","K","1","","" }
{ "72186","72412","130603","5524","","","","","","","Boo","","276.170","6.150","1.511","222.097293","24.366876","F2V","F","1","","" }
{ "72223","72449","130557","5522","","","","","","","Lib","","438.972","6.150","0.505","222.225394","-0.847655","B9Vsvar...","B","1","","" }
{ "72243","72469","130817","5529","","","","","","","Boo","","132.692","6.150","3.103","222.278260","37.811179","F2V","F","1","","" }
{ "75541","75770","138213","5752","","","","","","","Boo","","512.020","6.150","0.171","232.184990","47.201514","Amvar...","A","1","","" }
{ "76875","77111","140729","5858","","26Tau8Ser","Tau-8","26","Tau","8","Ser","","370.632","6.150","0.872","236.175550","17.264226","A0V","A","1","","" }
{ "77664","77900","142250","5910","","","","","","","Sco","","516.070","6.150","0.154","238.625457","-27.338639","B7V","B","1","","" }
{ "78745","78985","144889","6005","","","","","","","Ser","","746.353","6.150","-0.648","241.842407","21.822615","K4III","K","1","","" }
{ "57324","57497","102397","4524","","","","","","","Cen","","436.038","6.160","0.530","176.779351","-35.906862","G8III","G","1","","" }
{ "58467","58642","104430","4592","","","","","","","Cru","","333.834","6.160","1.109","180.371759","-57.503777","A1V","A","1","","" }
{ "59125","59307","105686","4628","","","","","","","Hya","","322.289","6.160","1.186","182.510645","-34.704742","A0V","A","1","","" }
{ "59984","60168","107326","4694","Gl 460","","","","","","Com","","210.288","6.160","2.113","185.074007","26.001875","F0IV","F","1","","" }
{ "62018","62212","110716","4841","","","","","","","Mus","","2051.298","6.160","-2.833","191.258592","-68.830751","F6Ia","F","1","","" }
{ "64352","64557","114873","4991","","","","","","","Cen","","346.975","6.160","1.026","198.490468","-43.139107","K5II","K","1","","" }
{ "66648","66860","119288","5156","","","","","","","Boo","","118.861","6.160","3.352","205.553177","8.388394","F3Vp","F","1","","" }
{ "67814","68030","121560","5243","","","","","","","Boo","","81.093","6.160","4.182","208.958328","14.056503","F6V","F","1","","" }
{ "68418","68637","122866","5280","","","","","","","UMa","","327.466","6.160","1.151","210.749020","50.971809","A2V","A","1","","" }
{ "73798","74026","134047","5631","","","","","","","Vir","","547.242","6.160","0.036","226.918014","5.498035","K0III","K","1","","" }
{ "73893","74121","134323","5639","","","","","","","Boo","","444.961","6.160","0.486","227.222969","13.235242","G6V:","G","1","","" }
{ "74881","75110","136366","5701","","28    Lib","","28","","","Lib","","598.452","6.160","-0.158","230.223657","-18.158658","G8II/III","G","1","","" }
{ "78748","78989","144183","5979","","","","","","","Nor","","1531.251","6.160","-2.198","241.850352","-56.190956","F2II","F","1","","" }
{ "81259","81507","149485","6167","","","","","","","Ara","","581.384","6.160","-0.095","249.719609","-60.990402","B8Vn","B","1","","" }
{ "82175","82426","152224","6259","","","","","","","Her","","306.826","6.160","1.293","252.679781","32.553668","K0III","K","1","","" }
{ "29137","29210","42278","2179","","","","","","","Mon","","203.848","6.160","2.181","92.401052","-5.711429","F3IVw","F","1","","" }
{ "30587","30660","45321","2325","","","","","","","Mon","","1294.271","6.160","-1.833","96.643518","-4.597400","B2.5V","B","1","","" }
{ "30731","30804","45512","2342","","","","","","","Mon","","266.904","6.160","1.595","97.078389","10.303893","K2III-IV","K","1","","" }
{ "30951","31024","46064","2373","","","","","","","CMa","","1630.782","6.160","-2.335","97.645355","-13.148172","B2III","B","1","","" }
{ "31922","32007","48383","2475","","","","","","","Pup","","1160.699","6.160","-1.596","100.309043","-40.349847","B4V","B","1","","" }
{ "32596","32682","49567","2517","","","","","","","Mon","","326156.378","6.160","-13.840","102.265235","1.002065","B3II-III","B","1","","" }
{ "33182","33269","50420","2557","","","","","","","Aur","","1012.908","6.160","-1.301","103.811072","43.910031","A9III","A","1","","" }
{ "37233","37339","61295","2936","","","","","","","Gem","","331.460","6.160","1.125","114.975370","32.009727","F6II","F","1","","" }
{ "37358","37465","62082","2976","","","","","","","Pup","","881.504","6.160","-0.999","115.348031","-22.336721","M0/M1III","M","1","","" }
{ "37613","37720","63584","3038","","","","","","","Vol","","407.695","6.160","0.675","116.054455","-69.821593","A0IV/V","A","1","","" }
{ "38198","38307","63894","3054","","","","","","","Mon","","402.166","6.160","0.705","117.730162","-11.128602","K0","K","1","","" }
{ "38681","38794","64938","3093","","","","","","","CMi","","1173.224","6.160","-1.620","119.099614","4.485567","G8III","G","1","","" }
{ "42365","42484","72582","3379","","","","","","","Cam","","369.792","6.160","0.887","129.927621","73.629678","G7III","G","1","","" }
{ "44610","44738","78196","3618","","","","","","","Hya","","813.358","6.160","-0.824","136.749747","1.462694","M1III","M","1","","" }
{ "45764","45896","80546","3707","","","","","","","Cnc","","293.306","6.160","1.391","140.363254","32.902151","K3III","K","1","","" }
{ "49853","49994","88693","4010","","","","","","","Vel","","358.808","6.160","0.953","153.095593","-52.163242","K2IIICN...","K","1","","" }
{ "50090","50232","89104","4038","","","","","","","Vel","","1538.473","6.160","-2.208","153.819353","-54.974207","B2IV-V","B","1","","" }
{ "50610","50755","89774","4070","","42    Leo","","42","","","Leo","","465.273","6.160","0.389","155.459599","14.975773","A1V","A","1","","" }
{ "53391","53546","95208","4279","","","","","","","Car","","3136.119","6.160","-3.755","164.315830","-75.099761","K1II","K","1","","" }
{ "53545","53701","95324","4290","","","","","","","Car","","385.528","6.160","0.797","164.808454","-61.320739","B8IV","B","1","","" }
{ "53927","54082","96088","","","","","","","","Car","","2740.810","6.160","-3.462","166.000990","-57.955331","B3III","B","1","","" }
{ "2095","2100","2273","101","","10    Cet","","10","","","Cet","","451.115","6.160","0.456","6.655891","-0.049533","G8III","G","1","","" }
{ "6258","6272","8121","388","","","","","","","Cet","","366.056","6.160","0.909","20.115867","-11.238999","K1III","K","1","","" }
{ "11438","11465","15138","709","","66    And","","66","","","And","","184.373","6.160","2.399","36.965698","50.569974","F4V","F","1","","" }
{ "20181","20231","27349","1344","","","","","","","Per","","734.586","6.160","-0.603","65.041448","31.953174","K5","K","1","","" }
{ "24393","24451","33654","1692","","","","","","","Aur","","326156.378","6.160","-13.840","78.684468","53.213949","A0V","A","1","","" }
{ "26411","26477","37356","1923","","","","","","","Ori","","1614.636","6.160","-2.313","84.472439","-4.814034","B2IV-V","B","1","","" }
{ "27601","27670","39385","2036","","","","","","","Lep","","411.294","6.160","0.656","87.869226","-22.926947","K0IIICN...","K","1","","" }
{ "83034","83289","154391","6348","","","","","","","Dra","","333.834","6.160","1.109","255.320631","60.648754","K1III","K","1","","" }
{ "85577","85839","158741","6522","","","","","","","Sco","","392.959","6.160","0.755","263.102618","-34.279405","F2IV","F","1","","" }
{ "86564","86831","161270","6609","","61    Oph","","61","","","Oph","","276.638","6.160","1.518","266.142053","2.579441","A1IV-V","A","1","","" }
{ "89903","90182","172864","7025","","","","","","","Dra","","490.461","6.160","0.274","276.038297","83.175400","A2V","A","1","","" }
{ "97456","97767","187923","7569","GJ 4126","","","","","","Aql","","86.813","6.160","4.034","298.014341","11.628329","G0V","G","1","","" }
{ "97800","98111","189296","7634","","","","","","","Cyg","","249.546","6.160","1.741","299.079324","56.687017","A4Vn","A","1","","" }
{ "98543","98858","190781","7684","","","","","","","Cyg","","598.452","6.160","-0.158","301.119970","48.229664","A2IV","A","1","","" }
{ "100185","100511","194012","7793","","","","","","","Del","","85.628","6.160","4.064","305.718199","14.551098","F8V","F","1","","" }
{ "106429","106771","206040","8275","","","","","","","Cyg","","538.212","6.160","0.072","324.411711","54.042192","K1III","K","1","","" }
{ "106698","107041","206509","8290","","","","","","","Cyg","","716.827","6.160","-0.550","325.180433","54.872149","K0III","K","1","","" }
{ "108687","109033","209857","8421","","","","","","","Lac","","994.379","6.160","-1.261","331.318783","46.744836","M4III","M","1","","" }
{ "109638","109984","211356","8495","","","","","","","Aqr","","263.242","6.160","1.625","334.140228","-1.596389","A5Vn","A","1","","" }
{ "110503","110849","212978","8553","","","","","","","Lac","","2145.766","6.160","-2.931","336.860412","39.810026","B2V","B","1","","" }
{ "113720","114081","218235","8788","","","","","","","Peg","","142.054","6.160","2.965","346.575554","18.517765","F6Vs","F","1","","" }
{ "109672","110018","211364","8497","","","","","","","Aqr","","463.949","6.170","0.405","334.249303","-23.140247","K0III","K","1","","" }
{ "113011","113371","217101","8733","","","","","","","Lac","","1538.473","6.170","-2.198","344.419743","39.308777","B2IV-V","B","1","","" }
{ "113061","113421","217107","8734","","","","","","","Psc","","64.765","6.170","4.680","344.564755","-2.395385","G8IV","G","1","","" }
{ "114893","115257","220035","8879","","","","","","","Aqr","","368.955","6.170","0.902","350.170365","-5.907975","K0III","K","1","","" }
{ "118505","","","","Gl 291B","","","","","","Pup","","54.377","6.170","5.060","117.941223","-13.896051","G4 V","G","2","38273","Gl 291" }
{ "1193","1195","1089","54","","","","","","","Scl","","634.545","6.170","-0.275","3.742718","-34.904223","K3III","K","1","","" }
{ "6575","6589","8589","405","","","","","","","Cet","","386.900","6.170","0.799","21.166384","-15.660468","G8III/IV","G","1","","" }
{ "6591","6605","8599","406","","","","","","","Cet","","248.974","6.170","1.756","21.202837","-2.848590","G8III","G","1","","" }
{ "7101","7115","9414","443","","","","","","","Phe","","341.525","6.170","1.070","22.912536","-45.575712","A2V","A","1","","" }
{ "10898","10924","14372","679","","","","","","","And","","795.503","6.170","-0.766","35.172958","47.310804","B5V","B","1","","" }
{ "11204","11231","15064","706","","","","","","","Phe","","101.701","6.170","3.700","36.141000","-40.840458","G5IV","G","1","","" }
{ "11644","11671","15652","735","","","","","","","Cet","","522.686","6.170","0.146","37.636642","-22.545318","M0III","M","1","","" }
{ "11991","12022","16060","751","","","","","","","Cet","","388.281","6.170","0.791","38.767224","7.470993","G6III:","G","1","","" }
{ "13666","13700","17958","861","","","","","","","Cas","","2280.814","6.170","-3.053","44.102722","64.332442","K3Ibvar","K","1","","" }
{ "14987","15024","20176","974","","","","","","","For","","408.206","6.170","0.683","48.408100","-29.804129","K1IICN...","K","1","","" }
{ "15165","15203","20319","983","","","","","","","Eri","","657.573","6.170","-0.353","49.003562","-5.918705","B9V","B","1","","" }
{ "17858","17900","23923","1183","","","","","","","Tau","","374.033","6.170","0.873","57.431372","23.711855","B8V","B","1","","" }
{ "24256","24313","33266","1675","","","","","","","Cam","","429.719","6.170","0.571","78.261761","61.850040","A2III","A","1","","" }
{ "25413","25476","35519","1794","","","","","","","Aur","","587.669","6.170","-0.109","81.726331","35.457272","K2","K","1","","" }
{ "26980","27046","37638","1943","","23    Cam","","23","","","Cam","","361.994","6.170","0.944","86.035224","61.476536","G5III:","G","1","","" }
{ "56730","56899","101370","4491","","","","","","","Crt","","688.094","6.170","-0.451","174.959728","-16.620229","M3II/III","M","1","","" }
{ "57798","57971","103266","4553","","","","","","","Hya","","241.776","6.170","1.820","178.361749","-35.066645","A2V","A","1","","" }
{ "64446","64651","115050","4999","","","","","","","Cen","","386.900","6.170","0.799","198.789434","-36.371410","K1III","K","1","","" }
{ "65106","65311","116278","5043","","","","","","","Cen","","817.435","6.170","-0.825","200.785972","-33.189878","M2III","M","1","","" }
{ "65549","65755","116890","5066","","","","","","","Mus","","611.926","6.170","-0.196","202.195051","-69.627152","B8V","B","1","","" }
{ "67637","67851","121056","5224","","","","","","","Cen","","215.143","6.170","2.073","208.467084","-35.314361","K0III","K","1","","" }
{ "73052","73279","132096","5572","","","","","","","Cen","","335.207","6.170","1.111","224.652256","-39.907172","K1III","K","1","","" }
{ "81112","81358","150429","6198","","","","","","","Dra","","511.217","6.170","0.194","249.229124","63.072824","K5","K","1","","" }
{ "81408","81657","149837","6177","","","","","","","Ara","","102.179","6.170","3.690","250.210202","-60.446442","F2III-IV","F","1","","" }
{ "28461","28532","36905","1885","","","","","","","Cep","","1358.985","6.170","-1.929","90.334083","85.182113","M0III","M","1","","" }
{ "30833","30906","45724","2355","","","","","","","Mon","","979.449","6.170","-1.218","97.311714","2.646194","M1","M","1","","" }
{ "30993","31066","45995","2370","","","","","","","Mon","","988.353","6.170","-1.237","97.789846","11.251375","B2V:nne","B","1","","" }
{ "31592","31672","47220","2430","","","","","","","Mon","","442.546","6.170","0.507","99.418026","2.704158","K1III","K","1","","" }
{ "34129","34217","52859","2644","","","","","","","Lyn","","325.181","6.170","1.177","106.415862","52.758558","A3Vs","A","1","","" }
{ "35744","35842","57744","2810","","58    Gem","","58","","","Gem","","285.851","6.170","1.456","110.867243","22.945349","A1V","A","1","","" }
{ "37507","37614","62264","2982","","","","","","","CMi","","561.371","6.170","-0.009","115.772576","0.189333","K0III","K","1","","" }
{ "38191","38300","63799","3050","","","","","","","CMi","","489.724","6.170","0.287","117.697479","3.277253","K1III","K","1","","" }
{ "43271","43394","75649","3516","","","","","","","Pyx","","375.756","6.170","0.863","132.590160","-28.617619","B9V","B","1","","" }
{ "43831","43957","76508","3558","","","","","","","Cnc","","349.204","6.170","1.022","134.284502","17.143751","K1III","K","1","","" }
{ "50092","50234","89015","4029","","","","","","","Ant","","350.329","6.170","1.015","153.836983","-36.517717","K0III","K","1","","" }
{ "53317","53472","94720","4269","","","","","","","Leo","","753.248","6.170","-0.648","164.070227","22.351682","K2","K","1","","" }
{ "83062","83317","155154","6379","","","","","","","UMi","","151.983","6.170","2.828","255.417037","75.297497","F0IVn","F","1","","" }
{ "84221","84479","156208","6412","","","","","","","Oph","","716.827","6.170","-0.540","259.059418","2.186202","A2V","A","1","","" }
{ "84983","85242","157588","6474","","","","","","","Oph","","411.814","6.170","0.664","261.275994","-24.243683","K0III","K","1","","" }
{ "85134","85393","157599","6475","","","","","","","Ara","","547.242","6.170","0.046","261.734811","-51.948819","B8/B9V","B","1","","" }
{ "87269","87540","162757","6666","","","","","","","Ser","","300.052","6.170","1.351","268.264743","-10.899562","K1III:","K","1","","" }
{ "89527","89805","167425","6828","","","","","","","Pav","","75.169","6.170","4.357","274.917088","-63.886562","F9V","F","1","","" }
{ "92379","92669","174500","7097","","","","","","","Tel","","821.553","6.170","-0.836","283.249582","-46.586329","A1IV/V","A","1","","" }
{ "92386","92676","174474","7095","","","","","","","Tel","","267.341","6.170","1.602","283.259800","-48.360913","A2V","A","1","","" }
{ "96498","96805","186121","7492","","","","","","","Cyg","","1681.218","6.170","-2.391","295.171456","43.077824","M2III","M","1","","" }
{ "98074","98385","189322","7636","","","","","","","Aql","","767.427","6.170","-0.688","299.844348","1.377696","G8III","G","1","","" }
{ "99950","100274","193556","7778","","","","","","","Del","","554.688","6.170","0.017","305.085517","14.569257","G8III","G","1","","" }
{ "101885","102216","197734","7938","","","","","","","Cep","","617.720","6.170","-0.217","310.665373","60.601316","A2IV","A","1","","" }
{ "103200","103532","199892","8036","","","","","","","Cyg","","498.710","6.170","0.248","314.628962","41.939925","B7III","B","1","","" }
{ "104763","105101","202862","8144","","","","","","","Cyg","","849.366","6.170","-0.908","319.346588","42.683572","B7Vn","B","1","","" }
{ "105925","106267","205114","8242","","","","","","","Cyg","","1725.695","6.170","-2.448","322.864432","52.619856","G2Ib+...","G","1","","" }
{ "106176","106518","205551","8259","","","","","","","Cyg","","1331.251","6.170","-1.884","323.614425","51.698465","B9III","B","1","","" }
{ "106538","106881","204904","8234","","","","","","","Oct","","210.152","6.170","2.124","324.734142","-79.442583","F4IV","F","1","","" }
{ "107254","107596","207235","8332","","","","","","","Aqr","","226.970","6.170","1.957","326.909327","-5.916802","A7V","A","1","","" }
{ "107866","108209","208606","8374","","","","","","","Cep","","326156.378","6.170","-13.830","328.835821","61.541810","G8Ib...","G","1","","" }
{ "107938","108281","208149","8362","","Pi  Ind","Pi","","Pi","","Ind","","465.938","6.170","0.395","329.058529","-57.899591","A3m...","A","1","","" }
{ "108859","109205","210221","8443","","","","","","","Lac","","326156.378","6.170","-13.830","331.856612","53.307438","A3Ib","A","1","","" }
{ "82656","82911","152667","6283","","","","","","","Sco","","2363.452","6.180","-3.121","254.149909","-40.823453","B0.5Ia","B","1","","" }
{ "83393","83650","154153","6338","","","","","","","Sco","","227.287","6.180","1.964","256.451966","-44.105042","A4III","A","1","","" }
{ "86542","86809","161321","6611","","","","","","","Her","","477.535","6.180","0.352","266.071860","14.410067","A3m","A","1","","" }
{ "86830","87099","161664","6617","","","","","","","Sgr","","2548.097","6.180","-3.284","266.940003","-22.477791","G3/G5Ib","G","1","","" }
{ "87224","87495","162714","6661","","","","","","","Oph","","326156.378","6.180","-13.820","268.161264","-6.143577","G3Ibv SB","G","1","","" }
{ "87435","87706","162978","6672","","","","","","","Sgr","","326156.378","6.180","-13.820","268.725180","-24.887095","O7/O8","O","1","","" }
{ "88004","88277","164824","6737","","","","","","","Her","","1405.847","6.180","-1.993","270.399587","33.311266","K5III","K","1","","" }
{ "88330","88604","165524","6763","","","","","","","Her","","474.064","6.180","0.368","271.375568","21.646624","K3III:","K","1","","" }
{ "89344","89622","167666","6835","","","","","","","Sgr","","561.371","6.180","0.001","274.350356","-28.652065","A5V","A","1","","" }
{ "91557","91843","173664","7060","","","","","","","Dra","","893.579","6.180","-1.009","280.870880","53.871767","A2IV","A","1","","" }
{ "91844","92131","173833","7067","","","","","","","Her","","683.766","6.180","-0.427","281.672338","18.705907","K5","K","1","","" }
{ "94390","94685","180583","7308","","","","","","","Lyr","","1399.813","6.180","-1.983","288.997873","27.926302","F6Ib-II","F","1","","" }
{ "96998","97307","187038","7535","","","","","","","Cyg","","396.302","6.180","0.757","296.645892","32.888591","K2","K","1","","" }
{ "98171","98482","189080","7621","","","","","","","Tel","","338.336","6.180","1.100","300.105635","-49.350946","K0III","K","1","","" }
{ "98605","98921","190771","7683","GJ 1249","","","","","","Cyg","","61.284","6.180","4.810","301.290585","38.478457","G5IV","G","1","","" }
{ "98905","99221","191110","7694","","","","","","","Cap","","552.807","6.180","0.034","302.130298","-10.062595","B9.5III","B","1","","" }
{ "103496","103828","200527","8062","","","","","","","Cyg","","976.516","6.180","-1.201","315.600836","44.790980","M3Ib-II:","M","1","","" }
{ "103960","104297","201057","8083","","","","","","","Cap","","391.075","6.180","0.786","316.936225","-17.455902","B9.5V","B","1","","" }
{ "104260","104597","200924","8081","","","","","","","Pav","","392.486","6.180","0.778","317.837027","-72.544353","K1III","K","1","","" }
{ "104484","104822","202314","8126","","","","","","","Cyg","","1782.275","6.180","-2.508","318.542852","29.900959","G2Ib","G","1","","" }
{ "106529","106872","206027","8274","","","","","","","Peg","","421.936","6.180","0.621","324.688176","25.498829","G9III","G","1","","" }
{ "107215","107558","207223","8330","","","","","","","Peg","","158.021","6.180","2.754","326.769820","17.194041","F3V","F","1","","" }
{ "107380","107723","207780","8347","","","","","","","Cep","","886.294","6.180","-0.991","327.329214","61.272760","M1II-III","M","1","","" }
{ "108000","108347","208435","8367","","","","","","","Gru","","468.616","6.180","0.393","329.258949","-37.746844","F2/F3V","F","1","","" }
{ "109093","109439","210460","8455","GJ 4261","","","","","","Peg","","193.221","6.180","2.317","332.579242","19.616339","G0V","G","1","","" }
{ "56587","56756","101112","4478","","","","","","","Vir","","376.190","6.180","0.870","174.540964","8.883792","K1III","K","1","","" }
{ "58270","58445","104055","4580","","","","","","","Vir","","695.429","6.180","-0.464","179.763906","0.530680","K2IV","K","1","","" }
{ "59526","59708","106478","4654","","","","","","","UMa","","480.348","6.180","0.339","183.680908","53.434626","K0III:","K","1","","" }
{ "62909","63109","112304","4911","","","","","","","Crv","","639.522","6.180","-0.282","193.971848","-15.327025","A0V","A","1","","" }
{ "64273","64478","114630","4980","","","","","","","Cen","","137.503","6.180","3.056","198.232132","-59.816605","G0V","G","1","","" }
{ "64728","64933","115529","5016","","","","","","","Cen","","609.638","6.180","-0.178","199.645315","-51.285776","A0V","A","1","","" }
{ "65083","65288","116197","5038","","","","","","","Cen","","988.353","6.180","-1.227","200.718785","-47.943221","A4V","A","1","","" }
{ "65656","65862","117404","5086","","","","","","","Vir","","1062.399","6.180","-1.384","202.500336","7.178853","K5","K","1","","" }
{ "66927","67139","119786","5170","","85    Vir","","85","","","Vir","","345.871","6.180","1.053","206.396121","-15.767467","A0V","A","1","","" }
{ "68375","68594","122563","5270","","","","","","","Boo","","772.882","6.180","-0.693","210.632698","9.686096","F8IV","F","1","","" }
{ "68422","68641","122510","5268","","","","","","","Cen","","124.487","6.180","3.272","210.757169","-31.684035","F6V","F","1","","" }
{ "68652","68872","123004","5286","","","","","","","Cen","","428.027","6.180","0.590","211.545450","-43.091702","G8III","G","1","","" }
{ "69799","70022","125489","5368","","","","","","","Vir","","206.297","6.180","2.175","214.920628","0.384333","A7V","A","1","","" }
{ "70457","70680","126722","5406","","104    Vir","","104","","","Vir","","257.221","6.180","1.696","216.851617","-6.120332","A2IV","A","1","","" }
{ "72402","72629","130970","5536","","","","","","","Vir","","457.442","6.180","0.445","222.750395","-0.257491","K3III","K","1","","" }
{ "73818","74047","133456","5611","","","","","","","TrA","","654.932","6.180","-0.334","226.986480","-65.275449","K3III","K","1","","" }
{ "74044","74272","135384","5672","","","","","","","UMi","","497.190","6.180","0.265","227.685036","67.781035","A8Vn","A","1","","" }
{ "74372","74600","135230","5662","","26    Lib","","26","","","Lib","","799.403","6.180","-0.767","228.640661","-17.768572","B9III","B","1","","" }
{ "74700","74929","135896","5688","","","","","","","Lup","","900.984","6.180","-1.026","229.672095","-31.209347","G6/G8III","G","1","","" }
{ "78933","79173","144927","6006","","","","","","","Sco","","393.434","6.180","0.773","242.382265","-32.649012","K1III","K","1","","" }
{ "79538","79781","146514","6067","","","","","","","Oph","","144.830","6.180","2.943","244.230423","-3.953349","A9Vn","A","1","","" }
{ "81590","81840","151199","6226","","","","","","","Dra","","288.890","6.180","1.443","250.743476","55.690119","A2p...","A","1","","" }
{ "82088","82339","151676","6240","","","","","","","Oph","","241.597","6.180","1.832","252.365292","-15.667970","A3V","A","1","","" }
{ "82104","82355","152153","6256","","","","","","","Her","","556.581","6.180","0.019","252.419033","43.430437","K0IV","K","1","","" }
{ "109995","110341","211976","8514","","","","","","","Peg","","100.883","6.180","3.728","335.232492","8.186742","F6V","F","1","","" }
{ "110151","110497","212454","8535","","","","","","","Cep","","1012.908","6.180","-1.281","335.750746","57.284612","B8III-IV","B","1","","" }
{ "110220","110566","212487","8536","","","","","","","Lac","","172.478","6.180","2.563","335.975876","38.573612","F5IV:","F","1","","" }
{ "113421","113781","217701","8763","","82    Aqr","","82","","","Aqr","","1456.055","6.180","-2.069","345.635652","-6.574008","M2III","M","1","","" }
{ "113906","114268","218288","8794","","","","","","","Ind","","600.656","6.180","-0.146","347.148175","-73.586116","K3III","K","1","","" }
{ "115163","115528","220465","8900","","","","","","","Aqr","","314.216","6.180","1.261","351.032727","-18.688006","K0III","K","1","","" }
{ "115999","116365","221776","8950","","","","","","","And","","758.503","6.180","-0.653","353.694752","38.024000","K5","K","1","","" }
{ "117680","118048","224303","9055","","","","","","","Peg","","732.936","6.180","-0.578","359.172926","22.648091","M2III","M","1","","" }
{ "118586","","","","Gl 332B","","","","","","Lyn","","53.591","6.180","5.102","135.163302","41.783620","G5 V","G","2","44120","Gl 332" }
{ "43","43","224784","9079","","","","","","","Cas","","444.355","6.180","0.508","0.128893","59.559679","G9III-IV","G","1","","" }
{ "663","664","352","14","","","","","","","Psc","","911.051","6.180","-1.051","2.050400","-2.447711","K2III","K","1","","" }
{ "965","967","743","36","","","","","","","And","","658.902","6.180","-0.347","2.996114","48.152396","K4III","K","1","","" }
{ "2382","2388","2724","119","","","","","","","Phe","","422.482","6.180","0.618","7.615941","-40.939586","F2III","F","1","","" }
{ "2416","2422","2589","112","","","","","","","Cas","","125.590","6.180","3.252","7.726644","77.019404","K0IV","K","1","","" }
{ "2468","2474","2729","121","","13    Cas","","13","","","Cas","","760.271","6.180","-0.658","7.855055","66.519617","B6V","B","1","","" }
{ "2920","2926","3411","156","","","","","","","And","","367.707","6.180","0.920","9.279961","24.014136","K2III","K","1","","" }
{ "3327","3334","3924","181","","","","","","","Cas","","1098.170","6.180","-1.456","10.629277","58.753411","B9.5III","B","1","","" }
{ "6655","6669","8634","407","","","","","","","Psc","","222.026","6.180","2.015","21.398651","23.511519","F5III","F","1","","" }
{ "7492","7506","10052","468","","","","","","","Hyi","","746.353","6.180","-0.618","24.186598","-58.270966","M3III","M","1","","" }
{ "8100","8115","10543","499","","","","","","","Cas","","277.108","6.180","1.534","26.074755","57.536617","A3V","A","1","","" }
{ "8305","8320","11022","524","","","","","","","Phe","","600.656","6.180","-0.146","26.819587","-41.759926","K5/M0III","K","1","","" }
{ "14515","14551","19545","943","","","","","","","For","","178.228","6.180","2.492","46.961847","-27.831151","A3V","A","1","","" }
{ "17017","17058","22695","1110","","","","","","","Tau","","424.683","6.180","0.607","54.857297","16.536685","K0III","K","1","","" }
{ "17730","17772","23552","1160","","","","","","","Per","","817.435","6.180","-0.815","57.075318","50.736767","B8Vn","B","1","","" }
{ "18408","18455","24832","1225","","","","","","","Eri","","409.744","6.180","0.685","59.158047","-9.750844","F1V","F","1","","" }
{ "20406","20456","27402","1352","","","","","","","Cam","","463.290","6.180","0.418","65.741369","59.616182","A4V","A","1","","" }
{ "20986","21038","28459","1419","","","","","","","Per","","375.324","6.180","0.875","67.660029","32.457768","B9.5Vn","B","1","","" }
{ "21908","21961","29859","1499","","95    Tau","","95","","","Tau","","157.411","6.180","2.762","70.807319","24.088920","F7IV-V","F","1","","" }
{ "22139","22192","30422","1525","","","","","","","Eri","","183.234","6.180","2.432","71.607292","-28.087444","A2IV/V","A","1","","" }
{ "25315","25378","35588","1803","","","","","","","Ori","","1240.138","6.180","-1.720","81.445911","0.520244","B2.5V","B","1","","" }
{ "25411","25475","35521","1796","","","","","","","Aur","","328.787","6.180","1.163","81.713672","33.262258","K0","K","1","","" }
{ "25438","25502","35693","1809","","","","","","","Ori","","425.236","6.180","0.604","81.807894","15.257630","A1IV","A","1","","" }
{ "25711","25776","39780","2059","","","","","","","Men","","366.056","6.180","0.929","82.558032","-84.785104","A1V","A","1","","" }
{ "26797","26862","38138","1972","","","","","","","Col","","739.584","6.180","-0.598","85.548248","-30.535442","A0V","A","1","","" }
{ "27240","27308","38713","2000","","","","","","","Lep","","729.656","6.180","-0.568","86.782521","-16.238079","G8III","G","1","","" }
{ "27403","27472","38284","1976","","","","","","","Cam","","400.192","6.180","0.736","87.269442","62.808190","A4V","A","1","","" }
{ "28446","28517","40588","2110","","","","","","","Aur","","234.645","6.180","1.895","90.291853","31.034517","A2V","A","1","","" }
{ "29328","29401","42657","2202","","","","","","","Mon","","574.219","6.180","-0.048","92.932149","-4.665440","B9MNp...","B","1","","" }
{ "31188","31265","47001","2416","","","","","","","Car","","599.552","6.180","-0.142","98.359556","-52.329234","G8III","G","1","","" }
{ "32092","32177","48348","2474","","","","","","","Mon","","634.545","6.180","-0.265","100.777559","3.033801","K0","K","1","","" }
{ "37163","37269","61219","2931","","","","","","","Gem","","441.348","6.180","0.523","114.800026","24.222528","A2V","A","1","","" }
{ "37998","38106","63208","3021","","82    Gem","","82","","","Gem","","787.817","6.180","-0.735","117.140165","23.140980","G2III+...","G","1","","" }
{ "39473","39584","67341","3179","","","","","","","Vel","","326156.378","6.180","-13.820","121.334603","-46.978411","B3Vnp","B","1","","" }
{ "40743","40858","70110","3271","","","","","","","Hya","","128.814","6.180","3.197","125.054164","-0.909314","F9V","F","1","","" }
{ "41680","41798","71906","3348","","","","","","","Lyn","","825.712","6.180","-0.837","127.833200","37.264942","A0V","A","1","","" }
{ "42180","42299","73281","3411","","","","","","","Hya","","416.016","6.180","0.652","129.363221","-4.933999","K0","K","1","","" }
{ "47012","47145","83368","3831","","","","","","","Vel","","230.337","6.180","1.935","144.105869","-48.751179","F0p","F","1","","" }
{ "47039","47172","83465","3837","","","","","","","Vel","","371.476","6.180","0.897","144.193075","-52.943670","K1III","K","1","","" }
{ "47656","47791","83962","3859","","","","","","","UMa","","311.218","6.180","1.282","146.152470","64.984112","F3Vn","F","1","","" }
{ "48643","48782","86659","3949","","","","","","","Car","","1207.987","6.180","-1.663","149.249280","-69.101804","B3V","B","1","","" }
{ "49093","49233","87436","3966","","","","","","","Car","","326156.378","6.180","-13.820","150.749774","-60.178675","A6II/III","A","1","","" }
{ "50081","50222","88651","4008","","","","","","","UMa","","2131.741","6.180","-2.897","153.781911","59.985539","M0IIIvar","M","1","","" }
{ "50830","50976","90630","4105","","","","","","","Car","","467.273","6.180","0.399","156.185626","-73.971732","A2/A3V","A","1","","" }
{ "50869","51014","90393","4093","","","","","","","Vel","","588.730","6.180","-0.102","156.321728","-42.467404","G8III","G","1","","" }
{ "53605","53761","94860","4272","","","","","","","Dra","","526.059","6.180","0.142","164.987407","77.770174","G9III","G","1","","" }
{ "30983","31056","46365","2390","","","","","","","Col","","565.262","6.190","-0.004","97.749565","-40.916253","K3III","K","1","","" }
{ "31927","32012","47886","2458","","","","","","","Mon","","326156.378","6.190","-13.810","100.321751","11.003197","M1III","M","1","","" }
{ "32348","32434","49336","2510","","","","","","","Pup","","1325.839","6.190","-1.855","101.550627","-37.775325","B3Vne","B","1","","" }
{ "34372","34462","53925","2675","","","","","","","Aur","","962.113","6.190","-1.159","107.151016","37.445096","K1III","K","1","","" }
{ "35249","35345","56386","2757","","","","","","","Gem","","590.863","6.190","-0.100","109.517047","30.955872","A0Vn","A","1","","" }
{ "41831","41949","72626","3381","","","","","","","Pyx","","236.860","6.190","1.885","128.270196","-24.606960","F2IV/V","F","1","","" }
{ "43884","44010","76629","3567","","","","","","","Cnc","","862.848","6.190","-0.923","134.425099","9.387764","G8III","G","1","","" }
{ "44035","44162","77084","3584","","","","","","","Hya","","128.055","6.190","3.220","134.916317","-19.208036","F5IV/V","F","1","","" }
{ "44874","45002","79091","","","","","","","","Vel","","299.776","6.190","1.373","137.487910","-52.082861","K1III","K","1","","" }
{ "46165","46297","81780","3746","","","","","","","Vel","","312.710","6.190","1.281","141.618570","-40.501706","A7III","A","1","","" }
{ "46771","46904","82522","3791","","9    LMi","","9","","","LMi","","486.075","6.190","0.324","143.376488","36.486949","K4III:","K","1","","" }
{ "51280","51425","91272","4129","","","","","","","Car","","876.764","6.190","-0.957","157.536676","-66.984654","B4IV","B","1","","" }
{ "53200","53355","94480","4254","","48    LMi","","48","","","LMi","","387.820","6.190","0.814","163.675715","25.490722","A8V","A","1","","" }
{ "53546","53702","96124","4312","","Eta Oct","Eta","","Eta","","Oct","","344.047","6.190","1.074","164.808863","-84.593893","A1V","A","1","","" }
{ "109321","109667","210739","8464","","","","","","","PsA","","206.952","6.190","2.178","333.239524","-26.327793","A3V","A","1","","" }
{ "109825","110171","211797","8510","","","","","","","Lac","","239.821","6.190","1.858","334.734162","37.769286","A9IIIp","A","1","","" }
{ "112255","112615","215874","8676","","70    Aqr","","70","","","Aqr","","364.014","6.190","0.952","342.125872","-10.555478","A9III-IV","A","1","","" }
{ "112309","112670","216172","8687","","","","","","","Cep","","207.743","6.190","2.169","342.253119","68.570228","F5","F","1","","" }
{ "114164","114526","218935","8827","","60    Peg","","60","","","Peg","","228.882","6.190","1.959","347.955016","26.847308","G8III-IV","G","1","","" }
{ "115631","115996","221246","8925","","","","","","","And","","903.480","6.190","-1.022","352.530854","49.133145","K5III","K","1","","" }
{ "83206","83462","154356","6346","","61    Her","","61","","","Her","","749.785","6.190","-0.618","255.875880","35.414049","M4III","M","1","","" }
{ "83308","83565","154441","6352","","","","","","","Her","","576.248","6.190","-0.046","256.172274","19.599105","B9.5V","B","1","","" }
{ "86086","86352","160042","","","","","","","","Oph","","403.659","6.190","0.727","264.686873","-21.912658","G6III/IV","G","1","","" }
{ "87065","87335","162468","6650","","","","","","","Oph","","509.619","6.190","0.221","267.681683","11.946548","K1III-IV","K","1","","" }
{ "87252","87523","162396","6649","","","","","","","Sco","","103.116","6.190","3.690","268.218979","-41.996522","F8V","F","1","","" }
{ "89702","89980","168574","6861","","","","","","","Sgr","","1065.871","6.190","-1.381","275.380694","-24.915276","M3III","M","1","","" }
{ "90215","90494","169990","6919","","","","","","","Sgr","","606.239","6.190","-0.156","276.985332","-17.800357","B8III/IV","B","1","","" }
{ "91983","92270","174160","7079","","","","","","","Her","","93.777","6.190","3.897","282.068339","23.514749","F8V","F","1","","" }
{ "92303","92593","174853","7109","","","","","","","Her","","682.335","6.190","-0.413","283.008015","13.965647","B8Vnn","B","1","","" }
{ "94538","94833","180782","7313","","","","","","","Aql","","281.169","6.190","1.512","289.450773","2.031727","A1Vn","A","1","","" }
{ "95197","95492","182807","7386","","","","","","","Vul","","89.334","6.190","4.002","291.357367","24.912774","F7V","F","1","","" }
{ "96301","96607","184585","7434","","","","","","","Pav","","530.335","6.190","0.134","294.608075","-57.983341","K0III","K","1","","" }
{ "98630","98946","191096","7692","","","","","","","Cyg","","165.394","6.190","2.665","301.339595","56.341422","F4V","F","1","","" }
{ "100719","101044","197508","7930","","","","","","","Dra","","297.588","6.190","1.389","307.261797","83.625417","A4m","A","1","","" }
{ "101230","101556","196379","7876","","","","","","","Cyg","","326156.378","6.190","-13.810","308.710017","51.854221","A9II","A","1","","" }
{ "101282","101608","196078","7865","","","","","","","Cap","","231.975","6.190","1.930","308.884396","-16.525879","A5II/III","A","1","","" }
{ "106410","106752","205939","8272","","","","","","","Cyg","","550.940","6.190","0.052","324.366143","44.696550","A7III","A","1","","" }
{ "106441","106783","205811","8265","","3    Peg","","3","","","Peg","","285.851","6.190","1.476","324.431854","6.618391","A2V","A","1","","" }
{ "107558","107901","207760","8346","","","","","","","Cap","","210.968","6.190","2.136","327.923930","-18.622940","F0V","F","1","","" }
{ "108775","109121","209993","8429","","","","","","","Lac","","318.823","6.190","1.239","331.551081","45.248690","A3V","A","1","","" }
{ "60943","61134","109014","4772","","","","","","","Vir","","404.661","6.190","0.722","187.911344","-5.052592","G9III:","G","1","","" }
{ "64267","64472","114707","4982","","","","","","","Cen","","575.232","6.190","-0.042","198.211848","-42.699720","K0III","K","1","","" }
{ "67310","67523","120455","5197","","","","","","","Hya","","382.813","6.190","0.842","207.527136","-29.081321","A0V","A","1","","" }
{ "67737","67953","121325","5233","","","","","","","Vir","","107.892","6.190","3.592","208.742512","-8.058852","F8V+...","F","1","","" }
{ "68893","69113","123445","5294","","","","","","","Cen","","525.212","6.190","0.155","212.216213","-43.470779","B9V","B","1","","" }
{ "69596","69818","125349","5360","","","","","","","Boo","","294.631","6.190","1.411","214.338115","51.307373","A2IV","A","1","","" }
{ "70191","70414","126271","5394","","","","","","","Boo","","358.808","6.190","0.983","216.076121","8.084595","K4III","K","1","","" }
{ "74286","74514","135402","5673","","","","","","","Boo","","411.294","6.190","0.686","228.398263","38.264700","K2III:","K","1","","" }
{ "74774","75003","136014","5689","","","","","","","Lup","","392.959","6.190","0.785","229.882214","-37.097161","G8III/IV","G","1","","" }
{ "76268","76503","139160","5801","","","","","","","Lib","","621.250","6.190","-0.209","234.368748","-26.279864","B9IV","B","1","","" }
{ "76428","76664","138289","5757","","","","","","","Aps","","323.247","6.190","1.209","234.827381","-77.918004","K2II","K","1","","" }
{ "78393","78632","144542","5995","","","","","","","Dra","","962.113","6.190","-1.159","240.788984","59.410738","M1III","M","1","","" }
{ "559","560","203","9","","","","","","","Cet","","128.459","6.190","3.213","1.708672","-23.107540","F2IV","F","1","","" }
{ "1418","1421","1367","67","","","","","","","Psc","","382.813","6.190","0.842","4.448741","1.688727","K0II","K","1","","" }
{ "4307","4317","5316","259","","","","","","","Psc","","567.228","6.190","-0.012","13.811130","24.557062","M4III","M","1","","" }
{ "11878","11907","15996","745","","","","","","","Cet","","372.325","6.190","0.903","38.417600","-20.001921","K1III","K","1","","" }
{ "12255","12287","16327","768","","","","","","","And","","268.441","6.190","1.613","39.574316","37.726715","F6III","F","1","","" }
{ "17016","17057","22799","1117","","","","","","","Eri","","356.845","6.190","0.995","54.855862","-10.437278","G5","G","1","","" }
{ "18461","18508","24802","1222","","","","","","","Tau","","1042.033","6.190","-1.332","59.359923","24.461937","K0","K","1","","" }
{ "25716","25781","36876","1882","","","","","","","Dor","","371.476","6.190","0.907","82.566120","-63.927686","F0IV","F","1","","" }
{ "26007","26072","36589","1860","","","","","","","Tau","","1144.408","6.190","-1.536","83.411825","20.474216","B6V","B","1","","" }
{ "26573","26638","36384","1844","","","","","","","Cam","","702.923","6.190","-0.477","84.932154","75.043871","M0III","M","1","","" }
{ "27249","27317","39110","2023","","","","","","","Pic","","1244.872","6.190","-1.718","86.805534","-54.360728","K3III","K","1","","" }
{ "601","602","256","10","","","","","","","Cet","","574.219","6.200","-0.028","1.826112","-17.386990","A2IV/V","A","1","","" }
{ "4373","4383","5343","260","","","","","","","Cas","","648.422","6.200","-0.292","14.053963","57.996557","K3III","K","1","","" }
{ "5024","5034","6301","303","","","","","","","Psc","","144.445","6.200","2.969","16.115081","29.658806","F7IV-V","F","1","","" }
{ "5916","5928","6319","306","","","","","","","Cep","","348.830","6.200","1.054","19.052640","87.145496","K2III:","K","1","","" }
{ "7479","7493","9746","454","","","","","","","And","","512.824","6.200","0.217","24.113353","48.722776","K1III:","K","1","","" }
{ "7859","7874","10308","484","","","","","","","Psc","","179.207","6.200","2.500","25.326531","25.745712","F2III","F","1","","" }
{ "7871","7886","10481","494","","","","","","","Scl","","135.616","6.200","3.106","25.363807","-38.132827","F3/F5IV/V","F","1","","" }
{ "8079","8094","10658","507","","","","","","","Cet","","683.766","6.200","-0.407","25.978317","-4.765514","K0","K","1","","" }
{ "11551","11578","15385","723","","","","","","","Ari","","310.625","6.200","1.306","37.306988","23.469026","A5m","A","1","","" }
{ "14090","14124","18894","913","","","","","","","Eri","","110.561","6.200","3.549","45.538647","-6.494543","G0IV-V","G","1","","" }
{ "15737","15776","21019","1024","GJ 2030A","","","","","","Eri","","121.158","6.200","3.350","50.823753","-7.794098","G2V","G","1","","GJ 2030" }
{ "16587","16628","22262","1093","","","","","","","For","","136.239","6.200","3.096","53.486637","-31.080114","F5V","F","1","","" }
{ "23429","23484","31675","1594","","","","","","","Cam","","90.549","6.200","3.983","75.709910","66.822974","F6V:","F","1","","" }
{ "23534","23589","32482","1633","","","","","","","Tau","","484.631","6.200","0.340","76.089952","21.277931","K0","K","1","","" }
{ "23744","23799","32655","1644","","","","","","","Aur","","776.563","6.200","-0.684","76.706484","43.174705","F2IIp...","F","1","","" }
{ "24916","24977","34810","1755","","","","","","","Tau","","550.011","6.200","0.065","80.235896","19.814347","K0III","K","1","","" }
{ "25666","25730","35984","1822","","","","","","","Aur","","289.402","6.200","1.460","82.419383","29.186464","F6III","F","1","","" }
{ "83796","84054","155514","6391","","63    Her","","63","","","Her","","268.441","6.200","1.623","257.763184","24.237694","A8V","A","1","","" }
{ "84187","84445","155940","6403","","","","","","","Sco","","347.344","6.200","1.063","258.963967","-30.210731","B9/B9.5V","B","1","","" }
{ "85138","85397","157968","6496","","","","","","","Ser","","141.869","6.200","3.008","261.758948","-12.512488","F7V","F","1","","" }
{ "91967","92254","173954","7076","","","","","","","Ser","","797.448","6.200","-0.741","282.011106","4.241422","K5","K","1","","" }
{ "92671","92963","175640","7143","","","","","","","Aql","","513.632","6.200","0.214","284.094416","-1.799863","B9III","B","1","","" }
{ "92884","93177","176502","7179","","","","","","","Lyr","","979.449","6.200","-1.188","284.694115","40.679194","B3V","B","1","","" }
{ "93985","94280","179583","7284","","","","","","","Lyr","","491.199","6.200","0.311","287.846501","40.429095","A3V","A","1","","" }
{ "98090","98401","190960","7686","","69    Dra","","69","","","Dra","","526.059","6.200","0.162","299.902826","76.481392","M3III","M","1","","" }
{ "99252","99570","191584","7706","","","","","","","Sgr","","326.483","6.200","1.198","303.099360","-42.780063","K2III","K","1","","" }
{ "99885","100208","193373","7771","","","","","","","Del","","712.132","6.200","-0.496","304.872069","13.216766","M1III","M","1","","" }
{ "100189","100515","194220","7802","","","","","","","Cyg","","335.897","6.200","1.136","305.731335","42.983543","K0IIIvar","K","1","","" }
{ "100643","100969","194953","7824","","","","","","","Del","","405.163","6.200","0.729","307.069964","2.937161","G8III","G","1","","" }
{ "100919","101245","195820","7854","","","","","","","Cyg","","375.756","6.200","0.893","307.838066","52.309526","K0III","K","1","","" }
{ "102449","102780","198208","7964","","","","","","","Cap","","1003.558","6.200","-1.241","312.335592","-18.035855","K3III","K","1","","" }
{ "102502","102833","198404","7975","","","","","","","Del","","413.379","6.200","0.685","312.496237","5.544560","K0","K","1","","" }
{ "104587","104925","202135","8117","","","","","","","Mic","","558.487","6.200","0.032","318.809872","-40.506065","K1III","K","1","","" }
{ "105319","105660","203858","8194","","","","","","","Vul","","570.204","6.200","-0.013","321.031029","25.312423","A2V","A","1","","" }
{ "106635","106978","205877","8269","","","","","","","Ind","","567.228","6.200","-0.002","324.998853","-52.359010","F7III","F","1","","" }
{ "107513","107856","207857","8349","","","","","","","Cyg","","1016.064","6.200","-1.267","327.770745","39.536658","B9p HgMn","B","1","","" }
{ "28551","28622","41125","2136","","","","","","","Lep","","408.717","6.200","0.710","90.640884","-14.497157","K0III","K","1","","" }
{ "33123","33210","50820","2577","","","","","","","Mon","","326156.378","6.200","-13.800","103.675181","-1.756486","B3IVe+...","B","1","","" }
{ "33508","33595","51530","2601","","39    Gem","","39","","","Gem","","155.460","6.200","2.809","104.697588","26.081079","F8Vbwvar","F","1","","" }
{ "33785","33873","52611","2636","","","","","","","Mon","","577.268","6.200","-0.040","105.470489","-1.345883","K0","K","1","","" }
{ "35822","35920","58346","2826","","","","","","","CMa","","576.248","6.200","-0.036","111.071810","-22.912758","B8/B9V","B","1","","" }
{ "37096","37202","61642","2955","","","","","","","Pup","","406.172","6.200","0.724","114.635566","-38.781487","G8III","G","1","","" }
{ "37492","37599","62897","3012","","","","","","","Car","","645.854","6.200","-0.284","115.722275","-58.230058","K0III","K","1","","" }
{ "41857","41975","72291","3365","","32    Lyn","","32","","","Lyn","","120.978","6.200","3.354","128.340629","36.436429","F5Vbwvar","F","1","","" }
{ "42817","42936","75086","3489","","","","","","","Car","","856.054","6.200","-0.895","131.273113","-58.724319","B7III","B","1","","" }
{ "43146","43266","74604","3470","","","","","","","UMa","","499.474","6.200","0.275","132.205284","66.708083","B8V","B","1","","" }
{ "44161","44290","77361","3597","","","","","","","Pyx","","352.601","6.200","1.031","135.297576","-26.663716","K1IIICN...","K","1","","" }
{ "46278","46410","80930","3719","","","","","","","Dra","","512.020","6.200","0.221","141.965072","75.098341","A5Vs","A","1","","" }
{ "48997","49137","87152","3955","","","","","","","Vel","","1230.779","6.200","-1.684","150.419648","-53.364115","B2.5V","B","1","","" }
{ "49020","49160","87238","3957","","","","","","","Car","","721.585","6.200","-0.524","150.491949","-57.349789","K1II","K","1","","" }
{ "49389","49530","87682","3973","","14    Sex","","14","","","Sex","","356.066","6.200","1.009","151.697603","5.611493","K1III","K","1","","" }
{ "50190","50332","89273","4045","","","","","","","Vel","","715.255","6.200","-0.505","154.167288","-51.204636","M4/M5III","M","1","","" }
{ "51343","51490","91106","4122","","","","","","","Sex","","1136.434","6.200","-1.511","157.744850","-7.637550","K5III+...","K","1","","" }
{ "110202","110548","212395","8532","","33    Peg","","33","","","Peg","","109.928","6.200","3.562","335.914796","20.848230","F7V","F","1","","" }
{ "112767","113127","216637","8710","","78    Aqr","","78","","","Aqr","","672.487","6.200","-0.371","343.642173","-7.204626","K3III","K","1","","" }
{ "115541","115906","221081","8921","","","","","","","Aqr","","937.231","6.200","-1.092","352.252767","-9.266104","K0","K","1","","" }
{ "119159","","","","Gl 678B","","","","","","Oph","","53.644","6.200","5.120","262.597655","-1.064706","G8 IV-V","G","2","85407","Gl 678" }
{ "119622","","45951","2366","","","","","","","Gem","","326156.378","6.200","-13.800","97.792084","17.466389","K2III","K","1","","" }
{ "55248","55412","98499","4383","","","","","","","UMa","","414.957","6.200","0.677","170.223892","67.100734","G8","G","1","","" }
{ "58097","58272","103789","4571","","","","","","","Hya","","393.434","6.200","0.793","179.265631","-33.315461","B9.5V","B","1","","" }
{ "59496","59678","106343","4653","","","","","","","Cru","","326156.378","6.200","-13.800","183.570542","-64.408519","B1.5Ia","B","1","","" }
{ "59998","60183","107301","4692","","","","","","","Mus","","306.250","6.200","1.337","185.117738","-65.842656","B9V","B","1","","" }
{ "60864","61053","108954","4767","","","","","","","UMa","","71.027","6.200","4.510","187.708869","53.076608","F9V","F","1","","" }
{ "61303","61496","109585","4797","","","","","","","Crv","","217.873","6.200","2.076","188.994968","-20.527476","F0V","F","1","","" }
{ "63294","63497","113022","4926","","","","","","","Com","","128.156","6.200","3.228","195.161329","18.373009","F6Vs","F","1","","" }
{ "63874","64077","114092","4956","","","","","","","Com","","432.568","6.200","0.587","196.973487","27.555958","K4III","K","1","","" }
{ "64569","64774","115612","5018","","","","","","","Dra","","427.466","6.200","0.613","199.119364","68.408001","B9.5V","B","1","","" }
{ "64903","65108","115778","5024","","","","","","","Cen","","436.622","6.200","0.567","200.146023","-59.772780","F3/F5II","F","1","","" }
{ "68052","68270","121557","5242","","","","","","","Cir","","512.020","6.200","0.221","209.630273","-65.800665","K0III","K","1","","" }
{ "68622","68842","122844","5278","","","","","","","Cen","","509.619","6.200","0.231","211.443749","-54.669362","A5III/IV","A","1","","" }
{ "71243","71469","128429","5455","","","","","","","Lib","","104.941","6.200","3.662","219.249116","-12.305349","F5V","F","1","","" }
{ "73167","73394","131551","5555","","","","","","","Aps","","494.176","6.200","0.298","224.982370","-75.032669","B9V","B","1","","" }
{ "75708","75939","138105","5749","","","","","","","Lib","","261.973","6.200","1.676","232.651052","-20.728553","A3V","A","1","","" }
{ "77453","77689","141853","5896","","","","","","","Lib","","558.487","6.200","0.032","237.909987","-14.133584","G8III","G","1","","" }
{ "56732","56901","101369","4490","","","","","","","Crt","","556.581","6.210","0.049","174.963009","-14.468529","A0V","A","1","","" }
{ "56908","57079","101695","4506","","","","","","","Crt","","255.209","6.210","1.743","175.514704","-20.294167","G8IV","G","1","","" }
{ "58370","58545","104216","4586","","","","","","","Cam","","913.603","6.210","-1.027","180.078353","80.853186","M2III","M","1","","" }
{ "59669","59851","106676","4664","","","","","","","Mus","","380.136","6.210","0.877","184.099400","-72.614499","A0V","A","1","","" }
{ "60142","60327","107655","4705","","","","","","","Com","","337.287","6.210","1.137","185.545132","24.773866","A0V","A","1","","" }
{ "60673","60861","108530","4747","","","","","","","Cru","","531.199","6.210","0.151","187.107075","-61.794842","K2III","K","1","","" }
{ "60799","60988","108845","4761","","7    CVn","","7","","","CVn","","145.997","6.210","2.955","187.512220","51.535631","F7V","F","1","","" }
{ "64978","65183","116061","5033","","","","","","","Vir","","289.659","6.210","1.468","200.374051","-19.489294","A2/A3V","A","1","","" }
{ "66479","66690","119035","5143","","","","","","","CVn","","539.994","6.210","0.115","205.064939","31.012036","G5II:","G","1","","" }
{ "66859","67071","119623","5166","","","","","","","Hya","","517.709","6.210","0.207","206.190285","-25.500933","K3III","K","1","","" }
{ "71635","71861","128917","5465","","","","","","","Cir","","139.205","6.210","3.059","220.483156","-58.615829","F4V","F","1","","" }
{ "72245","72471","130227","5515","","","","","","","Cir","","269.551","6.210","1.624","222.279613","-56.667829","K3III","K","1","","" }
{ "73331","73559","132763","5587","","","","","","","Cen","","417.614","6.210","0.673","225.492020","-34.358875","A8/A9III/IV","A","1","","" }
{ "74935","75164","136334","5696","","","","","","","Lup","","356.066","6.210","1.019","230.397104","-40.749482","A1V","A","1","","" }
{ "76573","76809","139599","5821","","","","","","","Lup","","872.076","6.210","-0.926","235.242662","-47.736091","K5/M0III","K","1","","" }
{ "77599","77835","142357","5913","","","","","","","Ser","","309.153","6.210","1.326","238.395291","16.074933","F5II-III","F","1","","" }
{ "77749","77985","142407","5916","","","","","","","Lup","","456.163","6.210","0.482","238.877219","-31.083644","K4III","K","1","","" }
{ "78208","78445","143248","5952","","","","","","","Lup","","335.207","6.210","1.151","240.223779","-40.435480","A0V","A","1","","" }
{ "79174","79414","146603","6069","","","","","","","Dra","","429.719","6.210","0.611","243.105711","67.144176","G8III","G","1","","" }
{ "81653","81903","150573","6206","","","","","","","Sco","","475.447","6.210","0.392","250.940356","-41.119204","A4V","A","1","","" }
{ "28180","28252","40347","2097","","","","","","","Ori","","337.636","6.210","1.135","89.548793","-0.994018","K0","K","1","","" }
{ "28363","28434","40745","2118","","","","","","","Lep","","205.001","6.210","2.218","90.073582","-12.900034","F2IV","F","1","","" }
{ "28367","28438","40325","2096","","","","","","","Aur","","352.221","6.210","1.043","90.078777","44.592013","K2III...","K","1","","" }
{ "32105","32190","48073","2464","","","","","","","Aur","","517.709","6.210","0.207","100.807244","37.147375","K0","K","1","","" }
{ "36630","36736","60325","2897","","","","","","","Pup","","2013.311","6.210","-2.742","113.342438","-14.338307","B2II","B","1","","" }
{ "38765","38879","65598","3118","","","","","","","Pup","","1035.417","6.210","-1.298","119.333629","-47.890705","B5V","B","1","","" }
{ "39424","39535","66552","3158","","","","","","","Cnc","","349.204","6.210","1.062","121.188765","18.842020","B9V","B","1","","" }
{ "39496","39607","66684","3164","","","","","","","Cnc","","959.283","6.210","-1.133","121.404403","27.529736","A0V","A","1","","" }
{ "39807","39920","67977","3199","","","","","","","Pup","","384.618","6.210","0.852","122.292454","-35.455015","G8III","G","1","","" }
{ "42419","42538","73596","3423","","","","","","","Cnc","","404.159","6.210","0.744","130.076213","31.941898","F5III","F","1","","" }
{ "42658","42777","73971","3436","","","","","","","UMa","","413.379","6.210","0.695","130.750693","46.900845","G8III","G","1","","" }
{ "42954","43073","75081","3488","","","","","","","Vel","","716.827","6.210","-0.500","131.599004","-41.125389","B9V","B","1","","" }
{ "44103","44231","76944","3580","","","","","","","Lyn","","1212.477","6.210","-1.641","135.128342","37.604353","K5","K","1","","" }
{ "45935","46067","81369","","","","","","","","Vel","","769.237","6.210","-0.653","140.915668","-46.908750","B7III","B","1","","" }
{ "53807","53963","95698","4302","","","","","","","Hya","","182.925","6.210","2.466","165.601869","-26.831505","A9III/IV","A","1","","" }
{ "697","699","400","17","Gl 6","","","","","","And","","105.826","6.210","3.654","2.170644","36.627125","F8IV","F","1","","" }
{ "6418","6432","8334","392","","","","","","","Cet","","692.476","6.210","-0.425","20.653971","1.726332","M0III","M","1","","" }
{ "6526","6539","8511","401","","44    Cet","","44","","","Cet","","220.227","6.210","2.063","21.010575","-8.007416","F0V","F","1","","" }
{ "10788","10814","14213","671","","","","","","","And","","445.569","6.210","0.533","34.795124","46.472261","A4V","A","1","","" }
{ "11670","11698","15596","731","","27    Ari","","27","","","Ari","","288.634","6.210","1.475","37.726656","17.703856","G5III-IV","G","1","","" }
{ "12286","12318","16467","775","","","","","","","Cet","","328.787","6.210","1.193","39.653349","3.443205","G9III","G","1","","" }
{ "12753","12786","17168","817","","","","","","","For","","356.845","6.210","1.015","41.085562","-32.524715","A1V","A","1","","" }
{ "16211","16252","21455","1047","","","","","","","Per","","637.024","6.210","-0.244","52.359489","46.937868","B7V","B","1","","" }
{ "17692","17734","23958","1186","","","","","","","Eri","","486.800","6.210","0.340","56.956713","-36.105785","B8V","B","1","","" }
{ "18130","18173","24497","1206","","","","","","","Eri","","888.710","6.210","-0.967","58.303874","-18.434447","K0/K1III+..","K","1","","" }
{ "21636","21689","29459","1477","","","","","","","Tau","","346.606","6.210","1.078","69.846447","25.218274","A5Vn","A","1","","" }
{ "23527","23582","31563","1587","","","","","","","Cam","","1545.765","6.210","-2.169","76.053233","73.763887","K0","K","1","","" }
{ "25721","25785","36217","1837","","","","","","","Ori","","541.788","6.210","0.108","82.583014","4.204795","K2IIIvar","K","1","","" }
{ "26714","26779","37394","1925","Gl 211","","","","","","Aur","","40.044","6.210","5.764","85.334727","53.481058","K1V","K","1","","" }
{ "83899","84158","154556","6357","","","","","","","Aps","","217.148","6.210","2.093","258.082817","-70.721082","K1IVCN...","K","1","","" }
{ "90780","91062","170873","6954","","","","","","","Tel","","664.270","6.210","-0.335","278.629686","-52.891521","K2III","K","1","","" }
{ "90878","91159","171746","6981","","","","","","","Her","","107.253","6.210","3.625","278.971754","16.975697","G2Vv comp","G","1","","" }
{ "90968","91250","172187","7003","","","","","","","Lyr","","428.589","6.210","0.617","279.189769","43.221815","F0V","F","1","","" }
{ "93177","93470","176425","7177","","","","","","","CrA","","404.159","6.210","0.744","285.535477","-41.910505","A0V","A","1","","" }
{ "97300","97611","186837","7527","","","","","","","Pav","","929.220","6.210","-1.063","297.590642","-61.061120","B5V","B","1","","" }
{ "97660","97971","187653","7558","","","","","","","Pav","","375.324","6.210","0.905","298.668526","-61.170792","A3V","A","1","","" }
{ "100887","101213","195479","7839","","","","","","","Del","","281.412","6.210","1.530","307.742297","20.606148","A1m","A","1","","" }
{ "100888","101214","195593","7847","","44    Cyg","","44","","","Cyg","","326156.378","6.210","-13.790","307.746789","36.935839","F5Iab","F","1","","" }
{ "101419","101746","196426","7878","","","","","","","Aql","","544.501","6.210","0.097","309.326590","0.096978","B8IIIp","B","1","","" }
{ "101429","101756","196642","7888","","","","","","","Cyg","","365.237","6.210","0.964","309.348258","38.328665","K0III","K","1","","" }
{ "103350","103682","199960","8041","","11    Aqr","","11","","","Aqr","","88.798","6.210","4.035","315.141000","-4.730261","G1V","G","1","","" }
{ "109593","109939","211287","8491","","","","","","","Peg","","387.359","6.210","0.837","333.999283","8.549574","A1Vn","A","1","","" }
{ "113866","114227","218560","8811","","","","","","","Cep","","1058.949","6.210","-1.347","346.988334","64.222532","K0","K","1","","" }
{ "117126","117494","223428","9021","","","","","","","Aqr","","392.015","6.210","0.811","357.381699","-15.861277","K1/K2III","K","1","","" }
{ "119501","","212698","8545","Gl 859A","53    Aqr","","53","","","Aqr","","65.493","6.210","4.696","336.644584","-16.742424","G3 V","G","1","","Gl 859" }
{ "119625","","93308","4210","","Eta Car","Eta","","Eta","","Car","","326156.378","6.210","-13.790","161.287619","-59.684167","pec","","1","","" }
{ "111198","111548","213884","8593","","","","","","","Tuc","","218.603","6.220","2.089","338.970359","-57.883752","F0Vn","F","1","","" }
{ "113250","113610","217428","8750","","3    Psc","","3","","","Psc","","585.559","6.220","-0.051","345.157948","0.185866","G4III","G","1","","" }
{ "115394","115759","220802","8910","","","","","","","Phe","","457.442","6.220","0.485","351.787910","-50.157244","B9V","B","1","","" }
{ "117559","117927","224103","9048","","26    Psc","","26","","","Psc","","414.430","6.220","0.700","358.782466","7.070972","B9V","B","1","","" }
{ "106","106","224870","9083","","","","","","","Cas","","651.011","6.220","-0.281","0.330197","49.981558","G7II-III","G","1","","" }
{ "1121","1123","952","44","","","","","","","And","","336.591","6.220","1.152","3.509508","33.206039","A1V","A","1","","" }
{ "4013","4023","4881","241","","","","","","","Cas","","1000.480","6.220","-1.214","12.890788","51.571427","B9.5V","B","1","","" }
{ "6854","6868","8949","426","","","","","","","Psc","","373.604","6.220","0.925","22.095475","7.961353","K1IIIvar","K","1","","" }
{ "11082","11108","14830","697","","","","","","","Cet","","411.294","6.220","0.716","35.740100","-18.354982","G8/K0III","G","1","","" }
{ "13485","13518","18265","871","","","","","","","Hor","","1144.408","6.220","-1.506","43.526961","-50.871402","K4III","K","1","","" }
{ "13698","13732","18153","864","","","","","","","Per","","606.239","6.220","-0.126","44.211082","51.261284","K5III","K","1","","" }
{ "17046","17086","22798","1116","","","","","","","Eri","","435.456","6.220","0.592","54.909774","-3.393010","G5","G","1","","" }
{ "18051","18094","24167","1197","","","","","","","Per","","371.476","6.220","0.937","58.018529","31.168578","A5V","A","1","","" }
{ "20013","20063","27026","1328","","","","","","","Per","","395.821","6.220","0.800","64.533775","42.141159","B9V","B","1","","" }
{ "20945","20997","28625","1431","","","","","","","Eri","","468.616","6.220","0.433","67.541680","-13.592372","K0III","K","1","","" }
{ "23256","23311","32147","1614","Gl 183","","","","","","Eri","","28.401","6.220","6.520","75.204160","-5.753675","K3V","K","1","","" }
{ "24336","24394","34045","1710","","","","","","","Lep","","250.312","6.220","1.795","78.499788","-14.606872","A9II/III","A","1","","" }
{ "24711","24771","34332","1725","","","","","","","Aur","","729.656","6.220","-0.528","79.668022","40.465124","K0","K","1","","" }
{ "26648","26713","37744","1950","","","","","","","Ori","","1364.671","6.220","-1.888","85.155399","-2.825236","B1.5V","B","1","","" }
{ "26756","26821","37971","1962","","","","","","","Lep","","1842.692","6.220","-2.540","85.422962","-16.725830","B4/B5III","B","1","","" }
{ "27236","27303","38804","2005","","","","","","","Col","","751.512","6.220","-0.593","86.769074","-28.638913","B5III","B","1","","" }
{ "56606","56775","101154","4484","","","","","","","Vir","","380.579","6.220","0.885","174.600284","-2.435901","G9III","G","1","","" }
{ "58084","58259","103736","4569","","","","","","","UMa","","578.292","6.220","-0.024","179.221897","61.549213","G8III","G","1","","" }
{ "59019","59200","105437","4622","","","","","","","Cru","","2811.693","6.220","-3.458","182.103062","-60.847128","K3/K4II","K","1","","" }
{ "61250","61443","109492","4790","","","","","","","Cru","","153.847","6.220","2.852","188.873449","-61.841576","G4IV","G","1","","" }
{ "61510","61703","109867","4806","","","","","","","Mus","","326156.378","6.220","-13.780","189.718181","-67.193048","B1Ia","B","1","","" }
{ "61744","61937","110377","4824","","27    Vir","","27","","","Vir","","205.130","6.220","2.227","190.393305","10.426270","A7Vn","A","1","","" }
{ "66514","66725","119081","5145","","","","","","","CVn","","543.594","6.220","0.111","205.162843","28.065165","K3III","K","1","","" }
{ "69569","69792","124990","5344","","","","","","","Vir","","409.744","6.220","0.725","214.265789","-18.585700","K0III","K","1","","" }
{ "70087","70310","126141","5387","","","","","","","Boo","","119.166","6.220","3.406","215.778465","25.338173","F5V","F","1","","" }
{ "70113","70336","126035","5383","","2    Lib","","2","","","Lib","","334.863","6.220","1.163","215.856776","-11.714043","G7III","G","1","","" }
{ "70539","70762","127065","5416","","","","","","","Boo","","847.160","6.220","-0.853","217.068513","36.197028","K0III","K","1","","" }
{ "73478","73706","133994","5629","","","","","","","UMi","","492.683","6.220","0.324","225.990609","65.919714","A2Vs","A","1","","" }
{ "75837","76069","138527","5770","","12Tau2Ser","Tau-2","12","Tau","2","Ser","","469.290","6.220","0.430","233.040313","16.056169","B9V","B","1","","" }
{ "76497","76733","139862","5831","","","","","","","Ser","","934.546","6.220","-1.066","235.043111","12.052934","G8II","G","1","","" }
{ "77581","77817","141585","5884","","","","","","","TrA","","632.086","6.220","-0.217","238.345558","-62.606583","K3III","K","1","","" }
{ "78460","78699","143900","5973","","","","","","","Sco","","531.199","6.220","0.161","240.977930","-24.726312","K2/K3III","K","1","","" }
{ "81597","81847","150421","6197","","","","","","","Ara","","2836.142","6.220","-3.477","250.764858","-46.070293","F5Iab","F","1","","" }
{ "27726","27795","38645","1994","","","","","","","Cam","","461.978","6.220","0.464","88.231207","68.471541","G9III","G","1","","" }
{ "28160","28232","40282","2093","","","","","","","Ori","","485.352","6.220","0.357","89.477053","1.224310","M0III","M","1","","" }
{ "29954","30028","44037","2270","","","","","","","Mon","","414.430","6.220","0.700","94.783047","-8.586012","B9V","B","1","","" }
{ "30696","30769","45394","2330","","16    Gem","","16","","","Gem","","464.610","6.220","0.452","96.986136","20.496320","A2Vs","A","1","","" }
{ "33405","33492","51823","2611","","","","","","","CMa","","1019.239","6.220","-1.254","104.427631","-27.537505","B2/B3V","B","1","","" }
{ "39160","39271","66011","3144","","","","","","","CMi","","208.008","6.220","2.197","120.461372","8.913991","G0IV","G","1","","" }
{ "39945","40058","67959","3198","","","","","","","Cnc","","635.782","6.220","-0.229","122.745354","14.629474","A1V","A","1","","" }
{ "40361","40476","69445","3251","","","","","","","Pup","","319.136","6.220","1.267","123.968933","-30.925944","G6:III+...","G","1","","" }
{ "42916","43035","74860","3480","","","","","","","Hya","","1000.480","6.220","-1.214","131.528642","-11.006768","K5III","K","1","","" }
{ "43287","43410","75332","3499","","","","","","","Lyn","","92.474","6.220","3.957","132.634294","33.285052","F7Vn","F","1","","" }
{ "47777","47913","84850","3887","","","","","","","Car","","263.667","6.220","1.682","146.482345","-58.793828","F5IV","F","1","","" }
{ "50145","50287","89263","4043","","","","","","","Car","","266.467","6.220","1.659","154.013472","-59.903411","A5V","A","1","","" }
{ "53550","53706","95057","4275","","","","","","","UMa","","691.009","6.220","-0.410","164.824504","51.882359","K0","K","1","","" }
{ "54768","54929","97866","4364","","","","","","","Cen","","797.448","6.220","-0.721","168.725517","-43.733703","K4III","K","1","","" }
{ "85221","85480","157524","6471","","","","","","","Ara","","834.160","6.220","-0.819","262.032802","-63.036240","B7/B8V","B","1","","" }
{ "85432","85692","159330","6540","","","","","","","Dra","","1269.091","6.220","-1.730","262.681530","57.876824","K2III","K","1","","" }
{ "86465","86732","161149","6604","","","","","","","Her","","392.486","6.220","0.818","265.841758","14.295168","F5II","F","1","","" }
{ "86656","86925","161695","6619","","","","","","","Her","","326156.378","6.220","-13.780","266.417642","31.504678","A0Ib","A","1","","" }
{ "86880","87150","161941","6633","","","","","","","Oph","","862.848","6.220","-0.893","267.084343","3.804215","B9.5V","B","1","","" }
{ "87578","87850","163990","6702","","","","","","","Her","","967.823","6.220","-1.142","269.202181","45.350851","M6Sv","M","1","","" }
{ "87853","88125","164028","6704","","","","","","","Sgr","","918.750","6.220","-1.029","270.000338","-20.339548","K0III","K","1","","" }
{ "88073","88346","164900","6741","","97    Her","","97","","","Her","","762.048","6.220","-0.623","270.625639","22.923230","B3Vn","B","1","","" }
{ "88483","88760","165516","6762","","","","","","","Sgr","","2346.449","6.220","-3.065","271.797304","-21.443938","B1/B2Ib","B","1","","" }
{ "89807","90086","169223","6887","","","","","","","Her","","379.693","6.220","0.890","275.762208","16.688000","K0","K","1","","" }
{ "90654","90936","170773","6948","","","","","","","CrA","","120.620","6.220","3.380","278.253754","-39.892022","F5V","F","1","","" }
{ "91406","91689","172546","7011","","26    Sgr","","26","","","Sgr","","205.130","6.220","2.227","280.465117","-23.833423","A3m...","A","1","","" }
{ "91734","92021","172781","7022","","","","","","","Pav","","693.950","6.220","-0.420","281.349591","-56.881970","K3III","K","1","","" }
{ "92261","92550","174881","7112","","","","","","","Lyr","","1190.352","6.220","-1.591","282.899546","28.783671","K1II-III","K","1","","" }
{ "92845","93138","176095","7163","","","","","","","Aql","","183.337","6.220","2.471","284.598771","6.239929","F5IV","F","1","","" }
{ "93680","93975","178476","7263","","","","","","","Vul","","140.645","6.220","3.047","287.014670","21.698927","F3V","F","1","","" }
{ "94859","95154","183556","","","","","","","","Dra","","1259.291","6.220","-1.714","290.398043","76.559596","C5II","C","1","","" }
{ "96600","96907","186307","7499","","","","","","","Cyg","","266.033","6.220","1.662","295.490076","40.254144","A6V","A","1","","" }
{ "97389","97700","188074","7577","","","","","","","Cyg","","203.848","6.220","2.241","297.830730","47.377236","F2V","F","1","","" }
{ "97633","97944","188088","7578","Gl 770","","","","","","Sgr","","45.821","6.220","5.482","298.573968","-23.941071","K3/K4V","K","1","","" }
{ "99944","100268","193702","7784","","","","","","","Cyg","","588.730","6.220","-0.062","305.063413","39.403226","A1V","A","1","","" }
{ "101482","101810","196610","7886","","","","","","","Del","","381.024","6.220","0.882","309.478031","18.268580","M6III","M","1","","" }
{ "101636","101965","196317","7872","","","","","","","Pav","","452.367","6.220","0.510","309.965571","-62.907802","K1III","K","1","","" }
{ "106263","106605","205541","8258","","","","","","","Peg","","644.578","6.220","-0.259","323.862648","24.452161","A4V","A","1","","" }
{ "106416","106758","205765","8263","","","","","","","Aqr","","368.122","6.220","0.957","324.390665","-0.390562","A2V","A","1","","" }
{ "106475","106818","205417","8249","","","","","","","Ind","","588.730","6.220","-0.062","324.511763","-64.824167","A0/A1IV","A","1","","" }
{ "94679","94974","181960","7351","","","","","","","Cyg","","515.255","6.230","0.237","289.901796","54.375987","A1V","A","1","","" }
{ "98252","98563","189942","7655","","","","","","","Cyg","","834.160","6.230","-0.809","300.313757","37.098996","K0III","K","1","","" }
{ "99971","100295","193944","7791","","","","","","","Cyg","","1976.705","6.230","-2.683","305.127665","53.595685","K5","K","1","","" }
{ "100481","100807","194688","7816","","","","","","","Del","","1012.908","6.230","-1.231","306.596475","17.315559","K0","K","1","","" }
{ "100627","100953","194937","7820","","","","","","","Del","","308.276","6.230","1.352","307.031414","8.437448","G9III","G","1","","" }
{ "100808","101134","196142","7868","","","","","","","Dra","","707.497","6.230","-0.451","307.502995","72.531703","K4III:","K","1","","" }
{ "101592","101921","196712","7890","","","","","","","Aqr","","1792.068","6.230","-2.470","309.805211","-2.412975","B7IIIn","B","1","","" }
{ "102873","103206","198766","7992","","","","","","","Ind","","908.513","6.230","-0.995","313.646265","-50.727341","B5IV","B","1","","" }
{ "103014","103346","199661","8029","","","","","","","Cep","","953.674","6.230","-1.100","314.070866","56.887519","B2.5IV","B","1","","" }
{ "104696","105034","202720","8138","","","","","","","Cyg","","723.185","6.230","-0.499","319.123413","42.251787","K2","K","1","","" }
{ "106895","107238","206546","8293","","","","","","","Cap","","354.133","6.230","1.051","325.806379","-19.620961","A0m...","A","1","","" }
{ "55774","55941","99651","4419","","","","","","","Leo","","525.212","6.230","0.195","171.973792","-1.699946","K2III:","K","1","","" }
{ "56381","56550","100826","","","","","","","","Cen","","326156.378","6.230","-13.770","173.926416","-61.287870","A0Ib","A","1","","" }
{ "58832","59008","105078","4612","","","","","","","Hya","","758.503","6.230","-0.603","181.486128","-35.693926","B7V","B","1","","" }
{ "58869","59046","105138","4614","","","","","","","Mus","","326156.378","6.230","-13.770","181.583043","-68.651405","G3Ib","G","1","","" }
{ "59257","59439","105920","4637","","","","","","","Cen","","171.481","6.230","2.626","182.881477","-51.359333","G6III+...","G","1","","" }
{ "59834","60018","107054","4680","","","","","","","Com","","193.679","6.230","2.362","184.631722","30.249047","A9.5III","A","1","","" }
{ "60625","60813","108506","4746","","","","","","","Vir","","241.062","6.230","1.886","186.964785","-4.615277","F2III","F","1","","" }
{ "68260","68478","122405","5263","","11    Boo","","11","","","Boo","","296.776","6.230","1.435","210.293694","27.386594","A7III","A","1","","" }
{ "69236","69458","124281","5314","","","","","","","Hya","","530.335","6.230","0.174","213.305231","-26.612309","K0III","K","1","","" }
{ "69347","69569","124755","5335","","","","","","","Boo","","149.271","6.230","2.927","213.598133","41.518757","K3III:","K","1","","" }
{ "75684","75915","137919","","","","","","","","Lup","","411.294","6.230","0.726","232.588725","-41.919027","B9V","B","1","","" }
{ "75831","76063","138204","5751","","","","","","","Lup","","174.977","6.230","2.582","233.017477","-38.622543","A3III","A","1","","" }
{ "81573","81823","150097","","","","","","","","TrA","","1614.636","6.230","-2.243","250.701746","-62.553931","K3III","K","1","","" }
{ "109475","109821","210918","8477","Gl 851.2","","","","","","Gru","","71.920","6.230","4.513","333.660591","-41.381666","G5V","G","1","","" }
{ "111410","111761","214448","8612","","","","","","","Aqr","","389.208","6.230","0.846","339.592263","-7.897563","G1IV-V","G","1","","" }
{ "112402","112761","216206","8692","","","","","","","Lac","","1347.753","6.230","-1.851","342.542054","50.676917","G4Ib","G","1","","" }
{ "113314","113674","217531","8757","","81    Aqr","","81","","","Aqr","","494.926","6.230","0.324","345.348506","-7.061153","K5III","K","1","","" }
{ "116740","117107","222872","8999","","","","","","","Scl","","224.317","6.230","2.043","356.121111","-26.246631","F3/F5V","F","1","","" }
{ "117429","117797","223884","9043","","","","","","","Aqr","","287.362","6.230","1.505","358.336841","-24.229257","A5V","A","1","","" }
{ "4553","4563","5771","281","","","","","","","Tuc","","558.487","6.230","0.062","14.592512","-60.696239","Am","A","1","","" }
{ "5308","5319","6680","327","","78    Psc","","78","","","Psc","","134.998","6.230","3.145","17.005513","32.012130","F5IV","F","1","","" }
{ "5979","5992","7916","380","","","","","","","Tuc","","307.405","6.230","1.359","19.265467","-66.397854","A0V","A","1","","" }
{ "7422","7436","9766","455","","101    Psc","","101","","","Psc","","1553.126","6.230","-2.159","23.943511","14.661422","B9.5III","B","1","","" }
{ "12168","12200","16220","761","","","","","","","Tri","","162.671","6.230","2.741","39.277337","32.891092","F8V","F","1","","" }
{ "12684","12717","17326","823","","","","","","","Hor","","177.259","6.230","2.554","40.860511","-66.714252","F5V","F","1","","" }
{ "13428","13462","17818","849","","","","","","","Per","","1763.007","6.230","-2.434","43.337795","48.569955","G5Iab:","G","1","","" }
{ "20719","20771","28191","1400","","","","","","","Tau","","343.684","6.230","1.116","66.752910","2.079409","K1III","K","1","","" }
{ "25346","25410","35532","1798","","113    Tau","","113","","","Tau","","585.559","6.230","-0.041","81.523844","16.700161","B2Vn","B","1","","" }
{ "25804","25869","36430","1848","","","","","","","Ori","","2329.688","6.230","-3.039","82.837055","-6.708379","B2V","B","1","","" }
{ "26653","26718","37536","1939","","","","","","","Aur","","1941.407","6.230","-2.643","85.175210","31.920607","M2SIab","M","1","","" }
{ "26898","26964","37967","1961","","","","","","","Tau","","827.808","6.230","-0.793","85.831259","23.204372","B2.5Ve","B","1","","" }
{ "28573","28644","40832","2122","","","","","","","Aur","","155.091","6.230","2.844","90.729853","32.635697","F4V","F","1","","" }
{ "28789","28861","41269","2139","","","","","","","Aur","","699.906","6.230","-0.428","91.391248","33.599050","B9sp...","B","1","","" }
{ "31686","31766","47432","2442","","","","","","","Mon","","2174.376","6.230","-2.890","99.659115","1.613518","O9.5II","O","1","","" }
{ "33039","33126","50853","2578","","","","","","","CMa","","532.066","6.230","0.167","103.481055","-24.538756","A0V","A","1","","" }
{ "33364","33451","51825","2612","Gl 255A","","","","","","Pup","","140.584","6.230","3.057","104.323290","-35.507153","F5V","F","1","","Gl 255" }
{ "33503","33590","52362","2626","","","","","","","Pup","","392.015","6.230","0.831","104.673888","-45.767593","A0V","A","1","","" }
{ "34445","34536","54662","2694","","","","","","","Mon","","2064.281","6.230","-2.777","107.334376","-10.346565","O6","O","1","","" }
{ "34525","34617","54958","2705","","","","","","","CMa","","137.271","6.230","3.109","107.539015","-18.685637","F3V","F","1","","" }
{ "35639","35737","57708","2807","","","","","","","Mon","","526.059","6.230","0.192","110.577463","-2.979175","F5","F","1","","" }
{ "36238","36340","59059","2858","","","","","","","Gem","","732.936","6.230","-0.528","112.196890","15.109822","B9IV","B","1","","" }
{ "37298","37404","61630","2953","","","","","","","Gem","","1101.880","6.230","-1.414","115.196602","13.771251","K0","K","1","","" }
{ "38076","38184","63655","3042","","","","","","","Pup","","1136.434","6.230","-1.481","117.370031","-13.352948","B8/B9II","B","1","","" }
{ "38610","38723","64491","3083","","","","","","","Lyn","","192.423","6.230","2.376","118.920150","35.412684","A3p","A","1","","" }
{ "41775","41894","71952","3351","","","","","","","Lyn","","189.406","6.230","2.410","128.139352","53.114848","K0IV","K","1","","" }
{ "48447","48584","85905","3921","","","","","","","Hya","","497.949","6.230","0.311","148.632565","-22.487456","A2/A3III","A","1","","" }
{ "49253","49394","87652","","","","","","","","Vel","","571.202","6.230","0.013","151.257689","-51.313620","B8/B9III","B","1","","" }
{ "49517","49658","87822","3979","","","","","","","LMi","","199.728","6.230","2.295","152.066232","31.604053","F4V","F","1","","" }
{ "49759","49900","88372","4000","","","","","","","Sex","","492.683","6.230","0.334","152.824021","-7.316626","A2Vn","A","1","","" }
{ "49925","50066","88699","4011","","","","","","","Hya","","472.006","6.230","0.427","153.331041","-27.028891","A9m...","A","1","","" }
{ "28133","28205","39429","2041","","","","","","","Cam","","488.258","6.240","0.364","89.395740","66.096099","K0","K","1","","" }
{ "29767","29840","43384","2240","","9    Gem","","9","","","Gem","","326156.378","6.240","-13.760","94.244606","23.740909","B3Ia","B","1","","" }
{ "29909","29982","43821","2259","","","","","","","Ori","","322.289","6.240","1.266","94.668140","9.047183","K0","K","1","","" }
{ "30375","30448","44783","2300","","","","","","","Mon","","1136.434","6.240","-1.471","96.009514","8.885014","B8Vn","B","1","","" }
{ "30493","30566","45383","2329","","","","","","","Col","","549.085","6.240","0.109","96.375022","-35.064153","K3III","K","1","","" }
{ "30742","30815","45506","2340","","","","","","","Gem","","224.780","6.240","2.048","97.116899","16.238386","G5","G","1","","" }
{ "32969","33056","49949","2532","","","","","","","Aur","","302.277","6.240","1.405","103.281574","44.839941","A8Vn","A","1","","" }
{ "33052","33139","51266","2594","","","","","","","Pup","","176.492","6.240","2.574","103.509488","-50.611600","K0/K1III","K","1","","" }
{ "35876","35975","58439","2831","","","","","","","CMa","","2329.688","6.240","-3.029","111.212010","-19.012279","A2Ib/II","A","1","","" }
{ "36423","36526","59669","2876","","","","","","","Mon","","1907.347","6.240","-2.595","112.713058","-5.226494","K0","K","1","","" }
{ "44003","44130","77087","3585","","","","","","","Pyx","","545.412","6.240","0.124","134.815938","-28.806017","G8III","G","1","","" }
{ "46114","46247","80953","3722","","","","","","","UMa","","1186.023","6.240","-1.563","141.434083","63.940939","K2III","K","1","","" }
{ "48137","48273","85217","3893","","4    Sex","","4","","","Sex","","145.671","6.240","2.990","147.625339","4.343650","F6V...","F","1","","" }
{ "49661","49802","88182","3988","","","","","","","Hya","","276.638","6.240","1.598","152.485362","-12.095305","A5m","A","1","","" }
{ "50758","50903","90170","4087","","","","","","","Vel","","237.723","6.240","1.927","155.919365","-41.953189","K0IV","K","1","","" }
{ "52240","52391","92770","4190","","","","","","","Hya","","829.914","6.240","-0.788","160.630721","-13.974514","K3/K4III:","K","1","","" }
{ "54548","54708","97451","","","","","","","","Car","","791.642","6.240","-0.686","168.014862","-58.423355","M4III","M","1","","" }
{ "54967","55130","98161","4372","","","","","","","Cen","","237.032","6.240","1.933","169.300082","-38.014367","A1V","A","1","","" }
{ "113324","113684","217673","8761","","","","","","","Cas","","991.357","6.240","-1.174","345.377986","57.105458","K2II","K","1","","" }
{ "114607","114969","219580","","","","","","","","Scl","","2452.304","6.240","-3.141","349.286475","-28.438273","M1/M2III","M","1","","" }
{ "115752","116118","221357","8932","","100    Aqr","","100","","","Aqr","","248.406","6.240","1.831","352.925171","-21.369457","F0V","F","1","","" }
{ "116458","116824","222451","8977","","","","","","","And","","142.426","6.240","3.039","355.169178","36.720768","F1V","F","1","","" }
{ "116546","116912","222618","8985","","","","","","","Cas","","931.875","6.240","-1.040","355.477329","57.259954","G8III","G","1","","" }
{ "84252","84510","154972","6373","","","","","","","Aps","","346.975","6.240","1.106","259.148688","-74.533008","A0V","A","1","","" }
{ "87384","87655","163151","6676","","","","","","","Oph","","271.797","6.240","1.636","268.559033","11.130558","F5Vn","F","1","","" }
{ "89405","89684","168270","6852","","","","","","","Her","","660.235","6.240","-0.291","274.532139","18.131691","B9V","B","1","","" }
{ "91784","92072","173047","","","","","","","","Tel","","1217.001","6.240","-1.619","281.483312","-50.872715","B8/B9II","B","1","","" }
{ "92098","92386","174240","7085","","","","","","","Aql","","585.559","6.240","-0.031","282.404969","0.836197","A1V","A","1","","" }
{ "92441","92731","175823","7153","","","","","","","Dra","","579.319","6.240","-0.007","283.442912","57.486557","K5III:","K","1","","" }
{ "96414","96721","185139","7461","","","","","","","Tel","","364.420","6.240","0.999","294.924097","-45.278550","Am","A","1","","" }
{ "96474","96781","185075","7459","","","","","","","Tel","","379.252","6.240","0.912","295.077865","-54.417790","K0III","K","1","","" }
{ "97485","97796","188001","7574","","9    Sge","","9","","","Sge","","326156.378","6.240","-13.760","298.090687","18.671875","O8e","O","1","","" }
{ "98557","98872","191174","7695","","","","","","","Dra","","258.240","6.240","1.747","301.185485","63.890207","A2II-III","A","1","","" }
{ "99127","99445","191814","7713","","","","","","","Sge","","487.528","6.240","0.367","302.764752","21.134579","K0","K","1","","" }
{ "99161","99479","191877","7716","","","","","","","Vul","","326156.378","6.240","-13.760","302.837572","21.874937","B1Ib","B","1","","" }
{ "99697","100018","193094","7760","","","","","","","Vul","","414.430","6.240","0.720","304.381379","29.147563","G9III","G","1","","" }
{ "100526","100852","194433","7808","","","","","","","Sgr","","121.746","6.240","3.380","306.720783","-37.402905","K1IV","K","1","","" }
{ "101827","102158","197249","7923","","","","","","","Del","","485.352","6.240","0.377","310.492353","17.521489","G8III","G","1","","" }
{ "102439","102770","198272","","","","","","","","Aqr","","991.357","6.240","-1.174","312.321824","-0.563337","M3","M","1","","" }
{ "103560","103892","200375","8056","","","","","","","Aqr","","230.989","6.240","1.989","315.762600","1.532061","F5V","F","1","","" }
{ "107802","108144","208177","8363","","","","","","","Aqr","","193.106","6.240","2.378","328.649644","-3.301272","F5IV","F","1","","" }
{ "108161","108506","208801","8382","","","","","","","Aqr","","120.309","6.240","3.406","329.729105","-4.373109","K2V","K","1","","" }
{ "56078","56245","100219","4440","","","","","","","Crt","","125.541","6.240","3.313","172.948151","-20.776472","F7V","F","1","","" }
{ "57414","57587","102574","4529","","","","","","","Crt","","140.403","6.240","3.070","177.097867","-10.313105","F7V","F","1","","" }
{ "58566","58741","104625","4598","","","","","","","Vir","","729.656","6.240","-0.508","180.715253","-7.683623","K5","K","1","","" }
{ "59603","59785","106572","4658","","","","","","","Cen","","401.670","6.240","0.788","183.877153","-41.913278","K0III","K","1","","" }
{ "60363","60549","107998","4718","","","","","","","Cen","","620.069","6.240","-0.155","186.186381","-41.384289","K2/K3III","K","1","","" }
{ "61127","61320","109345","4784","Gl 474","","","","","","CVn","","414.957","6.240","0.717","188.447556","33.384668","K0III","K","1","","" }
{ "63617","63820","113523","4938","","","","","","","Cen","","1190.352","6.240","-1.571","196.200993","-41.196322","M3/M4III","M","1","","" }
{ "68488","68707","122797","5275","","","","","","","Vir","","194.720","6.240","2.360","210.982319","4.900973","F4V","F","1","","" }
{ "71650","71876","129798","5492","","","","","","","Dra","","132.638","6.240","3.194","220.513339","61.261916","F2V","F","1","","" }
{ "77051","77287","140986","5866","","","","","","","Lib","","746.353","6.240","-0.558","236.689268","-6.120355","K0","K","1","","" }
{ "79985","80227","147550","6096","","","","","","","Oph","","426.906","6.240","0.655","245.662106","-2.079870","B9V","B","1","","" }
{ "274","274","225094","9097","","","","","","","Cas","","2489.743","6.240","-3.174","0.857146","63.640520","B3Ia","B","1","","" }
{ "714","716","417","19","","","","","","","Peg","","451.740","6.240","0.533","2.217208","25.462985","K0III","K","1","","" }
{ "1074","1076","895","40","","","","","","","And","","428.589","6.240","0.647","3.349683","26.987545","G0III","G","1","","" }
{ "2081","2086","2268","","","","","","","","Cet","","1575.635","6.240","-2.180","6.590631","-18.693632","M1III","M","1","","" }
{ "5399","5412","6473","312","","","","","","","Cep","","441.348","6.240","0.583","17.301145","80.011579","K0","K","1","","" }
{ "5667","5679","7229","356","","","","","","","Psc","","378.372","6.240","0.918","18.247800","30.064229","G1V...","G","1","","" }
{ "7566","7580","10009","466","","","","","","","Cet","","131.727","6.240","3.209","24.407095","-9.403782","F7V","F","1","","" }
{ "9605","9627","12594","609","","","","","","","Ari","","888.710","6.240","-0.937","30.927536","18.253238","K4III","K","1","","" }
{ "10197","10220","13372","634","","5    Tri","","5","","","Tri","","352.983","6.240","1.068","32.854247","31.526398","A1m","A","1","","" }
{ "11895","11925","16170","755","","","","","","","Hor","","189.516","6.240","2.419","38.477552","-51.093546","F6V","F","1","","" }
{ "14070","14104","18832","908","","","","","","","Cet","","390.139","6.240","0.851","45.467930","5.336151","K0","K","1","","" }
{ "14550","14586","19460","940","","54    Ari","","54","","","Ari","","765.625","6.240","-0.613","47.087949","18.795053","M0III","M","1","","" }
{ "19670","19720","26676","1307","","","","","","","Tau","","431.424","6.240","0.633","63.394042","10.212458","B8Vn","B","1","","" }
{ "21199","21251","28867","1442","","","","","","","Tau","","437.794","6.240","0.601","68.387703","18.016722","B9IVn","B","1","","" }
{ "21945","21998","30202","1518","","","","","","","Cae","","739.584","6.240","-0.538","70.934459","-41.064788","K3/K4III","K","1","","" }
{ "24072","24130","33555","1685","","","","","","","Ori","","152.624","6.240","2.889","77.741770","-2.254114","G8III","G","1","","" }
{ "25337","25401","35640","1806","","","","","","","Ori","","665.625","6.240","-0.309","81.509852","-5.518501","B9.5Vn","B","1","","" }
{ "26041","26106","36779","1873","","","","","","","Ori","","1012.908","6.240","-1.221","83.516212","-1.035726","B2.5V","B","1","","" }
{ "26169","26234","37016","1891","","","","","","","Ori","","1331.251","6.240","-1.814","83.842983","-4.424320","B2.5V","B","1","","" }
{ "27146","27212","38495","1986","","","","","","","Ori","","363.608","6.240","1.004","86.511951","-4.268484","K1III...","K","1","","" }
{ "137","137","224906","9086","","","","","","","And","","1221.559","6.250","-1.617","0.432702","42.367144","B9IIIp Mn","B","1","","" }
{ "238","238","225045","9095","","","","","","","Cet","","199.484","6.250","2.318","0.739518","-20.045882","F6/F7V","F","1","","" }
{ "399","399","225276","9109","","","","","","","Peg","","652.313","6.250","-0.255","1.233303","26.648764","K4IIIb","K","1","","" }
{ "1191","1193","1048","49","","","","","","","Peg","","459.375","6.250","0.506","3.732904","22.284225","A1p","A","1","","" }
{ "1768","1772","1796","86","","42    Psc","","42","","","Psc","","501.779","6.250","0.315","5.606177","13.482488","K3III","K","1","","" }
{ "4869","4879","6311","304","","","","","","","Tuc","","867.437","6.250","-0.874","15.678748","-65.456102","M2III","M","1","","" }
{ "6938","6952","9184","435","","","","","","","Phe","","1012.908","6.250","-1.211","22.377244","-46.756422","M3III","M","1","","" }
{ "8133","8148","10587","502","","","","","","","Cas","","630.863","6.250","-0.183","26.192339","57.089226","A2V","A","1","","" }
{ "8903","8922","11613","551","","","","","","","And","","294.365","6.250","1.473","28.724064","40.702034","K2","K","1","","" }
{ "10326","10350","13222","626","","","","","","","Cas","","474.755","6.250","0.435","33.337803","74.027721","G8III","G","1","","" }
{ "11252","11279","14818","696","","10    Per","","10","","","Per","","326156.378","6.250","-13.750","36.316787","56.609823","B2Ia","B","1","","" }
{ "13145","13178","17378","825","","","","","","","Per","","326156.378","6.250","-13.750","42.378069","57.084318","A5Ia","A","1","","" }
{ "14778","14814","19887","957","","","","","","","Eri","","539.994","6.250","0.155","47.819706","-16.024967","K2III","K","1","","" }
{ "15087","15125","20293","980","","","","","","","For","","651.011","6.250","-0.251","48.751129","-26.100459","A1V","A","1","","" }
{ "15166","15204","20210","976","","","","","","","Per","","198.755","6.250","2.326","49.007732","34.688513","A1m","A","1","","" }
{ "16636","16677","22243","1091","","","","","","","Eri","","448.017","6.250","0.561","53.656128","-9.868261","A2V","A","1","","" }
{ "17015","17056","21970","1080","","","","","","","Cas","","449.251","6.250","0.555","54.854550","75.739622","G9III-IV","G","1","","" }
{ "19352","19400","25948","1276","","","","","","","Cam","","144.958","6.250","3.011","62.342514","54.828862","F5V","F","1","","" }
{ "19686","19736","26703","1310","","","","","","","Tau","","324.211","6.250","1.263","63.457653","12.753701","K0","K","1","","" }
{ "20446","20498","27650","1371","","","","","","","Per","","578.292","6.250","0.006","65.899214","42.427909","A1sp...","A","1","","" }
{ "21056","21108","28503","1424","","","","","","","Per","","1203.529","6.250","-1.585","67.850411","40.010193","B8V","B","1","","" }
{ "21058","21110","28763","1438","","","","","","","Eri","","368.122","6.250","0.987","67.857713","-13.644222","A2/A3V","A","1","","" }
{ "22986","23041","31623","1591","","","","","","","Ori","","275.237","6.250","1.619","74.321629","-1.067258","F2","F","1","","" }
{ "26084","26149","36840","","","","","","","","Ori","","959.283","6.250","-1.093","83.622025","-0.012345","G5","G","1","","" }
{ "26915","26981","38385","1981","","","","","","","Col","","172.114","6.250","2.638","85.875739","-39.406908","F3V","F","1","","" }
{ "82441","82693","152569","6277","","","","","","","Oph","","249.928","6.250","1.828","253.544190","-1.612304","F0V","F","1","","" }
{ "84341","84599","156593","6430","","","","","","","Her","","1430.510","6.250","-1.960","259.399393","23.090627","K2","K","1","","" }
{ "84922","85181","157910","6491","","","","","","","Her","","751.512","6.250","-0.563","261.112995","36.951929","G5III+...","G","1","","" }
{ "86125","86391","160315","6575","","","","","","","Oph","","368.538","6.250","0.985","264.785437","2.028050","F4IV...","F","1","","" }
{ "87023","87293","164428","6717","","","","","","","Dra","","853.812","6.250","-0.840","267.542094","78.306539","K5","K","1","","" }
{ "91208","91491","172671","7017","","","","","","","Lyr","","886.294","6.250","-0.921","279.887642","40.935059","B9V","B","1","","" }
{ "93130","93423","176537","7182","","","","","","","Sgr","","2025.816","6.250","-2.716","285.407251","-22.695364","K3III","K","1","","" }
{ "93195","93488","176981","7208","","","","","","","Aql","","1217.001","6.250","-1.609","285.589861","8.373539","K2III","K","1","","" }
{ "94350","94645","179949","7291","","","","","","","Sgr","Gumala","89.850","6.250","4.050","288.888422","-24.179352","F8V","F","1","","" }
{ "94429","94724","179009","7274","","Tau Pav","Tau","","Tau","","Pav","","634.545","6.250","-0.195","289.119185","-69.190825","A6IV/V","A","1","","" }
{ "94636","94932","181470","7338","","","","","","","Lyr","","622.436","6.250","-0.153","289.754798","37.445346","A0III","A","1","","" }
{ "94864","95159","181558","7339","","","","","","","Sgr","","782.150","6.250","-0.649","290.404634","-19.234446","B5III","B","1","","" }
{ "95513","95812","183387","7404","","","","","","","Aql","","642.040","6.250","-0.221","292.325111","0.246080","K2","K","1","","" }
{ "96399","96706","185955","7487","","","","","","","Cyg","","412.334","6.250","0.741","294.893890","45.957439","K0III","K","1","","" }
{ "96594","96901","186427","7504","Gl 765.1B","","","","","","Cyg","","69.189","6.250","4.617","295.466738","50.517523","G5V","G","2","96588","Gl 765.1" }
{ "96832","97139","186547","7511","","48Psi Aql","Psi","48","Psi","","Aql","","1012.908","6.250","-1.211","296.142465","13.302783","B9III-IV","B","1","","" }
{ "97386","97697","187753","7562","","","","","","","Aql","","292.255","6.250","1.488","297.823881","9.629887","A1m","A","1","","" }
{ "99268","99585","191984","7717","","","","","","","Aql","","588.730","6.250","-0.032","303.146351","0.867054","A0","A","1","","" }
{ "101727","102057","196748","","","","","","","","Mic","","535.561","6.250","0.173","310.231757","-42.396689","G6III","G","1","","" }
{ "103570","103902","200245","8050","","","","","","","Mic","","953.674","6.250","-1.080","315.792443","-27.731594","K0III","K","1","","" }
{ "104115","104452","201352","8091","","27    Cap","","27","","","Cap","","168.295","6.250","2.687","317.387475","-20.556661","F2IV/V","F","1","","" }
{ "106253","106595","205539","8257","","","","","","","Peg","","231.975","6.250","1.990","323.829605","28.197607","F0IV","F","1","","" }
{ "107294","107637","207446","8336","","","","","","","Cyg","","580.349","6.250","-0.001","327.034990","36.580388","K5","K","1","","" }
{ "33497","33584","51693","2606","","","","","","","Mon","","222.784","6.250","2.078","104.662141","7.622300","A3V","A","1","","" }
{ "37529","37636","62141","2978","","","","","","","Gem","","320.389","6.250","1.289","115.842425","22.399472","K0III","K","1","","" }
{ "38510","38623","64106","3065","","25    Lyn","","25","","","Lyn","","805.324","6.250","-0.713","118.621952","47.385982","K2III:","K","1","","" }
{ "39419","39530","67536","3186","","","","","","","Car","","1199.104","6.250","-1.577","121.178899","-62.836347","B2.5Vn","B","1","","" }
{ "39563","39675","67159","3174","","","","","","","Mon","","1003.558","6.250","-1.191","121.614219","-9.244457","B9V","B","1","","" }
{ "39761","39874","67483","3184","","12    Cnc","","12","","","Cnc","","260.925","6.250","1.735","122.176856","13.640917","F3V","F","1","","" }
{ "41867","41986","72900","3390","","","","","","","Vel","","2233.948","6.250","-2.928","128.376146","-46.970661","K3III","K","1","","" }
{ "43452","43575","75716","3521","","53    Cnc","","53","","","Cnc","","886.294","6.250","-0.921","133.119125","28.259159","M3III","M","1","","" }
{ "43905","44031","76572","3563","","61    Cnc","","61","","","Cnc","","181.097","6.250","2.528","134.494421","30.233826","F6V","F","1","","" }
{ "44239","44367","77580","3602","","","","","","","Vel","","399.701","6.250","0.808","135.526656","-39.402164","K1IIICN...","K","1","","" }
{ "45282","45413","79900","3680","","","","","","","Vel","","1832.339","6.250","-2.498","138.810986","-45.555498","B8V","B","1","","" }
{ "46410","46543","82074","3762","","","","","","","Hya","","181.500","6.250","2.523","142.385067","-4.246636","G6IV","G","1","","" }
{ "46760","46893","82674","3805","","","","","","","Hya","","407.186","6.250","0.768","143.332941","-7.190204","K0","K","1","","" }
{ "47748","47884","83550","3843","","","","","","","Dra","","1035.417","6.250","-1.258","146.379021","78.134709","K2III","K","1","","" }
{ "49548","49689","88025","3986","","","","","","","Hya","","566.244","6.250","0.052","152.147604","-15.611939","A0V","A","1","","" }
{ "50723","50868","90071","4083","","","","","","","Ant","","180.796","6.250","2.531","155.804752","-30.162263","A9IV","A","1","","" }
{ "51583","51732","91767","4151","","","","","","","Car","","844.965","6.250","-0.817","158.552987","-60.987629","K2/K3III","K","1","","" }
{ "52165","52316","92588","4182","","33    Sex","","33","","","Sex","","120.087","6.250","3.420","160.350778","-1.741491","K1IV","K","1","","" }
{ "52369","52520","93344","4211","","","","","","","Car","","337.287","6.250","1.177","161.083651","-70.859721","A5IV/V","A","1","","" }
{ "113851","114212","218537","8808","","","","","","","Cep","","1336.707","6.250","-1.813","346.948921","63.633466","B3V","B","1","","" }
{ "114898","115261","220105","8884","","","","","","","And","","245.415","6.250","1.868","350.183752","44.116167","A5Vn","A","1","","" }
{ "115926","116292","221661","8941","","","","","","","And","","599.552","6.250","-0.072","353.429129","45.058100","G8II","G","1","","" }
{ "57632","57805","102942","4545","","","","","","","UMa","","213.593","6.250","2.169","177.789629","33.375013","Am","A","1","","" }
{ "60541","60729","108309","4734","","","","","","","Cen","","86.790","6.250","4.125","186.701405","-48.913191","G5IV-V","G","1","","" }
{ "62320","62516","111421","4866","","11    CVn","","11","","","CVn","","448.633","6.250","0.558","192.174258","48.466838","A6m","A","1","","" }
{ "62736","62933","112097","4900","","41    Vir","","41","","","Vir","","198.633","6.250","2.327","193.457132","12.418416","A7III","A","1","","" }
{ "62771","62972","112171","4904","","","","","","","CVn","","252.443","6.250","1.806","193.554565","33.534480","A7IV","A","1","","" }
{ "64014","64217","114376","4967","","15    CVn","","15","","","CVn","","1207.987","6.250","-1.593","197.425139","38.533885","B7III","B","1","","" }
{ "64232","64437","115337","5009","","","","","","","Cam","","678.080","6.250","-0.339","198.106048","80.471309","K0Ib","K","1","","" }
{ "68468","68687","122744","5274","","","","","","","Boo","","463.290","6.250","0.488","210.903193","7.546170","G9III","G","1","","" }
{ "69529","69751","125040","5346","","","","","","","Boo","","106.413","6.250","3.682","214.136868","20.121848","F8V","F","1","","" }
{ "70096","70319","126053","5384","Gl 547","","","","","","Vir","","56.070","6.250","5.073","215.813686","1.241569","G1V","G","1","","" }
{ "73953","74181","133792","5623","","","","","","","Cir","","591.935","6.250","-0.044","227.356371","-63.642930","A0p","A","1","","" }
{ "78365","78603","143238","5951","","","","","","","TrA","","321.653","6.250","1.280","240.718804","-62.541590","B9.5V","B","1","","" }
{ "78805","79045","145000","6009","","7Kap Her","Kap","7","Kap","","Her","Marsic B","2104.235","6.250","-2.798","242.020657","17.054382","K1III","K","1","","" }
{ "80642","80888","149084","6157","","","","","","","Her","","1019.239","6.250","-1.224","247.761601","35.225066","K5","K","1","","" }
{ "81383","81632","150259","6190","","","","","","","Oph","","449.251","6.250","0.555","250.143822","-20.408649","K0III","K","1","","" }
{ "81438","81687","150451","6201","","","","","","","Oph","","159.490","6.250","2.803","250.298100","-1.000312","A7III","A","1","","" }
{ "55144","55308","98672","4387","","","","","","","Mus","","523.525","6.260","0.232","169.902362","-75.142452","B9.5/A0V","B","1","","" }
{ "57150","57322","102150","4516","","","","","","","Cen","","391.544","6.260","0.863","176.302679","-49.069843","K1III","K","1","","" }
{ "58067","58242","103746","4570","","","","","","","Cen","","158.175","6.260","2.831","179.183125","-47.072379","F3IV-V","F","1","","" }
{ "59903","60087","107168","4685","","8    Com","","8","","","Com","","279.483","6.260","1.595","184.829972","23.034673","A8m","A","1","","" }
{ "61076","61270","109238","4778","","","","","","","Crv","","426.906","6.260","0.675","188.342710","-19.792549","F0IV/V","F","1","","" }
{ "61603","61796","110020","4814","","","","","","","Mus","","372.750","6.260","0.970","189.982842","-66.511138","B8V","B","1","","" }
{ "62459","62655","111519","4871","","","","","","","Cen","","611.926","6.260","-0.106","192.581247","-48.459543","A0V","A","1","","" }
{ "62624","62821","111790","4882","","","","","","","Cen","","1792.068","6.260","-2.440","193.102489","-53.829931","G8Ib/II","G","1","","" }
{ "64315","64520","114846","4990","","54    Vir","","54","","","Vir","","633.313","6.260","-0.181","198.361817","-18.826406","A0V","A","1","","" }
{ "64914","65119","115995","5031","","","","","","","Vir","","441.946","6.260","0.600","200.173204","2.942290","A3V","A","1","","" }
{ "70815","71040","127929","5437","","","","","","","Dra","","381.916","6.260","0.917","217.928500","60.225636","F0III","F","1","","" }
{ "75306","75535","137510","5740","","","","","","","Ser","","134.553","6.260","3.183","231.471967","19.480707","G0V","G","1","","" }
{ "75912","76143","138488","5765","","","","","","","Lib","","315.432","6.260","1.333","233.289654","-24.490433","A3/5V +A9/F2","A","1","","" }
{ "76161","76395","138923","5790","","","","","","","Lup","","347.344","6.260","1.123","234.047355","-33.092806","B8/B9V","B","1","","" }
{ "77759","77995","142763","5931","","","","","","","Ser","","1598.806","6.260","-2.192","238.916054","18.620745","B8III","B","1","","" }
{ "79223","79463","145788","6041","","","","","","","Oph","","536.441","6.260","0.180","243.235764","-4.220809","A1V","A","1","","" }
{ "29056","29129","42448","2187","","","","","","","Pup","","741.264","6.260","-0.523","92.144296","-44.356212","B8II","B","1","","" }
{ "30451","30524","45796","2360","","","","","","","Pic","","731.292","6.260","-0.493","96.232509","-63.828144","B6V","B","1","","" }
{ "30468","30541","44990","2310","","","","","","","Mon","","2695.507","6.260","-3.326","96.304170","7.085713","K1Iabv SB","K","1","","" }
{ "31025","31099","46431","2393","","","","","","","Col","","719.992","6.260","-0.460","97.895617","-36.940027","M2/M3III","M","1","","" }
{ "31081","31158","46136","","","","","20","","","Gem","","261.763","6.260","1.738","98.077268","17.784349","F6V...","F","1","","" }
{ "31623","31703","45947","2365","","","","","","","Cam","","117.280","6.260","3.481","99.479765","73.695636","F2","F","1","","" }
{ "32059","32144","48501","2481","","","","","","","CMa","","177.163","6.260","2.585","100.691861","-22.448590","F2V","F","1","","" }
{ "33378","33465","51330","2597","","","","","","","Gem","","3076.947","6.260","-3.613","104.356613","11.907554","F2Ib-II","F","1","","" }
{ "33501","33588","52603","2634","","","","","","","Car","","288.124","6.260","1.529","104.665718","-55.729122","K2III","K","1","","" }
{ "33579","33666","52273","2623","","","","","","","CMa","","1284.080","6.260","-1.716","104.913562","-21.602884","B2III","B","1","","" }
{ "36162","36264","59235","","","","","","","","Pup","","1144.408","6.260","-1.466","112.008034","-26.838974","K4III","K","1","","" }
{ "39825","39938","67370","3181","","","","","","","Lyn","","666.987","6.260","-0.293","122.346062","42.430609","K3III:","K","1","","" }
{ "40562","40677","69149","3246","","","","","","","Lyn","","842.781","6.260","-0.801","124.565821","54.143696","K5","K","1","","" }
{ "41891","42010","72505","3376","","","","","","","Cnc","","342.601","6.260","1.153","128.437690","13.257311","K0III","K","1","","" }
{ "42598","42717","74622","3471","","","","","","","Car","","325.181","6.260","1.267","130.586901","-55.774557","K2III","K","1","","" }
{ "43683","43807","76566","3562","","","","","","","Vel","","1207.987","6.260","-1.583","133.830023","-45.041670","B3IV","B","1","","" }
{ "46436","46569","82180","3767","","","","","","","Hya","","1342.207","6.260","-1.812","142.457809","-23.345342","K2/K3III","K","1","","" }
{ "46805","46938","82670","3804","","","","","","","Leo","","504.106","6.260","0.315","143.496431","23.453919","K7III","K","1","","" }
{ "47415","47550","83821","3853","","13    Leo","","13","","","Leo","","551.872","6.260","0.118","145.410357","25.912876","K2III:","K","1","","" }
{ "52384","52535","93372","4213","","","","","","","Car","","104.773","6.260","3.726","161.113193","-72.443498","F6V","F","1","","" }
{ "52527","52679","93502","4217","","","","","","","Car","","392.486","6.260","0.858","161.571215","-60.602872","A0IV","A","1","","" }
{ "53077","53231","94491","","","","","","","","Car","","1140.407","6.260","-1.458","163.338227","-58.893453","B5V","B","1","","" }
{ "2250","2256","2529","111","","","","","","","Phe","","408.717","6.260","0.770","7.179475","-50.532859","K0III","K","1","","" }
{ "2577","2583","2942","134","","","","","","","And","","516.888","6.260","0.260","8.204531","28.280241","G8II","G","1","","" }
{ "6269","6283","8120","387","","","","","","","Cet","","447.402","6.260","0.574","20.144050","-3.246990","K1III","K","1","","" }
{ "6581","6595","8681","411","","","","","","","Phe","","844.965","6.260","-0.807","21.174653","-44.528575","K1II","K","1","","" }
{ "11623","11651","15464","726","","","","","","","Tri","","390.139","6.260","0.871","37.569164","33.833707","K1III","K","1","","" }
{ "12414","12447","16647","783","","","","","","","Cet","","131.515","6.260","3.232","40.065387","6.111944","F3V:","F","1","","" }
{ "13100","13133","17138","815","","","","","","","Cas","","211.241","6.260","2.203","42.231280","69.634290","A3V","A","1","","" }
{ "17501","17543","24188","","","","","","","","Hyi","","467.273","6.260","0.479","56.348785","-71.658132","B8V","B","1","","" }
{ "17690","17732","23626","1164","","","","","","","Per","","156.580","6.260","2.853","56.954262","32.195415","G0","G","1","","" }
{ "23598","23653","33116","1667","","","","","","","Pic","","825.712","6.260","-0.757","76.252525","-54.407401","M2III","M","1","","" }
{ "23682","23737","33875","1700","","","","","","","Men","","440.157","6.260","0.609","76.538626","-73.037673","A0V","A","1","","" }
{ "24454","24512","34053","1711","","108    Tau","","108","","","Tau","","699.906","6.260","-0.398","78.865226","22.284858","A2V","A","1","","" }
{ "25240","25303","35860","1818","","The Pic","The","","The","","Pic","","512.824","6.260","0.277","81.192870","-52.316245","A0V","A","1","","" }
{ "26244","26309","37286","1915","","","","","","","Col","","172.205","6.260","2.647","84.042889","-28.708015","A2III/IV","A","1","","" }
{ "26345","26410","36496","1853","","","","","","","Cam","","253.621","6.260","1.806","84.316831","66.696692","A8Vn","A","1","","" }
{ "83068","83323","153261","6304","","","","","","","Ara","","1405.847","6.260","-1.913","255.447453","-58.958245","B2IVne","B","1","","" }
{ "83483","83740","154481","6354","","","","","","","Oph","","1072.883","6.260","-1.326","256.721772","-26.513022","B8/B9II","B","1","","" }
{ "85825","86088","158895","6525","","","","","","","Ara","","1436.812","6.260","-1.960","263.895832","-59.846115","B5II/III","B","1","","" }
{ "85983","86246","159633","6557","","","","","","","Sco","","2886.340","6.260","-3.475","264.362159","-38.066364","G2Ib","G","1","","" }
{ "87656","87928","163071","","","","","","","","Ara","","2938.346","6.260","-3.513","269.428069","-56.896252","B4III","B","1","","" }
{ "88142","88415","165358","6753","","","","","","","Her","","537.325","6.260","0.176","270.787026","48.464269","A2V","A","1","","" }
{ "91240","91523","172424","7010","","","","","","","Oph","","481.057","6.260","0.416","279.964988","7.358598","G8III","G","1","","" }
{ "91698","91985","173920","7071","","","","","","","Dra","","973.601","6.260","-1.115","281.230816","54.897184","G5III","G","1","","" }
{ "93845","94140","179933","7290","","55    Dra","","55","","","Dra","","304.819","6.260","1.407","287.440848","65.978513","A0V","A","1","","" }
{ "95654","95953","183986","7419","","","","","","","Cyg","","629.646","6.260","-0.168","292.695129","36.228503","B9.5III","B","1","","" }
{ "98821","99137","190422","7674","","","","","","","Tel","","76.419","6.260","4.411","301.896179","-55.016012","F8V","F","1","","" }
{ "100086","100412","193307","7766","GJ 9691","","","","","","Tel","","101.165","6.260","3.802","305.421462","-49.999416","G2IV-V","G","1","","" }
{ "102381","102712","198513","7978","","","","","","","Cyg","","726.406","6.260","-0.479","312.178086","51.910331","B8np","B","1","","" }
{ "103284","103616","199728","8033","","20    Cap","","20","","","Cap","","535.561","6.260","0.183","314.900573","-19.035283","Ap Si","A","1","","" }
{ "103361","103693","199642","","","","","","","","Ind","","756.743","6.260","-0.568","315.180908","-53.739070","K5/M0III","K","1","","" }
{ "108736","109082","209961","8427","","","","","","","Lac","","326156.378","6.260","-13.740","331.463412","48.231494","B2V SB","B","1","","" }
{ "110350","110696","212670","8543","","","","","","","Peg","","633.313","6.260","-0.181","336.419576","18.444316","K0","K","1","","" }
{ "110976","111325","214019","8598","","","","","","","Cep","","410.260","6.260","0.762","338.319928","70.373714","A0V","A","1","","" }
{ "115403","115768","220858","8912","","9    Psc","","9","","","Psc","","368.538","6.260","0.995","351.811634","1.122609","G7III","G","1","","" }
{ "115588","115953","221148","8924","","","","","","","Aqr","","154.284","6.260","2.886","352.383670","-4.532747","K3IIIvar","K","1","","" }
{ "116226","116592","222098","8960","","74    Peg","","74","","","Peg","","367.707","6.260","1.000","354.415580","16.825495","A1V","A","1","","" }
{ "116510","116876","222570","8981","","","","","","","Cas","","746.353","6.260","-0.538","355.361623","49.512413","A4V","A","1","","" }
{ "117708","118076","224350","9058","","","","","","","Scl","","967.823","6.260","-1.102","359.283977","-26.623446","K3III","K","1","","" }
{ "112000","112358","215510","8660","","45    Peg","","45","","","Peg","","369.792","6.270","0.997","341.367406","19.366561","G6III:","G","1","","" }
{ "113312","113673","217498","8756","","","","","","","Aqr","","393.909","6.270","0.860","345.346013","-22.790891","A2V","A","1","","" }
{ "3848","3858","4772","232","","","","","","","Cet","","763.832","6.270","-0.578","12.389294","-23.362144","A3IV","A","1","","" }
{ "4202","4212","5128","250","","","","","","","Cas","","288.379","6.270","1.537","13.448212","52.689293","A5m","A","1","","" }
{ "5934","5947","7238","357","","","","","","","Cep","","236.860","6.270","1.965","19.129209","79.910013","F5Vs","F","1","","" }
{ "6762","6776","8774","415","","","","","","","And","","133.071","6.270","3.217","21.776286","34.377552","F7IVsvar","F","1","","" }
{ "7175","7189","9544","447","","","","","","","Phe","","253.030","6.270","1.821","23.151567","-49.727713","F4V","F","1","","" }
{ "8144","8159","10697","508","","109    Psc","","109","","","Psc","","106.240","6.270","3.706","26.232610","20.083149","G5IV","G","1","","" }
{ "9787","9809","12872","614","","","","","","","Psc","","809.321","6.270","-0.703","31.551097","8.248114","M4","M","1","","" }
{ "12949","12982","17228","819","","","","","","","Per","","455.526","6.270","0.545","41.742977","35.983523","G8III","G","1","","" }
{ "19073","19121","25910","1272","","","","","","","Eri","","248.785","6.270","1.858","61.485445","-8.856105","A3V","A","1","","" }
{ "22386","22439","30743","1545","","","","","","","Eri","","110.262","6.270","3.625","72.426027","-13.769669","F3/F5V","F","1","","" }
{ "26006","26071","36499","1854","","","","","","","Aur","","448.017","6.270","0.581","83.409236","34.725570","A3IV","A","1","","" }
{ "26226","26291","36859","1878","","","","","","","Tau","","772.882","6.270","-0.603","83.981256","27.662347","K0","K","1","","" }
{ "56075","56242","100180","4437","GJ 3669A","88    Leo","","88","","","Leo","","76.080","6.270","4.431","172.937297","14.364505","G0V","G","1","","GJ 3669" }
{ "58699","58874","104904","4606","","","","","","","Cam","","237.205","6.270","1.962","181.118742","85.587132","F6V","F","1","","" }
{ "59584","59767","107192","4686","","","","","","","UMi","","153.125","6.270","2.912","183.836062","87.700115","F2V","F","1","","" }
{ "62226","62421","111199","4856","","","","","","","Vir","","228.401","6.270","2.044","191.889263","-6.301752","F7V","F","1","","" }
{ "65424","65630","116862","5063","","","","","","","Cen","","2609.251","6.270","-3.245","201.836076","-49.381291","B3IV","B","1","","" }
{ "68463","68682","122742","5273","Gl 538","","","","","","Boo","","55.393","6.270","5.120","210.884794","10.786779","G8V","G","1","","" }
{ "70971","71196","129245","5479","","","","","","","UMi","","449.871","6.270","0.572","218.410669","79.660427","K3III","K","1","","" }
{ "71898","72124","130084","5510","","","","","","","Boo","","809.321","6.270","-0.703","221.307113","32.788346","M1III","M","1","","" }
{ "72474","72702","131027","","","","","10","","","Lib","","729.656","6.270","-0.478","222.963776","-18.355325","K0II/III","K","1","","" }
{ "73674","73901","133550","5615","","","","","","","Lup","","939.932","6.270","-1.028","226.558068","-36.264599","K5III","K","1","","" }
{ "74241","74470","134468","5645","","","","","","","Cir","","326156.378","6.270","-13.730","228.254271","-61.743780","K4Ib","K","1","","" }
{ "74862","75091","135737","5684","","","","","","","TrA","","1000.480","6.270","-1.164","230.168982","-67.481526","B3V","B","1","","" }
{ "78599","78840","144426","5992","","","","","","","Ser","","433.719","6.270","0.651","241.408077","8.096248","A3m","A","1","","" }
{ "80674","80920","150010","6180","","","","","","","Dra","","469.290","6.270","0.480","247.867828","72.612338","K2III","K","1","","" }
{ "29160","29233","42486","2192","","","","","","","Lep","","476.141","6.270","0.448","92.446445","-26.701086","G8/K0III","G","1","","" }
{ "29946","30019","43819","2258","","","","","","","Ori","","849.366","6.270","-0.808","94.757677","17.325259","B9IIIsp...","B","1","","" }
{ "30347","30420","44891","2303","","","","","","","CMa","","1462.585","6.270","-1.988","95.942262","-15.071257","K2/K3III","K","1","","" }
{ "33307","33394","51682","2604","","","","","","","Pup","","632.086","6.270","-0.167","104.190426","-35.341334","K2III","K","1","","" }
{ "36622","36728","60559","2907","","","","","","","Pup","","767.427","6.270","-0.588","113.304838","-40.058522","B8IV (p Si)","B","1","","" }
{ "36894","37000","60853","2920","","","","","","","Mon","","739.584","6.270","-0.508","114.069568","-8.311302","K2","K","1","","" }
{ "39861","39974","68242","3205","","","","","","","Pup","","959.283","6.270","-1.073","122.448731","-42.640803","B+...","B","1","","" }
{ "45110","45242","79524","3668","","","","","","","Vel","","537.325","6.270","0.186","138.327780","-42.273290","K2III","K","1","","" }
{ "45913","46045","81347","","","","","","","","Vel","","2528.344","6.270","-3.177","140.855709","-48.286942","B5V","B","1","","" }
{ "46371","46504","81980","3758","","","","","","","Hya","","258.035","6.270","1.779","142.259582","-1.256913","F0Vn","F","1","","" }
{ "46604","46737","82858","3813","","","","","","","Car","","616.553","6.270","-0.113","142.887661","-66.719026","K1III","K","1","","" }
{ "48130","48266","84812","3885","","","","","","","UMa","","277.108","6.270","1.624","147.598469","65.593226","A9Vn","A","1","","" }
{ "48624","48763","86266","3931","","","","","","","Hya","","220.227","6.270","2.123","149.195198","-26.549672","A4V","A","1","","" }
{ "49277","49418","87606","3972","","","","","","","Ant","","457.442","6.270","0.535","151.313669","-36.384381","K1III","K","1","","" }
{ "52362","52513","92941","4197","","","","","","","Leo","","218.311","6.270","2.142","161.060630","19.758834","A5V","A","1","","" }
{ "52433","52584","93102","4201","","36    Sex","","36","","","Sex","","479.642","6.270","0.433","161.289402","2.487970","K4III","K","1","","" }
{ "54558","54718","97413","","","","","","","","Cen","","293.570","6.270","1.499","168.042562","-46.266761","A1V","A","1","","" }
{ "82695","82951","152909","6294","","","","","","","Oph","","579.319","6.270","0.023","254.266587","-19.539856","B7/8III","B","1","","" }
{ "82731","82987","153287","6305","","57    Her","","57","","","Her","","552.807","6.270","0.124","254.379356","25.352841","G5III:","G","1","","" }
{ "83053","83308","153882","6326","","","","","","","Her","","531.199","6.270","0.211","255.387713","14.949717","B9p CrEu","B","1","","" }
{ "84501","84759","156331","6423","","","","","","","Ara","","192.536","6.270","2.415","259.877138","-50.063762","F2III","F","1","","" }
{ "87984","88258","164358","6715","","6    Sgr","","6","","","Sgr","","2630.293","6.270","-3.263","270.346339","-17.156868","K2III","K","1","","" }
{ "89977","90256","169718","6904","","","","","","","Her","","383.262","6.270","0.920","276.243589","27.394783","A2Vn","A","1","","" }
{ "90410","90692","170547","6940","","","","","","","Sct","","458.085","6.270","0.532","277.559567","-5.724169","G8II-III","G","1","","" }
{ "91439","91723","169904","6912","","","","","","","Oct","","538.212","6.270","0.182","280.559874","-81.808114","B8V","B","1","","" }
{ "92384","92674","174866","7110","","","","","","","Sct","","324.857","6.270","1.279","283.257536","-9.575521","A7Vn","A","1","","" }
{ "92756","93049","175395","","","","","","","","CrA","","704.441","6.270","-0.402","284.309630","-43.917012","B9V","B","1","","" }
{ "94328","94623","180756","7311","","","","","","","Cyg","","438.972","6.270","0.625","288.829911","50.071127","G8III","G","1","","" }
{ "95103","95398","182490","7369","","2    Sge","","2","","","Sge","","365.646","6.270","1.022","291.091972","16.937722","A2III-IV","A","1","","" }
{ "96063","96365","184574","7433","","","","","","","Sgr","","335.207","6.270","1.211","293.889414","-12.253114","K0III","K","1","","" }
{ "96784","97091","186518","7508","","","","","","","Vul","","2470.882","6.270","-3.127","295.983225","27.135398","B7V + G1:III","B","1","","" }
{ "97181","97491","186756","7521","","","","","","","Tel","","929.220","6.270","-1.003","297.229511","-52.888109","K1III","K","1","","" }
{ "98040","98351","188981","7617","","","","","","","Sgr","","191.970","6.270","2.421","299.735076","-30.538384","K1III","K","1","","" }
{ "98346","98658","190713","7682","","65    Dra","","65","","","Dra","","360.394","6.270","1.053","300.584101","64.634419","G7III:","G","1","","" }
{ "99842","100165","192531","7732","","","","","","","Pav","","426.348","6.270","0.688","304.762522","-63.230744","K0III","K","1","","" }
{ "99976","100300","193002","7758","","","","","","","Tel","","921.346","6.270","-0.985","305.134629","-55.050882","M0/M1III","M","1","","" }
{ "103944","104281","201196","8088","","","","","","","Del","","481.767","6.270","0.423","316.890173","15.658657","K2IV","K","1","","" }
{ "104220","104557","201567","8096","","","","","","","Aqr","","337.986","6.270","1.193","317.695577","-9.354074","K0III","K","1","","" }
{ "104433","104771","202128","8116","","","","","","","Peg","","285.851","6.270","1.556","318.369942","15.982395","A7Vn","A","1","","" }
{ "106078","106420","205349","8248","","","","","","","Cyg","","1331.251","6.270","-1.784","323.324521","45.854014","K1Ibvar","K","1","","" }
{ "107391","107734","207563","8341","","","","","","","Peg","","1169.019","6.270","-1.502","327.361945","20.462446","B2V","B","1","","" }
{ "107613","107956","207932","8350","","","","","","","Peg","","896.034","6.270","-0.924","328.075761","21.273162","M8III","M","1","","" }
{ "82417","82669","152235","6261","","","","","","","Sco","","3106.251","6.280","-3.614","253.495224","-41.994327","B1Ia","B","1","","" }
{ "83077","83331","153727","6321","","29    Oph","","29","","","Oph","","579.319","6.280","0.033","255.463563","-18.885538","K1III","K","1","","" }
{ "83337","83594","154025","6331","","","","","","","Sco","","321.653","6.280","1.310","256.272396","-45.502127","A2V","A","1","","" }
{ "84391","84649","156462","6428","","","","","","","Oph","","823.627","6.280","-0.732","259.580300","-16.311877","M0/M1III","M","1","","" }
{ "84783","85042","157347","6465","","","","","","","Oph","","63.677","6.280","4.827","260.713702","-2.388176","G5IV","G","1","","" }
{ "86361","86628","160342","6576","","","","","","","Ara","","1203.529","6.280","-1.555","265.515078","-50.510703","M3III","M","1","","" }
{ "87594","87866","163641","6690","","","","","","","Oph","","633.313","6.280","-0.161","269.233233","6.487730","B9III","B","1","","" }
{ "87676","87948","163433","6683","","","","","","","Sco","","413.379","6.280","0.765","269.490802","-39.136523","A0IV/V","A","1","","" }
{ "87944","88217","164507","6722","","","","","","","Her","","145.346","6.280","3.035","270.238635","15.093550","G5IV","G","1","","" }
{ "89959","90238","169370","6892","","","","","","","Sct","","310.034","6.280","1.390","276.175532","-7.075936","K0","K","1","","" }
{ "90229","90510","169938","6914","","","","","","","Sgr","","262.184","6.280","1.754","277.025695","-26.757245","A3/A4V","A","1","","" }
{ "91526","91811","174205","7082","","","","","","","Dra","","626.020","6.280","-0.136","280.793111","70.792849","K2","K","1","","" }
{ "92309","92599","175132","7118","","","","","","","Lyr","","1606.682","6.280","-2.183","283.030210","41.383244","B9p Si","B","1","","" }
{ "92345","92635","174630","7103","","","","","","","Sgr","","370.632","6.280","1.002","283.117979","-26.650770","G8/K0III","G","1","","" }
{ "92977","93270","176541","7183","","","","","","","Vul","","704.441","6.280","-0.392","284.992125","22.814515","M4III","M","1","","" }
{ "93592","93887","177863","7241","","","","","","","Sgr","","606.239","6.280","-0.066","286.784691","-18.738171","B8V","B","1","","" }
{ "93977","94272","178840","7270","","","","","","","Sgr","","478.235","6.280","0.449","287.828388","-29.502293","B8/B9V","B","1","","" }
{ "96763","97070","186815","7526","","","","","","","Cyg","","253.621","6.280","1.826","295.914561","57.042713","K2III","K","1","","" }
{ "99573","99893","192934","7752","","","","","","","Cyg","","426.906","6.280","0.695","304.014290","38.898012","A1V","A","1","","" }
{ "99828","100151","192827","7745","","","","","","","Tel","","979.449","6.280","-1.108","304.733222","-47.710774","M1III","M","1","","" }
{ "101765","102096","196829","","","","","","","","Mic","","1144.408","6.280","-1.446","310.352732","-42.133780","M3II","M","1","","" }
{ "102230","102561","197954","7946","","","","","","","Aqr","","780.278","6.280","-0.614","311.764840","-2.486912","K2","K","1","","" }
{ "105337","105678","203133","8156","","","","","","","Pav","","1315.147","6.280","-1.748","321.069749","-69.733882","C5II","C","1","","" }
{ "106564","106907","205872","8268","","","","","","","PsA","","146.653","6.280","3.016","324.775449","-33.678856","G8IV","G","1","","" }
{ "107001","107344","206642","8299","","","","","","","Gru","","867.437","6.280","-0.844","326.122744","-38.552530","K1IIICN...","K","1","","" }
{ "107159","107502","207134","8325","","","","","","","Peg","","362.799","6.280","1.049","326.599744","25.563504","K3III:","K","1","","" }
{ "108439","108784","209240","8394","","","","","","","Aqr","","293.306","6.280","1.511","330.549380","-17.903474","K0III","K","1","","" }
{ "109096","109442","210419","8451","","","","","","","Aqr","","483.194","6.280","0.427","332.587950","-3.894086","A1Vnn","A","1","","" }
{ "56034","56201","100198","4438","","","","","","","Cen","","326156.378","6.280","-13.720","172.812704","-61.278463","A3Iae","A","1","","" }
{ "56874","57045","101604","4500","","","","","","","UMa","","872.076","6.280","-0.856","175.431274","55.172011","K5","K","1","","" }
{ "58399","58574","104307","4588","","","","","","","Crv","","574.219","6.280","0.052","180.175930","-21.837501","K2III","K","1","","" }
{ "61102","61295","109307","4780","","22    Com","","22","","","Com","","290.433","6.280","1.532","188.392585","24.282984","A4V","A","1","","" }
{ "66489","66700","119213","5153","","","","","","","UMa","","297.046","6.280","1.483","205.089203","57.207606","A4p SrCrEu","A","1","","" }
{ "68349","68567","122675","5271","","","","","","","CVn","","554.688","6.280","0.127","210.550757","45.753457","K2III","K","1","","" }
{ "68557","68776","122910","5283","","","","","","","Vir","","392.015","6.280","0.881","211.155946","2.297531","K0","K","1","","" }
{ "70294","70517","126597","5402","","","","","","","Boo","","562.339","6.280","0.097","216.371463","38.393053","K2III:","K","1","","" }
{ "72944","73171","131919","5565","","","","","","","Hya","","494.176","6.280","0.378","224.307125","-29.157678","B8/B9V","B","1","","" }
{ "74395","74623","135367","5669","","","","","","","Lib","","1199.104","6.280","-1.547","228.710820","-5.502555","K2","K","1","","" }
{ "75802","76033","138268","5756","","","","","","","Lib","","284.108","6.280","1.580","232.930874","-20.164922","A5V","A","1","","" }
{ "77674","77910","142500","5919","","40    Ser","","40","","","Ser","","257.221","6.280","1.796","238.667813","8.580337","A7Vn","A","1","","" }
{ "111244","111594","214085","8600","","Sig1Gru","Sig-1","","Sig","1","Gru","","222.784","6.280","2.108","339.122080","-40.582689","A3Vn","A","1","","" }
{ "111276","111627","214313","8609","","","","","","","Lac","","847.160","6.280","-0.793","339.202844","35.652419","K5","K","1","","" }
{ "111724","112078","214983","","","","","","","","Aqr","","688.094","6.280","-0.341","340.525108","-5.101968","M0","M","1","","" }
{ "112142","112501","215669","8668","","","","","","","PsA","","357.236","6.280","1.082","341.829872","-34.161722","K1III","K","1","","" }
{ "113000","113360","217019","8730","","","","","","","Psc","","372.750","6.280","0.990","344.386684","3.810241","K1III","K","1","","" }
{ "115043","115407","220318","8891","","65    Peg","","65","","","Peg","","571.202","6.280","0.063","350.668797","20.828716","B9.5V","B","1","","" }
{ "117810","118178","224481","9065","","1    Cet","","1","","","Cet","","622.436","6.280","-0.123","359.588427","-15.847484","K1IIICN...","K","1","","" }
{ "25","25","224750","9077","","","","","","","Phe","","265.384","6.280","1.728","0.079507","-44.290561","G3IV","G","1","","" }
{ "2264","2270","2507","110","","","","","","","And","","528.617","6.280","0.231","7.236094","36.899694","G5III","G","1","","" }
{ "3799","3807","4737","229","","","","","","","Phe","","422.482","6.280","0.718","12.236377","-46.697648","G8III","G","1","","" }
{ "4288","4298","5273","256","","","","","","","Cas","","676.673","6.280","-0.305","13.771710","48.678520","M2.5IIIa","M","1","","" }
{ "4922","4932","6269","300","","","","","","","Scl","","424.130","6.280","0.710","15.823768","-29.525848","G8IIICN...","G","1","","" }
{ "5165","5175","6476","","","","","76","","","Psc","","563.310","6.280","0.093","16.546667","32.181485","K0","K","1","","" }
{ "6498","6512","8375","396","","","","","","","And","","184.791","6.280","2.514","20.906030","34.245887","G8IV","G","1","","" }
{ "8753","8771","11335","538","","","","","","","Per","","422.482","6.280","0.718","28.211372","51.474836","A3V","A","1","","" }
{ "8911","8930","11624","552","","","","","","","And","","533.807","6.280","0.210","28.740230","37.128290","K0","K","1","","" }
{ "11774","11802","15889","742","","","","","","","For","","470.644","6.280","0.484","38.061473","-36.427307","K0III","K","1","","" }
{ "12957","12990","17240","820","","","","","","","Per","","165.059","6.280","2.759","41.764916","35.554680","A9V","A","1","","" }
{ "14571","14607","19525","942","","","","","","","Cet","","366.056","6.280","1.029","47.161631","8.471069","G9III","G","1","","" }
{ "20500","20552","28255","1405","GJ 9155A","","","","","","Dor","","90.348","6.280","4.068","66.051078","-57.071337","G4V+...","G","1","","GJ 9155" }
{ "20720","20772","27855","1382","","","","","","","Cam","","744.649","6.280","-0.513","66.753619","57.585290","A0III","A","1","","" }
{ "21030","21082","28595","","","","","84","","","Tau","","547.242","6.280","0.156","67.779957","15.105037","M3III","M","1","","" }
{ "21433","21486","29435","1476","","","","","","","Eri","","415.486","6.280","0.754","69.212218","-30.716779","Ap...","A","1","","" }
{ "22664","22717","31975","1606","","","","","","","Men","","105.826","6.280","3.724","73.273780","-72.407680","F8V","F","1","","" }
{ "26303","26368","37935","1960","","","","","","","Dor","","763.832","6.280","-0.568","84.229100","-66.560287","B9.5V","B","1","","" }
{ "27592","27661","39045","2018","","","","","","","Aur","","599.552","6.280","-0.042","87.857288","32.124694","M3III","M","1","","" }
{ "27949","28019","39927","2071","","","","","","","Ori","","332.813","6.280","1.236","88.897369","-4.788587","A2III","A","1","","" }
{ "28759","28831","40055","2078","","","","","","","Cam","","785.919","6.280","-0.630","91.288861","75.585919","K5","K","1","","" }
{ "29231","29304","42834","2211","","","","","","","Pup","","756.743","6.280","-0.548","92.666367","-45.281988","A0V","A","1","","" }
{ "29331","29404","42083","2172","","","","","","","Aur","","335.897","6.280","1.216","92.941302","52.647186","A5m","A","1","","" }
{ "30900","30973","46730","2408","","","","","","","Dor","","315.737","6.280","1.351","97.512541","-65.568242","F0III","F","1","","" }
{ "31935","32020","47863","2457","","","","","","","Gem","","900.984","6.280","-0.926","100.341423","16.397650","A1V","A","1","","" }
{ "32006","32091","48543","2482","","","","","","","Pup","","270.445","6.280","1.687","100.568262","-38.398791","A+...","A","1","","" }
{ "32176","32261","47979","2463","","","","","","","Lyn","","255.408","6.280","1.811","101.047904","53.295939","K0","K","1","","" }
{ "33210","33297","50931","2584","","","","","","","Mon","","278.766","6.280","1.621","103.894232","8.324285","A0V","A","1","","" }
{ "33673","33760","52619","2637","","","","","","","CMa","","224.008","6.280","2.096","105.177141","-28.489574","F3/F5V","F","1","","" }
{ "36690","36796","60275","2893","","","","","","","CMi","","441.946","6.280","0.620","113.520683","10.568076","A1V","A","1","","" }
{ "38679","38792","65183","3099","","","","","","","Pup","","1113.162","6.280","-1.386","119.094677","-30.284570","M5/M6III","M","1","","" }
{ "39127","39238","66607","3161","","","","","","","Car","","657.573","6.280","-0.243","120.381563","-55.454655","B4V","B","1","","" }
{ "39309","39420","66812","3166","","","","","","","Pup","","809.321","6.280","-0.693","120.873372","-42.948327","G8II","G","1","","" }
{ "40502","40617","69478","3252","","","","","","","Cnc","","879.128","6.280","-0.873","124.381882","8.866310","G8III","G","1","","" }
{ "40991","41107","70946","3296","","","","","","","Pup","","1090.824","6.280","-1.342","125.820559","-38.286079","M2III","M","1","","" }
{ "41091","41208","67934","3197","","","","","","","Cam","","607.367","6.280","-0.070","126.137897","82.430759","A2Vn","A","1","","" }
{ "41951","42070","72993","3399","","","","","","","Vel","","1331.251","6.280","-1.774","128.621900","-37.611169","M0III","M","1","","" }
{ "43687","43811","76221","3541","","","","","","","Cnc","","1116.974","6.280","-1.393","133.845337","17.231276","C6II","C","1","","" }
{ "45611","45742","80781","3717","","","","","","","Vel","","326156.378","6.280","-13.720","139.885335","-55.186471","B5V","B","1","","" }
{ "48331","48468","85725","3916","","","","","","","Ant","","175.636","6.280","2.624","148.241867","-27.332172","G1V","G","1","","" }
{ "49824","49967","88522","4003","","","","","","","Ant","","497.949","6.280","0.361","153.011892","-28.605956","A0V","A","1","","" }
{ "54106","54264","96407","4318","","","","","","","Cen","","406.172","6.280","0.804","166.523920","-51.212920","G6IV","G","1","","" }
{ "29989","30062","44225","","","","","","","","CMa","","921.346","6.290","-0.965","94.909049","-22.103119","K3III","K","1","","" }
{ "33632","33719","52265","2622","","","","","","","Mon","Citala","94.456","6.290","3.981","105.075152","-5.367162","G0III-IV","G","1","","" }
{ "35205","35301","56614","2765","","","","","","","Mon","","985.367","6.290","-1.111","109.381928","-6.679997","K2","K","1","","" }
{ "36750","36856","61031","2925","","","","","","","Car","","1489.299","6.290","-2.008","113.664924","-51.474517","A1III/IV","A","1","","" }
{ "42437","42556","73731","3429","","41Eps Cnc","Eps","41","Eps","","Cnc","Meleph","586.612","6.290","0.015","130.112553","19.544808","Am","A","1","","" }
{ "43075","43195","75466","3503","","","","","","","Vel","","462.633","6.290","0.531","132.000953","-52.850151","B8V","B","1","","" }
{ "48501","48638","85583","3911","","","","","","","UMa","","390.607","6.290","0.898","148.763969","61.116123","K0","K","1","","" }
{ "51686","51835","92209","4170","","","","","","","Cha","","463.290","6.290","0.528","158.853303","-76.308986","K2III","K","1","","" }
{ "51736","51885","91881","4157","","","","","","","Hya","","134.553","6.290","3.213","159.018782","-26.675479","F5V","F","1","","" }
{ "51765","51914","91752","4150","","35    LMi","","35","","","LMi","","156.430","6.290","2.886","159.089234","36.326927","F3V","F","1","","" }
{ "52557","52709","93453","","","","","","","","Vel","","236.174","6.290","1.991","161.654758","-43.192673","A4IV","A","1","","" }
{ "52643","52797","93662","4226","","","","","","","Car","","2508.895","6.290","-3.140","161.910010","-57.467411","M1II","M","1","","" }
{ "52946","53100","94275","","","","","","","","Car","","555.633","6.290","0.133","162.945418","-57.272315","A6III","A","1","","" }
{ "110400","110746","212643","8542","","","","","","","Aqr","","393.434","6.290","0.883","336.544596","-23.682447","A0V","A","1","","" }
{ "111200","111550","214240","8606","","","","","","","Lac","","1698.731","6.290","-2.293","338.972418","50.070788","B3V","B","1","","" }
{ "111905","112259","215121","8646","","","","","","","Tuc","","476.141","6.290","0.468","341.068654","-60.499618","F3V","F","1","","" }
{ "114808","115171","219962","8875","","","","","","","And","","374.892","6.290","0.988","349.922895","48.380935","K1III","K","1","","" }
{ "117406","117774","223855","9042","","25    Psc","","25","","","Psc","","411.814","6.290","0.784","358.269821","2.090625","A1V","A","1","","" }
{ "82602","82855","152636","6282","","","","","","","Sco","","805.324","6.290","-0.673","253.990627","-33.506873","K5III","K","1","","" }
{ "82627","82880","154099","6335","","","","","","","Dra","","294.099","6.290","1.515","254.069737","73.127867","F0V","F","1","","" }
{ "83310","83567","154204","6340","","","","","","","Oph","","472.006","6.290","0.487","256.188859","-20.494703","B7IV/V","B","1","","" }
{ "83427","83684","154418","6350","","","","","","","Oph","","348.458","6.290","1.146","256.549175","-21.564583","A1m...","A","1","","" }
{ "89345","89623","167833","6843","","","","","","","Ser","","432.568","6.290","0.677","274.350671","-9.758578","A8V","A","1","","" }
{ "89399","89677","168199","6851","","","","","","","Oph","","1531.251","6.290","-2.068","274.512260","13.777038","B5V","B","1","","" }
{ "92191","92480","174309","7088","","30    Sgr","","30","","","Sgr","","230.174","6.290","2.047","282.710381","-22.162190","F2IV","F","1","","" }
{ "92781","93074","175529","7136","","","","","","","CrA","","195.420","6.290","2.402","284.393309","-39.823195","A5IV/V","A","1","","" }
{ "93565","93860","177365","","","","","","","","Tel","","565.262","6.290","0.096","286.728388","-50.323144","B9V","B","1","","" }
{ "94686","94981","181655","7345","Gl 754.2","","","","","","Lyr","","82.802","6.290","4.267","289.912529","37.330539","G8V","G","1","","" }
{ "95633","95932","183028","7393","","Mu  Tel","Mu","","Mu","","Tel","","112.120","6.290","3.609","292.644145","-55.110053","F5V","F","1","","" }
{ "96726","97033","186760","7522","Gl 765.3","","","","","","Cyg","","144.189","6.290","3.062","295.809801","58.016617","G0V","G","1","","" }
{ "100198","100524","193896","7788","","","","","","","Cap","","521.850","6.290","0.269","305.753295","-9.654710","G5II-III","G","1","","" }
{ "101763","102094","196947","7910","","","","","","","Cap","","565.262","6.290","0.096","310.351089","-25.999911","K2III","K","1","","" }
{ "102311","102642","198387","7972","","","","","","","Cyg","","138.672","6.290","3.147","311.970563","52.407167","K0V:","K","1","","" }
{ "105003","105344","203206","8158","","","","","","","Vul","","760.271","6.290","-0.548","320.058637","22.026186","B6IV","B","1","","" }
{ "109239","109585","210905","8476","","","","","","","Cep","","384.618","6.290","0.932","332.986743","59.084579","K0III","K","1","","" }
{ "55916","56083","99859","4424","","","","","","","UMa","","219.191","6.290","2.153","172.431696","56.737573","A4m","A","1","","" }
{ "56615","56784","101151","4482","","","","","","","UMa","","809.321","6.290","-0.683","174.634684","33.625829","K2III","K","1","","" }
{ "56639","56809","101177","4486","Gl 433.2A","","","","","","UMa","","75.833","6.290","4.458","174.687688","45.108416","G0V","G","1","","Gl 433.2" }
{ "59614","59796","106677","4665","","","","","","","Dra","","481.057","6.290","0.446","183.922929","72.551196","K0III +K0III","K","1","","" }
{ "60415","60601","108054","4720","","","","","","","Mus","","158.098","6.290","2.862","186.323271","-65.769853","G8/K0IV","G","1","","" }
{ "61053","61246","109217","4777","","20    Vir","","20","","","Vir","","472.690","6.290","0.484","188.261998","10.295671","G8III","G","1","","" }
{ "62328","62523","111395","4864","Gl 486.1","","","","","","Com","","55.224","6.290","5.146","192.196118","24.840226","G7V","G","1","","" }
{ "62628","62825","111893","4886","","","","","","","Com","","360.793","6.290","1.071","193.114575","16.122495","A7V","A","1","","" }
{ "66435","66645","118781","5135","","","","","","","Cen","","1000.480","6.290","-1.144","204.920190","-39.747587","M3/M4III","M","1","","" }
{ "73237","73464","132879","5592","","","","","","","Boo","","785.919","6.290","-0.620","225.217821","22.045589","K0","K","1","","" }
{ "73536","73764","133220","5604","","","","","","","Lup","","603.993","6.290","-0.048","226.178745","-40.861330","M6III","M","1","","" }
{ "74045","74273","134060","5632","","","","","","","Cir","","78.934","6.290","4.371","227.686923","-61.422320","G3IV","G","1","","" }
{ "75001","75230","136831","5717","","7    Ser","","7","","","Ser","","448.633","6.290","0.598","230.596829","12.567521","A0V","A","1","","" }
{ "77546","77782","142244","5909","","","","","","","Ser","","623.626","6.290","-0.117","238.233821","17.403150","K0","K","1","","" }
{ "77822","78058","142542","5923","","","","","","","Lup","","169.080","6.290","2.717","239.058437","-31.785882","F3/F5V","F","1","","" }
{ "79703","79945","146834","6076","","","","","","","Sco","","469.966","6.290","0.497","244.782171","-20.218072","K0III","K","1","","" }
{ "82168","82419","152262","6264","","","","","","","Her","","373.177","6.290","0.998","252.650452","41.896500","K3III:","K","1","","" }
{ "6074","6087","7758","376","","","","","","","And","","2159.976","6.290","-2.815","19.542276","47.419706","K0","K","1","","" }
{ "9805","9827","12923","616","","","","","","","Cet","","601.764","6.290","-0.040","31.622117","0.035384","K0","K","1","","" }
{ "11147","11174","14662","690","","","","","","","Per","","3048.190","6.290","-3.563","35.965606","55.364861","F7Ib","F","1","","" }
{ "12273","12305","16350","769","","","","","","","And","","676.673","6.290","-0.295","39.616464","38.089141","B9.5V","B","1","","" }
{ "13734","13768","18466","884","","","","","","","For","","488.990","6.290","0.411","44.303762","-29.855289","A2/A3V:+...","A","1","","" }
{ "14935","14972","20144","970","","","","","","","For","","469.966","6.290","0.497","48.256206","-35.943688","B9IV/V","B","1","","" }
{ "16055","16095","21379","1039","","","","","","","Tau","","285.851","6.290","1.576","51.827823","12.735289","A0Vs","A","1","","" }
{ "16383","16424","21620","1056","","","","","","","Per","","486.800","6.290","0.420","52.872267","49.209770","A0Vn","A","1","","" }
{ "16786","16827","23474","1154","","","","","","","Men","","751.512","6.290","-0.523","54.125731","-78.323073","K2III","K","1","","" }
{ "16933","16974","22316","1094","","","","","","","Cam","","512.824","6.290","0.307","54.582168","56.932713","B9p","B","1","","" }
{ "17422","17464","23697","1168","","","","","","","Ret","","248.595","6.290","1.880","56.141165","-54.274027","K1III","K","1","","" }
{ "19364","19412","25877","1270","","","","","","","Cam","","1393.831","6.290","-1.864","62.364890","59.908071","G8II","G","1","","" }
{ "23197","23251","33519","1682","","","","","","","Men","","893.579","6.290","-0.899","75.055322","-78.300009","K5/M0III","K","1","","" }
{ "25742","25806","36160","1831","","","","","","","Tau","","357.236","6.290","1.092","82.680606","22.462255","K0","K","1","","" }
{ "27257","27325","38885","2009","","","","","","","Col","","530.335","6.290","0.234","86.827864","-35.674075","K1III","K","1","","" }
{ "27556","27625","38765","2003","","","","","","","Aur","","286.102","6.290","1.575","87.734636","51.514583","K1III","K","1","","" }
{ "4510","4520","5612","276","","","","","","","Psc","","484.631","6.300","0.440","14.477133","13.695865","G8III","G","1","","" }
{ "9542","9562","12596","","","","","","","","For","","838.448","6.300","-0.750","30.715574","-23.886628","K2III","K","1","","" }
{ "11017","11043","14832","698","","","","","","","Phe","","446.178","6.300","0.620","35.548907","-43.199811","K0III","K","1","","" }
{ "12657","12690","16780","792","","","","","","","Per","","1304.626","6.300","-1.710","40.757730","48.265245","G5","G","1","","" }
{ "13414","13448","17918","856","","","","","","","Ari","","349.578","6.300","1.149","43.298723","16.483460","F5III","F","1","","" }
{ "14319","14355","19210","","","","","","","","Eri","","458.085","6.300","0.562","46.297068","-8.274247","K0","K","1","","" }
{ "15153","15191","20193","975","","","","","","","Per","","178.716","6.300","2.606","48.946430","32.856712","F4Vwvar","F","1","","" }
{ "15192","15230","20356","","","","","","","","Eri","","1496.130","6.300","-2.008","49.090516","-5.730464","K5","K","1","","" }
{ "17991","18033","24155","1194","","","","","","","Tau","","401.670","6.300","0.848","57.816122","13.046078","B9p Si","B","1","","" }
{ "22554","22607","30869","","","","","","","","Ori","","132.800","6.300","3.251","72.958277","13.655155","F5","F","1","","" }
{ "23500","23555","32820","1651","","","","","","","Cae","","103.542","6.300","3.792","75.974785","-41.744950","F8V","F","1","","" }
{ "25227","25290","35238","1775","","","","","","","Aur","","626.020","6.300","-0.116","81.160111","31.223912","K1III...","K","1","","" }
{ "25423","25486","35850","1817","","","","","","","Lep","","88.198","6.300","4.140","81.769845","-11.900964","F7V:","F","1","","" }
{ "27251","27319","38358","1979","","","","","","","Aur","","587.669","6.300","0.021","86.811183","42.526748","K0","K","1","","" }
{ "82531","82783","152424","","","","","","","","Sco","","2329.688","6.300","-2.969","253.763875","-42.090831","O9Ia","O","1","","" }
{ "82615","82868","152478","6274","","","","","","","Ara","","644.578","6.300","-0.179","254.036850","-50.674790","B3Vnpe","B","1","","" }
{ "83764","84021","155711","6395","","","","","","","Dra","","395.821","6.300","0.880","257.627653",