//-----------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------
#ifndef( MA_Milkyway_Temp )
	#declare MA_Milkyway_Temp = version;
	#version 3.7;
	//Here we're still inside an If-Block !! (the first #ifndef)
//-----------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------


/* ****************************************************************************************************************************
--------------------------------------------------------
MA_Milkyway
--------------------------------------------------------
Purpose:			Display the Milkyway as Pigment inside the Sky-Sphere
Author:			Martin Seydler
Website:			www.maetes.com
Documentation:	www.maetes.com/en/povray-os/ma_milkyway
				www.maetes.com/de/povray-os/ma_milkyway
Date:			October 2025
Version:			1.0 (October 2025)
Status:			Experimential
Copyright:		See above (author)
License:			With my code you can do whatever you like. A mention and a link to my website would be nice.


Source of the map
------------------------------------------
https://svs.gsfc.nasa.gov/4851/

Credit
------------------------------------------
NASA/Goddard Space Flight Center Scientific Visualization Studio.
Gaia DR2: ESA/Gaia/DPAC. Constellation figures based on those developed for the IAU
by Alan MacRobert of Sky and Telescope magazine (Roger Sinnott and Rick Fienberg).



*/// **************************************************************************************************************************


#ifndef(MW_Maps_Path)			#declare MW_Maps_Path = "maps/";				#end //Folder of the maps, relative to the including POV file, with trailing backslash /
#ifndef(MW_Maps_Flip)			#declare MW_Maps_Flip				= <-1,1,1>;	#end		//Northern Hemisphere
//#ifndef(MW_Maps_Flip)			#declare MW_Maps_Flip				= <1,-1,1>;	#end		//Southern? Not sure.
#ifndef(MW_Rotate_Clockwise)		#declare MW_Rotate_Clockwise		= 0;			#end		//0 = as seen from earth (deg)


//Map brightness (float). 0 = original, 0.5 = darker, 1 = invisible (or all black), -1.5 = lighter than original
#ifndef(MW_Transmit_Milkyway)	#declare MW_Transmit_Milkyway	=  0.0;	#end
#ifndef(MW_Transmit_Figures)		#declare MW_Transmit_Figures		= +0.2;	#end
#ifndef(MW_Transmit_Bounds)		#declare MW_Transmit_Bounds		= +0.2;	#end
#ifndef(MW_Transmit_Grid)		#declare MW_Transmit_Grid		= +0.2;	#end


#ifndef(MW_MapNamePre_Milkyway)	#declare MW_MapNamePre_Milkyway	= "milkyway_mwstars0070";	#end		//MilkyWay and brightest stars
//#ifndef(MW_MapNamePre_Milkyway)#declare MW_MapNamePre_Milkyway	= "milkyway_mw0266";			#end		//MilkyWay without bright stars
#ifndef(MW_MapNamePre_Figures)	#declare MW_MapNamePre_Figures	= "milkyway_figures";		#end
#ifndef(MW_MapNamePre_Bounds)	#declare MW_MapNamePre_Bounds	= "milkyway_bounds";			#end
#ifndef(MW_MapNamePre_Grid)		#declare MW_MapNamePre_Grid		= "milkyway_grid";			#end

#ifndef(MW_Show_Milkyway)		#declare MW_Show_Milkyway		= 1;							#end
#ifndef(MW_Show_Figures)			#declare MW_Show_Figures			= 0;							#end
#ifndef(MW_Show_Bounds)			#declare MW_Show_Bounds			= 0;							#end
#ifndef(MW_Show_Grid)			#declare MW_Show_Grid			= 0;							#end


/* ****************************************************************************************************************************
MW_Milkyway_Pigment

Returns a multilayer-pigment with maps of real stars

Example:
	sky_sphere {
		MW_Milkyway_Pigment (180, 0, 4)
	}
	
Params:
	mMoveRight		Moves the map to the right or if negative to the left (Degrees)
	mMoveUp			Moves the map up or if negative down (Degrees)
	mResolution		4, 8, 16, 32 (int) - loads maps with different resolution. For development 4 or 8, for highres-pics 16 or higher
Return:
	Pigment
*/// **************************************************************************************************************************


#macro MW_Milkyway_Pigment (mMoveRight, mMoveUp, mResolution)

	#local mTransform = transform {
		scale MW_Maps_Flip
		rotate z*-MW_Rotate_Clockwise
		rotate y*+mMoveRight
		rotate x*-mMoveUp
	}

	#if (MW_Show_Milkyway = 1)
		pigment {
			image_map { jpeg concat (MW_Maps_Path, MW_MapNamePre_Milkyway, "_", str(mResolution,-2,0), "k.jpg") map_type 1 transmit all MW_Transmit_Milkyway }
			transform mTransform
		}
	#end

	#if (MW_Show_Figures = 1)
		pigment {
			image_map { png concat (MW_Maps_Path, MW_MapNamePre_Figures, "_", str(mResolution,-2,0), "k.png") map_type 1 transmit all MW_Transmit_Figures }
			transform mTransform
		}
	#end
	#if (MW_Show_Bounds = 1)
		pigment {
			image_map { png concat (MW_Maps_Path, MW_MapNamePre_Bounds, "_", str(mResolution,-2,0), "k.png") map_type 1  transmit all MW_Transmit_Bounds }
			transform mTransform
		}
	#end
	#if (MW_Show_Grid = 1)
		pigment {
			image_map { png concat (MW_Maps_Path, MW_MapNamePre_Grid, "_", str(mResolution,-2,0), "k.png") map_type 1  transmit all MW_Transmit_Grid }
			transform mTransform
		}
	#end

#end






//Old Test, maybe I need it somewhen
//https://www.f-lohmueller.de/pov_tut/tex/tex_893d.htm
/*
#macro MWM_Grid_Pigment (mScale, mLine, mDir)
	pigment {
		gradient x
		scale mScale
		color_map {
			[0.000   color rgbt<1,1,1,0.8>]
			[0+mLine color rgbt<1,1,1,0.8>]
			[0+mLine color rgbt<0,0,0,1>]
			[1-mLine color rgbt<0,0,0,1>]
			[1-mLine color rgbt<1,1,1,0.8>]
			[1.000   color rgbt<1,1,1,0.8>]
		}
		//scale 1/(pi*2)
		//scale 0.1
		//rotate <0,-1/32,0>
		//translate <-1/32,0,0>
		#if (mDir = "h")
			rotate <0,0,90>
		#end
	}
#end
*/



//-----------------------------------------------------------------------------------------------------------------------------
//This is the end of the very first If (that checks if this file was included before)
//Never delete it, or else ...
	#version MA_Milkyway_Temp;
#end
//-----------------------------------------------------------------------------------------------------------------------------
