/* ****************************************************************************************************************************
--------------------------------------------------------
MA_Milkyway - Simple Example
--------------------------------------------------------
Author:		Martin Seydler
Website:		www.maetes.com/en/povray-os/ma_milkyway


Helpful Command-Lines:
------------------------------------------
povray +Ima_milkyway_example_simple.pov +Oma_milkyway_test_00.png +w1920 +h1080 +GD +GF -GR +GS +GW +Q9 +A


*/// **************************************************************************************************************************

#version 3.7;

light_source { <10,10,-10>*100 color <1,1,1> }
camera	{ perspective right x*image_width/image_height sky <0,1,0>
	location	<0,0,-1>
	look_at	<0,0,0>
	angle	70
}

#local mMoveRight	= -15;
#local mMoveUp		= -8;

sky_sphere {
	pigment { 		//jpeg
		image_map { jpeg "maps/milkyway_mwstars0070_16k.jpg" map_type 1 }
	}
	pigment { 		//png because alpha-channel
		image_map { png "maps/milkyway_figures_08k.png" map_type 1 transmit all 0.3}
	}
	scale <-1,1,1>	//We have to flip the maps horizontally
	rotate < -mMoveUp, mMoveRight, 0 >
}




