/* ****************************************************************************************************************************

--------------------------------------------------------
MA_Milkyway - Examples
--------------------------------------------------------
Author:		Martin Seydler
Website:		www.maetes.com/en/povray-os/ma_milkyway




Helpful Command-Lines:
------------------------------------------
povray +Ima_milkyway_examples.pov +Otest/ma_milkyway_00.png +w1920 +h1080 +GD +GF -GR +GS +GW +Q9 +A
povray +Ima_milkyway_examples.pov +Otest/ma_milkyway_00.png +w2560 +h1440 +GD +GF -GR +GS +GW +Q9 +A



*/// **************************************************************************************************************************


#version 3.7;


//Set some defaults
global_settings		{ assumed_gamma 1.0 }
#default {
	finish { ambient 0.005 diffuse 0.99 }	//Org
}



//-----------------------------------------------------------------------------------------------------
//Try to include ma_helpers.
//-----------------------------------------------------------------------------------------------------
#local mH = array[2] {"ma_helpers.inc", "../../prog/ma_helpers/ma_helpers.inc" }
#for (mI, 0, dimension_size(mH,1) - 1) #if (file_exists(mH[mI])) #include mH[mI] #end #end #ifndef (MA_Helpers_Temp) #error "Cant find 'ma_helpers.inc'"; #end


/*
//#declare BasePathAstro = "../packages-ma/astro/";
//#declare BasePathSpace = "../packages-ma/space/";
#declare BasePathAstro = "../";
#declare BasePathSpace = "../../space/";
#include concat(BasePathAstro, "ma_skyfakes/ma_skyfakes.inc")
#include concat(BasePathAstro, "ma_skyfakes/ma_skyfakes_textures.inc")
*/

#include "ma_milkyway.inc"



#declare CamLocation		= <0,0,-20>;
#declare CamLookAt		= <0,0,0>;
#declare CamAngle		= 30;

#declare LigVector			= <10,3,-10>*1000;
#declare LigVector			= <10,0,0>*1000;
#declare LigIntensity		= 1;

MA_SetClock(0.5)				//For sill-images, without running clock


//-----------------------------------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------------------------------




//-----------------------------------------------------------------------------------------------------
//Choose one example. The star-background will be generated all the time, so it doesnt look too boring
//Only the last "x" gets generated (easier to switch from one to the other)
//-----------------------------------------------------------------------------------------------------

#local xExample	= "test";
#local Example	= "0-0";

#local Example	= "taurus-max";
#local xExample	= "cygnus-lyra";
#local xExample	= "summertriangle";
#local Example	= "cassiopeia";
#local Example	= "andromeda";
#local Example	= "crux";
#local Example	= "magellan";

#local Example	= "widefield";
#local Example	= "lines-widefield";

#local Example	= "new";



#if (0)	
//-----------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------
#elseif (xExample = "test")

	sky_sphere { MW_Milkyway_Pigment(-25, -21, 16)	}
	#declare CamAngle = 30;
	
	
//-----------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------
#elseif (xExample = "0-0")

	sky_sphere { MW_Milkyway_Pigment(0, 0, 16) }
	#declare CamAngle = 90;


//-----------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------
#elseif (xExample = "taurus-max")

	sky_sphere { MW_Milkyway_Pigment(-25, -21, 32) }		 //Taurus
	#declare CamAngle = 20;

//-----------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------
#elseif (xExample = "cygnus-lyra")

	//#declare MW_Show_Figures	= 1;
	#declare MW_Transmit_Figures = +0.4;
	sky_sphere { MW_Milkyway_Pigment(-151, -40, 16) }
	#declare CamAngle = 46;

//-----------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------
#elseif (xExample = "summertriangle")

	#declare MW_Show_Figures	= 1;
	#declare MW_Show_Bounds	= 1;
	//#declare MW_Show_Grid	= 1;
	#declare MW_Transmit_Milkyway	= -2.7;
	#declare MW_Transmit_Figures		= +0.2;
	#declare MW_Transmit_Bounds		= -0.3;
	//#declare MW_Transmit_Grid		= +0.2;
	sky_sphere { MW_Milkyway_Pigment(-155, -28, 8) }
	#declare CamAngle = 80;

//-----------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------
#elseif (xExample = "andromeda") //sehr unspektakulär

	#declare MW_Show_Figures	= 0;
	#declare MW_Transmit_Figures = +0.2;
	sky_sphere { MW_Milkyway_Pigment(280, -40, 16) }
	#declare CamAngle = 50;

//-----------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------
#elseif (xExample = "cassiopeia")

	#declare MW_Show_Figures	= 0;
	#declare MW_Transmit_Figures = +0.2;
	#declare MW_Transmit_Milkyway = -0.4;
	sky_sphere { MW_Milkyway_Pigment(280, -60, 32) }
	#declare CamAngle = 30;

//-----------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------
#elseif (xExample = "crux")

	//#declare MW_Show_Figures	= 1;
	//#declare MW_Show_Bounds	= 1;
	#declare MW_Transmit_Figures		= +0.2;
	#declare MW_Transmit_Bounds		= -0.2;
	//#declare MW_Show_Grid	= 1;
	sky_sphere { MW_Milkyway_Pigment(98, 61, 32) }
	#declare CamAngle = 20;

//-----------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------
#elseif (xExample = "magellan")

	#declare MW_Show_Figures	= 0;
	#declare MW_Transmit_Figures = +0.2;
	//#declare MW_Transmit_Milkyway = -0.7;
	#declare MW_Transmit_Milkyway = -2.7;
	sky_sphere { MW_Milkyway_Pigment(330,74, 16) }
	#declare CamAngle = 50;


//-----------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------
#elseif (xExample = "widefield")

	sky_sphere { MW_Milkyway_Pigment(-0, -0, 8) }
	#declare CamAngle = 90;

//-----------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------
#elseif (xExample = "lines-widefield")

	//#declare MW_Rotate_Clockwise	= 60;
	#declare MW_Show_Figures	= 1;
	#declare MW_Show_Bounds	= 1;
	//#declare MW_Show_Grid	= 1;
	#declare MW_Transmit_Figures		= +0.2;
	#declare MW_Transmit_Bounds		= -0.2;
	sky_sphere { MW_Milkyway_Pigment(-270, 70, 8) }		//Crux
	#declare CamAngle = 90;


//-----------------------------------------------------------------------------------------------------------------------
// 
//-----------------------------------------------------------------------------------------------------------------------
#elseif (xExample = "new")

	#declare MW_Transmit_Milkyway	=  0.0;
	#declare MW_Transmit_Figures		= +0.5;
	#declare MW_Transmit_Bounds		= +0.5;
	#declare MW_Transmit_Grid		= +0.5;

	#declare MW_Show_Milkyway		= 1;
	#declare MW_Show_Figures			= 0;
	#declare MW_Show_Bounds			= 0;
	#declare MW_Show_Grid			= 0;



	#local mPlanet = object {
		//SF_Minshara1("","","atmo-type: simple-1;rings-type: saturn-1")
		SF_Minshara1("","","atmo-type: simple-1")

		scale 3
		translate <-5,0,0>
	}
	//object { mPlanet }


//-----------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------
#else
	//Warning, no existing example choosen
	//DoNothingLoop()
	
#end




MA_CameraAndLight_Set()

		


