/*
--------------------------------------------------------
Povray-Tutorial - Terrestrial Planets
--------------------------------------------------------
Author:			Martin Seydler
Website:			www.maetes.com
Documentation:	www.maetes.com/en/povray/tutorial-terrestrial-planets-part-1
				www.maetes.com/en/povray/tutorial-terrestrial-planets-part-2
Date:			October 2025


CMD-Lines
-------------------
povray +Ima_tutorial_planet_step1.pov +Otest/step1.png +w1600 +h1200 -GR +A


*/

#version 3.7;
global_settings { assumed_gamma 1.0 charset utf8 }


#local oPlanet = sphere {
	<0,0,0> 1
	texture {
		pigment {
			//color rgb (<1,1,1>*.5) //for tests only
			image_map {
				jpeg "map_moon_4k_surface.jpg"
				map_type 1		//1 = spherical
			}
		}
		finish { ambient rgb (<2,1,1> * 0.01) }
	}
}


object {
	oPlanet
	rotate y*-90
}
light_source {
	<0,0,100000>
	color <1,1,1>
	rotate y*130
}
camera	{ perspective right x*image_width/image_height sky <0,1,0>
	location		<0,0,-20>
	look_at		<0,0,0>
	angle		10
	//look_at		<-.5,-.4,-.5> angle 2 //Zoom Mare Humorum

}




