/*
--------------------------------------------------------
Povray-Tutorial - Terrestrial Planets
--------------------------------------------------------
Author:			Martin Seydler
Website:			www.maetes.com
Documentation:	www.maetes.com/en/povray/tutorial-terrestrial-planets-part-1
				www.maetes.com/en/povray/tutorial-terrestrial-planets-part-2
Date:			October 2025


CMD-Lines
-------------------
povray +Ima_tutorial_planet_step3.pov +Otest/step3.png +w1600 +h1200 -GR +A
povray +Ima_tutorial_planet_step3.pov +Otest/step3_zoom.png +w1600 +h1200 -GR +A


*/

#version 3.7;
global_settings { assumed_gamma 1.0 charset utf8 }


#local nRadius		= 1;
#local nFactor		= 0.35;
#local nHeightDiff	= 50;  // the more the higher the contrast between valleys and hills

#local PlanetSphere_F		= function {internal(61)}
#local PlanetHeightfield_F	= function {
	pigment {
		image_map {
			png "map_moon_4k_dem.png"
			map_type 1
			interpolate 2
		}
	}
}
#local oPlanet = isosurface {
	function {
		PlanetSphere_F(x,y,z, nRadius)
		- PlanetHeightfield_F(x,y,z).gray*nHeightDiff/1000*nRadius
		+ nFactor*nRadius
	}
	contained_by { sphere{0, nRadius} }
	max_gradient 1.3
	accuracy 0.0001
	texture {
		pigment {
			color rgb (<1,1,1>*.5) //Instead the surface-map
		}
	}
	finish { ambient rgb (<2,1,1> * 0.004) }
	scale 1/(1-nFactor)
}


object {
	oPlanet
	rotate y*-90
}
light_source {
	<0,0,100000>
	color <1,1,1>
	rotate y*130
}
camera	{ perspective right x*image_width/image_height sky <0,1,0>
	location		<0,0,-20>
	look_at		<0,0,0>
	angle		10
	//look_at		<-.507,-.408,-.5> angle 2 //Zoom Mare Humorum
}




