/*
--------------------------------------------------------
Povray-Tutorial - Terrestrial Planets
--------------------------------------------------------
Author:			Martin Seydler
Website:			www.maetes.com
Documentation:	www.maetes.com/en/povray/tutorial-terrestrial-planets-part-1
				www.maetes.com/en/povray/tutorial-terrestrial-planets-part-2
Date:			October 2025


CMD-Lines
-------------------
povray +Ima_tutorial_planet_step5.pov +Otest/step5_moon.png +w1600 +h1200 -GR +A
povray +Ima_tutorial_planet_step5.pov +Otest/step5_mars.png +w1600 +h1200 -GR +A
povray +Ima_tutorial_planet_step5.pov +Otest/step5_moon_zoom.png +w1600 +h1200 -GR +A
povray +Ima_tutorial_planet_step5.pov +Otest/step5_mars_zoom.png +w1600 +h1200 -GR +A
povray +Ima_tutorial_planet_step5.pov +Otest/step5_moon_left.png +w1600 +h1200 -GR +A
povray +Ima_tutorial_planet_step5.pov +Otest/step5_moon_right.png +w1600 +h1200 -GR +A


composite -stereo 0 test/step5_moon_right.png test/step5_moon_left.png test/step5_moon_stereo.png
composite -stereo 0 test/step5_moon_right_sharp.png test/step5_moon_left_sharp.png test/step5_moon_stereo_sharp.png
https://imagemagick.org/script/command-line-options.php#stereo


*/

#version 3.7;
global_settings { assumed_gamma 1.0 charset utf8 }

#if (1)
	//Moon
	#local nRadius		= 1000;
	#local nFactor		= 0.35;
	#local nHeightDiff	= 20;  // the more the higher the contrast between valleys and hills
	#local nMaxGradient	= 1.3;
	#local nAccuracy		= 0.1;
	#local sMapDEM		= "map_moon_4k_dem.png";
	#local sMapSurface	= "map_moon_4k_surface.jpg";
	#local yRotatePlanet	= -90;
	#local yRotateLight	= 130;
	#local cFinish		= <2,1,1>;
	#local nFinish		= 0.004;
#else
	//Mars
	#local nRadius		= 1000;
	#local nFactor		= 0.35;
	#local nHeightDiff	= 16;
	#local nMaxGradient	= 1.3;
	#local nAccuracy		= 0.1;
	#local sMapDEM		= "map_mars_2k_dem.png";
	#local sMapSurface	= "map_mars_2k_surface.jpg";
	#local yRotatePlanet	= 190;
	#local yRotateLight	= 130;
	#local cFinish		= <1,1,1>;
	#local nFinish		= 0.004;
#end

#local yCamRotate	= 0;
//#local yCamRotate	= +1;	//Stereo-Left
//#local yCamRotate	= -1;	//Stereo-Right


#local PlanetSphere_F		= function {internal(61)}
#local PlanetHeightfield_F	= function {
	pigment {
		image_map {
			png sMapDEM
			map_type 1
			interpolate 2
		}
	}
}
#local oPlanet = isosurface {
	function {
		PlanetSphere_F(x,y,z, nRadius)
		- PlanetHeightfield_F(x,y,z).gray*nHeightDiff/1000*nRadius
		+ nFactor*nRadius
	}
	contained_by {
		sphere{0, nRadius}
	}
	max_gradient nMaxGradient
	accuracy nAccuracy
	texture {
		pigment {
			image_map {
				jpeg sMapSurface
				map_type 1
			}
		}
	}
	finish { ambient rgb (cFinish * nFinish) }
	scale 1/(1-nFactor)
}

object {
	oPlanet
	rotate y*yRotatePlanet
}
light_source {
	<0,0,100000>
	color <1,1,1>
	rotate y*yRotateLight
}
camera	{ perspective right x*image_width/image_height sky <0,1,0>
	location		<0,0,-20000>
	look_at		<0,0,0>
	angle		10
	//look_at		<-510,-410,-500> angle 2.0 //Zoom Mare Humorum (lower-left corner)
	rotate 		y*yCamRotate
}

